/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.budget;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.commons.CFinancialYear;
import org.egov.egf.model.BudgetAmountView;
import org.egov.egf.web.actions.budget.BudgetSearchAction;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.script.service.ScriptService;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.workflow.entity.OwnerGroup;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.infra.workflow.entity.WorkflowAction;
import org.egov.infra.workflow.service.SimpleWorkflowService;
import org.egov.infra.workflow.service.WorkflowService;
import org.egov.infstr.utils.EgovMasterDataCaching;
import org.egov.model.budget.Budget;
import org.egov.model.budget.BudgetDetail;
import org.egov.pims.commons.Position;
import org.egov.pims.model.PersonalInformation;
import org.egov.services.voucher.VoucherService;
import org.egov.utils.Constants;
import org.springframework.beans.factory.annotation.Autowired;

public class BudgetSearchAndModify
extends BudgetSearchAction {
    private static final String ACTIONNAME = "actionName";
    boolean enableApprovedAmount = false;
    boolean enableOriginalAmount = false;
    boolean consolidatedScreen = false;
    private String comments = "";
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(BudgetSearchAndModify.class);
    protected WorkflowService<Budget> budgetWorkflowService;
    private boolean showDetails = false;
    private boolean isDetailByFunction;
    private ScriptService scriptService;
    @Autowired
    private EgovMasterDataCaching masterDataCache;
    private String wfitemstate;
    private VoucherService voucherService;
    private Integer defaultDept;
    private Department department;

    public ScriptService getScriptService() {
        return this.scriptService;
    }

    public void setScriptService(ScriptService scriptService) {
        this.scriptService = scriptService;
    }

    public String modifyList() {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Starting modifyList...");
        }
        if (this.parameters.containsKey("mode") && "approve".equals(((String[])this.parameters.get("mode"))[0])) {
            this.setMode(((String[])this.parameters.get("mode"))[0]);
            this.isApproveAction = true;
            this.disableBudget = true;
            this.enableApprovedAmount = true;
        }
        if (this.getMode() != null && "approve".equals(this.getMode())) {
            this.budgetDetailApproveList();
        } else {
            this.budgetDetailList();
        }
        this.currentfinYearRange = this.topBudget.getFinancialYear().getFinYearRange();
        this.computePreviousYearRange();
        this.computeTwopreviousYearRange();
        this.computeNextYearRange();
        this.populateNextYrBEinBudgetDetailList();
        this.loadApproverUser(this.savedbudgetDetailList);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Completed modifyList...");
        }
        return "detailList";
    }

    public String modifyDetailList() {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"starting modifyDetailList...");
        }
        if (this.parameters.containsKey("mode") && "approve".equals(((String[])this.parameters.get("mode"))[0])) {
            this.setMode(((String[])this.parameters.get("mode"))[0]);
            this.isApproveAction = true;
            this.disableBudget = true;
        }
        if (this.getMode() != null && "approve".equals(this.getMode())) {
            this.budgetDetailApprove();
        } else {
            this.budgetDetailList();
        }
        this.setEnablingAmounts();
        this.currentfinYearRange = this.topBudget.getFinancialYear().getFinYearRange();
        this.computePreviousYearRange();
        this.computeTwopreviousYearRange();
        this.computeNextYearRange();
        this.isDetailByFunction = true;
        this.populateNextYrBEinBudgetDetailList();
        this.loadApproverUser(this.savedbudgetDetailList);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"completed modifyDetailList");
        }
        return "detailList";
    }

    public boolean isDetailByFunction() {
        return this.isDetailByFunction;
    }

    public void setDetailByFunction(boolean isDetailByFunction) {
        this.isDetailByFunction = isDetailByFunction;
    }

    public String budgetDetailApprove() {
        if (((String[])this.parameters.get("budgetDetail.id"))[0] != null) {
            this.budgetDetail = (BudgetDetail)this.persistenceService.find("from BudgetDetail where id=?", new Object[]{Long.valueOf(((String[])this.parameters.get("budgetDetail.id"))[0])});
            this.setTopBudget(this.budgetDetail.getBudget());
            this.comments = this.topBudget.getState().getExtraInfo();
        }
        String query = " from BudgetDetail bd where bd.budget=? and bd.function=" + this.budgetDetail.getFunction().getId() + "  order by bd.function.name,bd.budgetGroup.name";
        this.savedbudgetDetailList = this.budgetDetailService.findAllBy(query, new Object[]{this.topBudget});
        this.re = this.checkRe(this.topBudget);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"starting populateActualData...");
        }
        if ("BE".equalsIgnoreCase(this.topBudget.getIsbere())) {
            this.budgetDetailHelper.getPreviousYearFor(this.topBudget.getFinancialYear());
            this.populateActualData(this.topBudget.getFinancialYear());
        } else {
            this.populateActualData(this.topBudget.getFinancialYear());
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Completed populateActualData...");
        }
        this.computeActualAmounts(this.savedbudgetDetailList);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"finished loading detail List--------------------------------------------------------------");
        }
        return "detailList";
    }

    public void prepare() {
        super.prepare();
        if (this.parameters.containsKey("action") && "modify".equals(((String[])this.parameters.get("action"))[0]) && this.budgetDetail.getId() == null) {
            for (int i = 0; i < this.savedbudgetDetailList.size(); ++i) {
                this.savedbudgetDetailList.set(i, this.budgetDetailService.findById((Serializable)((BudgetDetail)this.savedbudgetDetailList.get(i)).getId(), false));
            }
        }
        if (this.isApproveMode()) {
            this.dropdownData.put("budgetList", this.budgetDetailService.findBudgetsForFY(this.getFinancialYear()));
        } else {
            this.dropdownData.put("budgetList", this.budgetDetailService.findBudgetsForFYWithNewState(this.getFinancialYear()));
        }
        this.addDropdownData("departmentList", this.masterDataCache.get("egi-department"));
        this.addDropdownData("designationList", Collections.EMPTY_LIST);
        this.addDropdownData("userList", Collections.EMPTY_LIST);
    }

    public String update() {
        BudgetDetail detail2;
        Budget budget = null;
        Budget b = null;
        if (this.parameters.get("budget.id") != null) {
            budget = (Budget)this.budgetService.find(" from Budget where id=?", new Object[]{Long.valueOf(((String[])this.parameters.get("budget.id"))[0])});
            this.setTopBudget(budget);
        }
        if ("forward".equalsIgnoreCase(((String[])this.parameters.get(ACTIONNAME))[0]) || ((String[])this.parameters.get(ACTIONNAME))[0].contains("approve")) {
            this.approve();
        } else {
            for (BudgetDetail detail2 : this.savedbudgetDetailList) {
                this.validateAmount(detail2);
                if (this.consolidatedScreen) {
                    detail2.setApprovedAmount(detail2.getApprovedAmount().multiply(BigDecimal.valueOf(1000L)));
                }
                this.budgetDetailService.persist(detail2);
                b = detail2.getBudget();
            }
            if (b != null && b.getId() != null && (b = (Budget)this.budgetService.find("from Budget where id=?", new Object[]{b.getId()})).getCurrentState() != null) {
                this.budgetService.persist((Object)b);
            }
            this.addActionMessage(this.getMessage("budgetdetail.updated"));
        }
        this.setBudgetDetail((BudgetDetail)this.session().get("searchCriteria"));
        Long count = (Long)this.persistenceService.find("select count(*) from Budget where materializedPath like ?", new Object[]{this.topBudget.getMaterializedPath() + ".%"});
        if (count == 0L && (detail2 = (BudgetDetail)this.persistenceService.find("from BudgetDetail where materializedPath like ?", new Object[]{this.topBudget.getMaterializedPath() + ".%"})) != null) {
            this.department = detail2.getExecutingDepartment();
        }
        this.showDetails = true;
        return this.setUpDataForList();
    }

    private void validateAmount(BudgetDetail detail) {
        this.setEnablingAmounts();
        if (this.consolidatedScreen && this.enableApprovedAmount && (detail.getApprovedAmount() == null || BigDecimal.ZERO.compareTo(detail.getApprovedAmount()) == 0)) {
            this.loadApproverUser(this.savedbudgetDetailList);
            throw new ValidationException(Arrays.asList(new ValidationError("approved.amount.mandatory", "approved.amount.mandatory")));
        }
        if (this.enableOriginalAmount && (detail.getOriginalAmount() == null || BigDecimal.ZERO.compareTo(detail.getOriginalAmount()) == 0)) {
            this.loadApproverUser(this.savedbudgetDetailList);
            throw new ValidationException(Arrays.asList(new ValidationError("original.amount.mandatory", "original.amount.mandatory")));
        }
    }

    public String setUpDataForList() {
        if (this.financialYear == null && this.getSession().get("financialyearid") != null) {
            this.financialYear = (Long)this.getSession().get("financialyearid");
        }
        this.dropdownData.put("budgetList", this.budgetDetailService.findBudgetsForFYWithNewState(this.financialYear == null ? this.getFinancialYear() : this.financialYear));
        return "list";
    }

    private boolean isApproveMode() {
        return this.parameters.containsKey("mode") && "approve".equals(((String[])this.parameters.get("mode"))[0]);
    }

    public void approve() {
        Budget beBudget;
        Integer userId = null;
        userId = ((String[])this.parameters.get(ACTIONNAME))[0] != null && ((String[])this.parameters.get(ACTIONNAME))[0].contains("reject") ? Integer.valueOf(((String[])this.parameters.get("approverUserId"))[0]) : (null != this.parameters.get("approverUserId") && Integer.valueOf(((String[])this.parameters.get("approverUserId"))[0]) != -1 ? Integer.valueOf(((String[])this.parameters.get("approverUserId"))[0]) : Integer.valueOf(ApplicationThreadLocals.getUserId().intValue()));
        Position positionByUserId = this.eisCommonService.getPositionByUserId(Long.valueOf(userId.longValue()));
        PersonalInformation empForCurrentUser = this.budgetDetailService.getEmpForCurrentUser();
        String name = "";
        if (empForCurrentUser != null) {
            name = empForCurrentUser.getName();
        }
        if (name == null) {
            name = empForCurrentUser.getEmployeeFirstName();
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("===============Processing " + this.savedbudgetDetailList.size() + "Budget line items"));
        }
        if (((String[])this.parameters.get(ACTIONNAME))[0].contains("approv")) {
            for (BudgetDetail detail : this.savedbudgetDetailList) {
                this.validateAmount(detail);
                if (this.consolidatedScreen) {
                    detail.setApprovedAmount(detail.getApprovedAmount().multiply(BigDecimal.valueOf(1000L)));
                }
                String comment = detail.getState() == null ? "" : detail.getState().getExtraInfo();
                detail.transition().progressWithStateCopy().withStateValue("END").withOwner((OwnerGroup)positionByUserId).withComments(comment);
                this.budgetDetailService.persist(detail);
                BudgetDetail detailBE = (BudgetDetail)this.persistenceService.find("from BudgetDetail where id=?", new Object[]{detail.getNextYrId()});
                if (this.consolidatedScreen) {
                    detailBE.setApprovedAmount(detail.getNextYrapprovedAmount().multiply(BigDecimal.valueOf(1000L)));
                } else {
                    detailBE.setApprovedAmount(detail.getNextYrapprovedAmount());
                }
                detailBE.transition().progressWithStateCopy().withStateValue("END").withOwner((OwnerGroup)this.getPosition()).withComments(comment);
                this.budgetDetailService.persist(detailBE);
            }
        } else {
            for (BudgetDetail detail : this.savedbudgetDetailList) {
                this.validateAmount(detail);
                if (this.consolidatedScreen) {
                    detail.setApprovedAmount(detail.getApprovedAmount().multiply(BigDecimal.valueOf(1000L)));
                }
                String comment = detail.getState() == null ? "" : detail.getState().getExtraInfo();
                detail.transition().progressWithStateCopy().withStateValue("Forwarded by " + name).withOwner((OwnerGroup)positionByUserId).withComments(comment);
                this.budgetDetailService.persist(detail);
                BudgetDetail detailBE = (BudgetDetail)this.persistenceService.find("from BudgetDetail where id=?", new Object[]{detail.getNextYrId()});
                if (this.consolidatedScreen) {
                    detailBE.setApprovedAmount(detail.getNextYrapprovedAmount().multiply(BigDecimal.valueOf(1000L)));
                } else {
                    detailBE.setApprovedAmount(detail.getNextYrapprovedAmount());
                }
                detailBE.transition().progressWithStateCopy().withStateValue("Forwarded by " + name).withOwner((OwnerGroup)positionByUserId).withComments(comment);
                this.budgetDetailService.persist(detailBE);
            }
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Processed Budget line items");
        }
        if (this.getTopBudget().getState().getOwnerPosition() != null && ((Position)this.getTopBudget().getState().getOwnerPosition()).getId() != positionByUserId.getId()) {
            this.getTopBudget().transition().progressWithStateCopy().withStateValue("Forwarded by " + name).withOwner((OwnerGroup)positionByUserId).withComments(this.comments);
        }
        if ((beBudget = (Budget)this.budgetService.find("from Budget where referenceBudget=?", new Object[]{this.getTopBudget()})).getState().getOwnerPosition() != null && ((Position)beBudget.getState().getOwnerPosition()).getId() != positionByUserId.getId()) {
            beBudget.transition().progressWithStateCopy().withStateValue("Forwarded by " + name).withOwner((OwnerGroup)positionByUserId).withComments(this.comments);
        }
        if (((String[])this.parameters.get(ACTIONNAME))[0].contains("approv")) {
            if (this.topBudget.getState().getValue().equals("END")) {
                this.addActionMessage(this.getMessage("budgetdetail.approved.end"));
            } else {
                this.addActionMessage(this.getMessage("budgetdetail.approved") + this.budgetService.getEmployeeNameAndDesignationForPosition(positionByUserId));
            }
        } else {
            this.addActionMessage(this.getMessage("budgetdetail.approved") + this.budgetService.getEmployeeNameAndDesignationForPosition(positionByUserId));
        }
        this.showButton = false;
    }

    public String ajaxDeleteBudgetDetail() {
        Long id = Long.valueOf(((String[])this.parameters.get("id"))[0]);
        BudgetDetail detail = (BudgetDetail)this.budgetDetailService.findById((Serializable)id, false);
        this.budgetDetailService.delete((Object)detail);
        BudgetDetail criteria = (BudgetDetail)this.getSession().get("searchCriteria");
        this.savedbudgetDetailList = this.budgetDetailService.searchBy(criteria);
        return "modifyList";
    }

    public String budgetDetailApproveList() {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Starting budgetDetailApproveList...");
        }
        this.isApproveAction = true;
        this.consolidatedScreen = this.budgetDetailService.toBeConsolidated();
        if (this.parameters.get("budget.id") != null && ((String[])this.parameters.get("budget.id"))[0] != null) {
            this.topBudget = (Budget)this.budgetService.findById((Serializable)Long.valueOf(((String[])this.parameters.get("budget.id"))[0]), false);
            this.comments = this.topBudget.getState().getExtraInfo();
        } else if (((String[])this.parameters.get("budgetDetail.budget.id"))[0] != null) {
            this.topBudget = (Budget)this.budgetService.findById((Serializable)Long.valueOf(((String[])this.parameters.get("budgetDetail.budget.id"))[0]), false);
        }
        this.comments = this.topBudget.getState().getExtraInfo();
        this.savedbudgetDetailList = this.getAllApprovedBudgetDetails(this.topBudget);
        if (this.savedbudgetDetailList.size() > 0) {
            this.budgetDetail = (BudgetDetail)this.savedbudgetDetailList.get(0);
        }
        this.re = this.checkRe(this.topBudget);
        this.populateActualData(this.topBudget.getFinancialYear());
        this.computeActualAmounts(this.savedbudgetDetailList);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Finished budgetDetailApproveList");
        }
        return "detailList";
    }

    private List<BudgetDetail> getAllApprovedBudgetDetails(Budget budget) {
        return this.budgetDetailService.findAllBy("from BudgetDetail where budget=? and (state.value='END' or state.owner=?) order by function.name,budgetGroup.name ", new Object[]{budget, this.getPosition()});
    }

    private void computeActualAmounts(List<BudgetDetail> budgetDetails) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Starting computeActualAmounts .... ");
        }
        this.budgetAmountView = new ArrayList();
        for (BudgetDetail detail : budgetDetails) {
            BigDecimal total;
            BigDecimal lastBEAmount;
            BigDecimal approvedReAppropriationsTotal;
            BigDecimal approvedAmt;
            BudgetAmountView view = new BudgetAmountView();
            view.setId(detail.getId());
            String previousYearAmount = (String)this.getPreviousYearBudgetDetailIdsAndAmount().get(detail.getUniqueNo());
            view.setPreviousYearActuals(previousYearAmount == null ? BigDecimal.ZERO.setScale(2) : new BigDecimal(previousYearAmount).setScale(2));
            String twopreviousYearAmount = (String)this.getTwopreviousYearBudgetDetailIdsAndAmount().get(detail.getUniqueNo());
            view.setTwopreviousYearActuals(twopreviousYearAmount == null ? BigDecimal.ZERO.setScale(2) : new BigDecimal(twopreviousYearAmount).setScale(2));
            String currentYearAmount = (String)this.getBudgetDetailIdsAndAmount().get(detail.getUniqueNo());
            view.setCurrentYearBeActuals(currentYearAmount == null ? BigDecimal.ZERO.setScale(2) : new BigDecimal(currentYearAmount).setScale(2));
            this.budgetAmountView.add(view);
            if (detail.getState() != null) {
                detail.setComment(detail.getState().getExtraInfo());
            }
            BigDecimal bigDecimal = approvedAmt = detail.getApprovedAmount() == null ? BigDecimal.ZERO : detail.getApprovedAmount().setScale(2);
            if (this.re) {
                view.setCurrentYearReApproved(approvedAmt.setScale(2).toString());
                approvedReAppropriationsTotal = detail.getApprovedReAppropriationsTotal();
                lastBEAmount = this.getLastBE(detail);
                total = approvedReAppropriationsTotal.add(lastBEAmount);
                view.setReappropriation(approvedReAppropriationsTotal.setScale(2).toString());
                view.setLastBEApproved(total.setScale(2).toString());
                view.setLastTotal(total.setScale(2).toString());
            } else {
                view.setCurrentYearBeApproved(approvedAmt.setScale(2).toString());
                approvedReAppropriationsTotal = detail.getApprovedReAppropriationsTotal();
                lastBEAmount = this.getLastBE(detail);
                total = approvedReAppropriationsTotal.add(lastBEAmount);
                view.setReappropriation(approvedReAppropriationsTotal.toString());
                view.setLastBEApproved(lastBEAmount.toString());
                view.setLastTotal(total.setScale(2).toString());
            }
            detail.setAnticipatoryAmount(detail.getAnticipatoryAmount() == null ? BigDecimal.ZERO : detail.getAnticipatoryAmount().setScale(2));
            detail.getOriginalAmount().setScale(2);
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Done computeActualAmounts ");
        }
    }

    private BigDecimal getLastBE(BudgetDetail detail) {
        Date startingDate;
        Date lastyear;
        CFinancialYear lastFinYear;
        BudgetDetail detailWithoutBudget = new BudgetDetail();
        detailWithoutBudget.copyFrom(detail);
        detailWithoutBudget.setBudget(null);
        CFinancialYear financialYear2 = detail.getBudget().getFinancialYear();
        Long finyearId = financialYear2.getId();
        if (detail.getBudget().getIsbere().equalsIgnoreCase("BE") && (lastFinYear = (CFinancialYear)this.persistenceService.find("from CFinancialYear where startingDate=? and isActive=true", new Object[]{lastyear = this.subtractYear(startingDate = financialYear2.getStartingDate())})) != null) {
            finyearId = lastFinYear.getId();
        }
        BigDecimal approvedAmount = BigDecimal.ZERO;
        List budgetDetail = this.budgetDetailService.searchByCriteriaWithTypeAndFY(finyearId, "BE", detailWithoutBudget);
        if (budgetDetail != null && budgetDetail.size() > 0) {
            approvedAmount = ((BudgetDetail)budgetDetail.get(0)).getApprovedAmount();
        }
        return approvedAmount.setScale(2);
    }

    void populateActualData(CFinancialYear financialYear) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Starting populate Actual data..... ");
        }
        if (financialYear == null) {
            return;
        }
        Constants.DDMMYYYYFORMAT1.format(financialYear.getStartingDate());
        List list = new ArrayList();
        list = this.getExcludeStatusForBudget();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Starting fetchActualsForFY..... ");
        }
        List result = this.budgetDetailService.fetchActualsForFinYear(financialYear, this.mandatoryFields, this.topBudget, null, null, this.defaultDept, null, list);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("Done fetchActualsForFY..... " + result.size()));
        }
        for (Object[] row : result) {
            this.getBudgetDetailIdsAndAmount().put(row[0].toString(), row[1].toString());
        }
        CFinancialYear lastFinancialYearByDate = this.getFinancialYearDAO().getPreviousFinancialYearByDate(financialYear.getStartingDate());
        CFinancialYear beforeLastFinancialYearByDate = null;
        Budget lastYearTopBudget = (Budget)this.budgetService.find(" from Budget where financialYear.id=? and parent is null  and isbere=?", new Object[]{lastFinancialYearByDate.getId(), this.topBudget.getIsbere()});
        Budget beforeLastYearTopBudget = (Budget)this.budgetService.find("from Budget where financialYear.id=? and parent is null  and isbere=?", new Object[]{beforeLastFinancialYearByDate.getId(), this.topBudget.getIsbere()});
        List previousYearResult = lastYearTopBudget != null ? this.budgetDetailService.fetchActualsForFinYear(lastFinancialYearByDate, this.mandatoryFields, lastYearTopBudget, this.topBudget, null, this.defaultDept, null, list) : new ArrayList();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Finished Fetching previous Year results");
        }
        List beforePreviousYearResult = beforeLastYearTopBudget != null ? this.budgetDetailService.fetchActualsForFinYear(beforeLastFinancialYearByDate, this.mandatoryFields, beforeLastYearTopBudget, this.topBudget, null, this.defaultDept, null, list) : new ArrayList();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Finished Fetching before Last Year results");
        }
        this.mapBudgetDetailForPreviousYear(this.savedbudgetDetailList, previousYearResult, beforePreviousYearResult);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Ending populate Actual data. ");
        }
    }

    public void mapBudgetDetailForPreviousYear(List<BudgetDetail> budgetdetail, List<Object[]> previousYearList, List<Object[]> beforelastYearList) {
        new BudgetDetail();
        if (previousYearList.size() > 0) {
            for (Object[] row : previousYearList) {
                this.getPreviousYearBudgetDetailIdsAndAmount().put(row[0].toString().toString(), row[1].toString());
            }
        }
        if (beforelastYearList.size() > 0) {
            for (Object[] row : beforelastYearList) {
                this.getTwopreviousYearBudgetDetailIdsAndAmount().put(row[0].toString().toString(), row[1].toString());
            }
        }
    }

    public boolean enableApprovedAmount() {
        return this.enableApprovedAmount;
    }

    public boolean enableOriginalAmount() {
        return this.enableOriginalAmount;
    }

    public void setBudgetDetailWorkflowService(SimpleWorkflowService<BudgetDetail> workflowService) {
        this.budgetDetailWorkflowService = workflowService;
    }

    public List<WorkflowAction> getValidActions() {
        List validButtons = null;
        if (this.isReferenceBudget(this.getTopBudget())) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)"Budget is Reference budget hence cannot be saved to sent for approval");
            }
        } else {
            validButtons = this.budgetWorkflowService.getValidActions((StateAware)this.getTopBudget());
        }
        return validButtons;
    }

    public void populateNextYrBEinBudgetDetailList() {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"starting populateNextYrBEinBudgetDetailList");
        }
        if (!this.savedbudgetDetailList.isEmpty()) {
            for (BudgetDetail budgetDetail : this.savedbudgetDetailList) {
                BudgetDetail nextYrbudgetDetail = (BudgetDetail)this.persistenceService.find("from BudgetDetail where uniqueNo=? and budget.referenceBudget=?", new Object[]{budgetDetail.getUniqueNo(), budgetDetail.getBudget()});
                budgetDetail.setNextYrId(nextYrbudgetDetail.getId());
                budgetDetail.setNextYroriginalAmount(nextYrbudgetDetail.getOriginalAmount());
                budgetDetail.setNextYrapprovedAmount(nextYrbudgetDetail.getApprovedAmount());
            }
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Completed populateNextYrBEinBudgetDetailList");
        }
    }

    private void setEnablingAmounts() {
        String value = (String)this.scriptService.executeScript("BudgetDetail.enable.amounts", ScriptService.createContext((Object[])new Object[]{"wfItem", this.topBudget, "persistenceService", this.budgetService}));
        if ("approved".equalsIgnoreCase(value)) {
            this.enableApprovedAmount = true;
        } else if ("original".equalsIgnoreCase(value)) {
            this.enableOriginalAmount = true;
        }
    }

    public boolean isReferenceBudget(Budget budget) {
        boolean isReference = false;
        if (budget == null) {
            isReference = false;
            return isReference;
        }
        String mPath = budget.getMaterializedPath();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("meterialized path for the Budget" + mPath));
        }
        if (mPath == null || mPath.isEmpty()) {
            throw new ApplicationRuntimeException("Materialized path is not set for the Budget " + budget.getName());
        }
        if (budget.getIsPrimaryBudget() && budget.getIsActiveBudget()) {
            isReference = false;
            return isReference;
        }
        int start = mPath.indexOf(46);
        if (start != -1) {
            Budget rootBudget;
            String rootPath = mPath.substring(0, start);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("meterialized path for root the Budget   " + rootPath));
            }
            if ((rootBudget = (Budget)this.budgetService.find("from Budget where materializedPath=?", new Object[]{rootPath})) == null) {
                throw new ApplicationRuntimeException("Materialized path is incorrect please verify for " + rootPath);
            }
            isReference = !rootBudget.getIsPrimaryBudget() || !rootBudget.getIsActiveBudget();
        } else {
            isReference = true;
        }
        return isReference;
    }

    public void setBudgetWorkflowService(WorkflowService<Budget> budgetWorkflowService) {
        this.budgetWorkflowService = budgetWorkflowService;
    }

    public void validate() {
        for (BudgetDetail detail : this.savedbudgetDetailList) {
            if (detail.getComment() == null || detail.getComment().trim().isEmpty() || detail.getComment().length() <= 1024) continue;
            this.addFieldError("Comments Max Length  Exceeded BudgetDetail ", this.getText("budgetdetail.comments.lengthcheck"));
        }
        if (this.parameters.get("budget.comments") != null && ((String[])this.parameters.get("budget.comments"))[0] != null && !((String[])this.parameters.get("budget.comments"))[0].trim().isEmpty() && ((String[])this.parameters.get("budget.comments"))[0].length() > 1024) {
            this.addFieldError("Comments Max Length  Exceeded for  Budget", this.getText("budget.comments.lengthcheck"));
        }
    }

    @SkipValidation
    private void loadApproverUser(List<BudgetDetail> budgetDetailList) {
        Map map = this.voucherService.getDesgBYPassingWfItem("BudgetDetail.nextDesg", null, Integer.valueOf(budgetDetailList.get(0).getExecutingDepartment().getId().intValue()));
        this.addDropdownData("departmentList", this.masterDataCache.get("egi-department"));
        List desgList = (List)map.get("designationList");
        String strDesgId = "";
        String dName = "";
        boolean bDefaultDeptId = false;
        ArrayList designationList = new ArrayList();
        for (Map desgIdAndName : desgList) {
            HashMap desgFuncryMap = new HashMap();
            if (desgIdAndName.get("designationName") != null) {
                desgFuncryMap.put("designationName", desgIdAndName.get("designationName"));
            }
            if (desgIdAndName.get("designationId") != null) {
                strDesgId = (String)desgIdAndName.get("designationId");
                if (strDesgId.indexOf("~") != -1) {
                    strDesgId = strDesgId.substring(0, strDesgId.indexOf(126));
                    dName = (String)desgIdAndName.get("designationId");
                    dName = dName.substring(dName.indexOf(126) + 1);
                    bDefaultDeptId = true;
                }
                desgFuncryMap.put("designationId", strDesgId);
            }
            designationList.add(desgFuncryMap);
        }
        map.put("designationList", designationList);
        this.addDropdownData("designationList", (List)map.get("designationList"));
        if (bDefaultDeptId && !dName.equals("")) {
            Department dept = (Department)this.persistenceService.find("from Department where deptName like '%" + dName + "' ");
            this.defaultDept = dept.getId().intValue();
        }
        this.wfitemstate = map.get("wfitemstate") != null ? map.get("wfitemstate").toString() : "";
    }

    public Integer getDefaultDept() {
        return this.defaultDept;
    }

    public void setDefaultDept(Integer defaultDept) {
        this.defaultDept = defaultDept;
    }

    public void setVoucherService(VoucherService voucherService) {
        this.voucherService = voucherService;
    }

    public String getWfitemstate() {
        return this.wfitemstate;
    }

    public void setWfitemstate(String wfitemstate) {
        this.wfitemstate = wfitemstate;
    }

    public String capitalize(String value) {
        if (value == null || value.length() == 0) {
            return value;
        }
        return value.substring(0, 1).toUpperCase() + value.substring(1).toLowerCase();
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public String getComments() {
        return this.comments;
    }

    public Date subtractYear(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(1, -1);
        return cal.getTime();
    }

    public boolean isShowDetails() {
        return this.showDetails;
    }

    public void setShowDetails(boolean showDetails) {
        this.showDetails = showDetails;
    }

    public Department getDepartment() {
        return this.department;
    }

    public void setDepartment(Department department) {
        this.department = department;
    }

    public boolean isConsolidatedScreen() {
        return this.consolidatedScreen;
    }

    public void setConsolidatedScreen(boolean consolidatedScreen) {
        this.consolidatedScreen = consolidatedScreen;
    }

    public EgovMasterDataCaching getMasterDataCache() {
        return this.masterDataCache;
    }

    public void setMasterDataCache(EgovMasterDataCaching masterDataCache) {
        this.masterDataCache = masterDataCache;
    }
}

