/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.budget;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.sf.jasperreports.engine.JRException;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.egov.commons.CChartOfAccounts;
import org.egov.commons.CFinancialYear;
import org.egov.commons.CFunction;
import org.egov.commons.dao.FinancialYearDAO;
import org.egov.egf.web.actions.budget.BudgetReport;
import org.egov.egf.web.actions.budget.BudgetReportView;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.EisCommonService;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.config.persistence.datasource.routing.annotation.ReadOnly;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.infstr.services.PersistenceService;
import org.egov.infstr.utils.EgovMasterDataCaching;
import org.egov.model.budget.Budget;
import org.egov.model.budget.BudgetDetail;
import org.egov.model.budget.BudgetGroup;
import org.egov.pims.commons.Designation;
import org.egov.pims.commons.Position;
import org.egov.services.budget.BudgetDetailService;
import org.egov.services.budget.BudgetService;
import org.egov.utils.ReportHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@ParentPackage(value="egov")
@Results(value={@Result(name={"department-PDF"}, type="stream", location="inputStream", params={"inputName", "inputStream", "contentType", "application/pdf", "contentDisposition", "no-cache;filename=BudgetReport.pdf"}), @Result(name={"department-XLS"}, type="stream", location="inputStream", params={"inputName", "inputStream", "contentType", "application/xls", "contentDisposition", "no-cache;filename=BudgetReport.xls"}), @Result(name={"department-HTML"}, type="stream", location="inputStream", params={"inputName", "inputStream", "contentType", "text/html"}), @Result(name={"functionwise-PDF"}, type="stream", location="inputStream", params={"inputName", "inputStream", "contentType", "application/pdf", "contentDisposition", "no-cache;filename=BudgetReport-functionwise.pdf"}), @Result(name={"functionwise-XLS"}, type="stream", location="inputStream", params={"inputName", "inputStream", "contentType", "application/xls", "contentDisposition", "no-cache;filename=BudgetReport-functionwise.xls"}), @Result(name={"functionwise-HTML"}, type="stream", location="inputStream", params={"inputName", "inputStream", "contentType", "text/html"}), @Result(name={"functionwise-dept-HTML"}, type="stream", location="inputStream", params={"inputName", "inputStream", "contentType", "text/html"}), @Result(name={"printFunctionwise"}, location="budgetReport-printFunctionwise.jsp"), @Result(name={"print"}, location="budgetReport-print.jsp"), @Result(name={"functionwise"}, location="budgetReport-functionwise.jsp"), @Result(name={"atGlance"}, location="budgetReport-atGlance.jsp"), @Result(name={"dept"}, location="budgetReport-dept.jsp")})
public class BudgetReportAction
extends BaseFormAction {
    private static final String DEPTWISEPATH = "/reports/templates/departmentWiseBudgetReport.jasper";
    private static final String FUNCTIONWISEPATH = "/reports/templates/budgetReportFunctionwise.jasper";
    private static final String WORKINGCOPYFORFINALAPPROVER = "/reports/templates/budgetReportWorkingCopyForFinalApprover.jasper";
    private static final String WORKINGCOPYWITHALLMOUNTS = "/reports/templates/budgetReportWorkingCopy.jasper";
    private static final String WORKINGCOPYWITHONLYPROPOSALS = "/reports/templates/budgetReportWorkingCopyWithOnlyProposals.jasper";
    private ReportHelper reportHelper;
    private static final long serialVersionUID = 1L;
    private InputStream inputStream;
    private BudgetReport budgetReport = new BudgetReport();
    @Autowired
    private EisCommonService eisCommonService;
    private List budgetReportList = new ArrayList();
    @Autowired
    private AppConfigValueService appConfigValuesService;
    private int majorCodeLength = 0;
    @Autowired
    private FinancialYearDAO financialYearDAO;
    @Autowired
    @Qualifier(value="budgetService")
    private BudgetService budgetService;
    private static final String EMPTYSTRING = "";
    private static final String TOTALROW = "totalrow";
    private static final String TOTALSTRING = "TOTAL";
    private final Map<String, String> coaMap = new HashMap();
    private Map<String, String> refNoMap = new HashMap();
    private final Map<Object, BigDecimal> reAppropriationMap = new HashMap();
    private final List<BudgetReportView> reportStoreList = new ArrayList();
    private static Logger LOGGER = Logger.getLogger(BudgetReportAction.class);
    @Autowired
    @Qualifier(value="budgetDetailService")
    private BudgetDetailService budgetDetailService;
    private boolean onSaveOrForward = false;
    protected boolean canViewApprovedAmount = true;
    protected boolean finalApprover = false;
    private final List<BudgetDetail> budgetDetailListForBE = new ArrayList();
    private List<BudgetDetail> budgetDetailListForRE = new ArrayList();
    private CFinancialYear financialYearForRE;
    private CFinancialYear financialYearForBE;
    private String path = "/reports/templates/budgetReportFunctionwise.jasper";
    private String isBERE = "RE";
    private BudgetDetail budgetDetail;
    private Position pos;
    private Budget topBudget;
    private boolean departmentBudget = false;
    private String workFlowstateCondn = "";
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    @Autowired
    private EgovMasterDataCaching masterDataCache;

    public boolean isDepartmentBudget() {
        return this.departmentBudget;
    }

    public void setDepartmentBudget(boolean departmentBudget) {
        this.departmentBudget = departmentBudget;
    }

    public BudgetDetail getBudgetDetail() {
        return this.budgetDetail;
    }

    public void setBudgetDetail(BudgetDetail budgetDetail) {
        this.budgetDetail = budgetDetail;
    }

    public void setBudgetService(BudgetService budgetService) {
        this.budgetService = budgetService;
    }

    public void setFinancialYearDAO(FinancialYearDAO financialYearDAO) {
        this.financialYearDAO = financialYearDAO;
    }

    public void setReportHelper(ReportHelper reportHelper) {
        this.reportHelper = reportHelper;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public Object getModel() {
        return this.budgetReport;
    }

    @Action(value="/budget/budgetReport-functionwise")
    public String functionwise() {
        return "functionwise";
    }

    @Action(value="/budget/budgetReport-atGlance")
    public String atGlance() {
        return "atGlance";
    }

    public BudgetReportAction() {
        this.addRelatedEntity("department", Department.class);
        this.addRelatedEntity("function", CFunction.class);
        this.addRelatedEntity("financialYear", CFinancialYear.class);
    }

    public void prepare() {
        super.prepare();
        this.addDropdownData("departmentList", this.masterDataCache.get("egi-department"));
        this.addDropdownData("functionList", this.masterDataCache.get("egi-function"));
        this.addDropdownData("financialYearList", this.getPersistenceService().findAllBy("from CFinancialYear where isActive=true  order by finYearRange desc ", new Object[0]));
        this.setRelatedEntitesOn();
        this.majorCodeLength = Integer.valueOf(this.getAppConfigValueFor("EGF", "coa_majorcode_length"));
    }

    @Action(value="/budget/budgetReport-getFunctionwiseReport")
    public String getFunctionwiseReport() {
        return "printFunctionwise";
    }

    @Action(value="/budget/budgetReport-ajaxGenerateFunctionWiseHtml")
    public String ajaxGenerateFunctionWiseHtml() throws IOException {
        if (this.topBudget != null && this.topBudget.getId() != null) {
            this.topBudget = (Budget)this.budgetService.find("from Budget where id=?", new Object[]{this.topBudget.getId()});
        }
        if (this.departmentBudget) {
            this.workFlowstateCondn = " and (bd.status.code='Approved')";
        }
        Map paramMap = this.getParamMap();
        this.inputStream = this.reportHelper.exportHtml(this.inputStream, this.path, paramMap, this.getDataForFunctionwise(), "pt");
        return "functionwise-HTML";
    }

    public String ajaxFunctionWiseConsolidated() throws IOException {
        List dataForFunctionwiseForConsolidation = this.getDataForFunctionwiseForConsolidation();
        Map paramMap = this.getParamMap();
        this.inputStream = this.reportHelper.exportHtml(this.inputStream, this.path, paramMap, dataForFunctionwiseForConsolidation, "pt");
        return "functionwise-HTML";
    }

    @Action(value="/budget/budgetReport-generateFunctionWisePdf")
    public String generateFunctionWisePdf() throws JRException, IOException {
        Map paramMap = this.getParamMap();
        this.inputStream = this.reportHelper.exportPdf(this.inputStream, this.path, paramMap, this.getDataForFunctionwise());
        return "functionwise-PDF";
    }

    @Action(value="/budget/budgetReport-generateFunctionWiseXls")
    public String generateFunctionWiseXls() throws JRException, IOException {
        Map paramMap = this.getParamMap();
        this.inputStream = this.reportHelper.exportXls(this.inputStream, this.path, paramMap, this.getDataForFunctionwise());
        return "functionwise-XLS";
    }

    public String getAtGlanceReport() {
        return "printAtGlance";
    }

    @Action(value="/budget/budgetReport-ajaxGenerateAtGlanceHtml")
    public String ajaxGenerateAtGlanceHtml() throws IOException {
        Map paramMap = this.getParamMap();
        paramMap.put("heading", "BUDGET AT GLANCE ");
        this.inputStream = this.reportHelper.exportHtml(this.inputStream, this.path, paramMap, this.getDataForGlance(), "pt");
        return "functionwise-HTML";
    }

    public String generateAtGlancePdf() throws JRException, IOException {
        Map paramMap = this.getParamMap();
        paramMap.put("heading", "BUDGET AT GLANCE ");
        this.inputStream = this.reportHelper.exportPdf(this.inputStream, this.path, paramMap, this.getDataForGlance());
        return "functionwise-PDF";
    }

    public String generateAtGlanceXls() throws JRException, IOException {
        Map paramMap = this.getParamMap();
        paramMap.put("heading", "BUDGET AT GLANCE ");
        this.inputStream = this.reportHelper.exportXls(this.inputStream, this.path, paramMap, this.getDataForGlance());
        return "functionwise-XLS";
    }

    private String getSql() {
        String sql = EMPTYSTRING;
        sql = " bd.budget.financialYear=" + this.budgetReport.getFinancialYear().getId();
        if (this.budgetReport.getDepartment() != null && this.budgetReport.getDepartment().getId() != null) {
            sql = sql + " and bd.executingDepartment.id=" + this.budgetReport.getDepartment().getId();
        }
        if (this.budgetReport.getFunction() != null && this.budgetReport.getFunction().getId() != null) {
            sql = sql + " and bd.function.id=" + this.budgetReport.getFunction().getId();
        }
        return sql;
    }

    private List<BudgetDetail> getMincodeData() {
        String finalStatus = this.getFinalStatus();
        String sql = this.getSql();
        if (this.budgetReport.getType().equalsIgnoreCase("IE")) {
            sql = sql + " and bd.budgetGroup.minCode.type in ('I','E')";
        } else if (!this.budgetReport.getType().equalsIgnoreCase("All")) {
            sql = sql + " and bd.budgetGroup.minCode.type='" + this.budgetReport.getType() + "'";
        }
        List<BudgetDetail> budgetDetailList = new ArrayList();
        if (this.isOnSaveOrForward()) {
            budgetDetailList = this.getPersistenceService().findAllBy(" from BudgetDetail bd where " + sql + " and bd.budget.isbere='RE'   order by bd.executingDepartment,bd.function.name,bd.budgetGroup.minCode.type,bd.budgetGroup.minCode.glcode", new Object[0]);
            if (budgetDetailList.isEmpty()) {
                budgetDetailList = this.getPersistenceService().findAllBy(" from BudgetDetail bd where " + sql + " and bd.budget.isbere='BE'   order by bd.executingDepartment,bd.function.name,bd.budgetGroup.minCode.type,bd.budgetGroup.minCode.glcode", new Object[0]);
            }
        } else {
            budgetDetailList = this.getPersistenceService().findAllBy(" from BudgetDetail bd where " + sql + " and bd.budget.isbere='RE' and bd.approvedAmount is not null  and bd.budget.status.code='" + finalStatus + "'  order by bd.executingDepartment,bd.function.name,bd.budgetGroup.minCode.type,bd.budgetGroup.minCode.glcode", new Object[0]);
            this.isBERE = "RE";
            if (budgetDetailList.isEmpty()) {
                budgetDetailList = this.getPersistenceService().findAllBy(" from BudgetDetail bd where " + sql + " and bd.budget.isbere='BE' and  bd.budget.status.code ='" + finalStatus + "'  order by bd.executingDepartment,bd.function.name,bd.budgetGroup.minCode.type,bd.budgetGroup.minCode.glcode", new Object[0]);
                this.isBERE = "BE";
            }
        }
        return budgetDetailList;
    }

    private void getMincodeDataForWorkingCopy() {
        String sql = EMPTYSTRING;
        if (this.budgetReport.getType().equalsIgnoreCase("IE")) {
            sql = sql + " and bd.budgetGroup.minCode.type in ('I','E')";
        } else if (!this.budgetReport.getType().equalsIgnoreCase("All")) {
            sql = sql + " and bd.budgetGroup.minCode.type='" + this.budgetReport.getType() + "'";
        }
        sql = this.getSqlForFinYear(this.financialYearForRE.getId());
        this.budgetDetailListForRE = this.getPersistenceService().findAllBy(" from BudgetDetail bd where " + sql + this.workFlowstateCondn + " and bd.budget.isbere='RE'   order by bd.executingDepartment,bd.function,bd.budgetGroup.minCode.type,bd.budgetGroup.minCode.glcode", new Object[0]);
        sql = this.getSqlForFinYearBE(this.financialYearForBE.getId());
        this.budgetDetailListForBE.addAll(this.getPersistenceService().findAllBy(" from BudgetDetail bd where " + sql + this.workFlowstateCondn + " and bd.budget.isbere='BE'   order by bd.executingDepartment,bd.function,bd.budgetGroup.minCode.type,bd.budgetGroup.minCode.glcode", new Object[0]));
    }

    private List<BudgetDetail> getMajorcodeData() {
        String finalStatus = this.getFinalStatus();
        String sql = this.getSql();
        if (this.budgetReport.getType().equalsIgnoreCase("IE")) {
            sql = sql + " and bd.budgetGroup.majorCode.type in ('I','E')";
        } else if (!this.budgetReport.getType().equalsIgnoreCase("All")) {
            sql = sql + " and bd.budgetGroup.majorCode.type='" + this.budgetReport.getType() + "'";
        }
        List<BudgetDetail> budgetDetailList = new ArrayList();
        if (this.onSaveOrForward) {
            budgetDetailList = this.getPersistenceService().findAllBy(" from BudgetDetail bd where " + sql + "  order by bd.executingDepartment,bd.function.name,bd.budgetGroup.majorCode.type,bd.budgetGroup.majorCode.glcode", new Object[0]);
            if (budgetDetailList.isEmpty()) {
                budgetDetailList = this.getPersistenceService().findAllBy(" from BudgetDetail bd where " + sql + " and bd.budget.isbere='BE'  order by bd.executingDepartment,bd.function.name,bd.budgetGroup.majorCode.type,bd.budgetGroup.majorCode.glcode", new Object[0]);
            }
        } else {
            budgetDetailList = this.getPersistenceService().findAllBy(" from BudgetDetail bd where " + sql + " and bd.budget.isbere='RE' and bd.budget.status.code='" + finalStatus + "' order by bd.executingDepartment,bd.function.name,bd.budgetGroup.majorCode.type,bd.budgetGroup.majorCode.glcode", new Object[0]);
            if (budgetDetailList.isEmpty()) {
                budgetDetailList = this.getPersistenceService().findAllBy(" from BudgetDetail bd where " + sql + " and bd.budget.isbere='BE'  and bd.budget.status.code='" + finalStatus + "'  order by bd.executingDepartment,bd.function.name,bd.budgetGroup.majorCode.type,bd.budgetGroup.majorCode.glcode", new Object[0]);
            }
        }
        return budgetDetailList;
    }

    private void getMajorcodeDataForWorkingCopy() {
        String sql = EMPTYSTRING;
        if (this.budgetReport.getType().equalsIgnoreCase("IE")) {
            sql = sql + " and bd.budgetGroup.majorCode.type in ('I','E')";
        } else if (!this.budgetReport.getType().equalsIgnoreCase("All")) {
            sql = sql + " and bd.budgetGroup.majorCode.type='" + this.budgetReport.getType() + "'";
        }
        sql = this.getSqlForFinYear(this.financialYearForRE.getId());
        this.budgetDetailListForRE.addAll(this.getPersistenceService().findAllBy(" from BudgetDetail bd where " + sql + this.workFlowstateCondn + "  order by bd.executingDepartment,bd.function,bd.budgetGroup.majorCode.type,bd.budgetGroup.majorCode.glcode", new Object[0]));
        sql = this.getSqlForFinYearBE(this.financialYearForBE.getId());
        this.budgetDetailListForBE.addAll(this.getPersistenceService().findAllBy(" from BudgetDetail bd where " + sql + this.workFlowstateCondn + " and bd.budget.isbere='BE'  order by bd.executingDepartment,bd.function,bd.budgetGroup.majorCode.type,bd.budgetGroup.majorCode.glcode", new Object[0]));
    }

    private List<Object> getDataForFunctionwise() {
        if (this.onSaveOrForward) {
            return this.getDataFunctionWiseForWorkingCopy();
        }
        List budgetDetailList = null;
        budgetDetailList = this.getMincodeData();
        budgetDetailList.addAll(this.getMajorcodeData());
        if (budgetDetailList.isEmpty()) {
            return this.budgetReportList;
        }
        Integer deptId = 0;
        Long functionId = 0L;
        String type = EMPTYSTRING;
        String majorCode = EMPTYSTRING;
        String glcode = EMPTYSTRING;
        String glType = EMPTYSTRING;
        String glName = EMPTYSTRING;
        String tempMajorCode = EMPTYSTRING;
        BigDecimal totalAmt = BigDecimal.ZERO;
        BigDecimal totalAppropriationAmt = BigDecimal.ZERO;
        BigDecimal reAppropriationAmt = BigDecimal.ZERO;
        boolean printed = true;
        boolean isFirst = true;
        boolean majorcodewise = false;
        this.refNoMap = this.getReferenceNumber("functionWiseBudgetReport");
        this.getCOA();
        this.getBudgetReappropriationAmt();
        this.loadAmountForMajorcodewise(this.budgetReport.getFinancialYear(), this.budgetReport.getDepartment(), this.budgetReport.getFunction());
        for (BudgetDetail detail : budgetDetailList) {
            if (detail.getExecutingDepartment() == null || detail.getFunction() == null) continue;
            BigDecimal bigDecimal = reAppropriationAmt = this.reAppropriationMap.get(detail.getId()) == null ? BigDecimal.ZERO : (BigDecimal)this.reAppropriationMap.get(detail.getId());
            if (detail.getBudgetGroup().getMajorCode() == null) {
                glcode = this.getGlCode(detail);
                glType = detail.getBudgetGroup().getMinCode().getType().toString();
                glName = this.getGlName(detail);
            } else {
                glcode = detail.getBudgetGroup().getMajorCode().getGlcode();
                glType = detail.getBudgetGroup().getMajorCode().getType().toString();
                glName = detail.getBudgetGroup().getMajorCode().getName();
                majorcodewise = true;
            }
            tempMajorCode = glcode.substring(0, this.majorCodeLength);
            if (detail.getExecutingDepartment().getId().compareTo(deptId.longValue()) != 0) {
                if (totalAmt.compareTo(BigDecimal.ZERO) != 0 && !isFirst) {
                    this.budgetReportList.add(new BudgetReportView(EMPTYSTRING, EMPTYSTRING, EMPTYSTRING, TOTALSTRING, EMPTYSTRING, totalAmt, totalAppropriationAmt, totalAmt.add(totalAppropriationAmt), TOTALROW));
                    totalAmt = BigDecimal.ZERO;
                    totalAppropriationAmt = BigDecimal.ZERO;
                }
                this.budgetReportList.add(new BudgetReportView(EMPTYSTRING, EMPTYSTRING, EMPTYSTRING, detail.getExecutingDepartment().getName(), EMPTYSTRING, null, null, null, "deptrow"));
                type = EMPTYSTRING;
                functionId = null;
                majorCode = EMPTYSTRING;
            }
            if (!glType.equals(type)) {
                if (totalAmt.compareTo(BigDecimal.ZERO) != 0 && !isFirst) {
                    this.budgetReportList.add(new BudgetReportView(EMPTYSTRING, EMPTYSTRING, EMPTYSTRING, TOTALSTRING, EMPTYSTRING, totalAmt, totalAppropriationAmt, totalAmt.add(totalAppropriationAmt), TOTALROW));
                    totalAmt = BigDecimal.ZERO;
                    totalAppropriationAmt = BigDecimal.ZERO;
                }
                this.budgetReportList.add(new BudgetReportView(EMPTYSTRING, EMPTYSTRING, EMPTYSTRING, "FUNCTIONWISE " + BudgetReport.getValueFor((String)glType).toUpperCase() + " BUDGET SUMMARY", (String)this.refNoMap.get(BudgetReport.getValueFor((String)glType)), null, null, null, "typerow"));
                functionId = null;
                majorCode = EMPTYSTRING;
            }
            if (detail.getFunction().getId().compareTo(functionId != null ? functionId : 0L) != 0) {
                if (totalAmt.compareTo(BigDecimal.ZERO) != 0 && !isFirst) {
                    this.budgetReportList.add(new BudgetReportView(EMPTYSTRING, EMPTYSTRING, EMPTYSTRING, TOTALSTRING, EMPTYSTRING, totalAmt, totalAppropriationAmt, totalAmt.add(totalAppropriationAmt), TOTALROW));
                    totalAmt = BigDecimal.ZERO;
                    totalAppropriationAmt = BigDecimal.ZERO;
                }
                this.budgetReportList.add(new BudgetReportView(EMPTYSTRING, EMPTYSTRING, EMPTYSTRING, "FUNCTION CENTRE-" + detail.getFunction().getName(), EMPTYSTRING, null, null, null, "functionrow"));
                List majorCodeList = this.getAmountForMajorcodewise(Integer.valueOf(detail.getExecutingDepartment().getId().intValue()), detail.getFunction().getId(), glType);
                this.budgetReportList.addAll(majorCodeList);
                printed = false;
                majorCode = EMPTYSTRING;
            }
            if (!tempMajorCode.equals(majorCode) && detail.getBudgetGroup().getMajorCode() == null) {
                if (printed) {
                    this.budgetReportList.add(new BudgetReportView(EMPTYSTRING, EMPTYSTRING, EMPTYSTRING, TOTALSTRING, EMPTYSTRING, totalAmt, totalAppropriationAmt, totalAmt.add(totalAppropriationAmt), TOTALROW));
                    totalAmt = BigDecimal.ZERO;
                    totalAppropriationAmt = BigDecimal.ZERO;
                }
                this.budgetReportList.add(new BudgetReportView(EMPTYSTRING, EMPTYSTRING, (String)this.refNoMap.get(tempMajorCode), tempMajorCode + "-" + (String)this.coaMap.get(tempMajorCode), EMPTYSTRING, null, null, null, "majorcodeheadingrow"));
            }
            if (detail.getExecutingDepartment() != null && detail.getFunction() != null && detail.getBudgetGroup().getMajorCode() == null) {
                this.budgetReportList.add(new BudgetReportView(detail.getExecutingDepartment().getCode(), detail.getFunction().getCode(), glcode, glName, EMPTYSTRING, detail.getApprovedAmount(), reAppropriationAmt, detail.getApprovedAmount().add(reAppropriationAmt), "detailrow"));
            }
            if (detail.getExecutingDepartment() != null) {
                deptId = detail.getExecutingDepartment().getId().intValue();
            }
            if (detail.getFunction() != null) {
                functionId = detail.getFunction().getId();
            }
            type = glType;
            majorCode = tempMajorCode;
            totalAmt = totalAmt.add(detail.getApprovedAmount());
            totalAppropriationAmt = totalAppropriationAmt.add(reAppropriationAmt);
            printed = true;
            isFirst = false;
        }
        if (totalAmt.compareTo(BigDecimal.ZERO) != 0 && !majorcodewise) {
            this.budgetReportList.add(new BudgetReportView(EMPTYSTRING, EMPTYSTRING, EMPTYSTRING, TOTALSTRING, EMPTYSTRING, totalAmt, totalAppropriationAmt, totalAmt.add(totalAppropriationAmt), TOTALROW));
        }
        return this.budgetReportList;
    }

    private List<Object> getDataForFunctionwiseForConsolidation() {
        List budgetDetailList = null;
        this.pos = this.getPosition();
        if (this.budgetDetail.getId() != null) {
            this.budgetDetail = (BudgetDetail)this.budgetDetailService.find("from BudgetDetail where id=?", new Object[]{this.budgetDetail.getId()});
            this.topBudget = this.budgetDetail.getBudget();
            this.budgetReport.setFinancialYear(this.budgetDetail.getBudget().getFinancialYear());
            budgetDetailList = this.budgetDetailService.findAllBy("from BudgetDetail where budget.id=? and state.value=? and function=?", new Object[]{this.budgetDetail.getBudget().getId(), "END", this.budgetDetail.getFunction()});
        } else if (this.budgetDetail.getBudget().getId() != null) {
            this.topBudget = (Budget)this.budgetService.find("from Budget where id=?", new Object[]{this.budgetDetail.getBudget().getId()});
            this.budgetReport.setFinancialYear(this.topBudget.getFinancialYear());
            budgetDetailList = this.budgetDetailService.findAllBy("from BudgetDetail where budget=? and( state.value=? or state.owner=?)", new Object[]{this.topBudget, "END", this.pos});
        }
        if (budgetDetailList.isEmpty()) {
            return this.budgetReportList;
        }
        Integer deptId = 0;
        Long functionId = 0L;
        String type = EMPTYSTRING;
        String majorCode = EMPTYSTRING;
        String glcode = EMPTYSTRING;
        String glType = EMPTYSTRING;
        String glName = EMPTYSTRING;
        String tempMajorCode = EMPTYSTRING;
        BigDecimal totalAmt = BigDecimal.ZERO;
        BigDecimal totalAppropriationAmt = BigDecimal.ZERO;
        BigDecimal reAppropriationAmt = BigDecimal.ZERO;
        boolean printed = true;
        boolean isFirst = true;
        boolean majorcodewise = false;
        this.refNoMap = this.getReferenceNumber("functionWiseBudgetReport");
        this.getCOA();
        this.loadAmountForMajorcodewiseConsolidated(this.budgetReport.getFinancialYear(), this.budgetReport.getDepartment(), this.budgetReport.getFunction());
        for (BudgetDetail detail : budgetDetailList) {
            if (detail.getExecutingDepartment() == null || detail.getFunction() == null) continue;
            if (detail.getBudgetGroup().getMajorCode() == null) {
                glcode = this.getGlCode(detail);
                glType = detail.getBudgetGroup().getMinCode().getType().toString();
                glName = this.getGlName(detail);
            } else {
                glcode = detail.getBudgetGroup().getMajorCode().getGlcode();
                glType = detail.getBudgetGroup().getMajorCode().getType().toString();
                glName = detail.getBudgetGroup().getMajorCode().getName();
                majorcodewise = true;
            }
            tempMajorCode = glcode.substring(0, this.majorCodeLength);
            if (!detail.getExecutingDepartment().getId().equals(deptId)) {
                if (totalAmt.compareTo(BigDecimal.ZERO) != 0 && !isFirst) {
                    this.budgetReportList.add(new BudgetReportView(EMPTYSTRING, EMPTYSTRING, EMPTYSTRING, TOTALSTRING, EMPTYSTRING, totalAmt, totalAppropriationAmt, totalAmt.add(totalAppropriationAmt), TOTALROW));
                    totalAmt = BigDecimal.ZERO;
                    totalAppropriationAmt = BigDecimal.ZERO;
                }
                this.budgetReportList.add(new BudgetReportView(EMPTYSTRING, EMPTYSTRING, EMPTYSTRING, detail.getExecutingDepartment().getName(), EMPTYSTRING, null, null, null, "deptrow"));
                type = EMPTYSTRING;
                functionId = null;
                majorCode = EMPTYSTRING;
            }
            if (!glType.equals(type)) {
                if (totalAmt.compareTo(BigDecimal.ZERO) != 0 && !isFirst) {
                    this.budgetReportList.add(new BudgetReportView(EMPTYSTRING, EMPTYSTRING, EMPTYSTRING, TOTALSTRING, EMPTYSTRING, totalAmt, totalAppropriationAmt, totalAmt.add(totalAppropriationAmt), TOTALROW));
                    totalAmt = BigDecimal.ZERO;
                    totalAppropriationAmt = BigDecimal.ZERO;
                }
                this.budgetReportList.add(new BudgetReportView(EMPTYSTRING, EMPTYSTRING, EMPTYSTRING, "FUNCTIONWISE " + BudgetReport.getValueFor((String)glType).toUpperCase() + " BUDGET SUMMARY", (String)this.refNoMap.get(BudgetReport.getValueFor((String)glType)), null, null, null, "typerow"));
                functionId = null;
                majorCode = EMPTYSTRING;
            }
            if (!detail.getFunction().getId().equals(functionId)) {
                if (totalAmt.compareTo(BigDecimal.ZERO) != 0 && !isFirst) {
                    this.budgetReportList.add(new BudgetReportView(EMPTYSTRING, EMPTYSTRING, EMPTYSTRING, TOTALSTRING, EMPTYSTRING, totalAmt, totalAppropriationAmt, totalAmt.add(totalAppropriationAmt), TOTALROW));
                    totalAmt = BigDecimal.ZERO;
                    totalAppropriationAmt = BigDecimal.ZERO;
                }
                this.budgetReportList.add(new BudgetReportView(EMPTYSTRING, EMPTYSTRING, EMPTYSTRING, "FUNCTION CENTRE-" + detail.getFunction().getName(), EMPTYSTRING, null, null, null, "functionrow"));
                List majorCodeList = this.getAmountForMajorcodewise(Integer.valueOf(detail.getExecutingDepartment().getId().intValue()), detail.getFunction().getId(), glType);
                this.budgetReportList.addAll(majorCodeList);
                printed = false;
                majorCode = EMPTYSTRING;
            }
            if (!tempMajorCode.equals(majorCode) && detail.getBudgetGroup().getMajorCode() == null) {
                if (printed) {
                    this.budgetReportList.add(new BudgetReportView(EMPTYSTRING, EMPTYSTRING, EMPTYSTRING, TOTALSTRING, EMPTYSTRING, totalAmt, totalAppropriationAmt, totalAmt.add(totalAppropriationAmt), TOTALROW));
                    totalAmt = BigDecimal.ZERO;
                    totalAppropriationAmt = BigDecimal.ZERO;
                }
                this.budgetReportList.add(new BudgetReportView(EMPTYSTRING, EMPTYSTRING, (String)this.refNoMap.get(tempMajorCode), tempMajorCode + "-" + (String)this.coaMap.get(tempMajorCode), EMPTYSTRING, null, null, null, "majorcodeheadingrow"));
            }
            if (detail.getExecutingDepartment() != null && detail.getFunction() != null && detail.getBudgetGroup().getMajorCode() == null) {
                this.budgetReportList.add(new BudgetReportView(detail.getExecutingDepartment().getCode(), detail.getFunction().getCode(), glcode, glName, EMPTYSTRING, detail.getApprovedAmount(), reAppropriationAmt, detail.getApprovedAmount().add(reAppropriationAmt), "detailrow"));
            }
            if (detail.getExecutingDepartment() != null) {
                deptId = detail.getExecutingDepartment().getId().intValue();
            }
            if (detail.getFunction() != null) {
                functionId = detail.getFunction().getId();
            }
            type = glType;
            majorCode = tempMajorCode;
            totalAmt = totalAmt.add(detail.getApprovedAmount());
            totalAppropriationAmt = totalAppropriationAmt.add(reAppropriationAmt);
            printed = true;
            isFirst = false;
        }
        if (totalAmt.compareTo(BigDecimal.ZERO) != 0 && !majorcodewise) {
            this.budgetReportList.add(new BudgetReportView(EMPTYSTRING, EMPTYSTRING, EMPTYSTRING, TOTALSTRING, EMPTYSTRING, totalAmt, totalAppropriationAmt, totalAmt.add(totalAppropriationAmt), TOTALROW));
        }
        return this.budgetReportList;
    }

    public Budget getTopBudget() {
        return this.topBudget;
    }

    public void setTopBudget(Budget topBudget) {
        this.topBudget = topBudget;
    }

    private Position getPosition() {
        Position pos;
        try {
            pos = this.eisCommonService.getPrimaryAssignmentPositionForEmp(ApplicationThreadLocals.getUserId());
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException("Unable to get Position for the user");
        }
        return pos;
    }

    public void loadAmountForMajorcodewise(CFinancialYear finyear, Department dept, CFunction function) {
        String finalStatus = this.getFinalStatus();
        String miscQuery = EMPTYSTRING;
        String floatingColumn = "sum(bd.approvedAmount)";
        if (this.onSaveOrForward) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("......Can view the approved Amount" + this.canViewApprovedAmount));
            }
            if (!this.canViewApprovedAmount) {
                floatingColumn = "sum(bd.originalAmount)";
                finalStatus = "%";
            }
        }
        if (dept != null && dept.getId() != null) {
            miscQuery = miscQuery + " and bd.executingDepartment.id=" + dept.getId();
        }
        if (function != null && function.getId() != null) {
            miscQuery = miscQuery + " and bd.function.id=" + function.getId();
        }
        List amountList = this.getPersistenceService().findAllBy("select substr(bd.budgetGroup.minCode.glcode,0," + this.majorCodeLength + ") ," + EMPTYSTRING + floatingColumn + ",bd.executingDepartment.id,bd.function.id,bd.budgetGroup.minCode.type,bd.id from BudgetDetail bd where " + "bd.budget.financialYear=? and bd.budget.state in (from org.egov.infra.workflow.entity.State where type='Budget' and value='" + finalStatus + "' ) " + miscQuery + " and bd.budget.isbere='" + this.isBERE + "' group by substr(bd.budgetGroup.minCode.glcode,0," + this.majorCodeLength + "),bd.executingDepartment.id," + "bd.function.id,bd.budgetGroup.minCode.type,bd.id order by  substr(bd.budgetGroup.minCode.glcode,0," + this.majorCodeLength + "),bd.executingDepartment.id,bd.function.id", new Object[]{finyear});
        BigDecimal reAppropriationAmt = BigDecimal.ZERO;
        for (Object[] obj : amountList) {
            if (obj[0] == null || obj[1] == null || obj[2] == null || obj[3] == null || obj[4] == null || BigDecimal.ZERO.compareTo(BigDecimal.valueOf(Double.valueOf(obj[1].toString()))) == 0) continue;
            reAppropriationAmt = this.reAppropriationMap.get(obj[5]) == null ? BigDecimal.ZERO : (BigDecimal)this.reAppropriationMap.get(obj[5]);
            this.reportStoreList.add(new BudgetReportView(Integer.valueOf(obj[2] + EMPTYSTRING), Long.valueOf(obj[3] + EMPTYSTRING), obj[4] + EMPTYSTRING, obj[0] + EMPTYSTRING, (BigDecimal)obj[1], reAppropriationAmt, ((BigDecimal)obj[1]).add(reAppropriationAmt)));
        }
        amountList = this.getPersistenceService().findAllBy("select substr(bd.budgetGroup.majorCode.glcode,0," + this.majorCodeLength + ") ," + floatingColumn + ",bd.executingDepartment.id,bd.function.id,bd.budgetGroup.majorCode.type,bd.id from BudgetDetail bd where bd.budget.financialYear=? and bd.budget.state in (from org.egov.infra.workflow.entity.State where type='Budget' and value='" + finalStatus + "' )  and bd.budget.isbere='" + this.isBERE + "' group by substr(bd.budgetGroup.majorCode.glcode,0," + this.majorCodeLength + "),bd.executingDepartment.id,bd.function.id,bd.budgetGroup.majorCode.type,bd.id order by  substr(bd.budgetGroup.majorCode.glcode,0," + this.majorCodeLength + ")", new Object[]{finyear});
        for (Object[] obj : amountList) {
            if (obj[0] == null || obj[1] == null || obj[2] == null || obj[3] == null || obj[4] == null || BigDecimal.ZERO.compareTo(BigDecimal.valueOf(Double.valueOf(obj[1].toString()))) == 0) continue;
            reAppropriationAmt = this.reAppropriationMap.get(obj[5]) == null ? BigDecimal.ZERO : (BigDecimal)this.reAppropriationMap.get(obj[5]);
            this.reportStoreList.add(new BudgetReportView(Integer.valueOf(obj[2] + EMPTYSTRING), Long.valueOf(obj[3] + EMPTYSTRING), obj[4] + EMPTYSTRING, obj[0] + EMPTYSTRING, (BigDecimal)obj[1], reAppropriationAmt, ((BigDecimal)obj[1]).add(reAppropriationAmt)));
        }
    }

    public void loadAmountForMajorcodewiseConsolidated(CFinancialYear finyear, Department dept, CFunction function) {
        this.getFinalStatus();
        String miscQuery = EMPTYSTRING;
        String floatingColumn = "sum(bd.approvedAmount)";
        if (dept != null && dept.getId() != null) {
            miscQuery = miscQuery + " and bd.executingDepartment.id=" + dept.getId();
        }
        if (function != null && function.getId() != null) {
            miscQuery = miscQuery + " and bd.function.id=" + function.getId();
        }
        List amountList = this.getPersistenceService().findAllBy("select substr(bd.budgetGroup.minCode.glcode,0," + this.majorCodeLength + ") ," + EMPTYSTRING + "sum(bd.approvedAmount)" + ",bd.executingDepartment.id,bd.function.id,bd.budgetGroup.minCode.type,bd.id from BudgetDetail bd where " + "bd.budget.financialYear=? and( bd.state.value ='END'  or bd.state.owner=?) and bd.budget=?" + miscQuery + " and bd.budget.isbere='" + this.isBERE + "' group by substr(bd.budgetGroup.minCode.glcode,0," + this.majorCodeLength + "),bd.executingDepartment.id," + "bd.function.id,bd.budgetGroup.minCode.type,bd.id order by  substr(bd.budgetGroup.minCode.glcode,0," + this.majorCodeLength + "),bd.executingDepartment.id,bd.function.id", new Object[]{finyear, this.pos, this.topBudget});
        BigDecimal reAppropriationAmt = BigDecimal.ZERO;
        for (Object[] obj : amountList) {
            if (obj[0] == null || obj[1] == null || obj[2] == null || obj[3] == null || obj[4] == null || BigDecimal.ZERO.compareTo(BigDecimal.valueOf(Double.valueOf(obj[1].toString()))) == 0) continue;
            reAppropriationAmt = this.reAppropriationMap.get(obj[5]) == null ? BigDecimal.ZERO : (BigDecimal)this.reAppropriationMap.get(obj[5]);
            this.reportStoreList.add(new BudgetReportView(Integer.valueOf(obj[2] + EMPTYSTRING), Long.valueOf(obj[3] + EMPTYSTRING), obj[4] + EMPTYSTRING, obj[0] + EMPTYSTRING, (BigDecimal)obj[1], reAppropriationAmt, ((BigDecimal)obj[1]).add(reAppropriationAmt)));
        }
    }

    public void loadAmountForMajorcodewiseForWorkingCopy(CFinancialYear finyear, Department dept, CFunction function) {
        String miscQuery = EMPTYSTRING;
        String floatingColumn = "sum(bd.originalAmount),sum(bd.approvedAmount)";
        this.getFinYearForRE();
        miscQuery = this.getSqlForFinYear(this.financialYearForRE.getId());
        List amountListForRE = this.getPersistenceService().findAllBy("select substr(bd.budgetGroup.minCode.glcode,0," + this.majorCodeLength + ") ," + EMPTYSTRING + "sum(bd.originalAmount),sum(bd.approvedAmount)" + ",bd.executingDepartment.id,bd.function.id,bd.budgetGroup.minCode.type,bd.budgetGroup.minCode.glcode,bd.id from BudgetDetail bd where " + " " + miscQuery + this.workFlowstateCondn + " and bd.budget.isbere='RE' group by substr(bd.budgetGroup.minCode.glcode,0," + this.majorCodeLength + "),bd.executingDepartment.id," + "bd.function.id,bd.budgetGroup.minCode.type,bd.budgetGroup.minCode.glcode,bd.id order by  substr(bd.budgetGroup.minCode.glcode,0," + this.majorCodeLength + "),bd.executingDepartment.id,bd.function.id", new Object[0]);
        amountListForRE.addAll(this.getPersistenceService().findAllBy("select substr(bd.budgetGroup.majorCode.glcode,0," + this.majorCodeLength + ") ," + "sum(bd.originalAmount),sum(bd.approvedAmount)" + ",bd.executingDepartment.id,bd.function.id,bd.budgetGroup.majorCode.type,bd.id from BudgetDetail bd where " + miscQuery + this.workFlowstateCondn + "  and bd.budget.isbere='RE'  group by substr(bd.budgetGroup.majorCode.glcode,0," + this.majorCodeLength + "),bd.executingDepartment.id,bd.function.id,bd.budgetGroup.majorCode.type,bd.budgetGroup.majorCode.glcode,bd.budgetGroup.minCode.glcode,bd.id order by  substr(bd.budgetGroup.majorCode.glcode,0," + this.majorCodeLength + ")", new Object[0]));
        miscQuery = this.getSqlForFinYearBE(this.financialYearForBE.getId());
        List amountListForBE = this.getPersistenceService().findAllBy("select substr(bd.budgetGroup.minCode.glcode,0," + this.majorCodeLength + ") ," + EMPTYSTRING + "sum(bd.originalAmount),sum(bd.approvedAmount)" + ",bd.executingDepartment.id,bd.function.id,bd.budgetGroup.minCode.type,bd.budgetGroup.minCode.glcode,bd.id from BudgetDetail bd where " + " " + miscQuery + this.workFlowstateCondn + "   and bd.budget.isbere='BE'  group by substr(bd.budgetGroup.minCode.glcode,0," + this.majorCodeLength + "),bd.executingDepartment.id," + "bd.function.id,bd.budgetGroup.minCode.type,bd.budgetGroup.minCode.glcode,bd.id order by  substr(bd.budgetGroup.minCode.glcode,0," + this.majorCodeLength + "),bd.executingDepartment.id,bd.function.id", new Object[0]);
        amountListForBE.addAll(this.getPersistenceService().findAllBy("select substr(bd.budgetGroup.majorCode.glcode,0," + this.majorCodeLength + ") ," + "sum(bd.originalAmount),sum(bd.approvedAmount)" + ",bd.executingDepartment.id,bd.function.id,bd.budgetGroup.majorCode.type,bd.budgetGroup.majorCode.glcode,bd.id from BudgetDetail bd where " + miscQuery + this.workFlowstateCondn + "   and bd.budget.isbere='BE'  group by substr(bd.budgetGroup.majorCode.glcode,0," + this.majorCodeLength + "),bd.executingDepartment.id,bd.function.id,bd.budgetGroup.majorCode.type,bd.budgetGroup.majorCode.glcode,bd.id order by  substr(bd.budgetGroup.majorCode.glcode,0," + this.majorCodeLength + ")", new Object[0]));
        block0: for (Object[] re : amountListForRE) {
            for (Object[] be : amountListForBE) {
                if (!re[0].toString().equalsIgnoreCase(be[0].toString()) || !re[3].toString().equalsIgnoreCase(be[3].toString()) || !re[4].toString().equalsIgnoreCase(be[4].toString()) || !re[6].toString().equalsIgnoreCase(be[6].toString())) continue;
                BudgetReportView v1 = new BudgetReportView();
                v1.setDeptId(Integer.valueOf(re[3].toString()));
                v1.setFunctionId((Long)re[4]);
                v1.setType(re[5].toString());
                v1.setMajorCode(re[0].toString());
                v1.setReProposalAmount((BigDecimal)re[1]);
                v1.setReRecomAmount((BigDecimal)re[2]);
                v1.setBeProposalAmount((BigDecimal)be[1]);
                v1.setBeRecomAmount((BigDecimal)be[2]);
                this.reportStoreList.add(v1);
                continue block0;
            }
        }
    }

    public List<Object> getAmountForMajorcodewise(Integer deptId, Long functionId, String type) {
        BigDecimal grandAmt = BigDecimal.ZERO;
        BigDecimal totalAmt = BigDecimal.ZERO;
        BigDecimal appropriationGrandAmt = BigDecimal.ZERO;
        BigDecimal appropriationTotalAmt = BigDecimal.ZERO;
        ArrayList<Object> majorCodeList = new ArrayList<Object>();
        TreeMap<String, BudgetReportView> entries = new TreeMap<String, BudgetReportView>();
        for (BudgetReportView budgetReportView : this.reportStoreList) {
            if (!deptId.equals(budgetReportView.getDeptId()) || !functionId.equals(budgetReportView.getFunctionId()) || !type.equals(budgetReportView.getType())) continue;
            if (entries.get(budgetReportView.getMajorCode()) == null) {
                totalAmt = BigDecimal.ZERO;
                appropriationTotalAmt = BigDecimal.ZERO;
                entries.put(budgetReportView.getMajorCode(), new BudgetReportView(EMPTYSTRING, EMPTYSTRING, EMPTYSTRING, budgetReportView.getMajorCode() + "-" + (String)this.coaMap.get(budgetReportView.getMajorCode()), this.refNoMap.get(budgetReportView.getMajorCode()) == null ? EMPTYSTRING : ((String)this.refNoMap.get(budgetReportView.getMajorCode())).toString(), budgetReportView.getTempamount(), budgetReportView.getAppropriationAmount(), budgetReportView.getTempamount().add(budgetReportView.getAppropriationAmount()), "majorcoderow"));
                totalAmt = totalAmt.add(budgetReportView.getTempamount());
                appropriationTotalAmt = appropriationTotalAmt.add(budgetReportView.getAppropriationAmount());
            } else {
                totalAmt = totalAmt.add(budgetReportView.getTempamount());
                appropriationTotalAmt = appropriationTotalAmt.add(budgetReportView.getAppropriationAmount());
                ((BudgetReportView)entries.get(budgetReportView.getMajorCode())).setAmount(totalAmt);
                ((BudgetReportView)entries.get(budgetReportView.getMajorCode())).setAppropriationAmount(appropriationTotalAmt);
                ((BudgetReportView)entries.get(budgetReportView.getMajorCode())).setTotalAmount(totalAmt.add(appropriationTotalAmt));
            }
            grandAmt = grandAmt.add(budgetReportView.getTempamount());
            appropriationGrandAmt = appropriationGrandAmt.add(budgetReportView.getAppropriationAmount());
        }
        for (Map.Entry entry : entries.entrySet()) {
            majorCodeList.add(entry.getValue());
        }
        if (totalAmt.compareTo(BigDecimal.ZERO) != 0) {
            majorCodeList.add(new BudgetReportView(EMPTYSTRING, EMPTYSTRING, EMPTYSTRING, TOTALSTRING, EMPTYSTRING, grandAmt, appropriationGrandAmt, grandAmt.add(appropriationGrandAmt), TOTALROW));
        }
        return majorCodeList;
    }

    public List<Object> getAmountForMajorcodewiseForWorkingCopy(Integer deptId, Long functionId, String type) {
        BigDecimal reProposalTotalAmountLocal = BigDecimal.ZERO;
        BigDecimal beProposalTotalAmountLocal = BigDecimal.ZERO;
        BigDecimal reRecomTotalAmountLocal = BigDecimal.ZERO;
        BigDecimal beRecomTotalAmountLocal = BigDecimal.ZERO;
        BigDecimal reProposalTotalAmountLocalGrand = BigDecimal.ZERO;
        BigDecimal beProposalTotalAmountLocalGrand = BigDecimal.ZERO;
        BigDecimal reRecomTotalAmountLocalGrand = BigDecimal.ZERO;
        BigDecimal beRecomTotalAmountLocalGrand = BigDecimal.ZERO;
        ArrayList<Object> majorCodeList = new ArrayList<Object>();
        TreeMap<String, BudgetReportView> entries = new TreeMap<String, BudgetReportView>();
        for (BudgetReportView budgetReportView : this.reportStoreList) {
            if (!deptId.equals(budgetReportView.getDeptId()) || !functionId.equals(budgetReportView.getFunctionId()) || !type.equals(budgetReportView.getType())) continue;
            if (entries.get(budgetReportView.getMajorCode()) == null) {
                reProposalTotalAmountLocal = BigDecimal.ZERO;
                beProposalTotalAmountLocal = BigDecimal.ZERO;
                reRecomTotalAmountLocal = BigDecimal.ZERO;
                beRecomTotalAmountLocal = BigDecimal.ZERO;
                BudgetReportView v2 = new BudgetReportView();
                v2.setNarration("1414");
                v2.setNarration(budgetReportView.getMajorCode() + "-" + (String)this.coaMap.get(budgetReportView.getMajorCode()));
                v2.setReference(this.refNoMap.get(budgetReportView.getMajorCode()) == null ? EMPTYSTRING : ((String)this.refNoMap.get(budgetReportView.getMajorCode())).toString());
                v2.setBeProposalAmount(budgetReportView.getBeProposalAmount());
                v2.setReProposalAmount(budgetReportView.getReProposalAmount());
                v2.setBeRecomAmount(budgetReportView.getBeRecomAmount());
                v2.setReRecomAmount(budgetReportView.getReRecomAmount());
                entries.put(budgetReportView.getMajorCode(), v2);
                reProposalTotalAmountLocal = reProposalTotalAmountLocal.add(budgetReportView.getReProposalAmount());
                beProposalTotalAmountLocal = beProposalTotalAmountLocal.add(budgetReportView.getBeProposalAmount());
                beRecomTotalAmountLocal = beRecomTotalAmountLocal.add(budgetReportView.getBeRecomAmount());
                reRecomTotalAmountLocal = reRecomTotalAmountLocal.add(budgetReportView.getReRecomAmount());
            } else {
                reProposalTotalAmountLocal = reProposalTotalAmountLocal.add(budgetReportView.getReProposalAmount());
                beProposalTotalAmountLocal = beProposalTotalAmountLocal.add(budgetReportView.getBeProposalAmount());
                beRecomTotalAmountLocal = beRecomTotalAmountLocal.add(budgetReportView.getBeRecomAmount());
                reRecomTotalAmountLocal = reRecomTotalAmountLocal.add(budgetReportView.getReRecomAmount());
                ((BudgetReportView)entries.get(budgetReportView.getMajorCode())).setReProposalAmount(reProposalTotalAmountLocal);
                ((BudgetReportView)entries.get(budgetReportView.getMajorCode())).setBeProposalAmount(beProposalTotalAmountLocal);
                ((BudgetReportView)entries.get(budgetReportView.getMajorCode())).setReRecomAmount(reRecomTotalAmountLocal);
                ((BudgetReportView)entries.get(budgetReportView.getMajorCode())).setBeRecomAmount(beRecomTotalAmountLocal);
            }
            reProposalTotalAmountLocalGrand = reProposalTotalAmountLocalGrand.add(budgetReportView.getReProposalAmount());
            beProposalTotalAmountLocalGrand = beProposalTotalAmountLocalGrand.add(budgetReportView.getBeProposalAmount());
            beRecomTotalAmountLocalGrand = beRecomTotalAmountLocalGrand.add(budgetReportView.getBeRecomAmount());
            reRecomTotalAmountLocalGrand = reRecomTotalAmountLocalGrand.add(budgetReportView.getReRecomAmount());
        }
        for (Map.Entry entry : entries.entrySet()) {
            majorCodeList.add(entry.getValue());
        }
        BudgetReportView v3 = new BudgetReportView();
        v3.setBeProposalAmount(beProposalTotalAmountLocalGrand);
        v3.setReProposalAmount(reProposalTotalAmountLocalGrand);
        v3.setBeRecomAmount(beRecomTotalAmountLocalGrand);
        v3.setReRecomAmount(reRecomTotalAmountLocalGrand);
        v3.setRowStyle(TOTALROW);
        v3.setNarration(TOTALSTRING);
        majorCodeList.add(v3);
        return majorCodeList;
    }

    public void getCOA() {
        List coaList = this.getPersistenceService().findAllBy("from CChartOfAccounts where length(glcode)=" + this.majorCodeLength, new Object[0]);
        for (CChartOfAccounts coa : coaList) {
            this.coaMap.put(coa.getGlcode(), coa.getName());
        }
    }

    @Action(value="/budget/budgetReport-departmentWiseReport")
    public String departmentWiseReport() {
        return "dept";
    }

    @ValidationErrorPage(value="dept")
    @Action(value="/budget/budgetReport-printDepartmentWiseReport")
    public String printDepartmentWiseReport() {
        try {
            this.validateFinancialYear();
        }
        catch (ValidationException e) {
            throw new ValidationException(Arrays.asList(new ValidationError(((ValidationError)e.getErrors().get(0)).getMessage(), ((ValidationError)e.getErrors().get(0)).getMessage())));
        }
        catch (Exception e) {
            throw new ValidationException(Arrays.asList(new ValidationError(e.getMessage(), e.getMessage())));
        }
        return "print";
    }

    @Action(value="/budget/budgetReport-generateDepartmentWiseXls")
    public String generateDepartmentWiseXls() throws JRException, IOException {
        this.validateFinancialYear();
        this.populateData();
        this.inputStream = this.reportHelper.exportXls(this.inputStream, DEPTWISEPATH, this.getParamMap(), this.budgetReportList);
        return "department-XLS";
    }

    @Action(value="/budget/budgetReport-generateDepartmentWisePdf")
    public String generateDepartmentWisePdf() throws Exception {
        this.validateFinancialYear();
        this.populateData();
        this.inputStream = this.reportHelper.exportPdf(this.inputStream, DEPTWISEPATH, this.getParamMap(), this.budgetReportList);
        return "department-PDF";
    }

    @Action(value="/budget/budgetReport-ajaxGenerateDepartmentWiseHtml")
    public String ajaxGenerateDepartmentWiseHtml() throws Exception {
        this.populateData();
        this.inputStream = this.reportHelper.exportHtml(this.inputStream, DEPTWISEPATH, this.getParamMap(), this.budgetReportList, "px");
        return "department-HTML";
    }

    public BudgetReport getBudgetReport() {
        return this.budgetReport;
    }

    public void setBudgetReport(BudgetReport budgetReport) {
        this.budgetReport = budgetReport;
    }

    protected void setRelatedEntitesOn() {
        if (this.budgetReport.getDepartment() == null || this.budgetReport.getDepartment().getId() == null) {
            this.budgetReport.setDepartment(null);
        } else {
            this.budgetReport.setDepartment((Department)this.getPersistenceService().find("from Department where id=?", new Object[]{this.budgetReport.getDepartment().getId()}));
        }
        if (this.budgetReport.getFinancialYear() != null) {
            this.budgetReport.setFinancialYear((CFinancialYear)this.getPersistenceService().find("from CFinancialYear where id=?", new Object[]{this.budgetReport.getFinancialYear().getId()}));
        }
    }

    protected void validateFinancialYear() {
        if (this.budgetReport.getFinancialYear() == null || this.budgetReport.getFinancialYear().getId() == null) {
            throw new ValidationException(Arrays.asList(new ValidationError("report.financialyear.not.selected", "report.financialyear.not.selected")));
        }
    }

    protected String getBudgetType(String finalStatus) {
        String isBeRe = "BE";
        Budget budget = (Budget)this.persistenceService.find("from Budget where financialYear.id=? and parent is null and isPrimaryBudget=true and isActiveBudget=true and isBeRe='RE' and status.code='" + finalStatus + "' ", new Object[]{this.budgetReport.getFinancialYear().getId()});
        if (budget != null) {
            isBeRe = "RE";
        }
        return isBeRe;
    }

    protected void addEmptyRow() {
        this.budgetReportList.add(new BudgetReportView(EMPTYSTRING, EMPTYSTRING, EMPTYSTRING, null, null, null));
    }

    protected String getQueryForSelectedType(String code) {
        if (this.budgetReport.getType() == null) {
            return EMPTYSTRING;
        }
        if (!"ALL".equalsIgnoreCase(this.budgetReport.getType())) {
            if ("IE".equalsIgnoreCase(this.budgetReport.getType())) {
                return "and (bd.budgetGroup." + code + ".type='I' or bd.budgetGroup." + code + ".type='E')";
            }
            return "and bd.budgetGroup." + code + ".type='" + this.budgetReport.getType() + "'";
        }
        return EMPTYSTRING;
    }

    @ReadOnly
    protected Map<String, Object> getParamMap() {
        HashMap<String, Object> paramMap = new HashMap<String, String>();
        paramMap.put("finYear", this.budgetReport.getFinancialYear().getFinYearRange());
        if (this.onSaveOrForward) {
            paramMap = this.getReportConfigs(paramMap);
        }
        if (this.budgetReport.getType() != null) {
            paramMap.put("type", BudgetReport.getValueFor((String)this.budgetReport.getType()));
        }
        return paramMap;
    }

    private Map<String, Object> getReportConfigs(Map<String, Object> paramMap) {
        if (this.financialYearForRE == null) {
            CFinancialYear finYear;
            Long finYearForRE = this.getFinYearForRE();
            this.financialYearForBE = finYearForRE == this.budgetReport.getFinancialYear().getId() ? (finYear = this.getFinYear("next")) : this.budgetReport.getFinancialYear();
        }
        List list = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "budget_toplevel_approver_designation");
        String value = ((AppConfigValues)list.get(0)).getValue();
        Assignment empAssignment = this.eisCommonService.getLatestAssignmentForEmployeeByToDate(ApplicationThreadLocals.getUserId(), new Date());
        Designation designation = empAssignment.getDesignation();
        if (designation.getName().equalsIgnoreCase(value)) {
            this.finalApprover = true;
        }
        this.canViewApprovedAmount = this.budgetDetailService.canViewApprovedAmount(this.persistenceService, null);
        this.path = !this.canViewApprovedAmount && !this.finalApprover ? WORKINGCOPYWITHONLYPROPOSALS : (this.finalApprover ? WORKINGCOPYFORFINALAPPROVER : WORKINGCOPYWITHALLMOUNTS);
        if (this.departmentBudget) {
            this.path = WORKINGCOPYFORFINALAPPROVER;
        }
        paramMap.put("financialYearForRE", this.financialYearForRE.getFinYearRange());
        paramMap.put("financialYearForBE", this.financialYearForBE.getFinYearRange());
        paramMap.put("heading", " FUNCTIONWISE  BUDGET SUMMARY ");
        return paramMap;
    }

    protected Map<String, String> getReferenceNumber(String appConfigKey) {
        HashMap<String, String> referenceNo = new HashMap<String, String>();
        List appConfigValues = this.appConfigValuesService.getConfigValuesByModuleAndKeyLike("EGF", appConfigKey + "-%");
        for (AppConfigValues appConfigVal : appConfigValues) {
            referenceNo.put(appConfigVal.getConfig().getKeyName().split("-")[1], appConfigVal.getValue());
        }
        return referenceNo;
    }

    protected String getFinalStatus() {
        return this.getAppConfigValueFor("EGF", "budget_final_approval_status");
    }

    protected String getAppConfigValueFor(String module, String key) {
        return ((AppConfigValues)this.appConfigValuesService.getConfigValuesByModuleAndKey(module, key).get(0)).getValue();
    }

    @ReadOnly
    protected void populateData() {
        String finalStatus = this.getFinalStatus();
        String isBeRe = this.getBudgetType(finalStatus);
        String deptQuery = EMPTYSTRING;
        if (this.budgetReport.getDepartment() != null && this.budgetReport.getDepartment().getId() != null) {
            deptQuery = " and bd.executingDepartment.id=" + this.budgetReport.getDepartment().getId().toString();
        }
        this.getBudgetReappropriationAmt();
        String budgetType = BudgetReport.getValueFor((String)this.budgetReport.getType());
        if (budgetType != null && !"ALL".equals(this.budgetReport.getType())) {
            this.budgetReportList.add(new BudgetReportView(EMPTYSTRING, budgetType.toUpperCase() + " BUDGET SUMMARY", EMPTYSTRING, null, null, null));
        }
        LinkedList budgetDetails = new LinkedList();
        this.fetchBudgetDetails(budgetDetails, deptQuery, finalStatus, isBeRe, "minCode");
        this.fetchBudgetDetails(budgetDetails, deptQuery, finalStatus, isBeRe, "majorCode");
        this.populateSummarySection(budgetDetails, isBeRe);
        this.addRowsToReport(budgetDetails, isBeRe);
    }

    public Map<String, BigDecimal> getMajorCodeToAmountMap(List<BudgetDetail> budgetDetails) {
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        for (BudgetDetail entry : budgetDetails) {
            BigDecimal approvedAmount;
            String glCode = EMPTYSTRING;
            glCode = entry.getBudgetGroup().getMajorCode() == null ? entry.getBudgetGroup().getMinCode().getMajorCode() : entry.getBudgetGroup().getMajorCode().getMajorCode();
            BigDecimal totalAmount = approvedAmount = entry.getApprovedAmount() == null ? BigDecimal.ZERO : entry.getApprovedAmount();
            if (map.get(glCode) != null) {
                map.put(glCode, ((BigDecimal)map.get(glCode)).add(totalAmount));
                continue;
            }
            map.put(glCode, totalAmount);
        }
        return map;
    }

    public String getUniqueMajorCodesAsString(Map<String, BigDecimal> majorCodeToAmountMap) {
        String result = EMPTYSTRING;
        Set<String> uniqueMajorCodes = majorCodeToAmountMap.keySet();
        for (String row : uniqueMajorCodes) {
            if (row == null) continue;
            result = result.concat("'").concat(row).concat("',");
        }
        if (result.length() > 0) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    public BigDecimal getMajorCodeTotals(Map<String, BigDecimal> majorCodeToAmountMap) {
        BigDecimal sum = BigDecimal.ZERO;
        for (Map.Entry<String, BigDecimal> entry : majorCodeToAmountMap.entrySet()) {
            if (entry.getValue() == null) continue;
            sum = sum.add(entry.getValue());
        }
        return sum;
    }

    public BigDecimal getMajorCodeApproriationTotals(Map<String, BigDecimal> majorCodeToApproriationAmountMap) {
        BigDecimal sum = BigDecimal.ZERO;
        for (Map.Entry<String, BigDecimal> entry : majorCodeToApproriationAmountMap.entrySet()) {
            if (entry.getValue() == null) continue;
            sum = sum.add(entry.getValue());
        }
        return sum;
    }

    void populateSummarySection(List<BudgetDetail> budgetDetails, String isBeRe) {
        Map majorCodeToAmountMap = this.getMajorCodeToAmountMap(budgetDetails);
        Map majorCodeToAppropriationAmountMap = this.getMajorCodeToAppropriationAmountMap(budgetDetails);
        Map referenceNo = this.getReferenceNumber("departmentWiseBudgetReport");
        String uniqueMajorCodesAsString = this.getUniqueMajorCodesAsString(majorCodeToAmountMap);
        if (EMPTYSTRING.equals(uniqueMajorCodesAsString)) {
            this.budgetReportList.add(new BudgetReportView(EMPTYSTRING, "No records found", EMPTYSTRING, null, null, null));
            return;
        }
        List chartOfAccounts = this.getPersistenceService().findAllBy("from CChartOfAccounts where glCode in (" + uniqueMajorCodesAsString + ")", new Object[0]);
        for (CChartOfAccounts account : chartOfAccounts) {
            BigDecimal approved = (BigDecimal)majorCodeToAmountMap.get(account.getMajorCode());
            BigDecimal reApp = (BigDecimal)majorCodeToAppropriationAmountMap.get(account.getMajorCode());
            if ("RE".equalsIgnoreCase(isBeRe) && !this.getConsiderReAppropriationAsSeperate()) {
                this.budgetReportList.add(new BudgetReportView(EMPTYSTRING, account.getMajorCode() + "-" + account.getName(), (String)referenceNo.get(account.getMajorCode()), approved.add(reApp), BigDecimal.ZERO, approved.add(reApp)));
                continue;
            }
            this.budgetReportList.add(new BudgetReportView(EMPTYSTRING, account.getMajorCode() + "-" + account.getName(), (String)referenceNo.get(account.getMajorCode()), approved, reApp, approved.add(reApp)));
        }
        if (!chartOfAccounts.isEmpty()) {
            BigDecimal majorCodeApprovedTotals = this.getMajorCodeTotals(majorCodeToAmountMap);
            BigDecimal majorCodeApproriationTotals = this.getMajorCodeApproriationTotals(majorCodeToAppropriationAmountMap);
            if ("RE".equalsIgnoreCase(isBeRe) && !this.getConsiderReAppropriationAsSeperate()) {
                this.budgetReportList.add(new BudgetReportView(EMPTYSTRING, "Total", EMPTYSTRING, majorCodeApprovedTotals.add(majorCodeApproriationTotals), BigDecimal.ZERO, majorCodeApprovedTotals.add(majorCodeApproriationTotals)));
            } else {
                this.budgetReportList.add(new BudgetReportView(EMPTYSTRING, "Total", EMPTYSTRING, majorCodeApprovedTotals, majorCodeApproriationTotals, majorCodeApprovedTotals.add(majorCodeApproriationTotals)));
            }
        }
        this.addEmptyRow();
    }

    private Map<String, BigDecimal> getMajorCodeToAppropriationAmountMap(List<BudgetDetail> budgetDetails) {
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        for (BudgetDetail entry : budgetDetails) {
            BigDecimal totalAmount;
            String glCode = EMPTYSTRING;
            glCode = entry.getBudgetGroup().getMajorCode() == null ? entry.getBudgetGroup().getMinCode().getMajorCode() : entry.getBudgetGroup().getMajorCode().getMajorCode();
            BigDecimal reAppAmount = (BigDecimal)this.reAppropriationMap.get(entry.getId());
            BigDecimal bigDecimal = totalAmount = reAppAmount == null ? BigDecimal.ZERO : reAppAmount;
            if (map.get(glCode) != null) {
                map.put(glCode, ((BigDecimal)map.get(glCode)).add(totalAmount));
                continue;
            }
            map.put(glCode, totalAmount);
        }
        return map;
    }

    void addRowsToReport(List<BudgetDetail> budgetDetails, String isBeRe) {
        Integer deptId = 0;
        BudgetReportView row = new BudgetReportView(null, null, null, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO);
        String glcode = null;
        BigDecimal sum = BigDecimal.ZERO;
        BigDecimal appropriationSum = BigDecimal.ZERO;
        budgetDetails = this.budgetDetailService.sortByDepartmentName(budgetDetails);
        for (BudgetDetail budgetDetail : budgetDetails) {
            if (budgetDetail.getExecutingDepartment() != null && budgetDetail.getExecutingDepartment().getId().compareTo(deptId.longValue()) != 0) {
                if (!deptId.equals(0)) {
                    if ("RE".equalsIgnoreCase(isBeRe) && !this.getConsiderReAppropriationAsSeperate()) {
                        this.budgetReportList.add(new BudgetReportView(EMPTYSTRING, "Total", EMPTYSTRING, sum.add(appropriationSum), BigDecimal.ZERO, sum.add(appropriationSum)));
                    } else {
                        this.budgetReportList.add(new BudgetReportView(EMPTYSTRING, "Total", EMPTYSTRING, sum, appropriationSum, sum.add(appropriationSum)));
                    }
                }
                sum = BigDecimal.ZERO;
                this.addEmptyRow();
                this.budgetReportList.add(new BudgetReportView(EMPTYSTRING, budgetDetail.getExecutingDepartment().getName().toUpperCase(), EMPTYSTRING, null, null, null));
                deptId = budgetDetail.getExecutingDepartment().getId().intValue();
                glcode = null;
            }
            if (!this.getGlCode(budgetDetail).equals(glcode)) {
                glcode = this.getGlCode(budgetDetail);
                String glName = this.getGlName(budgetDetail);
                row = new BudgetReportView(glcode, glName, EMPTYSTRING, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO);
                this.budgetReportList.add(row);
            }
            BigDecimal approvedAmount = budgetDetail.getApprovedAmount() == null ? BigDecimal.ZERO : budgetDetail.getApprovedAmount();
            BigDecimal reAppAmount = (BigDecimal)this.reAppropriationMap.get(budgetDetail.getId());
            if ("RE".equalsIgnoreCase(isBeRe) && !this.getConsiderReAppropriationAsSeperate()) {
                row.setAmount(approvedAmount.add(reAppAmount == null ? BigDecimal.ZERO : reAppAmount));
                row.setAppropriationAmount(BigDecimal.ZERO);
                row.setTotalAmount(approvedAmount.add(reAppAmount == null ? BigDecimal.ZERO : reAppAmount));
            } else {
                row.setAmount(approvedAmount);
                row.setAppropriationAmount(reAppAmount == null ? BigDecimal.ZERO : reAppAmount);
                row.setTotalAmount(approvedAmount.add(reAppAmount == null ? BigDecimal.ZERO : reAppAmount));
            }
            sum = sum.add(approvedAmount);
        }
        if (!budgetDetails.isEmpty()) {
            if ("RE".equalsIgnoreCase(isBeRe) && !this.getConsiderReAppropriationAsSeperate()) {
                this.budgetReportList.add(new BudgetReportView(EMPTYSTRING, "Total", EMPTYSTRING, sum.add(appropriationSum), BigDecimal.ZERO, sum.add(appropriationSum)));
            } else {
                this.budgetReportList.add(new BudgetReportView(EMPTYSTRING, "Total", EMPTYSTRING, sum, appropriationSum, sum.add(appropriationSum)));
            }
        }
    }

    private String getGlName(BudgetDetail budgetDetail) {
        BudgetGroup budgetGroup = budgetDetail.getBudgetGroup();
        return budgetGroup.getMinCode() == null ? budgetGroup.getMajorCode().getName() : budgetGroup.getMinCode().getName();
    }

    private String getGlCode(BudgetDetail budgetDetail) {
        BudgetGroup budgetGroup = budgetDetail.getBudgetGroup();
        return budgetGroup.getMinCode() == null ? budgetGroup.getMajorCode().getGlcode() : budgetGroup.getMinCode().getGlcode();
    }

    void fetchBudgetDetails(List<BudgetDetail> budgetDetails, String deptQuery, String finalStatus, String budgetType, String code) {
        List results = this.persistenceService.getSession().createQuery(" from BudgetDetail bd where bd.budget.financialYear.id=" + this.budgetReport.getFinancialYear().getId() + deptQuery + " and bd.budget.isbere='" + budgetType + "' and bd.budget.status.code ='" + finalStatus + "' " + this.getQueryForSelectedType(code) + "  order by bd.executingDepartment.name,bd.budgetGroup." + code + ".glcode").list();
        budgetDetails.addAll(results);
    }

    private void getBudgetReappropriationAmt() {
        String status = this.getFinalStatus();
        List list = this.getPersistenceService().findAllBy("select sum(br.additionAmount)-sum(br.deductionAmount),br.budgetDetail.id from BudgetReAppropriation br where br.status = (select id from EgwStatus where moduletype='BudgetReAppropriation' and description='Approved') group by br.budgetDetail.id", new Object[0]);
        if (!list.isEmpty() && list.size() != 0) {
            for (Object[] obj : list) {
                this.reAppropriationMap.put(obj[1], (BigDecimal)obj[0]);
            }
        }
    }

    public boolean isOnSaveOrForward() {
        return this.onSaveOrForward;
    }

    public void setOnSaveOrForward(boolean onSaveOrForward) {
        this.onSaveOrForward = onSaveOrForward;
    }

    public BudgetDetailService getBudgetDetailService() {
        return this.budgetDetailService;
    }

    public void setBudgetDetailService(BudgetDetailService budgetDetailService) {
        this.budgetDetailService = budgetDetailService;
    }

    private List<Object> getDataFunctionWiseForWorkingCopy() {
        this.getMincodeDataForWorkingCopy();
        this.getMajorcodeDataForWorkingCopy();
        if (this.budgetDetailListForRE.isEmpty()) {
            return this.budgetReportList;
        }
        Integer deptId = 0;
        Long functionId = 0L;
        String type = EMPTYSTRING;
        String majorCode = EMPTYSTRING;
        String glcode = EMPTYSTRING;
        String glType = EMPTYSTRING;
        String glName = EMPTYSTRING;
        String tempMajorCode = EMPTYSTRING;
        BigDecimal reProposalTotalLocal = BigDecimal.ZERO;
        BigDecimal beProposalTotalLocal = BigDecimal.ZERO;
        BigDecimal reRecomTotalLocal = BigDecimal.ZERO;
        BigDecimal beRecomTotalLocal = BigDecimal.ZERO;
        boolean printed = true;
        boolean isFirst = true;
        boolean majorcodewise = false;
        this.refNoMap = this.getReferenceNumber("functionWiseBudgetReport");
        this.getCOA();
        this.getBudgetReappropriationAmt();
        this.loadAmountForMajorcodewiseForWorkingCopy(this.budgetReport.getFinancialYear(), this.budgetReport.getDepartment(), this.budgetReport.getFunction());
        for (BudgetDetail detail : this.budgetDetailListForRE) {
            BudgetDetail beDetail = new BudgetDetail();
            for (BudgetDetail detail1 : this.budgetDetailListForBE) {
                if (detail.getExecutingDepartment().getId() != detail1.getExecutingDepartment().getId() || detail.getFunction().getId() != detail1.getFunction().getId() || detail.getBudgetGroup().getId() != detail1.getBudgetGroup().getId()) continue;
                beDetail = detail1;
                break;
            }
            if (detail.getExecutingDepartment() == null || detail.getFunction() == null) continue;
            if (detail.getBudgetGroup().getMajorCode() == null) {
                glcode = this.getGlCode(detail);
                glType = detail.getBudgetGroup().getMinCode().getType().toString();
                glName = this.getGlName(detail);
            } else {
                glcode = detail.getBudgetGroup().getMajorCode().getGlcode();
                glType = detail.getBudgetGroup().getMajorCode().getType().toString();
                glName = detail.getBudgetGroup().getMajorCode().getName();
                majorcodewise = true;
            }
            tempMajorCode = glcode.substring(0, this.majorCodeLength);
            if (!detail.getExecutingDepartment().getId().equals(deptId)) {
                if (reProposalTotalLocal.compareTo(BigDecimal.ZERO) != 0 && !isFirst) {
                    this.budgetReportList.add(new BudgetReportView(EMPTYSTRING, EMPTYSTRING, EMPTYSTRING, TOTALSTRING, EMPTYSTRING, reProposalTotalLocal, beProposalTotalLocal, reRecomTotalLocal, beRecomTotalLocal, TOTALROW));
                    reProposalTotalLocal = BigDecimal.ZERO;
                    beProposalTotalLocal = BigDecimal.ZERO;
                    reRecomTotalLocal = BigDecimal.ZERO;
                    beRecomTotalLocal = BigDecimal.ZERO;
                }
                this.budgetReportList.add(new BudgetReportView(EMPTYSTRING, EMPTYSTRING, EMPTYSTRING, detail.getExecutingDepartment().getName(), EMPTYSTRING, null, null, null, "deptrow"));
                type = EMPTYSTRING;
                functionId = null;
                majorCode = EMPTYSTRING;
            }
            if (!glType.equals(type)) {
                if (reProposalTotalLocal.compareTo(BigDecimal.ZERO) != 0 && !isFirst) {
                    this.budgetReportList.add(new BudgetReportView(EMPTYSTRING, EMPTYSTRING, EMPTYSTRING, TOTALSTRING, EMPTYSTRING, reProposalTotalLocal, reRecomTotalLocal, beProposalTotalLocal, beRecomTotalLocal, TOTALROW));
                    reProposalTotalLocal = BigDecimal.ZERO;
                    beProposalTotalLocal = BigDecimal.ZERO;
                    reRecomTotalLocal = BigDecimal.ZERO;
                    beRecomTotalLocal = BigDecimal.ZERO;
                }
                this.budgetReportList.add(new BudgetReportView(EMPTYSTRING, EMPTYSTRING, EMPTYSTRING, "FUNCTIONWISE " + BudgetReport.getValueFor((String)glType).toUpperCase() + " BUDGET SUMMARY", (String)this.refNoMap.get(BudgetReport.getValueFor((String)glType)), null, null, null, "typerow"));
                functionId = null;
                majorCode = EMPTYSTRING;
            }
            if (!detail.getFunction().getId().equals(functionId)) {
                if (reProposalTotalLocal.compareTo(BigDecimal.ZERO) != 0 && !isFirst) {
                    this.budgetReportList.add(new BudgetReportView(EMPTYSTRING, EMPTYSTRING, EMPTYSTRING, TOTALSTRING, EMPTYSTRING, reProposalTotalLocal, reRecomTotalLocal, beProposalTotalLocal, beRecomTotalLocal, TOTALROW));
                    reProposalTotalLocal = BigDecimal.ZERO;
                    beProposalTotalLocal = BigDecimal.ZERO;
                    reRecomTotalLocal = BigDecimal.ZERO;
                    beRecomTotalLocal = BigDecimal.ZERO;
                }
                this.budgetReportList.add(new BudgetReportView(EMPTYSTRING, EMPTYSTRING, EMPTYSTRING, "FUNCTION CENTRE-" + detail.getFunction().getName(), EMPTYSTRING, null, null, null, "functionrow"));
                List majorCodeList = this.getAmountForMajorcodewiseForWorkingCopy(Integer.valueOf(detail.getExecutingDepartment().getId().intValue()), detail.getFunction().getId(), glType);
                this.budgetReportList.addAll(majorCodeList);
                printed = false;
                majorCode = EMPTYSTRING;
            }
            if (!tempMajorCode.equals(majorCode) && detail.getBudgetGroup().getMajorCode() == null) {
                if (printed) {
                    this.budgetReportList.add(new BudgetReportView(EMPTYSTRING, EMPTYSTRING, EMPTYSTRING, TOTALSTRING, EMPTYSTRING, reProposalTotalLocal, reRecomTotalLocal, beProposalTotalLocal, beRecomTotalLocal, TOTALROW));
                    reProposalTotalLocal = BigDecimal.ZERO;
                    beProposalTotalLocal = BigDecimal.ZERO;
                    reRecomTotalLocal = BigDecimal.ZERO;
                    beRecomTotalLocal = BigDecimal.ZERO;
                }
                this.budgetReportList.add(new BudgetReportView(EMPTYSTRING, EMPTYSTRING, (String)this.refNoMap.get(tempMajorCode), tempMajorCode + "-" + (String)this.coaMap.get(tempMajorCode), EMPTYSTRING, null, null, null, "majorcodeheadingrow"));
            }
            if (detail.getExecutingDepartment() != null && detail.getFunction() != null && detail.getBudgetGroup().getMajorCode() == null) {
                if (this.onSaveOrForward && !this.canViewApprovedAmount) {
                    this.budgetReportList.add(new BudgetReportView(detail.getExecutingDepartment().getCode(), detail.getFunction().getCode(), glcode, glName, EMPTYSTRING, detail.getOriginalAmount(), detail.getApprovedAmount(), beDetail.getOriginalAmount(), beDetail.getApprovedAmount(), "detailrow"));
                } else {
                    this.budgetReportList.add(new BudgetReportView(detail.getExecutingDepartment().getCode(), detail.getFunction().getCode(), glcode, glName, EMPTYSTRING, detail.getOriginalAmount(), detail.getApprovedAmount(), beDetail.getOriginalAmount(), beDetail.getApprovedAmount(), "detailrow"));
                }
            }
            if (detail.getExecutingDepartment() != null) {
                deptId = detail.getExecutingDepartment().getId().intValue();
            }
            if (detail.getFunction() != null) {
                functionId = detail.getFunction().getId();
            }
            type = glType;
            majorCode = tempMajorCode;
            reProposalTotalLocal = reProposalTotalLocal.add(detail.getOriginalAmount());
            beProposalTotalLocal = beProposalTotalLocal.add(beDetail.getOriginalAmount());
            reRecomTotalLocal = reRecomTotalLocal.add(detail.getApprovedAmount());
            beRecomTotalLocal = beRecomTotalLocal.add(beDetail.getApprovedAmount());
            printed = true;
            isFirst = false;
        }
        if (reProposalTotalLocal.compareTo(BigDecimal.ZERO) != 0 && !majorcodewise) {
            this.budgetReportList.add(new BudgetReportView(EMPTYSTRING, EMPTYSTRING, EMPTYSTRING, TOTALSTRING, EMPTYSTRING, reProposalTotalLocal, reRecomTotalLocal, beProposalTotalLocal, beRecomTotalLocal, TOTALROW));
        }
        return this.budgetReportList;
    }

    private List getDataForGlance() {
        ArrayList budgetAtGlanceList = new ArrayList();
        budgetAtGlanceList.addAll(this.getFunctionwiseSumForGlance());
        budgetAtGlanceList.addAll(this.getBudgetWiseSumAndDetail());
        return budgetAtGlanceList;
    }

    private List<BudgetReportView> getBudgetWiseSumAndDetail() {
        ArrayList<BudgetReportView> ReportList = new ArrayList<BudgetReportView>();
        LinkedHashMap<String, BudgetReportView> function_deptSumMap = new LinkedHashMap<String, BudgetReportView>();
        StringBuffer query = new StringBuffer("select function.name,executingDepartment.deptCode,sum(originalAmount),sum(approvedAmount)  from BudgetDetail bd  where bd.budget.financialYear.id=" + this.budgetReport.getFinancialYear().getId());
        query.append(" and bd.budget.isbere='RE' ");
        if (this.budgetReport.getFunction() != null && this.budgetReport.getFunction().getId() != null && this.budgetReport.getFunction().getId() != 0L) {
            query.append("  and bd.function.id=" + this.budgetReport.getFunction().getId());
        }
        query.append(" group by function.name,executingDepartment.deptCode order by function.name,executingDepartment.deptCode");
        List findAllBy = this.persistenceService.findAllBy(query.toString(), new Object[0]);
        for (Object[] o : findAllBy) {
            BudgetReportView bv = new BudgetReportView();
            bv.setNarration((String)o[0]);
            bv.setDeptCode((String)o[1]);
            bv.setFunctionCode(EMPTYSTRING);
            bv.setReProposalAmount(o[2] != null ? new BigDecimal(o[2].toString()) : BigDecimal.ZERO);
            bv.setReRecomAmount(o[3] != null ? new BigDecimal(o[3].toString()) : BigDecimal.ZERO);
            bv.setRowStyle("majorcodeheadingrow");
            function_deptSumMap.put((String)o[0] + "-" + (String)o[1], bv);
        }
        query = new StringBuffer("select function.name,executingDepartment.deptCode,sum(originalAmount),sum(approvedAmount)  from BudgetDetail bd  where bd.budget.financialYear.id=" + this.getFinYear("next").getId());
        query.append(" and bd.budget.isbere='BE' ");
        if (this.budgetReport.getFunction() != null && this.budgetReport.getFunction().getId() != null && this.budgetReport.getFunction().getId() != 0L) {
            query.append("  and bd.function.id=" + this.budgetReport.getFunction().getId());
        }
        query.append(" group by function.name, executingDepartment.deptCode order by function.name,executingDepartment.deptCode");
        findAllBy = this.persistenceService.findAllBy(query.toString(), new Object[0]);
        for (Object[] o : findAllBy) {
            String key = (String)o[0] + "-" + (String)o[1];
            BudgetReportView bv = (BudgetReportView)function_deptSumMap.get(key);
            if (bv == null) {
                bv = new BudgetReportView();
                bv.setNarration((String)o[0]);
                bv.setDeptCode((String)o[1]);
                bv.setFunctionCode(EMPTYSTRING);
                bv.setBeProposalAmount(o[2] != null ? new BigDecimal(o[2].toString()) : BigDecimal.ZERO);
                bv.setBeRecomAmount(o[3] != null ? new BigDecimal(o[3].toString()) : BigDecimal.ZERO);
                function_deptSumMap.put((String)o[0] + "-" + (String)o[1], bv);
                continue;
            }
            bv.setBeProposalAmount(o[2] != null ? new BigDecimal(o[2].toString()) : BigDecimal.ZERO);
            bv.setBeRecomAmount(o[3] != null ? new BigDecimal(o[3].toString()) : BigDecimal.ZERO);
        }
        query = new StringBuffer(" from BudgetDetail bd  where bd.budget.financialYear.id=" + this.budgetReport.getFinancialYear().getId());
        query.append(" and bd.budget.isbere='RE' ");
        if (this.budgetReport.getFunction() != null && this.budgetReport.getFunction().getId() != null && this.budgetReport.getFunction().getId() != 0L) {
            query.append("  and bd.function.id=" + this.budgetReport.getFunction().getId());
        }
        query.append("  order by function.name,executingDepartment.deptCode");
        List details = this.persistenceService.findAllBy(query.toString(), new Object[0]);
        LinkedHashMap function_dept_DetailedMap = new LinkedHashMap();
        LinkedHashMap function_dept_DetailedBudgetMap = new LinkedHashMap();
        String key = EMPTYSTRING;
        for (BudgetDetail detail : details) {
            key = detail.getFunction().getName() + "-" + detail.getExecutingDepartment().getCode();
            if (function_dept_DetailedBudgetMap.get(key) == null) {
                ArrayList fun_dept_dtlList = new ArrayList();
                function_dept_DetailedBudgetMap.put(key, fun_dept_dtlList);
            }
            ((List)function_dept_DetailedBudgetMap.get(key)).add(detail);
        }
        query = new StringBuffer("from BudgetDetail bd  where bd.budget.financialYear.id=" + this.getFinYear("next").getId());
        query.append(" and bd.budget.isbere='BE' ");
        if (this.budgetReport.getFunction() != null && this.budgetReport.getFunction().getId() != null && this.budgetReport.getFunction().getId() != 0L) {
            query.append("  and bd.function.id=" + this.budgetReport.getFunction().getId());
        }
        query.append(" order by function.name, executingDepartment.deptCode");
        List beDetails = this.persistenceService.findAllBy(query.toString(), new Object[0]);
        block3: for (BudgetDetail beDetail : beDetails) {
            key = beDetail.getFunction().getName() + "-" + beDetail.getExecutingDepartment().getCode();
            for (BudgetDetail reDetail : (List)function_dept_DetailedBudgetMap.get(key)) {
                BudgetReportView bv;
                String glName;
                String glcode;
                if (reDetail == null) {
                    if (beDetail.getBudgetGroup().getMajorCode() == null) {
                        glcode = this.getGlCode(beDetail);
                        beDetail.getBudgetGroup().getMinCode().getType().toString();
                        glName = this.getGlName(beDetail);
                    } else {
                        glcode = beDetail.getBudgetGroup().getMajorCode().getGlcode();
                        beDetail.getBudgetGroup().getMajorCode().getType().toString();
                        glName = beDetail.getBudgetGroup().getMajorCode().getName();
                    }
                    bv = new BudgetReportView();
                    bv.setNarration(glName);
                    bv.setDeptCode(beDetail.getExecutingDepartment().getCode());
                    bv.setGlCode(glcode);
                    bv.setFunctionCode(reDetail.getFunction().getCode());
                    bv.setReProposalAmount(reDetail.getOriginalAmount());
                    bv.setReRecomAmount(reDetail.getApprovedAmount());
                    bv.setRowStyle("typerow");
                    bv.setBeProposalAmount(beDetail.getOriginalAmount());
                    bv.setBeRecomAmount(beDetail.getApprovedAmount());
                    ((List)function_dept_DetailedMap.get(key)).add(bv);
                    continue block3;
                }
                if (!beDetail.compareTo(reDetail)) continue;
                if (function_dept_DetailedMap.get(key) == null) {
                    ArrayList fun_dept_dtlList = new ArrayList();
                    function_dept_DetailedMap.put(key, fun_dept_dtlList);
                }
                if (beDetail.getBudgetGroup().getMajorCode() == null) {
                    glcode = this.getGlCode(beDetail);
                    beDetail.getBudgetGroup().getMinCode().getType().toString();
                    glName = this.getGlName(beDetail);
                } else {
                    glcode = beDetail.getBudgetGroup().getMajorCode().getGlcode();
                    beDetail.getBudgetGroup().getMajorCode().getType().toString();
                    glName = beDetail.getBudgetGroup().getMajorCode().getName();
                }
                bv = new BudgetReportView();
                bv.setNarration(glName);
                bv.setDeptCode(beDetail.getExecutingDepartment().getCode());
                bv.setGlCode(glcode);
                bv.setFunctionCode(reDetail.getFunction().getCode());
                bv.setReProposalAmount(reDetail.getOriginalAmount());
                bv.setReRecomAmount(reDetail.getApprovedAmount());
                bv.setBeProposalAmount(beDetail.getOriginalAmount());
                bv.setBeRecomAmount(beDetail.getApprovedAmount());
                ((List)function_dept_DetailedMap.get(key)).add(bv);
                continue block3;
            }
        }
        for (String tempKey : function_deptSumMap.keySet()) {
            BudgetReportView bvHead = new BudgetReportView();
            bvHead.setNarration(((BudgetReportView)function_deptSumMap.get(tempKey)).getNarration());
            bvHead.setRowStyle("majorcodeheadingrow");
            ReportList.add(bvHead);
            ReportList.addAll((Collection)function_dept_DetailedMap.get(tempKey));
            BudgetReportView bvTotal = new BudgetReportView();
            bvTotal.setNarration(TOTALSTRING);
            bvTotal.setBeProposalAmount(((BudgetReportView)function_deptSumMap.get(tempKey)).getBeProposalAmount());
            bvTotal.setReProposalAmount(((BudgetReportView)function_deptSumMap.get(tempKey)).getReProposalAmount());
            bvTotal.setBeRecomAmount(((BudgetReportView)function_deptSumMap.get(tempKey)).getBeRecomAmount());
            bvTotal.setReRecomAmount(((BudgetReportView)function_deptSumMap.get(tempKey)).getReRecomAmount());
            bvTotal.setRowStyle(TOTALROW);
            ReportList.add(bvTotal);
        }
        return ReportList;
    }

    private List<BudgetReportView> getFunctionwiseSumForGlance() {
        ArrayList<BudgetReportView> ReportList = new ArrayList<BudgetReportView>();
        StringBuffer query = new StringBuffer("select function.name,sum(originalAmount),sum(approvedAmount)  from BudgetDetail bd  where bd.budget.financialYear.id=" + this.budgetReport.getFinancialYear().getId());
        query.append(" and bd.budget.isbere='RE' ");
        if (this.budgetReport.getFunction() != null && this.budgetReport.getFunction().getId() != null && this.budgetReport.getFunction().getId() != 0L) {
            query.append("  and bd.function.id=" + this.budgetReport.getFunction().getId());
        }
        query.append(" group by function.name order by function.name");
        List findAllBy = this.persistenceService.findAllBy(query.toString(), new Object[0]);
        for (Object[] o : findAllBy) {
            BudgetReportView bv = new BudgetReportView();
            bv.setNarration((String)o[0]);
            bv.setFunctionCode(EMPTYSTRING);
            bv.setReProposalAmount(o[1] != null ? new BigDecimal(o[1].toString()) : BigDecimal.ZERO);
            bv.setReRecomAmount(o[2] != null ? new BigDecimal(o[2].toString()) : BigDecimal.ZERO);
            bv.setRowStyle("functionrow");
            ReportList.add(bv);
        }
        query = new StringBuffer("select function.name,sum(originalAmount),sum(approvedAmount)  from BudgetDetail bd  where bd.budget.financialYear.id=" + this.getFinYear("next").getId());
        query.append(" and bd.budget.isbere='BE' ");
        if (this.budgetReport.getFunction() != null && this.budgetReport.getFunction().getId() != null && this.budgetReport.getFunction().getId() != 0L) {
            query.append("  and bd.function.id=" + this.budgetReport.getFunction().getId());
        }
        query.append(" group by function.name");
        findAllBy = this.persistenceService.findAllBy(query.toString(), new Object[0]);
        block1: for (BudgetReportView bv : ReportList) {
            for (Object[] o : findAllBy) {
                if (!bv.getNarration().equalsIgnoreCase((String)o[0])) continue;
                bv.setBeProposalAmount(o[1] != null ? new BigDecimal(o[1].toString()) : BigDecimal.ZERO);
                bv.setBeRecomAmount(o[2] != null ? new BigDecimal(o[2].toString()) : BigDecimal.ZERO);
                continue block1;
            }
        }
        return ReportList;
    }

    private CFinancialYear getFinYear(String option) {
        Calendar cal = Calendar.getInstance();
        CFinancialYear finYear = null;
        if (option.equalsIgnoreCase("previous")) {
            cal.setTime(this.budgetReport.getFinancialYear().getStartingDate());
            cal.add(5, -1);
            finYear = (CFinancialYear)this.persistenceService.find("from CFinancialYear c where c.endingDate=?", new Object[]{cal.getTime()});
            if (finYear == null) {
                throw new ValidationException(Arrays.asList(new ValidationError("next.financial.year.not.defined", "Previous financial year not defined")));
            }
        } else if (option.equalsIgnoreCase("next")) {
            cal.setTime(this.budgetReport.getFinancialYear().getEndingDate());
            cal.add(5, 1);
            finYear = (CFinancialYear)this.persistenceService.find("from CFinancialYear c where c.startingDate=?", new Object[]{cal.getTime()});
            if (finYear == null) {
                throw new ValidationException(Arrays.asList(new ValidationError("next.financial.year.not.defined", "Next financial year not defined")));
            }
        }
        return finYear;
    }

    private String getSqlForFinYear(Long finYearForRE) {
        String sql = EMPTYSTRING;
        sql = " bd.budget.financialYear.id=" + finYearForRE;
        if (this.budgetReport.getDepartment() != null && this.budgetReport.getDepartment().getId() != null) {
            sql = sql + " and bd.executingDepartment.id=" + this.budgetReport.getDepartment().getId();
        }
        if (this.budgetReport.getFunction() != null && this.budgetReport.getFunction().getId() != null) {
            sql = sql + " and bd.function.id=" + this.budgetReport.getFunction().getId();
        }
        if (this.topBudget != null) {
            sql = sql + " and bd.budget.id=" + this.topBudget.getId();
        }
        return sql;
    }

    private String getSqlForFinYearBE(Long finYearForRE) {
        String sql = EMPTYSTRING;
        sql = " bd.budget.financialYear.id=" + finYearForRE;
        if (this.budgetReport.getDepartment() != null && this.budgetReport.getDepartment().getId() != null) {
            sql = sql + " and bd.executingDepartment.id=" + this.budgetReport.getDepartment().getId();
        }
        if (this.budgetReport.getFunction() != null && this.budgetReport.getFunction().getId() != null) {
            sql = sql + " and bd.function.id=" + this.budgetReport.getFunction().getId();
        }
        if (this.topBudget != null) {
            sql = sql + " and bd.budget.referenceBudget.id=" + this.topBudget.getId();
        }
        return sql;
    }

    private Long getFinYearForRE() {
        Long finId = this.budgetReport.getFinancialYear().getId();
        Long budgetCount = (Long)this.persistenceService.find("select count(*) from Budget b where b.financialYear.id=? and b.isbere='RE'", new Object[]{finId});
        if (budgetCount == 0L) {
            Date startingDate = this.budgetReport.getFinancialYear().getStartingDate();
            Calendar cal = Calendar.getInstance();
            cal.setTime(startingDate);
            cal.add(5, -1);
            CFinancialYear prevFinyear = (CFinancialYear)this.persistenceService.find("from CFinancialYear c where c.endingDate=?", new Object[]{cal.getTime()});
            if (prevFinyear == null) {
                throw new ValidationException(Arrays.asList(new ValidationError("next.financial.year.not.defined", "Next financial year not defined")));
            }
            this.financialYearForRE = prevFinyear;
            return prevFinyear.getId();
        }
        this.financialYearForRE = this.budgetReport.getFinancialYear();
        return this.budgetReport.getFinancialYear().getId();
    }

    public void setEisCommonService(EisCommonService eisCommonService) {
        this.eisCommonService = eisCommonService;
    }

    private boolean getConsiderReAppropriationAsSeperate() {
        List appList = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "CONSIDER_RE_REAPPROPRIATION_AS_SEPARATE");
        String appValue = "-1";
        appValue = ((AppConfigValues)appList.get(0)).getValue();
        return "Y".equalsIgnoreCase(appValue);
    }
}

