/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.budget;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.util.ValueStack;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.script.ScriptContext;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.egov.commons.CFinancialYear;
import org.egov.commons.CFunction;
import org.egov.commons.Functionary;
import org.egov.commons.Fund;
import org.egov.commons.Scheme;
import org.egov.commons.SubScheme;
import org.egov.egf.model.BudgetReAppropriationView;
import org.egov.eis.service.EisCommonService;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.script.entity.Script;
import org.egov.infra.script.service.ScriptService;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infra.workflow.entity.State;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.infra.workflow.service.WorkflowService;
import org.egov.infstr.utils.EgovMasterDataCaching;
import org.egov.model.budget.Budget;
import org.egov.model.budget.BudgetDetail;
import org.egov.model.budget.BudgetGroup;
import org.egov.model.budget.BudgetReAppropriation;
import org.egov.model.budget.BudgetReAppropriationMisc;
import org.egov.pims.commons.Position;
import org.egov.pims.service.EisUtilService;
import org.egov.services.budget.BudgetDetailService;
import org.egov.services.budget.BudgetReAppropriationService;
import org.egov.services.budget.BudgetService;
import org.egov.utils.BudgetDetailConfig;
import org.egov.utils.BudgetDetailHelper;
import org.springframework.beans.factory.annotation.Autowired;

@ParentPackage(value="egov")
@Results(value={@Result(name={"approvalList"}, location="budgetReAppropriationModify-approvalList.jsp"), @Result(name={"modify"}, location="budgetReAppropriationModify-modify.jsp")})
public class BudgetReAppropriationModifyAction
extends BaseFormAction {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(BudgetReAppropriationModifyAction.class);
    @Autowired
    protected BudgetDetailConfig budgetDetailConfig;
    BudgetDetail budgetDetail;
    protected Budget budget;
    protected List<String> headerFields = new ArrayList();
    protected List<String> gridFields = new ArrayList();
    protected List<String> mandatoryFields = new ArrayList();
    BudgetDetailHelper budgetDetailHelper;
    BudgetDetailService budgetDetailService;
    BudgetReAppropriationService budgetReAppropriationService;
    WorkflowService<BudgetReAppropriation> budgetReAppropriationWorkflowService;
    CFinancialYear financialYear;
    BudgetService budgetService;
    String isBeRe = "BE";
    List<BudgetReAppropriationView> savedBudgetReAppropriationList = new ArrayList();
    @Autowired
    AppConfigValueService appConfigValuesService;
    String message = "";
    boolean deleted = false;
    BudgetReAppropriation budgetReAppropriation;
    EisCommonService eisCommonService;
    Long miscId;
    WorkflowService<BudgetReAppropriationMisc> miscWorkflowService;
    private List<Action> validActions = new ArrayList();
    private String comment = "";
    private BudgetReAppropriationMisc workFlowItem;
    private String actionName = "";
    private boolean enableApprovedAmount = false;
    private boolean enableOriginalAmount = false;
    protected EisUtilService eisService;
    private ScriptService scriptService;
    @Autowired
    private EgovMasterDataCaching masterDataCache;

    public void setMiscWorkflowService(WorkflowService<BudgetReAppropriationMisc> miscWorkflowService) {
        this.miscWorkflowService = miscWorkflowService;
    }

    public Long getMiscId() {
        return this.miscId;
    }

    public void setMiscId(Long miscId) {
        this.miscId = miscId;
    }

    public void setEisCommonService(EisCommonService eisCommonService) {
        this.eisCommonService = eisCommonService;
    }

    public BudgetReAppropriation getBudgetReAppropriation() {
        return this.budgetReAppropriation;
    }

    public void setBudgetReAppropriation(BudgetReAppropriation budgetReAppropriation) {
        this.budgetReAppropriation = budgetReAppropriation;
    }

    public String getMessage() {
        return this.message;
    }

    public void setBudgetDetailService(BudgetDetailService budgetDetailService) {
        this.budgetDetailService = budgetDetailService;
    }

    public List<BudgetReAppropriationView> getSavedBudgetReAppropriationList() {
        return this.savedBudgetReAppropriationList;
    }

    public String getIsBeRe() {
        return this.isBeRe;
    }

    public void setBudgetReAppropriationService(BudgetReAppropriationService budgetReAppropriationService) {
        this.budgetReAppropriationService = budgetReAppropriationService;
    }

    public void setIsBeRe(String beRe) {
        this.isBeRe = beRe;
    }

    public void setBudgetService(BudgetService budgetService) {
        this.budgetService = budgetService;
    }

    public void setBudgetDetailHelper(BudgetDetailHelper budgetDetailHelper) {
        this.budgetDetailHelper = budgetDetailHelper;
    }

    public void setFinancialYear(CFinancialYear financialYear) {
        this.financialYear = financialYear;
    }

    public BudgetDetail getBudgetDetail() {
        return this.budgetDetail;
    }

    public void setBudgetDetail(BudgetDetail budgetDetail) {
        this.budgetDetail = budgetDetail;
    }

    public CFinancialYear getFinancialYear() {
        return this.financialYear;
    }

    public Budget getBudget() {
        return this.budget;
    }

    public List<String> getHeaderFields() {
        return this.headerFields;
    }

    public List<String> getGridFields() {
        return this.gridFields;
    }

    public List<String> getMandatoryFields() {
        return this.mandatoryFields;
    }

    protected void setupDropdownsInHeader() {
        this.setupDropdownDataExcluding(new String[]{"subScheme"});
        this.dropdownData.put("finYearList", this.getPersistenceService().findAllBy("from CFinancialYear where isActive=true order by finYearRange desc ", new Object[0]));
        this.dropdownData.put("budgetGroupList", this.masterDataCache.get("egf-budgetGroup"));
        if (this.shouldShowField("subScheme")) {
            this.dropdownData.put("subSchemeList", Collections.EMPTY_LIST);
        }
        if (this.shouldShowField("functionary")) {
            this.dropdownData.put("functionaryList", this.masterDataCache.get("egi-functionary"));
        }
        if (this.shouldShowField("function")) {
            this.dropdownData.put("functionList", this.masterDataCache.get("egi-function"));
        }
        if (this.shouldShowField("scheme")) {
            this.dropdownData.put("schemeList", this.persistenceService.findAllBy("from Scheme where isActive=true order by name", new Object[0]));
        }
        if (this.shouldShowField("executingDepartment")) {
            this.dropdownData.put("executingDepartmentList", this.masterDataCache.get("egi-department"));
        }
        if (this.shouldShowField("fund")) {
            this.dropdownData.put("fundList", this.persistenceService.findAllBy("from Fund where isNotLeaf=0 and isActive=true order by name", new Object[0]));
        }
        if (this.shouldShowField("boundary")) {
            this.dropdownData.put("boundaryList", this.persistenceService.findAllBy("from Boundary order by name", new Object[0]));
        }
    }

    public final boolean shouldShowField(String fieldName) {
        if (this.headerFields.isEmpty() && this.gridFields.isEmpty()) {
            return true;
        }
        return this.budgetDetailConfig.shouldShowField(this.headerFields, fieldName) || this.budgetDetailConfig.shouldShowField(this.gridFields, fieldName);
    }

    public boolean shouldShowHeaderField(String fieldName) {
        return this.budgetDetailConfig.shouldShowField(this.headerFields, fieldName);
    }

    public boolean shouldShowGridField(String fieldName) {
        return this.budgetDetailConfig.shouldShowField(this.gridFields, fieldName);
    }

    public String execute() throws Exception {
        return "modify";
    }

    public void prepare() {
        super.prepare();
        this.headerFields = this.budgetDetailConfig.getHeaderFields();
        this.gridFields = this.budgetDetailConfig.getGridFields();
        this.mandatoryFields = this.budgetDetailConfig.getMandatoryFields();
        this.addRelatedEntity("budgetGroup", BudgetGroup.class);
        if (this.shouldShowField("functionary")) {
            this.addRelatedEntity("functionary", Functionary.class);
        }
        if (this.shouldShowField("function")) {
            this.addRelatedEntity("function", CFunction.class);
        }
        if (this.shouldShowField("scheme")) {
            this.addRelatedEntity("scheme", Scheme.class);
        }
        if (this.shouldShowField("subScheme")) {
            this.addRelatedEntity("subScheme", SubScheme.class);
        }
        if (this.shouldShowField("fund")) {
            this.addRelatedEntity("fund", Fund.class);
        }
        if (this.shouldShowField("executingDepartment")) {
            this.addRelatedEntity("executingDepartment", Department.class);
        }
        if (this.shouldShowField("boundary")) {
            this.addRelatedEntity("boundary", Boundary.class);
        }
        this.setupDropdownsInHeader();
        this.addDropdownData("departmentList", this.masterDataCache.get("egi-department"));
        this.addDropdownData("designationList", Collections.EMPTY_LIST);
        this.addDropdownData("userList", Collections.EMPTY_LIST);
    }

    public Object getModel() {
        return this.budgetDetail;
    }

    @Action(value="/budget/budgetReAppropriationModify-update")
    public String update() {
        for (BudgetReAppropriationView entry : this.savedBudgetReAppropriationList) {
            BudgetReAppropriation reApp = this.budgetReAppropriationService.findBySequenceNumberAndBudgetDetail(entry.getSequenceNumber(), entry.getBudgetDetail().getId());
            if ("Addition".equalsIgnoreCase(entry.changeRequestType)) {
                reApp.setOriginalAdditionAmount(entry.getDeltaAmount());
                reApp.setAdditionAmount(entry.getApprovedDeltaAmount());
            } else {
                reApp.setOriginalDeductionAmount(entry.getDeltaAmount());
                reApp.setDeductionAmount(entry.getApprovedDeltaAmount());
            }
            this.budgetReAppropriationService.persist((Object)reApp);
        }
        if (!this.savedBudgetReAppropriationList.isEmpty()) {
            this.addActionMessage(this.getText("reapp.modified.successfully"));
        }
        this.savedBudgetReAppropriationList = Collections.EMPTY_LIST;
        return "modify";
    }

    public String list() {
        this.savedBudgetReAppropriationList.clear();
        this.budgetDetail = this.budgetReAppropriationService.setRelatedValues(this.budgetDetail);
        List results = this.budgetReAppropriationService.getNonApprovedReAppByUser(ApplicationThreadLocals.getUserId(), this.budgetDetail, this.financialYear);
        for (BudgetReAppropriation row : results) {
            BudgetReAppropriationView budgetReAppropriationView = new BudgetReAppropriationView();
            budgetReAppropriationView.setBudgetDetail(row.getBudgetDetail());
            BigDecimal approvedReAppropriationsTotal = row.getBudgetDetail().getApprovedReAppropriationsTotal();
            budgetReAppropriationView.setAppropriatedAmount(approvedReAppropriationsTotal == null ? BigDecimal.ZERO.setScale(2) : approvedReAppropriationsTotal.setScale(2));
            BigDecimal actuals = this.budgetDetailHelper.getTotalActualsFor(this.budgetDetailHelper.constructParamMap(this.getValueStack(), budgetReAppropriationView.getBudgetDetail()), new Date());
            budgetReAppropriationView.setActuals(actuals.setScale(2));
            budgetReAppropriationView.setApprovedAmount(this.budgetDetail.getApprovedAmount().setScale(2));
            budgetReAppropriationView.setAvailableAmount(budgetReAppropriationView.getApprovedAmount().add(budgetReAppropriationView.getAppropriatedAmount()).subtract(budgetReAppropriationView.getActuals()).setScale(2));
            budgetReAppropriationView.setSequenceNumber(row.getReAppropriationMisc().getSequenceNumber());
            if (row.getOriginalAdditionAmount() == null || BigDecimal.ZERO.compareTo(row.getOriginalAdditionAmount()) == 0) {
                budgetReAppropriationView.setChangeRequestType("Deduction");
                budgetReAppropriationView.setDeltaAmount(row.getOriginalDeductionAmount());
                if (row.getDeductionAmount() == null || BigDecimal.ZERO.compareTo(row.getDeductionAmount()) == 0) {
                    budgetReAppropriationView.setApprovedDeltaAmount(row.getOriginalDeductionAmount() == null ? BigDecimal.ZERO : row.getOriginalDeductionAmount());
                } else {
                    budgetReAppropriationView.setApprovedDeltaAmount(row.getDeductionAmount());
                }
            } else {
                budgetReAppropriationView.setChangeRequestType("Addition");
                budgetReAppropriationView.setDeltaAmount(row.getOriginalAdditionAmount() == null ? BigDecimal.ZERO.setScale(2) : row.getOriginalAdditionAmount().setScale(2));
                if (row.getAdditionAmount() == null || BigDecimal.ZERO.compareTo(row.getAdditionAmount()) == 0) {
                    budgetReAppropriationView.setApprovedDeltaAmount(row.getOriginalAdditionAmount() == null ? BigDecimal.ZERO.setScale(2) : row.getOriginalAdditionAmount().setScale(2));
                } else {
                    budgetReAppropriationView.setApprovedDeltaAmount(row.getAdditionAmount().setScale(2));
                }
            }
            this.savedBudgetReAppropriationList.add(budgetReAppropriationView);
        }
        if (this.savedBudgetReAppropriationList.isEmpty()) {
            this.message = this.getText("no.data.found");
        }
        return "modify";
    }

    protected ValueStack getValueStack() {
        return ActionContext.getContext().getValueStack();
    }

    public String ajaxDeleteBudgetReAppropriation() {
        Long budgetDetailId = Long.valueOf(((String[])this.parameters.get("id"))[0]);
        String sequenceNumber = String.valueOf(((String[])this.parameters.get("sequenceNumber"))[0]);
        BudgetReAppropriation reApp = this.budgetReAppropriationService.findBySequenceNumberAndBudgetDetail(sequenceNumber, budgetDetailId);
        if (reApp != null) {
            this.budgetReAppropriationService.delete((Object)reApp);
            this.deleted = true;
        }
        return "deleted";
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    @Action(value="/budget/budgetReAppropriationModify-approvalList")
    public String approvalList() {
        if (this.budgetReAppropriation == null) {
            return "approvalList";
        }
        this.miscId = this.budgetReAppropriation.getReAppropriationMisc().getId();
        BudgetReAppropriationMisc misc = (BudgetReAppropriationMisc)this.persistenceService.find("from BudgetReAppropriationMisc where id=?", new Object[]{this.budgetReAppropriation.getReAppropriationMisc().getId()});
        if (!this.validateOwner(misc.getState()).booleanValue()) {
            throw new ApplicationRuntimeException("Invalid Access");
        }
        this.workFlowItem = misc;
        this.setEnablingAmounts(misc);
        this.comment = misc.getCurrentState().getComments();
        List nonApprovedReAppropriations = misc.getNonApprovedReAppropriations();
        for (BudgetReAppropriation row : nonApprovedReAppropriations) {
            BudgetReAppropriationView budgetReAppropriationView = new BudgetReAppropriationView();
            budgetReAppropriationView.setId(row.getId());
            budgetReAppropriationView.setBudgetDetail(row.getBudgetDetail());
            String actuals = this.budgetDetailHelper.getActualsFor(this.budgetDetailHelper.constructParamMap(this.getValueStack(), budgetReAppropriationView.getBudgetDetail()), new Date());
            budgetReAppropriationView.setActuals(new BigDecimal(actuals));
            budgetReAppropriationView.setApprovedAmount(row.getBudgetDetail().getApprovedAmount());
            budgetReAppropriationView.setAddedReleased(row.getBudgetDetail().getApprovedReAppropriationsTotal() == null ? BigDecimal.ZERO : row.getBudgetDetail().getApprovedReAppropriationsTotal());
            budgetReAppropriationView.setAvailableAmount(budgetReAppropriationView.getApprovedAmount().add(budgetReAppropriationView.getAddedReleased()).subtract(budgetReAppropriationView.getActuals()));
            budgetReAppropriationView.setSequenceNumber(row.getReAppropriationMisc().getSequenceNumber());
            if (row.getOriginalAdditionAmount() == null || BigDecimal.ZERO.compareTo(row.getOriginalAdditionAmount()) == 0) {
                budgetReAppropriationView.setChangeRequestType("Deduction");
                budgetReAppropriationView.setDeltaAmount(row.getOriginalDeductionAmount());
                if (row.getDeductionAmount() == null || BigDecimal.ZERO.compareTo(row.getDeductionAmount()) == 0) {
                    budgetReAppropriationView.setApprovedDeltaAmount(row.getOriginalDeductionAmount() == null ? BigDecimal.ZERO : row.getOriginalDeductionAmount());
                } else {
                    budgetReAppropriationView.setApprovedDeltaAmount(row.getDeductionAmount());
                }
            } else {
                budgetReAppropriationView.setChangeRequestType("Addition");
                budgetReAppropriationView.setDeltaAmount(row.getOriginalAdditionAmount() == null ? BigDecimal.ZERO.setScale(2) : row.getOriginalAdditionAmount().setScale(2));
                if (row.getAdditionAmount() == null || BigDecimal.ZERO.compareTo(row.getAdditionAmount()) == 0) {
                    budgetReAppropriationView.setApprovedDeltaAmount(row.getOriginalAdditionAmount() == null ? BigDecimal.ZERO.setScale(2) : row.getOriginalAdditionAmount().setScale(2));
                } else {
                    budgetReAppropriationView.setApprovedDeltaAmount(row.getAdditionAmount().setScale(2));
                }
            }
            this.savedBudgetReAppropriationList.add(budgetReAppropriationView);
            this.budgetDetail = row.getBudgetDetail();
            this.financialYear = row.getBudgetDetail().getBudget().getFinancialYear();
        }
        return "approvalList";
    }

    public boolean enableApprovedAmount() {
        return this.enableApprovedAmount;
    }

    public boolean enableOriginalAmount() {
        return this.enableOriginalAmount;
    }

    public String forward() {
        this.actionName = this.actionName.replace(",", "").replace(" ", "").trim();
        BudgetReAppropriationMisc misc = null;
        for (BudgetReAppropriationView detail : this.savedBudgetReAppropriationList) {
            BudgetReAppropriation reApp = this.budgetReAppropriationService.findBySequenceNumberAndBudgetDetail(detail.getSequenceNumber(), detail.getBudgetDetail().getId());
            misc = this.approveReApp(reApp.getReAppropriationMisc(), reApp);
        }
        this.setEnablingAmounts(misc);
        this.update();
        return "success";
    }

    public String performAction() {
        if (this.miscId != null) {
            BudgetReAppropriationMisc misc = (BudgetReAppropriationMisc)this.persistenceService.find("from BudgetReAppropriationMisc where id=?", new Object[]{this.miscId});
            if (misc != null) {
                List reApps = this.budgetReAppropriationService.findAllBy("from BudgetReAppropriation where reAppropriationMisc.id=?", new Object[]{misc.getId()});
                this.actionName = this.actionName.replace(",", "").replace(" ", "").trim();
                this.setEnablingAmounts(misc);
                if (this.actionName != null && "forward".equalsIgnoreCase(this.actionName.trim()) || this.actionName.contains("approv") || this.actionName.contains("eject") || this.actionName.contains("ancel")) {
                    for (BudgetReAppropriation detail : reApps) {
                        this.setAmounts(detail, this.getReAppById(detail.getId(), this.savedBudgetReAppropriationList));
                    }
                    misc = this.approve(misc, reApps);
                } else {
                    for (BudgetReAppropriation detail : reApps) {
                        this.setAmounts(detail, this.getReAppById(detail.getId(), this.savedBudgetReAppropriationList));
                        this.budgetReAppropriationService.persist((Object)detail);
                    }
                    this.addActionMessage(this.getText("budget.reapp.saved"));
                }
            }
            if ("END".equalsIgnoreCase(misc.getCurrentState().getValue())) {
                for (BudgetReAppropriation entry : misc.getBudgetReAppropriations()) {
                    this.budgetReAppropriationService.updatePlanningBudget(entry);
                }
            }
        }
        this.savedBudgetReAppropriationList = Collections.EMPTY_LIST;
        return "success";
    }

    private void setAmounts(BudgetReAppropriation detail, BudgetReAppropriationView reAppById) {
        if (reAppById != null) {
            if (this.enableOriginalAmount) {
                if ("Addition".equalsIgnoreCase(reAppById.getChangeRequestType())) {
                    detail.setOriginalAdditionAmount(reAppById.getDeltaAmount());
                } else {
                    detail.setOriginalDeductionAmount(reAppById.getDeltaAmount());
                }
            }
            if (this.enableApprovedAmount) {
                if ("Addition".equalsIgnoreCase(reAppById.getChangeRequestType())) {
                    detail.setAdditionAmount(reAppById.getApprovedDeltaAmount());
                } else {
                    detail.setDeductionAmount(reAppById.getApprovedDeltaAmount());
                }
            }
        }
    }

    private BudgetReAppropriationView getReAppById(Long id, List<BudgetReAppropriationView> savedBudgetReAppropriationList2) {
        for (BudgetReAppropriationView budgetReAppropriationView : savedBudgetReAppropriationList2) {
            if (id == null || !id.equals(budgetReAppropriationView.getId())) continue;
            return budgetReAppropriationView;
        }
        return null;
    }

    private void setEnablingAmounts(BudgetReAppropriationMisc misc) {
        Script script = (Script)this.persistenceService.findAllByNamedQuery("Script.findByName", new Object[]{"BudgetDetail.enable.amounts"}).get(0);
        ScriptContext scriptContext = ScriptService.createContext((Object[])new Object[]{"wfItem", misc, "persistenceService", this.budgetService});
        String value = (String)this.scriptService.executeScript(script, scriptContext);
        if ("approved".equalsIgnoreCase(value)) {
            this.enableApprovedAmount = true;
        } else if ("original".equalsIgnoreCase(value)) {
            this.enableOriginalAmount = true;
        }
    }

    private BudgetReAppropriationMisc approve(BudgetReAppropriationMisc misc, List<BudgetReAppropriation> reApps) {
        Integer userId = this.fetchUserId();
        for (BudgetReAppropriation detail : reApps) {
            this.budgetReAppropriationWorkflowService.transition(this.actionName + "|" + userId, (StateAware)detail, this.comment);
        }
        misc = this.transformAndSetActionMessage(misc, userId);
        return misc;
    }

    private BudgetReAppropriationMisc approveReApp(BudgetReAppropriationMisc misc, BudgetReAppropriation reApp) {
        Integer userId = this.fetchUserId();
        this.budgetReAppropriationWorkflowService.transition(this.actionName + "|" + userId, (StateAware)reApp, this.comment);
        misc = this.transformAndSetActionMessage(misc, userId);
        return misc;
    }

    private BudgetReAppropriationMisc transformAndSetActionMessage(BudgetReAppropriationMisc misc, Integer userId) {
        misc = this.budgetReAppropriationService.performActionOnMisc(this.actionName + "|" + userId, misc, this.comment);
        Position owner = (Position)misc.getState().getOwnerPosition();
        if (this.actionName.contains("approv")) {
            if ("END".equalsIgnoreCase(misc.getCurrentState().getValue())) {
                this.addActionMessage(this.getText("budget.reapp.approved.end"));
            } else {
                this.addActionMessage(this.getText("budget.reapp.approved") + this.budgetService.getEmployeeNameAndDesignationForPosition(owner));
            }
        } else if (this.actionName.contains("eject")) {
            this.addActionMessage(this.getText("budget.reapp.rejected") + this.budgetService.getEmployeeNameAndDesignationForPosition(owner));
        } else if (this.actionName.contains("ancel")) {
            this.addActionMessage(this.getText("budget.reapp.cancelled") + " " + this.budgetService.getEmployeeNameAndDesignationForPosition(owner));
        } else {
            this.addActionMessage(this.getText("budget.reapp.forwarded") + this.budgetService.getEmployeeNameAndDesignationForPosition(owner));
        }
        return misc;
    }

    private Integer fetchUserId() {
        Integer userId = null;
        userId = null != this.parameters.get("approverUserId") && Integer.valueOf(((String[])this.parameters.get("approverUserId"))[0]) != -1 ? Integer.valueOf(((String[])this.parameters.get("approverUserId"))[0]) : Integer.valueOf(ApplicationThreadLocals.getUserId().intValue());
        return userId;
    }

    public void setValidActions(List<Action> validActions) {
        this.validActions = validActions;
    }

    public List<Action> getValidActions() {
        return this.validActions;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getComment() {
        return this.comment;
    }

    public void setWorkFlowItem(BudgetReAppropriationMisc workFlowItem) {
        this.workFlowItem = workFlowItem;
    }

    public BudgetReAppropriationMisc getWorkFlowItem() {
        return this.workFlowItem;
    }

    public void setActionName(String actionName) {
        this.actionName = actionName;
    }

    public String getActionName() {
        return this.actionName;
    }

    public void setEnableApprovedAmount(boolean enableApprovedAmount) {
        this.enableApprovedAmount = enableApprovedAmount;
    }

    public void setEnableOriginalAmount(boolean enableOriginalAmount) {
        this.enableOriginalAmount = enableOriginalAmount;
    }

    public String capitalize(String value) {
        if (value == null || value.length() == 0) {
            return value;
        }
        return value.substring(0, 1).toUpperCase() + value.substring(1).toLowerCase();
    }

    protected Boolean validateOwner(State state) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("validating owner for user " + ApplicationThreadLocals.getUserId()));
        }
        List positionsForUser = null;
        positionsForUser = this.eisService.getPositionsForUser(ApplicationThreadLocals.getUserId(), new Date());
        if (positionsForUser.contains(state.getOwnerPosition())) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Valid Owner :return true");
            }
            return true;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Invalid  Owner :return false");
        }
        return false;
    }

    public void setEisService(EisUtilService eisService) {
        this.eisService = eisService;
    }

    public void setBudgetReAppropriationWorkflowService(WorkflowService<BudgetReAppropriation> budgetReAppropriationWorkflowService) {
        this.budgetReAppropriationWorkflowService = budgetReAppropriationWorkflowService;
    }

    public ScriptService getScriptService() {
        return this.scriptService;
    }

    public void setScriptService(ScriptService scriptService) {
        this.scriptService = scriptService;
    }
}

