/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.report;

import com.exilant.GLEngine.DayBook;
import com.exilant.eGov.src.reports.DayBookReportBean;
import com.exilant.exility.common.TaskFailedException;
import com.opensymphony.xwork2.validator.annotations.RequiredFieldValidator;
import com.opensymphony.xwork2.validator.annotations.Validations;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.commons.Fund;
import org.egov.infra.config.persistence.datasource.routing.annotation.ReadOnly;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.infstr.services.PersistenceService;
import org.hibernate.FlushMode;
import org.hibernate.Query;
import org.hibernate.transform.Transformers;
import org.hibernate.type.StringType;
import org.hibernate.type.Type;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@ParentPackage(value="egov")
@Results(value={@Result(name={"result"}, location="dayBookReport-result.jsp"), @Result(name={"search"}, location="dayBookReport-search.jsp")})
public class DayBookReportAction
extends BaseFormAction {
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    private static final long serialVersionUID = 641276108961752283L;
    private static final Logger LOGGER = Logger.getLogger(DayBookReportAction.class);
    private DayBookReportBean dayBookReport = new DayBookReportBean();
    protected DateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
    protected List<DayBook> dayBookDisplayList = new ArrayList();
    String heading = "";
    private Date todayDate = new Date();
    private String currentDate;

    public Object getModel() {
        return this.dayBookReport;
    }

    public void prepareNewForm() {
        super.prepare();
        this.persistenceService.getSession().setDefaultReadOnly(true);
        this.persistenceService.getSession().setFlushMode(FlushMode.MANUAL);
        this.addDropdownData("fundList", this.persistenceService.findAllBy(" from Fund where isactive=true and isnotleaf=false order by name", new Object[0]));
        this.currentDate = this.formatter.format(this.todayDate);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Inside  Prepare ........");
        }
    }

    @SkipValidation
    @Action(value="/report/dayBookReport-newForm")
    public String newForm() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"..Inside NewForm method..");
        }
        return "search";
    }

    @Validations(requiredFields={@RequiredFieldValidator(fieldName="startDate", message="", key="Required"), @RequiredFieldValidator(fieldName="endDate", message="", key="Required"), @RequiredFieldValidator(fieldName="fundId", message="", key="Required")})
    @ValidationErrorPage(value="search")
    @ReadOnly
    @Action(value="/report/dayBookReport-ajaxSearch")
    public String ajaxSearch() throws TaskFailedException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"dayBookAction | Search | start");
        }
        this.prepareResultList();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"dayBookAction | list | End");
        }
        this.heading = this.getGLHeading();
        this.prepareNewForm();
        this.persistenceService.getSession().setFlushMode(FlushMode.AUTO);
        return "result";
    }

    private String getQuery() {
        SimpleDateFormat sdf = new SimpleDateFormat("dd-MMM-yyyy");
        String startDate = "";
        String endDate = "";
        String fundId = "";
        fundId = this.dayBookReport.getFundId();
        try {
            startDate = sdf.format(this.formatter.parse(this.dayBookReport.getStartDate()));
            endDate = sdf.format(this.formatter.parse(this.dayBookReport.getEndDate()));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        String query = "SELECT voucherdate as vdate, TO_CHAR(voucherdate, 'dd-Mon-yyyy')  AS  voucherdate, vouchernumber as vouchernumber , gd.glcode AS glcode,ca.name AS particulars ,vh.name ||' - '|| vh.TYPE AS type, CASE WHEN vh.description is null THEN ' ' ELSE vh.description END AS narration, CASE  WHEN status=0 THEN ( 'Approved') ELSE ( case WHEN status=1 THEN 'Reversed' else (case WHEN status=2 THEN 'Reversal' else ' ' END) END ) END as status , debitamount  ,  creditamount,vh.CGVN ,vh.isconfirmed as \"isconfirmed\",vh.id as vhId FROM voucherheader vh, generalledger gd, chartofaccounts ca WHERE vh.ID=gd.VOUCHERHEADERID  AND ca.GLCODE=gd.GLCODE AND voucherdate >= '" + startDate + "' and voucherdate <= '" + endDate + "' and vh.status not in (4,5)  and vh.fundid = " + fundId + " ORDER BY vdate,vouchernumber";
        return query;
    }

    private void prepareResultList() {
        String voucherDate = "";
        String voucherNumber = "";
        String voucherType = "";
        String narration = "";
        String status = "";
        Query query = null;
        query = this.persistenceService.getSession().createSQLQuery(this.getQuery()).addScalar("voucherdate", (Type)StringType.INSTANCE).addScalar("vouchernumber", (Type)StringType.INSTANCE).addScalar("glcode", (Type)StringType.INSTANCE).addScalar("particulars", (Type)StringType.INSTANCE).addScalar("type", (Type)StringType.INSTANCE).addScalar("narration", (Type)StringType.INSTANCE).addScalar("status", (Type)StringType.INSTANCE).addScalar("creditamount", (Type)StringType.INSTANCE).addScalar("debitamount", (Type)StringType.INSTANCE).addScalar("vhId", (Type)StringType.INSTANCE).setResultTransformer(Transformers.aliasToBean(DayBook.class));
        this.dayBookDisplayList = query.list();
        for (DayBook bean : this.dayBookDisplayList) {
            bean.setDebitamount(new BigDecimal(bean.getDebitamount()).setScale(2, 6).toString());
            bean.setCreditamount(new BigDecimal(bean.getCreditamount()).setScale(2, 6).toString());
            if (voucherDate != null && !voucherDate.equalsIgnoreCase("") && voucherDate.equalsIgnoreCase(bean.getVoucherdate()) && voucherNumber.equalsIgnoreCase(bean.getVouchernumber())) {
                bean.setVoucherdate("");
            } else {
                voucherDate = bean.getVoucherdate();
            }
            if (voucherType != null && !voucherType.equalsIgnoreCase("") && voucherType.equalsIgnoreCase(bean.getType()) && voucherNumber.equalsIgnoreCase(bean.getVouchernumber())) {
                bean.setType("");
            } else {
                voucherType = bean.getType();
            }
            if (status != null && !status.equalsIgnoreCase("") && status.equalsIgnoreCase(bean.getStatus()) && voucherNumber.equalsIgnoreCase(bean.getVouchernumber())) {
                bean.setStatus("");
            } else {
                status = bean.getStatus();
            }
            if (voucherNumber != null && !voucherNumber.equalsIgnoreCase("") && voucherNumber.equalsIgnoreCase(bean.getVouchernumber())) {
                bean.setVouchernumber("");
            } else {
                voucherNumber = bean.getVouchernumber();
            }
            if (narration != null && !narration.equalsIgnoreCase("") && narration.equalsIgnoreCase(bean.getNarration())) {
                bean.setNarration("");
                continue;
            }
            narration = bean.getNarration();
        }
    }

    private String getGLHeading() {
        String heading = "Day Book report from " + this.dayBookReport.getStartDate() + " to " + this.dayBookReport.getEndDate();
        Fund fund = new Fund();
        if (this.checkNullandEmpty(this.dayBookReport.getFundId())) {
            fund = (Fund)this.persistenceService.find("from Fund where id = ?", new Object[]{Integer.parseInt(this.dayBookReport.getFundId())});
            heading = heading + " under " + fund.getName() + " ";
        }
        return heading;
    }

    private boolean checkNullandEmpty(String column) {
        return column != null && !column.isEmpty() && !column.equalsIgnoreCase("0");
    }

    public DayBookReportBean getDayBookReport() {
        return this.dayBookReport;
    }

    public void setDayBookReport(DayBookReportBean dayBookReport) {
        this.dayBookReport = dayBookReport;
    }

    public List<DayBook> getDayBookDisplayList() {
        return this.dayBookDisplayList;
    }

    public void setDayBookDisplayList(List<DayBook> dayBookDisplayList) {
        this.dayBookDisplayList = dayBookDisplayList;
    }

    public void setDayBookDisplayList(LinkedList dayBookDisplayList) {
        this.dayBookDisplayList = dayBookDisplayList;
    }

    public String getHeading() {
        return this.heading;
    }

    public void setHeading(String heading) {
        this.heading = heading;
    }

    public Date getTodayDate() {
        return this.todayDate;
    }

    public void setTodayDate(Date todayDate) {
        this.todayDate = todayDate;
    }

    public String getCurrentDate() {
        return this.currentDate;
    }

    public void setCurrentDate(String currentDate) {
        this.currentDate = currentDate;
    }
}

