/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.payment;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.JRException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.commons.Bankaccount;
import org.egov.commons.CChartOfAccounts;
import org.egov.commons.CFinancialYear;
import org.egov.commons.CFunction;
import org.egov.commons.EgwStatus;
import org.egov.commons.Fund;
import org.egov.commons.dao.FinancialYearDAO;
import org.egov.commons.service.BankAccountService;
import org.egov.commons.utils.EntityType;
import org.egov.egf.autonumber.RtgsNumberGenerator;
import org.egov.egf.commons.EgovCommon;
import org.egov.egf.model.BankAdviceReportInfo;
import org.egov.egf.web.actions.payment.BankAccountRemittanceCOA;
import org.egov.egf.web.actions.voucher.BaseVoucherAction;
import org.egov.eis.entity.DrawingOfficer;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.exception.ApplicationException;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.reporting.engine.ReportFormat;
import org.egov.infra.utils.autonumber.AutonumberServiceBeanResolver;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.infstr.services.PersistenceService;
import org.egov.model.instrument.InstrumentHeader;
import org.egov.model.instrument.InstrumentVoucher;
import org.egov.model.payment.ChequeAssignment;
import org.egov.model.payment.Paymentheader;
import org.egov.model.recoveries.Recovery;
import org.egov.model.service.RecoveryService;
import org.egov.payment.client.BankAdviceForm;
import org.egov.services.cheque.ChequeService;
import org.egov.services.contra.ContraService;
import org.egov.services.instrument.InstrumentHeaderService;
import org.egov.services.instrument.InstrumentService;
import org.egov.services.instrument.InstrumentVoucherService;
import org.egov.services.masters.BankService;
import org.egov.services.payment.ChequeAssignmentHelper;
import org.egov.services.payment.PaymentService;
import org.egov.utils.Constants;
import org.egov.utils.FinancialConstants;
import org.egov.utils.ReportHelper;
import org.egov.utils.VoucherHelper;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.transform.Transformers;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@ParentPackage(value="egov")
@Results(value={@Result(name={"search"}, location="chequeAssignment-search.jsp"), @Result(name={"view"}, location="chequeAssignment-view.jsp"), @Result(name={"viewRtgs"}, location="chequeAssignment-viewRtgs.jsp"), @Result(name={"surrenderRTGSsearch"}, location="chequeAssignment-surrenderRTGSsearch.jsp"), @Result(name={"viewReceiptDetailsResult"}, location="chequeAssignment-viewReceiptDetailsResult.jsp"), @Result(name={"before_pension_search"}, location="chequeAssignment-before_pension_search.jsp"), @Result(name={"surrenderRTGS"}, location="chequeAssignment-surrenderRTGS.jsp"), @Result(name={"viewsurrender"}, location="chequeAssignment-viewsurrender.jsp"), @Result(name={"remittanceRtgsSearch"}, location="chequeAssignment-remittanceRtgsSearch.jsp"), @Result(name={"before_remittance_search"}, location="chequeAssignment-before_remittance_search.jsp"), @Result(name={"before_salary_search"}, location="chequeAssignment-before_salary_search.jsp"), @Result(name={"searchRtgsResult"}, location="chequeAssignment-searchRtgsResult.jsp"), @Result(name={"surrendersearch"}, location="chequeAssignment-surrendersearch.jsp"), @Result(name={"searchremittance"}, location="chequeAssignment-searchremittance.jsp"), @Result(name={"searchpayment"}, location="chequeAssignment-searchpayment.jsp"), @Result(name={"surrendercheques"}, location="chequeAssignment-surrendercheques.jsp"), @Result(name={"rtgsSearch"}, location="chequeAssignment-rtgsSearch.jsp"), @Result(name={"tnebRtgsSearch"}, location="chequeAssignment-tnebRtgsSearch.jsp"), @Result(name={"bankAdvice-PDF"}, type="stream", location="inputStream", params={"inputName", "inputStream", "contentType", "application/pdf", "contentDisposition", "no-cache;filename=BandAdvice.pdf"}), @Result(name={"bankAdvice-XLS"}, type="stream", location="inputStream", params={"inputName", "inputStream", "contentType", "application/xls", "contentDisposition", "no-cache;filename=${fileName}"}), @Result(name={"bankAdvice-HTML"}, type="stream", location="inputStream", params={"inputName", "inputStream", "contentType", "text/html"})})
public class ChequeAssignmentAction
extends BaseVoucherAction {
    private static final long serialVersionUID = -3721873563220007939L;
    private static final String SURRENDERSEARCH = "surrendersearch";
    private static final String SURRENDERRTGSSEARCH = "surrenderRTGSsearch";
    private String paymentMode;
    private String inFavourOf;
    private Integer bankaccount;
    private Integer selectedRows = 0;
    private Integer bankbranch;
    private String bank_branch;
    private String bank_account;
    private Integer department;
    public Map<String, String> modeOfPaymentMap;
    private Date chequeDt;
    private boolean chequeNoGenerationAuto;
    private boolean rtgsNoGenerationAuto;
    private String typeOfAccount;
    private List<Map<String, Object>> bankbranchList;
    private String fileName;
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    @Autowired
    @Qualifier(value="paymentService")
    private PaymentService paymentService;
    @Autowired
    @Qualifier(value="chequeAssignmentHelper")
    private ChequeAssignmentHelper chequeAssignmentHelper;
    @Autowired
    @Qualifier(value="instrumentService")
    private InstrumentService instrumentService;
    @Autowired
    @Qualifier(value="instrumentHeaderService")
    private InstrumentHeaderService instrumentHeaderService;
    @Autowired
    @Qualifier(value="bankService")
    private BankService bankService;
    @Autowired
    @Qualifier(value="bankAccountService")
    private BankAccountService bankAccountService;
    private List<ChequeAssignment> chequeAssignmentList;
    private List<InstrumentHeader> instHeaderList = null;
    List<InstrumentVoucher> instVoucherList;
    List<InstrumentHeader> instVoucherDisplayList;
    private static final Logger LOGGER = Logger.getLogger(ChequeAssignmentAction.class);
    @Autowired
    private AppConfigValueService appConfigValuesService;
    private static final String JASPER_PATH = "/org/egov/payment/client/bankAdviceReport.jasper";
    InputStream inputStream;
    ReportHelper reportHelper;
    Map<String, Object> paramMap = new HashMap();
    List<Object> adviceList = new ArrayList();
    String fromDate;
    String toDate;
    private String rtgsDate;
    private String rtgsRefNo;
    private final SimpleDateFormat sdf = new SimpleDateFormat("dd-MMM-yyyy", Constants.LOCALE);
    private final SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy", Constants.LOCALE);
    private List<InstrumentVoucher> instrumentVoucherList;
    private List<InstrumentHeader> instrumentHeaderList;
    private List<InstrumentHeader> tempInstrumentHeaderList;
    @Autowired
    private AutonumberServiceBeanResolver beanResolver;
    String[] surrender;
    String instrumentNumber;
    Long recoveryId;
    private String button;
    String[] newInstrumentNumber;
    String[] newSerialNo;
    String[] newInstrumentDate;
    String[] surrendarReasons;
    private ChequeService chequeService;
    String bank_account_dept;
    private Date currentDate;
    Map<String, String> bankBranchMap = Collections.EMPTY_MAP;
    Map<String, String> billTypeMap = Collections.EMPTY_MAP;
    String billType;
    Map<String, String> bankAccountMap = Collections.EMPTY_MAP;
    @Autowired
    @Qualifier(value="remittanceRecoveryService")
    private RecoveryService recoveryService;
    Map<String, String> surrendarReasonMap = Collections.EMPTY_MAP;
    private boolean reassignSurrenderChq = false;
    private Boolean deptNonMandatory = false;
    private Boolean functionNonMandatory = false;
    private Boolean rtgsContractorAssignment = false;
    private String assignmentType = "BillPayment";
    private List<String> chequeSlNoList = new ArrayList();
    private Map chequeSlNoMap;
    Map<Bankaccount, List<ChequeAssignment>> accountNoAndRtgsEntryMap = new HashMap();
    Map<BankAccountRemittanceCOA, List<ChequeAssignment>> accountNoAndRemittanceRtgsEntryMap = new HashMap();
    Map<String, String> rtgsdateMap = new HashMap();
    Map<String, String> rtgsRefNoMap = new HashMap();
    Map<String, Boolean> rtgsSeceltedAccMap = new HashMap();
    List<ChequeAssignment> rtgsList = new LinkedList();
    List<ChequeAssignment> viewReceiptDetailsList = new ArrayList();
    public static final String RTGSAUTOGENERATIONNUMBERFORMAT = "000000";
    private final NumberFormat ackNumberFormat = new DecimalFormat("000000");
    String bankAdviceJasperPath = "/reports/templates/bankAdviceExcelReport.jasper";
    private Integer drawingOfficerId;
    private String drawingOfficerCode;
    private String billSubType;
    private String region;
    private String recoveryCode;
    private String paymentId;
    private BigDecimal totalDeductedAmount;
    private Boolean nonSubledger = false;
    private FinancialYearDAO financialYearDAO;
    private boolean containsRTGS = false;
    private List<CFinancialYear> yearCodeList;
    private Long departmentId;
    private boolean chequePrintingEnabled;
    private String chequePrintAvailableAt;
    private String instrumentHeader;
    private String chequeFormat;
    private Long instHeaderId;
    private String selectedRowsId;
    @Autowired
    private InstrumentVoucherService instrumentVoucherService;

    public List<String> getChequeSlNoList() {
        return this.chequeSlNoList;
    }

    public void setChequeSlNoList(List<String> chequeSlNoList) {
        this.chequeSlNoList = chequeSlNoList;
    }

    public String getRtgsRefNo() {
        return this.rtgsRefNo;
    }

    public void setRtgsRefNo(String rtgsRefNo) {
        this.rtgsRefNo = rtgsRefNo;
    }

    public String getRtgsDate() {
        return this.rtgsDate;
    }

    public void setRtgsDate(String rtgsDate) {
        this.rtgsDate = rtgsDate;
    }

    public String getAssignmentType() {
        return this.assignmentType;
    }

    public void setAssignmentType(String assignmentType) {
        this.assignmentType = assignmentType;
    }

    public boolean getReassignSurrenderChq() {
        return this.reassignSurrenderChq;
    }

    public void setReassignSurrenderChq(boolean reassignSurrenderChq) {
        this.reassignSurrenderChq = reassignSurrenderChq;
    }

    public Map<String, String> getSurrendarReasonMap() {
        return this.surrendarReasonMap;
    }

    public void setSurrendarReasonMap(Map<String, String> surrendarReasonMap) {
        this.surrendarReasonMap = surrendarReasonMap;
    }

    public void prepare() {
        super.prepare();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting prepare...");
        }
        this.addDropdownData("bankaccountList", Collections.EMPTY_LIST);
        this.addDropdownData("regionsList", VoucherHelper.TNEB_REGIONS);
        this.chequeNoGenerationAuto = this.paymentService.isChequeNoGenerationAuto();
        this.rtgsNoGenerationAuto = this.paymentService.isRtgsNoGenerationAuto();
        this.typeOfAccount = "PAYMENTS,RECEIPTS_PAYMENTS";
        this.currentDate = new Date();
        if (this.deptNonMandatory.booleanValue()) {
            this.mandatoryFields.remove("department");
        }
        this.mandatoryFields.remove("function");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed prepare.");
        }
    }

    @SkipValidation
    @Action(value="/payment/chequeAssignment-beforeSearch")
    public String beforeSearch() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting beforeSearch...");
        }
        this.paymentMode = "cheque";
        this.loadBillTypeMap();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed beforeSearch.");
        }
        this.mandatoryFields.remove("department");
        this.mandatoryFields.remove("function");
        this.deptNonMandatory = true;
        this.functionNonMandatory = true;
        return "search";
    }

    @SkipValidation
    @Action(value="/payment/chequeAssignment-beforeRtgsSearch")
    public String beforeRtgsSearch() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting beforeRtgsSearch...");
        }
        this.paymentMode = "rtgs";
        this.rtgsContractorAssignment = true;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed beforeRtgsSearch.");
        }
        return "rtgsSearch";
    }

    @SkipValidation
    @Action(value="/payment/chequeAssignment-beforeTNEBRtgsSearch")
    public String beforeTNEBRtgsSearch() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting beforeRtgsSearch...");
        }
        this.paymentMode = "rtgs";
        this.rtgsContractorAssignment = true;
        this.setTNEBMandatoryFields();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed beforeRtgsSearch.");
        }
        return "tnebRtgsSearch";
    }

    private void setTNEBMandatoryFields() {
        this.billType = "Expense";
        ArrayList<String> propartyAppConfigKeysList = new ArrayList<String>();
        LinkedHashMap<String, String> propartyAppConfigResultList = new LinkedHashMap<String, String>();
        propartyAppConfigKeysList.add("EB Voucher Property-Fund");
        propartyAppConfigKeysList.add("EB Voucher Property-Function");
        propartyAppConfigKeysList.add("EB Voucher Property-Department");
        propartyAppConfigKeysList.add("EB Voucher Property-BankBranch");
        propartyAppConfigKeysList.add("EB Voucher Property-BankAccount");
        for (String key : propartyAppConfigKeysList) {
            String value = null;
            try {
                List configValues = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", key);
                for (AppConfigValues appConfigVal : configValues) {
                    value = appConfigVal.getValue();
                    propartyAppConfigResultList.put(key, value);
                }
            }
            catch (Exception e) {
                throw new ApplicationRuntimeException("Appconfig value for EB Voucher propartys is not defined in the system");
            }
        }
        for (String key : propartyAppConfigResultList.keySet()) {
            if (key.equals("EB Voucher Property-Fund")) {
                this.voucherHeader.setFundId((Fund)this.persistenceService.find("from Fund where code = ?", new Object[]{propartyAppConfigResultList.get(key)}));
            }
            if (key.equals("EB Voucher Property-Function")) {
                this.voucherHeader.getVouchermis().setFunction((CFunction)this.persistenceService.find("from CFunction where code = ?", new Object[]{propartyAppConfigResultList.get(key)}));
            }
            if (key.equals("EB Voucher Property-Department")) {
                this.voucherHeader.getVouchermis().setDepartmentid((Department)this.persistenceService.find("from Department where deptCode = ?", new Object[]{propartyAppConfigResultList.get(key)}));
            }
            if (key.equals("EB Voucher Property-BankBranch")) {
                this.bank_branch = (String)propartyAppConfigResultList.get(key);
            }
            if (!key.equals("EB Voucher Property-BankAccount")) continue;
            this.bank_account = (String)propartyAppConfigResultList.get(key);
            Bankaccount ba = (Bankaccount)this.persistenceService.find(" from Bankaccount where accountnumber=?", new Object[]{this.bank_account});
            if (ba.getId() == null) continue;
            this.bankaccount = ba.getId().intValue();
        }
    }

    public void prepareBeforeRemittanceRtgsSearch() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting prepareBeforeRemittanceRtgsSearch...");
        }
        this.addDropdownData("drawingofficerList", this.getPersistenceService().findAllBy("from DrawingOfficer where id in (select drawingOfficer.id from DepartmentDOMapping) order by code", new Object[0]));
        List listRecovery = this.recoveryService.getAllActiveAutoRemitTds();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("RemitRecoveryAction | Tds list size : " + listRecovery.size()));
        }
        this.addDropdownData("recoveryList", listRecovery);
        this.paymentMode = "rtgs";
        this.rtgsContractorAssignment = true;
        if (this.deptNonMandatory.booleanValue()) {
            this.mandatoryFields.remove("department");
        }
        if (this.mandatoryFields.contains("fund")) {
            this.mandatoryFields.remove("fund");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed prepareBeforeRemittanceRtgsSearch.");
        }
    }

    @SkipValidation
    @Action(value="/payment/chequeAssignment-beforeRemittanceRtgsSearch")
    public String beforeRemittanceRtgsSearch() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting beforeRemittanceRtgsSearch...");
        }
        this.paymentMode = "rtgs";
        this.rtgsContractorAssignment = true;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed beforeRemittanceRtgsSearch.");
        }
        return "remittanceRtgsSearch";
    }

    @ValidationErrorPage(value="remittanceRtgsSearch")
    @SkipValidation
    public String searchRemittanceRTGS() throws ApplicationException, ParseException {
        Recovery recovery;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting searchRemittanceRTGS...");
        }
        List rtgsChequeAssignmentList = null;
        ArrayList<ChequeAssignment> rtgsEntry = new ArrayList<ChequeAssignment>();
        this.rtgsContractorAssignment = true;
        boolean addList = false;
        Bankaccount bnkAcc = new Bankaccount();
        new BankAccountRemittanceCOA();
        CChartOfAccounts coa = new CChartOfAccounts();
        rtgsChequeAssignmentList = this.paymentService.getPaymentVoucherForRemittanceRTGSInstrument(this.parameters, this.voucherHeader);
        for (ChequeAssignment chqAssgn : rtgsChequeAssignmentList) {
            BankAccountRemittanceCOA bnkAccCOA = new BankAccountRemittanceCOA();
            if (this.accountNoAndRemittanceRtgsEntryMap.isEmpty()) {
                rtgsEntry = new ArrayList();
                bnkAcc = (Bankaccount)this.persistenceService.find("from Bankaccount where id=?", new Object[]{Long.parseLong(chqAssgn.getBankAccountId().toString())});
                coa = (CChartOfAccounts)this.persistenceService.find("from CChartOfAccounts where id =?", new Object[]{new Long(chqAssgn.getGlcodeId().toString())});
                bnkAccCOA.setBankAccount(bnkAcc);
                bnkAccCOA.setRemittanceCOA(coa);
                rtgsEntry.add(chqAssgn);
                this.accountNoAndRemittanceRtgsEntryMap.put(bnkAccCOA, rtgsEntry);
                this.rtgsdateMap.put(bnkAcc.getId().toString(), this.formatter.format(this.currentDate));
                continue;
            }
            Set bankAccntKeySet = this.accountNoAndRemittanceRtgsEntryMap.keySet();
            for (BankAccountRemittanceCOA bkcoa : bankAccntKeySet) {
                addList = false;
                if (bkcoa.getBankAccount().getId().equals(Integer.parseInt(chqAssgn.getBankAccountId().toString())) && bkcoa.getRemittanceCOA().getId().toString().equals(chqAssgn.getGlcodeId().toString())) {
                    bnkAccCOA = bkcoa;
                    addList = false;
                    break;
                }
                addList = true;
            }
            if (!addList) {
                ((List)this.accountNoAndRemittanceRtgsEntryMap.get(bnkAccCOA)).add(chqAssgn);
                continue;
            }
            rtgsEntry = new ArrayList();
            bnkAcc = (Bankaccount)this.persistenceService.find("from Bankaccount where id=?", new Object[]{Long.parseLong(chqAssgn.getBankAccountId().toString())});
            coa = (CChartOfAccounts)this.persistenceService.find("from CChartOfAccounts where id =?", new Object[]{new Long(chqAssgn.getGlcodeId().toString())});
            bnkAccCOA.setBankAccount(bnkAcc);
            bnkAccCOA.setRemittanceCOA(coa);
            rtgsEntry.add(chqAssgn);
            this.accountNoAndRemittanceRtgsEntryMap.put(bnkAccCOA, rtgsEntry);
            this.rtgsdateMap.put(bnkAcc.getId().toString(), this.formatter.format(this.currentDate));
        }
        this.getSession().put("accountNoAndRtgsEntryMapSession", this.accountNoAndRemittanceRtgsEntryMap);
        if (0 != this.drawingOfficerId) {
            DrawingOfficer drawingOfficer = (DrawingOfficer)this.persistenceService.find("from DrawingOfficer where id =?", new Object[]{this.drawingOfficerId});
            this.drawingOfficerCode = drawingOfficer.getCode();
        }
        this.assignmentType = "BillPayment";
        if (!"".equals(((String[])this.parameters.get("recoveryId"))[0]) && (recovery = (Recovery)this.persistenceService.find("from Recovery where id=?", new Object[]{new Long(((String[])this.parameters.get("recoveryId"))[0])})).getChartofaccounts().getChartOfAccountDetails().isEmpty()) {
            this.nonSubledger = true;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed searchRemittanceRTGS.");
        }
        return "searchRemittanceRtgsResult";
    }

    @SkipValidation
    @Action(value="/payment/chequeAssignment-getReceiptDetails")
    public String getReceiptDetails() {
        Query query = null;
        query = this.persistenceService.getSession().createSQLQuery("select  vh.id as voucherid ,vh.voucherNumber as voucherNumber , redtl.remittedamt as receiptAmount,redtl.remittedamt as deductedAmount FROM voucherheader vh,eg_remittance re,eg_remittance_detail redtl,generalledger gl WHERE re.paymentvhid = " + this.paymentId + " AND re.id = redtl.remittanceid AND redtl.generalledgerid = gl.id AND gl.voucherheaderid =    vh.id group by vh.id,vh.voucherNumber,redtl.remittedamt order by vh.voucherNumber").addScalar("voucherid").addScalar("voucherNumber").addScalar("receiptAmount").addScalar("deductedAmount").setResultTransformer(Transformers.aliasToBean(ChequeAssignment.class));
        this.viewReceiptDetailsList = query.list();
        this.totalDeductedAmount = BigDecimal.ZERO;
        for (ChequeAssignment ch : this.viewReceiptDetailsList) {
            this.totalDeductedAmount = this.totalDeductedAmount.add(ch.getDeductedAmount());
        }
        return "viewReceiptDetailsResult";
    }

    public void prepareBeforeSearchForRemittance() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting prepareBeforeSearchForRemittance...");
        }
        this.paymentMode = "cash";
        if (this.getSession().get("recoveryList") == null) {
            List listRecovery = this.recoveryService.getAllActiveRecoverys();
            this.getSession().put("RecoveryList", listRecovery);
        }
        this.addDropdownData("recoveryList", (List)this.getSession().get("recoveryList"));
        this.deptNonMandatory = true;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed prepareBeforeSearchForRemittance.");
        }
    }

    public void prepareBeforeRtgsSearch() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting prepareBeforeRemittanceRtgsSearch...");
        }
        this.addDropdownData("drawingofficerList", this.getPersistenceService().findAllBy("from DrawingOfficer order by code", new Object[0]));
        this.recoveryService.getAllActiveAutoRemitTds();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting prepareBeforeRtgsSearch...");
        }
        this.paymentMode = "rtgs";
        this.rtgsContractorAssignment = true;
        if (this.deptNonMandatory.booleanValue()) {
            this.mandatoryFields.remove("department");
        }
        if (this.mandatoryFields.contains("fund")) {
            this.mandatoryFields.remove("fund");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed prepareBeforeRtgsSearch.");
        }
    }

    @SkipValidation
    @Action(value="/payment/chequeAssignment-beforeSearchForRemittance")
    public String beforeSearchForRemittance() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting beforeSearchForRemittance...");
        }
        this.paymentMode = "cash";
        this.modeOfPaymentMap = new LinkedHashMap();
        this.modeOfPaymentMap.put("cash", this.getText("cash.consolidated.cheque"));
        List listRecovery = this.recoveryService.getAllActiveRecoverys();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("RemitRecoveryAction | Tds list size : " + listRecovery.size()));
        }
        this.addDropdownData("recoveryList", listRecovery);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed beforeSearchForRemittance.");
        }
        return "before_remittance_search";
    }

    @ValidationErrorPage(value="rtgsSearch")
    @SkipValidation
    @Action(value="/payment/chequeAssignment-searchRTGS")
    public String searchRTGS() throws ApplicationException, ParseException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting searchRTGS...");
        }
        List rtgsChequeAssignmentList = null;
        List dbpRtgsAssignmentList = null;
        ArrayList<ChequeAssignment> rtgsEntry = new ArrayList<ChequeAssignment>();
        this.rtgsContractorAssignment = true;
        boolean addList = false;
        Bankaccount bnkAcc = new Bankaccount();
        Bankaccount selBnkAcc = new Bankaccount();
        HashSet bankAccSet = new HashSet();
        ArrayList bankAccntList = new ArrayList();
        ChequeAssignment obj = new ChequeAssignment();
        rtgsChequeAssignmentList = this.paymentService.getPaymentVoucherForRTGSInstrument(this.parameters, this.voucherHeader);
        dbpRtgsAssignmentList = this.paymentService.getDirectBankPaymentVoucherForRTGSInstrument(this.parameters, this.voucherHeader);
        rtgsChequeAssignmentList.addAll(dbpRtgsAssignmentList);
        if (!this.paymentMode.equals("cheque")) {
            List appList = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "cheque.assignment.infavourof");
            this.inFavourOf = ((AppConfigValues)appList.get(0)).getValue();
        }
        this.chequeDt = new Date();
        for (ChequeAssignment chqAssgn : rtgsChequeAssignmentList) {
            if (this.accountNoAndRtgsEntryMap.isEmpty()) {
                rtgsEntry = new ArrayList();
                selBnkAcc = bnkAcc = (Bankaccount)this.persistenceService.find("from Bankaccount where id=?", new Object[]{Long.parseLong(chqAssgn.getBankAccountId().toString())});
                rtgsEntry.add(chqAssgn);
                this.accountNoAndRtgsEntryMap.put(bnkAcc, rtgsEntry);
                this.rtgsdateMap.put(bnkAcc.getId().toString(), this.formatter.format(this.currentDate));
                continue;
            }
            Set bankAccntSet = this.accountNoAndRtgsEntryMap.keySet();
            for (Bankaccount bk : bankAccntSet) {
                addList = false;
                if (bk.getId().compareTo(chqAssgn.getBankAccountId().longValue()) == 0) {
                    selBnkAcc = bk;
                    addList = false;
                    break;
                }
                addList = true;
            }
            if (!addList) {
                ((List)this.accountNoAndRtgsEntryMap.get(selBnkAcc)).add(chqAssgn);
                selBnkAcc = null;
                continue;
            }
            rtgsEntry = new ArrayList();
            selBnkAcc = bnkAcc = (Bankaccount)this.persistenceService.find("from Bankaccount where id=?", new Object[]{Long.parseLong(chqAssgn.getBankAccountId().toString())});
            rtgsEntry.add(chqAssgn);
            this.accountNoAndRtgsEntryMap.put(selBnkAcc, rtgsEntry);
            this.rtgsdateMap.put(bnkAcc.getId().toString(), this.formatter.format(this.currentDate));
            selBnkAcc = null;
        }
        this.getSession().put("accountNoAndRtgsEntryMapSession", this.accountNoAndRtgsEntryMap);
        this.assignmentType = "BillPayment";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed searchRTGS.");
        }
        return "searchRtgsResult";
    }

    @SkipValidation
    public String searchTNEBRTGS() throws ApplicationException, ParseException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting searchTNEBRTGS...");
        }
        List rtgsChequeAssignmentList = null;
        ArrayList<ChequeAssignment> rtgsEntry = new ArrayList<ChequeAssignment>();
        this.rtgsContractorAssignment = true;
        boolean addList = false;
        Bankaccount bnkAcc = new Bankaccount();
        Bankaccount selBnkAcc = new Bankaccount();
        new HashSet();
        new ArrayList();
        new ChequeAssignment();
        rtgsChequeAssignmentList = this.paymentService.getPaymentVoucherForTNEBRTGSInstrument(this.parameters, this.voucherHeader);
        this.chequeDt = new Date();
        for (ChequeAssignment chqAssgn : rtgsChequeAssignmentList) {
            if (this.accountNoAndRtgsEntryMap.isEmpty()) {
                rtgsEntry = new ArrayList();
                selBnkAcc = bnkAcc = (Bankaccount)this.persistenceService.find("from Bankaccount where id=?", new Object[]{Long.parseLong(chqAssgn.getBankAccountId().toString())});
                rtgsEntry.add(chqAssgn);
                this.accountNoAndRtgsEntryMap.put(bnkAcc, rtgsEntry);
                this.rtgsdateMap.put(bnkAcc.getId().toString(), this.formatter.format(this.currentDate));
                continue;
            }
            Set bankAccntSet = this.accountNoAndRtgsEntryMap.keySet();
            for (Bankaccount bk : bankAccntSet) {
                addList = false;
                if (bk.getId().equals(Integer.parseInt(chqAssgn.getBankAccountId().toString()))) {
                    selBnkAcc = bk;
                    addList = false;
                    break;
                }
                addList = true;
            }
            if (!addList) {
                ((List)this.accountNoAndRtgsEntryMap.get(selBnkAcc)).add(chqAssgn);
                selBnkAcc = null;
                continue;
            }
            rtgsEntry = new ArrayList();
            selBnkAcc = bnkAcc = (Bankaccount)this.persistenceService.find("from Bankaccount where id=?", new Object[]{Long.parseLong(chqAssgn.getBankAccountId().toString())});
            rtgsEntry.add(chqAssgn);
            this.accountNoAndRtgsEntryMap.put(selBnkAcc, rtgsEntry);
            this.rtgsdateMap.put(bnkAcc.getId().toString(), this.formatter.format(this.currentDate));
            selBnkAcc = null;
        }
        this.getSession().put("accountNoAndRtgsEntryMapSession", this.accountNoAndRtgsEntryMap);
        this.assignmentType = "BillPayment";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed searchRTGS.");
        }
        return "searchRtgsResult";
    }

    @ValidationErrorPage(value="search")
    @Action(value="/payment/chequeAssignment-search")
    public String search() throws ApplicationException, ParseException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting search...");
        }
        this.chequeSlNoMap = this.loadChequeSerialNo(this.bankaccount);
        this.chequeAssignmentList = this.paymentService.getPaymentVoucherNotInInstrument(this.parameters, this.voucherHeader);
        if (!this.paymentMode.equals("cheque")) {
            this.chequeDt = new Date();
            List appList = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "cheque.assignment.infavourof");
            this.inFavourOf = ((AppConfigValues)appList.get(0)).getValue();
        }
        this.loadBankAndAccount();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("" + this.reassignSurrenderChq));
        }
        this.assignmentType = "BillPayment";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed search.");
        }
        return "searchpayment";
    }

    private Map<String, String> loadChequeSerialNo(Integer acc) {
        this.chequeSlNoMap = new LinkedHashMap();
        try {
            if (this.bankaccount != null) {
                if (this.department != null) {
                    List yearCodeList = this.persistenceService.findAllBy("select ac.serialNo ,fs.finYearRange from  AccountCheques ac,CFinancialYear fs,ChequeDeptMapping cd  where ac.serialNo = fs.id and  bankAccountId=?and ac.id=cd.accountCheque and cd.allotedTo=(select id from Department where id = " + this.department + ") order by serialNo desc ", new Object[]{this.bankaccount});
                    if (yearCodeList != null) {
                        for (Object[] s : yearCodeList) {
                            this.chequeSlNoMap.put(s[0], s[1]);
                        }
                    }
                } else if (this.departmentId != null) {
                    List yearCodeList = this.persistenceService.findAllBy("select ac.serialNo ,fs.finYearRange from  AccountCheques ac,CFinancialYear fs,ChequeDeptMapping cd  where ac.serialNo = fs.id and  bankAccountId=?and ac.id=cd.accountCheque and cd.allotedTo=(select id from Department where id = " + this.departmentId + ") order by serialNo desc ", new Object[]{this.bankaccount});
                    if (yearCodeList != null) {
                        for (Object[] s : yearCodeList) {
                            this.chequeSlNoMap.put(s[0], s[1]);
                        }
                    }
                } else {
                    List yearCodeList = this.persistenceService.findAllBy("select ac.serialNo ,fs.finYearRange from  AccountCheques ac,CFinancialYear fs,ChequeDeptMapping cd  where ac.serialNo = fs.id and  bankAccountId=?and ac.id=cd.accountCheque and cd.allotedTo=(select id from Department where upper(name) = 'ACCOUNTS') order by serialNo desc ", new Object[]{this.bankaccount});
                    if (yearCodeList != null) {
                        for (Object[] s : yearCodeList) {
                            this.chequeSlNoMap.put(s[0], s[1]);
                        }
                    }
                }
            }
        }
        catch (HibernateException e) {
            LOGGER.error((Object)("Exception occured while getting year code " + e.getMessage()), (Throwable)new HibernateException(e.getMessage()));
        }
        catch (Exception e) {
            LOGGER.error((Object)("Exception occured while getting year code " + e.getMessage()), (Throwable)new HibernateException(e.getMessage()));
        }
        return this.chequeSlNoMap;
    }

    public Map getChequeSlNoMap() {
        return this.chequeSlNoMap;
    }

    public void setChequeSlNoMap(Map chequeSlNoMap) {
        this.chequeSlNoMap = chequeSlNoMap;
    }

    public void prepareSearchChequesOfRemittance() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting prepareSearchChequesOfRemittance...");
        }
        this.beforeSearchForRemittance();
        this.assignmentType = "RemittancePayment";
        this.deptNonMandatory = true;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed prepareSearchChequesOfRemittance.");
        }
    }

    @ValidationErrorPage(value="before_salary_search")
    public String searchForSalaryPayments() throws ApplicationException, ParseException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting searchForSalaryPayments...");
        }
        this.voucherHeader.setName("Salary Bill Payment");
        this.loadChequeSerialNo(this.bankaccount);
        this.chequeAssignmentList = this.paymentService.getPaymentVoucherNotInInstrument(this.parameters, this.voucherHeader);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("" + this.reassignSurrenderChq));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed searchForSalaryPayments.");
        }
        return "searchsalpayment";
    }

    @ValidationErrorPage(value="before_pension_search")
    public String searchForPensionPayments() throws ApplicationException, ParseException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting searchForPensionPayments...");
        }
        this.voucherHeader.setName("Pension Bill Payment");
        this.loadChequeSerialNo(this.bankaccount);
        this.chequeAssignmentList = this.paymentService.getPaymentVoucherNotInInstrument(this.parameters, this.voucherHeader);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("" + this.reassignSurrenderChq));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed searchForSalaryPayments.");
        }
        return "searchpensionpayment";
    }

    @SkipValidation
    @Action(value="/payment/chequeAssignment-beforeSalarySearch")
    public String beforeSalarySearch() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting beforeSalarySearch...");
        }
        this.modeOfPaymentMap = new LinkedHashMap();
        this.modeOfPaymentMap.put("cash", this.getText("cash.consolidated.cheque"));
        this.modeOfPaymentMap.put("rtgs", this.getText("rtgs"));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed beforeSalarySearch.");
        }
        return "before_salary_search";
    }

    @SkipValidation
    @Action(value="/payment/chequeAssignment-beforePensionSearch")
    public String beforePensionSearch() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting beforePensionSearch...");
        }
        this.modeOfPaymentMap = new LinkedHashMap();
        this.modeOfPaymentMap.put("cash", this.getText("cash.consolidated.cheque"));
        this.modeOfPaymentMap.put("rtgs", this.getText("rtgs"));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed beforePensionSearch.");
        }
        return "before_pension_search";
    }

    public void prepareBeforeSalarySearch() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting prepareBeforeSalarySearch...");
        }
        this.paymentMode = "cash";
        this.deptNonMandatory = true;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed prepareBeforeSalarySearch.");
        }
    }

    public void prepareBeforePensionSearch() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting prepareBeforePensionSearch...");
        }
        this.paymentMode = "cash";
        this.deptNonMandatory = true;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed prepareBeforePensionSearch.");
        }
    }

    public void prepareSearchForSalaryPayments() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting prepareSearchForSalaryPayments...");
        }
        this.beforeSalarySearch();
        this.deptNonMandatory = true;
        this.assignmentType = "SalaryPayment";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed prepareSearchForSalaryPayments.");
        }
    }

    public void prepareSearchForPensionPayments() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting prepareSearchForPensionPayments...");
        }
        this.beforePensionSearch();
        this.deptNonMandatory = true;
        this.assignmentType = "PensionPayment";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed prepareSearchForPensionPayments.");
        }
    }

    @ValidationErrorPage(value="before_remittance_search")
    @Action(value="/payment/chequeAssignment-searchChequesOfRemittance")
    public String searchChequesOfRemittance() throws ApplicationException, ParseException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting searchChequesOfRemittance...");
        }
        Recovery recovery = (Recovery)this.persistenceService.find("from Recovery where id=?", new Object[]{this.recoveryId});
        this.voucherHeader.setType("Payment");
        this.voucherHeader.setName("Remittance Payment");
        this.loadChequeSerialNo(this.bankaccount);
        this.chequeAssignmentList = this.paymentService.getPaymentVoucherNotInInstrument(this.parameters, this.voucherHeader);
        this.inFavourOf = recovery != null && recovery.getRemitted() != null ? recovery.getRemitted() : "";
        this.loadBankAndAccount();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed searchChequesOfRemittance.");
        }
        return "searchremittance";
    }

    private void loadBankAndAccount() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting loadBankAndAccount...");
        }
        if (this.voucherHeader.getFundId() != null) {
            this.setTypeOfAccount(this.typeOfAccount);
            this.bankbranchList = this.bankService.getPaymentApprovedBankAndBranchName(this.voucherHeader.getFundId().getId(), this.currentDate);
            this.addDropdownData("bankbranchList", this.bankbranchList);
            this.bankBranchMap = new LinkedHashMap();
            for (Map mp : this.bankbranchList) {
                this.bankBranchMap.put((String)mp.get("bankBranchId"), (String)mp.get("bankBranchName"));
            }
        }
        if (this.getBankbranch() != null) {
            this.setTypeOfAccount(this.typeOfAccount);
            this.addDropdownData("bankaccountList", this.bankAccountService.getBankaccountsHasApprovedPayment(this.voucherHeader.getFundId().getId(), this.getBankbranch()));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed loadBankAndAccount.");
        }
    }

    @ValidationErrorPage(value="searchRtgsResult")
    @SkipValidation
    @Action(value="/payment/chequeAssignment-update")
    public String update() throws ApplicationException, ParseException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Start createInstrumentForRTGS");
        }
        Map resultMap = new HashMap();
        this.instHeaderList = new ArrayList();
        try {
            resultMap = this.prepareMapForRTGS();
            if (!this.getFieldErrors().isEmpty()) {
                this.accountNoAndRtgsEntryMap = (Map)this.getSession().get("accountNoAndRtgsEntryMapSession");
                return "searchRtgsResult";
            }
            this.createRtgsAssignment(resultMap);
        }
        catch (ValidationException e) {
            this.searchRTGS();
            LOGGER.error((Object)e.getMessage());
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.add(new ValidationError("exp", e.getMessage()));
            throw new ValidationException(e.getErrors());
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage());
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.add(new ValidationError("exp", e.getMessage()));
            throw new ValidationException(errors);
        }
        this.addActionMessage(this.getMessage("rtgs.transaction.success"));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed createInstrument.");
        }
        return "viewRtgs";
    }

    @ValidationErrorPage(value="searchpayment")
    @SkipValidation
    @Action(value="/payment/chequeAssignment-create")
    public String create() throws ApplicationException {
        Bankaccount bankAccount;
        LOGGER.error((Object)("size--------" + this.parameters.size()));
        if (!this.paymentMode.equalsIgnoreCase("cash")) {
            this.prepareChequeAssignmentList();
        }
        List printAvailConfig = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "chequeprintavailableat");
        this.chequePrintingEnabled = this.isChequePrintEnabled();
        for (AppConfigValues appConfigVal : printAvailConfig) {
            this.chequePrintAvailableAt = appConfigVal.getValue();
        }
        if (this.chequePrintAvailableAt == null) {
            this.chequePrintAvailableAt = "";
        }
        if (this.bankaccount != null && this.bankaccount != 0 && (bankAccount = (Bankaccount)this.persistenceService.find("from Bankaccount where id=?", new Object[]{this.bankaccount.longValue()})).getChequeformat() != null && !bankAccount.getChequeformat().equals("")) {
            this.chequeFormat = bankAccount.getChequeformat().getId().toString();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting createInstrument...");
        }
        this.loadChequeSerialNo(this.bankaccount);
        try {
            this.validateData();
            if (this.reassignSurrenderChq || !this.isChequeNoGenerationAuto()) {
                this.validateDataForManual();
            }
            if (this.getFieldErrors().isEmpty()) {
                this.instHeaderList = this.reassignSurrenderChq && !this.paymentMode.equalsIgnoreCase("rtgs") ? this.chequeAssignmentHelper.reassignInstrument(this.chequeAssignmentList, this.paymentMode, this.bankaccount, this.parameters, this.voucherHeader.getVouchermis().getDepartmentid()) : this.chequeAssignmentHelper.createInstrument(this.chequeAssignmentList, this.paymentMode, this.bankaccount, this.parameters, this.voucherHeader.getVouchermis().getDepartmentid());
                this.selectedRows = this.paymentService.selectedRows;
                if (this.paymentMode.equalsIgnoreCase("rtgs")) {
                    this.addActionMessage(this.getMessage("rtgs.transaction.success"));
                } else {
                    this.addActionMessage(this.getMessage("chq.assignment.transaction.success"));
                }
            } else {
                this.loadChequeSerialNo(this.bankaccount);
                return "searchpayment";
            }
            this.instVoucherList = this.paymentService.getInstVoucherList();
        }
        catch (ValidationException e) {
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.add(new ValidationError("exp", ((ValidationError)e.getErrors().get(0)).getMessage()));
            throw new ValidationException(errors);
        }
        catch (Exception e) {
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.add(new ValidationError("exp", e.getMessage()));
            throw new ValidationException(errors);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed createInstrument.");
        }
        return "view";
    }

    public List<ChequeAssignment> prepareChequeAssignmentList() {
        this.chequeAssignmentList = new ArrayList();
        String[] selectedRowsIdArray = this.selectedRowsId != null ? this.selectedRowsId.split(";,") : new String[]{};
        int length = selectedRowsIdArray.length;
        for (int i = 0; i < length; ++i) {
            ChequeAssignment chequeAssignment = new ChequeAssignment();
            String[] items = selectedRowsIdArray[i].split("\\~");
            chequeAssignment.setVoucherHeaderId(Long.valueOf(items[0]));
            chequeAssignment.setPaidTo(items[1]);
            chequeAssignment.setSerialNo(items[2]);
            chequeAssignment.setChequeNumber(items[3]);
            try {
                chequeAssignment.setChequeDate(this.formatter.parse(items[4]));
                chequeAssignment.setVoucherDate(this.formatter.parse(items[6]));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            chequeAssignment.setVoucherNumber(items[5]);
            String item = items[7];
            if (item.contains(";")) {
                item = items[7].replace(";", "");
            }
            chequeAssignment.setPaidAmount(BigDecimal.valueOf(Double.valueOf(item)));
            chequeAssignment.setIsSelected(true);
            this.chequeAssignmentList.add(chequeAssignment);
        }
        return this.chequeAssignmentList;
    }

    private void createRtgsAssignment(Map<String, List<ChequeAssignment>> resultMap) throws Exception {
        this.instVoucherList = new ArrayList();
        this.instVoucherDisplayList = new ArrayList();
        for (Map.Entry<String, List<ChequeAssignment>> row : resultMap.entrySet()) {
            String[] dateArray;
            if (row.getKey() == null || this.getRtgsSeceltedAccMap().get(row.getKey()) == null || !((Boolean)this.getRtgsSeceltedAccMap().get(row.getKey())).booleanValue()) continue;
            if (this.isRtgsNoGenerationAuto()) {
                dateArray = new String[]{(String)this.getRtgsdateMap().get(row.getKey())};
                Date rtgsdate = null;
                Date autoNoCutOffDate = FinancialConstants.RTGS_FINYEAR_WISE_ROLLING_SEQ_CUTOFF_DATE;
                String rtgsNo = "";
                if (dateArray[0] != null) {
                    String date = dateArray[0];
                    rtgsdate = this.formatter.parse(date);
                }
                String finYearRange = this.financialYearDAO.getFinancialYearByDate(rtgsdate).getFinYearRange();
                RtgsNumberGenerator r = (RtgsNumberGenerator)this.beanResolver.getAutoNumberServiceFor(RtgsNumberGenerator.class);
                if (null == autoNoCutOffDate || rtgsdate.after(autoNoCutOffDate)) {
                    rtgsNo = r.getNextNumber("RTGS_RefNumber_" + finYearRange.replace('-', '_'));
                    rtgsNo = rtgsNo + "/" + finYearRange;
                } else {
                    rtgsNo = r.getNextNumber("RTGS_RefNumber");
                }
                String[] refNoArray = new String[]{rtgsNo};
                this.parameters.put("rtgsRefNo", refNoArray);
            } else {
                String[] refNoArray = new String[]{(String)this.getRtgsRefNoMap().get(row.getKey())};
                this.parameters.put("rtgsRefNo", refNoArray);
            }
            dateArray = new String[]{(String)this.getRtgsdateMap().get(row.getKey())};
            this.parameters.put("rtgsDate", dateArray);
            this.chequeAssignmentList = resultMap.get(row.getKey());
            this.bankaccount = Integer.parseInt(row.getKey());
            this.paymentService.createInstrument(this.chequeAssignmentList, this.paymentMode, this.bankaccount, this.parameters, this.voucherHeader.getVouchermis().getDepartmentid());
            this.instVoucherList.addAll(this.paymentService.getInstVoucherList());
            ArrayList<InstrumentVoucher> tempInstVoucherList = new ArrayList<InstrumentVoucher>();
            for (InstrumentVoucher iv : this.instVoucherList) {
                Paymentheader payment = this.paymentService.getPaymentHeaderByVoucherHeaderId(iv.getVoucherHeaderId().getId());
                iv.setPaymentAmount(payment.getPaymentAmount().setScale(2, 6));
                tempInstVoucherList.add(iv);
            }
            this.instVoucherList = new ArrayList();
            this.instVoucherList = tempInstVoucherList;
        }
    }

    private Map<String, List<ChequeAssignment>> prepareMapForRTGS() throws ParseException {
        ArrayList<ChequeAssignment> ContractorbillList = new ArrayList<ChequeAssignment>();
        new ArrayList();
        new ArrayList();
        Date rtgsdate = null;
        HashMap<String, List<ChequeAssignment>> resultMap = new HashMap<String, List<ChequeAssignment>>();
        new ArrayList();
        for (ChequeAssignment chqAssgn : this.rtgsList) {
            ArrayList<ChequeAssignment> rtgsEntry;
            if (resultMap.isEmpty()) {
                rtgsEntry = new ArrayList<ChequeAssignment>();
                rtgsEntry.add(chqAssgn);
                if (chqAssgn.getBankAccountId() != null && !"".equals(chqAssgn.getBankAccountId())) {
                    resultMap.put(chqAssgn.getBankAccountId().toString(), rtgsEntry);
                }
                if (!chqAssgn.getIsSelected()) continue;
                this.rtgsSeceltedAccMap.put(chqAssgn.getBankAccountId().toString(), true);
                if (chqAssgn.getExpenditureType() != null && !"".equals(chqAssgn.getExpenditureType()) && chqAssgn.getExpenditureType().equalsIgnoreCase("Works")) {
                    ContractorbillList.add(chqAssgn);
                }
                rtgsdate = Constants.DDMMYYYYFORMAT2.parse((String)this.getRtgsdateMap().get(chqAssgn.getBankAccountId().toString()));
                if (chqAssgn.getVoucherDate().compareTo(rtgsdate) <= 0) continue;
                this.addFieldError("rtgs.date.less.than.payment.date", " RTGS Date cannot be less than Payment Date." + chqAssgn.getVoucherNumber());
                continue;
            }
            if (resultMap.containsKey(chqAssgn.getBankAccountId().toString())) {
                ((List)resultMap.get(chqAssgn.getBankAccountId().toString())).add(chqAssgn);
                if (!chqAssgn.getIsSelected()) continue;
                this.rtgsSeceltedAccMap.put(chqAssgn.getBankAccountId().toString(), true);
                if (chqAssgn.getExpenditureType() != null && !"".equals(chqAssgn.getExpenditureType()) && chqAssgn.getExpenditureType().equalsIgnoreCase("Works")) {
                    ContractorbillList.add(chqAssgn);
                }
                rtgsdate = Constants.DDMMYYYYFORMAT2.parse((String)this.getRtgsdateMap().get(chqAssgn.getBankAccountId().toString()));
                if (chqAssgn.getVoucherDate().compareTo(rtgsdate) <= 0) continue;
                this.addFieldError("rtgs.date.less.than.payment.date", "RTGS Date cannot be less than Payment Date." + chqAssgn.getVoucherNumber());
                continue;
            }
            rtgsEntry = new ArrayList();
            rtgsEntry.add(chqAssgn);
            resultMap.put(chqAssgn.getBankAccountId().toString(), rtgsEntry);
            if (!chqAssgn.getIsSelected()) continue;
            this.rtgsSeceltedAccMap.put(chqAssgn.getBankAccountId().toString(), true);
            if (chqAssgn.getExpenditureType() != null && !"".equals(chqAssgn.getExpenditureType()) && chqAssgn.getExpenditureType().equalsIgnoreCase("Works")) {
                ContractorbillList.add(chqAssgn);
            }
            rtgsdate = Constants.DDMMYYYYFORMAT2.parse((String)this.getRtgsdateMap().get(chqAssgn.getBankAccountId().toString()));
            if (chqAssgn.getVoucherDate().compareTo(rtgsdate) <= 0) continue;
            this.addFieldError("rtgs.date.less.than.payment.date", "RTGS Date cannot be less than Payment Date." + chqAssgn.getVoucherNumber());
        }
        try {
            this.paymentService.validatePaymentForRTGSAssignment(ContractorbillList, "Contractor");
        }
        catch (ValidationException e) {
            this.accountNoAndRtgsEntryMap = (Map)this.getSession().get("accountNoAndRtgsEntryMap");
            this.addFieldError("rtgs.payment.mandatory.details.missing", ((ValidationError)e.getErrors().get(0)).getMessage());
        }
        catch (ApplicationException e) {
            this.accountNoAndRtgsEntryMap = (Map)this.getSession().get("accountNoAndRtgsEntryMap");
            this.addFieldError("rtgs.payment.mandatory.details.missing", e.getMessage());
        }
        return resultMap;
    }

    @ValidationErrorPage(value="searchsalpayment")
    @SkipValidation
    public String createInstrumentForSalaryPayment() throws ApplicationException, ParseException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting createInstrumentForSalaryPayment...");
        }
        this.loadChequeSerialNo(this.bankaccount);
        try {
            this.validateData();
            if (this.reassignSurrenderChq || !this.isChequeNoGenerationAuto()) {
                this.validateDataForManual();
            }
            if (this.getFieldErrors().isEmpty()) {
                this.instHeaderList = this.reassignSurrenderChq && !this.paymentMode.equalsIgnoreCase("rtgs") ? this.paymentService.reassignInstrument(this.chequeAssignmentList, this.paymentMode, this.bankaccount, this.parameters, this.voucherHeader.getVouchermis().getDepartmentid()) : this.paymentService.createInstrument(this.chequeAssignmentList, this.paymentMode, this.bankaccount, this.parameters, this.voucherHeader.getVouchermis().getDepartmentid());
                this.selectedRows = this.paymentService.selectedRows;
                if (this.paymentMode.equalsIgnoreCase("rtgs")) {
                    this.addActionMessage(this.getMessage("rtgs.transaction.success"));
                } else {
                    this.addActionMessage(this.getMessage("chq.assignment.transaction.success"));
                }
            } else {
                this.loadChequeSerialNo(this.bankaccount);
                return "searchsalpayment";
            }
            this.instVoucherList = this.paymentService.getInstVoucherList();
        }
        catch (ValidationException e) {
            throw new ValidationException(e.getErrors());
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage());
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.add(new ValidationError("exp", e.getMessage()));
            throw new ValidationException(errors);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed createInstrumentForSalaryPayment.");
        }
        if (this.paymentMode.equalsIgnoreCase("rtgs")) {
            this.prepareBeforeSalarySearch();
            this.beforeSalarySearch();
            this.mandatoryFields.remove("department");
            return "before_salary_search";
        }
        return "view";
    }

    @ValidationErrorPage(value="searchpensionpayment")
    @SkipValidation
    public String createInstrumentForPensionPayment() throws ApplicationException, ParseException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting createInstrumentForPensionPayment...");
        }
        this.loadChequeSerialNo(this.bankaccount);
        try {
            this.validateData();
            if (this.reassignSurrenderChq || !this.isChequeNoGenerationAuto()) {
                this.validateDataForManual();
            }
            if (this.getFieldErrors().isEmpty()) {
                this.instHeaderList = this.reassignSurrenderChq && !this.paymentMode.equalsIgnoreCase("rtgs") ? this.paymentService.reassignInstrument(this.chequeAssignmentList, this.paymentMode, this.bankaccount, this.parameters, this.voucherHeader.getVouchermis().getDepartmentid()) : this.paymentService.createInstrument(this.chequeAssignmentList, this.paymentMode, this.bankaccount, this.parameters, this.voucherHeader.getVouchermis().getDepartmentid());
                this.selectedRows = this.paymentService.selectedRows;
                if (this.paymentMode.equalsIgnoreCase("rtgs")) {
                    this.addActionMessage(this.getMessage("rtgs.transaction.success"));
                } else {
                    this.addActionMessage(this.getMessage("chq.assignment.transaction.success"));
                }
            } else {
                this.loadChequeSerialNo(this.bankaccount);
                return "searchpensionpayment";
            }
            this.instVoucherList = this.paymentService.getInstVoucherList();
        }
        catch (ValidationException e) {
            throw new ValidationException(e.getErrors());
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage());
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.add(new ValidationError("exp", e.getMessage()));
            throw new ValidationException(errors);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed createInstrumentForPensionPayment.");
        }
        if (this.paymentMode.equalsIgnoreCase("rtgs")) {
            this.prepareBeforePensionSearch();
            this.beforePensionSearch();
            this.mandatoryFields.remove("department");
            return "before_pension_search";
        }
        return "view";
    }

    public void generateAdvice() throws Exception {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting generateAdvice...");
        }
        EntityType entity = null;
        String voucherno = "";
        InstrumentHeader instrumentHeader = (InstrumentHeader)this.persistenceService.find("from InstrumentHeader where id=?", new Object[]{Long.valueOf(((String[])this.parameters.get("instHeaderId"))[0])});
        for (InstrumentVoucher instrumentVoucher : instrumentHeader.getInstrumentVouchers()) {
            Object[] obj = (Object[])this.persistenceService.find(" select gld.detailTypeId.id,gld.detailKeyId,gld.amount from CGeneralLedgerDetail gld,CGeneralLedger gl where gl.id=gld.generalLedgerId.id and gl.voucherHeaderId=?", new Object[]{instrumentVoucher.getVoucherHeaderId()});
            if (obj == null) continue;
            entity = this.paymentService.getEntity((Integer)obj[0], (Serializable)obj[1]);
            BankAdviceForm baf = new BankAdviceForm();
            baf.setContractorCode(entity.getCode());
            baf.setContractorName(entity.getName());
            baf.setBankName(entity.getBankname());
            baf.setBankAccountNo(entity.getBankaccount());
            baf.setIfscCode(entity.getIfsccode());
            baf.setNetAmount((BigDecimal)obj[2]);
            voucherno = voucherno + instrumentVoucher.getVoucherHeaderId().getVoucherNumber() + ",";
            this.adviceList.add(baf);
        }
        if (this.adviceList.size() != 0) {
            voucherno = voucherno.substring(0, voucherno.length() - 1);
            this.paramMap.put("chequeNo", instrumentHeader.getInstrumentNumber());
            this.paramMap.put("chequeDate", this.paymentService.formatter.format(instrumentHeader.getInstrumentDate()));
            this.paramMap.put("pymtVhNo", voucherno);
            this.paramMap.put("inFavourOf", instrumentHeader.getPayTo());
            this.paramMap.put("pymtBank", instrumentHeader.getBankAccountId().getBankbranch().getBank().getName() + "-" + instrumentHeader.getBankAccountId().getBankbranch().getBranchname());
            this.paramMap.put("pymtAcNo", instrumentHeader.getBankAccountId().getAccountnumber());
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed generateAdvice.");
        }
    }

    public void validateData() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting validateData...");
        }
        if (this.paymentMode.equalsIgnoreCase("rtgs")) {
            if (!this.rtgsContractorAssignment.booleanValue()) {
                if (this.rtgsRefNo == null || this.rtgsRefNo.equalsIgnoreCase("")) {
                    this.addFieldError("rtgsrefno", this.getMessage("rtgs.refno.empty"));
                }
                if (this.rtgsDate == null || this.rtgsDate.equalsIgnoreCase("")) {
                    this.addFieldError("rtgsdate", this.getMessage("rtgs.date.empty"));
                }
            }
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed validateData.");
        }
        this.checkMandatory("vouchermis.departmentid", "department", (Object)this.voucherHeader.getVouchermis().getDepartmentid(), "voucher.department.mandatory");
    }

    @SkipValidation
    @Action(value="/payment/chequeAssignment-beforeSearchForSurrender")
    public String beforeSearchForSurrender() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting beforeSearchForSurrender...");
        }
        this.addDropdownData("bankaccountList", Collections.EMPTY_LIST);
        this.loadBankAndAccounForSurender();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed beforeSearchForSurrender.");
        }
        return SURRENDERSEARCH;
    }

    @SkipValidation
    @Action(value="/payment/chequeAssignment-beforeSearchForRTGSSurrender")
    public String beforeSearchForRTGSSurrender() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting beforeSearchForSurrender...");
        }
        this.addDropdownData("bankaccountList", Collections.EMPTY_LIST);
        this.loadBankAndAccounForRTGSSurender();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed beforeSearchForSurrender.");
        }
        return SURRENDERRTGSSEARCH;
    }

    @SkipValidation
    @ValidationErrorPage(value="surrendersearch")
    @Action(value="/payment/chequeAssignment-searchChequesForSurrender")
    public String searchChequesForSurrender() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting searchChequesForSurrender...");
        }
        this.validateForSuurenderSearch();
        if (this.getFieldErrors().size() > 0) {
            if (this.bank_branch != null && !this.bank_branch.equals("-1")) {
                this.addDropdownData("bankaccountList", this.persistenceService.findAllBy(" from Bankaccount where bankbranch.id=? and isactive=true ", new Object[]{Integer.valueOf(this.bank_branch.split("-")[1])}));
            }
            this.loadReasonsForSurrendaring();
            return this.beforeSearchForSurrender();
        }
        StringBuffer sql = new StringBuffer();
        try {
            if (!"".equals(this.fromDate)) {
                sql.append(" and iv.voucherHeaderId.voucherDate>='" + this.sdf.format(this.formatter.parse(this.fromDate)) + "' ");
            }
            if (!"".equals(this.toDate)) {
                sql.append(" and iv.voucherHeaderId.voucherDate<='" + this.sdf.format(this.formatter.parse(this.toDate)) + "'");
            }
            if (this.bankaccount != null && this.bankaccount != -1) {
                sql.append(" and  ih.bankAccountId.id=" + this.bankaccount);
            }
            if (this.instrumentNumber != null && !this.instrumentNumber.isEmpty()) {
                sql.append(" and  ih.instrumentNumber='" + this.instrumentNumber + "'");
            }
            if (this.department != null && this.department != -1) {
                sql.append(" and  iv.voucherHeaderId.vouchermis.departmentid.id=" + this.department);
            }
            if (this.voucherHeader.getVoucherNumber() != null && !this.voucherHeader.getVoucherNumber().isEmpty()) {
                sql.append(" and  iv.voucherHeaderId.voucherNumber='" + this.voucherHeader.getVoucherNumber() + "'");
            }
            String mainquery = "select ih from  InstrumentVoucher iv ,InstrumentHeader ih ,InstrumentType it where iv.instrumentHeaderId.id =ih.id and ih.instrumentNumber is not null and ih.instrumentType=it.id and ( it.type = 'cheque' or it.type = 'cash' ) and   iv.voucherHeaderId.status=0  and iv.voucherHeaderId.type='Payment'  " + sql + "  and ih.statusId.id in (?)  order by iv.voucherHeaderId.voucherDate";
            EgwStatus created = this.instrumentService.getStatusId("New");
            this.instrumentHeaderList = this.persistenceService.findAllBy(mainquery, new Object[]{created.getId()});
            LinkedHashSet lhs = new LinkedHashSet();
            lhs.addAll(this.instrumentHeaderList);
            this.instrumentHeaderList.clear();
            this.instrumentHeaderList.addAll(lhs);
            this.instrumentVoucherList = new ArrayList();
            for (InstrumentHeader ih : this.instrumentHeaderList) {
                this.instrumentVoucherList.addAll(ih.getInstrumentVouchers());
            }
            this.getSession().put("instrumentVoucherList", this.instrumentVoucherList);
            this.getSession().put("instrumentHeaderList", this.instrumentHeaderList);
            if (this.instrumentVoucherList.size() > 0) {
                this.loadReasonsForSurrendaring();
                this.loadChequeSerialNo(this.bankaccount);
            }
        }
        catch (ParseException e) {
            LOGGER.error((Object)e.getMessage());
            throw new ValidationException(Arrays.asList(new ValidationError("Unparsable Date", "Unparsable Date")));
        }
        this.getheader();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed searchChequesForSurrender.");
        }
        this.containsRTGS = false;
        return "surrendercheques";
    }

    @SkipValidation
    @ValidationErrorPage(value="surrenderRTGSsearch")
    @Action(value="/payment/chequeAssignment-searchForRTGSSurrender")
    public String searchForRTGSSurrender() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting searchRTGSForSurrender...");
        }
        this.validateForSuurenderSearch();
        if (this.getFieldErrors().size() > 0) {
            if (this.bank_branch != null && !this.bank_branch.equals("-1")) {
                this.addDropdownData("bankaccountList", this.persistenceService.findAllBy(" from Bankaccount where bankbranch.id=? and isactive=true ", new Object[]{Integer.valueOf(this.bank_branch.split("-")[1])}));
            }
            this.loadReasonsForSurrendaring();
            return this.beforeSearchForRTGSSurrender();
        }
        StringBuffer sql = new StringBuffer();
        try {
            if (!"".equals(this.fromDate)) {
                sql.append(" and iv.voucherHeaderId.voucherDate>='" + this.sdf.format(this.formatter.parse(this.fromDate)) + "' ");
            }
            if (!"".equals(this.toDate)) {
                sql.append(" and iv.voucherHeaderId.voucherDate<='" + this.sdf.format(this.formatter.parse(this.toDate)) + "'");
            }
            if (this.bankaccount != null && this.bankaccount != -1) {
                sql.append(" and  ih.bankAccountId.id=" + this.bankaccount);
            }
            if (this.instrumentNumber != null && !this.instrumentNumber.isEmpty()) {
                sql.append(" and  ih.transactionNumber='" + this.instrumentNumber + "'");
            }
            if (this.department != null && this.department != -1) {
                sql.append(" and  iv.voucherHeaderId.vouchermis.departmentid.id=" + this.department);
            }
            if (this.voucherHeader.getVoucherNumber() != null && !this.voucherHeader.getVoucherNumber().isEmpty()) {
                sql.append(" and  iv.voucherHeaderId.voucherNumber='" + this.voucherHeader.getVoucherNumber() + "'");
            }
            String mainquery = "select ih from  InstrumentVoucher iv,InstrumentHeader ih ,InstrumentType it where iv.instrumentHeaderId.id =ih.id and ih.transactionNumber is not null and ih.instrumentType=it.id and it.type = 'advice' and   iv.voucherHeaderId.status=0  and iv.voucherHeaderId.type='Payment'  " + sql + "  and ih.statusId.id in (?)  order by iv.voucherHeaderId.voucherDate";
            EgwStatus created = this.instrumentService.getStatusId("New");
            this.instrumentHeaderList = this.persistenceService.findAllBy(mainquery, new Object[]{created.getId()});
            LinkedHashSet lhs = new LinkedHashSet();
            lhs.addAll(this.instrumentHeaderList);
            this.instrumentHeaderList.clear();
            this.instrumentHeaderList.addAll(lhs);
            this.instrumentVoucherList = new ArrayList();
            for (InstrumentHeader ih : this.instrumentHeaderList) {
                this.instrumentVoucherList.addAll(ih.getInstrumentVouchers());
            }
            this.getSession().put("instrumentVoucherList", this.instrumentVoucherList);
            this.getSession().put("instrumentHeaderList", this.instrumentHeaderList);
            if (this.instrumentVoucherList.size() > 0) {
                this.loadReasonsForSurrendaring();
            }
            this.loadChequeSerialNo(this.bankaccount);
        }
        catch (ParseException e) {
            LOGGER.error((Object)e.getMessage());
            throw new ValidationException(Arrays.asList(new ValidationError("Unparsable Date", "Unparsable Date")));
        }
        this.getheader();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed searchRTGSForSurrender.");
        }
        return "surrenderRTGS";
    }

    private void loadReasonsForSurrendaring() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting loadReasonsForSurrendaring...");
        }
        this.surrendarReasonMap = new LinkedHashMap();
        List appConfigValuesList = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "Reason For Cheque Surrendaring");
        for (AppConfigValues app : appConfigValuesList) {
            String value = app.getValue();
            if (app.getValue().indexOf(124) != -1) {
                this.surrendarReasonMap.put(app.getValue(), value.substring(0, app.getValue().indexOf(124)));
                continue;
            }
            this.surrendarReasonMap.put(app.getValue(), app.getValue());
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed loadReasonsForSurrendaring.");
        }
    }

    private void loadBankAndAccounForSurender() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting loadBankAndAccounForSurender...");
        }
        this.setTypeOfAccount(this.typeOfAccount);
        this.addDropdownData("bankbranchList", this.bankService.getChequeAssignedBankAndBranchName(this.currentDate));
        if (this.getBankbranch() != null) {
            this.addDropdownData("bankaccountList", this.bankAccountService.getBankaccountsWithAssignedCheques(this.getBankbranch(), null, this.currentDate));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed loadBankAndAccounForSurender.");
        }
    }

    private void loadBankAndAccounForRTGSSurender() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting loadBankAndAccounForSurender...");
        }
        this.setTypeOfAccount(this.typeOfAccount);
        this.addDropdownData("bankbranchList", this.bankService.getRTGSAssignedBankAndBranchName(this.currentDate));
        if (this.getBankbranch() != null) {
            this.addDropdownData("bankaccountList", this.bankAccountService.getBankaccountsWithAssignedRTGS(this.getBankbranch(), this.currentDate));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed loadBankAndAccounForSurender.");
        }
    }

    private void getheader() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting getheader...");
        }
        Bankaccount account = (Bankaccount)this.persistenceService.find("from Bankaccount where id=?", new Object[]{this.bankaccount.longValue()});
        this.bank_account_dept = account.getBankbranch().getBank().getName() + "-" + account.getBankbranch().getBranchname() + "-" + account.getAccountnumber();
        if (this.department != null && this.department != -1) {
            Department dept = (Department)this.persistenceService.find("from Department where id=?", new Object[]{this.department.longValue()});
            this.bank_account_dept = this.bank_account_dept + "-" + dept.getName();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed getheader.");
        }
    }

    @SkipValidation
    private void validateForSuurenderSearch() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting validateForSuurenderSearch...");
        }
        if (this.bankaccount == null || this.bankaccount == -1) {
            this.addFieldError("bankaccount", this.getMessage("bankaccount.empty"));
        }
        if (this.bank_branch == null || this.bank_branch.equals("-1")) {
            this.addFieldError("bankbranch", this.getMessage("bankbranch.empty"));
        }
        if (this.isFieldMandatory("department") && (null == this.department || this.department == -1)) {
            this.addFieldError("department", this.getMessage("validate.department.null"));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed validateForSuurenderSearch.");
        }
    }

    @ValidationErrorPage(value="surrendercheques")
    @SkipValidation
    @Action(value="/payment/chequeAssignment-save")
    public String save() {
        block23: {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Starting surrenderCheques...");
            }
            StringBuffer reasonMissingRows = new StringBuffer(50);
            this.prepareInstrumentList();
            this.loadBankAndAccount();
            this.loadReasonsForSurrendaring();
            this.loadChequeSerialNo(this.bankaccount);
            try {
                if (this.surrender == null) {
                    if (this.containsRTGS) {
                        this.addActionError("Please select atleast one Cheque for Surrendering");
                        return this.searchForRTGSSurrender();
                    }
                    throw new ValidationException(Arrays.asList(new ValidationError("Exception while surrender Cheque ", "Please select atleast one Cheque for Surrendering ")));
                }
                ArrayList<InstrumentHeader> suurenderChequelist = new ArrayList<InstrumentHeader>();
                ArrayList<String> chequeNoList = new ArrayList<String>();
                ArrayList<String> serialNoList = new ArrayList<String>();
                ArrayList<Date> chequeDateList = new ArrayList<Date>();
                InstrumentHeader instrumentHeader = null;
                if (null == this.department || -1 == this.department) {
                    throw new ValidationException(Arrays.asList(new ValidationError("Exception while surrender Cheque ", "please select department")));
                }
                int j = 0;
                this.instrumentHeaderList = (List)this.getSession().get("instrumentHeaderList");
                String[] newSurrender = new String[this.instrumentHeaderList.size()];
                for (InstrumentHeader iheader : this.instrumentHeaderList) {
                    newSurrender[j] = null;
                    for (String ih : this.surrender) {
                        if (!ih.equalsIgnoreCase(iheader.getId().toString())) continue;
                        newSurrender[j] = ih;
                    }
                    ++j;
                }
                this.surrender = newSurrender;
                if (this.surrender != null && this.surrender.length > 0) {
                    int i;
                    for (i = 0; i < this.surrender.length; ++i) {
                        instrumentHeader = this.surrender[i] == null ? null : (InstrumentHeader)this.persistenceService.find("from InstrumentHeader where id=?", new Object[]{Long.valueOf(this.surrender[i])});
                        if (instrumentHeader != null && (this.surrendarReasons[i] == null || this.surrendarReasons[i].equalsIgnoreCase("-1"))) {
                            reasonMissingRows.append(i + 1);
                            reasonMissingRows.append(",");
                        }
                        if (instrumentHeader == null) continue;
                        instrumentHeader.setSurrendarReason(this.surrendarReasons[i]);
                        suurenderChequelist.add(instrumentHeader);
                        if (instrumentHeader.getTransactionNumber() == null) continue;
                        this.containsRTGS = true;
                    }
                    if (!reasonMissingRows.toString().isEmpty()) {
                        if (this.containsRTGS) {
                            this.addActionError("please select the Reason for Surrendering the cheque for selected  rows");
                            return this.searchForRTGSSurrender();
                        }
                        throw new ValidationException(Arrays.asList(new ValidationError("Exception while surrender Cheque ", "please select the Reason for Surrendering the cheque for selected  rows")));
                    }
                    this.instrumentService.surrenderCheques(suurenderChequelist);
                    if (this.button.equalsIgnoreCase("surrenderAndReassign") && this.containsRTGS) {
                        throw new ValidationException(Arrays.asList(new ValidationError("Cannot reassign RTGS Numbers. Use RTGS Screen ", "Cannot reassign RTGS Numbers. Use RTGS Screen")));
                    }
                    if (this.button.equalsIgnoreCase("surrenderAndReassign") && !this.containsRTGS) {
                        for (i = 0; i < this.surrender.length; ++i) {
                            if (this.surrender[i] == null) continue;
                            if (!this.isChequeNoGenerationAuto()) {
                                chequeNoList.add(this.newInstrumentNumber[i]);
                                serialNoList.add(this.newSerialNo[i]);
                                try {
                                    chequeDateList.add(this.formatter.parse(this.newInstrumentDate[i]));
                                    continue;
                                }
                                catch (ParseException e) {
                                    throw new ValidationException(Arrays.asList(new ValidationError("Exception while formatting ChequeDate ", "TRANSACTION_FAILED")));
                                }
                            }
                            chequeNoList.add(this.getNewChequenumbers(instrumentHeader, this.department));
                            chequeDateList.add(new Date());
                        }
                        if (!this.isChequeNoGenerationAuto()) {
                            this.validateNewChequeNumbers(suurenderChequelist, chequeNoList, this.department, serialNoList);
                            if (this.getFieldErrors().size() > 0) {
                                throw new ValidationException(Arrays.asList(new ValidationError("TRANSACTION FAILED", "TRANSACTION FAILED")));
                            }
                        }
                        this.paymentMode = "cheque";
                        this.instHeaderList = this.addNewInstruments(suurenderChequelist, chequeNoList, chequeDateList, serialNoList);
                        this.addActionMessage(this.getMessage("surrender.reassign.succesful"));
                    } else {
                        this.instHeaderList = suurenderChequelist;
                        this.paymentMode = "cheque";
                        this.addActionMessage(this.getMessage("surrender.succesful"));
                    }
                    break block23;
                }
                throw new ValidationException(Arrays.asList(new ValidationError("Exception while surrender ChequeDate ", "please select at least one cheque")));
            }
            catch (ValidationException e) {
                this.instrumentVoucherList = (List)this.getSession().get("instrumentVoucherList");
                this.instrumentHeaderList = (List)this.getSession().get("instrumentHeaderList");
                this.getheader();
                throw e;
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed surrenderCheques.");
        }
        return "viewsurrender";
    }

    private List<InstrumentHeader> prepareInstrumentList() {
        String[] selectedArray = this.selectedRowsId.split(";,");
        if (!this.selectedRowsId.isEmpty()) {
            this.instrumentHeaderList = new ArrayList();
            int length = selectedArray.length;
            for (int i = 0; i < length; ++i) {
                InstrumentHeader instrumentsHeader = new InstrumentHeader();
                String[] items = selectedArray[i].split("\\~");
                if (items[0] != null && !items[0].isEmpty()) {
                    instrumentsHeader.setId(Long.valueOf(items[0]));
                }
                if (items[1] != null && !items[1].isEmpty()) {
                    instrumentsHeader.setInstrumentNumber(items[1]);
                }
                try {
                    if (items[2] != null && !items[2].isEmpty()) {
                        instrumentsHeader.setInstrumentDate(this.formatter.parse(items[2]));
                    }
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                if (items[3] != null && !items[3].isEmpty()) {
                    instrumentsHeader.setSerialNo(this.financialYearDAO.findById((Number)Long.valueOf(items[3]), false));
                }
                if (items[4] != null && !items[4].isEmpty()) {
                    String item = items[4];
                    if (item.contains(";")) {
                        item = items[4].replace(";", "");
                    }
                    instrumentsHeader.setSurrendarReason(item);
                }
                this.instrumentHeaderList.add(instrumentsHeader);
            }
        }
        return this.instrumentHeaderList;
    }

    private String getNewChequenumbers(InstrumentHeader instrumentHeader, Integer department) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting getNewChequenumbers...");
        }
        return this.chequeService.nextChequeNumber(instrumentHeader.getBankAccountId().getId().toString(), 1, department.intValue());
    }

    private List<InstrumentHeader> addNewInstruments(List<InstrumentHeader> suurenderChequelist, List<String> chequeNoList, List<Date> chequeDatelist, List<String> serialNoList) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting addNewInstruments...");
        }
        HashMap<String, Object> instrumentVoucherMap = null;
        ArrayList instrumentVoucherList = new ArrayList();
        this.instHeaderList = new ArrayList();
        int i = 0;
        for (InstrumentHeader instrumentHeader : suurenderChequelist) {
            InstrumentHeader newInstrumentHeader = instrumentHeader.clone();
            newInstrumentHeader.setInstrumentNumber(chequeNoList.get(i).toString());
            newInstrumentHeader.setSerialNo(this.financialYearDAO.findById((Number)Long.valueOf(serialNoList.get(i).toString()), false));
            newInstrumentHeader.setStatusId(this.instrumentService.getStatusId("New"));
            newInstrumentHeader.setInstrumentDate(chequeDatelist.get(i));
            ++i;
            this.instHeaderList.add(this.instrumentHeaderService.persist((Object)newInstrumentHeader));
            Set instrumentVouchers = instrumentHeader.getInstrumentVouchers();
            for (InstrumentVoucher iv : instrumentVouchers) {
                instrumentVoucherMap = new HashMap<String, Object>();
                instrumentVoucherMap.put("Voucher header", iv.getVoucherHeaderId());
                instrumentVoucherMap.put("Instrument header", newInstrumentHeader);
                instrumentVoucherList.add(instrumentVoucherMap);
            }
        }
        this.instVoucherList = this.instrumentService.updateInstrumentVoucherReference(instrumentVoucherList);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed addNewInstruments.");
        }
        return this.instHeaderList;
    }

    private void validateNewChequeNumbers(List<InstrumentHeader> suurenderChequelist, List<String> chequeNoList, Integer department, List<String> serialNoList) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting validateNewChequeNumbers...");
        }
        if (this.newInstrumentNumber != null && this.newInstrumentNumber.length > 0) {
            int i = 0;
            InstrumentHeader instrumentHeader = null;
            for (i = 0; i < suurenderChequelist.size(); ++i) {
                instrumentHeader = suurenderChequelist.get(i);
                if (this.instrumentService.isChequeNumberValid(chequeNoList.get(i), instrumentHeader.getBankAccountId().getId(), department, serialNoList.get(i))) continue;
                this.addFieldError("newInstrumentNumber[" + i + "]", this.getMessage("payment.chequenumber.invalid") + " " + chequeNoList.get(i).toString());
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed validateNewChequeNumbers.");
        }
    }

    public void validateDataForManual() throws ParseException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting validateDataForManual...");
        }
        int i = 0;
        HashMap<String, String> chqNoMap = new HashMap<String, String>();
        if (this.paymentMode.equals("cheque")) {
            for (ChequeAssignment assignment : this.chequeAssignmentList) {
                if (!assignment.getIsSelected()) continue;
                if (assignment.getSerialNo() == null) {
                    this.addFieldError("Year code should not be empty", this.getMessage("payment.yearcode.invalid"));
                    break;
                }
                if (null == assignment.getChequeNumber() || "".equals(assignment.getChequeNumber())) {
                    this.addFieldError("chequeAssignmentList[" + i + "].chequeNumber", this.getMessage("payment.chequeno.empty"));
                    break;
                }
                if (this.reassignSurrenderChq) {
                    if (!this.instrumentService.isReassigningChequeNumberValid(assignment.getChequeNumber(), Long.valueOf(this.bankaccount.longValue()), Integer.valueOf(this.voucherHeader.getVouchermis().getDepartmentid().getId().intValue()), assignment.getSerialNo())) {
                        this.addFieldError("chequeAssignmentList[" + i + "].chequeNumber", this.getMessage("payment.chequenumber.invalid"));
                    }
                } else if (!this.instrumentService.isChequeNumberValid(assignment.getChequeNumber(), Long.valueOf(this.bankaccount.longValue()), Integer.valueOf(this.voucherHeader.getVouchermis().getDepartmentid().getId().intValue()), assignment.getSerialNo())) {
                    this.addFieldError("chequeAssignmentList[" + i + "].chequeNumber", this.getMessage("payment.chequenumber.invalid"));
                }
                if (null == assignment.getChequeDate()) {
                    this.addFieldError("chequeAssignmentList[" + i + "].chequeNumber", this.getMessage("payment.chequeno.empty"));
                    break;
                }
                if (assignment.getChequeDate().compareTo(assignment.getVoucherDate()) < 0) {
                    this.addFieldError("Cheque date cannot be less than paymnet date", this.getMessage("payment.chequedate.invalid"));
                    break;
                }
                if (chqNoMap.containsKey(assignment.getChequeNumber())) {
                    if (!((String)chqNoMap.get(assignment.getChequeNumber())).equals(assignment.getPaidTo())) {
                        this.addFieldError("chequeAssignmentList[" + i + "].chequeNumber", this.getMessage("payment.duplicate.chequeno", new String[]{assignment.getChequeNumber(), (String)chqNoMap.get(assignment.getChequeNumber()), assignment.getPaidTo()}));
                    }
                } else {
                    chqNoMap.put(assignment.getChequeNumber(), assignment.getPaidTo());
                }
                ++i;
            }
        } else {
            String chequedt = null;
            if (this.paymentMode.equalsIgnoreCase("rtgs")) {
                return;
            }
            chequedt = ((String[])this.parameters.get("chequeDt"))[0];
            if (StringUtils.isEmpty((String)((String[])this.parameters.get("inFavourOf"))[0])) {
                this.addFieldError("inFavourOf", this.getMessage("inFavourOf.is.empty"));
            }
            if (StringUtils.isEmpty((String)((String[])this.parameters.get("chequeNo"))[0])) {
                this.addFieldError("chequeNo", this.getMessage("payment.chequeno.empty"));
            } else {
                for (int j = 0; j < this.chequeAssignmentList.size(); ++j) {
                    if (this.parameters.get("chequeAssignmentList[" + j + "].isSelected") == null || !((String[])this.parameters.get("chequeAssignmentList[" + j + "].isSelected"))[0].equals("true")) continue;
                    String paymentdt = ((String[])this.parameters.get("chequeAssignmentList[" + j + "].tempPaymentDate"))[0];
                    if (this.formatter.parse(chequedt).compareTo(this.formatter.parse(paymentdt)) >= 0) continue;
                    this.addFieldError("Cheque date cannot be less than paymnet date", this.getMessage("payment.chequedate.invalid"));
                }
                if (this.reassignSurrenderChq) {
                    if (!this.instrumentService.isReassigningChequeNumberValid(((String[])this.parameters.get("chequeNo"))[0], Long.valueOf(this.bankaccount.longValue()), Integer.valueOf(this.voucherHeader.getVouchermis().getDepartmentid().getId().intValue()), ((String[])this.parameters.get("serialNo"))[0])) {
                        this.addFieldError("chequeAssignmentList[" + i + "].chequeNumber", this.getMessage("payment.chequenumber.invalid"));
                    }
                } else if (!this.instrumentService.isChequeNumberValid(((String[])this.parameters.get("chequeNo"))[0], Long.valueOf(this.bankaccount.longValue()), Integer.valueOf(this.voucherHeader.getVouchermis().getDepartmentid().getId().intValue()), ((String[])this.parameters.get("serialNo"))[0])) {
                    this.addFieldError("chequeN0", this.getMessage("payment.chequenumber.invalid"));
                }
            }
            if (null == this.getChequeDt()) {
                this.addFieldError("chequeDt", this.getMessage("payment.chequedate.empty"));
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed validateDataForManual.");
        }
    }

    @SkipValidation
    public boolean validateUser(String purpose) throws ParseException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting validateUser...");
        }
        this.getPersistenceService().findAllByNamedQuery("Script.findByName", new Object[]{"Paymentheader.show.bankbalance"}).get(0);
        List list = null;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed validateUser.");
        }
        return ((String)list.get(0)).equals("true");
    }

    public void validate() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting validate...");
        }
        if (!this.rtgsContractorAssignment.booleanValue() && !this.containsRTGS) {
            this.checkMandatory("fundId", "fund", (Object)this.voucherHeader.getFundId(), "voucher.fund.mandatory");
            this.checkMandatory("vouchermis.departmentid", "department", (Object)this.voucherHeader.getVouchermis().getDepartmentid(), "voucher.department.mandatory");
            this.checkMandatory("voucher.function", "function", (Object)this.voucherHeader.getVouchermis().getFunction(), "voucher.function.mandatory");
            this.checkMandatory("vouchermis.schemeid", "scheme", (Object)this.voucherHeader.getVouchermis().getSchemeid(), "voucher.scheme.mandatory");
            this.checkMandatory("vouchermis.subschemeid", "subscheme", (Object)this.voucherHeader.getVouchermis().getSubschemeid(), "voucher.subscheme.mandatory");
            this.checkMandatory("vouchermis.functionary", "functionary", (Object)this.voucherHeader.getVouchermis().getFunctionary(), "voucher.functionary.mandatory");
            this.checkMandatory("fundsourceId", "fundsource", (Object)this.voucherHeader.getVouchermis().getFundsource(), "voucher.fundsource.mandatory");
            this.checkMandatory("vouchermis.divisionId", "field", (Object)this.voucherHeader.getVouchermis().getDivisionid(), "voucher.field.mandatory");
            this.checkMandatory("Recovery Code", "recovery", (Object)this.recoveryId, "recovery.mandatory");
            this.loadBankAndAccount();
            this.loadBillTypeMap();
            if (this.getBankbranch() == null || this.getBankbranch() == -1) {
                this.addFieldError("bankbranch", this.getMessage("bankbranch.empty"));
            }
            if (this.getBankaccount() == null || this.getBankaccount() == -1) {
                this.addFieldError("bankaccount", this.getMessage("bankaccount.empty"));
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed validate.");
        }
    }

    private void loadBillTypeMap() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting loadBillTypeMap...");
        }
        this.billTypeMap = new HashMap();
        this.billTypeMap.put("Expense", "Expense");
        this.billTypeMap.put("Works-Purchase", "Contractor/Supplier");
        this.billTypeMap.put("Direct Bank Payment", "No associated bills");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed loadBillTypeMap.");
        }
    }

    private void checkMandatory(String objectName, String fieldName, Object value, String errorKey) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting checkMandatory...");
        }
        if (this.mandatoryFields.contains(fieldName) && value == null) {
            this.addFieldError(objectName, this.getMessage(errorKey));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed checkMandatory.");
        }
    }

    @SkipValidation
    public String ajaxGenerateAdviceHtml() throws Exception {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting ajaxGenerateAdviceHtml...");
        }
        this.generateAdvice();
        this.inputStream = this.reportHelper.exportHtml(this.inputStream, JASPER_PATH, this.getParamMap(), this.getAdviceList(), "pt");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed ajaxGenerateAdviceHtml.");
        }
        return "bankAdvice-HTML";
    }

    @SkipValidation
    public String generateAdvicePdf() throws Exception {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting generateAdvicePdf...");
        }
        this.generateAdvice();
        this.inputStream = this.reportHelper.exportPdf(this.inputStream, JASPER_PATH, this.getParamMap(), this.getAdviceList());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed generateAdvicePdf.");
        }
        return "bankAdvice-PDF";
    }

    public Map<String, String> getBankBranchMap() {
        return this.bankBranchMap;
    }

    public void setBillTypeMap(Map<String, String> billTypeMap) {
        this.billTypeMap = billTypeMap;
    }

    public Map<String, String> getBillTypeMap() {
        return this.billTypeMap;
    }

    public void setBankBranchMap(Map<String, String> bankBranchMap) {
        this.bankBranchMap = bankBranchMap;
    }

    public Map<String, String> getBankAccountMap() {
        return this.bankAccountMap;
    }

    public void setBankAccountMap(Map<String, String> bankAccountMap) {
        this.bankAccountMap = bankAccountMap;
    }

    @SkipValidation
    public String generateAdviceXls() throws Exception {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting generateAdviceXls...");
        }
        this.generateAdvice();
        this.inputStream = this.reportHelper.exportXls(this.inputStream, JASPER_PATH, this.getParamMap(), this.getAdviceList());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed generateAdviceXls.");
        }
        return "bankAdvice-XLS";
    }

    public boolean isChequePrintEnabled() {
        String chequePrintEnabled = null;
        List enablePrintConfig = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "chequeprintingenabled");
        for (AppConfigValues appConfigVal : enablePrintConfig) {
            chequePrintEnabled = appConfigVal.getValue();
        }
        if (chequePrintEnabled == null) {
            return false;
        }
        return chequePrintEnabled.equalsIgnoreCase("Y");
    }

    @SkipValidation
    @Action(value="/payment/chequeAssignment-bankAdviceExcel")
    public String bankAdviceExcel() throws JRException, IOException {
        BankAdviceReportInfo bankAdvice = new BankAdviceReportInfo();
        InstrumentVoucher instrumentHeader = this.instrumentVoucherService.getInstrumentVoucherByVoucherHeader(this.instHeaderId);
        bankAdvice.setPartyName(instrumentHeader.getInstrumentHeaderId().getPayTo());
        bankAdvice.setAmount(instrumentHeader.getInstrumentHeaderId().getInstrumentAmount());
        ArrayList<BankAdviceReportInfo> data = new ArrayList<BankAdviceReportInfo>();
        data.add(bankAdvice);
        this.setFileName(instrumentHeader.getVoucherHeaderId().getVoucherNumber() + "." + ReportFormat.XLS.toString().toLowerCase());
        this.inputStream = this.reportHelper.exportXls(this.getInputStream(), this.bankAdviceJasperPath, null, data);
        return "bankAdvice-XLS";
    }

    protected String getMessage(String key) {
        return this.getText(key);
    }

    protected String getMessage(String key, String[] value) {
        return this.getText(key, value);
    }

    public String getPaymentMode() {
        return this.paymentMode;
    }

    public void setPaymentMode(String paymentMode) {
        this.paymentMode = paymentMode;
    }

    public void setPaymentService(PaymentService paymentService) {
        this.paymentService = paymentService;
    }

    public Integer getBankaccount() {
        return this.bankaccount;
    }

    public void setBankaccount(Integer bankaccount) {
        this.bankaccount = bankaccount;
    }

    public List<InstrumentHeader> getInstHeaderList() {
        return this.instHeaderList;
    }

    public void setInstHeaderList(List<InstrumentHeader> instHeaderList) {
        this.instHeaderList = instHeaderList;
    }

    public Integer getSelectedRows() {
        return this.selectedRows;
    }

    public void setSelectedRows(Integer selectedRows) {
        this.selectedRows = selectedRows;
    }

    public List<ChequeAssignment> getChequeAssignmentList() {
        return this.chequeAssignmentList;
    }

    public void setChequeAssignmentList(List<ChequeAssignment> chequeAssignmentList) {
        this.chequeAssignmentList = chequeAssignmentList;
    }

    public boolean isChequeNoGenerationAuto() {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)this.chequeNoGenerationAuto);
        }
        return this.chequeNoGenerationAuto;
    }

    public void setChequeNoGenerationAuto(boolean chequeNoGenerationAuto) {
        this.chequeNoGenerationAuto = chequeNoGenerationAuto;
    }

    public void setInstrumentService(InstrumentService instrumentService) {
        this.instrumentService = instrumentService;
    }

    public Integer getBankbranch() {
        return this.bankbranch;
    }

    public void setBankbranch(Integer bankbranch) {
        this.bankbranch = bankbranch;
    }

    public Date getChequeDt() {
        return this.chequeDt;
    }

    public void setChequeDt(Date chequeDt) {
        this.chequeDt = chequeDt;
    }

    public String getInFavourOf() {
        return this.inFavourOf;
    }

    public void setInFavourOf(String inFavourOf) {
        this.inFavourOf = inFavourOf;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setReportHelper(ReportHelper reportHelper) {
        this.reportHelper = reportHelper;
    }

    public Map<String, Object> getParamMap() {
        return this.paramMap;
    }

    public void setParamMap(Map<String, Object> paramMap) {
        this.paramMap = paramMap;
    }

    public List<Object> getAdviceList() {
        return this.adviceList;
    }

    public List<InstrumentVoucher> getInstVoucherList() {
        return this.instVoucherList;
    }

    public void setInstVoucherList(List<InstrumentVoucher> instVoucherList) {
        this.instVoucherList = instVoucherList;
    }

    public String getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(String fromDate) {
        this.fromDate = fromDate;
    }

    public String getToDate() {
        return this.toDate;
    }

    public void setToDate(String toDate) {
        this.toDate = toDate;
    }

    public List<InstrumentVoucher> getInstrumentVoucherList() {
        return this.instrumentVoucherList;
    }

    public void setInstrumentVoucherList(List<InstrumentVoucher> instrumentVoucherList) {
        this.instrumentVoucherList = instrumentVoucherList;
    }

    public String getInstrumentNumber() {
        return this.instrumentNumber;
    }

    public void setInstrumentNumber(String instrumentNumber) {
        this.instrumentNumber = instrumentNumber;
    }

    public String[] getSurrender() {
        return this.surrender;
    }

    public void setSurrender(String[] surrender) {
        this.surrender = surrender;
    }

    public void setContraService(ContraService contraService) {
    }

    public String getBank_branch() {
        return this.bank_branch;
    }

    public void setBank_branch(String bank_branch) {
        this.bank_branch = bank_branch;
    }

    public String getBillType() {
        return this.billType;
    }

    public void setBillType(String billType) {
        this.billType = billType;
    }

    public String getButton() {
        return this.button;
    }

    public void setButton(String button) {
        this.button = button;
    }

    public void setChequeService(ChequeService chequeService) {
        this.chequeService = chequeService;
    }

    public String[] getNewInstrumentNumber() {
        return this.newInstrumentNumber;
    }

    public void setNewInstrumentNumber(String[] newInstrumentNumber) {
        this.newInstrumentNumber = newInstrumentNumber;
    }

    public Integer getDepartment() {
        return this.department;
    }

    public void setDepartment(Integer department) {
        this.department = department;
    }

    public String getBank_account_dept() {
        return this.bank_account_dept;
    }

    public void setBank_account_dept(String bank_account_dept) {
        this.bank_account_dept = bank_account_dept;
    }

    public String[] getNewInstrumentDate() {
        return this.newInstrumentDate;
    }

    public void setNewInstrumentDate(String[] newInstrumentDate) {
        this.newInstrumentDate = newInstrumentDate;
    }

    public List<InstrumentHeader> getInstrumentHeaderList() {
        return this.instrumentHeaderList;
    }

    public void setInstrumentHeaderList(List<InstrumentHeader> instrumentHeaderList) {
        this.instrumentHeaderList = instrumentHeaderList;
    }

    public void setEgovCommon(EgovCommon egovCommon) {
    }

    public String getTypeOfAccount() {
        return this.typeOfAccount;
    }

    public void setTypeOfAccount(String typeOfAccount) {
        this.typeOfAccount = typeOfAccount;
    }

    public Date getCurrentDate() {
        return this.currentDate;
    }

    public void setCurrentDate(Date currentDate) {
        this.currentDate = currentDate;
    }

    public RecoveryService getRecoveryService() {
        return this.recoveryService;
    }

    public void setRecoveryService(RecoveryService recoveryService) {
        this.recoveryService = recoveryService;
    }

    public Long getRecoveryId() {
        return this.recoveryId;
    }

    public void setRecoveryId(Long recoveryId) {
        this.recoveryId = recoveryId;
    }

    public Map<String, String> getModeOfPaymentMap() {
        return this.modeOfPaymentMap;
    }

    public void setModeOfPaymentMap(Map<String, String> modeOfPaymentMap) {
        this.modeOfPaymentMap = modeOfPaymentMap;
    }

    public String[] getSurrendarReasons() {
        return this.surrendarReasons;
    }

    public void setSurrendarReasons(String[] surrendarReasons) {
        this.surrendarReasons = surrendarReasons;
    }

    public String[] getNewSerialNo() {
        return this.newSerialNo;
    }

    public void setNewSerialNo(String[] newSerialNo) {
        this.newSerialNo = newSerialNo;
    }

    public Boolean getRtgsContractorAssignment() {
        return this.rtgsContractorAssignment;
    }

    public void setRtgsContractorAssignment(Boolean rtgsContractorAssignment) {
        this.rtgsContractorAssignment = rtgsContractorAssignment;
    }

    public Map<Bankaccount, List<ChequeAssignment>> getAccountNoAndRtgsEntryMap() {
        return this.accountNoAndRtgsEntryMap;
    }

    public void setAccountNoAndRtgsEntryMap(Map<Bankaccount, List<ChequeAssignment>> accountNoAndRtgsEntryMap) {
        this.accountNoAndRtgsEntryMap = accountNoAndRtgsEntryMap;
    }

    public boolean isRtgsNoGenerationAuto() {
        return this.rtgsNoGenerationAuto;
    }

    public void setRtgsNoGenerationAuto(boolean rtgsNoGenerationAuto) {
        this.rtgsNoGenerationAuto = rtgsNoGenerationAuto;
    }

    public Map<String, String> getRtgsdateMap() {
        return this.rtgsdateMap;
    }

    public void setRtgsdateMap(Map<String, String> rtgsdateMap) {
        this.rtgsdateMap = rtgsdateMap;
    }

    public Map<String, String> getRtgsRefNoMap() {
        return this.rtgsRefNoMap;
    }

    public List<ChequeAssignment> getRtgsList() {
        return this.rtgsList;
    }

    public void setRtgsRefNoMap(Map<String, String> rtgsRefNoMap) {
        this.rtgsRefNoMap = rtgsRefNoMap;
    }

    public void setRtgsList(List<ChequeAssignment> rtgsList) {
        this.rtgsList = rtgsList;
    }

    public Map<String, Boolean> getRtgsSeceltedAccMap() {
        return this.rtgsSeceltedAccMap;
    }

    public void setRtgsSeceltedAccMap(Map<String, Boolean> rtgsSeceltedAccMap) {
        this.rtgsSeceltedAccMap = rtgsSeceltedAccMap;
    }

    public List<InstrumentHeader> getInstVoucherDisplayList() {
        return this.instVoucherDisplayList;
    }

    public void setInstVoucherDisplayList(List<InstrumentHeader> instVoucherDisplayList) {
        this.instVoucherDisplayList = instVoucherDisplayList;
    }

    public Integer getDrawingOfficerId() {
        return this.drawingOfficerId;
    }

    public void setDrawingOfficerId(Integer drawingOfficerId) {
        this.drawingOfficerId = drawingOfficerId;
    }

    public String getDrawingOfficerCode() {
        return this.drawingOfficerCode;
    }

    public void setDrawingOfficerCode(String drawingOfficerCode) {
        this.drawingOfficerCode = drawingOfficerCode;
    }

    public Map<BankAccountRemittanceCOA, List<ChequeAssignment>> getAccountNoAndRemittanceRtgsEntryMap() {
        return this.accountNoAndRemittanceRtgsEntryMap;
    }

    public void setAccountNoAndRemittanceRtgsEntryMap(Map<BankAccountRemittanceCOA, List<ChequeAssignment>> accountNoAndRemittanceRtgsEntryMap) {
        this.accountNoAndRemittanceRtgsEntryMap = accountNoAndRemittanceRtgsEntryMap;
    }

    public String getBillSubType() {
        return this.billSubType;
    }

    public void setBillSubType(String billSubType) {
        this.billSubType = billSubType;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getBank_account() {
        return this.bank_account;
    }

    public void setBank_account(String bank_account) {
        this.bank_account = bank_account;
    }

    public String getRecoveryCode() {
        return this.recoveryCode;
    }

    public void setRecoveryCode(String recoveryCode) {
        this.recoveryCode = recoveryCode;
    }

    public String getPaymentId() {
        return this.paymentId;
    }

    public void setPaymentId(String paymentId) {
        this.paymentId = paymentId;
    }

    public List<ChequeAssignment> getViewReceiptDetailsList() {
        return this.viewReceiptDetailsList;
    }

    public void setViewReceiptDetailsList(List<ChequeAssignment> viewReceiptDetailsList) {
        this.viewReceiptDetailsList = viewReceiptDetailsList;
    }

    public BigDecimal getTotalDeductedAmount() {
        return this.totalDeductedAmount;
    }

    public void setTotalDeductedAmount(BigDecimal totalDeductedAmount) {
        this.totalDeductedAmount = totalDeductedAmount;
    }

    public Boolean getNonSubledger() {
        return this.nonSubledger;
    }

    public void setNonSubledger(Boolean nonSubledger) {
        this.nonSubledger = nonSubledger;
    }

    public void setFinancialYearDAO(FinancialYearDAO financialYearDAO) {
        this.financialYearDAO = financialYearDAO;
    }

    public boolean isContainsRTGS() {
        return this.containsRTGS;
    }

    public void setContainsRTGS(boolean containsRTGS) {
        this.containsRTGS = containsRTGS;
    }

    public Boolean getFunctionNonMandatory() {
        return this.functionNonMandatory;
    }

    public void setFunctionNonMandatory(Boolean functionNonMandatory) {
        this.functionNonMandatory = functionNonMandatory;
    }

    public Boolean getDeptNonMandatory() {
        return this.deptNonMandatory;
    }

    public void setDeptNonMandatory(Boolean deptNonMandatory) {
        this.deptNonMandatory = deptNonMandatory;
    }

    public List<CFinancialYear> getYearCodeList() {
        return this.yearCodeList;
    }

    public void setYearCodeList(List<CFinancialYear> yearCodeList) {
        this.yearCodeList = yearCodeList;
    }

    public Long getDepartmentId() {
        return this.departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }

    public boolean isChequePrintingEnabled() {
        return this.chequePrintingEnabled;
    }

    public String getChequePrintAvailableAt() {
        return this.chequePrintAvailableAt;
    }

    public String getInstrumentHeader() {
        return this.instrumentHeader;
    }

    public void setChequePrintingEnabled(boolean chequePrintingEnabled) {
        this.chequePrintingEnabled = chequePrintingEnabled;
    }

    public void setChequePrintAvailableAt(String chequePrintAvailableAt) {
        this.chequePrintAvailableAt = chequePrintAvailableAt;
    }

    public void setInstrumentHeader(String instrumentHeader) {
        this.instrumentHeader = instrumentHeader;
    }

    public String getChequeFormat() {
        return this.chequeFormat;
    }

    public void setChequeFormat(String chequeFormat) {
        this.chequeFormat = chequeFormat;
    }

    public Long getInstHeaderId() {
        return this.instHeaderId;
    }

    public void setInstHeaderId(Long instHeaderId) {
        this.instHeaderId = instHeaderId;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getSelectedRowsId() {
        return this.selectedRowsId;
    }

    public void setSelectedRowsId(String selectedRowsId) {
        this.selectedRowsId = selectedRowsId;
    }

    public List<InstrumentHeader> getTempInstrumentHeaderList() {
        return this.tempInstrumentHeaderList;
    }

    public void setTempInstrumentHeaderList(List<InstrumentHeader> tempInstrumentHeaderList) {
        this.tempInstrumentHeaderList = tempInstrumentHeaderList;
    }
}

