/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.controller.expensebill;

import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.egov.commons.service.ChartOfAccountsService;
import org.egov.commons.service.CheckListService;
import org.egov.egf.expensebill.service.ExpenseBillService;
import org.egov.egf.utils.FinancialUtils;
import org.egov.egf.web.controller.expensebill.BaseBillController;
import org.egov.eis.web.contract.WorkflowContainer;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.exception.ApplicationException;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.infstr.models.EgChecklists;
import org.egov.model.bills.EgBilldetails;
import org.egov.model.bills.EgBillregister;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/expensebill"})
public class UpdateExpenseBillController
extends BaseBillController {
    private static final String NET_PAYABLE_AMOUNT = "netPayableAmount";
    private static final String APPROVAL_DESIGNATION = "approvalDesignation";
    private static final String EG_BILLREGISTER = "egBillregister";
    private static final String APPROVAL_POSITION = "approvalPosition";
    private static final String EXPENSEBILL_VIEW = "expensebill-view";
    private static final String NET_PAYABLE_ID = "netPayableId";
    @Autowired
    private ExpenseBillService expenseBillService;
    @Autowired
    @Qualifier(value="chartOfAccountsService")
    private ChartOfAccountsService chartOfAccountsService;
    @Autowired
    private FinancialUtils financialUtils;
    @Autowired
    private CheckListService checkListService;

    public UpdateExpenseBillController(AppConfigValueService appConfigValuesService) {
        super(appConfigValuesService);
    }

    @ModelAttribute(value="egBillregister")
    public EgBillregister getEgBillregister(@PathVariable String billId) {
        return this.expenseBillService.getById(Long.valueOf(Long.parseLong(billId)));
    }

    @RequestMapping(value={"/update/{billId}"}, method={RequestMethod.GET})
    public String updateForm(Model model, @PathVariable String billId, HttpServletRequest request) throws ApplicationException {
        EgBillregister egBillregister = this.expenseBillService.getById(Long.valueOf(Long.parseLong(billId)));
        this.setDropDownValues(model);
        model.addAttribute("stateType", (Object)egBillregister.getClass().getSimpleName());
        if (egBillregister.getState() != null) {
            model.addAttribute("currentState", (Object)egBillregister.getState().getValue());
        }
        model.addAttribute("workflowHistory", (Object)this.financialUtils.getHistory(egBillregister.getState(), egBillregister.getStateHistory()));
        this.prepareWorkflow(model, (StateAware)egBillregister, new WorkflowContainer());
        egBillregister.getBillDetails().addAll(egBillregister.getEgBilldetailes());
        this.prepareBillDetailsForView(egBillregister);
        this.expenseBillService.validateSubledgeDetails(egBillregister);
        List expensePayableAccountList = this.chartOfAccountsService.getNetPayableCodes();
        for (EgBilldetails details : egBillregister.getBillDetails()) {
            if (expensePayableAccountList == null || expensePayableAccountList.isEmpty() || !expensePayableAccountList.contains(details.getChartOfAccounts())) continue;
            model.addAttribute(NET_PAYABLE_ID, (Object)details.getChartOfAccounts().getId());
            model.addAttribute(NET_PAYABLE_AMOUNT, (Object)details.getCreditamount());
        }
        this.prepareCheckListForEdit(egBillregister, model);
        model.addAttribute(EG_BILLREGISTER, (Object)egBillregister);
        if (egBillregister.getState() != null && ("Rejected".equals(egBillregister.getState().getValue()) || this.financialUtils.isBillEditable(egBillregister.getState()))) {
            model.addAttribute("mode", (Object)"edit");
            return "expensebill-update";
        }
        model.addAttribute("mode", (Object)"view");
        return EXPENSEBILL_VIEW;
    }

    @RequestMapping(value={"/update/{billId}"}, method={RequestMethod.POST})
    public String update(@ModelAttribute(value="egBillregister") EgBillregister egBillregister, BindingResult resultBinder, RedirectAttributes redirectAttributes, Model model, HttpServletRequest request, @RequestParam String workFlowAction) throws ApplicationException, IOException {
        String mode = "";
        EgBillregister updatedEgBillregister = null;
        if (request.getParameter("mode") != null) {
            mode = request.getParameter("mode");
        }
        Long approvalPosition = 0L;
        String approvalComment = "";
        if (request.getParameter("approvalComent") != null) {
            approvalComment = request.getParameter("approvalComent");
        }
        if (request.getParameter(APPROVAL_POSITION) != null && !request.getParameter(APPROVAL_POSITION).isEmpty()) {
            approvalPosition = Long.valueOf(request.getParameter(APPROVAL_POSITION));
        }
        if ((approvalPosition == null || approvalPosition.equals(0L)) && request.getParameter(APPROVAL_POSITION) != null && !request.getParameter(APPROVAL_POSITION).isEmpty()) {
            approvalPosition = Long.valueOf(request.getParameter(APPROVAL_POSITION));
        }
        if (egBillregister.getState() != null && ("Rejected".equals(egBillregister.getState().getValue()) || this.financialUtils.isBillEditable(egBillregister.getState()))) {
            this.populateBillDetails(egBillregister);
            this.validateBillNumber(egBillregister, resultBinder);
            this.validateLedgerAndSubledger(egBillregister, resultBinder);
        }
        if (resultBinder.hasErrors()) {
            this.setDropDownValues(model);
            model.addAttribute("stateType", (Object)egBillregister.getClass().getSimpleName());
            this.prepareWorkflow(model, (StateAware)egBillregister, new WorkflowContainer());
            model.addAttribute(APPROVAL_DESIGNATION, (Object)request.getParameter(APPROVAL_DESIGNATION));
            model.addAttribute(APPROVAL_POSITION, (Object)request.getParameter(APPROVAL_POSITION));
            model.addAttribute(NET_PAYABLE_ID, (Object)request.getParameter(NET_PAYABLE_ID));
            model.addAttribute(NET_PAYABLE_AMOUNT, (Object)request.getParameter(NET_PAYABLE_AMOUNT));
            model.addAttribute("designation", (Object)request.getParameter("designation"));
            if (egBillregister.getState() != null && ("Rejected".equals(egBillregister.getState().getValue()) || this.financialUtils.isBillEditable(egBillregister.getState()))) {
                this.prepareValidActionListByCutOffDate(model);
                model.addAttribute("mode", (Object)"edit");
                return "expensebill-update";
            }
            model.addAttribute("mode", (Object)"view");
            return EXPENSEBILL_VIEW;
        }
        try {
            if (null != workFlowAction) {
                updatedEgBillregister = this.expenseBillService.update(egBillregister, approvalPosition, approvalComment, null, workFlowAction, mode);
            }
        }
        catch (ValidationException e) {
            this.setDropDownValues(model);
            model.addAttribute("stateType", (Object)egBillregister.getClass().getSimpleName());
            this.prepareWorkflow(model, (StateAware)egBillregister, new WorkflowContainer());
            model.addAttribute(APPROVAL_DESIGNATION, (Object)request.getParameter(APPROVAL_DESIGNATION));
            model.addAttribute(APPROVAL_POSITION, (Object)request.getParameter(APPROVAL_POSITION));
            model.addAttribute(NET_PAYABLE_ID, (Object)request.getParameter(NET_PAYABLE_ID));
            model.addAttribute(NET_PAYABLE_AMOUNT, (Object)request.getParameter(NET_PAYABLE_AMOUNT));
            model.addAttribute("designation", (Object)request.getParameter("designation"));
            if (egBillregister.getState() != null && ("Rejected".equals(egBillregister.getState().getValue()) || this.financialUtils.isBillEditable(egBillregister.getState()))) {
                this.prepareValidActionListByCutOffDate(model);
                model.addAttribute("mode", (Object)"edit");
                return "expensebill-update";
            }
            model.addAttribute("mode", (Object)"view");
            return EXPENSEBILL_VIEW;
        }
        redirectAttributes.addFlashAttribute(EG_BILLREGISTER, updatedEgBillregister);
        if (approvalPosition == null || approvalPosition.equals(0L)) {
            approvalPosition = this.expenseBillService.getApprovalPositionByMatrixDesignation(egBillregister, null, mode, workFlowAction);
        }
        String approverDetails = this.financialUtils.getApproverDetails(workFlowAction, updatedEgBillregister.getState(), updatedEgBillregister.getId(), approvalPosition);
        return "redirect:/expensebill/success?approverDetails= " + approverDetails + "&billNumber=" + updatedEgBillregister.getBillnumber();
    }

    @RequestMapping(value={"/view/{billId}"}, method={RequestMethod.GET})
    public String view(Model model, @PathVariable String billId, HttpServletRequest request) throws ApplicationException {
        EgBillregister egBillregister = this.expenseBillService.getById(Long.valueOf(Long.parseLong(billId)));
        this.setDropDownValues(model);
        egBillregister.getBillDetails().addAll(egBillregister.getEgBilldetailes());
        model.addAttribute("mode", (Object)"readOnly");
        this.prepareBillDetailsForView(egBillregister);
        this.prepareCheckList(egBillregister);
        List expensePayableAccountList = this.chartOfAccountsService.getNetPayableCodesByAccountDetailType(Integer.valueOf(0));
        for (EgBilldetails details : egBillregister.getBillDetails()) {
            if (expensePayableAccountList == null || expensePayableAccountList.isEmpty() || !expensePayableAccountList.contains(details.getChartOfAccounts())) continue;
            model.addAttribute(NET_PAYABLE_AMOUNT, (Object)details.getCreditamount());
        }
        model.addAttribute(EG_BILLREGISTER, (Object)egBillregister);
        return EXPENSEBILL_VIEW;
    }

    private void prepareCheckList(EgBillregister egBillregister) {
        List checkLists = this.checkListService.getByObjectId(egBillregister.getId());
        egBillregister.getCheckLists().addAll(checkLists);
    }

    private void prepareCheckListForEdit(EgBillregister egBillregister, Model model) {
        List checkLists = this.checkListService.getByObjectId(egBillregister.getId());
        egBillregister.getCheckLists().addAll(checkLists);
        StringBuilder selectedCheckList = new StringBuilder();
        for (EgChecklists checkList : egBillregister.getCheckLists()) {
            selectedCheckList.append(checkList.getAppconfigvalue().getId());
            selectedCheckList.append("-");
            selectedCheckList.append(checkList.getChecklistvalue());
            selectedCheckList.append(",");
        }
        if (!checkLists.isEmpty()) {
            model.addAttribute("selectedCheckList", (Object)selectedCheckList.toString().substring(0, selectedCheckList.length() - 1));
        }
    }

    protected void setDropDownValues(Model model) {
        super.setDropDownValues(model);
    }
}

