/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.controller;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.List;
import javax.validation.Valid;
import org.egov.commons.service.AccountEntityService;
import org.egov.commons.service.AccountdetailtypeService;
import org.egov.egf.web.adaptor.AccountEntityJsonAdaptor;
import org.egov.masters.model.AccountEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/accountentity"})
public class AccountEntityController {
    private static final String ACCOUNTENTITY_NEW = "accountentity-new";
    private static final String ACCOUNTENTITY_RESULT = "accountentity-result";
    private static final String ACCOUNTENTITY_EDIT = "accountentity-edit";
    private static final String ACCOUNTENTITY_VIEW = "accountentity-view";
    private static final String ACCOUNTENTITY_SEARCH = "accountentity-search";
    @Autowired
    private AccountEntityService accountEntityService;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private AccountdetailtypeService accountdetailtypeService;

    private void prepareNewForm(Model model) {
        model.addAttribute("accountdetailtypes", (Object)this.accountdetailtypeService.findByFullQualifiedName("org.egov.masters.model.AccountEntity"));
    }

    @RequestMapping(value={"/new"}, method={RequestMethod.GET})
    public String newForm(Model model) {
        this.prepareNewForm(model);
        model.addAttribute("accountEntity", (Object)new AccountEntity());
        return ACCOUNTENTITY_NEW;
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String create(@Valid @ModelAttribute AccountEntity accountEntity, BindingResult errors, Model model, RedirectAttributes redirectAttrs) {
        if (errors.hasErrors()) {
            this.prepareNewForm(model);
            return ACCOUNTENTITY_NEW;
        }
        this.accountEntityService.create(accountEntity);
        redirectAttrs.addFlashAttribute("message", (Object)this.messageSource.getMessage("msg.accountentity.success", null, null));
        return "redirect:/accountentity/result/" + accountEntity.getId();
    }

    @RequestMapping(value={"/edit/{id}"}, method={RequestMethod.GET})
    public String edit(@PathVariable(value="id") Integer id, Model model) {
        AccountEntity accountEntity = this.accountEntityService.findOne(id);
        this.prepareNewForm(model);
        model.addAttribute("accountEntity", (Object)accountEntity);
        return ACCOUNTENTITY_EDIT;
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public String update(@Valid @ModelAttribute AccountEntity accountEntity, BindingResult errors, Model model, RedirectAttributes redirectAttrs) {
        if (errors.hasErrors()) {
            this.prepareNewForm(model);
            return ACCOUNTENTITY_EDIT;
        }
        this.accountEntityService.update(accountEntity);
        redirectAttrs.addFlashAttribute("message", (Object)this.messageSource.getMessage("msg.accountentity.success", null, null));
        return "redirect:/accountentity/result/" + accountEntity.getId();
    }

    @RequestMapping(value={"/view/{id}"}, method={RequestMethod.GET})
    public String view(@PathVariable(value="id") Integer id, Model model) {
        AccountEntity accountEntity = this.accountEntityService.findOne(id);
        this.prepareNewForm(model);
        model.addAttribute("accountEntity", (Object)accountEntity);
        return ACCOUNTENTITY_VIEW;
    }

    @RequestMapping(value={"/result/{id}"}, method={RequestMethod.GET})
    public String result(@PathVariable(value="id") Integer id, Model model) {
        AccountEntity accountEntity = this.accountEntityService.findOne(id);
        model.addAttribute("accountEntity", (Object)accountEntity);
        return ACCOUNTENTITY_RESULT;
    }

    @RequestMapping(value={"/search/{mode}"}, method={RequestMethod.GET})
    public String search(@PathVariable(value="mode") String mode, Model model) {
        AccountEntity accountEntity = new AccountEntity();
        this.prepareNewForm(model);
        model.addAttribute("accountEntity", (Object)accountEntity);
        return ACCOUNTENTITY_SEARCH;
    }

    @RequestMapping(value={"/ajaxsearch/{mode}"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String ajaxsearch(@PathVariable(value="mode") String mode, Model model, @ModelAttribute AccountEntity accountEntity) {
        List searchResultList = this.accountEntityService.search(accountEntity);
        String result = "{ \"data\":" + this.toSearchResultJson((Object)searchResultList) + "}";
        return result;
    }

    public Object toSearchResultJson(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(AccountEntity.class, (Object)new AccountEntityJsonAdaptor()).create();
        String json = gson.toJson(object);
        return json;
    }
}

