/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.voucher;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import net.sf.jasperreports.engine.JRException;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.egov.commons.Accountdetailtype;
import org.egov.commons.CGeneralLedger;
import org.egov.commons.CVoucherHeader;
import org.egov.commons.Fund;
import org.egov.commons.utils.EntityType;
import org.egov.egf.commons.EgovCommon;
import org.egov.egf.web.actions.voucher.VoucherReport;
import org.egov.egf.web.actions.voucher.WorkFlowHistoryItem;
import org.egov.infra.admin.master.entity.City;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.exception.ApplicationException;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infra.workflow.entity.StateHistory;
import org.egov.model.bills.EgBillregistermis;
import org.egov.services.bills.BillsService;
import org.egov.services.budget.BudgetAppropriationService;
import org.egov.utils.ReportHelper;
import org.springframework.beans.factory.annotation.Autowired;

@Results(value={@Result(name={"PDF"}, type="stream", location="inputStream", params={"inputName", "inputStream", "contentType", "application/pdf", "contentDisposition", "no-cache;filename=JournalVoucherReport.pdf"}), @Result(name={"XLS"}, type="stream", location="inputStream", params={"inputName", "inputStream", "contentType", "application/xls", "contentDisposition", "no-cache;filename=JournalVoucherReport.xls"}), @Result(name={"HTML"}, type="stream", location="inputStream", params={"inputName", "inputStream", "contentType", "text/html"})})
@ParentPackage(value="egov")
public class JournalVoucherPrintAction
extends BaseFormAction {
    String jasperpath = "/reports/templates/journalVoucherReport.jasper";
    private static final long serialVersionUID = 1L;
    private static final String PRINT = "print";
    private CVoucherHeader voucher = new CVoucherHeader();
    List<Object> voucherReportList = new ArrayList();
    List<Object> budgetReportList = new ArrayList();
    InputStream inputStream;
    ReportHelper reportHelper;
    Long id;
    List<WorkFlowHistoryItem> inboxHistory = new ArrayList();
    private CityService cityService;
    private BillsService billsManager;
    private static final String ACCDETAILTYPEQUERY = " from Accountdetailtype where id=?";
    private BudgetAppropriationService budgetAppropriationService;
    @Autowired
    private EgovCommon egovCommon;

    public void setBillsService(BillsService billsManager) {
        this.billsManager = billsManager;
    }

    public void setCityService(CityService cityService) {
        this.cityService = cityService;
    }

    public Long getId() {
        return this.id;
    }

    public void setReportHelper(ReportHelper helper) {
        this.reportHelper = helper;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public List<Object> getVoucherReportList() {
        return this.voucherReportList;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public String execute() {
        return this.exportHtml();
    }

    @Action(value="/voucher/journalVoucherPrint-ajaxPrint")
    public String ajaxPrint() {
        return this.exportHtml();
    }

    public void prepare() {
        this.populateVoucher();
    }

    public Object getModel() {
        return this.voucher;
    }

    @Action(value="/voucher/journalVoucherPrint-print")
    public String print() {
        return PRINT;
    }

    private void populateVoucher() {
        if (!StringUtils.isBlank((String)((String[])this.parameters.get("id"))[0])) {
            Long voucherId = Long.valueOf(((String[])this.parameters.get("id"))[0]);
            CVoucherHeader voucherHeader = (CVoucherHeader)this.persistenceService.find("from CVoucherHeader where id =?", new Object[]{voucherId});
            if (voucherHeader != null) {
                this.voucher = voucherHeader;
                this.generateVoucherReportList();
            }
        }
    }

    private void generateVoucherReportList() {
        if (this.voucher != null) {
            VoucherReport voucherReport;
            for (CGeneralLedger vd : this.voucher.getGeneralledger()) {
                if (BigDecimal.ZERO.compareTo(BigDecimal.valueOf(vd.getCreditAmount())) != 0) continue;
                voucherReport = new VoucherReport(this.persistenceService, Integer.valueOf(this.voucher.getId().toString()), vd, this.egovCommon);
                this.voucherReportList.add(voucherReport);
            }
            for (CGeneralLedger vd : this.voucher.getGeneralledger()) {
                if (BigDecimal.ZERO.compareTo(BigDecimal.valueOf(vd.getDebitAmount())) != 0) continue;
                voucherReport = new VoucherReport(this.persistenceService, Integer.valueOf(this.voucher.getId().toString()), vd, this.egovCommon);
                this.voucherReportList.add(voucherReport);
            }
        }
    }

    public String getFundName() {
        if (this.voucher != null && this.voucher.getFundId() != null) {
            Fund fund = (Fund)this.persistenceService.find("from Fund where id=? ", new Object[]{this.voucher.getFundId().getId()});
            return fund == null ? "" : fund.getName();
        }
        return "";
    }

    public String getDepartmentName() {
        if (this.voucher != null && this.voucher.getVouchermis() != null && this.voucher.getVouchermis().getDepartmentid() != null) {
            Department dept = (Department)this.persistenceService.find("from Department where id=? ", new Object[]{this.voucher.getVouchermis().getDepartmentid().getId()});
            return dept == null ? "" : dept.getName();
        }
        return "";
    }

    @Action(value="/voucher/journalVoucherPrint-exportPdf")
    public String exportPdf() throws JRException, IOException {
        this.inputStream = this.reportHelper.exportPdf(this.inputStream, this.jasperpath, this.getParamMap(), this.voucherReportList);
        return "PDF";
    }

    public String exportHtml() {
        this.inputStream = this.reportHelper.exportHtml(this.inputStream, this.jasperpath, this.getParamMap(), this.voucherReportList, "px");
        return "HTML";
    }

    @Action(value="/voucher/journalVoucherPrint-exportXls")
    public String exportXls() throws JRException, IOException {
        this.inputStream = this.reportHelper.exportXls(this.inputStream, this.jasperpath, this.getParamMap(), this.voucherReportList);
        return "XLS";
    }

    protected Map<String, Object> getParamMap() {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("fundName", this.getFundName());
        paramMap.put("departmentName", this.getDepartmentName());
        paramMap.put("voucherNumber", this.getVoucherNumber());
        paramMap.put("voucherDate", this.getVoucherDate());
        paramMap.put("voucherDescription", this.getVoucherDescription());
        if (this.voucher != null && this.voucher.getState() != null) {
            this.loadInboxHistoryData(this.voucher.getStateHistory());
        }
        paramMap.put("workFlowHistory", this.inboxHistory);
        paramMap.put("workFlowJasper", this.reportHelper.getClass().getResourceAsStream("/reports/templates/workFlowHistoryReport.jasper"));
        HttpServletRequest request = ServletActionContext.getRequest();
        HttpSession session = request.getSession();
        City cityWebsite = this.cityService.getCityByURL((String)session.getAttribute("cityurl"));
        String billType = this.billsManager.getBillTypeforVoucher(this.voucher);
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)billType)) {
            billType = "General";
        } else if ("Works".equalsIgnoreCase(billType)) {
            billType = "Contractor";
        }
        if ("Purchase".equalsIgnoreCase(billType)) {
            billType = this.billsManager.getBillSubTypeforVoucher(this.voucher);
        }
        EgBillregistermis billRegistermis = null;
        if (this.voucher != null) {
            billRegistermis = (EgBillregistermis)this.persistenceService.find("from EgBillregistermis where voucherHeader.id=?", new Object[]{this.voucher.getId()});
        }
        StringBuilder cityName = new StringBuilder(100);
        cityName.append(cityWebsite.getName().toUpperCase());
        paramMap.put("cityName", cityName.toString());
        paramMap.put("voucherName", billType.toUpperCase().concat(" JOURNAL VOUCHER"));
        paramMap.put("budgetAppropriationDetailJasper", this.reportHelper.getClass().getResourceAsStream("/reports/templates/budgetAppropriationDetail.jasper"));
        if (billRegistermis != null && billRegistermis.getBudgetaryAppnumber() != null && !"".equalsIgnoreCase(billRegistermis.getBudgetaryAppnumber())) {
            paramMap.put("budgetDetail", this.budgetAppropriationService.getBudgetDetailsForBill(billRegistermis.getEgBillregister()));
        } else if (this.voucher != null && this.voucher.getVouchermis().getBudgetaryAppnumber() != null && !"".equalsIgnoreCase(this.voucher.getVouchermis().getBudgetaryAppnumber())) {
            paramMap.put("budgetDetail", this.budgetAppropriationService.getBudgetDetailsForVoucher(this.voucher));
        } else {
            paramMap.put("budgetDetail", new ArrayList());
        }
        return paramMap;
    }

    public Map<String, Object> getAccountDetails(Integer detailtypeid, Integer detailkeyid, Map<String, Object> tempMap) throws ApplicationException {
        Accountdetailtype detailtype = (Accountdetailtype)this.getPersistenceService().find(ACCDETAILTYPEQUERY, new Object[]{detailtypeid});
        tempMap.put("detailtype", detailtype.getName());
        tempMap.put("detailtypeid", detailtype.getId());
        tempMap.put("detailkeyid", detailkeyid);
        this.egovCommon.setPersistenceService(this.persistenceService);
        EntityType entityType = this.egovCommon.getEntityType(detailtype, (Serializable)detailkeyid);
        tempMap.put("detailkey", entityType.getName());
        tempMap.put("detailcode", entityType.getCode());
        return tempMap;
    }

    private String getVoucherNumber() {
        return this.voucher == null || this.voucher.getVoucherNumber() == null ? "" : this.voucher.getVoucherNumber();
    }

    private String getVoucherDescription() {
        return this.voucher == null || this.voucher.getDescription() == null ? "" : this.voucher.getDescription();
    }

    private String getVoucherDate() {
        return this.voucher == null || this.voucher.getVoucherDate() == null ? "" : DateUtils.getDefaultFormattedDate((Date)this.voucher.getVoucherDate());
    }

    private void loadInboxHistoryData(List<StateHistory> stateHistory) throws ApplicationRuntimeException {
        Collections.reverse(stateHistory);
        for (StateHistory historyState : stateHistory) {
            String pos = historyState.getSenderName().concat(" / ").concat(historyState.getSenderName());
            String nextAction = historyState.getNextAction();
            if ("NEW".equalsIgnoreCase(historyState.getValue())) continue;
            WorkFlowHistoryItem inboxHistoryItem = new WorkFlowHistoryItem(DateUtils.getFormattedDate((Date)historyState.getCreatedDate(), (String)"dd/MM/yyyy hh:mm a"), pos, nextAction, historyState.getValue(), historyState.getComments() != null ? this.removeSpecialCharacters(historyState.getComments()) : "");
            this.inboxHistory.add(inboxHistoryItem);
        }
    }

    private String removeSpecialCharacters(String str) {
        return str.replaceAll("\\s\\s+|\\r\\n", "<br/>").replaceAll("'", "\\\\'");
    }

    public void setBudgetAppropriationService(BudgetAppropriationService budgetAppropriationService) {
        this.budgetAppropriationService = budgetAppropriationService;
    }
}

