/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.revenue;

import java.util.ArrayList;
import java.util.List;
import org.egov.commons.CFinancialYear;
import org.egov.commons.CVoucherHeader;
import org.egov.egf.revenue.Grant;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.model.instrument.InstrumentHeader;

public class BaseRevenueAction
extends BaseFormAction {
    private static final long serialVersionUID = 1594209619636642478L;
    protected List<Grant> grantsList;
    protected List<Department> departmentList;
    protected List<CFinancialYear> finYearList;
    protected List<String> periodList;
    protected String grantsType;
    protected List<Grant> grantSearchList;
    protected String mode;
    protected Grant grant = new Grant();

    public Grant getModel() {
        return this.grant;
    }

    public void prepare() {
        this.mode = "view";
        this.finYearList = this.persistenceService.findAllBy("from CFinancialYear  where isActiveForPosting=true order by finYearRange DESC", new Object[0]);
        this.departmentList = this.persistenceService.findAllBy("from Department order by deptName", new Object[0]);
    }

    public String newForm() {
        this.mode = "create";
        this.grantsList = new ArrayList();
        this.grantsList.add(new Grant());
        return "new";
    }

    public String beforeModify() {
        StringBuffer query = new StringBuffer();
        query.append("From Grant gr where gr.financialYear.id=? and gr.grantType=? and gr.department.id=?");
        this.grantsList = this.persistenceService.findAllBy(query.toString(), new Object[]{this.grant.getFinancialYear().getId(), this.grant.getGrantType(), this.grant.getDepartment().getId()});
        if (this.mode.equals("edit")) {
            return "edit";
        }
        return "view";
    }

    public String saveOrupdate() {
        for (Grant gtr : this.grantsList) {
            gtr.setDepartment((Department)this.persistenceService.find("from Department where id=?", new Object[]{gtr.getDepartment().getId()}));
            gtr.setFinancialYear((CFinancialYear)this.persistenceService.find("from CFinancialYear where id=?", new Object[]{gtr.getFinancialYear().getId()}));
            gtr.setAccrualVoucher((CVoucherHeader)this.persistenceService.find("from CVoucherHeader where id=?", new Object[]{gtr.getAccrualVoucher().getId()}));
            if (gtr.getIhID().getId() != null) {
                gtr.setIhID((InstrumentHeader)this.persistenceService.find("from InstrumentHeader where id=?", new Object[]{gtr.getIhID().getId()}));
            } else {
                gtr.setIhID(null);
            }
            if (gtr.getGeneralVoucher().getId() != null) {
                gtr.setGeneralVoucher((CVoucherHeader)this.persistenceService.find("from CVoucherHeader where id=?", new Object[]{gtr.getGeneralVoucher().getId()}));
            } else {
                gtr.setGeneralVoucher(null);
            }
            if (gtr.getReceiptVoucher().getId() != null) {
                gtr.setReceiptVoucher((CVoucherHeader)this.persistenceService.find("from CVoucherHeader where id=?", new Object[]{gtr.getReceiptVoucher().getId()}));
            } else {
                gtr.setReceiptVoucher(null);
            }
            gtr.setGrantType(this.getGrantsType());
        }
        for (Grant gtr : this.grantsList) {
            this.persistenceService.persist((Object)gtr);
        }
        return "result";
    }

    public List<Grant> getGrantsList() {
        return this.grantsList;
    }

    public void setGrantsList(List<Grant> grantsList) {
        this.grantsList = grantsList;
    }

    public List<Department> getDepartmentList() {
        return this.departmentList;
    }

    public void setDepartmentList(List<Department> departmentList) {
        this.departmentList = departmentList;
    }

    public List<CFinancialYear> getFinYearList() {
        return this.finYearList;
    }

    public void setFinYearList(List<CFinancialYear> finYearList) {
        this.finYearList = finYearList;
    }

    public List<String> getPeriodList() {
        return this.periodList;
    }

    public void setPeriodList(List<String> periodList) {
        this.periodList = periodList;
    }

    public String getGrantsType() {
        return this.grantsType;
    }

    public void setGrantsType(String grantsType) {
        this.grantsType = grantsType;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }
}

