/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.brs;

import com.exilant.eGov.src.common.EGovernCommon;
import com.exilant.exility.common.TaskFailedException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.struts2.convention.annotation.Action;
import org.egov.commons.Bankaccount;
import org.egov.commons.Bankbranch;
import org.egov.commons.CFinancialYear;
import org.egov.commons.dao.FinancialYearDAO;
import org.egov.egf.web.actions.brs.AutoReconciliationAction;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infstr.services.PersistenceService;
import org.egov.model.brs.AutoReconcileBean;
import org.egov.utils.ReportHelper;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.transform.Transformers;
import org.hibernate.type.LongType;
import org.hibernate.type.Type;
import org.jboss.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Scope(value="prototype")
public class AutoReconcileHelper {
    private static final String DID_NOT_FIND_MATCH_IN_BANKBOOK = "did not find match in Bank Book  (InstrumentHeader)";
    private String file_already_uploaded = "This file (#name) already uploaded ";
    private String bank_account_not_match_msg = "Selected Bank account and spreadsheet ( #name ) account does not match";
    private String bankStatementFormat = "Upload the Bank Statement as shown in the Download Template format.";
    private static final long serialVersionUID = -4207341983597707193L;
    private static final Logger LOGGER = Logger.getLogger(AutoReconciliationAction.class);
    private static final int ACCOUNTNUMBER_ROW_INDEX = 2;
    private static final int STARTOF_DETAIL_ROW_INDEX = 8;
    private static final int TXNDT_INDEX = 1;
    private static final int NARRATION_INDEX = 2;
    private static final int CHEQUENO_INDEX = 4;
    private static final int TYPE_INDEX = 3;
    private static final int DEBIT_INDEX = 5;
    private static final int CREDIT_INDEX = 6;
    private static final int BALANCE_INDEX = 7;
    private static final int CSLNO_INDEX = 8;
    private final String BRS_TRANSACTION_TYPE_CHEQUE = "CLG";
    private static final String BRS_TRANSACTION_TYPE_BANK = "TRF";
    private List<Bankbranch> branchList = Collections.EMPTY_LIST;
    private final List<Bankaccount> accountList = Collections.EMPTY_LIST;
    private Integer accountId;
    private Date reconciliationDate;
    private Date fromDate;
    private Date toDate;
    private String accNo;
    private File bankStatmentInXls;
    private String bankStatmentInXlsFileName;
    private String failureMessage = "Invalid data in  the  following row(s), please correct and upload again\n";
    private final String successMessage = "BankStatement upload completed Successfully # rows processed";
    private boolean isFailed;
    private final String TABLENAME = "egf_brs_bankstatements";
    private final String BRS_ACTION_TO_BE_PROCESSED = "to be processed";
    private final String BRS_ACTION_TO_BE_PROCESSED_MANUALLY = "to be processed manually";
    private final String BRS_ACTION_PROCESSED = "processed";
    private final String jasperpath = "/reports/templates/AutoReconcileReport.jasper";
    private ReportHelper reportHelper;
    private InputStream inputStream;
    private final String BRS_MESSAGE_MORE_THAN_ONE_MATCH = "found more than one match in instruments";
    private final String BRS_MESSAGE_DUPPLICATE_IN_BANKSTATEMENT = "duplicate instrument number within the bankstament";
    private String message = "";
    private final String dateInDotFormat = "dd.mm.yyyy";
    private final SimpleDateFormat dateFormatter = new SimpleDateFormat("dd/MMM/yyyy");
    private SQLQuery insertQuery;
    private final String insertsql = "insert into egf_brs_bankstatements (ID,ACCOUNTNUMBER,ACCOUNTID,TXDATE,TYPE,INSTRUMENTNO,DEBIT,CREDIT,BALANCE,NARRATION,CSLNO,CREATEDDATE) values (nextval('seq_egf_brs_bankstatements'),:accNo,:accountId,to_date(:txDate,'dd.mm.yyyy'),:type,:instrumentNo,:debit,:credit,:balance,:narration,:cslNo,CURRENT_DATE)";
    private int count;
    private int rowIndex;
    private int rowCount;
    private List<AutoReconcileBean> statementsNotInBankBookList;
    private List<AutoReconcileBean> statementsFoundButNotProcessed;
    @Autowired
    private FinancialYearDAO financialYearDAO;
    private Date finYearStartDate;
    private List<AutoReconcileBean> entriesNotInBankStament;
    private Bankaccount bankAccount;
    private BigDecimal notInBooktotalDebit;
    private BigDecimal notInBooktotalCredit;
    private BigDecimal notprocessedCredit;
    @Autowired
    private EGovernCommon eGovernCommon;
    private BigDecimal notprocessedDebit;
    private BigDecimal notprocessedNet;
    private BigDecimal notInBookNet;
    private String notInBookNetBal;
    private BigDecimal notInStatementTotalDebit;
    private BigDecimal notInStatementTotalCredit;
    private BigDecimal notInStatementNet;
    private BigDecimal bankBookBalance;
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    private BigDecimal brsBalance;
    private BigDecimal totalNotReconciledAmount;
    private Integer statusId;

    public BigDecimal getBankBookBalance() {
        return this.bankBookBalance;
    }

    public void setBankBookBalance(BigDecimal bankBookBalance) {
        this.bankBookBalance = bankBookBalance;
    }

    public BigDecimal getBrsBalance() {
        return this.brsBalance;
    }

    public void setBrsBalance(BigDecimal brsBalance) {
        this.brsBalance = brsBalance;
    }

    public Bankaccount getBankAccount() {
        return this.bankAccount;
    }

    public void setBankAccount(Bankaccount bankAccount) {
        this.bankAccount = bankAccount;
    }

    @Transactional
    public String upload() {
        try {
            this.insertQuery = this.persistenceService.getSession().createSQLQuery("insert into egf_brs_bankstatements (ID,ACCOUNTNUMBER,ACCOUNTID,TXDATE,TYPE,INSTRUMENTNO,DEBIT,CREDIT,BALANCE,NARRATION,CSLNO,CREATEDDATE) values (nextval('seq_egf_brs_bankstatements'),:accNo,:accountId,to_date(:txDate,'dd.mm.yyyy'),:type,:instrumentNo,:debit,:credit,:balance,:narration,:cslNo,CURRENT_DATE)");
            Bankaccount ba = (Bankaccount)this.persistenceService.find("from Bankaccount ba where id=?", new Object[]{(long)this.accountId.intValue()});
            this.accNo = ba.getAccountnumber();
            POIFSFileSystem fs = new POIFSFileSystem((InputStream)new FileInputStream(this.bankStatmentInXls));
            HSSFWorkbook wb = new HSSFWorkbook(fs);
            wb.getNumberOfSheets();
            HSSFSheet sheet = wb.getSheetAt(0);
            sheet.getFirstRowNum();
            HSSFRow row = sheet.getRow(2);
            if (row == null) {
                this.bank_account_not_match_msg = this.bank_account_not_match_msg.replace("#name", this.bankStatmentInXlsFileName);
                throw new ValidationException(Arrays.asList(new ValidationError(this.bank_account_not_match_msg, this.bank_account_not_match_msg)));
            }
            String strValue2 = this.getStrValue(row.getCell(0));
            if (!(strValue2 = strValue2.substring(strValue2.indexOf(58) + 1, strValue2.indexOf(45)).trim()).equals(this.accNo.trim())) {
                this.bank_account_not_match_msg = this.bank_account_not_match_msg.replace("#name", this.bankStatmentInXlsFileName);
                throw new ValidationException(Arrays.asList(new ValidationError(this.bank_account_not_match_msg, this.bank_account_not_match_msg)));
            }
            AutoReconcileBean ab = null;
            HSSFRow detailRow = null;
            String dateStr = null;
            this.rowIndex = 8;
            this.count = 0;
            do {
                try {
                    ab = new AutoReconcileBean();
                    if (this.rowIndex == 8) {
                        detailRow = sheet.getRow(this.rowIndex);
                        if (this.rowIndex >= 9290 && LOGGER.isDebugEnabled()) {
                            LOGGER.debug((Object)detailRow.getRowNum());
                        }
                        if (this.alreadyUploaded(dateStr = this.getStrValue(detailRow.getCell(1)))) {
                            this.file_already_uploaded = this.file_already_uploaded.replace("#name", this.bankStatmentInXlsFileName);
                            throw new ValidationException(Arrays.asList(new ValidationError(this.file_already_uploaded, this.file_already_uploaded)));
                        }
                        ab.setTxDateStr(dateStr);
                    }
                    ab.setTxDateStr(dateStr);
                    ab.setInstrumentNo(this.getStrValue(detailRow.getCell(4)));
                    ab.setDebit(this.getNumericValue(detailRow.getCell(5)));
                    ab.setCredit(this.getNumericValue(detailRow.getCell(6)));
                    ab.setBalance(this.getNumericValue(detailRow.getCell(7)));
                    String strValue = this.getStrValue(detailRow.getCell(2));
                    if (strValue != null) {
                        if (strValue.length() > 125) {
                            strValue = strValue.substring(0, 125);
                        }
                        ab.setNarration(strValue);
                    }
                    ab.setType(this.getStrValue(detailRow.getCell(3)));
                    ab.setCSLno(this.getStrValue(detailRow.getCell(8)));
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info((Object)(detailRow.getRowNum() + "   " + ab.toString()));
                    }
                    this.insert(ab);
                    if (this.count % 20 == 0) {
                        this.persistenceService.getSession().flush();
                    }
                }
                catch (ValidationException ve) {
                    throw ve;
                }
                catch (NumberFormatException e) {
                    this.failureMessage = !this.isFailed ? this.failureMessage + (detailRow.getRowNum() + 1) : this.failureMessage + " , " + detailRow.getRowNum() + 1;
                    this.isFailed = true;
                    throw new ValidationException(Arrays.asList(new ValidationError(this.failureMessage, this.failureMessage)));
                }
                ++this.rowIndex;
                ++this.count;
            } while ((dateStr = (detailRow = sheet.getRow(this.rowIndex)) != null ? this.getStrValue(detailRow.getCell(1)) : null) != null && !dateStr.isEmpty());
            if (this.isFailed) {
                throw new ValidationException(Arrays.asList(new ValidationError(this.failureMessage, this.failureMessage)));
            }
            this.message = "BankStatement upload completed Successfully # rows processed".replace("#", "" + this.count);
        }
        catch (FileNotFoundException e) {
            throw new ValidationException(Arrays.asList(new ValidationError("File cannot be uploaded", "File cannot be uploaded")));
        }
        catch (IOException e) {
            throw new ValidationException(Arrays.asList(new ValidationError("Unable to read uploaded file", "Unable to read uploaded file")));
        }
        catch (ValidationException ve) {
            throw ve;
        }
        catch (NullPointerException npe) {
            throw new ValidationException(Arrays.asList(new ValidationError(this.bankStatementFormat, this.bankStatementFormat)));
        }
        catch (Exception e) {
            throw new ValidationException(Arrays.asList(new ValidationError(this.bankStatementFormat, this.bankStatementFormat)));
        }
        return "upload";
    }

    private void insert(AutoReconcileBean ab) {
        this.insertQuery.setString("accNo", this.accNo).setInteger("accountId", this.accountId.intValue()).setString("txDate", ab.getTxDateStr()).setString("type", ab.getType()).setString("instrumentNo", ab.getInstrumentNo()).setBigDecimal("debit", ab.getDebit()).setBigDecimal("credit", ab.getCredit()).setBigDecimal("balance", ab.getBalance()).setString("narration", ab.getNarration()).setString("cslNo", ab.getCSLno());
        this.insertQuery.executeUpdate();
    }

    private boolean alreadyUploaded(String dateStr) {
        List list = this.persistenceService.getSession().createSQLQuery("select id from egf_brs_bankstatements where accountid=" + this.accountId + " and txdate=to_date('" + dateStr + "','" + "dd.mm.yyyy" + "')").list();
        return list.size() >= 1;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getFailureMessage() {
        return this.failureMessage;
    }

    public void setFailureMessage(String failureMessage) {
        this.failureMessage = failureMessage;
    }

    private String getStrValue(HSSFCell cell) {
        if (cell == null) {
            return null;
        }
        double numericCellValue = 0.0;
        String strValue = "";
        switch (cell.getCellType()) {
            case 0: {
                numericCellValue = cell.getNumericCellValue();
                DecimalFormat decimalFormat = new DecimalFormat("#");
                strValue = decimalFormat.format(numericCellValue);
                break;
            }
            case 1: {
                strValue = cell.getStringCellValue();
            }
        }
        return strValue;
    }

    private BigDecimal getNumericValue(HSSFCell cell) {
        if (cell == null) {
            return null;
        }
        double numericCellValue = 0.0;
        BigDecimal bigDecimalValue = BigDecimal.ZERO;
        String strValue = "";
        switch (cell.getCellType()) {
            case 0: {
                numericCellValue = cell.getNumericCellValue();
                bigDecimalValue = BigDecimal.valueOf(numericCellValue);
                break;
            }
            case 1: {
                strValue = cell.getStringCellValue();
                strValue = strValue.replaceAll("[^\\p{L}\\p{Nd}]", "");
                if (strValue != null && strValue.contains("E+")) {
                    String[] split = strValue.split("E+");
                    String mantissa = split[0].replaceAll(".", "");
                    int exp = Integer.parseInt(split[1]);
                    while (mantissa.length() <= exp + 1) {
                        mantissa = mantissa + "0";
                    }
                    numericCellValue = Double.parseDouble(mantissa);
                    bigDecimalValue = BigDecimal.valueOf(numericCellValue);
                } else if (strValue != null && strValue.contains(",")) {
                    strValue = strValue.replaceAll(",", "");
                }
                try {
                    numericCellValue = Double.parseDouble(strValue);
                    bigDecimalValue = BigDecimal.valueOf(numericCellValue);
                    break;
                }
                catch (Exception e) {
                    if (!LOGGER.isDebugEnabled()) break;
                    LOGGER.debug((Object)("Found : Non numeric value in Numeric Field :" + strValue + ":"));
                }
            }
        }
        return bigDecimalValue;
    }

    @Transactional
    public String schedule() {
        this.count = 0;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Started at " + new Date()));
        }
        this.markForProcessing("CLG");
        this.persistenceService.getSession().flush();
        this.findandUpdateDuplicates();
        List detailList = this.getStatmentsForProcessing("CLG");
        String statusQury = "select id from EgwStatus where upper(moduletype)=upper('instrument') and  upper(description)=upper('Reconciled')";
        this.statusId = (Integer)this.persistenceService.find("select id from EgwStatus where upper(moduletype)=upper('instrument') and  upper(description)=upper('Reconciled')");
        Long instrumentTypeId = this.getInstrumentType("cheque");
        Long instrumentTypeDDId = this.getInstrumentType("dd");
        String recociliationQuery = "update EGF_InstrumentHeader set id_status=:statusId,  lastmodifiedby=:userId,lastmodifieddate=CURRENT_DATE where id= (select id from egf_instrumentheader where instrumentNumber=:instrumentNo and  instrumentAmount=:amount and bankaccountid=:accountId and ispaycheque=:ispaycheque and instrumentType in (" + instrumentTypeId + "," + instrumentTypeDDId + ")" + " and id_status=(select id from Egw_Status where upper(moduletype)=upper('instrument') and  upper(description)=upper(:instrumentStatus)))";
        String recociliationAmountQuery = "update egf_instrumentOtherdetails set reconciledamount=:amount,instrumentstatusdate=:txDate  ,lastmodifiedby=:userId,lastmodifieddate=CURRENT_DATE,reconciledOn=:reconciliationDate  where instrumentheaderid= (select id from egf_instrumentheader where instrumentNumber=:instrumentNo and  instrumentAmount=:amount and bankaccountid=:accountId and ispaycheque=:ispaycheque and instrumentType in (" + instrumentTypeId + "," + instrumentTypeDDId + ")" + " and id_status=(select id from Egw_Status where upper(moduletype)=upper('instrument') and  upper(description)=upper(:instrumentStatus)))";
        SQLQuery updateQuery = this.persistenceService.getSession().createSQLQuery(recociliationQuery);
        SQLQuery updateQuery2 = this.persistenceService.getSession().createSQLQuery(recociliationAmountQuery);
        String backUpdateBankStmtquery = "update egf_brs_bankstatements set action='processed' ,reconciliationDate=:reconciliationDate where id=:id";
        String backUpdateFailureBRSquery = "update egf_brs_bankstatements set action='to be processed manually',errormessage=:e where id=:id";
        SQLQuery backupdateQuery = this.persistenceService.getSession().createSQLQuery("update egf_brs_bankstatements set action='processed' ,reconciliationDate=:reconciliationDate where id=:id");
        SQLQuery backupdateFailureQuery = this.persistenceService.getSession().createSQLQuery("update egf_brs_bankstatements set action='to be processed manually',errormessage=:e where id=:id");
        this.rowCount = 0;
        for (AutoReconcileBean bean : detailList) {
            int updated = -1;
            try {
                updateQuery.setLong("statusId", (long)this.statusId.intValue());
                updateQuery.setLong("accountId", (long)this.accountId.intValue());
                updateQuery.setString("instrumentNo", bean.getInstrumentNo());
                updateQuery.setInteger("userId", ApplicationThreadLocals.getUserId().intValue());
                updateQuery2.setDate("txDate", bean.getTxDate());
                updateQuery2.setDate("reconciliationDate", this.reconciliationDate);
                updateQuery2.setLong("accountId", (long)this.accountId.intValue());
                updateQuery2.setString("instrumentNo", bean.getInstrumentNo());
                updateQuery2.setInteger("userId", ApplicationThreadLocals.getUserId().intValue());
                if (bean.getDebit() != null && bean.getDebit().compareTo(BigDecimal.ZERO) != 0) {
                    updateQuery.setBigDecimal("amount", bean.getDebit());
                    updateQuery.setCharacter("ispaycheque", '1');
                    updateQuery.setString("instrumentStatus", "New");
                    updated = updateQuery.executeUpdate();
                    if (updated != 0) {
                        updateQuery2.setBigDecimal("amount", bean.getDebit());
                        updateQuery2.setCharacter("ispaycheque", '1');
                        updateQuery2.setString("instrumentStatus", "Reconciled");
                        updated = updateQuery2.executeUpdate();
                    }
                } else {
                    updateQuery.setBigDecimal("amount", bean.getCredit());
                    updateQuery.setCharacter("ispaycheque", '0');
                    updateQuery.setString("instrumentStatus", "Deposited");
                    updated = updateQuery.executeUpdate();
                    if (updated != 0) {
                        updateQuery2.setBigDecimal("amount", bean.getCredit());
                        updateQuery2.setCharacter("ispaycheque", '0');
                        updateQuery2.setString("instrumentStatus", "Reconciled");
                        updated = updateQuery2.executeUpdate();
                    }
                }
                if (updated == 0) {
                    backupdateFailureQuery.setLong("id", bean.getId().longValue());
                    backupdateFailureQuery.setString("e", DID_NOT_FIND_MATCH_IN_BANKBOOK);
                    backupdateFailureQuery.executeUpdate();
                } else {
                    backupdateQuery.setLong("id", bean.getId().longValue());
                    backupdateQuery.setDate("reconciliationDate", this.reconciliationDate);
                    backupdateQuery.executeUpdate();
                    ++this.count;
                }
                ++this.rowCount;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("out of " + this.rowCount + "==>succesfull " + this.count));
                }
                if (this.rowCount % 20 != 0) continue;
                this.persistenceService.getSession().flush();
            }
            catch (HibernateException e) {
                if (e.getCause().getMessage().contains("single-row subquery returns more")) {
                    backupdateFailureQuery.setString("e", "found more than one match in instruments");
                } else {
                    backupdateFailureQuery.setString("e", e.getMessage());
                }
                backupdateFailureQuery.setLong("id", bean.getId().longValue());
                backupdateFailureQuery.executeUpdate();
            }
            catch (Exception e) {
                backupdateFailureQuery.setLong("id", bean.getId().longValue());
                backupdateFailureQuery.setString("e", e.getMessage());
                backupdateFailureQuery.executeUpdate();
            }
        }
        this.processCSL();
        return "result";
    }

    private Long getInstrumentType(String typeName) {
        return (Long)this.persistenceService.find("select id from InstrumentType where upper(type)=upper(?)", new Object[]{typeName});
    }

    private void markForProcessing(String type) {
        StringBuffer sql = new StringBuffer(256);
        sql.append("update ").append("egf_brs_bankstatements").append(" set action='").append("to be processed").append("' where type='").append(type).append("' and accountid=:accountId and txdate>=:fromDate and txDate<=:toDate and  (action is null or action!='processed')");
        if (BRS_TRANSACTION_TYPE_BANK.equalsIgnoreCase(type)) {
            sql.append(" and CSLno is not null ");
        }
        SQLQuery markQuery = this.persistenceService.getSession().createSQLQuery(sql.toString());
        markQuery.setDate("fromDate", this.fromDate);
        markQuery.setDate("toDate", this.toDate);
        markQuery.setLong("accountId", (long)this.accountId.intValue());
        markQuery.executeUpdate();
    }

    private void processCSL() {
        this.markForProcessing(BRS_TRANSACTION_TYPE_BANK);
        List CSLList = this.getStatmentsForProcessing(BRS_TRANSACTION_TYPE_BANK);
        Long instrumentTypeId = this.getInstrumentType("banktobank");
        String recociliationQuery = "update EGF_InstrumentHeader set id_status=:statusId,  lastmodifiedby=:userId,lastmodifieddate=CURRENT_DATE where id = (select ih.id from egf_instrumentheader ih,egf_instrumentvoucher iv,voucherheader vh where   instrumentAmount=:amount and bankaccountid=:accountId and ispaycheque=:ispaycheque and instrumentType in (" + instrumentTypeId + ")" + " and id_status=(select id from Egw_Status where upper(moduletype)=upper('instrument') and  upper(description)=" + " upper(:instrumentStatus)) and iv.instrumentheaderid=ih.id and iv.voucherheaderid=ih.id and vh.vouchernumber=:cslNo )  ";
        String recociliationAmountQuery = "update egf_instrumentOtherdetails set reconciledamount=:amount,instrumentstatusdate=:txDate  ,lastmodifiedby=:userId,lastmodifieddate=CURRENT_DATE,reconciledOn=:reconciliationDate  where instrumentheaderid =  (select ih.id from egf_instrumentheader ih,egf_instrumentvoucher iv,voucherheader vh where   instrumentAmount=:amount and bankaccountid=:accountId and ispaycheque=:ispaycheque and instrumentType in (" + instrumentTypeId + ")" + " and id_status=(select id from Egw_Status where upper(moduletype)=upper('instrument') and  upper(description)=" + " upper(:instrumentStatus)) and iv.instrumentheaderid=ih.id and iv.voucherheaderid=ih.id and vh.vouchernumber=:cslNo ) ";
        SQLQuery updateQuery = this.persistenceService.getSession().createSQLQuery(recociliationQuery);
        SQLQuery updateQuery2 = this.persistenceService.getSession().createSQLQuery(recociliationAmountQuery);
        String backUpdateBankStmtquery = "update egf_brs_bankstatements set action='processed' ,reconciliationDate=:reconciliationDate where id=:id";
        String backUpdateFailureBRSquery = "update egf_brs_bankstatements set action='to be processed manually',errormessage=:e where id=:id";
        SQLQuery backupdateQuery = this.persistenceService.getSession().createSQLQuery("update egf_brs_bankstatements set action='processed' ,reconciliationDate=:reconciliationDate where id=:id");
        SQLQuery backupdateFailureQuery = this.persistenceService.getSession().createSQLQuery("update egf_brs_bankstatements set action='to be processed manually',errormessage=:e where id=:id");
        for (AutoReconcileBean bean : CSLList) {
            int updated = -1;
            try {
                updateQuery.setLong("statusId", (long)this.statusId.intValue());
                updateQuery.setLong("accountId", (long)this.accountId.intValue());
                updateQuery.setString("cslNo", bean.getCSLno());
                updateQuery.setInteger("userId", ApplicationThreadLocals.getUserId().intValue());
                updateQuery2.setDate("txDate", bean.getTxDate());
                updateQuery2.setDate("reconciliationDate", this.reconciliationDate);
                updateQuery2.setLong("accountId", (long)this.accountId.intValue());
                updateQuery2.setString("cslNo", bean.getCSLno());
                updateQuery2.setInteger("userId", ApplicationThreadLocals.getUserId().intValue());
                if (bean.getDebit() != null && bean.getDebit().compareTo(BigDecimal.ZERO) != 0) {
                    updateQuery.setBigDecimal("amount", bean.getDebit());
                    updateQuery.setCharacter("ispaycheque", '1');
                    updateQuery.setString("instrumentStatus", "New");
                    updated = updateQuery.executeUpdate();
                    if (updated != 0) {
                        updateQuery2.setBigDecimal("amount", bean.getDebit());
                        updateQuery2.setCharacter("ispaycheque", '1');
                        updateQuery2.setString("instrumentStatus", "Reconciled");
                        updated = updateQuery2.executeUpdate();
                    }
                } else {
                    updateQuery.setBigDecimal("amount", bean.getCredit());
                    updateQuery.setCharacter("ispaycheque", '1');
                    updateQuery.setString("instrumentStatus", "New");
                    updated = updateQuery.executeUpdate();
                    if (updated != 0) {
                        updateQuery2.setBigDecimal("amount", bean.getCredit());
                        updateQuery2.setCharacter("ispaycheque", '1');
                        updateQuery2.setString("instrumentStatus", "Reconciled");
                        updated = updateQuery2.executeUpdate();
                    }
                    if (updated == 0) {
                        // empty if block
                    }
                }
                if (updated == 0) {
                    backupdateFailureQuery.setLong("id", bean.getId().longValue());
                    backupdateFailureQuery.setString("e", DID_NOT_FIND_MATCH_IN_BANKBOOK);
                    backupdateFailureQuery.executeUpdate();
                } else if (updated == -1) {
                    backupdateFailureQuery.setLong("id", bean.getId().longValue());
                    backupdateFailureQuery.setString("e", DID_NOT_FIND_MATCH_IN_BANKBOOK);
                    backupdateFailureQuery.executeUpdate();
                } else {
                    backupdateQuery.setLong("id", bean.getId().longValue());
                    backupdateQuery.setDate("reconciliationDate", this.reconciliationDate);
                    backupdateQuery.executeUpdate();
                    ++this.count;
                }
                ++this.rowCount;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("out of " + this.rowCount + "==>succesfull " + this.count));
                }
                if (this.rowCount % 20 != 0) continue;
                this.persistenceService.getSession().flush();
            }
            catch (HibernateException e) {
                if (e.getCause().getMessage().contains("single-row subquery returns more")) {
                    backupdateFailureQuery.setString("e", "found more than one match in instruments");
                } else {
                    backupdateFailureQuery.setString("e", e.getMessage());
                }
                backupdateFailureQuery.setLong("id", bean.getId().longValue());
                backupdateFailureQuery.executeUpdate();
            }
            catch (Exception e) {
                backupdateFailureQuery.setLong("id", bean.getId().longValue());
                backupdateFailureQuery.setString("e", e.getMessage());
                backupdateFailureQuery.executeUpdate();
            }
        }
    }

    private List<AutoReconcileBean> getStatmentsForProcessing(String type) {
        SQLQuery detailQuery = this.persistenceService.getSession().createSQLQuery("select id,txDate,instrumentNo,debit,credit,CSLno  from egf_brs_bankstatements where accountId=:accountId  and type='" + type + "' and action='" + "to be processed" + "'");
        detailQuery.setLong("accountId", (long)this.accountId.intValue());
        detailQuery.addScalar("id", (Type)LongType.INSTANCE).addScalar("txDate").addScalar("instrumentNo").addScalar("debit").addScalar("credit").addScalar("CSLno").setResultTransformer(Transformers.aliasToBean(AutoReconcileBean.class));
        List detailList = detailQuery.list();
        return detailList;
    }

    @Action(value="/brs/autoReconciliation-generateReport")
    @Transactional(readOnly=true)
    public String generateReport() {
        try {
            this.bankBookBalance = this.eGovernCommon.getAccountBalance(this.dateFormatter.format(this.toDate), this.accountId.toString()).setScale(2, 4);
        }
        catch (HibernateException e) {
            throw new ApplicationRuntimeException(e.getMessage());
        }
        catch (TaskFailedException e) {
            throw new ApplicationRuntimeException(e.getMessage());
        }
        this.bankAccount = (Bankaccount)this.persistenceService.find("from Bankaccount ba where id=?", new Object[]{(long)this.accountId.intValue()});
        String statmentsNotInBankBookStr = "select id,txDate,instrumentNo,debit,credit,narration,type,action as \"errorCode\",errorMessage from egf_brs_bankstatements where accountId=:accountId and txdate>=:fromDate  and txdate<=:toDate and reconciliationdate is null and (errorMesSage is null or errorMessage !=:multipleEntryErrorMessage) order by  txDate ";
        Query statmentsNotInBankBookQry = this.persistenceService.getSession().createSQLQuery("select id,txDate,instrumentNo,debit,credit,narration,type,action as \"errorCode\",errorMessage from egf_brs_bankstatements where accountId=:accountId and txdate>=:fromDate  and txdate<=:toDate and reconciliationdate is null and (errorMesSage is null or errorMessage !=:multipleEntryErrorMessage) order by  txDate ").addScalar("instrumentNo").addScalar("credit").addScalar("debit").addScalar("txDate").addScalar("id", (Type)LongType.INSTANCE).addScalar("narration").addScalar("type").addScalar("errorCode").addScalar("errorMessage").setResultTransformer(Transformers.aliasToBean(AutoReconcileBean.class));
        statmentsNotInBankBookQry.setDate("fromDate", this.fromDate).setDate("toDate", this.toDate).setString("multipleEntryErrorMessage", "found more than one match in instruments").setLong("accountId", (long)this.accountId.intValue());
        this.statementsNotInBankBookList = statmentsNotInBankBookQry.list();
        this.notInBooktotalDebit = BigDecimal.ZERO;
        this.notInBooktotalCredit = BigDecimal.ZERO;
        this.notInBookNet = BigDecimal.ZERO;
        for (AutoReconcileBean ab : this.statementsNotInBankBookList) {
            this.notInBooktotalDebit = this.notInBooktotalDebit.add(ab.getDebit() == null ? BigDecimal.ZERO : ab.getDebit());
            this.notInBooktotalCredit = this.notInBooktotalCredit.add(ab.getCredit() == null ? BigDecimal.ZERO : ab.getCredit());
        }
        this.notInBookNet = this.notInBooktotalCredit.subtract(this.notInBooktotalDebit);
        this.notInBookNetBal = this.notInBookNet.compareTo(BigDecimal.ZERO) == -1 ? this.notInBookNet + "(Dr)" : this.notInBookNet + "(Cr)";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("notInBookNet" + this.notInBookNet));
        }
        CFinancialYear finYearByDate = this.financialYearDAO.getFinYearByDate(this.toDate);
        this.finYearStartDate = finYearByDate.getStartingDate();
        String entriesNotInBankStamentStr = "select  instrumentnumber as \"instrumentNo\", instrumentdate as \"txDate\", instrumentamount as \"credit\",null as \"debit\", payto as \"narration\"  from egf_instrumentheader  where bankaccountid=:accountId and instrumentdate BETWEEN :fromDate and :toDate and ispaycheque='0' and id_status=(select id from egw_status where moduletype='Instrument'  and description='Deposited') and instrumentnumber is not null and instrumentamount is not null and instrumentnumber||'-'||instrumentamount not in (select  instrumentno||'-'|| credit from egf_brs_bankstatements  where accountid=:accountId and txdate between :fromDate and :toDate and action=:action and errorMessage =:multipleEntryErrorMessage  and instrumentno is not null and  credit is not null and credit>0)  union  select   instrumentnumber as \"instrumentNo\", instrumentdate as \"txDate\", instrumentamount \"debit\",null as \"credit\", payto as \"narration\"  from egf_instrumentheader where bankaccountid=:accountId and instrumentdate BETWEEN :fromDate and :toDate  and ispaycheque='1' and id_status=(select id from egw_status where moduletype='Instrument'  and description='New') and  instrumentnumber is not null   and instrumentamount is not null and instrumentnumber||'-'||instrumentamount not in  (select  instrumentno||'-'|| debit from egf_brs_bankstatements where accountid=:accountId and txdate between :fromDate and :toDate and action=:action and errorMessage =:multipleEntryErrorMessage  and instrumentno is not null and debit is not null and debit>0) order by \"txDate\"";
        Query entriesNotInBankStamentQry = this.persistenceService.getSession().createSQLQuery(entriesNotInBankStamentStr).addScalar("instrumentNo").addScalar("credit").addScalar("debit").addScalar("txDate").addScalar("narration").setResultTransformer(Transformers.aliasToBean(AutoReconcileBean.class));
        entriesNotInBankStamentQry.setDate("fromDate", this.finYearStartDate).setDate("toDate", this.toDate).setString("action", "to be processed manually").setLong("accountId", (long)this.accountId.intValue()).setString("multipleEntryErrorMessage", "found more than one match in instruments");
        this.entriesNotInBankStament = entriesNotInBankStamentQry.list();
        this.notInStatementTotalDebit = BigDecimal.ZERO;
        this.notInStatementTotalCredit = BigDecimal.ZERO;
        this.notInStatementNet = BigDecimal.ZERO;
        for (AutoReconcileBean ab : this.entriesNotInBankStament) {
            this.notInStatementTotalDebit = this.notInStatementTotalDebit.add(ab.getDebit() == null ? BigDecimal.ZERO : ab.getDebit());
            LOGGER.error((Object)("no=" + ab.getInstrumentNo() + " t =" + this.notInStatementTotalCredit + " a=" + ab.getCredit()));
            this.notInStatementTotalCredit = this.notInStatementTotalCredit.add(ab.getCredit() == null ? BigDecimal.ZERO : ab.getCredit());
        }
        LOGGER.error((Object)("notInStatementTotalCredit==" + this.notInStatementTotalCredit + "           " + "notInStatementTotalDebit==" + this.notInStatementTotalDebit));
        this.notInStatementNet = this.notInStatementTotalCredit.subtract(this.notInStatementTotalDebit);
        entriesNotInBankStamentStr = "select  sum(instrumentamount) as \"credit\"  from egf_instrumentheader  where bankaccountid=:accountId and instrumentdate BETWEEN :fromDate and :toDate and ispaycheque='0' and id_status=(select id from egw_status where moduletype='Instrument'  and description='Deposited') and instrumentnumber is not null and instrumentamount is not null and instrumentnumber||'-'||instrumentamount not in (select  instrumentno||'-'|| credit from egf_brs_bankstatements  where accountid=:accountId and txdate between :fromDate and :toDate and action=:action and errorMessage =:multipleEntryErrorMessage  and instrumentno is not null and  credit is not null and credit>0)  union  select   sum(instrumentamount) as \"credit\"  from egf_instrumentheader where bankaccountid=:accountId and instrumentdate BETWEEN :fromDate and :toDate  and ispaycheque='1' and id_status=(select id from egw_status where moduletype='Instrument'  and description='New') and  instrumentnumber is not null   and instrumentamount is not null and instrumentnumber||'-'||instrumentamount not in  (select  instrumentno||'-'|| debit from egf_brs_bankstatements where accountid=:accountId and txdate between :fromDate and :toDate and action=:action and errorMessage =:multipleEntryErrorMessage  and instrumentno is not null and debit is not null and debit>0) ";
        entriesNotInBankStamentQry = this.persistenceService.getSession().createSQLQuery(entriesNotInBankStamentStr).addScalar("credit").setResultTransformer(Transformers.aliasToBean(AutoReconcileBean.class));
        entriesNotInBankStamentQry.setDate("fromDate", this.finYearStartDate).setDate("toDate", this.toDate).setString("action", "to be processed manually").setLong("accountId", (long)this.accountId.intValue()).setString("multipleEntryErrorMessage", "found more than one match in instruments");
        List entriesNotInBankStament1 = entriesNotInBankStamentQry.list();
        if (entriesNotInBankStament1.size() > 0) {
            this.notInStatementTotalCredit = ((AutoReconcileBean)entriesNotInBankStament1.get(0)).getCredit();
            if (this.notInStatementTotalCredit == null) {
                this.notInStatementTotalCredit = BigDecimal.ZERO;
            }
        }
        if (entriesNotInBankStament1.size() > 1) {
            this.notInStatementTotalDebit = ((AutoReconcileBean)entriesNotInBankStament1.get(1)).getCredit();
            if (this.notInStatementTotalDebit == null) {
                this.notInStatementTotalDebit = BigDecimal.ZERO;
            }
        }
        this.notInStatementNet = this.notInStatementTotalCredit.subtract(this.notInStatementTotalDebit);
        String statmentsfoundButNotProcessed = "select id,txDate,instrumentNo,debit,credit,narration,type,action as \"errorCode\",errorMessage from egf_brs_bankstatements where accountId=:accountId and txdate>=:fromDate  and txdate<=:toDate and reconciliationdate is null  and  errorMessage =:multipleEntryErrorMessage order by  txDate ";
        Query statmentsfoundButNotProcessedQry = this.persistenceService.getSession().createSQLQuery("select id,txDate,instrumentNo,debit,credit,narration,type,action as \"errorCode\",errorMessage from egf_brs_bankstatements where accountId=:accountId and txdate>=:fromDate  and txdate<=:toDate and reconciliationdate is null  and  errorMessage =:multipleEntryErrorMessage order by  txDate ").addScalar("instrumentNo").addScalar("credit").addScalar("debit").addScalar("txDate").addScalar("id", (Type)LongType.INSTANCE).addScalar("narration").addScalar("type").addScalar("errorCode").addScalar("errorMessage").setResultTransformer(Transformers.aliasToBean(AutoReconcileBean.class));
        statmentsfoundButNotProcessedQry.setDate("fromDate", this.fromDate).setDate("toDate", this.toDate).setString("multipleEntryErrorMessage", "found more than one match in instruments").setLong("accountId", (long)this.accountId.intValue());
        this.statementsFoundButNotProcessed = statmentsfoundButNotProcessedQry.list();
        this.notprocessedDebit = BigDecimal.ZERO;
        this.notprocessedCredit = BigDecimal.ZERO;
        this.notprocessedNet = BigDecimal.ZERO;
        for (AutoReconcileBean ab : this.statementsFoundButNotProcessed) {
            LOGGER.error((Object)("notprocessedDebit==" + this.notprocessedDebit + "           " + ab.getDebit()));
            this.notprocessedDebit = this.notprocessedDebit.add(ab.getDebit() == null ? BigDecimal.ZERO : ab.getDebit());
            LOGGER.error((Object)("notprocessedCredit==" + this.notprocessedCredit + "           " + ab.getCredit()));
            this.notprocessedCredit = this.notprocessedCredit.add(ab.getCredit() == null ? BigDecimal.ZERO : ab.getCredit());
            LOGGER.error((Object)("notprocessedDebit==" + this.notprocessedDebit + "           " + "notprocessedCredit==" + this.notprocessedCredit));
        }
        LOGGER.error((Object)("notprocessedDebit==" + this.notprocessedDebit + "           " + "notprocessedCredit==" + this.notprocessedCredit));
        this.notprocessedNet = this.notprocessedCredit.subtract(this.notprocessedDebit);
        LOGGER.error((Object)("notprocessedDebit==" + this.notprocessedDebit + "           " + "notprocessedCredit==" + this.notprocessedCredit));
        this.totalNotReconciledAmount = this.notInStatementNet.add(this.notprocessedNet.negate());
        this.brsBalance = this.bankBookBalance.add(this.notInStatementNet).add(this.notInBookNet).add(this.notprocessedNet);
        return "report";
    }

    public BigDecimal getTotalNotReconciledAmount() {
        return this.totalNotReconciledAmount;
    }

    public void setTotalNotReconciledAmount(BigDecimal totalNotReconciledAmount) {
        this.totalNotReconciledAmount = totalNotReconciledAmount;
    }

    public BigDecimal getNotInBooktotalDebit() {
        return this.notInBooktotalDebit;
    }

    public BigDecimal getNotInBooktotalCredit() {
        return this.notInBooktotalCredit;
    }

    public BigDecimal getNotInBookNet() {
        return this.notInBookNet;
    }

    public BigDecimal getNotInStatementTotalDebit() {
        return this.notInStatementTotalDebit;
    }

    public BigDecimal getNotInStatementTotalCredit() {
        return this.notInStatementTotalCredit;
    }

    public BigDecimal getNotInStatementNet() {
        return this.notInStatementNet;
    }

    public void setNotInBooktotalDebit(BigDecimal notInBooktotalDebit) {
        this.notInBooktotalDebit = notInBooktotalDebit;
    }

    public void setNotInBooktotalCredit(BigDecimal notInBooktotalCredit) {
        this.notInBooktotalCredit = notInBooktotalCredit;
    }

    public void setNotInBookNet(BigDecimal notInBookNet) {
        this.notInBookNet = notInBookNet;
    }

    public void setNotInStatementTotalDebit(BigDecimal notInStatementTotalDebit) {
        this.notInStatementTotalDebit = notInStatementTotalDebit;
    }

    public void setNotInStatementTotalCredit(BigDecimal notInStatementTotalCredit) {
        this.notInStatementTotalCredit = notInStatementTotalCredit;
    }

    public void setNotInStatementNet(BigDecimal notInStatementNet) {
        this.notInStatementNet = notInStatementNet;
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public void setRowIndex(int rowIndex) {
        this.rowIndex = rowIndex;
    }

    public void setRowCount(int rowCount) {
        this.rowCount = rowCount;
    }

    private void findandUpdateDuplicates() {
        try {
            String duplicates = "select instrumentNo,debit,accountId from egf_brs_bankstatements where accountId=:accountId and debit>0 and action='to be processed'  group by  instrumentNo,debit,accountId having count(*)>1";
            SQLQuery paymentDuplicateChequesQuery = this.persistenceService.getSession().createSQLQuery(duplicates);
            paymentDuplicateChequesQuery.addScalar("instrumentNo").addScalar("debit").addScalar("accountId", (Type)LongType.INSTANCE).setResultTransformer(Transformers.aliasToBean(AutoReconcileBean.class));
            paymentDuplicateChequesQuery.setLong("accountId", (long)this.accountId.intValue());
            List duplicatePaymentCheques = paymentDuplicateChequesQuery.list();
            String backUpdateDuplicatePaymentquery = "update egf_brs_bankstatements set action='to be processed manually', errorMessage='duplicate instrument number within the bankstament' where debit=:debit and accountid=:accountId and instrumentNo=:instrumentNo  and action='to be processed'";
            SQLQuery paymentDuplicateUpdate = this.persistenceService.getSession().createSQLQuery("update egf_brs_bankstatements set action='to be processed manually', errorMessage='duplicate instrument number within the bankstament' where debit=:debit and accountid=:accountId and instrumentNo=:instrumentNo  and action='to be processed'");
            for (AutoReconcileBean bean : duplicatePaymentCheques) {
                paymentDuplicateUpdate.setLong("accountId", bean.getAccountId().longValue());
                paymentDuplicateUpdate.setBigDecimal("debit", bean.getDebit());
                paymentDuplicateUpdate.setString("instrumentNo", bean.getInstrumentNo());
                paymentDuplicateUpdate.executeUpdate();
            }
            duplicates = "select instrumentNo,credit,accountId from egf_brs_bankstatements where accountid=:accountId and  credit>0 and action='to be processed' group by  instrumentNo,credit,accountId having count(*)>1";
            SQLQuery receiptsDuplicateChequesQuery = this.persistenceService.getSession().createSQLQuery(duplicates);
            receiptsDuplicateChequesQuery.addScalar("instrumentNo").addScalar("credit").addScalar("accountId", (Type)LongType.INSTANCE).setResultTransformer(Transformers.aliasToBean(AutoReconcileBean.class));
            receiptsDuplicateChequesQuery.setLong("accountId", (long)this.accountId.intValue());
            List duplicateReceiptsCheques = receiptsDuplicateChequesQuery.list();
            String backUpdateDuplicateReceiptsQuery = "update egf_brs_bankstatements set action='to be processed manually' ,errorMessage='duplicate instrument number within the bankstament' where credit=:credit and accountid=:accountId and instrumentNo=:instrumentNo  and action='to be processed'";
            SQLQuery receiptDuplicateUpdate = this.persistenceService.getSession().createSQLQuery("update egf_brs_bankstatements set action='to be processed manually' ,errorMessage='duplicate instrument number within the bankstament' where credit=:credit and accountid=:accountId and instrumentNo=:instrumentNo  and action='to be processed'");
            for (AutoReconcileBean bean : duplicateReceiptsCheques) {
                receiptDuplicateUpdate.setLong("accountId", bean.getAccountId().longValue());
                receiptDuplicateUpdate.setBigDecimal("credit", bean.getCredit());
                receiptDuplicateUpdate.setString("instrumentNo", bean.getInstrumentNo());
                receiptDuplicateUpdate.executeUpdate();
            }
        }
        catch (HibernateException e) {
            throw new ApplicationRuntimeException("Failed while processing autoreconciliation ");
        }
    }

    public Date getReconciliationDate() {
        return this.reconciliationDate;
    }

    public void setReconciliationDate(Date reconciliationDate) {
        this.reconciliationDate = reconciliationDate;
    }

    public Date getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(Date fromDate) {
        this.fromDate = fromDate;
    }

    public Date getToDate() {
        return this.toDate;
    }

    public void setToDate(Date toDate) {
        this.toDate = toDate;
    }

    public int getAccountId() {
        return this.accountId;
    }

    public void setAccountId(int accountId) {
        this.accountId = accountId;
    }

    public File getBankStatmentInXls() {
        return this.bankStatmentInXls;
    }

    public void setBankStatmentInXls(File bankStatmentInXls) {
        this.bankStatmentInXls = bankStatmentInXls;
    }

    public void setBankStatmentInXlsContentType(String bankStatmentInXlsContentType) {
    }

    public void setBankStatmentInXlsFileName(String bankStatmentInXlsFileName) {
        this.bankStatmentInXlsFileName = bankStatmentInXlsFileName;
    }

    public String getAccNo() {
        return this.accNo;
    }

    public void setAccNo(String accNo) {
        this.accNo = accNo;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public List<AutoReconcileBean> getStatementsNotInBankBookList() {
        return this.statementsNotInBankBookList;
    }

    public void setStatementsNotInBankBookList(List<AutoReconcileBean> statementsNotInBankBookList) {
        this.statementsNotInBankBookList = statementsNotInBankBookList;
    }

    public void setFinancialYearDAO(FinancialYearDAO financialYearDAO) {
        this.financialYearDAO = financialYearDAO;
    }

    public List<AutoReconcileBean> getEntriesNotInBankStament() {
        return this.entriesNotInBankStament;
    }

    public void setEntriesNotInBankStament(List<AutoReconcileBean> entriesNotInBankStament) {
        this.entriesNotInBankStament = entriesNotInBankStament;
    }

    public List<AutoReconcileBean> getStatementsFoundButNotProcessed() {
        return this.statementsFoundButNotProcessed;
    }

    public BigDecimal getNotprocessedNet() {
        return this.notprocessedNet;
    }

    public void setStatementsFoundButNotProcessed(List<AutoReconcileBean> statementsFoundButNotProcessed) {
        this.statementsFoundButNotProcessed = statementsFoundButNotProcessed;
    }

    public void setNotprocessedNet(BigDecimal notprocessedNet) {
        this.notprocessedNet = notprocessedNet;
    }

    public String getNotInBookNetBal() {
        return this.notInBookNetBal;
    }

    public boolean isFailed() {
        return this.isFailed;
    }

    public void setFailed(boolean isFailed) {
        this.isFailed = isFailed;
    }

    public BigDecimal getNotprocessedCredit() {
        return this.notprocessedCredit;
    }

    public void setNotprocessedCredit(BigDecimal notprocessedCredit) {
        this.notprocessedCredit = notprocessedCredit;
    }

    public BigDecimal getNotprocessedDebit() {
        return this.notprocessedDebit;
    }

    public void setNotprocessedDebit(BigDecimal notprocessedDebit) {
        this.notprocessedDebit = notprocessedDebit;
    }

    public String getSuccessMessage() {
        return "BankStatement upload completed Successfully # rows processed";
    }

    public void setNotInBookNetBal(String notInBookNetBal) {
        this.notInBookNetBal = notInBookNetBal;
    }
}

