/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.bill;

import com.opensymphony.xwork2.validator.annotations.RequiredFieldValidator;
import com.opensymphony.xwork2.validator.annotations.Validations;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.script.ScriptContext;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.commons.Accountdetailtype;
import org.egov.commons.CChartOfAccountDetail;
import org.egov.commons.CChartOfAccounts;
import org.egov.commons.CFunction;
import org.egov.commons.EgwStatus;
import org.egov.commons.utils.EntityType;
import org.egov.egf.autonumber.ExpenseBillNumberGenerator;
import org.egov.egf.web.actions.bill.BaseBillAction;
import org.egov.egf.web.actions.bill.ContingentBillAction;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.persistence.utils.ApplicationSequenceNumberGenerator;
import org.egov.infra.script.service.ScriptService;
import org.egov.infra.utils.NumberToWord;
import org.egov.infra.utils.autonumber.AutonumberServiceBeanResolver;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.infra.workflow.matrix.entity.WorkFlowMatrix;
import org.egov.infstr.models.EgChecklists;
import org.egov.infstr.services.PersistenceService;
import org.egov.infstr.utils.EgovMasterDataCaching;
import org.egov.model.bills.EgBillPayeedetails;
import org.egov.model.bills.EgBillSubType;
import org.egov.model.bills.EgBilldetails;
import org.egov.model.bills.EgBillregister;
import org.egov.model.bills.EgBillregistermis;
import org.egov.model.voucher.VoucherDetails;
import org.egov.model.voucher.WorkflowBean;
import org.egov.utils.CheckListHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@ParentPackage(value="egov")
@Results(value={@Result(name={"new"}, location="contingentBill-new.jsp"), @Result(name={"messages"}, location="contingentBill-messages.jsp"), @Result(name={"view"}, location="contingentBill-view.jsp")})
public class ContingentBillAction
extends BaseBillAction {
    private static final String FORWARD = "Forward";
    private static final String ACCOUNT_DETAIL_TYPE_LIST = "accountDetailTypeList";
    private static final String BILL_SUB_TYPE_LIST = "billSubTypeList";
    private static final String USER_LIST = "userList";
    private static final String DESIGNATION_LIST = "designationList";
    private static final String MODE = "mode";
    private static final String APPROVER_USER_ID = "approverUserId";
    private static final String END = "END";
    private static final String APPROVE = "approve";
    private static final String ACTION_NAME = "actionName";
    private static final String WFITEMSTATE = "wfitemstate";
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(ContingentBillAction.class);
    private BigDecimal debitSum = BigDecimal.ZERO;
    private BigDecimal billAmount = BigDecimal.ZERO;
    private EgBillregister bill = new EgBillregister();
    private boolean showPrintPreview;
    private String sanctionedMessge;
    private Department primaryDepartment;
    private String cutOffDate;
    protected DateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
    DateFormat df = new SimpleDateFormat("dd-MMM-yyyy");
    DateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
    SimpleDateFormat formatter1 = new SimpleDateFormat("yyyy-MM-dd");
    Date date;
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    @Autowired
    private EgovMasterDataCaching masterDataCache;
    @Autowired
    private ApplicationSequenceNumberGenerator sequenceGenerator;
    @Autowired
    private AutonumberServiceBeanResolver beanResolver;

    public StateAware getModel() {
        return super.getModel();
    }

    public void prepare() {
        super.prepare();
        this.accountDetailTypeList = this.persistenceService.findAllBy("from Accountdetailtype where isactive=true order by name", new Object[0]);
        this.addDropdownData(ACCOUNT_DETAIL_TYPE_LIST, this.accountDetailTypeList);
        this.addDropdownData(BILL_SUB_TYPE_LIST, this.getBillSubTypes());
        this.addDropdownData(USER_LIST, Collections.EMPTY_LIST);
        this.addDropdownData(DESIGNATION_LIST, Collections.EMPTY_LIST);
        this.getNetPayableCodes();
        this.billDetailslist = new ArrayList();
        this.billDetailslist.add(new VoucherDetails());
        LinkedHashMap<String, String> mp = new LinkedHashMap<String, String>();
        mp.put("na", this.getText("na"));
        mp.put("yes", this.getText("yes"));
        mp.put("no", this.getText("no"));
        this.commonBean.setCheckListValuesMap(mp);
        if (this.mandatoryFields.contains("department")) {
            List deptList = this.masterDataCache.get("egi-department");
            this.addDropdownData("departmentList", deptList);
            this.addDropdownData("billDepartmentList", this.persistenceService.findAllBy("from Department order by name", new Object[0]));
        }
    }

    public void prepareNewform() {
        this.billDetailslist = new ArrayList();
        this.billDetailslist.add(new VoucherDetails());
        this.billDetailsTableFinal = null;
        this.billDetailsTableNetFinal = null;
        this.billDetailsTableCreditFinal = null;
        this.checkListsTable = null;
        this.subledgerlist = null;
    }

    private void getNetPayableCodes() {
        List configValuesByModuleAndKey = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "contingencyBillPurposeIds");
        List configValuesByModuleAndKeydefault = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "contingencyBillDefaultPurposeId");
        String tempCBillDefaulPurposeId = ((AppConfigValues)configValuesByModuleAndKeydefault.get(0)).getValue();
        Long cBillDefaulPurposeId = Long.valueOf(tempCBillDefaulPurposeId);
        this.netPayList = new ArrayList();
        List accountCodeByPurpose = new ArrayList();
        for (int i = 0; i < configValuesByModuleAndKey.size(); ++i) {
            try {
                accountCodeByPurpose = this.chartOfAccountsHibernateDAO.getAccountCodeByPurpose(Integer.valueOf(((AppConfigValues)configValuesByModuleAndKey.get(i)).getValue()));
            }
            catch (NumberFormatException e) {
                LOGGER.error((Object)("Inside getNetPayableCodes" + e.getMessage()), (Throwable)e);
            }
            catch (Exception e) {
                LOGGER.error((Object)("inside getNetPayableCodes" + e.getMessage()));
            }
            for (CChartOfAccounts coa : accountCodeByPurpose) {
                this.detailTypeIdandName = coa.getGlcode() + "~" + this.getDetailTypesForCoaId(coa.getId()) + "^" + this.detailTypeIdandName;
            }
            if (((AppConfigValues)configValuesByModuleAndKey.get(i)).getValue().equals(cBillDefaulPurposeId)) {
                for (CChartOfAccounts coa : accountCodeByPurpose) {
                    if (coa.getPurposeId().compareTo(cBillDefaulPurposeId) != 0) continue;
                    this.defaultNetPayCode = coa;
                }
            }
            this.netPayList.addAll(accountCodeByPurpose);
        }
        Collections.sort(this.netPayList, new COAcomparator(this));
        for (CChartOfAccounts c : this.netPayList) {
            if (!LOGGER.isInfoEnabled()) continue;
            LOGGER.info((Object)c.getGlcode());
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("netPayList............................." + this.netPayList.size()));
        }
        this.getSession().put("netPayList", this.netPayList);
    }

    @SkipValidation
    @Action(value="/bill/contingentBill-newform")
    public String newform() {
        List cutOffDateconfigValue = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "DataEntryCutOffDate");
        if (!cutOffDateconfigValue.isEmpty()) {
            try {
                Date date = this.df.parse(((AppConfigValues)cutOffDateconfigValue.get(0)).getValue());
                this.cutOffDate = this.formatter.format(date);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        this.reset();
        this.commonBean.setBillDate(this.getDefaultDate());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("bigllDetailslist.............................." + this.billDetailslist.size()));
        }
        return "new";
    }

    @ValidationErrorPage(value="view")
    @SkipValidation
    @Action(value="/bill/contingentBill-update")
    public String update() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Contingent Bill Action  | update | start");
        }
        Integer userId = -1;
        try {
            this.bill = (EgBillregister)this.getPersistenceService().find(" from EgBillregister where id=?", new Object[]{Long.valueOf(((String[])this.parameters.get("billRegisterId"))[0])});
            if (null == this.bill.getEgBillregistermis().getSourcePath()) {
                this.bill.getEgBillregistermis().setSourcePath("/EGF/bill/contingentBill!beforeView.action?billRegisterId=" + this.bill.getId());
            }
            this.populateWorkflowBean();
            this.bill = this.egBillRegisterService.sendForApproval(this.bill, this.workflowBean);
            if ("Reject".equalsIgnoreCase(this.workflowBean.getWorkFlowAction())) {
                this.addActionMessage(this.getText("bill.rejected", new String[]{this.voucherService.getEmployeeNameForPositionId(this.bill.getState().getOwnerPosition())}));
            }
            if (FORWARD.equalsIgnoreCase(this.workflowBean.getWorkFlowAction())) {
                this.addActionMessage(this.getText("bill.forwarded", new String[]{this.voucherService.getEmployeeNameForPositionId(this.bill.getState().getOwnerPosition())}));
            }
            if ("Cancel".equalsIgnoreCase(this.workflowBean.getWorkFlowAction())) {
                this.addActionMessage(this.getText("cbill.cancellation.succesful"));
            } else if ("Approve".equalsIgnoreCase(this.workflowBean.getWorkFlowAction())) {
                if ("Closed".equals(this.bill.getState().getValue())) {
                    this.addActionMessage(this.getText("bill.final.approval", new String[]{"The File has been approved"}));
                } else {
                    this.addActionMessage(this.getText("bill.approved", new String[]{this.voucherService.getEmployeeNameForPositionId(this.bill.getState().getOwnerPosition())}));
                }
            }
        }
        catch (ValidationException e) {
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.add(new ValidationError("exp", ((ValidationError)e.getErrors().get(0)).getMessage()));
            throw new ValidationException(errors);
        }
        catch (Exception e) {
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.add(new ValidationError("exp", e.getMessage()));
            throw new ValidationException(errors);
        }
        return "messages";
    }

    private void reset() {
        this.voucherHeader.reset();
        this.commonBean.reset();
        this.billDetailsTableCreditFinal = null;
        this.billDetailsTableFinal = null;
        this.billDetailsTableNetFinal = null;
        this.subledgerlist = null;
        this.billDetailsTableSubledger = null;
        this.checkListsTable = null;
    }

    public void prepareCreate() {
        this.loadSchemeSubscheme();
    }

    @Validations(requiredFields={@RequiredFieldValidator(fieldName="fundId", message="", key="required"), @RequiredFieldValidator(fieldName="commonBean.billDate", message="", key="required"), @RequiredFieldValidator(fieldName="commonBean.billSubType", message="", key="required"), @RequiredFieldValidator(fieldName="commonBean.payto", message="", key="required")})
    @ValidationErrorPage(value="new")
    @Action(value="/bill/contingentBill-create")
    public String create() {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)this.billDetailsTableCreditFinal);
        }
        try {
            this.voucherHeader.setVoucherDate(this.commonBean.getBillDate());
            this.voucherHeader.setVoucherNumber(this.commonBean.getBillNumber());
            String voucherDate = this.formatter1.format(this.voucherHeader.getVoucherDate());
            String cutOffDate1 = null;
            if (this.commonBean.getFunctionId() != null) {
                CFunction function1 = (CFunction)this.getPersistenceService().find(" from CFunction where id=?", new Object[]{this.commonBean.getFunctionId().longValue()});
                this.voucherHeader.getVouchermis().setFunction(function1);
            }
            HashMap headerDetails = this.createHeaderAndMisDetails();
            headerDetails.put("sourcepath", "/EGF/bill/contingentBill-beforeView.action?billRegisterId=");
            EgBillregistermis mis = new EgBillregistermis();
            this.bill = this.setBillDetailsFromHeaderDetails(this.bill, mis, true);
            this.bill = this.createBillDetails(this.bill);
            this.validateLedgerAndSubledger();
            this.bill = this.checkBudgetandGenerateNumber(this.bill);
            this.validateFields();
            if (!this.isBillNumberGenerationAuto() && !this.isBillNumUnique(this.commonBean.getBillNumber())) {
                throw new ValidationException(Arrays.asList(new ValidationError("bill number", "Duplicate Bill Number : " + this.commonBean.getBillNumber())));
            }
            this.populateWorkflowBean();
            this.bill = this.egBillRegisterService.createBill(this.bill, this.workflowBean, this.checkListsTable);
            this.addActionMessage(this.getText("cbill.transaction.succesful") + this.bill.getBillnumber());
            this.billRegisterId = this.bill.getId();
            if (!this.cutOffDate.isEmpty() && this.cutOffDate != null) {
                try {
                    this.date = this.sdf.parse(this.cutOffDate);
                    cutOffDate1 = this.formatter1.format(this.date);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            if (cutOffDate1 != null && voucherDate.compareTo(cutOffDate1) <= 0 && "Create And Approve".equalsIgnoreCase(this.workflowBean.getWorkFlowAction())) {
                if (this.bill.getEgBillregistermis().getBudgetaryAppnumber() != null) {
                    this.addActionMessage(this.getText("budget.recheck.sucessful", new String[]{this.bill.getEgBillregistermis().getBudgetaryAppnumber()}));
                }
            } else {
                if (this.bill.getEgBillregistermis().getBudgetaryAppnumber() != null) {
                    this.addActionMessage(this.getText("budget.recheck.sucessful", new String[]{this.bill.getEgBillregistermis().getBudgetaryAppnumber()}));
                }
                this.addActionMessage(this.getText("bill.forwarded", new String[]{this.voucherService.getEmployeeNameForPositionId(this.bill.getState().getOwnerPosition())}));
            }
        }
        catch (ValidationException e) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)"Inside catch block");
            }
            if (this.billDetailsTableSubledger == null) {
                this.billDetailsTableSubledger = new ArrayList();
            }
            if (this.billDetailsTableSubledger.size() == 0) {
                this.billDetailsTableSubledger.add(new VoucherDetails());
            }
            this.prepare();
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.add(new ValidationError("exp", ((ValidationError)e.getErrors().get(0)).getMessage()));
            throw new ValidationException(errors);
        }
        return "messages";
    }

    public List<String> getValidActions() {
        List cutOffDateconfigValue = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "DataEntryCutOffDate");
        List<String> validActions = Collections.emptyList();
        if (!cutOffDateconfigValue.isEmpty()) {
            if (null == this.bill || null == this.bill.getId() || this.bill.getCurrentState().getValue().endsWith("NEW")) {
                validActions = Arrays.asList(FORWARD, "Create And Approve");
            } else if (this.bill.getCurrentState() != null) {
                validActions = this.customizedWorkFlowService.getNextValidActions(this.bill.getStateType(), this.getWorkFlowDepartment(), this.getAmountRule(), this.getAdditionalRule(), this.bill.getCurrentState().getValue(), this.getPendingActions(), this.bill.getCreatedDate());
            }
        } else if (null == this.bill || null == this.bill.getId() || this.bill.getCurrentState().getValue().endsWith("NEW")) {
            validActions = Arrays.asList(FORWARD);
        } else if (this.bill.getCurrentState() != null) {
            validActions = this.customizedWorkFlowService.getNextValidActions(this.bill.getStateType(), this.getWorkFlowDepartment(), this.getAmountRule(), this.getAdditionalRule(), this.bill.getCurrentState().getValue(), this.getPendingActions(), this.bill.getCreatedDate());
        }
        return validActions;
    }

    public String getNextAction() {
        WorkFlowMatrix wfMatrix = null;
        if (this.bill.getId() != null) {
            wfMatrix = this.bill.getCurrentState() != null ? this.customizedWorkFlowService.getWfMatrix(this.bill.getStateType(), this.getWorkFlowDepartment(), this.getAmountRule(), this.getAdditionalRule(), this.bill.getCurrentState().getValue(), this.getPendingActions(), this.bill.getCreatedDate()) : this.customizedWorkFlowService.getWfMatrix(this.bill.getStateType(), this.getWorkFlowDepartment(), this.getAmountRule(), this.getAdditionalRule(), "Created", this.getPendingActions(), this.bill.getCreatedDate());
        }
        return wfMatrix == null ? "" : wfMatrix.getNextAction();
    }

    @SkipValidation
    @ValidationErrorPage(value="edit")
    public String edit() {
        EgBillregister cbill = null;
        if (this.getButton().toLowerCase().contains("cancel")) {
            this.cancelBill();
        } else {
            try {
                cbill = (EgBillregister)this.persistenceService.find("from EgBillregister where id=?", new Object[]{this.billRegisterId});
                if (cbill != null && cbill.getState() != null && !this.validateOwner(cbill.getState()).booleanValue()) {
                    throw new ApplicationRuntimeException("Invalid Aceess");
                }
                this.voucherHeader.setVoucherDate(this.commonBean.getBillDate());
                this.voucherHeader.setVoucherNumber(this.commonBean.getBillNumber());
                this.validateFields();
                cbill = this.updateBill(cbill);
                this.validateLedgerAndSubledger();
                this.recreateCheckList(cbill);
                this.forwardBill(cbill);
            }
            catch (ValidationException e) {
                LOGGER.error((Object)("Inside catch block" + e.getMessage()));
                this.beforeViewWF(cbill);
                if (this.billDetailsTableSubledger == null) {
                    this.billDetailsTableSubledger = new ArrayList();
                }
                if (this.billDetailsTableSubledger.size() == 0) {
                    this.billDetailsTableSubledger.add(new VoucherDetails());
                }
                throw e;
            }
        }
        return "messages";
    }

    private void cancelBill() {
        EgBillregister cbill = null;
        cbill = (EgBillregister)this.persistenceService.find("from Cbill where id=?", new Object[]{this.billRegisterId});
        if (cbill != null && cbill.getState() != null && !this.validateOwner(cbill.getState()).booleanValue()) {
            throw new ApplicationRuntimeException("Invalid Aceess");
        }
        if (((String[])this.parameters.get(ACTION_NAME))[0].contains("reject")) {
            cbill.getCreatedBy().getId().intValue();
        }
        cbill.transition().end().withOwner(this.getPosition()).withComments(((String[])this.parameters.get("comments"))[0]);
        String statusQury = "from EgwStatus where upper(moduletype)=upper('EXPENSEBILL') and  upper(description)=upper('Cancelled')";
        EgwStatus egwStatus = (EgwStatus)this.persistenceService.find("from EgwStatus where upper(moduletype)=upper('EXPENSEBILL') and  upper(description)=upper('Cancelled')");
        cbill.setStatus(egwStatus);
        cbill.setBillstatus("Cancelled");
        this.persistenceService.persist((Object)cbill);
        this.persistenceService.getSession().flush();
        this.addActionMessage(this.getText("cbill.cancellation.succesful"));
    }

    private void removeEmptyRows() {
        ArrayList<VoucherDetails> trash = new ArrayList<VoucherDetails>();
        if (this.billDetailsTableCreditFinal != null) {
            for (VoucherDetails vd : this.billDetailsTableCreditFinal) {
                if (vd == null) {
                    trash.add(vd);
                    continue;
                }
                if (vd.getGlcodeDetail() != null) continue;
                trash.add(vd);
            }
        }
        for (VoucherDetails vd : trash) {
            this.billDetailsTableCreditFinal.remove(vd);
        }
        trash.clear();
        if (this.billDetailsTableFinal != null) {
            for (VoucherDetails vd : this.billDetailsTableFinal) {
                if (vd == null) {
                    trash.add(vd);
                    continue;
                }
                if (vd.getGlcodeDetail() != null) continue;
                trash.add(vd);
            }
        }
        for (VoucherDetails vd : trash) {
            this.billDetailsTableFinal.remove(vd);
        }
        trash.clear();
        if (this.billDetailsTableSubledger != null) {
            for (VoucherDetails vd : this.billDetailsTableSubledger) {
                if (vd == null) {
                    trash.add(vd);
                    continue;
                }
                if (vd.getSubledgerCode() != null && !vd.getSubledgerCode().equals("")) continue;
                trash.add(vd);
            }
        }
        for (VoucherDetails vd : trash) {
            this.billDetailsTableSubledger.remove(vd);
        }
    }

    private void validateLedgerAndSubledger() {
        ArrayList finalList = new ArrayList();
        this.removeEmptyRows();
        if (this.billDetailsTableFinal != null) {
            finalList.addAll(this.billDetailsTableFinal);
        }
        if (this.billDetailsTableCreditFinal != null) {
            finalList.addAll(this.billDetailsTableCreditFinal);
        }
        if (this.billDetailsTableNetFinal != null) {
            finalList.addAll(this.billDetailsTableNetFinal);
        }
        this.billDetailsTableSubledger = this.rearrangeSubledger(this.billDetailsTableSubledger);
        if (this.billDetailsTableSubledger == null) {
            this.billDetailsTableSubledger = new ArrayList();
        }
        if (this.validateData(finalList, this.billDetailsTableSubledger)) {
            throw new ValidationException(Arrays.asList(new ValidationError("Ledger.validation.failed", "Ledger.validation.failed")));
        }
    }

    private List<VoucherDetails> rearrangeSubledger(List<VoucherDetails> billDetailsTableSubledger) {
        if (billDetailsTableSubledger != null && this.commonBean.getSubledgerType() != null && this.commonBean.getSubledgerType() > 0) {
            Accountdetailtype detailType = (Accountdetailtype)this.persistenceService.find("from Accountdetailtype where id=? order by name", new Object[]{this.commonBean.getSubledgerType()});
            for (VoucherDetails vd : billDetailsTableSubledger) {
                vd.setAmount(vd.getDebitAmountDetail());
                CChartOfAccounts coa = (CChartOfAccounts)this.persistenceService.find("from CChartOfAccounts where glcode=?", new Object[]{vd.getSubledgerCode()});
                vd.setGlcode(coa);
                vd.setDetailType(detailType);
                vd.setDetailKeyId(Integer.valueOf(vd.getDetailKey()));
            }
        }
        return billDetailsTableSubledger;
    }

    private void recreateCheckList(EgBillregister bill) {
        List checkLists = this.persistenceService.findAllBy("from org.egov.infstr.models.EgChecklists where objectid=?", new Object[]{this.billRegisterId});
        for (EgChecklists chk : checkLists) {
            this.persistenceService.delete((Object)chk);
        }
    }

    private EgBillregister updateBill(EgBillregister bill) {
        HashMap headerDetails = this.createHeaderAndMisDetails();
        headerDetails.put("sourcepath", "/EGF/bill/contingentBill!beforeView.action?billRegisterId=");
        Boolean recreateBillnumber = false;
        if (bill.getEgBillregistermis().getEgDepartment() != null && this.voucherHeader.getVouchermis().getDepartmentid() != null && bill.getEgBillregistermis().getEgDepartment().getId() != this.voucherHeader.getVouchermis().getDepartmentid().getId()) {
            recreateBillnumber = true;
        }
        bill = this.setBillDetailsFromHeaderDetails(bill, bill.getEgBillregistermis(), recreateBillnumber.booleanValue());
        Set EgBillSet = bill.getEgBilldetailes();
        Iterator billDetItr = EgBillSet.iterator();
        EgBilldetails billDet = null;
        while (billDetItr.hasNext()) {
            try {
                billDet = (EgBilldetails)billDetItr.next();
                billDetItr.remove();
            }
            catch (Exception e) {
                LOGGER.error((Object)("Inside updateBill" + e.getMessage()), (Throwable)e);
            }
        }
        this.persistenceService.getSession().flush();
        bill.setEgBilldetailes(EgBillSet);
        EgBillSet.addAll(this.updateBillDetails(bill));
        this.checkBudgetandGenerateNumber(bill);
        this.persistenceService.getSession().refresh((Object)bill);
        this.persistenceService.persist((Object)bill);
        this.persistenceService.getSession().flush();
        return bill;
    }

    private EgBillregister checkBudgetandGenerateNumber(EgBillregister bill) {
        try {
            ScriptContext scriptContext = ScriptService.createContext((Object[])new Object[]{"voucherService", this.voucherService, "bill", bill});
            this.scriptService.executeScript("egf.bill.budgetcheck", scriptContext);
        }
        catch (ValidationException e) {
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.add(new ValidationError("exp", ((ValidationError)e.getErrors().get(0)).getMessage()));
            throw new ValidationException(errors);
        }
        catch (Exception e) {
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.add(new ValidationError("exp", e.getMessage()));
            throw new ValidationException(errors);
        }
        return bill;
    }

    private void forwardBill(EgBillregister cbill) {
        Integer userId = null;
        userId = null != this.parameters.get(APPROVER_USER_ID) && Integer.valueOf(((String[])this.parameters.get(APPROVER_USER_ID))[0]) != -1 ? Integer.valueOf(((String[])this.parameters.get(APPROVER_USER_ID))[0]) : Integer.valueOf(ApplicationThreadLocals.getUserId().intValue());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("User selected id is : " + userId));
        }
        this.addActionMessage(this.getText("bill.forwarded", new String[]{this.voucherService.getEmployeeNameForPositionId(cbill.getState().getOwnerPosition())}));
    }

    @SkipValidation
    @Action(value="/bill/contingentBill-beforeView")
    public String beforeView() throws ClassNotFoundException {
        this.bill = (EgBillregister)this.egBillRegisterService.find("from EgBillregister where id=?", new Object[]{this.billRegisterId});
        this.bill = this.prepareForViewModifyReverse();
        this.addDropdownData(USER_LIST, Collections.EMPTY_LIST);
        this.addDropdownData("billDepartmentList", this.persistenceService.findAllBy("from Department order by name", new Object[0]));
        this.mode = null != this.parameters.get(MODE) && ((String[])this.parameters.get(MODE))[0].equalsIgnoreCase(APPROVE) ? APPROVE : "view";
        return "view";
    }

    private void beforeViewWF(EgBillregister cbill) {
        Map map = this.primaryDepartment != null && this.primaryDepartment.getId() != null ? this.voucherService.getDesgBYPassingWfItem("cbill.nextUser", (Object)cbill, Integer.valueOf(this.primaryDepartment.getId().intValue())) : this.voucherService.getDesgBYPassingWfItem("cbill.nextUser", (Object)cbill, Integer.valueOf(this.voucherHeader.getVouchermis().getDepartmentid().getId().intValue()));
        this.addDropdownData(DESIGNATION_LIST, (List)map.get(DESIGNATION_LIST));
        this.addDropdownData(USER_LIST, Collections.EMPTY_LIST);
        this.nextLevel = map.get(WFITEMSTATE) != null ? map.get(WFITEMSTATE).toString() : null;
    }

    private EgBillregister prepareForViewModifyReverse() throws ClassNotFoundException {
        this.billDetailsTableNetFinal = new ArrayList();
        this.billDetailsTableCreditFinal = new ArrayList();
        this.billDetailsTableFinal = new ArrayList();
        this.billDetailsTableSubledger = new ArrayList();
        this.checkListsTable = new ArrayList();
        EgBillregister cbill = (EgBillregister)this.egBillRegisterService.find("from EgBillregister where id=?", new Object[]{this.billRegisterId});
        this.getHeadersFromBill(cbill);
        this.billAmount = cbill.getBillamount();
        Set egBilldetailes = cbill.getEgBilldetailes();
        for (EgBilldetails detail : egBilldetailes) {
            VoucherDetails vd = new VoucherDetails();
            BigDecimal glcodeid = detail.getGlcodeid();
            CChartOfAccounts coa = (CChartOfAccounts)this.persistenceService.find("from CChartOfAccounts where id=?", new Object[]{Long.valueOf(glcodeid.toString())});
            vd.setGlcodeDetail(coa.getGlcode());
            vd.setGlcodeIdDetail(coa.getId());
            vd.setAccounthead(coa.getName());
            vd.setCreditAmountDetail(detail.getCreditamount() != null ? detail.getCreditamount().setScale(2, 6) : null);
            if (detail.getFunctionid() != null) {
                CFunction functionById = this.functionHibernateDAO.findById((Number)detail.getFunctionid().longValue(), false);
                this.commonBean.setFunctionName(functionById.getName());
                this.commonBean.setFunctionId(Integer.valueOf(functionById.getId().intValue()));
            }
            if (coa.getChartOfAccountDetails().size() > 0) {
                vd.setIsSubledger("true");
            } else {
                vd.setIsSubledger("false");
            }
            if (this.netPayList.contains(coa)) {
                vd.setCreditAmountDetail(detail.getCreditamount() != null ? detail.getCreditamount().setScale(2, 6) : null);
                this.billDetailsTableNetFinal.add(vd);
            } else if (detail.getCreditamount() != null && detail.getCreditamount().compareTo(BigDecimal.ZERO) != 0) {
                vd.setCreditAmountDetail(detail.getCreditamount().setScale(2, 6));
                this.billDetailsTableCreditFinal.add(vd);
            }
            if (detail.getDebitamount() != null && detail.getDebitamount().compareTo(BigDecimal.ZERO) != 0) {
                vd.setDebitAmountDetail(detail.getDebitamount().setScale(2, 6));
                this.billDetailsTableFinal.add(vd);
            }
            Set egBillPaydetailes = detail.getEgBillPaydetailes();
            for (EgBillPayeedetails payeedetail : egBillPaydetailes) {
                VoucherDetails subVd = new VoucherDetails();
                subVd.setDetailKey(payeedetail.getAccountDetailKeyId().toString());
                subVd.setAccounthead(coa.getName());
                subVd.setGlcodeDetail(coa.getGlcode());
                subVd.setSubledgerCode(coa.getGlcode());
                this.commonBean.setSubledgerType(payeedetail.getAccountDetailTypeId());
                Accountdetailtype detailType = (Accountdetailtype)this.persistenceService.find("from Accountdetailtype where id=? order by name", new Object[]{payeedetail.getAccountDetailTypeId()});
                String table = detailType.getFullQualifiedName();
                Class<?> service = Class.forName(table);
                String tableName = service.getSimpleName();
                EntityType entity = null;
                String dataType = "";
                try {
                    Method method = service.getMethod("getId", new Class[0]);
                    dataType = method.getReturnType().getSimpleName();
                    entity = dataType.equals("Long") ? (EntityType)this.persistenceService.find("from " + tableName + " where id=? order by name", new Object[]{payeedetail.getAccountDetailKeyId().longValue()}) : (EntityType)this.persistenceService.find("from " + tableName + " where id=? order by name", new Object[]{payeedetail.getAccountDetailKeyId()});
                }
                catch (Exception e) {
                    LOGGER.error((Object)("prepareForViewModifyReverse" + e.getMessage()), (Throwable)e);
                    throw new ApplicationRuntimeException(e.getMessage());
                }
                subVd.setDetailName(entity.getName());
                subVd.setDetailCode(entity.getCode());
                if (detail.getCreditamount() != null && detail.getCreditamount().compareTo(BigDecimal.ZERO) != 0) {
                    subVd.setDebitAmountDetail(payeedetail.getCreditAmount());
                } else {
                    subVd.setDebitAmountDetail(payeedetail.getDebitAmount());
                }
                this.billDetailsTableSubledger.add(subVd);
            }
        }
        if (this.billDetailsTableSubledger.size() == 0) {
            this.billDetailsTableSubledger.add(new VoucherDetails());
        }
        BigDecimal amt = cbill.getPassedamount().setScale(2, 6);
        String amountInWords = NumberToWord.convertToWord((String)amt.toString());
        this.sanctionedMessge = this.getText("cbill.getsanctioned.message", new String[]{amountInWords, cbill.getPassedamount().setScale(2, 6).toString()});
        this.sanctionedMessge = this.sanctionedMessge.substring(0, this.sanctionedMessge.length() - 15);
        List checkLists = this.persistenceService.findAllBy("from org.egov.infstr.models.EgChecklists where objectid=?", new Object[]{this.billRegisterId});
        for (EgChecklists chk : checkLists) {
            CheckListHelper chkHelper = new CheckListHelper();
            chkHelper.setName(chk.getAppconfigvalue().getValue());
            chkHelper.setVal(chk.getChecklistvalue());
            chkHelper.setId(chk.getAppconfigvalue().getId());
            this.checkListsTable.add(chkHelper);
        }
        return cbill;
    }

    private void getHeadersFromBill(EgBillregister cbill) {
        this.voucherHeader.setFundId(cbill.getEgBillregistermis().getFund());
        this.voucherHeader.getVouchermis().setDepartmentid(cbill.getEgBillregistermis().getEgDepartment());
        this.voucherHeader.getVouchermis().setDivisionid(cbill.getEgBillregistermis().getFieldid());
        this.voucherHeader.getVouchermis().setSchemeid(cbill.getEgBillregistermis().getScheme());
        this.voucherHeader.getVouchermis().setSubschemeid(cbill.getEgBillregistermis().getSubScheme());
        this.voucherHeader.getVouchermis().setFundsource(cbill.getEgBillregistermis().getFundsource());
        this.voucherHeader.setDescription(cbill.getNarration());
        this.commonBean.setBillDate(cbill.getBilldate());
        this.commonBean.setBillNumber(cbill.getBillnumber());
        if (null != cbill.getEgBillregistermis().getEgBillSubType()) {
            this.commonBean.setBillSubType(Integer.valueOf(cbill.getEgBillregistermis().getEgBillSubType().getId().intValue()));
        }
        this.commonBean.setInwardSerialNumber(cbill.getEgBillregistermis().getInwardSerialNumber());
        this.commonBean.setPartyBillNumber(cbill.getEgBillregistermis().getPartyBillNumber());
        this.commonBean.setPartyBillDate(cbill.getEgBillregistermis().getPartyBillDate());
        this.commonBean.setPayto(cbill.getEgBillregistermis().getPayto());
        if (null != cbill.getState()) {
            this.commonBean.setStateId(cbill.getState().getId());
        }
        this.commonBean.setBudgetReappNo(cbill.getEgBillregistermis().getBudgetaryAppnumber());
        String amountInWords = NumberToWord.amountInWords((Double)cbill.getPassedamount().doubleValue());
        this.sanctionedMessge = this.getText("cbill.getsanctioned.message", new String[]{amountInWords, cbill.getPassedamount().toString()});
        this.sanctionedMessge = this.sanctionedMessge.substring(0, this.sanctionedMessge.length() - 15);
    }

    @SkipValidation
    @Action(value="/bill/contingentBill-beforeEdit")
    public String beforeEdit() throws ClassNotFoundException {
        EgBillregister cbill = this.prepareForViewModifyReverse();
        this.addDropdownData(USER_LIST, Collections.EMPTY_LIST);
        if (null != this.parameters.get(MODE) && ((String[])this.parameters.get(MODE))[0].equalsIgnoreCase(APPROVE)) {
            this.beforeViewWF(cbill);
            this.mode = APPROVE;
        } else {
            this.mode = "view";
        }
        return "edit";
    }

    @SkipValidation
    public String beforeReverse() throws ClassNotFoundException {
        this.prepareForViewModifyReverse();
        return "reverse";
    }

    public List<CheckListHelper> getCheckListsTable() {
        return this.checkListsTable;
    }

    public void setCheckListsTable(List<CheckListHelper> checkListsTable) {
        this.checkListsTable = checkListsTable;
    }

    public String execute() {
        try {
            super.execute();
        }
        catch (Exception e) {
            LOGGER.error((Object)("Inside execute" + e.getMessage()), (Throwable)e);
            throw new ApplicationRuntimeException(e.getMessage());
        }
        this.billDetailslist = new ArrayList();
        this.billDetailslist.add(new VoucherDetails());
        this.billDetailslist.add(new VoucherDetails());
        return "new";
    }

    private EgBillregister createBillDetails(EgBillregister bill) {
        EgBillPayeedetails payeedetails;
        HashSet<EgBillPayeedetails> payeedetailsSet;
        EgBilldetails billdetails;
        HashSet<EgBilldetails> billdetailsSet = new HashSet<EgBilldetails>();
        String entityKey = null;
        int entityCount = 0;
        for (VoucherDetails vd : this.billDetailsTableFinal) {
            billdetails = new EgBilldetails();
            billdetails.setGlcodeid(BigDecimal.valueOf(vd.getGlcodeIdDetail()));
            if (this.commonBean.getFunctionId() != null) {
                billdetails.setFunctionid(BigDecimal.valueOf(this.commonBean.getFunctionId().intValue()));
            }
            billdetails.setDebitamount(vd.getDebitAmountDetail());
            this.debitSum = this.debitSum.add(vd.getDebitAmountDetail());
            billdetails.setEgBillregister(bill);
            if (vd.getIsSubledger().equalsIgnoreCase("true")) {
                payeedetailsSet = new HashSet<EgBillPayeedetails>();
                for (VoucherDetails sub : this.billDetailsTableSubledger) {
                    if (!vd.getGlcodeDetail().equalsIgnoreCase(sub.getSubledgerCode())) continue;
                    payeedetails = new EgBillPayeedetails();
                    payeedetails.setDebitAmount(sub.getDebitAmountDetail());
                    payeedetails.setAccountDetailKeyId(Integer.valueOf(sub.getDetailKey()));
                    payeedetails.setAccountDetailTypeId(this.commonBean.getSubledgerType());
                    payeedetails.setLastUpdatedTime(new Date());
                    billdetails.setLastupdatedtime(new Date());
                    payeedetails.setEgBilldetailsId(billdetails);
                    payeedetailsSet.add(payeedetails);
                    if (entityKey == null) {
                        entityKey = sub.getDetailKey();
                    }
                    if (entityKey.equals(sub.getDetailKey())) continue;
                    ++entityCount;
                }
                billdetails.setEgBillPaydetailes(payeedetailsSet);
            }
            billdetails.setLastupdatedtime(new Date());
            billdetailsSet.add(billdetails);
        }
        if (this.billDetailsTableCreditFinal != null) {
            for (VoucherDetails vd : this.billDetailsTableCreditFinal) {
                billdetails = new EgBilldetails();
                billdetails.setGlcodeid(BigDecimal.valueOf(vd.getGlcodeIdDetail()));
                if (this.commonBean.getFunctionId() != null) {
                    billdetails.setFunctionid(BigDecimal.valueOf(this.commonBean.getFunctionId().intValue()));
                }
                billdetails.setCreditamount(vd.getCreditAmountDetail());
                billdetails.setEgBillregister(bill);
                if (vd.getIsSubledger().equalsIgnoreCase("true")) {
                    payeedetailsSet = new HashSet();
                    for (VoucherDetails sub : this.billDetailsTableSubledger) {
                        if (!vd.getGlcodeDetail().equalsIgnoreCase(sub.getSubledgerCode())) continue;
                        payeedetails = new EgBillPayeedetails();
                        payeedetails.setCreditAmount(sub.getDebitAmountDetail());
                        payeedetails.setAccountDetailKeyId(Integer.valueOf(sub.getDetailKey()));
                        payeedetails.setAccountDetailTypeId(this.commonBean.getSubledgerType());
                        payeedetails.setLastUpdatedTime(new Date());
                        billdetails.setLastupdatedtime(new Date());
                        payeedetails.setEgBilldetailsId(billdetails);
                        payeedetailsSet.add(payeedetails);
                        if (entityKey == null) {
                            entityKey = sub.getDetailKey();
                        }
                        if (entityKey.equals(sub.getDetailKey())) continue;
                        ++entityCount;
                    }
                    billdetails.setEgBillPaydetailes(payeedetailsSet);
                }
                billdetails.setLastupdatedtime(new Date());
                billdetailsSet.add(billdetails);
            }
        }
        for (VoucherDetails vd : this.billDetailsTableNetFinal) {
            billdetails = new EgBilldetails();
            String netGlCode = vd.getGlcodeDetail();
            String[] netGl = netGlCode.split("-");
            CChartOfAccounts netCoa = (CChartOfAccounts)this.persistenceService.find("from CChartOfAccounts where glcode=?", new Object[]{netGl[0]});
            billdetails.setGlcodeid(BigDecimal.valueOf(netCoa.getId()));
            vd.setGlcodeIdDetail(netCoa.getId());
            if (this.isOneFunctionCenter() && this.commonBean.getFunctionId() != null) {
                billdetails.setFunctionid(BigDecimal.valueOf(this.commonBean.getFunctionId().intValue()));
            }
            billdetails.setCreditamount(vd.getCreditAmountDetail());
            bill.setBillamount(this.debitSum);
            bill.setPassedamount(this.debitSum);
            billdetails.setEgBillregister(bill);
            if (vd.getIsSubledger().equalsIgnoreCase("true")) {
                payeedetailsSet = new HashSet();
                for (VoucherDetails sub : this.billDetailsTableSubledger) {
                    if (!vd.getGlcodeDetail().equalsIgnoreCase(sub.getSubledgerCode())) continue;
                    payeedetails = new EgBillPayeedetails();
                    payeedetails.setCreditAmount(sub.getDebitAmountDetail());
                    payeedetails.setAccountDetailKeyId(Integer.valueOf(sub.getDetailKey()));
                    payeedetails.setAccountDetailTypeId(this.commonBean.getSubledgerType());
                    payeedetails.setLastUpdatedTime(new Date());
                    billdetails.setLastupdatedtime(new Date());
                    payeedetails.setEgBilldetailsId(billdetails);
                    payeedetailsSet.add(payeedetails);
                    if (entityKey == null) {
                        entityKey = sub.getDetailKey();
                    }
                    if (entityKey.equals(sub.getDetailKey())) continue;
                    ++entityCount;
                }
                billdetails.setEgBillPaydetailes(payeedetailsSet);
            }
            billdetails.setLastupdatedtime(new Date());
            billdetailsSet.add(billdetails);
        }
        bill.setEgBilldetailes(billdetailsSet);
        if (entityCount < 2) {
            bill.getEgBillregistermis().setPayto(this.commonBean.getPayto());
        } else {
            bill.getEgBillregistermis().setPayto("MULTIPLE");
        }
        return bill;
    }

    private Set<EgBilldetails> updateBillDetails(EgBillregister bill) {
        EgBillPayeedetails payeedetails;
        HashSet<EgBillPayeedetails> payeedetailsSet;
        EgBilldetails billdetails;
        HashSet<EgBilldetails> billdetailsSet = new HashSet<EgBilldetails>();
        String entityKey = null;
        int entityCount = 0;
        for (VoucherDetails vd : this.billDetailsTableFinal) {
            billdetails = new EgBilldetails();
            billdetails.setGlcodeid(BigDecimal.valueOf(vd.getGlcodeIdDetail()));
            if (this.commonBean.getFunctionId() != null) {
                billdetails.setFunctionid(BigDecimal.valueOf(this.commonBean.getFunctionId().intValue()));
            }
            billdetails.setDebitamount(vd.getDebitAmountDetail());
            this.debitSum = this.debitSum.add(vd.getDebitAmountDetail());
            billdetails.setEgBillregister(bill);
            if (vd.getIsSubledger().equalsIgnoreCase("true")) {
                payeedetailsSet = new HashSet<EgBillPayeedetails>();
                for (VoucherDetails sub : this.billDetailsTableSubledger) {
                    if (sub == null || !vd.getGlcodeDetail().equalsIgnoreCase(sub.getSubledgerCode())) continue;
                    payeedetails = new EgBillPayeedetails();
                    payeedetails.setDebitAmount(sub.getDebitAmountDetail());
                    payeedetails.setAccountDetailKeyId(Integer.valueOf(sub.getDetailKey()));
                    payeedetails.setAccountDetailTypeId(this.commonBean.getSubledgerType());
                    payeedetails.setEgBilldetailsId(billdetails);
                    payeedetailsSet.add(payeedetails);
                    if (entityKey == null) {
                        entityKey = sub.getDetailKey();
                    }
                    if (entityKey.equals(sub.getDetailKey())) continue;
                    ++entityCount;
                }
                billdetails.setEgBillPaydetailes(payeedetailsSet);
            }
            billdetails.setLastupdatedtime(new Date());
            billdetailsSet.add(billdetails);
        }
        if (this.billDetailsTableCreditFinal != null) {
            for (VoucherDetails vd : this.billDetailsTableCreditFinal) {
                billdetails = new EgBilldetails();
                billdetails.setGlcodeid(BigDecimal.valueOf(vd.getGlcodeIdDetail()));
                if (this.commonBean.getFunctionId() != null) {
                    billdetails.setFunctionid(BigDecimal.valueOf(this.commonBean.getFunctionId().intValue()));
                }
                billdetails.setCreditamount(vd.getCreditAmountDetail());
                billdetails.setEgBillregister(bill);
                if (vd.getIsSubledger().equalsIgnoreCase("true")) {
                    payeedetailsSet = new HashSet();
                    for (VoucherDetails sub : this.billDetailsTableSubledger) {
                        if (sub == null || !vd.getGlcodeDetail().equalsIgnoreCase(sub.getSubledgerCode())) continue;
                        payeedetails = new EgBillPayeedetails();
                        payeedetails.setCreditAmount(sub.getDebitAmountDetail());
                        payeedetails.setAccountDetailKeyId(Integer.valueOf(sub.getDetailKey()));
                        payeedetails.setAccountDetailTypeId(this.commonBean.getSubledgerType());
                        payeedetails.setEgBilldetailsId(billdetails);
                        payeedetailsSet.add(payeedetails);
                        if (entityKey == null) {
                            entityKey = sub.getDetailKey();
                        }
                        if (entityKey.equals(sub.getDetailKey())) continue;
                        ++entityCount;
                    }
                    billdetails.setEgBillPaydetailes(payeedetailsSet);
                }
                billdetails.setLastupdatedtime(new Date());
                billdetailsSet.add(billdetails);
            }
        }
        for (VoucherDetails vd : this.billDetailsTableNetFinal) {
            billdetails = new EgBilldetails();
            String netGlCode = vd.getGlcodeDetail();
            String[] netGl = netGlCode.split("-");
            CChartOfAccounts netCoa = (CChartOfAccounts)this.persistenceService.find("from CChartOfAccounts where glcode=?", new Object[]{netGl[0]});
            billdetails.setGlcodeid(BigDecimal.valueOf(netCoa.getId()));
            vd.setGlcodeIdDetail(netCoa.getId());
            if (this.voucherHeader.getIsRestrictedtoOneFunctionCenter().booleanValue() && this.commonBean.getFunctionId() != null) {
                billdetails.setFunctionid(BigDecimal.valueOf(this.commonBean.getFunctionId().intValue()));
            }
            billdetails.setCreditamount(vd.getCreditAmountDetail());
            bill.setBillamount(this.debitSum);
            bill.setPassedamount(this.debitSum);
            billdetails.setEgBillregister(bill);
            if (vd.getIsSubledger().equalsIgnoreCase("true")) {
                payeedetailsSet = new HashSet();
                for (VoucherDetails sub : this.billDetailsTableSubledger) {
                    if (sub == null || !vd.getGlcodeDetail().equalsIgnoreCase(sub.getSubledgerCode())) continue;
                    payeedetails = new EgBillPayeedetails();
                    payeedetails.setCreditAmount(sub.getDebitAmountDetail());
                    payeedetails.setAccountDetailKeyId(Integer.valueOf(sub.getDetailKey()));
                    payeedetails.setAccountDetailTypeId(this.commonBean.getSubledgerType());
                    payeedetails.setEgBilldetailsId(billdetails);
                    payeedetailsSet.add(payeedetails);
                    if (entityKey == null) {
                        entityKey = sub.getDetailKey();
                    }
                    if (entityKey.equals(sub.getDetailKey())) continue;
                    ++entityCount;
                }
                billdetails.setEgBillPaydetailes(payeedetailsSet);
            }
            billdetails.setLastupdatedtime(new Date());
            billdetailsSet.add(billdetails);
        }
        if (entityCount < 2) {
            bill.getEgBillregistermis().setPayto(this.commonBean.getPayto());
        }
        return billdetailsSet;
    }

    private EgBillregister setBillDetailsFromHeaderDetails(EgBillregister bill, EgBillregistermis mis, boolean generateBill) {
        mis.setEgDepartment(this.voucherHeader.getVouchermis().getDepartmentid());
        mis.setFund(this.voucherHeader.getFundId());
        mis.setScheme(this.voucherHeader.getVouchermis().getSchemeid());
        mis.setSubScheme(this.voucherHeader.getVouchermis().getSubschemeid());
        mis.setFieldid(this.voucherHeader.getVouchermis().getDivisionid());
        mis.setFundsource(this.voucherHeader.getVouchermis().getFundsource());
        mis.setFunction(this.voucherHeader.getVouchermis().getFunction());
        bill.setNarration(this.voucherHeader.getDescription());
        EgBillSubType egBillSubType = (EgBillSubType)this.persistenceService.find("from EgBillSubType where id=?", new Object[]{this.commonBean.getBillSubType().longValue()});
        mis.setEgBillSubType(egBillSubType);
        mis.setInwardSerialNumber(this.commonBean.getInwardSerialNumber());
        mis.setPartyBillNumber(this.commonBean.getPartyBillNumber());
        mis.setPartyBillDate(this.commonBean.getPartyBillDate());
        bill.setBilldate(this.commonBean.getBillDate());
        bill.setExpendituretype("Expense");
        mis.setEgBillregister(bill);
        mis.setLastupdatedtime(new Date());
        bill.setEgBillregistermis(mis);
        if (generateBill) {
            if (this.isBillNumberGenerationAuto()) {
                this.commonBean.setBillNumber(this.getNextBillNumber(bill));
            }
            bill.setBillnumber(this.commonBean.getBillNumber());
        }
        bill.setBillstatus("CREATED");
        String statusQury = "from EgwStatus where upper(moduletype)=upper('EXPENSEBILL') and  upper(description)=upper('CREATED')";
        EgwStatus egwStatus = (EgwStatus)this.persistenceService.find("from EgwStatus where upper(moduletype)=upper('EXPENSEBILL') and  upper(description)=upper('CREATED')");
        bill.setStatus(egwStatus);
        bill.setBilltype("Final Bill");
        return bill;
    }

    private String getNextBillNumber(EgBillregister bill) {
        ExpenseBillNumberGenerator b = (ExpenseBillNumberGenerator)this.beanResolver.getAutoNumberServiceFor(ExpenseBillNumberGenerator.class);
        String billNumber = b.getNextNumber(bill);
        return billNumber;
    }

    public String getDetailTypesForCoaId(Long id) {
        StringBuffer detailTypeIdandName1 = new StringBuffer(500);
        List coaDetails = this.persistenceService.findAllBy("from CChartOfAccountDetail where glCodeId.id=?", new Object[]{id});
        for (CChartOfAccountDetail coad : coaDetails) {
            detailTypeIdandName1.append(coad.getDetailTypeId().getId()).append("`-`");
        }
        return detailTypeIdandName1.toString();
    }

    public String getSanctionedMessge() {
        return this.sanctionedMessge;
    }

    public void setSanctionedMessge(String sanctionedMessge) {
        this.sanctionedMessge = sanctionedMessge;
    }

    public String getComments() {
        if (BigDecimal.ZERO.compareTo(this.billAmount) != 0) {
            return this.getText("bill.comments", new String[]{this.billAmount.setScale(2, 6).toPlainString()});
        }
        return "";
    }

    public boolean isShowPrintPreview() {
        return this.showPrintPreview;
    }

    public void setShowPrintPreview(boolean showPrintPreview) {
        this.showPrintPreview = showPrintPreview;
    }

    public boolean isBillNumUnique(String billNumber) {
        String billNum = (String)this.persistenceService.find("select billnumber from EgBillregister where upper(billnumber)='" + billNumber.toUpperCase() + "'");
        return null == billNum;
    }

    public Integer getPrimaryDepartment() {
        return this.primaryDepartment.getId().intValue();
    }

    public WorkflowBean getWorkflowBean() {
        return this.workflowBean;
    }

    public void setWorkflowBean(WorkflowBean workflowBean) {
        this.workflowBean = workflowBean;
    }

    public String getCurrentState() {
        return this.bill.getState().getValue();
    }

    public String getCutOffDate() {
        return this.cutOffDate;
    }

    public void setCutOffDate(String cutOffDate) {
        this.cutOffDate = cutOffDate;
    }
}

