/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.controller.es.dashboard;

import java.io.IOException;
import java.util.List;
import org.egov.commons.CFinancialYear;
import org.egov.commons.service.CFinancialYearService;
import org.egov.egf.bean.dashboard.FinancialsDetailResponse;
import org.egov.egf.bean.dashboard.FinancialsDetailsRequest;
import org.egov.egf.es.utils.FinancialsDashBoardUtils;
import org.egov.infra.utils.DateUtils;
import org.egov.services.es.dashboard.FinancialsDashboardService;
import org.egov.utils.FinancialConstants;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/public/findashboard", "/findashboard"})
public class FinancialsDashboardController {
    private static final Logger LOGGER = LoggerFactory.getLogger(FinancialsDashboardController.class);
    @Autowired
    private FinancialsDashboardService financialsDashboardService;
    @Autowired
    private CFinancialYearService cFinancialYearService;

    @RequestMapping(value={"/dashboard"}, method={RequestMethod.GET}, produces={"application/json"})
    public List<FinancialsDetailResponse> getFinancialDetails(FinancialsDetailsRequest financialsDetailsRequest) throws IOException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("financialsDetailsRequest input : regionName = " + financialsDetailsRequest.getRegion() + ", districtName = " + financialsDetailsRequest.getDistrict() + ", ulbGrade = " + financialsDetailsRequest.getGrade() + ", ulbCode = " + financialsDetailsRequest.getUlbCode() + ", fromDate = " + financialsDetailsRequest.getFromDate() + ", toDate = " + financialsDetailsRequest.getToDate() + ", aggregationlevel = " + financialsDetailsRequest.getAggregationLevel());
        }
        this.setAsOnDate(financialsDetailsRequest);
        BoolQueryBuilder boolQuery = FinancialsDashBoardUtils.prepareWhereClause((FinancialsDetailsRequest)financialsDetailsRequest);
        String aggrField = FinancialsDashBoardUtils.getAggregationGroupingField((FinancialsDetailsRequest)financialsDetailsRequest);
        return this.financialsDashboardService.getFinancialsData(financialsDetailsRequest, boolQuery, aggrField);
    }

    private void setAsOnDate(FinancialsDetailsRequest financialsDetailsRequest) {
        if (financialsDetailsRequest.getToDate() != null) {
            CFinancialYear financialYear = this.cFinancialYearService.getFinancialYearByDate(DateUtils.toDateUsingDefaultPattern((String)financialsDetailsRequest.getToDate()));
            financialsDetailsRequest.setFromDate(FinancialConstants.DATEFORMATTER_YYYY_MM_DD.format(financialYear.getStartingDate()));
            financialsDetailsRequest.setCurrentFinancialYear(financialYear.getFinYearRange());
            financialsDetailsRequest.setLastFinancialYear(this.cFinancialYearService.getPreviousFinancialYearForDate(DateUtils.toDateUsingDefaultPattern((String)financialsDetailsRequest.getToDate())).getFinYearRange());
        } else {
            CFinancialYear financialYear = this.cFinancialYearService.getFinancialYearByDate(DateUtils.now());
            financialsDetailsRequest.setToDate(FinancialConstants.DATEFORMATTER_YYYY_MM_DD.format(DateUtils.now()));
            financialsDetailsRequest.setFromDate(FinancialConstants.DATEFORMATTER_YYYY_MM_DD.format(financialYear.getStartingDate()));
            financialsDetailsRequest.setCurrentFinancialYear(financialYear.getFinYearRange());
            financialsDetailsRequest.setLastFinancialYear(this.cFinancialYearService.getPreviousFinancialYearForDate(DateUtils.now()).getFinYearRange());
        }
    }
}

