/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.payment;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.web.struts.actions.SearchFormAction;
import org.egov.infstr.search.SearchQuery;
import org.egov.infstr.search.SearchQueryHQL;
import org.egov.infstr.services.PersistenceService;
import org.egov.services.voucher.VoucherService;
import org.egov.utils.VoucherHelper;
import org.hibernate.FlushMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@Results(value={@Result(name={"search"}, location="searchAdvanceRequisitionForPayment-search.jsp")})
public class SearchAdvanceRequisitionForPaymentAction
extends SearchFormAction {
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(SearchAdvanceRequisitionForPaymentAction.class);
    public static final String ARF_STATUS_APPROVED = "APPROVED";
    public static final String ARF_TYPE = "Contractor";
    private Date fromDate;
    private Date toDate;
    private Integer departmentId = -1;
    private String arfNumber;
    private VoucherHelper voucherHelper;
    private VoucherService voucherService;

    public Object getModel() {
        return null;
    }

    public void prepare() {
        super.prepare();
        this.addDropdownData("departmentList", this.voucherHelper.getAllAssgnDeptforUser());
        if (this.departmentId == null || this.departmentId == -1) {
            this.departmentId = this.voucherService.getCurrentDepartment().getId().intValue();
        }
    }

    @Action(value="/payment/searchAdvanceRequisitionForPayment-beforeSearch")
    public String beforeSearch() {
        return "search";
    }

    private Map getQuery() {
        StringBuffer query = new StringBuffer(700);
        ArrayList<Object> paramList = new ArrayList<Object>();
        HashMap<String, Object> queryAndParams = new HashMap<String, Object>();
        query.append("from EgAdvanceRequisition arf where arf.arftype = ? and arf.status.code = ? and  NOT EXISTS (select 1 from CVoucherHeader vh where vh.id=arf.egAdvanceReqMises.voucherheader.id and arf.egAdvanceReqMises.voucherheader.status<>4) ");
        paramList.add(ARF_TYPE);
        paramList.add(ARF_STATUS_APPROVED);
        if (StringUtils.isNotBlank((String)this.arfNumber)) {
            query.append(" and UPPER(arf.advanceRequisitionNumber) like '%'||?||'%'");
            paramList.add(StringUtils.trim((String)this.arfNumber).toUpperCase());
        }
        if (this.fromDate != null && this.toDate != null && this.getFieldErrors().isEmpty()) {
            query.append(" and arf.advanceRequisitionDate between ? and ? ");
            paramList.add(this.fromDate);
            paramList.add(this.toDate);
        }
        if (this.departmentId != 0 && this.departmentId != -1) {
            query.append(" and arf.egAdvanceReqMises.egDepartment.id = ? ");
            paramList.add(this.departmentId);
        }
        query.append(" order by arf.advanceRequisitionDate");
        queryAndParams.put("query", query.toString());
        queryAndParams.put("params", paramList);
        return queryAndParams;
    }

    public SearchQuery prepareQuery(String sortField, String sortOrder) {
        String query = null;
        String countQuery = null;
        Map queryAndParms = null;
        List paramList = new ArrayList();
        queryAndParms = this.getQuery();
        paramList = (List)queryAndParms.get("params");
        query = (String)queryAndParms.get("query");
        countQuery = "select count(distinct arf.id) " + query;
        query = "select distinct arf " + query;
        return new SearchQueryHQL(query, countQuery, paramList);
    }

    @Action(value="/payment/searchAdvanceRequisitionForPayment-search")
    public String search() {
        return "search";
    }

    public String searchList() {
        this.persistenceService.getSession().setDefaultReadOnly(true);
        this.persistenceService.getSession().setFlushMode(FlushMode.MANUAL);
        boolean isError = false;
        if (this.fromDate != null && this.toDate == null) {
            this.addFieldError("toDate", this.getText("search.toDate.null"));
            isError = true;
        }
        if (this.toDate != null && this.fromDate == null) {
            this.addFieldError("fromDate", this.getText("search.fromDate.null"));
            isError = true;
        }
        if (!DateUtils.compareDates((Date)this.toDate, (Date)this.fromDate)) {
            this.addFieldError("toDate", this.getText("fromDate.greaterthan.toDate"));
            isError = true;
        }
        if (!DateUtils.compareDates((Date)new Date(), (Date)this.toDate)) {
            this.addFieldError("toDate", this.getText("toDate.greaterthan.currentdate"));
            isError = true;
        }
        if (isError) {
            return "search";
        }
        this.setPageSize(30);
        super.search();
        return "search";
    }

    public String getArfNumber() {
        return this.arfNumber;
    }

    public void setArfNumber(String arfNumber) {
        this.arfNumber = arfNumber;
    }

    public Date getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(Date fromDate) {
        this.fromDate = fromDate;
    }

    public Date getToDate() {
        return this.toDate;
    }

    public void setToDate(Date toDate) {
        this.toDate = toDate;
    }

    public Integer getDepartmentId() {
        return this.departmentId;
    }

    public void setDepartmentId(Integer departmentId) {
        this.departmentId = departmentId;
    }

    public void setVoucherHelper(VoucherHelper voucherHelper) {
        this.voucherHelper = voucherHelper;
    }

    public void setVoucherService(VoucherService voucherService) {
        this.voucherService = voucherService;
    }
}

