/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.masters;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.egov.commons.Bankaccount;
import org.egov.commons.FinancingInstitution;
import org.egov.commons.Fundsource;
import org.egov.commons.SharedFundSource;
import org.egov.commons.SubScheme;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.infstr.services.PersistenceService;
import org.egov.services.financingsource.FinancingSourceService;

@ParentPackage(value="egov")
@Results(value={@Result(name={"result"}, location="financingSource-result.jsp"), @Result(name={"new"}, location="financingSource-new.jsp"), @Result(name={"nameUniqueCheck"}, location="financingSource-nameUniqueCheck.jsp"), @Result(name={"codeUniqueCheck"}, location="financingSource-codeUniqueCheck.jsp")})
public class FinancingSourceAction
extends BaseFormAction {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(FinancingSourceAction.class);
    private Fundsource fundsource = new Fundsource();
    private List<String> fundingTypeList;
    private List<FinancingInstitution> finInstList;
    private List<String> rePymntFrqList;
    private List<Fundsource> fundSourceList = new ArrayList();
    private FinancingSourceService financingSourceService;
    private BigDecimal initialEstimateAmount;
    private List<Fundsource> finSrcTypOwnSrcList;
    private PersistenceService<SharedFundSource, Long> shrdFSrcPerSer;

    public FinancingSourceAction() {
        this.addRelatedEntity("bankAccountId", Bankaccount.class);
        this.addRelatedEntity("subSchemeId", SubScheme.class);
        this.addRelatedEntity("finInstId", FinancingInstitution.class);
    }

    public Object getModel() {
        return this.fundsource;
    }

    public void prepare() {
        super.prepare();
        this.addDropdownData("subschemeList", this.persistenceService.findAllBy("from SubScheme where isactive=true order by name", new Object[0]));
        StringTokenizer sTokenizer = new StringTokenizer(this.getText("masters.finsrc.fundingtypes"), "|");
        this.fundingTypeList = new ArrayList();
        while (sTokenizer.hasMoreElements()) {
            this.fundingTypeList.add((String)sTokenizer.nextElement());
        }
        this.finInstList = this.persistenceService.findAllBy("from FinancingInstitution order by name", new Object[0]);
        StringTokenizer frqTokenizer = new StringTokenizer(this.getText("masters.finsrc.repymtfrq"), "|");
        this.rePymntFrqList = new ArrayList();
        while (frqTokenizer.hasMoreElements()) {
            this.rePymntFrqList.add((String)frqTokenizer.nextElement());
        }
        this.addDropdownData("fundingTypeList", this.fundingTypeList);
        this.addDropdownData("finInstList", this.finInstList);
        this.addDropdownData("rePymntFrqList", this.rePymntFrqList);
        this.addDropdownData("accNumList", Collections.EMPTY_LIST);
        this.finSrcTypOwnSrcList = this.financingSourceService.getListOfSharedFinancialSource();
        this.addDropdownData("finSrcTypOwnSrcList", this.finSrcTypOwnSrcList);
    }

    @Action(value="/masters/financingSource-newform")
    public String newform() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"FinancingSourceAction | newform | start");
        }
        return "new";
    }

    @Action(value="/masters/financingSource-getIntEstAmt")
    public String getIntEstAmt() {
        SubScheme subscheme = (SubScheme)this.persistenceService.find("from SubScheme  where id = " + Integer.valueOf(((String[])this.parameters.get("subSchemeId"))[0]));
        this.initialEstimateAmount = subscheme.getInitialEstimateAmount();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)(" initial estimate amount received = " + this.initialEstimateAmount));
        }
        if (null == subscheme.getInitialEstimateAmount()) {
            this.initialEstimateAmount = BigDecimal.ZERO;
        }
        return "result";
    }

    public String getOwnSrcAmount() {
        Fundsource fundsource = (Fundsource)this.persistenceService.find("from Fundsource where id=" + Integer.valueOf(((String[])this.parameters.get("finSrcOwnSrcId"))[0]));
        this.initialEstimateAmount = fundsource.getSourceAmount();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)(" initial estimate amount received = " + this.initialEstimateAmount));
        }
        if (null == this.initialEstimateAmount) {
            this.initialEstimateAmount = BigDecimal.ZERO;
        }
        return "result";
    }

    @Action(value="/masters/financingSource-codeUniqueCheck")
    public String codeUniqueCheck() {
        return "codeUniqueCheck";
    }

    public boolean getCodeCheck() {
        boolean codeExistsOrNot = false;
        Fundsource fundsourceObj = (Fundsource)this.persistenceService.find("from Fundsource where code='" + this.fundsource.getCode() + "'");
        if (null != fundsourceObj) {
            codeExistsOrNot = true;
        }
        return codeExistsOrNot;
    }

    @Action(value="/masters/financingSource-nameUniqueCheck")
    public String nameUniqueCheck() {
        return "nameUniqueCheck";
    }

    public boolean getNameCheck() {
        boolean nameExistsOrNot = false;
        Fundsource fundsourceObj = (Fundsource)this.persistenceService.find("from Fundsource where name='" + this.fundsource.getName() + "'");
        if (null != fundsourceObj) {
            nameExistsOrNot = true;
        }
        return nameExistsOrNot;
    }

    @ValidationErrorPage(value="new")
    @Action(value="/masters/financingSource-save")
    public String save() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"FinancingSourceAction | save | start");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("financial source list size " + this.fundSourceList.size()));
        }
        User user = (User)this.persistenceService.find("from User where id=" + ApplicationThreadLocals.getUserId());
        try {
            for (Fundsource fundsource : this.fundSourceList) {
                if (fundsource.getType().equalsIgnoreCase("Shared Source")) {
                    SharedFundSource sharedFundSource = new SharedFundSource();
                    sharedFundSource.setSubSchemeId(fundsource.getSubSchemeId());
                    sharedFundSource.setFundSourceId((Fundsource)this.financingSourceService.findById((Serializable)Integer.valueOf(fundsource.getId().intValue()), false));
                    sharedFundSource.setAmount(fundsource.getSourceAmount());
                    this.shrdFSrcPerSer.persist((Object)sharedFundSource);
                    continue;
                }
                fundsource = this.checkRelatedEntities(fundsource);
                fundsource.setCreatedDate(new Date());
                fundsource.setCreatedBy(user);
                this.financingSourceService.persist((Object)fundsource);
            }
            this.addActionMessage(this.getText("masters.finsrc.saved.sucess"));
        }
        catch (Exception e) {
            LOGGER.error((Object)("error occured while creating financial source" + e.getMessage()), (Throwable)e);
            this.clearMessages();
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.add(new ValidationError("exp", e.getMessage(), new String[]{e.getMessage()}));
            throw new ValidationException(errors);
        }
        return "new";
    }

    private Fundsource checkRelatedEntities(Fundsource fundsource) {
        if (null == fundsource.getSubSchemeId().getId()) {
            fundsource.setSubSchemeId(null);
        }
        if (null == fundsource.getFinInstId().getId()) {
            fundsource.setFinInstId(null);
        }
        if (null == fundsource.getBankAccountId().getId()) {
            fundsource.setBankAccountId(null);
        }
        return fundsource;
    }

    public Fundsource getFundsource() {
        return this.fundsource;
    }

    public void setFundsource(Fundsource fundsource) {
        this.fundsource = fundsource;
    }

    public List<String> getFundingTypeList() {
        return this.fundingTypeList;
    }

    public void setFundingTypeList(List<String> fundingTypeList) {
        this.fundingTypeList = fundingTypeList;
    }

    public List<FinancingInstitution> getFinInstList() {
        return this.finInstList;
    }

    public void setFinInstList(List<FinancingInstitution> finInstList) {
        this.finInstList = finInstList;
    }

    public List<String> getRePymntFrqList() {
        return this.rePymntFrqList;
    }

    public void setRePymntFrqList(List<String> rePymntFrqList) {
        this.rePymntFrqList = rePymntFrqList;
    }

    public List<Fundsource> getFundSourceList() {
        return this.fundSourceList;
    }

    public void setFundSourceList(List<Fundsource> fundSourceList) {
        this.fundSourceList = fundSourceList;
    }

    public FinancingSourceService getFinancingSourceService() {
        return this.financingSourceService;
    }

    public void setFinancingSourceService(FinancingSourceService financingSourceService) {
        this.financingSourceService = financingSourceService;
    }

    public BigDecimal getInitialEstimateAmount() {
        return this.initialEstimateAmount;
    }

    public void setInitialEstimateAmount(BigDecimal initialEstimateAmount) {
        this.initialEstimateAmount = initialEstimateAmount;
    }

    public List<Fundsource> getFinSrcTypOwnSrcList() {
        return this.finSrcTypOwnSrcList;
    }

    public void setFinSrcTypOwnSrcList(List<Fundsource> finSrcTypOwnSrcList) {
        this.finSrcTypOwnSrcList = finSrcTypOwnSrcList;
    }

    public void setShrdFSrcPerSer(PersistenceService<SharedFundSource, Long> shrdFSrcPerSer) {
        this.shrdFSrcPerSer = shrdFSrcPerSer;
    }
}

