/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.brs;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.egov.commons.Bankaccount;
import org.egov.commons.Bankbranch;
import org.egov.commons.Bankreconciliation;
import org.egov.commons.dao.BankHibernateDAO;
import org.egov.egf.model.ReconcileBean;
import org.egov.egf.web.actions.brs.ManualReconcileHelper;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.jboss.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;

@ParentPackage(value="egov")
@Results(value={@Result(name={"new"}, location="manualReconciliation-new.jsp"), @Result(name={"search"}, location="manualReconciliation-search.jsp"), @Result(name={"report"}, location="manualReconciliation-report.jsp"), @Result(name={"update"}, location="manualReconciliation-update.jsp"), @Result(name={"balance"}, location="manualReconciliation-balance.jsp"), @Result(name={"PDF"}, type="stream", location="inputStream", params={"inputName", "inputStream", "contentType", "application/pdf", "contentDisposition", "no-cache;filename=AutoReconcileReport.pdf"}), @Result(name={"XLS"}, type="stream", location="inputStream", params={"inputName", "inputStream", "contentType", "application/xls", "contentDisposition", "no-cache;filename=AutoReconcileReport.xls"})})
public class ManualReconciliationAction
extends BaseFormAction {
    private static final long serialVersionUID = -4207341983597707193L;
    private static final Logger LOGGER = Logger.getLogger(ManualReconciliationAction.class);
    private List<Bankbranch> branchList = Collections.EMPTY_LIST;
    private final List<Bankaccount> accountList = Collections.EMPTY_LIST;
    @Autowired
    private ManualReconcileHelper manualReconcileHelper;
    private ReconcileBean reconcileBean;
    private Map<String, String> unReconciledDrCr;
    private List<ReconcileBean> unReconciledCheques;
    List<Long> instrumentHeaders;
    List<Date> reconDates;
    @Autowired
    private BankHibernateDAO bankHibernateDAO;

    public Object getModel() {
        return new Bankreconciliation();
    }

    public void prepareNewForm() {
        this.reconcileBean = new ReconcileBean();
        this.reconcileBean.setLimit(Integer.valueOf(500));
        List allBankHavingAccounts = this.bankHibernateDAO.getAllBankHavingBranchAndAccounts();
        this.dropdownData.put("bankList", allBankHavingAccounts);
        this.dropdownData.put("branchList", this.branchList);
        this.dropdownData.put("accountList", this.accountList);
        if (this.reconcileBean.getBranchId() != null) {
            this.branchList = this.persistenceService.findAllBy("select  bb from Bankbranch bb,Bankaccount ba where bb.bank.id=? and ba.bankbranch=bb and bb.isactive=true", new Object[]{this.reconcileBean.getBankId()});
            this.dropdownData.put("branchList", this.branchList);
        }
        if (this.reconcileBean.getAccountId() != null) {
            List accountList = this.getPersistenceService().findAllBy("from Bankaccount ba where ba.bankbranch.id=? and isactive=true order by ba.chartofaccounts.glcode", new Object[]{this.reconcileBean.getBranchId()});
            this.dropdownData.put("accountList", accountList);
        }
    }

    @Action(value="/brs/manualReconciliation-newForm")
    public String newForm() {
        return "new";
    }

    @Action(value="/brs/manualReconciliation-ajaxSearch")
    public String search() {
        this.unReconciledCheques = this.manualReconcileHelper.getUnReconciledCheques(this.reconcileBean);
        return "search";
    }

    @Action(value="/brs/manualReconciliation-ajaxBalance")
    public String balance() {
        this.unReconciledDrCr = this.manualReconcileHelper.getUnReconciledDrCr(this.reconcileBean.getAccountId(), this.reconcileBean.getFromDate(), this.reconcileBean.getToDate());
        return "balance";
    }

    @Action(value="/brs/manualReconciliation-update")
    @ValidationErrorPage(value="search")
    public String update() {
        this.manualReconcileHelper.update(this.reconDates, this.instrumentHeaders);
        return "update";
    }

    @Action(value="/brs/manualReconciliation-generateReport")
    public String generateReport() {
        return "report";
    }

    public List<Bankbranch> getBranchList() {
        return this.branchList;
    }

    public void setBranchList(List<Bankbranch> branchList) {
        this.branchList = branchList;
    }

    public ReconcileBean getReconcileBean() {
        return this.reconcileBean;
    }

    public void setReconcileBean(ReconcileBean reconcileBean) {
        this.reconcileBean = reconcileBean;
    }

    public List<Bankaccount> getAccountList() {
        return this.accountList;
    }

    public List<ReconcileBean> getUnReconciledCheques() {
        return this.unReconciledCheques;
    }

    public void setUnReconciledCheques(List<ReconcileBean> unReconciledCheques) {
        this.unReconciledCheques = unReconciledCheques;
    }

    public List<Long> getInstrumentHeaders() {
        return this.instrumentHeaders;
    }

    public void setInstrumentHeaders(List<Long> instrumentHeaders) {
        this.instrumentHeaders = instrumentHeaders;
    }

    public List<Date> getReconDates() {
        return this.reconDates;
    }

    public void setReconDates(List<Date> reconDates) {
        this.reconDates = reconDates;
    }

    public Map<String, String> getUnReconciledDrCr() {
        return this.unReconciledDrCr;
    }

    public void setUnReconciledDrCr(Map<String, String> unReconciledDrCr) {
        this.unReconciledDrCr = unReconciledDrCr;
    }
}

