/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.bill;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.JRException;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.commons.Accountdetailtype;
import org.egov.commons.CChartOfAccounts;
import org.egov.commons.CFinancialYear;
import org.egov.commons.CFunction;
import org.egov.commons.CVoucherHeader;
import org.egov.commons.dao.FinancialYearDAO;
import org.egov.commons.utils.EntityType;
import org.egov.dao.budget.BudgetDetailsHibernateDAO;
import org.egov.egf.budget.model.BudgetControlType;
import org.egov.egf.budget.service.BudgetControlTypeService;
import org.egov.egf.commons.EgovCommon;
import org.egov.egf.web.actions.bill.BillReport;
import org.egov.eis.service.EisCommonService;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.exception.ApplicationException;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.reporting.util.ReportUtil;
import org.egov.infra.utils.NumberToWord;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infra.workflow.entity.StateHistory;
import org.egov.infstr.services.PersistenceService;
import org.egov.model.bills.EgBillPayeedetails;
import org.egov.model.bills.EgBilldetails;
import org.egov.model.bills.EgBillregister;
import org.egov.model.bills.EgBillregistermis;
import org.egov.model.voucher.VoucherDetails;
import org.egov.utils.Constants;
import org.egov.utils.ReportHelper;
import org.hibernate.SQLQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@Results(value={@Result(name={"PDF"}, type="stream", location="inputStream", params={"inputName", "inputStream", "contentType", "application/pdf", "contentDisposition", "no-cache;filename=ExpenseJournalVoucherReport.pdf"}), @Result(name={"XLS"}, type="stream", location="inputStream", params={"inputName", "inputStream", "contentType", "application/xls", "contentDisposition", "no-cache;filename=ExpenseJournalVoucherReport.xls"}), @Result(name={"HTML"}, type="stream", location="inputStream", params={"inputName", "inputStream", "contentType", "text/html"})})
@ParentPackage(value="egov")
public class ExpenseBillPrintAction
extends BaseFormAction {
    private static final Logger LOGGER = Logger.getLogger(ExpenseBillPrintAction.class);
    String jasperpath = "/reports/templates/expenseBillReport.jasper";
    String subReportPath = "/reports/templates/budgetAppropriationDetail.jasper";
    private static final long serialVersionUID = 1L;
    private static final String PRINT = "print";
    String functionName;
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    @Autowired
    AppConfigValueService appConfigValuesService;
    @Autowired
    private EisCommonService eisCommonService;
    private BudgetDetailsHibernateDAO budgetDetailsDAO;
    @Autowired
    private FinancialYearDAO financialYearDAO;
    private final SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
    Map<String, Object> budgetDataMap = new HashMap();
    Map<String, Object> paramMap = new HashMap();
    @Autowired
    private EgovCommon egovCommon;
    private CVoucherHeader voucher = new CVoucherHeader();
    List<Object> billReportList = new ArrayList();
    InputStream inputStream;
    ReportHelper reportHelper;
    Long id;
    EgBillregistermis billRegistermis;
    List<EgBillPayeedetails> billPayeeDetails = new ArrayList();
    private static final String ACCDETAILTYPEQUERY = " from Accountdetailtype where id=?";
    EgBillregister cbill = new EgBillregister();
    @Autowired
    private BudgetControlTypeService budgetControlTypeService;

    public BudgetDetailsHibernateDAO getBudgetDetailsDAO() {
        return this.budgetDetailsDAO;
    }

    public void setBudgetDetailsDAO(BudgetDetailsHibernateDAO budgetDetailsDAO) {
        this.budgetDetailsDAO = budgetDetailsDAO;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public List<Object> getBillReportList() {
        return this.billReportList;
    }

    public void setBillReportList(List<Object> billReportList) {
        this.billReportList = billReportList;
    }

    public Long getId() {
        return this.id;
    }

    public void setReportHelper(ReportHelper helper) {
        this.reportHelper = helper;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public String execute() {
        return this.print();
    }

    @SkipValidation
    @Action(value="/bill/expenseBillPrint-ajaxPrint")
    public String ajaxPrint() {
        return this.exportHtml();
    }

    public Object getModel() {
        return this.voucher;
    }

    @Action(value="/bill/expenseBillPrint-print")
    public String print() {
        return PRINT;
    }

    private void populateBill() {
        if (this.parameters.get("id") != null && !((String[])this.parameters.get("id"))[0].isEmpty()) {
            this.cbill = (EgBillregister)this.persistenceService.find("from EgBillregister where id=?", new Object[]{Long.valueOf(((String[])this.parameters.get("id"))[0])});
            this.billRegistermis = this.cbill.getEgBillregistermis();
        }
        this.generateVoucherReportList();
    }

    private void generateVoucherReportList() {
        this.prepareForPrint();
    }

    private String getUlbName() {
        SQLQuery query = this.persistenceService.getSession().createSQLQuery("select name from companydetail");
        List result = query.list();
        if (result != null) {
            return (String)result.get(0);
        }
        return "";
    }

    @Action(value="/bill/expenseBillPrint-exportPdf")
    public String exportPdf() throws JRException, IOException {
        this.populateBill();
        this.inputStream = this.reportHelper.exportPdf(this.inputStream, this.jasperpath, this.getParamMap(), this.billReportList);
        return "PDF";
    }

    public String exportHtml() {
        this.populateBill();
        this.inputStream = this.reportHelper.exportHtml(this.inputStream, this.jasperpath, this.getParamMap(), this.billReportList, "px");
        return "HTML";
    }

    @Action(value="/bill/expenseBillPrint-exportXls")
    public String exportXls() throws JRException, IOException {
        this.populateBill();
        this.inputStream = this.reportHelper.exportXls(this.inputStream, this.jasperpath, this.getParamMap(), this.billReportList);
        return "XLS";
    }

    protected Map<String, Object> getParamMap() {
        this.paramMap.put("billNumber", this.cbill.getBillnumber());
        if (this.cbill.getBilldate() != null) {
            this.paramMap.put("billDate", this.sdf.format(this.cbill.getBilldate()));
        }
        this.paramMap.put("voucherDescription", this.getVoucherDescription());
        if (this.cbill != null && this.cbill.getState() != null) {
            this.loadInboxHistoryData(this.cbill.getStateHistory(), this.paramMap);
        }
        if (this.billRegistermis != null) {
            this.paramMap.put("billDate", Constants.DDMMYYYYFORMAT2.format(this.billRegistermis.getEgBillregister().getBilldate()));
            this.paramMap.put("partyBillNumber", this.billRegistermis.getPartyBillNumber());
            this.paramMap.put("serviceOrder", this.billRegistermis.getEgBillregister().getNarration());
            this.paramMap.put("partyName", this.billRegistermis.getPayto());
            if (this.billRegistermis.getPartyBillDate() != null) {
                this.paramMap.put("partyBillDate", this.sdf.format(this.billRegistermis.getPartyBillDate()));
            }
            this.paramMap.put("netAmount", this.cbill.getPassedamount());
            BigDecimal amt = this.cbill.getPassedamount().setScale(2, 6);
            String amountInWords = NumberToWord.convertToWord((String)amt.toString());
            amountInWords = "(" + amountInWords + " )";
            amountInWords = "Bill is in order. Sanction is accorded for Rs." + amt + "/-" + amountInWords;
            this.paramMap.put("netAmountText", amountInWords);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("amountInWords" + amountInWords));
            }
            this.paramMap.put("netAmountInWords", amountInWords);
            this.paramMap.put("billNumber", this.billRegistermis.getEgBillregister().getBillnumber());
            this.paramMap.put("functionName", this.getFunctionName());
            this.paramMap.put("departmentName", this.billRegistermis.getEgDepartment().getName());
            this.paramMap.put("fundName", this.billRegistermis.getFund().getName());
            this.billRegistermis.getEgBillregister().getBillamount();
            this.paramMap.put("budgetApprNumber", this.billRegistermis.getBudgetaryAppnumber());
            this.paramMap.put("budgetAppropriationDetailJasper", this.reportHelper.getClass().getResourceAsStream(this.subReportPath));
        }
        this.paramMap.put("ulbName", ReportUtil.getCityName());
        return this.paramMap;
    }

    private Map<String, Object> getBudgetDetails(CChartOfAccounts coa, EgBilldetails billDetail, String functionName) {
        HashMap<String, Object> budgetApprDetailsMap = new HashMap<String, Object>();
        this.budgetDataMap.put("functionid", Long.valueOf(billDetail.getFunctionid().toString()));
        if (this.cbill.getEgBillregistermis().getVoucherHeader() != null) {
            this.budgetDataMap.put("asondate", this.cbill.getEgBillregistermis().getVoucherHeader().getVoucherDate());
        } else {
            this.budgetDataMap.put("asondate", this.cbill.getBilldate());
        }
        Date billDate = this.cbill.getBilldate();
        CFinancialYear financialYearById = this.financialYearDAO.getFinYearByDate(billDate);
        budgetApprDetailsMap.put("financialYear", "BE-" + financialYearById.getFinYearRange() + " & Addl Funds(Rs)");
        this.budgetDataMap.put("fromdate", financialYearById.getStartingDate());
        this.budgetDataMap.put("glcode", coa.getGlcode());
        this.budgetDataMap.put("glcodeid", coa.getId());
        List budgetHeadByGlcode = this.budgetDetailsDAO.getBudgetHeadByGlcode(coa);
        this.budgetDataMap.put("budgetheadid", budgetHeadByGlcode);
        BigDecimal budgetedAmtForYear = this.budgetDetailsDAO.getBudgetedAmtForYear(this.budgetDataMap);
        this.paramMap.put("budgetedAmtForYear", budgetedAmtForYear);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("budgetedAmtForYear .......... " + budgetedAmtForYear));
        }
        this.budgetDataMap.put("budgetApprNumber", this.cbill.getEgBillregistermis().getBudgetaryAppnumber());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Getting actuals .............................. for print");
        }
        BigDecimal actualAmtFromVoucher = this.budgetDetailsDAO.getActualBudgetUtilizedForBudgetaryCheck(this.budgetDataMap);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("actualAmtFromVoucher .............................. " + actualAmtFromVoucher));
        }
        this.budgetDataMap.put("asondate", this.cbill.getBilldate());
        BigDecimal actualAmtFromBill = this.budgetDetailsDAO.getBillAmountForBudgetCheck(this.budgetDataMap);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("actualAmtFromBill .............................. " + actualAmtFromBill));
        }
        BigDecimal currentBillAmount = BigDecimal.ZERO;
        BigDecimal soFarAppropriated = BigDecimal.ZERO;
        BigDecimal actualAmount = BigDecimal.ZERO;
        actualAmount = actualAmtFromVoucher != null ? actualAmtFromVoucher : BigDecimal.ZERO;
        BigDecimal bigDecimal = actualAmount = actualAmtFromBill != null ? actualAmount.add(actualAmtFromBill) : actualAmount;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("actualAmount ...actualAmtFromVoucher+actualAmtFromBill........ " + actualAmount));
        }
        if (billDetail.getDebitamount() != null && billDetail.getDebitamount().compareTo(BigDecimal.ZERO) != 0) {
            actualAmount = actualAmount.subtract(billDetail.getDebitamount());
            currentBillAmount = billDetail.getDebitamount();
        } else {
            actualAmount = actualAmount.subtract(billDetail.getCreditamount());
            currentBillAmount = billDetail.getCreditamount();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("actualAmount ...actualAmount-billamount........ " + actualAmount));
        }
        BigDecimal balance = budgetedAmtForYear;
        balance = balance.subtract(actualAmount);
        soFarAppropriated = actualAmount;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("soFarAppropriated ...actualAmount==soFarAppropriated........ " + soFarAppropriated));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("balance ...budgetedAmtForYear-actualAmount........ " + balance));
        }
        BigDecimal cumilativeIncludingCurrentBill = soFarAppropriated.add(currentBillAmount);
        BigDecimal currentBalanceAvailable = balance.subtract(currentBillAmount);
        budgetApprDetailsMap.put("budgetApprNumber", this.cbill.getEgBillregistermis().getBudgetaryAppnumber());
        budgetApprDetailsMap.put("budgetedAmtForYear", budgetedAmtForYear);
        budgetApprDetailsMap.put("soFarAppropriated", soFarAppropriated);
        budgetApprDetailsMap.put("balance", balance);
        budgetApprDetailsMap.put("cumilativeIncludingCurrentBill", cumilativeIncludingCurrentBill);
        budgetApprDetailsMap.put("currentBalanceAvailable", currentBalanceAvailable);
        budgetApprDetailsMap.put("currentBillAmount", currentBillAmount);
        budgetApprDetailsMap.put("AccountCode", coa.getGlcode());
        budgetApprDetailsMap.put("departmentName", this.cbill.getEgBillregistermis().getEgDepartment().getName());
        budgetApprDetailsMap.put("functionName", functionName);
        budgetApprDetailsMap.put("fundName", this.cbill.getEgBillregistermis().getFund().getName());
        return budgetApprDetailsMap;
    }

    private void getRequiredDataForBudget(EgBillregister cbill) {
        Object financialYearId = null;
        Date billDate = cbill.getBilldate();
        CFinancialYear financialYearById = this.financialYearDAO.getFinYearByDate(billDate);
        this.budgetDataMap.put("financialyearid", financialYearById.getId());
        this.budgetDataMap.put("deptid", cbill.getEgBillregistermis().getEgDepartment().getId());
        if (cbill.getEgBillregistermis().getFunctionaryid() != null) {
            this.budgetDataMap.put("functionaryid", cbill.getEgBillregistermis().getFunctionaryid().getId());
        }
        if (cbill.getEgBillregistermis().getScheme() != null) {
            this.budgetDataMap.put("schemeid", cbill.getEgBillregistermis().getScheme().getId());
        }
        if (cbill.getEgBillregistermis().getSubScheme() != null) {
            this.budgetDataMap.put("subschemeid", cbill.getEgBillregistermis().getSubScheme().getId());
        }
        this.budgetDataMap.put("fundid", cbill.getEgBillregistermis().getFund().getId());
        this.budgetDataMap.put("boundaryid", cbill.getDivision());
    }

    public Map<String, Object> getAccountDetails(Integer detailtypeid, Integer detailkeyid, Map<String, Object> tempMap) throws ApplicationException {
        Accountdetailtype detailtype = (Accountdetailtype)this.getPersistenceService().find(ACCDETAILTYPEQUERY, new Object[]{detailtypeid});
        tempMap.put("detailtype", detailtype.getName());
        tempMap.put("detailtypeid", detailtype.getId());
        tempMap.put("detailkeyid", detailkeyid);
        this.egovCommon.setPersistenceService(this.persistenceService);
        EntityType entityType = this.egovCommon.getEntityType(detailtype, (Serializable)detailkeyid);
        tempMap.put("detailkey", entityType.getName());
        tempMap.put("detailcode", entityType.getCode());
        return tempMap;
    }

    private String getVoucherDescription() {
        return this.voucher == null || this.voucher.getDescription() == null ? "" : this.voucher.getDescription();
    }

    void loadInboxHistoryData(List<StateHistory> stateHistory, Map<String, Object> paramMap) throws ApplicationRuntimeException {
        ArrayList<String> history = new ArrayList<String>();
        ArrayList<String> workFlowDate = new ArrayList<String>();
        if (!stateHistory.isEmpty()) {
            for (StateHistory historyState : stateHistory) {
                if ("NEW".equalsIgnoreCase(historyState.getValue())) continue;
                history.add(historyState.getSenderName());
                workFlowDate.add(Constants.DDMMYYYYFORMAT2.format(historyState.getLastModifiedDate()));
                if (!historyState.getValue().equalsIgnoreCase("Rejected")) continue;
                history.clear();
                workFlowDate.clear();
            }
            history.add(this.cbill.getState().getSenderName());
            workFlowDate.add(Constants.DDMMYYYYFORMAT2.format(this.cbill.getState().getLastModifiedDate()));
        } else {
            history.add(this.cbill.getState().getSenderName());
            workFlowDate.add(Constants.DDMMYYYYFORMAT2.format(this.cbill.getState().getLastModifiedDate()));
        }
        for (int i = 0; i < history.size(); ++i) {
            paramMap.put("workFlow_" + i, history.get(i));
            paramMap.put("workFlowDate_" + i, workFlowDate.get(i));
        }
    }

    private void prepareForPrint() {
        BillReport billReport;
        ArrayList<ValidationError> errors;
        Method method;
        String dataType;
        String detailTypeName;
        Class<?> service;
        Accountdetailtype detailType;
        EntityType entity;
        Set egBillPaydetailes;
        CChartOfAccounts coa;
        BigDecimal glcodeid;
        VoucherDetails vd;
        Map budgetApprDetails;
        CFunction functionById;
        Set egBilldetailes = this.cbill.getEgBilldetailes();
        boolean budgetcheck = false;
        if (!BudgetControlType.BudgetCheckOption.NONE.toString().equalsIgnoreCase(this.budgetControlTypeService.getConfigValue())) {
            budgetcheck = true;
            this.getRequiredDataForBudget(this.cbill);
        }
        ArrayList<Map> budget = new ArrayList<Map>();
        for (EgBilldetails detail : egBilldetailes) {
            if (detail.getDebitamount() == null || detail.getDebitamount().compareTo(BigDecimal.ZERO) == 0) continue;
            functionById = null;
            budgetApprDetails = null;
            vd = new VoucherDetails();
            glcodeid = detail.getGlcodeid();
            if (detail.getFunctionid() != null) {
                functionById = (CFunction)this.persistenceService.find("from CFunction where id=?", new Object[]{Long.valueOf(detail.getFunctionid().toString())});
                this.setFunctionName(functionById.getName());
                this.paramMap.put("functionName", functionById.getName());
            }
            coa = (CChartOfAccounts)this.persistenceService.find("from CChartOfAccounts where id=?", new Object[]{Long.valueOf(glcodeid.toString())});
            if (budgetcheck && coa.getBudgetCheckReq() != null && coa.getBudgetCheckReq().booleanValue()) {
                budgetApprDetails = this.getBudgetDetails(coa, detail, functionById.getName());
                budget.add(budgetApprDetails);
            }
            vd.setGlcodeDetail(coa.getGlcode());
            vd.setGlcodeIdDetail(coa.getId());
            vd.setAccounthead(coa.getName());
            vd.setCreditAmountDetail(BigDecimal.ZERO);
            vd.setDebitAmountDetail(detail.getDebitamount());
            egBillPaydetailes = detail.getEgBillPaydetailes();
            for (EgBillPayeedetails payeedetail : egBillPaydetailes) {
                try {
                    entity = null;
                    detailType = (Accountdetailtype)this.persistenceService.find("from Accountdetailtype where id=? order by name", new Object[]{payeedetail.getAccountDetailTypeId()});
                    vd.setDetailTypeName(detailType.getName());
                    service = Class.forName(detailType.getFullQualifiedName());
                    detailTypeName = service.getSimpleName();
                    dataType = "";
                    method = service.getMethod("getId", new Class[0]);
                    dataType = method.getReturnType().getSimpleName();
                    entity = dataType.equals("Long") ? (EntityType)this.persistenceService.find("from " + detailTypeName + " where id=? order by name", new Object[]{payeedetail.getAccountDetailKeyId().longValue()}) : (EntityType)this.persistenceService.find("from " + detailTypeName + " where id=? order by name", new Object[]{payeedetail.getAccountDetailKeyId()});
                    vd.setDetailKey(entity.getCode());
                    vd.setDetailName(entity.getName());
                }
                catch (Exception e) {
                    errors = new ArrayList<ValidationError>();
                    errors.add(new ValidationError("exp", e.getMessage()));
                    throw new ValidationException(errors);
                }
            }
            billReport = new BillReport(this.persistenceService, vd, this.cbill, budgetApprDetails);
            this.billReportList.add(billReport);
        }
        for (EgBilldetails detail : egBilldetailes) {
            if (detail.getCreditamount() == null || detail.getCreditamount().compareTo(BigDecimal.ZERO) == 0) continue;
            functionById = null;
            budgetApprDetails = null;
            vd = new VoucherDetails();
            glcodeid = detail.getGlcodeid();
            if (detail.getFunctionid() != null) {
                functionById = (CFunction)this.persistenceService.find("from CFunction where id=?", new Object[]{Long.valueOf(detail.getFunctionid().toString())});
                this.setFunctionName(functionById.getName());
                this.paramMap.put("functionName", functionById.getName());
            }
            coa = (CChartOfAccounts)this.persistenceService.find("from CChartOfAccounts where id=?", new Object[]{Long.valueOf(glcodeid.toString())});
            if (budgetcheck && coa.getBudgetCheckReq() != null && coa.getBudgetCheckReq().booleanValue()) {
                budgetApprDetails = this.getBudgetDetails(coa, detail, this.functionName);
                budget.add(budgetApprDetails);
            }
            vd.setGlcodeDetail(coa.getGlcode());
            vd.setGlcodeIdDetail(coa.getId());
            vd.setAccounthead(coa.getName());
            vd.setCreditAmountDetail(detail.getCreditamount());
            vd.setDebitAmountDetail(BigDecimal.ZERO);
            egBillPaydetailes = detail.getEgBillPaydetailes();
            for (EgBillPayeedetails payeedetail : egBillPaydetailes) {
                try {
                    entity = null;
                    detailType = (Accountdetailtype)this.persistenceService.find("from Accountdetailtype where id=? order by name", new Object[]{payeedetail.getAccountDetailTypeId()});
                    vd.setDetailTypeName(detailType.getName());
                    service = Class.forName(detailType.getFullQualifiedName());
                    detailTypeName = service.getSimpleName();
                    dataType = "";
                    method = service.getMethod("getId", new Class[0]);
                    dataType = method.getReturnType().getSimpleName();
                    entity = dataType.equals("Long") ? (EntityType)this.persistenceService.find("from " + detailTypeName + " where id=? order by name", new Object[]{payeedetail.getAccountDetailKeyId().longValue()}) : (EntityType)this.persistenceService.find("from " + detailTypeName + " where id=? order by name", new Object[]{payeedetail.getAccountDetailKeyId()});
                    vd.setDetailKey(entity.getCode());
                    vd.setDetailName(entity.getName());
                }
                catch (Exception e) {
                    errors = new ArrayList();
                    errors.add(new ValidationError("exp", e.getMessage()));
                    throw new ValidationException(errors);
                }
            }
            billReport = new BillReport(this.persistenceService, vd, this.cbill, budgetApprDetails);
            this.billReportList.add(billReport);
        }
        this.paramMap.put("budgetDetail", budget);
    }

    private void setFunctionName(String name) {
        this.functionName = name;
    }

    public AppConfigValueService getAppConfigValuesService() {
        return this.appConfigValuesService;
    }

    public void setAppConfigValuesService(AppConfigValueService appConfigValuesService) {
        this.appConfigValuesService = appConfigValuesService;
    }

    public EisCommonService getEisCommonService() {
        return this.eisCommonService;
    }

    public void setEisCommonService(EisCommonService eisCommonService) {
        this.eisCommonService = eisCommonService;
    }

    public FinancialYearDAO getFinancialYearDAO() {
        return this.financialYearDAO;
    }

    public void setFinancialYearDAO(FinancialYearDAO financialYearDAO) {
        this.financialYearDAO = financialYearDAO;
    }
}

