/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.controller.expensebill;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.egov.commons.Accountdetailtype;
import org.egov.commons.CChartOfAccountDetail;
import org.egov.commons.CChartOfAccounts;
import org.egov.commons.service.AccountdetailtypeService;
import org.egov.commons.service.ChartOfAccountsService;
import org.egov.commons.utils.EntityType;
import org.egov.egf.billsubtype.service.EgBillSubTypeService;
import org.egov.egf.expensebill.service.ExpenseBillService;
import org.egov.egf.web.controller.voucher.BaseVoucherController;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infstr.services.PersistenceService;
import org.egov.model.bills.EgBillPayeedetails;
import org.egov.model.bills.EgBillSubType;
import org.egov.model.bills.EgBilldetails;
import org.egov.model.bills.EgBillregister;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;

@Controller
public abstract class BaseBillController
extends BaseVoucherController {
    @Autowired
    private EgBillSubTypeService egBillSubTypeService;
    @Autowired
    private AccountdetailtypeService accountdetailtypeService;
    @Autowired
    @Qualifier(value="chartOfAccountsService")
    private ChartOfAccountsService chartOfAccountsService;
    @Autowired
    private ExpenseBillService expenseBillService;
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;

    public BaseBillController(AppConfigValueService appConfigValuesService) {
        super(appConfigValuesService);
    }

    protected void setDropDownValues(Model model) {
        super.setDropDownValues(model);
        model.addAttribute("billNumberGenerationAuto", (Object)this.expenseBillService.isBillNumberGenerationAuto());
        model.addAttribute("billSubTypes", (Object)this.getBillSubTypes());
        model.addAttribute("subLedgerTypes", (Object)this.accountdetailtypeService.findAll());
    }

    public List<EgBillSubType> getBillSubTypes() {
        return this.egBillSubTypeService.getByExpenditureType("Expense");
    }

    protected void validateBillNumber(EgBillregister egBillregister, BindingResult resultBinder) {
        if (!this.expenseBillService.isBillNumberGenerationAuto() && egBillregister.getId() == null && !this.expenseBillService.isBillNumUnique(egBillregister.getBillnumber())) {
            resultBinder.reject("msg.expense.bill.duplicate.bill.number", (Object[])new String[]{egBillregister.getBillnumber()}, null);
        }
    }

    protected void validateLedgerAndSubledger(EgBillregister egBillregister, BindingResult resultBinder) {
        BigDecimal totalDrAmt = BigDecimal.ZERO;
        BigDecimal totalCrAmt = BigDecimal.ZERO;
        for (EgBilldetails details : egBillregister.getEgBilldetailes()) {
            if (details.getDebitamount() != null) {
                totalDrAmt = totalDrAmt.add(details.getDebitamount());
            }
            if (details.getCreditamount() != null) {
                totalCrAmt = totalCrAmt.add(details.getCreditamount());
            }
            if (details.getGlcodeid() == null) {
                resultBinder.reject("msg.expense.bill.accdetail.accmissing", (Object[])new String[0], null);
            }
            if (details.getDebitamount() != null && details.getCreditamount() != null && details.getDebitamount().equals(BigDecimal.ZERO) && details.getCreditamount().equals(BigDecimal.ZERO) && details.getGlcodeid() != null) {
                resultBinder.reject("msg.expense.bill.accdetail.amountzero", (Object[])new String[]{details.getChartOfAccounts().getGlcode()}, null);
            }
            if (details.getDebitamount() == null || details.getCreditamount() == null || details.getDebitamount().compareTo(BigDecimal.ZERO) != 1 || details.getCreditamount().compareTo(BigDecimal.ZERO) != 1) continue;
            resultBinder.reject("msg.expense.bill.accdetail.amount", (Object[])new String[]{details.getChartOfAccounts().getGlcode()}, null);
        }
        if (totalDrAmt.compareTo(totalCrAmt) != 0) {
            resultBinder.reject("msg.expense.bill.accdetail.drcrmatch", (Object[])new String[0], null);
        }
        this.validateSubledgerDetails(egBillregister, resultBinder);
    }

    protected void validateSubledgerDetails(EgBillregister egBillregister, BindingResult resultBinder) {
        for (EgBilldetails details : egBillregister.getEgBilldetailes()) {
            BigDecimal detailAmt = BigDecimal.ZERO;
            BigDecimal payeeDetailAmt = BigDecimal.ZERO;
            if (details.getDebitamount() != null && details.getDebitamount().compareTo(BigDecimal.ZERO) == 1) {
                detailAmt = details.getDebitamount();
            } else if (details.getCreditamount() != null && details.getCreditamount().compareTo(BigDecimal.ZERO) == 1) {
                detailAmt = details.getCreditamount();
            }
            for (EgBillPayeedetails payeeDetails : details.getEgBillPaydetailes()) {
                if (payeeDetails.getDebitAmount() != null && payeeDetails.getCreditAmount() != null && payeeDetails.getDebitAmount().equals(BigDecimal.ZERO) && payeeDetails.getCreditAmount().equals(BigDecimal.ZERO)) {
                    resultBinder.reject("msg.expense.bill.subledger.amountzero", (Object[])new String[]{details.getChartOfAccounts().getGlcode()}, null);
                }
                if (payeeDetails.getDebitAmount() != null && payeeDetails.getCreditAmount() != null && payeeDetails.getDebitAmount().compareTo(BigDecimal.ZERO) == 1 && payeeDetails.getCreditAmount().compareTo(BigDecimal.ZERO) == 1) {
                    resultBinder.reject("msg.expense.bill.subledger.amount", (Object[])new String[]{details.getChartOfAccounts().getGlcode()}, null);
                }
                if (payeeDetails.getDebitAmount() != null && payeeDetails.getDebitAmount().compareTo(BigDecimal.ZERO) == 1) {
                    payeeDetailAmt = payeeDetailAmt.add(payeeDetails.getDebitAmount());
                } else if (payeeDetails.getCreditAmount() != null && payeeDetails.getCreditAmount().compareTo(BigDecimal.ZERO) == 1) {
                    payeeDetailAmt = payeeDetailAmt.add(payeeDetails.getCreditAmount());
                }
                Boolean check = false;
                for (CChartOfAccountDetail coaDetails : details.getChartOfAccounts().getChartOfAccountDetails()) {
                    if (payeeDetails.getAccountDetailTypeId() != coaDetails.getDetailTypeId().getId()) continue;
                    check = true;
                }
                if (check.booleanValue()) continue;
                resultBinder.reject("msg.expense.bill.subledger.mismatch", (Object[])new String[]{details.getChartOfAccounts().getGlcode()}, null);
            }
            if (detailAmt.compareTo(payeeDetailAmt) == 0 || details.getEgBillPaydetailes().isEmpty()) continue;
            resultBinder.reject("msg.expense.bill.subledger.amtnotmatchinng", (Object[])new String[]{details.getChartOfAccounts().getGlcode()}, null);
        }
    }

    protected void populateBillDetails(EgBillregister egBillregister) {
        egBillregister.getEgBilldetailes().clear();
        egBillregister.getEgBilldetailes().addAll(egBillregister.getBillDetails());
        for (EgBilldetails details : egBillregister.getEgBilldetailes()) {
            if (egBillregister.getEgBillregistermis().getFunction() != null) {
                details.setFunctionid(BigDecimal.valueOf(egBillregister.getEgBillregistermis().getFunction().getId()));
            }
            details.setEgBillregister(egBillregister);
            details.setLastupdatedtime(new Date());
            details.setChartOfAccounts((CChartOfAccounts)this.chartOfAccountsService.findById((Serializable)Long.valueOf(details.getGlcodeid().longValue()), false));
        }
        if (!egBillregister.getBillPayeedetails().isEmpty()) {
            this.populateBillPayeeDetails(egBillregister);
        }
    }

    protected void populateBillPayeeDetails(EgBillregister egBillregister) {
        for (EgBilldetails details : egBillregister.getEgBilldetailes()) {
            for (EgBillPayeedetails payeeDetails : egBillregister.getBillPayeedetails()) {
                if (!details.getGlcodeid().equals(payeeDetails.getEgBilldetailsId().getGlcodeid())) continue;
                EgBillPayeedetails payeeDetail = new EgBillPayeedetails();
                payeeDetail.setEgBilldetailsId(details);
                payeeDetail.setAccountDetailTypeId(payeeDetails.getAccountDetailTypeId());
                payeeDetail.setAccountDetailKeyId(payeeDetails.getAccountDetailKeyId());
                payeeDetail.setDebitAmount(payeeDetails.getDebitAmount());
                payeeDetail.setCreditAmount(payeeDetails.getCreditAmount());
                payeeDetail.setLastUpdatedTime(new Date());
                details.getEgBillPaydetailes().add(payeeDetail);
            }
        }
    }

    protected void prepareBillDetailsForView(EgBillregister egBillregister) {
        for (EgBilldetails details : egBillregister.getBillDetails()) {
            details.setChartOfAccounts((CChartOfAccounts)this.chartOfAccountsService.findById((Serializable)Long.valueOf(details.getGlcodeid().longValue()), false));
            egBillregister.getBillPayeedetails().addAll(details.getEgBillPaydetailes());
        }
        for (EgBillPayeedetails payeeDetails : egBillregister.getBillPayeedetails()) {
            payeeDetails.getEgBilldetailsId().setChartOfAccounts((CChartOfAccounts)this.chartOfAccountsService.findById((Serializable)Long.valueOf(payeeDetails.getEgBilldetailsId().getGlcodeid().longValue()), false));
            Accountdetailtype detailType = this.accountdetailtypeService.findOne(payeeDetails.getAccountDetailTypeId());
            EntityType entity = null;
            String dataType = "";
            try {
                String table = detailType.getFullQualifiedName();
                Class<?> service = Class.forName(table);
                String tableName = service.getSimpleName();
                Method method = service.getMethod("getId", new Class[0]);
                dataType = method.getReturnType().getSimpleName();
                entity = "Long".equals(dataType) ? (EntityType)this.persistenceService.find("from " + tableName + " where id=? order by name", new Object[]{payeeDetails.getAccountDetailKeyId().longValue()}) : (EntityType)this.persistenceService.find("from " + tableName + " where id=? order by name", new Object[]{payeeDetails.getAccountDetailKeyId()});
            }
            catch (Exception e) {
                throw new ApplicationRuntimeException(e.getMessage());
            }
            payeeDetails.setDetailTypeName(detailType.getName());
            payeeDetails.setDetailKeyName(entity.getName());
        }
    }
}

