/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.controller.advancepayment;

import java.util.LinkedHashMap;
import java.util.Map;
import org.egov.commons.CVoucherHeader;
import org.egov.commons.Fund;
import org.egov.commons.service.BankBranchService;
import org.egov.egf.advancepayment.service.AdvancePaymentService;
import org.egov.egf.web.controller.voucher.BaseVoucherController;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.services.payment.MiscbilldetailService;
import org.egov.services.payment.PaymentService;
import org.egov.utils.FinancialConstants;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ui.Model;

public class BasePaymentController
extends BaseVoucherController {
    @Autowired
    private BankBranchService bankBranchService;
    @Autowired
    protected MiscbilldetailService miscbilldetailService;
    @Autowired
    protected PaymentService paymentService;
    @Autowired
    protected AdvancePaymentService advancePaymentService;

    public BasePaymentController(AppConfigValueService appConfigValuesService) {
        super(appConfigValuesService);
    }

    public void prepare(Model model) {
        super.setDropDownValues(model);
    }

    private String getTypeOfAccount() {
        return "PAYMENTS,RECEIPTS_PAYMENTS";
    }

    protected void loadbankBranch(Fund fund, Model model) {
        String typeOfAccount = this.getTypeOfAccount();
        String[] strArray = typeOfAccount.split(",");
        model.addAttribute("bankbranchList", (Object)this.bankBranchService.getBankBranchByFund(fund, strArray));
    }

    public Map<String, String> getModeOfPayments() {
        LinkedHashMap<String, String> modeOfPaymentMap = new LinkedHashMap<String, String>();
        modeOfPaymentMap.put("cheque", "cheque".toUpperCase());
        modeOfPaymentMap.put("cash", "cash".toUpperCase());
        modeOfPaymentMap.put("rtgs", "rtgs".toUpperCase());
        return modeOfPaymentMap;
    }

    public CVoucherHeader setVoucherStatus(CVoucherHeader voucherHeader, String workFlowAction) {
        if ("Cancel".toString().equalsIgnoreCase(workFlowAction)) {
            voucherHeader.setStatus(FinancialConstants.CANCELLEDVOUCHERSTATUS);
        } else if ("Approve".toString().equalsIgnoreCase(workFlowAction)) {
            voucherHeader.setStatus(FinancialConstants.CREATEDVOUCHERSTATUS);
        } else {
            voucherHeader.setStatus(FinancialConstants.PREAPPROVEDVOUCHERSTATUS);
        }
        return voucherHeader;
    }
}

