/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.controller.advancepayment;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.egov.commons.CVoucherHeader;
import org.egov.commons.service.FundService;
import org.egov.egf.advancepayment.SearchAdvanceRequisition;
import org.egov.egf.expensebill.service.ExpenseBillService;
import org.egov.egf.utils.FinancialUtils;
import org.egov.egf.web.controller.advancepayment.BasePaymentController;
import org.egov.eis.web.contract.WorkflowContainer;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.exception.ApplicationException;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.model.advance.EgAdvanceRequisition;
import org.egov.model.bills.EgBillregister;
import org.egov.model.payment.Paymentheader;
import org.egov.services.masters.EgPartyTypeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/advancepayment"})
public class AdvancePaymentController
extends BasePaymentController {
    private static final String STATE_TYPE = "stateType";
    private static final String ADVANCEPAYMENT_NEW = "advancepayment-new";
    private static final String APPROVAL_POSITION = "approvalPosition";
    private static final String APPROVAL_DESIGNATION = "approvalDesignation";
    private static final String DESIGNATION = "designation";
    private static final String ADVANCEPAYMENT_VIEW = "advancepayment-view";
    private static final String ADVANCEREQUISITION_SEARCH = "advancerequisition-search";
    @Autowired
    private ExpenseBillService expenseBillService;
    @Autowired
    private FinancialUtils financialUtils;
    @Autowired
    private FundService fundService;
    @Autowired
    @Qualifier(value="messageSource")
    private MessageSource messageSource;
    @Autowired
    private EgPartyTypeService egPartyTypeService;

    public AdvancePaymentController(AppConfigValueService appConfigValuesService) {
        super(appConfigValuesService);
    }

    public void prepare(Model model) {
        super.prepare(model);
        model.addAttribute("bankaccounts", Collections.emptyList());
        model.addAttribute("modeOfPaymentMap", (Object)this.getModeOfPayments());
    }

    @RequestMapping(value={"/search"}, method={RequestMethod.GET})
    public String search(@ModelAttribute SearchAdvanceRequisition searchAdvanceRequisition, Model model) {
        model.addAttribute("partyType", (Object)this.egPartyTypeService.findAll());
        model.addAttribute("searchAdvanceRequisition", (Object)searchAdvanceRequisition);
        model.addAttribute("fund", (Object)this.fundService.getByIsActive(Boolean.valueOf(true)));
        return ADVANCEREQUISITION_SEARCH;
    }

    @RequestMapping(value={"/ajaxsearch"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String searchBill(@ModelAttribute SearchAdvanceRequisition searchAdvanceRequisition) {
        List advanceRequisitionList = this.advancePaymentService.searchAdvanceBill(searchAdvanceRequisition);
        String result = "[";
        if (!advanceRequisitionList.isEmpty()) {
            for (EgAdvanceRequisition eg : advanceRequisitionList) {
                String data = "{\"advanceReqSourcePath\":\"" + eg.getEgAdvanceReqMises().getSourcePath() + "\",\"billId\":\"" + eg.getEgAdvanceReqMises().getEgBillregister().getId() + "\",\"voucherId\":\"" + eg.getEgAdvanceReqMises().getEgBillregister().getEgBillregistermis().getVoucherHeader().getId() + "\",\"advanceRequisitionNumber\":\"" + eg.getAdvanceRequisitionNumber() + "\",\"partyType\":\"" + eg.getArftype() + "\",\"voucherNumber\":\"" + eg.getEgAdvanceReqMises().getEgBillregister().getEgBillregistermis().getVoucherHeader().getVoucherNumber() + "\",\"amount\":" + eg.getEgAdvanceReqMises().getEgBillregister().getBillamount() + "},";
                result = result.concat(data);
            }
        }
        StringBuilder results = new StringBuilder("{ \"data\":").append(result);
        if (advanceRequisitionList.isEmpty()) {
            return results.append("]}").toString();
        }
        return results.deleteCharAt(results.length() - 1).append("]}").toString();
    }

    @RequestMapping(value={"/newform"}, method={RequestMethod.GET})
    public String newForm(@RequestParam(value="billId") String billId, Model model) {
        this.prepare(model);
        EgBillregister egBillRegister = this.expenseBillService.getById(Long.valueOf(Long.parseLong(billId)));
        this.loadbankBranch(egBillRegister.getEgBillregistermis().getFund(), model);
        CVoucherHeader voucherHeader = egBillRegister.getEgBillregistermis().getVoucherHeader();
        voucherHeader.setVoucherDate(new Date());
        model.addAttribute("voucherHeader", (Object)voucherHeader);
        model.addAttribute("egBillregister", (Object)egBillRegister);
        model.addAttribute(STATE_TYPE, (Object)Paymentheader.class.getSimpleName());
        model.addAttribute("billIds", (Object)billId);
        this.prepareWorkflow(model, (StateAware)egBillRegister.getEgBillregistermis().getVoucherHeader(), new WorkflowContainer());
        this.prepareValidActionListByCutOffDate(model);
        return ADVANCEPAYMENT_NEW;
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String create(@ModelAttribute(value="voucherHeader") CVoucherHeader voucherHeader, Model model, BindingResult resultBinder, HttpServletRequest request, @RequestParam String workFlowAction) throws IOException, ApplicationException {
        Paymentheader paymentHeader;
        String modeOfPay = "";
        String bankAccount = "";
        if (StringUtils.isNotBlank((String)request.getParameter("bankaccount"))) {
            bankAccount = request.getParameter("bankaccount");
        }
        EgBillregister egBillRegister = this.expenseBillService.getById(Long.valueOf(Long.parseLong(request.getParameter("billId"))));
        if (request.getParameter("modeOfPayment") != null && StringUtils.isNotBlank((String)request.getParameter("modeOfPayment"))) {
            modeOfPay = request.getParameter("modeOfPayment");
        }
        EgAdvanceRequisition egAdvanceRequisition = this.advancePaymentService.validateVoucherDetails(egBillRegister, modeOfPay, resultBinder);
        if (resultBinder.hasErrors()) {
            this.setUp(model, egBillRegister, voucherHeader, request);
            return ADVANCEPAYMENT_NEW;
        }
        Long approvalPosition = 0L;
        String approvalComment = "";
        if (request.getParameter("approvalComent") != null) {
            approvalComment = request.getParameter("approvalComent");
        }
        if (request.getParameter(APPROVAL_POSITION) != null && !request.getParameter(APPROVAL_POSITION).isEmpty()) {
            approvalPosition = Long.valueOf(request.getParameter(APPROVAL_POSITION));
        }
        try {
            paymentHeader = this.advancePaymentService.createAdvancePayment(egBillRegister, voucherHeader, egAdvanceRequisition, bankAccount, modeOfPay, workFlowAction, approvalComment, approvalPosition, egAdvanceRequisition.getAdvanceRequisitionAmount());
        }
        catch (ValidationException e) {
            this.setUp(model, egBillRegister, voucherHeader, request);
            return ADVANCEPAYMENT_NEW;
        }
        String approverDetails = this.financialUtils.getApproverDetails(workFlowAction, paymentHeader.getState(), paymentHeader.getId(), approvalPosition);
        return "redirect:/advancepayment/success?approverDetails= " + approverDetails + "&voucherNumber=" + paymentHeader.getVoucherheader().getVoucherNumber() + "&workFlowAction=" + workFlowAction;
    }

    @RequestMapping(value={"/view/{paymentId}"}, method={RequestMethod.GET})
    public String viewForm(Model model, @PathVariable String paymentId, HttpServletRequest request) throws ApplicationException {
        String[] payId = paymentId.split("&");
        Paymentheader paymentHeader = (Paymentheader)this.paymentService.findById((Serializable)Long.valueOf(Long.parseLong(payId[0])), false);
        EgBillregister egBillRegister = this.advancePaymentService.getBillRegisterFromPayVhid(paymentHeader);
        this.prepare(model);
        model.addAttribute("egBillregister", (Object)egBillRegister);
        model.addAttribute("totalAmount", (Object)paymentHeader.getPaymentAmount());
        model.addAttribute(STATE_TYPE, (Object)Paymentheader.class.getSimpleName());
        if (paymentHeader.getState() != null) {
            model.addAttribute("currentState", (Object)paymentHeader.getState().getValue());
        }
        model.addAttribute("workflowHistory", (Object)this.financialUtils.getHistory(paymentHeader.getState(), paymentHeader.getStateHistory()));
        this.prepareWorkflow(model, (StateAware)paymentHeader, new WorkflowContainer());
        model.addAttribute("paymentHeader", (Object)paymentHeader);
        model.addAttribute("voucherHeader", (Object)paymentHeader.getVoucherheader());
        if (payId.length > 1 && StringUtils.isNotBlank((String)paymentId.split("&")[1])) {
            model.addAttribute("mode", (Object)"readOnly");
        } else {
            model.addAttribute("mode", (Object)"view");
        }
        return ADVANCEPAYMENT_VIEW;
    }

    @RequestMapping(value={"/view/{paymentId}"}, method={RequestMethod.POST})
    public String forward(@ModelAttribute(value="voucherHeader") CVoucherHeader voucherHeader, BindingResult resultBinder, Model model, HttpServletRequest request, @RequestParam String workFlowAction) throws ApplicationException, IOException {
        Paymentheader paymentheader = (Paymentheader)this.paymentService.findById((Serializable)Long.valueOf(Long.parseLong(request.getParameter("payHeaderId"))), false);
        Long approvalPosition = 0L;
        String approvalComment = "";
        if (request.getParameter("approvalComent") != null) {
            approvalComment = request.getParameter("approvalComent");
        }
        if (request.getParameter(APPROVAL_POSITION) != null && !request.getParameter(APPROVAL_POSITION).isEmpty()) {
            approvalPosition = Long.valueOf(request.getParameter(APPROVAL_POSITION));
        }
        paymentheader.setVoucherheader(this.setVoucherStatus(paymentheader.getVoucherheader(), workFlowAction));
        Paymentheader updatedPaymentHeader = this.advancePaymentService.updatePaymentHeader(paymentheader, workFlowAction, approvalPosition, approvalComment, null);
        String approverDetails = this.financialUtils.getApproverDetails(workFlowAction, updatedPaymentHeader.getState(), updatedPaymentHeader.getId(), approvalPosition);
        return "redirect:/advancepayment/success?approverDetails= " + approverDetails + "&voucherNumber=" + updatedPaymentHeader.getVoucherheader().getVoucherNumber() + "&workFlowAction=" + workFlowAction;
    }

    private void setUp(Model model, EgBillregister egBillregister, CVoucherHeader cVoucherHeader, HttpServletRequest request) {
        this.prepare(model);
        this.loadbankBranch(egBillregister.getEgBillregistermis().getFund(), model);
        model.addAttribute(STATE_TYPE, (Object)Paymentheader.class.getSimpleName());
        this.prepareWorkflow(model, (StateAware)egBillregister.getEgBillregistermis().getVoucherHeader(), new WorkflowContainer());
        model.addAttribute(APPROVAL_DESIGNATION, (Object)request.getParameter(APPROVAL_DESIGNATION));
        model.addAttribute(APPROVAL_POSITION, (Object)request.getParameter(APPROVAL_POSITION));
        model.addAttribute(DESIGNATION, (Object)request.getParameter(DESIGNATION));
        model.addAttribute("voucherHeader", (Object)cVoucherHeader);
        model.addAttribute("egBillregister", (Object)egBillregister);
    }

    @RequestMapping(value={"/success"}, method={RequestMethod.GET})
    public String showSuccessPage(@RequestParam(value="voucherNumber") String voucherNumber, Model model, HttpServletRequest request) {
        String[] keyNameArray = request.getParameter("approverDetails").split(",");
        String workFlowAction = request.getParameter("workFlowAction");
        Long id = 0L;
        String approverName = "";
        String currentUserDesgn = "";
        String nextDesign = "";
        if (keyNameArray.length != 0 && keyNameArray.length > 0) {
            if (keyNameArray.length == 1) {
                id = Long.parseLong(keyNameArray[0].trim());
            } else if (keyNameArray.length == 3) {
                id = Long.parseLong(keyNameArray[0].trim());
                approverName = keyNameArray[1];
                currentUserDesgn = keyNameArray[2];
            } else {
                id = Long.parseLong(keyNameArray[0].trim());
                approverName = keyNameArray[1];
                currentUserDesgn = keyNameArray[2];
                nextDesign = keyNameArray[3];
            }
        }
        if (id != null) {
            model.addAttribute("approverName", (Object)approverName);
        }
        model.addAttribute("currentUserDesgn", (Object)currentUserDesgn);
        model.addAttribute("nextDesign", (Object)nextDesign);
        String message = this.getMessageByStatus(voucherNumber, approverName, nextDesign, workFlowAction);
        model.addAttribute("message", (Object)message);
        return "advancepayment-success";
    }

    private String getMessageByStatus(String paymentheader, String approverName, String nextDesign, String workFlowAction) {
        String message = "";
        if ("Forward".toString().equalsIgnoreCase(workFlowAction)) {
            message = this.messageSource.getMessage("msg.advance.payment.create.success", (Object[])new String[]{paymentheader, approverName, nextDesign}, null);
        } else if ("Approve".toString().equalsIgnoreCase(workFlowAction)) {
            message = this.messageSource.getMessage("msg.advance.payment.approved.success", (Object[])new String[]{paymentheader}, null);
        } else if ("Reject".toString().equalsIgnoreCase(workFlowAction)) {
            message = this.messageSource.getMessage("msg.advance.payment.reject", (Object[])new String[]{paymentheader, approverName, nextDesign}, null);
        } else if ("Cancel".toString().equalsIgnoreCase(workFlowAction)) {
            message = this.messageSource.getMessage("msg.advance.payment.cancel", (Object[])new String[]{paymentheader}, null);
        } else if ("Create And Approve".toString().equalsIgnoreCase(workFlowAction)) {
            message = this.messageSource.getMessage("msg.advance.payment.createapprove.success", (Object[])new String[]{paymentheader}, null);
        }
        return message;
    }
}

