/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.adaptor;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import org.egov.model.budget.BudgetApproval;
import org.egov.model.service.BudgetDefinitionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BudgetApprovalAdaptor
implements JsonSerializer<BudgetApproval> {
    @Autowired
    private BudgetDefinitionService budgetDefinitionService;

    public JsonElement serialize(BudgetApproval budgetApproval, Type type, JsonSerializationContext jsc) {
        JsonObject jsonObject = new JsonObject();
        Long finYrId = this.budgetDefinitionService.getFinancialYearForBudget(budgetApproval.getId());
        jsonObject.addProperty("id", (Number)budgetApproval.getId());
        jsonObject.addProperty("department", budgetApproval.getDepartment());
        jsonObject.addProperty("parent", budgetApproval.getReferenceBudget());
        jsonObject.addProperty("referenceBudget", budgetApproval.getParent());
        jsonObject.addProperty("reAmount", (Number)budgetApproval.getReAmount());
        jsonObject.addProperty("beAmount", (Number)budgetApproval.getBeAmount());
        jsonObject.addProperty("count", (Number)budgetApproval.getCount());
        jsonObject.addProperty("approvedBudget", (Number)this.budgetDefinitionService.getApproved(finYrId));
        jsonObject.addProperty("verifiedBudget", (Number)this.budgetDefinitionService.getVerified(finYrId));
        jsonObject.addProperty("notInitiated", (Number)this.budgetDefinitionService.getNotInitalized(finYrId));
        return jsonObject;
    }
}

