/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.voucher;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.commons.CVoucherHeader;
import org.egov.egf.budget.service.BudgetControlTypeService;
import org.egov.egf.web.actions.voucher.BaseVoucherAction;
import org.egov.eis.service.EisCommonService;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.script.service.ScriptService;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.infra.workflow.service.SimpleWorkflowService;
import org.egov.model.voucher.VoucherDetails;
import org.egov.model.voucher.VoucherTypeBean;
import org.egov.model.voucher.WorkflowBean;
import org.egov.pims.commons.Position;
import org.egov.services.voucher.JournalVoucherActionHelper;
import org.egov.services.voucher.VoucherService;
import org.egov.utils.VoucherHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@ParentPackage(value="egov")
@Results(value={@Result(name={"new"}, location="journalVoucher-new.jsp")})
public class JournalVoucherAction
extends BaseVoucherAction {
    private static final Logger LOGGER = Logger.getLogger(JournalVoucherAction.class);
    private static final long serialVersionUID = 1L;
    private List<VoucherDetails> billDetailslist;
    private List<VoucherDetails> subLedgerlist;
    private String target;
    protected String showMode;
    @Autowired
    @Qualifier(value="voucherService")
    private VoucherService voucherService;
    @Autowired
    @Qualifier(value="journalVoucherActionHelper")
    private JournalVoucherActionHelper journalVoucherActionHelper;
    private VoucherTypeBean voucherTypeBean;
    private String buttonValue;
    private String message = "";
    private Integer departmentId;
    private String wfitemstate;
    private VoucherHelper voucherHelper;
    private static final String VOUCHERQUERY = " from CVoucherHeader where id=?";
    private static final String ACTIONNAME = "actionName";
    private SimpleWorkflowService<CVoucherHeader> voucherWorkflowService;
    private static final String VHID = "vhid";
    protected EisCommonService eisCommonService;
    @Autowired
    protected AppConfigValueService appConfigValuesService;
    private String cutOffDate;
    protected DateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
    DateFormat df = new SimpleDateFormat("dd-MMM-yyyy");
    DateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
    SimpleDateFormat formatter1 = new SimpleDateFormat("yyyy-MM-dd");
    Date date;
    @Autowired
    private BudgetControlTypeService budgetCheckConfigService;
    @Autowired
    private ScriptService scriptService;

    public void prepare() {
        super.prepare();
        this.addDropdownData("approvaldepartmentList", Collections.EMPTY_LIST);
        this.addDropdownData("designationList", Collections.EMPTY_LIST);
        this.addDropdownData("userList", Collections.EMPTY_LIST);
    }

    @SkipValidation
    @Action(value="/voucher/journalVoucher-newForm")
    public String newForm() {
        List cutOffDateconfigValue = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "DataEntryCutOffDate");
        if (cutOffDateconfigValue != null && !cutOffDateconfigValue.isEmpty()) {
            try {
                this.date = this.df.parse(((AppConfigValues)cutOffDateconfigValue.get(0)).getValue());
                this.cutOffDate = this.formatter.format(this.date);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        this.billDetailslist = new ArrayList();
        this.subLedgerlist = new ArrayList();
        this.billDetailslist.add(new VoucherDetails());
        this.billDetailslist.add(new VoucherDetails());
        this.subLedgerlist.add(new VoucherDetails());
        this.showMode = "new";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"JournalVoucherAction | new | End");
        }
        return "new";
    }

    @SkipValidation
    public String viewform() {
        this.showMode = "view";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"JournalVoucherAction | new | End");
        }
        return "new";
    }

    public StateAware getModel() {
        this.voucherHeader = (CVoucherHeader)super.getModel();
        this.voucherHeader.setType("Journal Voucher");
        return this.voucherHeader;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SkipValidation
    @Action(value="/voucher/journalVoucher-create")
    public String create() throws Exception {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"VoucherAction | create Method | Start");
        }
        String voucherDate = this.formatter1.format(this.voucherHeader.getVoucherDate());
        String cutOffDate1 = null;
        this.removeEmptyRowsAccoutDetail(this.billDetailslist);
        this.removeEmptyRowsSubledger(this.subLedgerlist);
        this.target = "";
        String voucherNumber = this.voucherHeader.getVoucherNumber();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Bill details List size  : " + this.billDetailslist.size()));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Sub ledger details List size  : " + this.subLedgerlist.size()));
        }
        this.loadSchemeSubscheme();
        this.validateFields();
        if (!this.validateData(this.billDetailslist, this.subLedgerlist)) {
            try {
                if (!"JVGeneral".equalsIgnoreCase(this.voucherTypeBean.getVoucherName())) {
                    this.voucherTypeBean.setTotalAmount(((String[])this.parameters.get("totaldbamount"))[0]);
                }
                this.populateWorkflowBean();
                this.voucherHeader = this.journalVoucherActionHelper.createVoucher(this.billDetailslist, this.subLedgerlist, this.voucherHeader, this.voucherTypeBean, this.workflowBean);
                if (!this.cutOffDate.isEmpty() && this.cutOffDate != null) {
                    try {
                        this.date = this.sdf.parse(this.cutOffDate);
                        cutOffDate1 = this.formatter1.format(this.date);
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
                if (cutOffDate1 != null && voucherDate.compareTo(cutOffDate1) <= 0 && "Create And Approve".equalsIgnoreCase(this.workflowBean.getWorkFlowAction())) {
                    if (this.voucherHeader.getVouchermis().getBudgetaryAppnumber() == null) {
                        this.message = "Voucher  " + this.voucherHeader.getVoucherNumber() + " Created Sucessfully";
                        this.target = "success";
                    } else {
                        this.message = "Voucher  " + this.voucherHeader.getVoucherNumber() + " Created Sucessfully" + "\\n" + "And " + this.getText("budget.recheck.sucessful", new String[]{this.voucherHeader.getVouchermis().getBudgetaryAppnumber()});
                        this.target = "success";
                    }
                } else if (this.voucherHeader.getVouchermis().getBudgetaryAppnumber() == null) {
                    this.message = "Voucher  " + this.voucherHeader.getVoucherNumber() + " Created Sucessfully" + "\\n" + this.getText("pjv.voucher.approved", new String[]{this.voucherService.getEmployeeNameForPositionId(this.voucherHeader.getState().getOwnerPosition())});
                    this.target = "success";
                } else {
                    this.message = "Voucher  " + this.voucherHeader.getVoucherNumber() + " Created Sucessfully" + "\\n" + "And " + this.getText("budget.recheck.sucessful", new String[]{this.voucherHeader.getVouchermis().getBudgetaryAppnumber()}) + "\\n" + this.getText("pjv.voucher.approved", new String[]{this.voucherService.getEmployeeNameForPositionId(this.voucherHeader.getState().getOwnerPosition())});
                    this.target = "success";
                }
                if (!LOGGER.isDebugEnabled()) return this.viewform();
                LOGGER.debug((Object)("JournalVoucherAction | create  | Success | message === " + this.message));
                return this.viewform();
            }
            catch (ValidationException e) {
                if (this.subLedgerlist.size() == 0) {
                    this.subLedgerlist.add(new VoucherDetails());
                }
                this.voucherHeader.setVoucherNumber(voucherNumber);
                ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
                errors.add(new ValidationError("exp", ((ValidationError)e.getErrors().get(0)).getMessage()));
                if (((ValidationError)e.getErrors().get(0)).getMessage() == null) throw new ValidationException("Voucher creation failed", "Voucher creation failed", new String[0]);
                if (((ValidationError)e.getErrors().get(0)).getMessage() == "") throw new ValidationException("Voucher creation failed", "Voucher creation failed", new String[0]);
                throw new ValidationException(((ValidationError)e.getErrors().get(0)).getMessage(), ((ValidationError)e.getErrors().get(0)).getMessage(), new String[0]);
            }
            catch (Exception e) {
                this.clearMessages();
                if (this.subLedgerlist.size() == 0) {
                    this.subLedgerlist.add(new VoucherDetails());
                }
                this.voucherHeader.setVoucherNumber(voucherNumber);
                ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
                errors.add(new ValidationError("exp", e.getMessage()));
                throw new ValidationException(errors);
            }
        }
        if (this.subLedgerlist.size() == 0) {
            this.subLedgerlist.add(new VoucherDetails());
        }
        if (!LOGGER.isDebugEnabled()) return "new";
        LOGGER.debug((Object)"VoucherAction | create Method | End");
        return "new";
    }

    public List<String> getValidActions() {
        List cutOffDateconfigValue = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "DataEntryCutOffDate");
        List<String> validActions = Collections.emptyList();
        if (cutOffDateconfigValue != null && !cutOffDateconfigValue.isEmpty()) {
            if (null == this.voucherHeader || null == this.voucherHeader.getId() || this.voucherHeader.getCurrentState().getValue().endsWith("NEW")) {
                validActions = Arrays.asList("Forward", "Create And Approve");
            } else if (this.voucherHeader.getCurrentState() != null) {
                validActions = this.customizedWorkFlowService.getNextValidActions(this.voucherHeader.getStateType(), this.getWorkFlowDepartment(), this.getAmountRule(), this.getAdditionalRule(), this.voucherHeader.getCurrentState().getValue(), this.getPendingActions(), this.voucherHeader.getCreatedDate());
            }
        } else if (null == this.voucherHeader || null == this.voucherHeader.getId() || this.voucherHeader.getCurrentState().getValue().endsWith("NEW")) {
            validActions = Arrays.asList("Forward");
        } else if (this.voucherHeader.getCurrentState() != null) {
            validActions = this.customizedWorkFlowService.getNextValidActions(this.voucherHeader.getStateType(), this.getWorkFlowDepartment(), this.getAmountRule(), this.getAdditionalRule(), this.voucherHeader.getCurrentState().getValue(), this.getPendingActions(), this.voucherHeader.getCreatedDate());
        }
        return validActions;
    }

    public Position getPosition() throws ApplicationRuntimeException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("getPosition====" + ApplicationThreadLocals.getUserId()));
        }
        Position pos = this.eisCommonService.getPositionByUserId(ApplicationThreadLocals.getUserId());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("position===" + pos.getId()));
        }
        return pos;
    }

    public List<VoucherDetails> getBillDetailslist() {
        return this.billDetailslist;
    }

    public void setBillDetailslist(List<VoucherDetails> billDetailslist) {
        this.billDetailslist = billDetailslist;
    }

    public List<VoucherDetails> getSubLedgerlist() {
        return this.subLedgerlist;
    }

    public void setSubLedgerlist(List<VoucherDetails> subLedgerlist) {
        this.subLedgerlist = subLedgerlist;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public VoucherTypeBean getVoucherTypeBean() {
        return this.voucherTypeBean;
    }

    public void setVoucherTypeBean(VoucherTypeBean voucherTypeBean) {
        this.voucherTypeBean = voucherTypeBean;
    }

    @ValidationErrorPage(value="new")
    public String saveAndView() throws Exception {
        this.buttonValue = "view";
        return this.create();
    }

    @ValidationErrorPage(value="new")
    public String saveAndPrint() throws Exception {
        this.buttonValue = "print";
        return this.create();
    }

    @ValidationErrorPage(value="new")
    public String saveAndNew() throws Exception {
        this.buttonValue = "new";
        return this.create();
    }

    @ValidationErrorPage(value="new")
    public String saveAndClose() throws Exception {
        this.buttonValue = "close";
        return this.create();
    }

    public String getMessage() {
        return this.message;
    }

    public String getButtonValue() {
        return this.buttonValue;
    }

    public void setButtonValue(String buttonValue) {
        this.buttonValue = buttonValue;
    }

    public String getWfitemstate() {
        return this.wfitemstate;
    }

    public void setWfitemstate(String wfitemstate) {
        this.wfitemstate = wfitemstate;
    }

    public VoucherHelper getVoucherHelper() {
        return this.voucherHelper;
    }

    public void setVoucherHelper(VoucherHelper voucherHelper) {
        this.voucherHelper = voucherHelper;
    }

    public SimpleWorkflowService<CVoucherHeader> getVoucherWorkflowService() {
        return this.voucherWorkflowService;
    }

    public void setVoucherWorkflowService(SimpleWorkflowService<CVoucherHeader> voucherWorkflowService) {
        this.voucherWorkflowService = voucherWorkflowService;
    }

    public EisCommonService getEisCommonService() {
        return this.eisCommonService;
    }

    public void setEisCommonService(EisCommonService eisCommonService) {
        this.eisCommonService = eisCommonService;
    }

    public String getShowMode() {
        return this.showMode;
    }

    public void setShowMode(String showMode) {
        this.showMode = showMode;
    }

    public WorkflowBean getWorkflowBean() {
        return this.workflowBean;
    }

    public void setWorkflowBean(WorkflowBean workflowBean) {
        this.workflowBean = workflowBean;
    }

    public String getCutOffDate() {
        return this.cutOffDate;
    }

    public void setCutOffDate(String cutOffDate) {
        this.cutOffDate = cutOffDate;
    }
}

