/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.report;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Date;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.export.JRHtmlExporterParameter;
import org.apache.log4j.Logger;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.commons.Accountdetailtype;
import org.egov.commons.Bankaccount;
import org.egov.commons.CFinancialYear;
import org.egov.commons.dao.FinancialYearDAO;
import org.egov.commons.service.EntityTypeService;
import org.egov.commons.utils.EntityType;
import org.egov.egf.model.BankAdviceReportInfo;
import org.egov.egf.web.actions.report.ReportAction;
import org.egov.infra.reporting.util.ReportUtil;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.infstr.services.PersistenceService;
import org.egov.utils.Constants;
import org.egov.utils.ReportHelper;
import org.hibernate.FlushMode;
import org.hibernate.SQLQuery;
import org.hibernate.transform.Transformers;
import org.hibernate.type.BigDecimalType;
import org.hibernate.type.Type;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

@Results(value={@Result(name={"search"}, location="rtgsIssueRegisterReport-search.jsp"), @Result(name={"PDF"}, type="stream", location="inputStream", params={"inputName", "inputStream", "contentType", "application/pdf", "contentDisposition", "no-cache;filename=RtgsIssueRegisterReport.pdf"}), @Result(name={"XLS"}, type="stream", location="inputStream", params={"inputName", "inputStream", "contentType", "application/xls", "contentDisposition", "no-cache;filename=RtgsIssueRegisterReport.xls"}), @Result(name={"HTML"}, type="stream", location="inputStream", params={"inputName", "inputStream", "contentType", "text/html"})})
@ParentPackage(value="egov")
public class RtgsIssueRegisterReportAction
extends ReportAction {
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(RtgsIssueRegisterReportAction.class);
    private java.util.Date fromDate = new java.util.Date();
    private java.util.Date toDate = new java.util.Date();
    private Bankaccount bankaccount;
    BankAdviceReportInfo bankAdviceInfo;
    private InputStream inputStream;
    private ReportHelper reportHelper;
    String jasperpath = "/reports/templates/rtgsIssueRegisterReportAction.jasper";
    private StringBuffer header = new StringBuffer();
    List<BankAdviceReportInfo> rtgsDisplayList = new ArrayList();
    List<Object> rtgsReportList = new ArrayList();
    Map<String, Object> paramMap = new HashMap();
    Boolean searchResult = Boolean.FALSE;
    @Autowired
    private FinancialYearDAO financialYearDAO;

    public Object getModel() {
        return null;
    }

    public void prepare() {
        this.persistenceService.getSession().setDefaultReadOnly(true);
        this.persistenceService.getSession().setFlushMode(FlushMode.MANUAL);
        super.prepare();
        this.addDropdownData("bankList", this.persistenceService.findAllBy("from Bank where isactive=true order by upper(name)", new Object[0]));
        this.addDropdownData("bankBranchList", Collections.EMPTY_LIST);
        this.addDropdownData("bankAccountList", Collections.EMPTY_LIST);
        this.addDropdownData("accNumList", Collections.EMPTY_LIST);
        this.addDropdownData("chequeNumberList", Collections.EMPTY_LIST);
        this.finYearDate();
        this.mandatoryFields.clear();
    }

    @ValidationErrorPage(value="search")
    @Action(value="/report/rtgsIssueRegisterReport-newForm")
    public String newForm() {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)this.fromDate);
            LOGGER.info((Object)this.toDate);
        }
        return "search";
    }

    private String getUlbName() {
        return ReportUtil.getCityName();
    }

    @SkipValidation
    @Action(value="/report/rtgsIssueRegisterReport-exportPdf")
    public String exportPdf() throws JRException, IOException {
        this.search();
        if (this.rtgsDisplayList.size() > 0) {
            this.inputStream = this.reportHelper.exportPdf(this.inputStream, this.jasperpath, this.getParamMap(), this.rtgsReportList);
            return "PDF";
        }
        this.prepare();
        return this.newForm();
    }

    @SkipValidation
    @Action(value="/report/rtgsIssueRegisterReport-exportHtml")
    public String exportHtml() {
        this.search();
        if (this.rtgsDisplayList.size() > 0) {
            this.inputStream = this.reportHelper.exportHtml(this.inputStream, this.jasperpath, this.getParamMap(), this.rtgsReportList, JRHtmlExporterParameter.SIZE_UNIT_POINT);
            return "HTML";
        }
        this.addActionMessage("No data found ");
        this.prepare();
        return "search";
    }

    @SkipValidation
    @Action(value="/report/rtgsIssueRegisterReport-exportXls")
    public String exportXls() throws JRException, IOException {
        this.search();
        if (this.rtgsDisplayList.size() > 0) {
            this.inputStream = this.reportHelper.exportXls(this.inputStream, this.jasperpath, this.getParamMap(), this.rtgsReportList);
            return "XLS";
        }
        this.prepare();
        return this.newForm();
    }

    protected Map<String, Object> getParamMap() {
        String fundAndBankHeading = "";
        String dateRange = "";
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
        java.util.Date date = new java.util.Date();
        String newFromDate = "";
        String newToDate = "";
        String reportRundate = "";
        fundAndBankHeading = "RTGS Register for " + this.persistenceService.find("select name from Fund where id = ?", new Object[]{Integer.parseInt(((String[])this.parameters.get("fundId"))[0])}).toString();
        if (null != ((String[])this.parameters.get("rtgsAssignedFromDate"))[0] && !((String[])this.parameters.get("rtgsAssignedFromDate"))[0].equalsIgnoreCase("")) {
            dateRange = "from " + ((String[])this.parameters.get("rtgsAssignedFromDate"))[0];
        } else {
            newFromDate = dateFormat.format(this.fromDate);
            dateRange = "from " + newFromDate;
        }
        if (null != ((String[])this.parameters.get("rtgsAssignedToDate"))[0] && !((String[])this.parameters.get("rtgsAssignedToDate"))[0].equalsIgnoreCase("")) {
            dateRange = dateRange + " to " + ((String[])this.parameters.get("rtgsAssignedToDate"))[0];
        } else {
            newToDate = dateFormat.format(this.toDate);
            dateRange = dateRange + " to " + newToDate;
        }
        reportRundate = dateFormat.format(date);
        this.paramMap.put("fundAndBankHeading", fundAndBankHeading);
        this.paramMap.put("dateRange", dateRange);
        this.paramMap.put("reportRundate", reportRundate);
        this.paramMap.put("ulbName", this.getUlbName());
        this.paramMap.put("rtgsDetailsList", this.rtgsDisplayList);
        this.paramMap.put("rtgsReportList", this.rtgsReportList);
        return this.paramMap;
    }

    public void finYearDate() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)" Getting Starting date of financial year ");
        }
        CFinancialYear date = this.financialYearDAO.getFinancialYearByDate(new java.util.Date());
        this.persistenceService.getSession().setReadOnly((Object)date, true);
        this.fromDate = date.getStartingDate();
    }

    public void setFinancialYearDAO(FinancialYearDAO financialYearDAO) {
        this.financialYearDAO = financialYearDAO;
    }

    @ValidationErrorPage(value="new")
    @Action(value="/report/rtgsIssueRegisterReport-search")
    public String search() {
        this.searchResult = Boolean.TRUE;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)" Seraching RTGS result for given criteria ");
        }
        SQLQuery query = this.persistenceService.getSession().createSQLQuery(this.getQueryString().toString()).addScalar("ihId", (Type)BigDecimalType.INSTANCE).addScalar("rtgsNumber").addScalar("rtgsDate").addScalar("vhId", (Type)BigDecimalType.INSTANCE).addScalar("paymentNumber").addScalar("paymentDate").addScalar("paymentAmount").addScalar("department").addScalar("status").addScalar("bank").addScalar("bankBranch").addScalar("dtId", (Type)BigDecimalType.INSTANCE).addScalar("dkId", (Type)BigDecimalType.INSTANCE).addScalar("accountNumber");
        if (null == ((String[])this.parameters.get("rtgsAssignedFromDate"))[0] || ((String[])this.parameters.get("rtgsAssignedFromDate"))[0].equalsIgnoreCase("")) {
            query.setDate("finStartDate", (java.util.Date)new Date(this.fromDate.getTime()));
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("Search Query ------------>" + query));
        }
        query.setResultTransformer(Transformers.aliasToBean(BankAdviceReportInfo.class));
        this.rtgsDisplayList = query.list();
        this.populateSubLedgerDetails();
        this.rtgsReportList.addAll(this.rtgsDisplayList);
        return "search";
    }

    private StringBuffer getQueryString() {
        StringBuffer queryString = new StringBuffer();
        String deptQry = "";
        String fundQry = "";
        String phQry = "";
        StringBuffer bankQry = new StringBuffer("");
        SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MMM-yyyy");
        StringBuffer instrumentHeaderQry = new StringBuffer("");
        try {
            if (null != ((String[])this.parameters.get("departmentid"))[0] && !((String[])this.parameters.get("departmentid"))[0].equalsIgnoreCase("-1")) {
                deptQry = " AND vmis.departmentid     =" + ((String[])this.parameters.get("departmentid"))[0];
            }
            instrumentHeaderQry = null != ((String[])this.parameters.get("rtgsAssignedFromDate"))[0] && !((String[])this.parameters.get("rtgsAssignedFromDate"))[0].equalsIgnoreCase("") ? instrumentHeaderQry.append(" and   ih.transactiondate >='" + dateFormat.format(formatter.parse(((String[])this.parameters.get("rtgsAssignedFromDate"))[0])) + "'") : instrumentHeaderQry.append(" and   ih.transactiondate >=:finStartDate");
            if (null != ((String[])this.parameters.get("rtgsAssignedToDate"))[0] && !((String[])this.parameters.get("rtgsAssignedToDate"))[0].equalsIgnoreCase("")) {
                instrumentHeaderQry = instrumentHeaderQry.append(" and   ih.transactiondate  <='" + dateFormat.format(formatter.parse(((String[])this.parameters.get("rtgsAssignedToDate"))[0])) + "'");
            }
            if (null != ((String[])this.parameters.get("bank"))[0] && !((String[])this.parameters.get("bank"))[0].equals("-1") && !((String[])this.parameters.get("bank"))[0].equalsIgnoreCase("")) {
                bankQry = bankQry.append(" AND b.id = " + ((String[])this.parameters.get("bank"))[0]);
            }
            if (null != ((String[])this.parameters.get("bankbranch.id"))[0] && !((String[])this.parameters.get("bankbranch.id"))[0].equals("-1") && !((String[])this.parameters.get("bankbranch.id"))[0].equalsIgnoreCase("")) {
                bankQry = bankQry.append(" AND branch.id=" + ((String[])this.parameters.get("bankbranch.id"))[0]);
            }
            if (null != ((String[])this.parameters.get("bankaccount.id"))[0] && !((String[])this.parameters.get("bankaccount.id"))[0].equals("-1") && !((String[])this.parameters.get("bankaccount.id"))[0].equalsIgnoreCase("")) {
                phQry = " AND ph.bankaccountnumberid=" + ((String[])this.parameters.get("bankaccount.id"))[0];
                instrumentHeaderQry = instrumentHeaderQry.append(" and   ih.bankaccountid =" + ((String[])this.parameters.get("bankaccount.id"))[0]);
            }
            if (null != ((String[])this.parameters.get("instrumentnumber"))[0] && !((String[])this.parameters.get("instrumentnumber"))[0].equalsIgnoreCase("")) {
                instrumentHeaderQry = instrumentHeaderQry.append(" and   ih.transactionnumber ='" + ((String[])this.parameters.get("instrumentnumber"))[0] + "'");
            }
            if (null != ((String[])this.parameters.get("fundId"))[0] && !((String[])this.parameters.get("fundId"))[0].equalsIgnoreCase("")) {
                fundQry = " AND vh.fundId            =" + ((String[])this.parameters.get("fundId"))[0];
            }
            queryString = queryString.append(" SELECT ih.id as ihId , ih.transactionnumber as rtgsNumber,  ih.transactiondate as rtgsDate, vh.id as vhId,  vh.vouchernumber as paymentNumber, to_char(vh.voucherdate,'dd/mm/yyyy') as paymentDate,   gld.detailtypeid as dtId,  gld.detailkeyid as dkId,   gld.amount as paymentAmount, dept.name as department,   stat.description as status,b.name as bank,branch.branchname as bankBranch, ba.accountnumber as accountNumber FROM Paymentheader ph, voucherheader vh,vouchermis vmis,bankaccount ba,bankbranch branch,bank b,generalledger gl,generalledgerdetail gld, egf_instrumentvoucher iv,  egf_instrumentheader ih,  eg_department dept ,egw_status stat WHERE  ph.voucherheaderid   =vh.id AND vmis.voucherheaderid = vh.id " + bankQry.toString() + "  AND ih.bankaccountid = ba.id and branch.id = ba.branchid and branch.bankid = b.id and vh.status = 0 " + fundQry + phQry + " and stat.id= ih.id_status " + " AND dept.id = vmis.departmentid " + deptQry + "  and lower(ph.type)=lower('rtgs') " + instrumentHeaderQry.toString() + " AND IV.VOUCHERHEADERID  IS NOT NULL AND iv.voucherheaderid   =vh.id AND ih.instrumentnumber IS NULL " + " AND ih.id = iv.instrumentheaderid " + " AND vh.type   = 'Payment' and gl.voucherheaderid = vh.id and gld.generalledgerid = gl.id GROUP BY ih.id , ih.transactionnumber," + " ih.transactiondate, vh.id,  vh.vouchernumber,vh.voucherDate, vmis.departmentid,  dept.name, b.name,branch.branchname,ba.accountnumber,stat.description,gld.detailtypeid,gld.detailkeyid,gld.amount ORDER BY b.name,branch.branchname,ba.accountnumber,ih.transactiondate,ih.transactionnumber,dept.name");
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return queryString;
    }

    private void populateSubLedgerDetails() {
        HashMap subLedgerList = new HashMap();
        HashMap detailTypeMapForGetEntitys = new HashMap();
        for (BankAdviceReportInfo bankAdviceReportInfo : this.rtgsDisplayList) {
            if (detailTypeMapForGetEntitys.get(bankAdviceReportInfo.getDtId().intValue()) == null) {
                detailTypeMapForGetEntitys.put(bankAdviceReportInfo.getDtId().intValue(), new ArrayList());
                ((List)detailTypeMapForGetEntitys.get(bankAdviceReportInfo.getDtId().intValue())).add(bankAdviceReportInfo.getDkId().longValue());
                continue;
            }
            ((List)detailTypeMapForGetEntitys.get(bankAdviceReportInfo.getDtId().intValue())).add(bankAdviceReportInfo.getDkId().longValue());
        }
        for (Integer keyGroup : detailTypeMapForGetEntitys.keySet()) {
            try {
                ArrayList subDetail = new ArrayList();
                Accountdetailtype detailType = (Accountdetailtype)this.persistenceService.find("from Accountdetailtype where id=? order by name", new Object[]{keyGroup});
                String table = detailType.getFullQualifiedName();
                Class<?> service = Class.forName(table);
                String simpleName = service.getSimpleName();
                simpleName = simpleName.substring(0, 1).toLowerCase() + simpleName.substring(1) + "Service";
                WebApplicationContext wac = WebApplicationContextUtils.getWebApplicationContext((ServletContext)ServletActionContext.getServletContext());
                EntityTypeService entityService = (EntityTypeService)wac.getBean(simpleName);
                ArrayList entityIds = new ArrayList((Collection)detailTypeMapForGetEntitys.get(keyGroup));
                int size = entityIds.size();
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info((Object)(entityService + " size " + size));
                }
                if (size > 999) {
                    List returnList;
                    int fromIndex = 0;
                    int toIndex = 0;
                    int step = 1000;
                    while (size - 1000 >= 0) {
                        returnList = entityService.getEntitiesById(entityIds.subList(fromIndex, toIndex += 1000));
                        if (returnList != null) {
                            subDetail.addAll(returnList);
                        }
                        fromIndex = toIndex;
                        size -= 1000;
                    }
                    if (size > 0 && (returnList = entityService.getEntitiesById(entityIds.subList(fromIndex = toIndex, toIndex = fromIndex + size))) != null) {
                        subDetail.addAll(returnList);
                    }
                    subLedgerList.put(keyGroup, subDetail);
                    continue;
                }
                subDetail.addAll(entityService.getEntitiesById(entityIds));
                subLedgerList.put(keyGroup, subDetail);
            }
            catch (ClassCastException e) {
                LOGGER.error((Object)e);
            }
            catch (Exception e) {
                LOGGER.error((Object)("Exception to get EntityType=" + e.getMessage()));
            }
        }
        List subDetail = new ArrayList();
        for (Integer keyGroup : subLedgerList.keySet()) {
            for (BankAdviceReportInfo bankAdviceReportInfo : this.rtgsDisplayList) {
                if (bankAdviceReportInfo.getDtId() == null || !keyGroup.equals(bankAdviceReportInfo.getDtId().intValue())) continue;
                subDetail = (List)subLedgerList.get(keyGroup);
                for (EntityType entityType : subDetail) {
                    if (bankAdviceReportInfo.getDtId() == null || !entityType.getEntityId().equals(bankAdviceReportInfo.getDkId().intValue()) || entityType == null) continue;
                    bankAdviceReportInfo.setPartyName(entityType.getName().toUpperCase());
                }
            }
        }
        for (BankAdviceReportInfo bankAdviceReportInfo : this.rtgsDisplayList) {
            if (!bankAdviceReportInfo.getStatus().equalsIgnoreCase("new")) continue;
            bankAdviceReportInfo.setStatus("Assigned");
        }
    }

    public java.util.Date getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(java.util.Date fromDate) {
        this.fromDate = fromDate;
    }

    public java.util.Date getToDate() {
        return this.toDate;
    }

    public void setToDate(java.util.Date toDate) {
        this.toDate = toDate;
    }

    public Bankaccount getBankaccount() {
        return this.bankaccount;
    }

    public void setBankaccount(Bankaccount bankaccount) {
        this.bankaccount = bankaccount;
    }

    public void setHeader(StringBuffer header) {
        this.header = header;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public ReportHelper getReportHelper() {
        return this.reportHelper;
    }

    public StringBuffer getHeader() {
        return this.header;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public void setReportHelper(ReportHelper reportHelper) {
        this.reportHelper = reportHelper;
    }

    public List<BankAdviceReportInfo> getRtgsDisplayList() {
        return this.rtgsDisplayList;
    }

    public void setRtgsDisplayList(List<BankAdviceReportInfo> rtgsDisplayList) {
        this.rtgsDisplayList = rtgsDisplayList;
    }

    public List<Object> getRtgsReportList() {
        return this.rtgsReportList;
    }

    public void setRtgsReportList(List<Object> rtgsReportList) {
        this.rtgsReportList = rtgsReportList;
    }

    public String getFormattedDate(java.util.Date date) {
        return Constants.DDMMYYYYFORMAT2.format(date);
    }

    public Boolean getSearchResult() {
        return this.searchResult;
    }

    public void setSearchResult(Boolean searchResult) {
        this.searchResult = searchResult;
    }
}

