/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.report;

import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.egov.commons.Bank;
import org.egov.commons.Bankaccount;
import org.egov.commons.Bankbranch;
import org.egov.egf.commons.EgovCommon;
import org.egov.egf.model.BankAdviceReportInfo;
import org.egov.egf.web.actions.report.ChequeIssueRegisterDisplay;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.reporting.util.ReportUtil;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infstr.utils.EgovMasterDataCaching;
import org.egov.model.instrument.InstrumentHeader;
import org.egov.services.instrument.InstrumentHeaderService;
import org.egov.utils.Constants;
import org.egov.utils.ReportHelper;
import org.hibernate.FlushMode;
import org.hibernate.Query;
import org.hibernate.transform.Transformers;
import org.hibernate.type.BigDecimalType;
import org.hibernate.type.LongType;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.springframework.beans.factory.annotation.Autowired;

@Results(value={@Result(name={"result"}, location="chequeIssueRegisterReport-result.jsp"), @Result(name={"PDF"}, type="stream", location="inputStream", params={"inputName", "inputStream", "contentType", "application/pdf", "contentDisposition", "no-cache;filename=ChequeIssueRegister.pdf"}), @Result(name={"XLS"}, type="stream", location="inputStream", params={"inputName", "inputStream", "contentType", "application/xls", "contentDisposition", "no-cache;filename=ChequeIssueRegister.xls"})})
@ParentPackage(value="egov")
public class ChequeIssueRegisterReportAction
extends BaseFormAction {
    private static final long serialVersionUID = -5452940328051657821L;
    private static final String MULTIPLE = "Multiple";
    String jasperpath = "/reports/templates/chequeIssueRegisterReport.jasper";
    String bankAdviceJasperPath = "/reports/templates/bankAdviceExcelReport.jasper";
    private List<ChequeIssueRegisterDisplay> chequeIssueRegisterList = new ArrayList();
    private Date fromDate;
    private Date toDate;
    private String chequeFromNumber;
    private String chequeToNumber;
    private Department department;
    private Bankaccount accountNumber;
    ReportHelper reportHelper;
    private InputStream inputStream;
    private EgovCommon egovCommon;
    @Autowired
    private AppConfigValueService appConfigValuesService;
    private String ulbName = "";
    private String bank;
    private static final Logger LOGGER = Logger.getLogger(ChequeIssueRegisterReportAction.class);
    @Autowired
    private EgovMasterDataCaching masterDataCache;
    private boolean chequePrintingEnabled;
    private String chequePrintAvailableAt;
    private boolean chequeFormatExists;
    private String chequeFormat = "";
    private Long instrumentHeaderId;
    private InstrumentHeaderService instrumentHeaderService;

    public ChequeIssueRegisterReportAction() {
        this.addRelatedEntity("executingDepartment", Department.class);
    }

    public void prepare() {
        this.persistenceService.getSession().setDefaultReadOnly(true);
        this.persistenceService.getSession().setFlushMode(FlushMode.MANUAL);
        super.prepare();
        if (!this.parameters.containsKey("showDropDown")) {
            this.addDropdownData("bankList", this.egovCommon.getBankBranchForActiveBanks());
            this.addDropdownData("bankAccountList", Collections.EMPTY_LIST);
            this.dropdownData.put("executingDepartmentList", this.masterDataCache.get("egi-department"));
        }
        this.populateUlbName();
    }

    public String execute() throws Exception {
        return "form";
    }

    public void setReportHelper(ReportHelper reportHelper) {
        this.reportHelper = reportHelper;
    }

    public void generateReport() throws JRException, IOException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"----Inside generateReport---- ");
        }
        this.accountNumber = (Bankaccount)this.persistenceService.find("from Bankaccount where id=?", new Object[]{this.accountNumber.getId()});
        if (this.accountNumber.getChequeformat() != null && !this.accountNumber.getChequeformat().equals("")) {
            this.chequeFormat = this.accountNumber.getChequeformat().getId().toString();
        }
        this.validateDates(this.fromDate, this.toDate);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Querying to date range " + this.getFormattedDate(this.fromDate) + "to date " + this.getFormattedDate(this.getNextDate(this.toDate))));
        }
        List printAvailConfig = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "chequeprintavailableat");
        this.chequePrintingEnabled = this.isChequePrintEnabled();
        for (AppConfigValues appConfigVal : printAvailConfig) {
            this.chequePrintAvailableAt = appConfigVal.getValue();
        }
        Query query = this.persistenceService.getSession().createSQLQuery("select ih.instrumentnumber as chequeNumber,ih.instrumentdate as chequeDate,ih.instrumentamount as chequeAmount,vh.vouchernumber as voucherNumber,vh.id as vhId,ih.serialno as serialNo,vh.voucherdate as voucherDate,vh.name as voucherName,ih.payto as payTo,mbd.billnumber as billNumber,mbd.billDate as billDate,vh.type as type,es.DESCRIPTION as chequeStatus,ih.id as instrumentheaderid from egf_instrumentHeader ih,egf_instrumentvoucher iv,EGW_STATUS es,voucherheader vh left outer join miscbilldetail mbd on  vh.id=mbd.PAYVHID ,vouchermis vmis where ih.instrumentDate <'" + this.getFormattedDate(this.getNextDate(this.toDate)) + "' and ih.instrumentDate>='" + this.getFormattedDate(this.fromDate) + "' and ih.isPayCheque='1' " + "and ih.INSTRUMENTTYPE=(select id from egf_instrumenttype where TYPE='cheque' ) and vh.status not in (" + this.getExcludeVoucherStatues() + ") and vh.id=iv.voucherheaderid and  bankAccountId=" + this.accountNumber.getId() + " and ih.id=iv.instrumentheaderid and ih.id_status=es.id " + " and vmis.voucherheaderid=vh.id " + this.createQuery() + " order by ih.instrumentDate,ih.instrumentNumber ").addScalar("chequeNumber").addScalar("chequeDate", (Type)StandardBasicTypes.DATE).addScalar("chequeAmount", (Type)BigDecimalType.INSTANCE).addScalar("voucherNumber").addScalar("voucherDate", (Type)StandardBasicTypes.DATE).addScalar("voucherName").addScalar("payTo").addScalar("billNumber").addScalar("billDate", (Type)StandardBasicTypes.DATE).addScalar("type").addScalar("vhId", (Type)BigDecimalType.INSTANCE).addScalar("serialNo", (Type)LongType.INSTANCE).addScalar("chequeStatus").addScalar("instrumentHeaderId", (Type)LongType.INSTANCE).setResultTransformer(Transformers.aliasToBean(ChequeIssueRegisterDisplay.class));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Search query" + query.getQueryString()));
        }
        this.chequeIssueRegisterList = query.list();
        if (this.chequeIssueRegisterList == null) {
            this.chequeIssueRegisterList = new ArrayList();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Got Cheque list| Size of list is" + this.chequeIssueRegisterList.size()));
        }
        this.updateBillNumber();
        this.updateVoucherNumber();
        this.removeDuplicates();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"--End  generateReport--");
        }
    }

    public boolean isChequePrintEnabled() {
        String chequePrintEnabled = null;
        List enablePrintConfig = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "chequeprintingenabled");
        if (enablePrintConfig != null) {
            for (AppConfigValues appConfigVal : enablePrintConfig) {
                chequePrintEnabled = appConfigVal.getValue();
            }
        }
        return chequePrintEnabled != null && chequePrintEnabled.equalsIgnoreCase("Y");
    }

    private void removeDuplicates() {
        HashMap<String, ChequeIssueRegisterDisplay> map = new HashMap<String, ChequeIssueRegisterDisplay>();
        Iterator row = this.chequeIssueRegisterList.iterator();
        while (row.hasNext()) {
            ChequeIssueRegisterDisplay next = (ChequeIssueRegisterDisplay)row.next();
            if (map.get(next.getChequeNumber() + "-" + next.getSerialNo()) == null) {
                map.put(next.getChequeNumber() + "-" + next.getSerialNo(), next);
                continue;
            }
            row.remove();
        }
    }

    String createQuery() {
        String query = "";
        if (this.department != null && this.department.getId() != 0L) {
            query = query.concat(" and vmis.departmentid=" + this.department.getId());
        }
        return query;
    }

    private void updateBillNumber() {
        HashMap<String, ChequeIssueRegisterDisplay> map = new HashMap<String, ChequeIssueRegisterDisplay>();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Inside updateBillNumber ");
        }
        for (ChequeIssueRegisterDisplay row : this.chequeIssueRegisterList) {
            if (map.get(row.getChequeNumber()) == null) {
                map.put(row.getChequeNumber(), row);
                continue;
            }
            if (row.getBillNumber() != null && row.getBillNumber().equalsIgnoreCase(((ChequeIssueRegisterDisplay)map.get(row.getChequeNumber())).getBillNumber())) continue;
            ((ChequeIssueRegisterDisplay)map.get(row.getChequeNumber())).setBillNumber("MULTIPLE");
            row.setBillNumber(MULTIPLE);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"End updateBillNumber ");
        }
    }

    private void updateVoucherNumber() {
        HashMap<String, ChequeIssueRegisterDisplay> map = new HashMap<String, ChequeIssueRegisterDisplay>();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"End updateVoucherNumber ");
        }
        for (ChequeIssueRegisterDisplay row : this.chequeIssueRegisterList) {
            if (map.get(row.getChequeNumber()) == null) {
                map.put(row.getChequeNumber(), row);
                continue;
            }
            if (row.getVoucherNumber() != null && row.getVoucherNumber().equalsIgnoreCase(((ChequeIssueRegisterDisplay)map.get(row.getChequeNumber())).getVoucherNumber()) || ((ChequeIssueRegisterDisplay)map.get(row.getChequeNumber())).getChequeStatus().equalsIgnoreCase("Surrender_For_Reassign") || ((ChequeIssueRegisterDisplay)map.get(row.getChequeNumber())).getChequeStatus().equalsIgnoreCase("Surrendered") || ((ChequeIssueRegisterDisplay)map.get(row.getChequeNumber())).getChequeStatus().equalsIgnoreCase("Cancelled") || row.getChequeStatus().equalsIgnoreCase("Surrender_For_Reassign") || row.getChequeStatus().equalsIgnoreCase("Surrendered") || row.getChequeStatus().equalsIgnoreCase("Cancelled")) continue;
            ((ChequeIssueRegisterDisplay)map.get(row.getChequeNumber())).setVoucherNumber("MULTIPLE");
            row.setVoucherNumber(MULTIPLE);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"End updateVoucherNumber ");
        }
    }

    private void validateDates(Date fromDate, Date toDate) {
        if (fromDate.compareTo(toDate) == 1) {
            throw new ValidationException(Arrays.asList(new ValidationError("invalid.from.date", "invalid.from.date")));
        }
    }

    @Action(value="/report/chequeIssueRegisterReport-generatePdf")
    public String generatePdf() throws JRException, IOException {
        this.generateReport();
        ArrayList data = new ArrayList();
        data.addAll(this.getChequeIssueRegisterList());
        this.inputStream = this.reportHelper.exportPdf(this.getInputStream(), this.jasperpath, this.getParamMap(), data);
        return "PDF";
    }

    @Action(value="/report/chequeIssueRegisterReport-generateXls")
    public String generateXls() throws JRException, IOException {
        this.generateReport();
        ArrayList data = new ArrayList();
        data.addAll(this.getChequeIssueRegisterList());
        this.inputStream = this.reportHelper.exportXls(this.getInputStream(), this.jasperpath, this.getParamMap(), data);
        return "XLS";
    }

    @Action(value="/report/chequeIssueRegisterReport-bankAdviceExcel")
    public String bankAdviceExcel() throws JRException, IOException {
        BankAdviceReportInfo bankAdvice = new BankAdviceReportInfo();
        InstrumentHeader instrumentHeader = (InstrumentHeader)this.persistenceService.find("from InstrumentHeader where id=?", new Object[]{this.instrumentHeaderId});
        bankAdvice.setPartyName(instrumentHeader.getPayTo());
        bankAdvice.setAmount(instrumentHeader.getInstrumentAmount());
        ArrayList<BankAdviceReportInfo> data = new ArrayList<BankAdviceReportInfo>();
        data.add(bankAdvice);
        this.inputStream = this.reportHelper.exportXls(this.getInputStream(), this.bankAdviceJasperPath, null, data);
        return "XLS";
    }

    @Action(value="/report/chequeIssueRegisterReport-ajaxPrint")
    public String ajaxPrint() throws JRException, IOException {
        this.generateReport();
        return "result";
    }

    public Object getModel() {
        return null;
    }

    public void setFromDate(Date fromDate) {
        this.fromDate = fromDate;
    }

    public Date getFromDate() {
        return this.fromDate;
    }

    public void setToDate(Date toDate) {
        this.toDate = toDate;
    }

    public Date getToDate() {
        return this.toDate;
    }

    public String getFormattedDate(Date date) {
        SimpleDateFormat formatter = Constants.DDMMYYYYFORMAT1;
        return formatter.format(date);
    }

    private Date getNextDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, 1);
        return calendar.getTime();
    }

    protected Map<String, Object> getParamMap() {
        this.accountNumber = (Bankaccount)this.persistenceService.find("from Bankaccount where id=?", new Object[]{this.accountNumber.getId()});
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("bank", this.getFormattedBankName());
        paramMap.put("accountNumber", this.accountNumber.getAccountnumber());
        paramMap.put("fromDate", Constants.DDMMYYYYFORMAT1.format(this.fromDate));
        paramMap.put("toDate", Constants.DDMMYYYYFORMAT1.format(this.toDate));
        paramMap.put("ulbName", this.ulbName);
        if (this.department != null && this.department.getId() != null && this.department.getId() != 0L) {
            Department dept = (Department)this.persistenceService.find("from Department where id=?", new Object[]{this.department.getId()});
            paramMap.put("departmentName", dept.getName());
        }
        return paramMap;
    }

    public String getFormattedBankName() {
        String[] bankData = this.bank.split("-");
        Bank bank = (Bank)this.persistenceService.find("from Bank where id=?", new Object[]{Integer.valueOf(bankData[0])});
        Bankbranch bankBranch = (Bankbranch)this.persistenceService.find("from Bankbranch where id=?", new Object[]{Integer.valueOf(bankData[1])});
        String name = "";
        if (bank != null && bankBranch != null) {
            name = bank.getName().concat(" - ").concat(bankBranch.getBranchname());
        }
        return name;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public List<ChequeIssueRegisterDisplay> getChequeIssueRegisterList() {
        return this.chequeIssueRegisterList;
    }

    public void setChequeIssueRegisterList(List<ChequeIssueRegisterDisplay> chequeIssueRegisterList) {
        this.chequeIssueRegisterList = chequeIssueRegisterList;
    }

    public void setAccountNumber(Bankaccount bankAccount) {
        this.accountNumber = bankAccount;
    }

    public Bankaccount getAccountNumber() {
        return this.accountNumber;
    }

    public void setEgovCommon(EgovCommon egovCommon) {
        this.egovCommon = egovCommon;
    }

    private String getExcludeVoucherStatues() {
        List appList = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "statusexcludeReport");
        String statusExclude = "-1";
        statusExclude = ((AppConfigValues)appList.get(0)).getValue();
        return statusExclude;
    }

    private void populateUlbName() {
        this.setUlbName(ReportUtil.getCityName());
    }

    public void setUlbName(String ulbName) {
        this.ulbName = ulbName;
    }

    public String getUlbName() {
        return this.ulbName;
    }

    public void setBank(String bank) {
        this.bank = bank;
    }

    public String getBank() {
        return this.bank;
    }

    public void setDepartment(Department department) {
        this.department = department;
    }

    public Department getDepartment() {
        return this.department;
    }

    public void setChequeToNumber(String chequeToNumber) {
        this.chequeToNumber = chequeToNumber;
    }

    public String getChequeToNumber() {
        return this.chequeToNumber;
    }

    public void setChequeFromNumber(String chequeFromNumber) {
        this.chequeFromNumber = chequeFromNumber;
    }

    public String getChequeFromNumber() {
        return this.chequeFromNumber;
    }

    public AppConfigValueService getAppConfigValuesService() {
        return this.appConfigValuesService;
    }

    public void setAppConfigValuesService(AppConfigValueService appConfigValuesService) {
        this.appConfigValuesService = appConfigValuesService;
    }

    public boolean isChequePrintingEnabled() {
        return this.chequePrintingEnabled;
    }

    public String getChequePrintAvailableAt() {
        return this.chequePrintAvailableAt;
    }

    public boolean isChequeFormatExists() {
        return this.chequeFormatExists;
    }

    public void setChequePrintingEnabled(boolean chequePrintingEnabled) {
        this.chequePrintingEnabled = chequePrintingEnabled;
    }

    public void setChequePrintAvailableAt(String chequePrintAvailableAt) {
        this.chequePrintAvailableAt = chequePrintAvailableAt;
    }

    public void setChequeFormatExists(boolean chequeFormatExists) {
        this.chequeFormatExists = chequeFormatExists;
    }

    public String getChequeFormat() {
        return this.chequeFormat;
    }

    public void setChequeFormat(String chequeFormat) {
        this.chequeFormat = chequeFormat;
    }

    public Long getInstrumentHeaderId() {
        return this.instrumentHeaderId;
    }

    public void setInstrumentHeaderId(Long instrumentHeaderId) {
        this.instrumentHeaderId = instrumentHeaderId;
    }
}

