/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.report;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.commons.CFinancialYear;
import org.egov.commons.CFunction;
import org.egov.commons.Functionary;
import org.egov.commons.Fund;
import org.egov.commons.Fundsource;
import org.egov.commons.Scheme;
import org.egov.commons.SubScheme;
import org.egov.commons.Vouchermis;
import org.egov.commons.dao.FinancialYearHibernateDAO;
import org.egov.egf.commons.EgovCommon;
import org.egov.egf.model.BudgetVarianceEntry;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.reporting.engine.ReportConstants;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.infstr.services.PersistenceService;
import org.egov.model.budget.BudgetDetail;
import org.egov.model.budget.BudgetGroup;
import org.egov.model.payment.Paymentheader;
import org.egov.services.budget.BudgetDetailService;
import org.egov.services.budget.BudgetService;
import org.egov.utils.BudgetAccountType;
import org.egov.utils.BudgetDetailConfig;
import org.egov.utils.Constants;
import org.hibernate.FlushMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@Results(value={@Result(name={"results"}, location="budgetVarianceReport-results.jsp"), @Result(name={"form"}, location="budgetVarianceReport-form.jsp"), @Result(name={"PDF"}, type="stream", location="inputStream", params={"inputName", "inputStream", "contentType", "application/pdf", "contentDisposition", "no-cache;filename=BudgetVarianceReport.pdf"}), @Result(name={"XLS"}, type="stream", location="inputStream", params={"inputName", "inputStream", "contentType", "application/xls", "contentDisposition", "no-cache;filename=BudgetVarianceReport.xls"})})
@ParentPackage(value="egov")
public class BudgetVarianceReportAction
extends BaseFormAction {
    private static final long serialVersionUID = -9048247816556335427L;
    String jasperpath = "budgetVarianceReport";
    List<Paymentheader> paymentHeaderList = new ArrayList();
    private List<BudgetVarianceEntry> budgetVarianceEntries = new ArrayList();
    private Date asOnDate = new Date();
    private InputStream inputStream;
    private EgovCommon egovCommon;
    protected List<String> headerFields = new ArrayList();
    protected List<String> mandatoryFields = new ArrayList();
    private Vouchermis vouchermis = new Vouchermis();
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    @Autowired
    AppConfigValueService appConfigValuesService;
    private ReportService reportService;
    private final List<String> accountTypeList = new ArrayList();
    private String accountType = "";
    private BudgetDetail budgetDetail = new BudgetDetail();
    @Autowired
    private BudgetDetailConfig budgetDetailConfig;
    protected List<String> gridFields = new ArrayList();
    protected BudgetDetailService budgetDetailService;
    private FinancialYearHibernateDAO financialYearDAO;
    private String type = "Budget";
    private BudgetService budgetService;
    String budgetType = "BE";
    private final Map<String, Integer> queryParamMap = new HashMap();
    private Department department = new Department();
    private CFunction function = new CFunction();
    private Fund fund = new Fund();

    @ValidationErrorPage(value="form")
    @SkipValidation
    public String execute() throws Exception {
        return "form";
    }

    public void prepare() {
        this.headerFields = this.budgetDetailConfig.getHeaderFields();
        this.gridFields = this.budgetDetailConfig.getGridFields();
        this.mandatoryFields = this.budgetDetailConfig.getMandatoryFields();
        if (this.isFieldMandatory("executingDepartment")) {
            this.addRelatedEntity("executingDepartment", Department.class);
        }
        if (this.isFieldMandatory("fund")) {
            this.addRelatedEntity("fund", Fund.class);
        }
        if (this.isFieldMandatory("function")) {
            this.addRelatedEntity("function", CFunction.class);
        }
        if (this.isFieldMandatory("scheme")) {
            this.addRelatedEntity("scheme", Scheme.class);
        }
        if (this.isFieldMandatory("subscheme")) {
            this.addRelatedEntity("subscheme", SubScheme.class);
        }
        if (this.isFieldMandatory("functionary")) {
            this.addRelatedEntity("functionary", Functionary.class);
        }
        if (this.isFieldMandatory("fundsource")) {
            this.addRelatedEntity("fundsource", Fundsource.class);
        }
        if (this.isFieldMandatory("boundary")) {
            this.addRelatedEntity("boundary", Boundary.class);
        }
        this.addRelatedEntity("budgetGroup", BudgetGroup.class);
        super.prepare();
        this.persistenceService.getSession().setDefaultReadOnly(true);
        this.persistenceService.getSession().setFlushMode(FlushMode.MANUAL);
        this.mandatoryFields = this.budgetDetailConfig.getMandatoryFields();
        if (!this.parameters.containsKey("skipPrepare")) {
            this.accountTypeList.add(BudgetAccountType.REVENUE_EXPENDITURE.name());
            this.accountTypeList.add(BudgetAccountType.REVENUE_RECEIPTS.name());
            this.accountTypeList.add(BudgetAccountType.CAPITAL_EXPENDITURE.name());
            this.accountTypeList.add(BudgetAccountType.CAPITAL_RECEIPTS.name());
            this.addDropdownData("accountTypeList", this.accountTypeList);
            this.dropdownData.put("budgetGroupList", this.persistenceService.findAllBy("from BudgetGroup where isActive=true order by name", new Object[0]));
            if (this.isFieldMandatory("executingDepartment")) {
                this.addDropdownData("departmentList", this.persistenceService.findAllBy("from Department order by name", new Object[0]));
            }
            if (this.isFieldMandatory("function")) {
                this.addDropdownData("functionList", this.persistenceService.findAllBy("from CFunction where isactive=true and isnotleaf=false  order by name", new Object[0]));
            }
            if (this.isFieldMandatory("functionary")) {
                this.addDropdownData("functionaryList", this.persistenceService.findAllBy(" from Functionary where isactive=true order by name", new Object[0]));
            }
            if (this.isFieldMandatory("fund")) {
                this.addDropdownData("fundList", this.persistenceService.findAllBy(" from Fund where isactive=true and isnotleaf=false order by name", new Object[0]));
            }
            if (this.isFieldMandatory("field")) {
                this.addDropdownData("fieldList", this.persistenceService.findAllBy(" from Boundary b where lower(b.boundaryType.name)='ward' ", new Object[0]));
            }
            if (this.isFieldMandatory("scheme")) {
                this.addDropdownData("schemeList", Collections.EMPTY_LIST);
            }
            if (this.isFieldMandatory("subscheme")) {
                this.addDropdownData("subschemeList", Collections.EMPTY_LIST);
            }
        }
    }

    @ValidationErrorPage(value="form")
    @SkipValidation
    @Action(value="/report/budgetVarianceReport-loadData")
    public String loadData() {
        this.populateData();
        return "form";
    }

    public boolean shouldShowHeaderField(String fieldName) {
        return (this.headerFields.contains(fieldName) || this.gridFields.contains(fieldName)) && this.mandatoryFields.contains(fieldName);
    }

    Date parseDate(String stringDate) {
        if (this.parameters.containsKey(stringDate) && ((String[])this.parameters.get(stringDate))[0] != null) {
            try {
                return Constants.DDMMYYYYFORMAT2.parse(((String[])this.parameters.get(stringDate))[0]);
            }
            catch (ParseException e) {
                throw new ValidationException("Invalid date", "Invalid date", new String[0]);
            }
        }
        return new Date();
    }

    private StringBuffer formMiscQuery(String mis, String gl, String detail) {
        StringBuffer miscQuery = new StringBuffer();
        if (this.shouldShowHeaderField("fund") && this.queryParamMap.containsKey("fundId")) {
            miscQuery = miscQuery.append(" and " + detail + ".fundId=bd.fund ");
            miscQuery = miscQuery.append(" and bd.fund= " + this.queryParamMap.get("fundId"));
        }
        if (this.shouldShowHeaderField("scheme") && this.queryParamMap.containsKey("schemeId")) {
            miscQuery = miscQuery.append(" and " + mis + ".schemeid=bd.scheme ");
            miscQuery = miscQuery.append(" and bd.scheme= " + this.queryParamMap.get("schemeId"));
        }
        if (this.shouldShowHeaderField("subScheme") && this.queryParamMap.containsKey("subSchemeId")) {
            miscQuery = miscQuery.append(" and " + mis + ".subschemeid=bd.subscheme ");
            miscQuery = miscQuery.append(" and bd.subscheme= " + this.queryParamMap.get("subSchemeId"));
        }
        if (this.shouldShowHeaderField("functionary") && this.queryParamMap.containsKey("functionaryId")) {
            miscQuery = miscQuery.append(" and " + mis + ".functionaryid=bd.functionary ");
            miscQuery = miscQuery.append(" and bd.functionary= " + this.queryParamMap.get("functionaryId"));
        }
        if (this.shouldShowHeaderField("function") && this.queryParamMap.containsKey("functionId")) {
            miscQuery = miscQuery.append(" and " + gl + ".functionId=bd.function ");
            miscQuery = miscQuery.append(" and bd.function= " + Long.parseLong(((Integer)this.queryParamMap.get("functionId")).toString()));
        }
        if (this.shouldShowHeaderField("executingDepartment") && this.queryParamMap.containsKey("deptId")) {
            miscQuery = miscQuery.append(" and " + mis + ".departmentid=bd.executing_department ");
            miscQuery = miscQuery.append(" and bd.executing_department= " + this.queryParamMap.get("deptId"));
        }
        return miscQuery;
    }

    public List<Paymentheader> getPaymentHeaderList() {
        return this.paymentHeaderList;
    }

    public void setAsOnDate(Date startDate) {
        this.asOnDate = startDate;
    }

    public Date getAsOnDate() {
        return this.asOnDate;
    }

    public String getFormattedDate(Date date) {
        return Constants.DDMMYYYYFORMAT2.format(date);
    }

    @SkipValidation
    @Action(value="/report/budgetVarianceReport-exportPdf")
    public String exportPdf() throws JRException, IOException {
        this.generateReport();
        return "PDF";
    }

    private void generateReport() {
        this.populateData();
        ReportRequest reportInput = new ReportRequest(this.jasperpath, (Collection)this.budgetVarianceEntries, this.getParamMap());
        ReportOutput reportOutput = this.reportService.createReport(reportInput);
        this.inputStream = new ByteArrayInputStream(reportOutput.getReportOutputData());
    }

    Map<String, Object> getParamMap() {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("departmentName", this.getDepartmentName());
        String estimateHeading = "";
        estimateHeading = "BE".equalsIgnoreCase(this.budgetType) ? "Budget Estimate" : "Revised Estimate";
        paramMap.put("estimateHeading", estimateHeading);
        paramMap.put("asOnDate", Constants.DDMMYYYYFORMAT2.format(this.asOnDate));
        return paramMap;
    }

    private void populateData() {
        CFinancialYear financialYear = this.financialYearDAO.getFinancialYearByDate(this.asOnDate);
        boolean hasApprovedReForYear = this.budgetService.hasApprovedReForYear(financialYear.getId());
        if (hasApprovedReForYear) {
            this.type = "Revised";
            this.budgetType = "RE";
        }
        List result = this.persistenceService.findAllBy("from BudgetDetail where budget.isbere='" + this.budgetType + "' and " + "budget.isActiveBudget=true and budget.status.code='Approved' and budget.financialYear.id=" + financialYear.getId() + this.getMiscQuery() + " order by budget.name,budgetGroup.name", new Object[0]);
        if (this.budgetVarianceEntries == null) {
            this.budgetVarianceEntries = new ArrayList();
        }
        for (BudgetDetail budgetDetail : result) {
            BudgetVarianceEntry budgetVarianceEntry = new BudgetVarianceEntry();
            budgetVarianceEntry.setBudgetHead(budgetDetail.getBudgetGroup().getName());
            if (budgetDetail.getExecutingDepartment() != null) {
                budgetVarianceEntry.setDepartmentCode(budgetDetail.getExecutingDepartment().getCode());
                budgetVarianceEntry.setDepartmentName(budgetDetail.getExecutingDepartment().getName());
            }
            if (budgetDetail.getFund() != null) {
                budgetVarianceEntry.setFundCode(budgetDetail.getFund().getName());
            }
            if (budgetDetail.getFunction() != null) {
                budgetVarianceEntry.setFunctionCode(budgetDetail.getFunction().getName());
            }
            budgetVarianceEntry.setDetailId(budgetDetail.getId());
            budgetVarianceEntry.setBudgetCode(budgetDetail.getBudget().getName());
            if ("RE".equalsIgnoreCase(this.budgetType) && !this.getConsiderReAppropriationAsSeperate()) {
                budgetVarianceEntry.setAdditionalAppropriation(BigDecimal.ZERO);
                BigDecimal estimateAmount = (budgetDetail.getApprovedAmount() == null ? BigDecimal.ZERO : budgetDetail.getApprovedAmount()).add(budgetDetail.getApprovedReAppropriationsTotal() == null ? BigDecimal.ZERO : budgetDetail.getApprovedReAppropriationsTotal());
                budgetVarianceEntry.setEstimate(estimateAmount);
            } else {
                budgetVarianceEntry.setEstimate(budgetDetail.getApprovedAmount() == null ? BigDecimal.ZERO : budgetDetail.getApprovedAmount());
                budgetVarianceEntry.setAdditionalAppropriation(budgetDetail.getApprovedReAppropriationsTotal() == null ? BigDecimal.ZERO : budgetDetail.getApprovedReAppropriationsTotal());
            }
            budgetVarianceEntry.setTotal(budgetVarianceEntry.getEstimate().add(budgetVarianceEntry.getAdditionalAppropriation()));
            this.budgetVarianceEntries.add(budgetVarianceEntry);
        }
        this.populateActualData(financialYear);
    }

    private String getMiscQuery() {
        StringBuilder query = new StringBuilder();
        if (this.budgetDetail.getExecutingDepartment() != null && this.budgetDetail.getExecutingDepartment().getId() != null && this.budgetDetail.getExecutingDepartment().getId() != -1L) {
            query.append(" and executingDepartment.id=").append(this.budgetDetail.getExecutingDepartment().getId());
        }
        if (this.budgetDetail.getBudgetGroup() != null && this.budgetDetail.getBudgetGroup().getId() != null && this.budgetDetail.getBudgetGroup().getId() != -1L) {
            query.append(" and budgetGroup.id=").append(this.budgetDetail.getBudgetGroup().getId());
        }
        if (this.budgetDetail.getFunction() != null && this.budgetDetail.getFunction().getId() != null && this.budgetDetail.getFunction().getId() != -1L) {
            query.append(" and function.id=").append(this.budgetDetail.getFunction().getId());
        }
        if (this.budgetDetail.getFund() != null && this.budgetDetail.getFund().getId() != null && this.budgetDetail.getFund().getId() != -1) {
            query.append(" and fund.id=").append(this.budgetDetail.getFund().getId());
        }
        if (this.budgetDetail.getFunctionary() != null && this.budgetDetail.getFunctionary().getId() != null && this.budgetDetail.getFunctionary().getId() != -1) {
            query.append(" and functionary.id=").append(this.budgetDetail.getFunctionary().getId());
        }
        if (this.budgetDetail.getScheme() != null && this.budgetDetail.getScheme().getId() != null && this.budgetDetail.getScheme().getId() != -1) {
            query.append(" and scheme.id=").append(this.budgetDetail.getScheme().getId());
        }
        if (this.budgetDetail.getSubScheme() != null && this.budgetDetail.getSubScheme().getId() != null && this.budgetDetail.getSubScheme().getId() != -1) {
            query.append(" and subScheme.id=").append(this.budgetDetail.getSubScheme().getId());
        }
        if (this.budgetDetail.getBoundary() != null && this.budgetDetail.getBoundary().getId() != null && this.budgetDetail.getBoundary().getId() != -1L) {
            query.append(" and boundary.id=").append(this.budgetDetail.getBoundary().getId());
        }
        if (!"".equalsIgnoreCase(this.accountType) && !"-1".equalsIgnoreCase(this.accountType)) {
            query.append(" and budgetGroup.accountType='").append(this.accountType).append("'");
        }
        return query.toString();
    }

    private void setQueryParams() {
        if (this.shouldShowHeaderField("executingDepartment") && this.budgetDetail.getExecutingDepartment() != null && this.budgetDetail.getExecutingDepartment().getId() != null && this.budgetDetail.getExecutingDepartment().getId() != -1L && this.budgetDetail.getExecutingDepartment().getId() != 0L) {
            this.queryParamMap.put("deptId", this.budgetDetail.getExecutingDepartment().getId().intValue());
        }
        if (this.shouldShowHeaderField("function") && this.budgetDetail.getFunction() != null && this.budgetDetail.getFunction().getId() != null && this.budgetDetail.getFunction().getId() != -1L && this.budgetDetail.getFunction().getId() != 0L) {
            this.queryParamMap.put("functionId", Integer.parseInt(this.budgetDetail.getFunction().getId().toString()));
        }
        if (this.shouldShowHeaderField("fund") && this.budgetDetail.getFund() != null && this.budgetDetail.getFund().getId() != null && this.budgetDetail.getFund().getId() != -1 && this.budgetDetail.getFund().getId() != 0) {
            this.queryParamMap.put("fundId", this.budgetDetail.getFund().getId());
        }
        if (this.shouldShowHeaderField("scheme") && this.budgetDetail.getScheme() != null && this.budgetDetail.getScheme().getId() != null && this.budgetDetail.getScheme().getId() != -1 && this.budgetDetail.getScheme().getId() != 0) {
            this.queryParamMap.put("schemeId", this.budgetDetail.getScheme().getId());
        }
        if (this.shouldShowHeaderField("subscheme") && this.budgetDetail.getSubScheme() != null && this.budgetDetail.getSubScheme().getId() != null && this.budgetDetail.getSubScheme().getId() != -1 && this.budgetDetail.getSubScheme().getId() != 0) {
            this.queryParamMap.put("subSchemeId", this.budgetDetail.getSubScheme().getId());
        }
        if (this.shouldShowHeaderField("functionary") && this.budgetDetail.getFunctionary() != null && this.budgetDetail.getFunctionary().getId() != null && this.budgetDetail.getFunctionary().getId() != -1 && this.budgetDetail.getFunctionary().getId() != 0) {
            this.queryParamMap.put("functionaryId", this.budgetDetail.getFunctionary().getId());
        }
    }

    private void populateActualData(CFinancialYear financialYear) {
        String fromDate = Constants.DDMMYYYYFORMAT2.format(financialYear.getStartingDate());
        if (this.budgetVarianceEntries != null && this.budgetVarianceEntries.size() != 0) {
            this.setQueryParams();
            List resultForVoucher = this.budgetDetailService.fetchActualsForFYWithParams(fromDate, "'" + Constants.DDMMYYYYFORMAT2.format(this.asOnDate) + "'", this.formMiscQuery("vmis", "gl", "vh"));
            this.extractData(resultForVoucher);
            List resultForBill = this.budgetDetailService.fetchActualsForBillWithVouchersParams(fromDate, "'" + Constants.DDMMYYYYFORMAT2.format(this.asOnDate) + "'", this.formMiscQuery("bmis", "bdetail", "bmis"));
            this.extractData(resultForBill);
        } else {
            this.addActionError("no data found");
        }
    }

    private void extractData(List<Object[]> result) {
        HashMap<String, String> budgetDetailIdsAndAmount = new HashMap<String, String>();
        if (result == null) {
            return;
        }
        for (Object[] objectArray : result) {
            if (objectArray[0] == null || objectArray[1] == null) continue;
            budgetDetailIdsAndAmount.put(objectArray[0].toString(), objectArray[1].toString());
        }
        for (BudgetVarianceEntry budgetVarianceEntry : this.budgetVarianceEntries) {
            BigDecimal actual = budgetVarianceEntry.getActual();
            if (budgetDetailIdsAndAmount.get(budgetVarianceEntry.getDetailId().toString()) != null) {
                if (actual == null || BigDecimal.ZERO.compareTo(actual) == 0) {
                    budgetVarianceEntry.setActual(new BigDecimal((String)budgetDetailIdsAndAmount.get(budgetVarianceEntry.getDetailId().toString())));
                } else {
                    budgetVarianceEntry.setActual(budgetVarianceEntry.getActual().add(new BigDecimal((String)budgetDetailIdsAndAmount.get(budgetVarianceEntry.getDetailId().toString()))));
                }
            } else if (actual == null) {
                budgetVarianceEntry.setActual(BigDecimal.ZERO);
            }
            budgetVarianceEntry.setVariance(budgetVarianceEntry.getEstimate().add(budgetVarianceEntry.getAdditionalAppropriation().subtract(budgetVarianceEntry.getActual() == null ? BigDecimal.ZERO : budgetVarianceEntry.getActual())));
        }
    }

    @SkipValidation
    @Action(value="/report/budgetVarianceReport-exportXls")
    public String exportXls() throws JRException, IOException {
        this.populateData();
        ReportRequest reportInput = new ReportRequest(this.jasperpath, (Collection)this.budgetVarianceEntries, this.getParamMap());
        reportInput.setReportFormat(ReportConstants.FileFormat.XLS);
        ReportOutput reportOutput = this.reportService.createReport(reportInput);
        this.inputStream = new ByteArrayInputStream(reportOutput.getReportOutputData());
        return "XLS";
    }

    protected void checkMandatoryField(String objectName, String fieldName, Object value, String errorKey) {
        if (this.mandatoryFields.contains(fieldName) && (value == null || value.equals(-1) || value.equals(0))) {
            this.addFieldError(objectName, this.getText(errorKey));
        }
    }

    public void validate() {
        this.checkMandatoryField("fund", "fund", (Object)(this.budgetDetail.getFund() == null ? Integer.parseInt("0") : this.budgetDetail.getFund().getId()), "voucher.fund.mandatory");
        this.checkMandatoryField("executingDepartment", "executingDepartment", (Object)(this.budgetDetail.getExecutingDepartment() == null ? (long)Integer.parseInt("0") : this.budgetDetail.getExecutingDepartment().getId()), "voucher.department.mandatory");
        this.checkMandatoryField("scheme", "scheme", (Object)(this.budgetDetail.getScheme() == null ? Integer.parseInt("0") : this.budgetDetail.getScheme().getId()), "voucher.scheme.mandatory");
        this.checkMandatoryField("subScheme", "subscheme", (Object)(this.budgetDetail.getSubScheme() == null ? Integer.parseInt("0") : this.budgetDetail.getSubScheme().getId()), "voucher.subscheme.mandatory");
        this.checkMandatoryField("function", "function", (Object)(this.budgetDetail.getFunction() == null ? (long)Integer.parseInt("0") : this.budgetDetail.getFunction().getId()), "budget.function.mandatory");
        this.checkMandatoryField("functionary", "functionary", (Object)(this.budgetDetail.getFunctionary() == null ? Integer.parseInt("0") : this.budgetDetail.getFunctionary().getId()), "voucher.functionary.mandatory");
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setEgovCommon(EgovCommon egovCommon) {
        this.egovCommon = egovCommon;
    }

    public EgovCommon getEgovCommon() {
        return this.egovCommon;
    }

    public void setBudgetVarianceEntries(List<BudgetVarianceEntry> bankBookViewEntries) {
        this.budgetVarianceEntries = bankBookViewEntries;
    }

    public List<BudgetVarianceEntry> getBudgetVarianceEntries() {
        return this.budgetVarianceEntries;
    }

    public Vouchermis getVouchermis() {
        return this.vouchermis;
    }

    public Object getModel() {
        return this.budgetDetail;
    }

    public void setVouchermis(Vouchermis vouchermis) {
        this.vouchermis = vouchermis;
    }

    public List<String> getAccountTypeList() {
        return this.accountTypeList;
    }

    public void setBudgetDetail(BudgetDetail budgetDetail) {
        this.budgetDetail = budgetDetail;
    }

    public BudgetDetail getBudgetDetail() {
        return this.budgetDetail;
    }

    public void setAccountType(String accountType) {
        this.accountType = accountType;
    }

    public String getAccountType() {
        return this.accountType;
    }

    public void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    public void setBudgetDetailService(BudgetDetailService budgetDetailService) {
        this.budgetDetailService = budgetDetailService;
    }

    public void setFinancialYearDAO(FinancialYearHibernateDAO financialYearDAO) {
        this.financialYearDAO = financialYearDAO;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public void setBudgetService(BudgetService budgetService) {
        this.budgetService = budgetService;
    }

    public boolean isFieldMandatory(String field) {
        return this.mandatoryFields.contains(field);
    }

    public String getDepartmentName() {
        if (this.budgetDetail.getExecutingDepartment() != null && this.budgetDetail.getExecutingDepartment().getId() != null && this.budgetDetail.getExecutingDepartment().getId() != -1L) {
            Department department = (Department)this.persistenceService.find("from Department where id=?", new Object[]{this.budgetDetail.getExecutingDepartment().getId()});
            return department.getName();
        }
        return "";
    }

    private boolean getConsiderReAppropriationAsSeperate() {
        List appList = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "CONSIDER_RE_REAPPROPRIATION_AS_SEPARATE");
        String appValue = "-1";
        appValue = ((AppConfigValues)appList.get(0)).getValue();
        return "Y".equalsIgnoreCase(appValue);
    }

    public Department getDepartment() {
        return this.department;
    }

    public void setDepartment(Department department) {
        this.department = department;
    }

    public CFunction getFunction() {
        return this.function;
    }

    public void setFunction(CFunction function) {
        this.function = function;
    }

    public Fund getFund() {
        return this.fund;
    }

    public void setFund(Fund fund) {
        this.fund = fund;
    }
}

