/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.report;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.util.ValueStack;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JasperPrint;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.egov.commons.CFinancialYear;
import org.egov.commons.dao.FinancialYearDAO;
import org.egov.egf.model.BudgetReportView;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.infstr.services.PersistenceService;
import org.egov.infstr.utils.EgovMasterDataCaching;
import org.egov.model.budget.Budget;
import org.egov.model.budget.BudgetDetail;
import org.egov.model.budget.BudgetGroup;
import org.egov.services.budget.BudgetDetailService;
import org.egov.services.budget.BudgetService;
import org.egov.utils.BudgetDetailHelper;
import org.egov.utils.ReportHelper;
import org.hibernate.FlushMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@Results(value={@Result(name={"PDF"}, type="stream", location="inputStream", params={"inputName", "inputStream", "contentType", "application/pdf", "contentDisposition", "no-cache;filename=BudgetReport.pdf"}), @Result(name={"XLS"}, type="stream", location="inputStream", params={"inputName", "inputStream", "contentType", "application/xls", "contentDisposition", "no-cache;filename=BudgetReport.xls"})})
@ParentPackage(value="egov")
public class BudgetReportAction
extends BaseFormAction {
    private static final long serialVersionUID = -4750341307051187L;
    ReportHelper reportHelper;
    private BudgetDetail budgetDetail = new BudgetDetail();
    private List<BudgetReportView> budgetDetailsList = new ArrayList();
    private BudgetDetailService budgetDetailService;
    private List<Budget> budgetList = new ArrayList();
    FinancialYearDAO financialYearDAO;
    private boolean canViewREApprovedAmount = false;
    private boolean canViewBEApprovedAmount = false;
    private BudgetService budgetService;
    BudgetDetailHelper budgetDetailHelper;
    private InputStream inputStream;
    private boolean showResults = false;
    private String currentYearRange = "";
    private String nextYearRange = "";
    private String lastYearRange = "";
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    @Autowired
    private EgovMasterDataCaching masterDataCache;

    public void setFinancialYearDAO(FinancialYearDAO financialYearDAO) {
        this.financialYearDAO = financialYearDAO;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public void setReportHelper(ReportHelper reportHelper) {
        this.reportHelper = reportHelper;
    }

    public void setBudgetDetailHelper(BudgetDetailHelper budgetHelper) {
        this.budgetDetailHelper = budgetHelper;
    }

    public BudgetReportAction() {
        this.addRelatedEntity("budgetGroup", BudgetGroup.class);
        this.addRelatedEntity("executingDepartment", Department.class);
        this.addRelatedEntity("budget", Budget.class);
    }

    public void prepare() {
        this.persistenceService.getSession().setDefaultReadOnly(true);
        this.persistenceService.getSession().setFlushMode(FlushMode.MANUAL);
        super.prepare();
        this.setupDropdownsInHeader();
    }

    public String execute() throws Exception {
        return "form";
    }

    @Action(value="/report/budgetReport-ajaxLoadBudgets")
    public String ajaxLoadBudgets() {
        String isbere = this.budgetDetail.getBudget().getIsbere();
        if (this.budgetDetail.getBudget() != null && this.budgetDetail.getBudget().getFinancialYear() != null && isbere != null) {
            Long finYearId = this.budgetDetail.getBudget().getFinancialYear().getId();
            this.setBudgetList(this.getPersistenceService().findAllBy("from Budget where isbere=? and financialYear.id=? and isPrimaryBudget=1 and isActiveBudget=1 and id not in (select parent from Budget where parent is not null and isbere=? and financialYear.id=? and isPrimaryBudget=1) order by name", new Object[]{isbere, finYearId, isbere, finYearId}));
        }
        return "budgets";
    }

    private void setupDropdownsInHeader() {
        this.setupDropdownDataExcluding(new String[]{"subScheme"});
        this.dropdownData.put("budgetGroupList", this.masterDataCache.get("egf-budgetGroup"));
        this.dropdownData.put("executingDepartmentList", this.masterDataCache.get("egi-department"));
        this.addDropdownData("financialYearList", this.budgetService.getFYForNonApprovedBudgets());
        ArrayList<String> isbereList = new ArrayList<String>();
        isbereList.add("BE");
        isbereList.add("RE");
        this.dropdownData.put("isbereList", isbereList);
    }

    public boolean canViewApprovedAmount(Budget budget) {
        return this.budgetDetailService.canViewApprovedAmount(this.persistenceService, budget);
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    private Date getNextYearFor(Date date) {
        GregorianCalendar previousYearToDate = new GregorianCalendar();
        previousYearToDate.setTime(date);
        int prevYear = previousYearToDate.get(1) + 1;
        previousYearToDate.set(1, prevYear);
        return previousYearToDate.getTime();
    }

    public String exportXls() throws Exception {
        this.generateReport();
        JasperPrint jasper = this.reportHelper.generateBudgetReportJasperPrint(this.budgetDetailsList, this.getParamMap().get("heading").toString(), this.canViewBEApprovedAmount, this.canViewREApprovedAmount, this.lastYearRange, this.currentYearRange, this.nextYearRange);
        this.inputStream = this.reportHelper.exportXls(this.inputStream, jasper);
        return "XLS";
    }

    Map<String, Object> getParamMap() {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        String budgetName = "";
        if (this.budgetDetail.getBudget() != null) {
            budgetName = this.budgetDetail.getBudget().getName();
        }
        paramMap.put("heading", "Budget Report For " + budgetName);
        paramMap.put("enableReApproved", this.canViewREApprovedAmount);
        paramMap.put("enableBeApproved", this.canViewBEApprovedAmount);
        return paramMap;
    }

    public String exportPdf() throws Exception {
        this.generateReport();
        JasperPrint jasper = this.reportHelper.generateBudgetReportJasperPrint(this.budgetDetailsList, this.getParamMap().get("heading").toString(), this.canViewBEApprovedAmount, this.canViewREApprovedAmount, this.lastYearRange, this.currentYearRange, this.nextYearRange);
        this.inputStream = this.reportHelper.exportPdf(this.inputStream, jasper);
        return "PDF";
    }

    @ValidationErrorPage(value="form")
    public String generateReport() {
        this.showResults = true;
        CFinancialYear finYear = ((Budget)this.budgetService.find("from Budget where id=?", new Object[]{this.budgetDetail.getBudget().getId()})).getFinancialYear();
        List currentYearBeList = new ArrayList();
        List nextYearBeList = new ArrayList();
        List lastYearBe = new ArrayList();
        List lastYearRe = new ArrayList();
        Budget b = (Budget)this.budgetService.findById((Serializable)this.budgetDetail.getBudget().getId(), false);
        if ("BE".equalsIgnoreCase(b.getIsbere())) {
            CFinancialYear previousYear = this.budgetDetailHelper.getPreviousYearFor(finYear);
            if (previousYear != null) {
                lastYearBe = this.budgetDetailService.findAllBy("from BudgetDetail where budget.financialYear.id=? and budget.isPrimaryBudget=1 and budget.isActiveBudget=1 and budget.isbere='BE'", new Object[]{previousYear.getId()});
                lastYearRe = this.budgetDetailService.findAllBy("from BudgetDetail where budget.financialYear.id=? and budget.isPrimaryBudget=1 and budget.isActiveBudget=1 and budget.isbere='RE'", new Object[]{previousYear.getId()});
            }
        } else {
            nextYearBeList = this.populateNextYearBe(finYear);
        }
        List results = this.budgetDetailService.findAllBudgetDetailsForParent(this.budgetDetail.getBudget(), this.budgetDetail, this.persistenceService);
        for (BudgetDetail detail : results) {
            BudgetReportView view = new BudgetReportView();
            view.setId(detail.getId());
            view.setDepartmentCode(detail.getExecutingDepartment().getCode());
            view.setFunctionCode(detail.getFunction().getCode());
            view.setBudgetGroupName(detail.getBudgetGroup().getName());
            if ("BE".equalsIgnoreCase(detail.getBudget().getIsbere())) {
                view.setBeNextYearApproved(detail.getApprovedAmount());
                view.setBeNextYearOriginal(detail.getOriginalAmount());
                for (BudgetDetail budgetDetail : lastYearBe) {
                    if (!this.compareDetails(budgetDetail, detail)) continue;
                    view.setBeCurrentYearApproved(budgetDetail.getApprovedAmount());
                }
                for (BudgetDetail budgetDetail : lastYearRe) {
                    if (!this.compareDetails(budgetDetail, detail)) continue;
                    view.setReCurrentYearApproved(budgetDetail.getApprovedAmount());
                    view.setReCurrentYearOriginal(budgetDetail.getOriginalAmount());
                }
            } else {
                view.setReCurrentYearApproved(detail.getApprovedAmount());
                view.setReCurrentYearOriginal(detail.getOriginalAmount());
                currentYearBeList = this.populateCurrentYearBe();
                for (BudgetDetail budgetDetail : currentYearBeList) {
                    if (!this.compareDetails(budgetDetail, detail)) continue;
                    view.setBeCurrentYearApproved(budgetDetail.getApprovedAmount());
                }
            }
            for (BudgetDetail nextYear : nextYearBeList) {
                if (!this.compareDetails(nextYear, detail)) continue;
                view.setBeNextYearApproved(nextYear.getApprovedAmount());
                view.setBeNextYearOriginal(nextYear.getOriginalAmount());
            }
            this.budgetDetailsList.add(view);
        }
        this.populatePreviousYearActuals(results, this.budgetDetail.getBudget().getFinancialYear());
        this.ajaxLoadBudgets();
        this.populateYearRange();
        this.canViewREApprovedAmount = this.canViewApprovedAmount(this.budgetDetail.getBudget());
        this.canViewBEApprovedAmount = this.canViewApprovedAmount(this.budgetService.getReferenceBudgetFor(this.budgetDetail.getBudget()));
        return "form";
    }

    private void populateYearRange() {
        CFinancialYear financialYear = this.budgetDetail.getBudget().getFinancialYear();
        if (financialYear != null) {
            if ("BE".equalsIgnoreCase(this.budgetDetail.getBudget().getIsbere())) {
                this.lastYearRange = this.currentYearRange = this.budgetDetailHelper.computePreviousYearRange(financialYear.getFinYearRange());
                this.nextYearRange = this.budgetDetailHelper.computeNextYearRange(this.currentYearRange);
            } else {
                this.currentYearRange = financialYear.getFinYearRange();
                this.lastYearRange = this.budgetDetailHelper.computePreviousYearRange(this.currentYearRange);
                this.nextYearRange = this.budgetDetailHelper.computeNextYearRange(this.currentYearRange);
            }
        }
    }

    private boolean compareDetails(BudgetDetail nextYear, BudgetDetail current) {
        if (nextYear.getExecutingDepartment() != null && current.getExecutingDepartment() != null && current.getExecutingDepartment().getId() != nextYear.getExecutingDepartment().getId()) {
            return false;
        }
        if (nextYear.getFunction() != null && current.getFunction() != null && current.getFunction().getId() != nextYear.getFunction().getId()) {
            return false;
        }
        if (nextYear.getFund() != null && current.getFund() != null && current.getFund().getId() != nextYear.getFund().getId()) {
            return false;
        }
        if (nextYear.getFunctionary() != null && current.getFunctionary() != null && current.getFunctionary().getId() != nextYear.getFunctionary().getId()) {
            return false;
        }
        if (nextYear.getScheme() != null && current.getScheme() != null && current.getScheme().getId() != nextYear.getScheme().getId()) {
            return false;
        }
        if (nextYear.getSubScheme() != null && current.getSubScheme() != null && current.getSubScheme().getId() != nextYear.getSubScheme().getId()) {
            return false;
        }
        if (nextYear.getBoundary() != null && current.getBoundary() != null && current.getBoundary().getId() != nextYear.getBoundary().getId()) {
            return false;
        }
        if (nextYear.getBudgetGroup() != null && current.getBudgetGroup() != null && current.getBudgetGroup().getId() != nextYear.getBudgetGroup().getId()) {
            return false;
        }
        return nextYear.getBudget() == null || current.getBudget() == null || current.getBudget().getId() != nextYear.getBudget().getId();
    }

    private List<BudgetDetail> populateNextYearBe(CFinancialYear finYear) {
        BudgetDetail detail = new BudgetDetail();
        detail.copyFrom(this.budgetDetail);
        detail.setBudget(null);
        Date nextYear = this.getNextYearFor(finYear.getStartingDate());
        return this.budgetDetailService.searchByCriteriaWithTypeAndFY(this.financialYearDAO.getFinYearByDate(nextYear).getId(), "BE", detail);
    }

    private List<BudgetDetail> populateCurrentYearBe() {
        BudgetDetail detail = new BudgetDetail();
        detail.copyFrom(this.budgetDetail);
        detail.setBudget(null);
        return this.budgetDetailService.searchByCriteriaWithTypeAndFY(this.budgetDetail.getBudget().getFinancialYear().getId(), "BE", detail);
    }

    protected ValueStack getValueStack() {
        return ActionContext.getContext().getValueStack();
    }

    private void populatePreviousYearActuals(List<BudgetDetail> budgetDetails, CFinancialYear financialYear) {
        if (financialYear != null && financialYear.getId() != null) {
            financialYear = (CFinancialYear)this.persistenceService.find("from CFinancialYear where id=?", new Object[]{financialYear.getId()});
        }
        for (BudgetDetail detail : budgetDetails) {
            Map paramMap = this.budgetDetailHelper.constructParamMap(this.getValueStack(), detail);
            BigDecimal amount = this.budgetDetailHelper.getTotalPreviousActualData(paramMap, financialYear.getEndingDate());
            for (BudgetReportView row : this.budgetDetailsList) {
                if (!row.getId().equals(detail.getId())) continue;
                row.setActualsLastYear(amount == null ? BigDecimal.ZERO : amount);
            }
        }
    }

    public Date subtractYear(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(1, -1);
        return cal.getTime();
    }

    public Object getModel() {
        return this.budgetDetail;
    }

    public void setBudgetDetail(BudgetDetail budgetDetail) {
        this.budgetDetail = budgetDetail;
    }

    public BudgetDetail getBudgetDetail() {
        return this.budgetDetail;
    }

    public void setBudgetDetailsList(List<BudgetReportView> budgetDetailsList) {
        this.budgetDetailsList = budgetDetailsList;
    }

    public List<BudgetReportView> getBudgetDetailsList() {
        return this.budgetDetailsList;
    }

    public void setBudgetDetailService(BudgetDetailService budgetDetailService) {
        this.budgetDetailService = budgetDetailService;
    }

    public void setBudgetList(List<Budget> budgetList) {
        this.budgetList = budgetList;
    }

    public List<Budget> getBudgetList() {
        return this.budgetList;
    }

    public boolean getCanViewREApprovedAmount() {
        return this.canViewREApprovedAmount;
    }

    public boolean getCanViewBEApprovedAmount() {
        return this.canViewBEApprovedAmount;
    }

    public void setBudgetService(BudgetService budgetService) {
        this.budgetService = budgetService;
    }

    public void setShowResults(boolean showResults) {
        this.showResults = showResults;
    }

    public boolean getShowResults() {
        return this.showResults;
    }

    public void setCurrentYearRange(String currentYearRange) {
        this.currentYearRange = currentYearRange;
    }

    public String getCurrentYearRange() {
        return this.currentYearRange;
    }

    public void setNextYearRange(String nextYearRange) {
        this.nextYearRange = nextYearRange;
    }

    public String getNextYearRange() {
        return this.nextYearRange;
    }

    public void setLastYearRange(String lastYearRange) {
        this.lastYearRange = lastYearRange;
    }

    public String getLastYearRange() {
        return this.lastYearRange;
    }
}

