/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.report;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.commons.CFinancialYear;
import org.egov.commons.CFunction;
import org.egov.commons.Fund;
import org.egov.commons.dao.FinancialYearDAO;
import org.egov.dao.budget.BudgetDetailsDAO;
import org.egov.egf.model.BudgetAppDisplay;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infstr.services.PersistenceService;
import org.egov.infstr.utils.EgovMasterDataCaching;
import org.egov.model.budget.BudgetDetail;
import org.egov.model.budget.BudgetGroup;
import org.egov.services.budget.BudgetService;
import org.egov.utils.BudgetDetailConfig;
import org.egov.utils.BudgetingType;
import org.egov.utils.Constants;
import org.egov.utils.ReportHelper;
import org.hibernate.Query;
import org.hibernate.transform.Transformers;
import org.hibernate.type.BigDecimalType;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.springframework.beans.factory.annotation.Autowired;

@Results(value={@Result(name={"result"}, location="budgetAppropriationRegisterReport-form.jsp"), @Result(name={"PDF"}, type="stream", location="inputStream", params={"inputName", "inputStream", "contentType", "application/pdf", "contentDisposition", "no-cache;filename=BudgetAppropriationRegisterRepor.pdf"}), @Result(name={"XLS"}, type="stream", location="inputStream", params={"inputName", "inputStream", "contentType", "application/xls", "contentDisposition", "no-cache;filename=BudgetAppropriationRegisterRepor.xls"})})
@ParentPackage(value="egov")
public class BudgetAppropriationRegisterReportAction
extends BaseFormAction {
    private static final long serialVersionUID = 1658431423915247237L;
    private static final Logger LOGGER = Logger.getLogger(BudgetAppropriationRegisterReportAction.class);
    String jasperpath = "/reports/templates/BudgetAppReport.jasper";
    private Department department = new Department();
    private CFunction function = new CFunction();
    private Fund fund = new Fund();
    private BudgetGroup budgetGroup = new BudgetGroup();
    private List<BudgetAppDisplay> budgetAppropriationRegisterList = new ArrayList();
    private List<BudgetAppDisplay> updatedBdgtAppropriationRegisterList = new ArrayList();
    private String budgetHead;
    private BigDecimal totalGrant;
    BudgetDetailsDAO budgetDetailsDAO;
    FinancialYearDAO financialYearDAO;
    ReportHelper reportHelper;
    private InputStream inputStream;
    private String strAsOnDate;
    String financialYearId = "";
    Date dtAsOnDate = null;
    private BigDecimal addtionalAppropriationForBe = BigDecimal.ZERO;
    private BigDecimal addtionalAppropriationForRe = BigDecimal.ZERO;
    private BigDecimal beAmount = BigDecimal.ZERO;
    private BigDecimal reAmount = BigDecimal.ZERO;
    private String finYearRange;
    protected List<String> mandatoryFields = new ArrayList();
    private BudgetService budgetService;
    private boolean isBeDefined = true;
    private boolean isReDefined = true;
    @Autowired
    private AppConfigValueService appConfigValuesService;
    private Boolean shouldShowREAppropriations = false;
    @Autowired
    private EgovMasterDataCaching masterDataCache;
    @Autowired
    private BudgetDetailConfig budgetDetailConfig;

    public BudgetAppropriationRegisterReportAction() {
        this.addRelatedEntity("function", CFunction.class);
        this.addRelatedEntity("executingDepartment", Department.class);
        this.addRelatedEntity("fund", Fund.class);
    }

    public void prepare() {
        super.prepare();
        this.mandatoryFields = this.budgetDetailConfig.getMandatoryFields();
        this.dropdownData.put("functionList", Collections.EMPTY_LIST);
        this.dropdownData.put("executingDepartmentList", Collections.EMPTY_LIST);
        this.dropdownData.put("budgetGroupList", Collections.EMPTY_LIST);
        this.dropdownData.put("fundList", this.masterDataCache.get("egi-fund"));
        if (this.department.getId() != null && this.department.getId() != -1L) {
            this.department = (Department)this.persistenceService.find("from Department where id=?", new Object[]{this.department.getId()});
        }
        if (this.function.getId() != null && this.function.getId() != -1L) {
            this.function = (CFunction)this.persistenceService.find("from CFunction where id=?", new Object[]{this.function.getId()});
        }
        if (this.fund.getId() != null && this.fund.getId() != -1) {
            this.fund = (Fund)this.persistenceService.find("from Fund where id=?", new Object[]{this.fund.getId()});
        }
        if (this.budgetGroup.getId() != null && this.budgetGroup.getId() != -1L) {
            this.budgetGroup = (BudgetGroup)this.persistenceService.find("from BudgetGroup where id=?", new Object[]{this.budgetGroup.getId()});
        }
    }

    @SkipValidation
    @Action(value="/report/budgetAppropriationRegisterReport-search")
    public String search() {
        CFinancialYear financialYear;
        block8: {
            financialYear = new CFinancialYear();
            if (((String[])this.parameters.get("asOnDate"))[0] != null) {
                this.strAsOnDate = ((String[])this.parameters.get("asOnDate"))[0];
                try {
                    this.dtAsOnDate = Constants.DDMMYYYYFORMAT2.parse(this.strAsOnDate);
                    financialYear = this.financialYearDAO.getFinancialYearByDate(this.dtAsOnDate);
                }
                catch (ParseException e) {
                    if (!LOGGER.isInfoEnabled()) break block8;
                    LOGGER.info((Object)("ParseException the date :" + e.getMessage()));
                }
            }
        }
        if (this.budgetService.hasApprovedBeForYear(financialYear.getId())) {
            this.beAmount = this.getBudgetBEorREAmt("BE");
        } else {
            this.isBeDefined = false;
            this.isReDefined = false;
        }
        if (this.budgetService.hasApprovedReForYear(financialYear.getId())) {
            this.reAmount = this.getBudgetBEorREAmt("RE");
            this.totalGrant = this.getConsiderReAppropriationAsSeperate() ? this.reAmount.add(this.addtionalAppropriationForRe) : this.reAmount;
        } else if (this.budgetService.hasApprovedBeForYear(financialYear.getId())) {
            this.isReDefined = false;
            this.totalGrant = this.beAmount.add(this.addtionalAppropriationForBe);
        }
        this.generateReport();
        return "result";
    }

    private void generateReport() {
        CFinancialYear financialYr = new CFinancialYear();
        financialYr = this.financialYearDAO.getFinancialYearByDate(this.dtAsOnDate);
        CFinancialYear financialYear = null;
        financialYear = this.financialYearDAO.getFinancialYearById(Long.valueOf(financialYr.getId()));
        this.finYearRange = financialYear.getFinYearRange();
        Date dStartDate = financialYear.getStartingDate();
        String strAODate = Constants.DDMMYYYYFORMAT1.format(this.dtAsOnDate);
        String strStDate = Constants.DDMMYYYYFORMAT1.format(dStartDate);
        Query query = null;
        if (this.budgetGroup != null) {
            this.budgetHead = this.budgetGroup.getName();
            StringBuilder strQuery = new StringBuilder();
            strQuery.append("select vmis.budgetary_appnumber as bdgApprNumber, vh.vouchernumber as VoucherNumber, vh.voucherdate as voucherDate, vh.description as description,vh.createddate as createdDate, ");
            strQuery.append(" null as billNumber, null as billDate,null as billCreatedDate, gl.debitamount as debitAmount, gl.creditamount as creditAmount from generalledger gl, vouchermis vmis,  ");
            strQuery.append(" voucherheader vh  where vh.id = gl.voucherheaderid and vh.id = vmis.voucherheaderid and  gl.glcodeid =:glCodeId");
            strQuery.append(" and (vmis.budgetary_appnumber  != 'null' and vmis.budgetary_appnumber is not null) and vh.status != 4 and vh.voucherdate  >=:strStDate");
            strQuery.append(" and vh.voucherdate <=:strAODate");
            strQuery.append(this.getFunctionQuery("gl.functionid"));
            strQuery.append(this.getDepartmentQuery("vmis.departmentid"));
            strQuery.append(this.getFundQuery("vh.fundid"));
            strQuery.append(" ");
            strQuery.append(" union select distinct bmis.budgetary_appnumber as bdgApprNumber, vh1.vouchernumber as VoucherNumber, vh1.voucherdate as  voucherDate , br.narration as description,vh1.createddate as createdDate, br.billnumber as billNumber, br.billdate as billDate,br.createddate as billCreatedDate ,  bd.debitamount as debitAmount, bd.creditamount as creditAmount  ");
            strQuery.append(" from eg_billdetails bd, eg_billregistermis bmis, eg_billregister br, voucherHeader vh1 where br.id = bd.billid and br.id = bmis.billid and  bd.glcodeid =:glCodeId ");
            strQuery.append(" and (bmis.budgetary_appnumber != 'null' and bmis.budgetary_appnumber is not null) and br.statusid not in (select id from egw_status where description='Cancelled' and moduletype in ('EXPENSEBILL', 'SALBILL', 'WORKSBILL', 'PURCHBILL', 'CBILL', 'SBILL', 'CONTRACTORBILL')) and (vh1.id = bmis.voucherheaderid )  and br.billdate  >=:strStDate");
            strQuery.append(" and br.billdate  <=:strAODate");
            strQuery.append(this.getFunctionQuery("bd.functionid"));
            strQuery.append(this.getDepartmentQuery("bmis.departmentid"));
            strQuery.append(this.getFundQuery("bmis.fundid"));
            strQuery.append("  ");
            strQuery.append(" union select distinct bmis1.budgetary_appnumber as bdgApprNumber, null as VoucherNumber,cast( null as date) voucherDate , ");
            strQuery.append(" br.narration as description,cast( null as date) createdDate, br.billnumber as billNumber, br.billdate as billDate,br.createddate as billCreatedDate ,   bd1.debitamount as debitAmount, bd1.creditamount as creditAmount from eg_billdetails bd1, eg_billregistermis bmis1, eg_billregister br  ");
            strQuery.append(" where br.id = bd1.billid and br.id = bmis1.billid and  bd1.glcodeid =:glCodeId ");
            strQuery.append(" and (bmis1.budgetary_appnumber != 'null' and bmis1.budgetary_appnumber is not null) ");
            strQuery.append(" and br.statusid not in (select id from egw_status where description='Cancelled' and moduletype in ('EXPENSEBILL', 'SALBILL', 'WORKSBILL', 'PURCHBILL', 'CBILL', 'SBILL', 'CONTRACTORBILL')) and bmis1.voucherheaderid is null and br.billdate   >=:strStDate");
            strQuery.append(" and br.billdate <=:strAODate");
            strQuery.append(this.getFunctionQuery("bd1.functionid"));
            strQuery.append(this.getDepartmentQuery("bmis1.departmentid"));
            strQuery.append(this.getFundQuery("bmis1.fundid"));
            strQuery.append("  order by bdgApprNumber ");
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("BudgetAppropriationRegisterReportAction -- strQuery...." + strQuery));
            }
            query = this.persistenceService.getSession().createSQLQuery(strQuery.toString()).addScalar("bdgApprNumber").addScalar("voucherDate", (Type)StandardBasicTypes.DATE).addScalar("billDate", (Type)StandardBasicTypes.DATE).addScalar("createdDate", (Type)StandardBasicTypes.DATE).addScalar("billCreatedDate", (Type)StandardBasicTypes.DATE).addScalar("description").addScalar("VoucherNumber").addScalar("billNumber").addScalar("debitAmount", (Type)BigDecimalType.INSTANCE).addScalar("creditAmount", (Type)BigDecimalType.INSTANCE).setResultTransformer(Transformers.aliasToBean(BudgetAppDisplay.class));
            query = this.setParameterForBudgetAppDisplay(query, this.dtAsOnDate, dStartDate);
        }
        this.budgetAppropriationRegisterList = query.list();
        List budgetApprRegNewList = new ArrayList();
        ArrayList<Object> budgetApprRegUpdatedList1 = new ArrayList<Object>();
        HashMap<String, BudgetAppDisplay> regMap = new HashMap<String, BudgetAppDisplay>();
        if (this.budgetAppropriationRegisterList.size() > 0) {
            StringBuilder strsubQuery = new StringBuilder();
            strsubQuery.append("select vmis.budgetary_appnumber as bdgApprNumber, vh.vouchernumber as VoucherNumber, vh.voucherdate as voucherDate, vh.description as description,vh.createddate as createdDate, ");
            strsubQuery.append(" br.billnumber as billNumber, br.billdate as billDate,br.createddate as billCreatedDate, gl.debitamount as debitAmount, gl.creditamount as creditAmount from generalledger gl, vouchermis vmis,  ");
            strsubQuery.append(" voucherheader vh,  eg_billregistermis bmis, eg_billregister br  where vh.id = gl.voucherheaderid and vh.id = vmis.voucherheaderid and vh.id = bmis.voucherheaderid and bmis.billid = br.id ");
            strsubQuery.append(" and  gl.glcodeid =:glCodeId ");
            strsubQuery.append(" and  ");
            strsubQuery.append(" (vmis.budgetary_appnumber  != 'null' and vmis.budgetary_appnumber is not null) and vh.status != 4 and vh.voucherdate  >=:strStDate");
            strsubQuery.append(" and vh.voucherdate <=:strAODate");
            strsubQuery.append(this.getFunctionQuery("gl.functionid"));
            strsubQuery.append(this.getDepartmentQuery("vmis.departmentid"));
            strsubQuery.append(this.getFundQuery("vh.fundid"));
            strsubQuery.append("  order by bdgApprNumber ");
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("BudgetAppropriationRegisterReportAction -- strsubQuery...." + strsubQuery));
            }
            query = this.persistenceService.getSession().createSQLQuery(strsubQuery.toString()).addScalar("bdgApprNumber").addScalar("voucherDate", (Type)StandardBasicTypes.DATE).addScalar("billDate", (Type)StandardBasicTypes.DATE).addScalar("createdDate", (Type)StandardBasicTypes.DATE).addScalar("billCreatedDate", (Type)StandardBasicTypes.DATE).addScalar("description").addScalar("VoucherNumber").addScalar("billNumber").addScalar("debitAmount", (Type)BigDecimalType.INSTANCE).addScalar("creditAmount", (Type)BigDecimalType.INSTANCE).setResultTransformer(Transformers.aliasToBean(BudgetAppDisplay.class));
            budgetApprRegNewList = (query = this.setParameterForBudgetAppDisplay(query, this.dtAsOnDate, dStartDate)).list();
            if (budgetApprRegNewList.size() > 0) {
                for (BudgetAppDisplay budgetAppRtDisp : budgetApprRegNewList) {
                    regMap.put(budgetAppRtDisp.getBdgApprNumber(), budgetAppRtDisp);
                }
                for (BudgetAppDisplay budgetAppropriationRegisterDisp : this.budgetAppropriationRegisterList) {
                    if (regMap.containsKey(budgetAppropriationRegisterDisp.getBdgApprNumber())) {
                        budgetApprRegUpdatedList1.add(regMap.get(budgetAppropriationRegisterDisp.getBdgApprNumber()));
                        continue;
                    }
                    budgetApprRegUpdatedList1.add(budgetAppropriationRegisterDisp);
                }
            }
        }
        if (budgetApprRegUpdatedList1.size() > 0) {
            this.budgetAppropriationRegisterList.clear();
            this.budgetAppropriationRegisterList.addAll(budgetApprRegUpdatedList1);
        }
        this.updateBdgtAppropriationList();
    }

    private String getFundQuery(String string) {
        String query = "";
        if (this.fund.getId() != null && this.fund.getId() != -1) {
            return " and " + string + " =:fundId ";
        }
        return "";
    }

    private String getFunctionQuery(String string) {
        String query = "";
        if (this.function.getId() != null && this.function.getId() != -1L) {
            return " and " + string + " =:functionId ";
        }
        return "";
    }

    private String getDepartmentQuery(String string) {
        String query = "";
        if (this.department.getId() != null && this.department.getId() != -1L) {
            return " and " + string + " =:departmentId ";
        }
        return "";
    }

    public boolean isFieldMandatory(String field) {
        return this.mandatoryFields.contains(field);
    }

    private void updateBdgtAppropriationList() {
        BigDecimal cumulativeAmt = null;
        BigDecimal balanceAvailableAmt = new BigDecimal(0.0);
        BigDecimal totalDebit = new BigDecimal(0.0);
        BigDecimal totalCredit = new BigDecimal(0.0);
        if (this.totalGrant == null) {
            this.totalGrant = new BigDecimal(0.0);
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("budgetAppropriationRegisterList.size() :" + this.budgetAppropriationRegisterList.size()));
        }
        if (this.budgetAppropriationRegisterList.size() > 0) {
            int iSerialNumber = 1;
            for (BudgetAppDisplay budgetAppropriationRegisterDisp : this.budgetAppropriationRegisterList) {
                if (BudgetingType.DEBIT.equals((Object)this.budgetGroup.getBudgetingType())) {
                    if (budgetAppropriationRegisterDisp.getDebitAmount() != null && budgetAppropriationRegisterDisp.getDebitAmount().compareTo(BigDecimal.ZERO) == 1) {
                        budgetAppropriationRegisterDisp.setBillAmount(budgetAppropriationRegisterDisp.getDebitAmount());
                        totalDebit = totalDebit.add(budgetAppropriationRegisterDisp.getBillAmount());
                    } else {
                        budgetAppropriationRegisterDisp.setBillAmount(budgetAppropriationRegisterDisp.getCreditAmount().multiply(new BigDecimal("-1")));
                        totalCredit = totalCredit.add(budgetAppropriationRegisterDisp.getBillAmount().abs());
                    }
                }
                if (BudgetingType.CREDIT.equals((Object)this.budgetGroup.getBudgetingType())) {
                    if (budgetAppropriationRegisterDisp.getCreditAmount() != null && budgetAppropriationRegisterDisp.getCreditAmount().compareTo(BigDecimal.ZERO) == 1) {
                        budgetAppropriationRegisterDisp.setBillAmount(budgetAppropriationRegisterDisp.getCreditAmount());
                        totalCredit = totalCredit.add(budgetAppropriationRegisterDisp.getBillAmount());
                    } else {
                        budgetAppropriationRegisterDisp.setBillAmount(budgetAppropriationRegisterDisp.getDebitAmount().multiply(new BigDecimal("-1")));
                        totalDebit = totalDebit.add(budgetAppropriationRegisterDisp.getBillAmount().abs());
                    }
                }
                if (BudgetingType.ALL.equals((Object)this.budgetGroup.getBudgetingType())) {
                    if (budgetAppropriationRegisterDisp.getDebitAmount() != null && budgetAppropriationRegisterDisp.getDebitAmount().compareTo(BigDecimal.ZERO) == 1) {
                        budgetAppropriationRegisterDisp.setBillAmount(budgetAppropriationRegisterDisp.getDebitAmount());
                    } else {
                        budgetAppropriationRegisterDisp.setBillAmount(budgetAppropriationRegisterDisp.getCreditAmount().multiply(new BigDecimal("-1")));
                    }
                }
                if (cumulativeAmt == null) {
                    if (BudgetingType.ALL.equals((Object)this.budgetGroup.getBudgetingType())) {
                        cumulativeAmt = budgetAppropriationRegisterDisp.getBillAmount();
                    } else if (BudgetingType.CREDIT.equals((Object)this.budgetGroup.getBudgetingType())) {
                        cumulativeAmt = totalCredit.subtract(totalDebit);
                    } else if (BudgetingType.DEBIT.equals((Object)this.budgetGroup.getBudgetingType())) {
                        cumulativeAmt = totalDebit.subtract(totalCredit);
                    }
                    budgetAppropriationRegisterDisp.setCumulativeAmount(cumulativeAmt);
                } else if (BudgetingType.ALL.equals((Object)this.budgetGroup.getBudgetingType())) {
                    if (budgetAppropriationRegisterDisp.getDebitAmount() != null && budgetAppropriationRegisterDisp.getDebitAmount().compareTo(BigDecimal.ZERO) == 1) {
                        cumulativeAmt = budgetAppropriationRegisterDisp.getBillAmount().abs().add(cumulativeAmt);
                        budgetAppropriationRegisterDisp.setCumulativeAmount(cumulativeAmt);
                    } else {
                        cumulativeAmt = cumulativeAmt.subtract(budgetAppropriationRegisterDisp.getBillAmount().abs());
                        budgetAppropriationRegisterDisp.setCumulativeAmount(cumulativeAmt);
                    }
                } else if (BudgetingType.CREDIT.equals((Object)this.budgetGroup.getBudgetingType())) {
                    cumulativeAmt = cumulativeAmt.add(totalCredit.subtract(totalDebit));
                    budgetAppropriationRegisterDisp.setCumulativeAmount(cumulativeAmt);
                } else if (BudgetingType.DEBIT.equals((Object)this.budgetGroup.getBudgetingType())) {
                    cumulativeAmt = cumulativeAmt.add(totalDebit.subtract(totalCredit));
                    budgetAppropriationRegisterDisp.setCumulativeAmount(cumulativeAmt);
                }
                balanceAvailableAmt = BudgetingType.ALL.equals((Object)this.budgetGroup.getBudgetingType()) ? (budgetAppropriationRegisterDisp.getDebitAmount() != null && budgetAppropriationRegisterDisp.getDebitAmount().compareTo(BigDecimal.ZERO) == 1 ? this.totalGrant.subtract(budgetAppropriationRegisterDisp.getCumulativeAmount().abs()) : this.totalGrant.add(budgetAppropriationRegisterDisp.getCumulativeAmount())) : this.totalGrant.subtract(budgetAppropriationRegisterDisp.getCumulativeAmount());
                budgetAppropriationRegisterDisp.setBalanceAvailableAmount(balanceAvailableAmt);
                budgetAppropriationRegisterDisp.setSerailNumber(Integer.toString(iSerialNumber));
                this.updatedBdgtAppropriationRegisterList.add(budgetAppropriationRegisterDisp);
                totalCredit = BigDecimal.ZERO;
                totalDebit = BigDecimal.ZERO;
                ++iSerialNumber;
            }
        }
    }

    private BigDecimal getBudgetBEorREAmt(String type) {
        BigDecimal approvedAmount = new BigDecimal(0.0);
        try {
            CFinancialYear financialYr = new CFinancialYear();
            financialYr = this.financialYearDAO.getFinancialYearByDate(this.dtAsOnDate);
            CFinancialYear financialYear = this.financialYearDAO.getFinancialYearById(Long.valueOf(financialYr.getId()));
            List budgedDetailList = new ArrayList();
            String query = " from BudgetDetail bd where bd.budget.isbere=? and bd.budgetGroup=? and bd.budget.financialYear=? ";
            if (this.department.getId() != null && this.department.getId() != -1L) {
                query = query + " and bd.executingDepartment.id=" + this.department.getId();
            }
            if (this.function.getId() != null && this.function.getId() != -1L) {
                query = query + " and bd.function.id=" + this.function.getId();
            }
            if (this.fund.getId() != null && this.fund.getId() != -1) {
                query = query + " and bd.fund.id=" + this.fund.getId();
            }
            if ((budgedDetailList = this.persistenceService.findAllBy(query, new Object[]{type, this.budgetGroup, financialYear})) != null && budgedDetailList.size() > 0) {
                for (BudgetDetail bdetail : budgedDetailList) {
                    approvedAmount = approvedAmount.add(bdetail.getApprovedAmount());
                    if ("RE".equalsIgnoreCase(type) && !this.getConsiderReAppropriationAsSeperate()) {
                        approvedAmount = approvedAmount.add(bdetail.getApprovedReAppropriationsTotal());
                        continue;
                    }
                    if ("BE".equalsIgnoreCase(type)) {
                        this.addtionalAppropriationForBe = this.addtionalAppropriationForBe.add(bdetail.getApprovedReAppropriationsTotal());
                        continue;
                    }
                    this.shouldShowREAppropriations = true;
                    this.addtionalAppropriationForRe = this.addtionalAppropriationForRe.add(bdetail.getApprovedReAppropriationsTotal());
                }
            }
        }
        catch (ValidationException e) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("ValidationException while fetching BudgetBEorREAmt :" + e.getMessage()));
            }
            return new BigDecimal(0.0);
        }
        return approvedAmount;
    }

    private Map<String, Object> getParamMapForReportFile() {
        HashMap<String, Object> paramMapForReportFile = new HashMap<String, Object>();
        paramMapForReportFile.put("bgname", this.budgetHead);
        paramMapForReportFile.put("deptName", this.department.getName());
        paramMapForReportFile.put("function", this.function.getName());
        paramMapForReportFile.put("fund", this.fund.getName());
        String rBEorREAmountForm = " - (" + this.finYearRange + ") (Rs.)  : ";
        paramMapForReportFile.put("rAsOnDate", this.strAsOnDate);
        if (this.isBeDefined) {
            paramMapForReportFile.put("rBE", rBEorREAmountForm + this.beAmount.toString());
            paramMapForReportFile.put("rAddiApprBe", this.addtionalAppropriationForBe.toString());
        } else {
            paramMapForReportFile.put("rBE", rBEorREAmountForm + "Budget Not Defined ");
            paramMapForReportFile.put("rAddiApprBe", "");
        }
        if (this.isReDefined) {
            paramMapForReportFile.put("rRE", rBEorREAmountForm + this.reAmount.toString());
            paramMapForReportFile.put("rAddiApprRe", this.addtionalAppropriationForRe.toString());
        } else {
            paramMapForReportFile.put("rRE", rBEorREAmountForm);
            paramMapForReportFile.put("rAddiApprRe", "");
        }
        paramMapForReportFile.put("showREAppr", this.shouldShowREAppropriations.toString());
        return paramMapForReportFile;
    }

    @Action(value="/report/budgetAppropriationRegisterReport-generatePdf")
    public String generatePdf() throws JRException, IOException {
        this.updatedBdgtAppropriationRegisterList = new ArrayList();
        this.search();
        ArrayList data = new ArrayList();
        data.addAll(this.getUpdatedBdgtAppropriationRegisterList());
        this.inputStream = this.reportHelper.exportPdf(this.getInputStream(), this.jasperpath, this.getParamMapForReportFile(), data);
        return "PDF";
    }

    @Action(value="/report/budgetAppropriationRegisterReport-generateXls")
    public String generateXls() throws JRException, IOException {
        this.updatedBdgtAppropriationRegisterList = new ArrayList();
        this.search();
        ArrayList data = new ArrayList();
        data.addAll(this.getUpdatedBdgtAppropriationRegisterList());
        this.inputStream = this.reportHelper.exportXls(this.getInputStream(), this.jasperpath, this.getParamMapForReportFile(), data);
        return "XLS";
    }

    private Query setParameterForBudgetAppDisplay(Query query, Date asOnDate, Date startDate) {
        if (this.function.getId() != null && this.function.getId() != -1L) {
            query.setLong("functionId", this.function.getId().longValue());
        }
        if (this.department.getId() != null && this.department.getId() != -1L) {
            query.setLong("departmentId", this.department.getId().longValue());
        }
        if (this.fund.getId() != null && this.fund.getId() != -1) {
            query.setLong("fundId", (long)this.fund.getId().intValue());
        }
        if (this.budgetGroup.getMinCode().getId() != null) {
            query.setLong("glCodeId", this.budgetGroup.getMinCode().getId().longValue());
        }
        if (asOnDate != null) {
            query.setDate("strAODate", asOnDate);
        }
        if (startDate != null) {
            query.setDate("strStDate", startDate);
        }
        return query;
    }

    public String getFormattedDate(Date date) {
        SimpleDateFormat formatter = Constants.DDMMYYYYFORMAT1;
        return formatter.format(date);
    }

    public void setReportHelper(ReportHelper reportHelper) {
        this.reportHelper = reportHelper;
    }

    public String execute() throws Exception {
        return "form";
    }

    public Object getModel() {
        return null;
    }

    public Department getDepartment() {
        return this.department;
    }

    public void setDepartment(Department department) {
        this.department = department;
    }

    public CFunction getFunction() {
        return this.function;
    }

    public void setFunction(CFunction function) {
        this.function = function;
    }

    public List<BudgetAppDisplay> getBudgetAppropriationRegisterList() {
        return this.budgetAppropriationRegisterList;
    }

    public void setBudgetAppropriationRegisterList(List<BudgetAppDisplay> budgetAppropriationRegisterList) {
        this.budgetAppropriationRegisterList = budgetAppropriationRegisterList;
    }

    public String getBudgetHead() {
        return this.budgetHead;
    }

    public void setBudgetHead(String budgetHead) {
        this.budgetHead = budgetHead;
    }

    public BigDecimal getTotalGrant() {
        return this.totalGrant;
    }

    public void setTotalGrant(BigDecimal totalGrant) {
        this.totalGrant = totalGrant;
    }

    public BudgetDetailsDAO getBudgetDetailsDAO() {
        return this.budgetDetailsDAO;
    }

    public void setBudgetDetailsDAO(BudgetDetailsDAO budgetDetailsDAO) {
        this.budgetDetailsDAO = budgetDetailsDAO;
    }

    public BudgetGroup getBudgetGroup() {
        return this.budgetGroup;
    }

    public void setBudgetGroup(BudgetGroup budgetGroup) {
        this.budgetGroup = budgetGroup;
    }

    public PersistenceService getPersistenceService() {
        return this.persistenceService;
    }

    public FinancialYearDAO getFinancialYearDAO() {
        return this.financialYearDAO;
    }

    public void setFinancialYearDAO(FinancialYearDAO financialYearDAO) {
        this.financialYearDAO = financialYearDAO;
    }

    public List<BudgetAppDisplay> getUpdatedBdgtAppropriationRegisterList() {
        return this.updatedBdgtAppropriationRegisterList;
    }

    public void setUpdatedBdgtAppropriationRegisterList(List<BudgetAppDisplay> updatedBdgtAppropriationRegisterList) {
        this.updatedBdgtAppropriationRegisterList = updatedBdgtAppropriationRegisterList;
    }

    public String getStrAsOnDate() {
        return this.strAsOnDate;
    }

    public void setStrAsOnDate(String strAsOnDate) {
        this.strAsOnDate = strAsOnDate;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public BigDecimal getBeAmount() {
        return this.beAmount;
    }

    public void setBeAmount(BigDecimal beAmount) {
        this.beAmount = beAmount;
    }

    public BigDecimal getReAmount() {
        return this.reAmount;
    }

    public void setReAmount(BigDecimal reAmount) {
        this.reAmount = reAmount;
    }

    public String getFinYearRange() {
        return this.finYearRange;
    }

    public void setFinYearRange(String finYearRange) {
        this.finYearRange = finYearRange;
    }

    public void setFund(Fund fund) {
        this.fund = fund;
    }

    public Fund getFund() {
        return this.fund;
    }

    public void setBudgetService(BudgetService budgetService) {
        this.budgetService = budgetService;
    }

    public void setAddtionalAppropriationForBe(BigDecimal addtionalAppropriationForBe) {
        this.addtionalAppropriationForBe = addtionalAppropriationForBe;
    }

    public BigDecimal getAddtionalAppropriationForBe() {
        return this.addtionalAppropriationForBe;
    }

    public void setAddtionalAppropriationForRe(BigDecimal addtionalAppropriationForRe) {
        this.addtionalAppropriationForRe = addtionalAppropriationForRe;
    }

    public BigDecimal getAddtionalAppropriationForRe() {
        return this.addtionalAppropriationForRe;
    }

    public boolean getIsBeDefined() {
        return this.isBeDefined;
    }

    public boolean getIsReDefined() {
        return this.isReDefined;
    }

    private boolean getConsiderReAppropriationAsSeperate() {
        List appList = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "CONSIDER_RE_REAPPROPRIATION_AS_SEPARATE");
        String appValue = "-1";
        appValue = ((AppConfigValues)appList.get(0)).getValue();
        return "Y".equalsIgnoreCase(appValue);
    }

    public void setShouldShowREAppropriations(boolean shouldShowREAppropriations) {
        this.shouldShowREAppropriations = shouldShowREAppropriations;
    }

    public boolean getShouldShowREAppropriations() {
        return this.shouldShowREAppropriations;
    }
}

