/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.report;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.egov.commons.dao.ChartOfAccountsHibernateDAO;
import org.egov.egf.model.AutoRemittanceSchedulerReportBean;
import org.egov.infra.web.struts.actions.SearchFormAction;
import org.egov.infstr.search.SearchQuery;
import org.egov.infstr.search.SearchQueryHQL;
import org.egov.infstr.services.PersistenceService;
import org.egov.services.recoveries.RecoveryService;
import org.egov.utils.FinancialConstants;
import org.hibernate.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@ParentPackage(value="egov")
@Results(value={@Result(name={"new"}, location="autoRemittanceSchedulerReport-new.jsp")})
public class AutoRemittanceSchedulerReportAction
extends SearchFormAction {
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    private static final long serialVersionUID = 1L;
    private static final String[] REMITTANCE_SCHEDULER_SCHEDULAR_TYPE = new String[]{"Auto", "Manual", "Both"};
    public static final Locale LOCALE = new Locale("en", "IN");
    public static final SimpleDateFormat DDMMYYYYFORMATS = new SimpleDateFormat("dd/MM/yyyy", LOCALE);
    private AutoRemittanceSchedulerReportBean reportBean;
    @Autowired
    @Qualifier(value="recoveryPersistenceService")
    private RecoveryService recoveryService;
    private String recoveryId;
    private String schedulerType;
    private Date runDateFrom;
    private Date runDateTo;
    private Boolean nextRunDate;
    private static final int PAGE_SIZE = 30;
    @Autowired
    private ChartOfAccountsHibernateDAO chartOfAccountsHibernateDAO;
    private List<Object> paramList;
    StringBuilder dynQuery = new StringBuilder(800);
    private static Logger LOGGER = Logger.getLogger(AutoRemittanceSchedulerReportAction.class);
    private Map recoveryMap = new TreeMap();

    @Action(value="/report/autoRemittanceSchedulerReport-newform")
    public String newform() {
        return "new";
    }

    public SearchQuery prepareQuery(String sortField, String sortOrder) {
        String query = this.getSearchQuery();
        String countQry = "select count(*) from  RemittanceSchedulerLog  as s " + this.dynQuery + " ";
        this.setPageSize(30);
        return new SearchQueryHQL(query, countQry, this.paramList);
    }

    private String getSearchQuery() {
        this.paramList = new ArrayList();
        String queryBeginning = " ";
        queryBeginning = "select distinct (SELECT COUNT(sp.schId)  from RemittanceSchedulePayment sp  WHERE sp.schId = s.id) AS COUNT, s.schJobName,s.lastRunDate, s.schType, s.glcode, s.status, s.remarks,s.id from RemittanceSchedulerLog as s ";
        if (this.schedulerType.equals("Auto")) {
            this.dynQuery.append(" where  s.schType=?");
            this.paramList.add(FinancialConstants.REMITTANCE_SCHEDULER_SCHEDULAR_TYPE_AUTO);
        } else if (this.schedulerType.equals("Manual")) {
            this.dynQuery.append(" where s.schType=?");
            this.paramList.add(FinancialConstants.REMITTANCE_SCHEDULER_SCHEDULAR_TYPE_MANUAL);
        } else {
            this.dynQuery.append(" where s.schType=? or s.schType=?");
            this.paramList.add(FinancialConstants.REMITTANCE_SCHEDULER_SCHEDULAR_TYPE_AUTO);
            this.paramList.add(FinancialConstants.REMITTANCE_SCHEDULER_SCHEDULAR_TYPE_MANUAL);
        }
        if (StringUtils.isNotEmpty((String)this.recoveryId)) {
            this.dynQuery.append(" and  s.glcode=?");
            this.paramList.add(this.recoveryId);
        }
        if (this.runDateFrom != null) {
            this.dynQuery.append(" and  s.lastRunDate>=to_date(?,'dd/MM/yyyy')");
            this.paramList.add(DDMMYYYYFORMATS.format(this.runDateFrom));
        }
        if (this.runDateTo != null) {
            this.dynQuery.append(" and  s.lastRunDate<=to_date(?,'dd/MM/yyyy')");
            this.paramList.add(DDMMYYYYFORMATS.format(this.runDateTo));
        }
        this.dynQuery.append(" order by lastRunDate desc");
        return queryBeginning + this.dynQuery.toString();
    }

    public String searchList() {
        super.search();
        this.populateResult(this.searchResult.getList());
        this.getSession().put("searchResult", this.searchResult);
        return "new";
    }

    private void populateResult(List searchResult) {
        ArrayList<AutoRemittanceSchedulerReportBean> srchList = new ArrayList<AutoRemittanceSchedulerReportBean>();
        Iterator itr = searchResult.iterator();
        while (itr.hasNext()) {
            this.reportBean = new AutoRemittanceSchedulerReportBean();
            Object[] row = (Object[])itr.next();
            this.reportBean.setNumberOfPayments(((Long)row[0]).toString());
            this.reportBean.setRunDate((Date)row[2]);
            Character schType = (Character)row[3];
            String schStringType = null;
            if (schType.charValue() == 'A') {
                schStringType = "Auto";
            } else if (schType.charValue() == 'M') {
                schStringType = "Manual";
            }
            this.reportBean.setScheduleType(schStringType);
            String glcode = (String)row[4];
            String recCoa = "";
            if (StringUtils.isNotEmpty((String)glcode)) {
                Object ca = null;
                recCoa = ca.getGlcode() + "-" + ca.getName();
            }
            this.reportBean.setRecoveryCoa(recCoa);
            String stat = (String)row[5];
            if (stat.equalsIgnoreCase("success")) {
                this.reportBean.setStatus("Completed");
                this.reportBean.setRemarks("Success");
            } else {
                this.reportBean.setStatus(stat);
                this.reportBean.setRemarks((String)row[6] == null ? (String)row[6] : "");
            }
            srchList.add(this.reportBean);
        }
        searchResult.clear();
        HashSet uniqueResult = new HashSet(srchList);
        searchResult.addAll(uniqueResult);
        LOGGER.info((Object)("SearchResult Full List size>>>>>>>>>>>>>>>>" + searchResult));
    }

    public void prepare() {
        super.prepare();
        this.getRecoveryCOA();
        this.addDropdownData("schedulerTypeList", Arrays.asList(REMITTANCE_SCHEDULER_SCHEDULAR_TYPE));
    }

    private void getRecoveryCOA() {
        String queryString = "select c.glcode, c.glcode || '-' || c.name from Recovery r join r.chartofaccounts c where r.isactive=true and r.remittanceMode='A'  order by c.glcode ";
        Query query = this.persistenceService.getSession().createQuery("select c.glcode, c.glcode || '-' || c.name from Recovery r join r.chartofaccounts c where r.isactive=true and r.remittanceMode='A'  order by c.glcode ");
        List chartList = query.list();
        for (Object[] row : chartList) {
            this.recoveryMap.put(row[0], row[1]);
        }
    }

    public Object getModel() {
        return null;
    }

    public String getRecoveryId() {
        return this.recoveryId;
    }

    public void setRecoveryId(String recoveryId) {
        this.recoveryId = recoveryId;
    }

    public String getSchedulerType() {
        return this.schedulerType;
    }

    public void setSchedulerType(String schedulerType) {
        this.schedulerType = schedulerType;
    }

    public Date getRunDateFrom() {
        return this.runDateFrom;
    }

    public void setRunDateFrom(Date runDateFrom) {
        this.runDateFrom = runDateFrom;
    }

    public Date getRunDateTo() {
        return this.runDateTo;
    }

    public void setRunDateTo(Date runDateTo) {
        this.runDateTo = runDateTo;
    }

    public Boolean getNextRunDate() {
        return this.nextRunDate;
    }

    public void setNextRunDate(Boolean nextRunDate) {
        this.nextRunDate = nextRunDate;
    }

    public AutoRemittanceSchedulerReportBean getReportBean() {
        return this.reportBean;
    }

    public void setReportBean(AutoRemittanceSchedulerReportBean reportBean) {
        this.reportBean = reportBean;
    }

    public Map getRecoveryMap() {
        return this.recoveryMap;
    }

    public void setRecoveryMap(Map recoveryMap) {
        this.recoveryMap = recoveryMap;
    }
}

