/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.payment;

import com.exilant.GLEngine.ChartOfAccounts;
import com.exilant.GLEngine.Transaxtion;
import com.exilant.exility.common.TaskFailedException;
import com.exilant.exility.dataservice.DatabaseConnectionException;
import com.opensymphony.xwork2.validator.annotations.RequiredFieldValidator;
import com.opensymphony.xwork2.validator.annotations.Validations;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.billsaccounting.services.CreateVoucher;
import org.egov.commons.Accountdetailtype;
import org.egov.commons.Bankaccount;
import org.egov.commons.CFunction;
import org.egov.commons.CGeneralLedger;
import org.egov.commons.CGeneralLedgerDetail;
import org.egov.commons.CVoucherHeader;
import org.egov.commons.Vouchermis;
import org.egov.commons.utils.EntityType;
import org.egov.egf.commons.EgovCommon;
import org.egov.egf.web.actions.payment.BasePaymentAction;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.exception.ApplicationException;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.script.service.ScriptService;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.infra.workflow.matrix.entity.WorkFlowMatrix;
import org.egov.infra.workflow.service.SimpleWorkflowService;
import org.egov.infstr.services.PersistenceService;
import org.egov.model.bills.Miscbilldetail;
import org.egov.model.instrument.InstrumentHeader;
import org.egov.model.payment.Paymentheader;
import org.egov.model.voucher.CommonBean;
import org.egov.model.voucher.VoucherDetails;
import org.egov.model.voucher.WorkflowBean;
import org.egov.payment.services.PaymentActionHelper;
import org.egov.services.contra.ContraService;
import org.egov.services.payment.MiscbilldetailService;
import org.egov.services.payment.PaymentService;
import org.egov.services.voucher.VoucherService;
import org.egov.utils.Constants;
import org.egov.utils.FinancialConstants;
import org.hibernate.HibernateException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

@ParentPackage(value="egov")
@Results(value={@Result(name={"new"}, location="directBankPayment-new.jsp"), @Result(name={"edit"}, location="directBankPayment-edit.jsp"), @Result(name={"reverse"}, location="directBankPayment-reverse.jsp"), @Result(name={"view"}, location="directBankPayment-view.jsp")})
public class DirectBankPaymentAction
extends BasePaymentAction {
    private static final String FORWARD = "Forward";
    private static final String FAILED_WHILE_REVERSING = "Failed while Reversing";
    private static final String FAILED = "Transaction failed";
    private static final String EXCEPTION_WHILE_SAVING_DATA = "Exception while saving data";
    private static final long serialVersionUID = 1L;
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    @Autowired
    private CreateVoucher createVoucher;
    private PaymentService paymentService;
    @Autowired
    private PaymentActionHelper paymentActionHelper;
    private static final String DD_MMM_YYYY = "dd-MMM-yyyy";
    private final SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy", Constants.LOCALE);
    public Map<String, String> modeOfPaymentMap;
    private static final String MDP_CHEQUE = "cheque";
    private static final String MDP_RTGS = "rtgs";
    private static final String MDP_CASH = "cash";
    private String button;
    private VoucherService voucherService;
    private static final Logger LOGGER = Logger.getLogger(DirectBankPaymentAction.class);
    public static final String ZERO = "0";
    private static final String VIEW = "view";
    private static final String REVERSE = "reverse";
    private static final String REQUIRED = "required";
    private static final String PAYMENTID = "paymentid";
    private List<VoucherDetails> billDetailslist;
    private List<VoucherDetails> subLedgerlist;
    boolean showChequeNumber;
    private CommonBean commonBean;
    private Paymentheader paymentheader = new Paymentheader();
    public boolean showApprove = false;
    private Integer departmentId;
    private String wfitemstate;
    private String typeOfAccount;
    private List<InstrumentHeader> instrumentHeaderList = new ArrayList();
    private BigDecimal balance;
    private ScriptService scriptService;
    private ChartOfAccounts chartOfAccounts;
    @Autowired
    @Qualifier(value="miscbilldetailService")
    private MiscbilldetailService miscbilldetailService;
    private String cutOffDate;
    DateFormat df = new SimpleDateFormat("dd-MMM-yyyy");
    DateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
    SimpleDateFormat formatter1 = new SimpleDateFormat("yyyy-MM-dd");
    Date date;

    public BigDecimal getBalance() {
        return this.balance;
    }

    public void setBalance(BigDecimal balance) {
        this.balance = balance;
    }

    public StateAware getModel() {
        this.voucherHeader = (CVoucherHeader)super.getModel();
        return this.voucherHeader;
    }

    public void prepare() {
        super.prepare();
        this.voucherHeader.setType("Payment");
        this.voucherHeader.setName("Direct Bank Payment");
        this.modeOfPaymentMap = new LinkedHashMap();
        this.modeOfPaymentMap.put(MDP_CHEQUE, this.getText(MDP_CHEQUE));
        this.modeOfPaymentMap.put(MDP_CASH, this.getText(MDP_CASH));
        this.modeOfPaymentMap.put(MDP_RTGS, this.getText(MDP_RTGS));
        this.addDropdownData("designationList", Collections.EMPTY_LIST);
        this.addDropdownData("userList", Collections.EMPTY_LIST);
        this.typeOfAccount = "PAYMENTS,RECEIPTS_PAYMENTS";
    }

    public void prepareNewform() {
        this.addDropdownData("bankList", Collections.EMPTY_LIST);
        this.addDropdownData("accNumList", Collections.EMPTY_LIST);
    }

    @SkipValidation
    @Action(value="/payment/directBankPayment-newform")
    public String newform() {
        List cutOffDateconfigValue;
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Resetting all........................... ");
        }
        if ((cutOffDateconfigValue = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "DataEntryCutOffDate")) != null && !cutOffDateconfigValue.isEmpty()) {
            try {
                this.date = this.df.parse(((AppConfigValues)cutOffDateconfigValue.get(0)).getValue());
                this.cutOffDate = this.formatter.format(this.date);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        this.voucherHeader.reset();
        this.commonBean.reset();
        this.commonBean.setModeOfPayment(MDP_CHEQUE);
        this.voucherHeader.setVouchermis(new Vouchermis());
        this.billDetailslist = new ArrayList();
        this.billDetailslist.add(new VoucherDetails());
        this.subLedgerlist = new ArrayList();
        this.subLedgerlist.add(new VoucherDetails());
        this.loadDefalutDates();
        if (this.getBankBalanceCheck() == null || "".equals(this.getBankBalanceCheck())) {
            this.addActionMessage(this.getText("payment.bankbalance.controltype"));
        }
        return "new";
    }

    @Validations(requiredFields={@RequiredFieldValidator(fieldName="fundId", message="", key="required"), @RequiredFieldValidator(fieldName="voucherNumber", message="", key="required"), @RequiredFieldValidator(fieldName="commonBean.bankId", message="", key="required"), @RequiredFieldValidator(fieldName="commonBean.accountNumberId", message="", key="required"), @RequiredFieldValidator(fieldName="commonBean.amount", message="", key="required"), @RequiredFieldValidator(fieldName="voucherDate", message="", key="required"), @RequiredFieldValidator(fieldName="commonBean.documentNumber", message="", key="required"), @RequiredFieldValidator(fieldName="commonBean.documentDate", message="", key="required"), @RequiredFieldValidator(fieldName="commonBean.paidTo", message="", key="required")})
    @SkipValidation
    @ValidationErrorPage(value="new")
    @Action(value="/payment/directBankPayment-create")
    public String create() {
        block21: {
            CVoucherHeader billVhId = null;
            this.voucherHeader.setType("Payment");
            this.loadAjaxedDropDowns();
            this.removeEmptyRowsAccoutDetail(this.billDetailslist);
            this.removeEmptyRowsSubledger(this.subLedgerlist);
            String voucherDate = this.formatter1.format(this.voucherHeader.getVoucherDate());
            String cutOffDate1 = null;
            try {
                if (!this.validateDBPData(this.billDetailslist, this.subLedgerlist)) {
                    if (this.commonBean.getModeOfPayment().equalsIgnoreCase(MDP_RTGS)) {
                        if (LOGGER.isInfoEnabled()) {
                            LOGGER.info((Object)"calling Validate RTGS");
                        }
                        this.validateRTGS();
                    }
                    if (this.showMode != null && this.showMode.equalsIgnoreCase("nonbillPayment") && this.voucherHeader.getId() != null) {
                        billVhId = (CVoucherHeader)this.persistenceService.getSession().load(CVoucherHeader.class, (Serializable)this.voucherHeader.getId());
                    }
                    this.voucherHeader.setId(null);
                    this.populateWorkflowBean();
                    this.paymentheader = this.paymentActionHelper.createDirectBankPayment(this.paymentheader, this.voucherHeader, billVhId, this.commonBean, this.billDetailslist, this.subLedgerlist, this.workflowBean);
                    this.showMode = "create";
                    if (!this.cutOffDate.isEmpty() && this.cutOffDate != null) {
                        try {
                            this.date = this.sdf.parse(this.cutOffDate);
                            cutOffDate1 = this.formatter1.format(this.date);
                        }
                        catch (ParseException parseException) {
                            // empty catch block
                        }
                    }
                    if (cutOffDate1 != null && voucherDate.compareTo(cutOffDate1) <= 0 && "Create And Approve".equalsIgnoreCase(this.workflowBean.getWorkFlowAction())) {
                        if (this.paymentheader.getVoucherheader().getVouchermis().getBudgetaryAppnumber() == null) {
                            this.addActionMessage(this.getText("directbankpayment.transaction.success") + this.paymentheader.getVoucherheader().getVoucherNumber());
                        } else {
                            this.addActionMessage(this.getText("directbankpayment.transaction.success") + this.paymentheader.getVoucherheader().getVoucherNumber() + " and " + this.getText("budget.recheck.sucessful", new String[]{this.paymentheader.getVoucherheader().getVouchermis().getBudgetaryAppnumber()}));
                        }
                    } else {
                        if (this.paymentheader.getVoucherheader().getVouchermis().getBudgetaryAppnumber() == null) {
                            this.addActionMessage(this.getText("directbankpayment.transaction.success") + this.paymentheader.getVoucherheader().getVoucherNumber());
                        } else {
                            this.addActionMessage(this.getText("directbankpayment.transaction.success") + this.paymentheader.getVoucherheader().getVoucherNumber() + " and " + this.getText("budget.recheck.sucessful", new String[]{this.paymentheader.getVoucherheader().getVouchermis().getBudgetaryAppnumber()}));
                        }
                        this.addActionMessage(this.getText("payment.voucher.approved", new String[]{this.paymentService.getEmployeeNameForPositionId(this.paymentheader.getState().getOwnerPosition())}));
                    }
                    break block21;
                }
                throw new ValidationException(Arrays.asList(new ValidationError("engine.validation.failed", "Validation Faild")));
            }
            catch (ValidationException e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
                ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
                errors.add(new ValidationError("exp", ((ValidationError)e.getErrors().get(0)).getMessage()));
                throw new ValidationException(errors);
            }
            catch (NumberFormatException e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
                throw e;
            }
            catch (ApplicationRuntimeException e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
                throw e;
            }
            finally {
                if (this.subLedgerlist.size() == 0) {
                    this.subLedgerlist.add(new VoucherDetails());
                }
            }
        }
        return VIEW;
    }

    public void prepareNonBillPayment() {
        this.addDropdownData("bankList", Collections.EMPTY_LIST);
        this.addDropdownData("accNumList", Collections.EMPTY_LIST);
        this.commonBean.setModeOfPayment(MDP_CHEQUE);
    }

    @ValidationErrorPage(value="new")
    @SkipValidation
    public String nonBillPayment() {
        this.voucherHeader = (CVoucherHeader)this.persistenceService.getSession().load(CVoucherHeader.class, (Serializable)this.voucherHeader.getId());
        String vName = this.voucherHeader.getName();
        String appconfigKey = "";
        if (vName.equalsIgnoreCase("Contractor Journal")) {
            appconfigKey = "worksBillPurposeIds";
        } else if (vName.equalsIgnoreCase("Supplier Journal")) {
            appconfigKey = "purchaseBillPurposeIds";
        } else if (vName.equalsIgnoreCase("Salary Journal")) {
            appconfigKey = "salaryBillPurposeIds";
        }
        AppConfigValues appConfigValues = (AppConfigValues)this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", appconfigKey).get(0);
        String purposeValue = appConfigValues.getValue();
        CGeneralLedger netPay = (CGeneralLedger)this.persistenceService.find("from CGeneralLedger where voucherHeaderId.id=? and glcodeId.purposeId=?", new Object[]{this.voucherHeader.getId(), purposeValue});
        if (netPay == null) {
            throw new ValidationException(Arrays.asList(new ValidationError("net.payable.not.selected.or.selected.wrongly", "Either Net payable code is not selected or wrongly selected in voucher .Payment creation Failed")));
        }
        this.billDetailslist = new ArrayList();
        this.subLedgerlist = new ArrayList();
        VoucherDetails vd = new VoucherDetails();
        vd.setGlcodeDetail(netPay.getGlcode());
        vd.setGlcodeIdDetail(netPay.getGlcodeId().getId());
        vd.setAccounthead(netPay.getGlcodeId().getName());
        vd.setDebitAmountDetail(BigDecimal.valueOf(netPay.getCreditAmount()));
        if (netPay.getFunctionId() != null) {
            vd.setFunctionIdDetail(Long.valueOf(netPay.getFunctionId().intValue()));
            CFunction function = (CFunction)this.persistenceService.getSession().load(CFunction.class, (Serializable)Long.valueOf(netPay.getFunctionId().intValue()));
            vd.setFunctionDetail(function.getId().toString());
        }
        this.commonBean.setAmount(BigDecimal.valueOf(netPay.getCreditAmount()));
        this.billDetailslist.add(vd);
        Set generalLedgerDetails = netPay.getGeneralLedgerDetails();
        boolean i = false;
        for (CGeneralLedgerDetail gldetail : generalLedgerDetails) {
            Class<?> service;
            VoucherDetails vdetails = new VoucherDetails();
            vdetails.setSubledgerCode(netPay.getGlcode());
            vdetails.setAmount(gldetail.getAmount());
            vdetails.setGlcodeDetail(netPay.getGlcode());
            vdetails.setGlcode(netPay.getGlcodeId());
            vdetails.setSubledgerCode(netPay.getGlcode());
            vdetails.setAccounthead(netPay.getGlcodeId().getName());
            Accountdetailtype detailType = (Accountdetailtype)this.persistenceService.getSession().load(Accountdetailtype.class, (Serializable)gldetail.getDetailTypeId());
            vdetails.setDetailTypeName(detailType.getName());
            vdetails.setDetailType(detailType);
            vdetails.setDetailKey(gldetail.getDetailKeyId().toString());
            vdetails.setDetailKeyId(gldetail.getDetailKeyId());
            String table = detailType.getFullQualifiedName();
            try {
                service = Class.forName(table);
            }
            catch (ClassNotFoundException e1) {
                LOGGER.error((Object)e1.getMessage(), (Throwable)e1);
                throw new ValidationException(Arrays.asList(new ValidationError("application.error", "application.error")));
            }
            String simpleName = service.getSimpleName();
            simpleName = simpleName.substring(0, 1).toLowerCase() + simpleName.substring(1) + "Service";
            WebApplicationContext wac = WebApplicationContextUtils.getWebApplicationContext((ServletContext)ServletActionContext.getServletContext());
            PersistenceService entityPersistenceService = (PersistenceService)wac.getBean(simpleName);
            String dataType = "";
            try {
                Class<?> aClass = Class.forName(table);
                Method method = aClass.getMethod("getId", new Class[0]);
                dataType = method.getReturnType().getSimpleName();
            }
            catch (Exception e) {
                throw new ApplicationRuntimeException(e.getMessage());
            }
            EntityType entity = null;
            entity = dataType.equals("Long") ? (EntityType)entityPersistenceService.findById((Serializable)Long.valueOf(gldetail.getDetailKeyId().toString()), false) : (EntityType)entityPersistenceService.findById((Serializable)gldetail.getDetailKeyId(), false);
            vdetails.setDetailCode(entity.getCode());
            vdetails.setDetailName(entity.getName());
            vdetails.setDetailKey(entity.getName());
            this.commonBean.setPaidTo(entity.getName());
            this.subLedgerlist.add(vdetails);
        }
        if (this.subLedgerlist.size() == 0) {
            this.subLedgerlist.add(new VoucherDetails());
        }
        this.loadAjaxedDropDowns();
        return "new";
    }

    private void validateRTGS() {
        EntityType entity = null;
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        String type = null;
        if (this.subLedgerlist != null && !this.subLedgerlist.isEmpty()) {
            for (VoucherDetails voucherDetail : this.subLedgerlist) {
                try {
                    type = voucherDetail.getDetailTypeName();
                    entity = this.paymentService.getEntity(voucherDetail.getDetailType().getId(), (Serializable)voucherDetail.getDetailKeyId());
                    if (entity == null) {
                        throw new ValidationException(Arrays.asList(new ValidationError("No.entity.for.detailkey", "There is no entity defined for" + voucherDetail.getDetailCode(), new String[]{voucherDetail.getDetailCode()})));
                    }
                }
                catch (ApplicationException e) {
                    throw new ValidationException(Arrays.asList(new ValidationError("Exception to get EntityType  ", e.getMessage())));
                }
                voucherDetail.setDetailType((Accountdetailtype)this.persistenceService.getSession().load(Accountdetailtype.class, (Serializable)voucherDetail.getDetailType().getId()));
                if (type.equalsIgnoreCase("Contractor") && (StringUtils.isBlank((String)entity.getPanno()) || StringUtils.isBlank((String)entity.getBankname()) || StringUtils.isBlank((String)entity.getBankaccount()) || StringUtils.isBlank((String)entity.getIfsccode()))) {
                    LOGGER.error((Object)("BankAccount,IFSC Code, Pan number is mandatory for RTGS Payment for " + entity.getName()));
                    errors.add(new ValidationError("paymentMode", "BankName, BankAccount,IFSC Code, Pan number is mandatory for RTGS Payment for " + entity.getName()));
                    throw new ValidationException(errors);
                }
                if (type.equalsIgnoreCase("Supplier") && (StringUtils.isBlank((String)entity.getTinno()) || StringUtils.isBlank((String)entity.getBankname()) || StringUtils.isBlank((String)entity.getBankaccount()) || StringUtils.isBlank((String)entity.getIfsccode()))) {
                    LOGGER.error((Object)("BankAccount,IFSC Code, Tin number is mandatory for RTGS Payment for " + entity.getName()));
                    errors.add(new ValidationError("paymentMode", "BankName, BankAccount,IFSC Code, Tin number is mandatory for RTGS Payment for " + entity.getName()));
                    throw new ValidationException(errors);
                }
                if (!StringUtils.isBlank((String)entity.getBankname()) && !StringUtils.isBlank((String)entity.getBankaccount()) && !StringUtils.isBlank((String)entity.getIfsccode())) continue;
                LOGGER.error((Object)("BankAccount,IFSC Code is mandatory for RTGS Payment for " + entity.getName()));
                errors.add(new ValidationError("paymentMode", "BankName, BankAccount,IFSC Code is mandatory for RTGS Payment for type " + type + " and Entity " + entity.getName()));
                throw new ValidationException(errors);
            }
        } else {
            throw new ValidationException(Arrays.asList(new ValidationError("no.subledger.cannot.create.rtgs.payment", "There is no subledger selected cannot create RTGS Payment")));
        }
    }

    private void updateMiscBillDetail(CVoucherHeader billVhId) {
        Miscbilldetail miscbillDetail = (Miscbilldetail)this.persistenceService.find(" from Miscbilldetail where payVoucherHeader=?", new Object[]{this.voucherHeader});
        miscbillDetail.setBillnumber(this.commonBean.getDocumentNumber());
        miscbillDetail.setBilldate(this.commonBean.getDocumentDate());
        miscbillDetail.setBillVoucherHeader(billVhId);
        miscbillDetail.setBillamount(this.commonBean.getAmount());
        miscbillDetail.setPayVoucherHeader(this.voucherHeader);
        miscbillDetail.setPaidamount(this.commonBean.getAmount());
        miscbillDetail.setPassedamount(this.commonBean.getAmount());
        miscbillDetail.setPaidamount(this.commonBean.getAmount());
        miscbillDetail.setPaidto(this.commonBean.getPaidTo().trim());
        this.miscbilldetailService.persist((Object)miscbillDetail);
    }

    @SkipValidation
    @Action(value="/payment/directBankPayment-beforeView")
    public String beforeView() {
        this.prepareForViewModifyReverse();
        this.wfitemstate = "END";
        return VIEW;
    }

    @SkipValidation
    @Action(value="/payment/directBankPayment-beforeEdit")
    public String beforeEdit() {
        this.prepareForViewModifyReverse();
        return "edit";
    }

    @SkipValidation
    @Action(value="/payment/directBankPayment-beforeReverse")
    public String beforeReverse() {
        this.prepareForViewModifyReverse();
        return REVERSE;
    }

    private void prepareForViewModifyReverse() {
        StringBuffer instrumentQuery = new StringBuffer(100);
        instrumentQuery.append("select  distinct ih from InstrumentHeader ih join ih.instrumentVouchers iv where iv.voucherHeaderId.id=?").append(" order by ih.id");
        this.voucherHeader = (CVoucherHeader)this.persistenceService.getSession().load(CVoucherHeader.class, (Serializable)this.voucherHeader.getId());
        this.paymentheader = (Paymentheader)this.persistenceService.find("from Paymentheader where voucherheader=?", new Object[]{this.voucherHeader});
        this.commonBean.setAmount(this.paymentheader.getPaymentAmount());
        this.commonBean.setAccountNumberId(this.paymentheader.getBankaccount().getId().toString());
        this.commonBean.setAccnumnar(this.paymentheader.getBankaccount().getNarration());
        String bankBranchId = this.paymentheader.getBankaccount().getBankbranch().getBank().getId() + "-" + this.paymentheader.getBankaccount().getBankbranch().getId();
        this.commonBean.setBankId(bankBranchId);
        this.commonBean.setModeOfPayment(this.paymentheader.getType());
        Miscbilldetail miscbillDetail = (Miscbilldetail)this.persistenceService.find(" from Miscbilldetail where payVoucherHeader=?", new Object[]{this.voucherHeader});
        this.commonBean.setDocumentNumber(miscbillDetail.getBillnumber());
        this.commonBean.setDocumentDate(miscbillDetail.getBilldate());
        this.commonBean.setPaidTo(miscbillDetail.getPaidto());
        if (miscbillDetail.getBillVoucherHeader() != null) {
            this.commonBean.setDocumentId(miscbillDetail.getBillVoucherHeader().getId());
            this.commonBean.setLinkReferenceNumber(miscbillDetail.getBillVoucherHeader().getVoucherNumber());
        }
        String bankGlcode = this.paymentheader.getBankaccount().getChartofaccounts().getGlcode();
        VoucherDetails bankdetail = null;
        Map vhInfoMap = this.voucherService.getVoucherInfo(this.voucherHeader.getId());
        this.billDetailslist = (List)vhInfoMap.get("glDetailList");
        this.subLedgerlist = (List)vhInfoMap.get("subLedgerDetail");
        for (VoucherDetails vd : this.billDetailslist) {
            if (!vd.getGlcodeDetail().equalsIgnoreCase(bankGlcode)) continue;
            bankdetail = vd;
        }
        if (bankdetail != null) {
            this.billDetailslist.remove(bankdetail);
        }
        this.loadAjaxedDropDowns();
        if (VIEW.equalsIgnoreCase(this.showMode)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"fetching cheque detail ------------------------");
            }
            this.instrumentHeaderList = this.getPersistenceService().findAllBy(instrumentQuery.toString(), new Object[]{this.paymentheader.getVoucherheader().getId()});
        }
    }

    private void loadAjaxedDropDowns() {
        this.loadSchemeSubscheme();
        this.loadBankBranchForFund();
        this.loadBankAccountNumber(this.commonBean.getBankId());
        this.loadFundSource();
    }

    @Action(value="/payment/directBankPayment-edit")
    public String edit() throws SQLException {
        block9: {
            CVoucherHeader billVhId = null;
            this.voucherHeader.setType("Payment");
            this.removeEmptyRowsAccoutDetail(this.billDetailslist);
            this.removeEmptyRowsSubledger(this.subLedgerlist);
            this.validateFields();
            this.voucherHeader = this.voucherService.updateVoucherHeader(this.voucherHeader);
            try {
                if (!this.validateDBPData(this.billDetailslist, this.subLedgerlist)) {
                    if (this.commonBean.getModeOfPayment().equalsIgnoreCase(MDP_RTGS)) {
                        this.validateRTGS();
                    }
                    this.reCreateLedger();
                    this.paymentheader = (Paymentheader)this.persistenceService.find("from Paymentheader where voucherheader=?", new Object[]{this.voucherHeader});
                    this.paymentService.updatePaymentHeader(this.paymentheader, this.voucherHeader, Integer.valueOf(this.commonBean.getAccountNumberId()), this.commonBean.getModeOfPayment(), this.commonBean.getAmount());
                    if (this.commonBean.getDocumentId() != null) {
                        billVhId = (CVoucherHeader)this.persistenceService.getSession().load(CVoucherHeader.class, (Serializable)this.commonBean.getDocumentId());
                    }
                    this.updateMiscBillDetail(billVhId);
                    this.sendForApproval();
                    this.addActionMessage(this.getText("directbankpayment.transaction.success") + this.voucherHeader.getVoucherNumber());
                    break block9;
                }
                throw new ValidationException(Arrays.asList(new ValidationError("engine.validation.failed", "Validation Faild")));
            }
            catch (NumberFormatException e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
                throw new ValidationException(Arrays.asList(new ValidationError(e.getMessage(), e.getMessage())));
            }
            finally {
                if (this.subLedgerlist.size() == 0) {
                    this.subLedgerlist.add(new VoucherDetails());
                }
                this.loadAjaxedDropDowns();
            }
        }
        return VIEW;
    }

    @ValidationErrorPage(value="reverse")
    public String reverse() {
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
        CVoucherHeader reversalVoucher = null;
        HashMap<String, Object> reversalVoucherMap = new HashMap<String, Object>();
        reversalVoucherMap.put("Original voucher header id", this.voucherHeader.getId());
        reversalVoucherMap.put("Reversal voucher type", "Receipt");
        reversalVoucherMap.put("Reversal voucher name", "Direct");
        try {
            reversalVoucherMap.put("Reversal voucher date", sdf.parse(this.getReversalVoucherDate()));
        }
        catch (ParseException e1) {
            throw new ValidationException(Arrays.asList(new ValidationError("reversalVocuherDate", "reversalVocuherDate.notinproperformat")));
        }
        reversalVoucherMap.put("Reversal voucher number", this.getReversalVoucherNumber());
        ArrayList<HashMap<String, Object>> reversalList = new ArrayList<HashMap<String, Object>>();
        reversalList.add(reversalVoucherMap);
        try {
            reversalVoucher = this.createVoucher.reverseVoucher(reversalList);
        }
        catch (ApplicationRuntimeException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new ValidationException(Arrays.asList(new ValidationError(FAILED_WHILE_REVERSING, FAILED_WHILE_REVERSING)));
        }
        catch (ParseException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new ValidationException(Arrays.asList(new ValidationError("Date is not in proper Format", "Date is not in proper Format")));
        }
        this.loadAjaxedDropDowns();
        this.addActionMessage(this.getText("directbankpayment.reverse.transaction.success") + reversalVoucher.getVoucherNumber());
        return REVERSE;
    }

    private void reCreateLedger() {
        try {
            this.createVoucher.deleteVoucherdetailAndGL(this.voucherHeader);
            this.persistenceService.getSession().flush();
            HashMap<String, String> detailMap = null;
            HashMap<String, Object> subledgertDetailMap = null;
            ArrayList accountdetails = new ArrayList();
            ArrayList subledgerDetails = new ArrayList();
            detailMap = new HashMap<String, String>();
            detailMap.put("creditamount", this.commonBean.getAmount().toString());
            detailMap.put("debitamount", ZERO);
            Bankaccount account = (Bankaccount)this.persistenceService.getSession().load(Bankaccount.class, (Serializable)Integer.valueOf(this.commonBean.getAccountNumberId()));
            detailMap.put("glcode", account.getChartofaccounts().getGlcode());
            if (this.voucherHeader.getVouchermis().getFunction() != null) {
                detailMap.put("functioncode", this.voucherHeader.getVouchermis().getFunction().getCode());
            }
            accountdetails.add(detailMap);
            HashMap<String, String> glcodeMap = new HashMap<String, String>();
            for (VoucherDetails voucherDetail : this.billDetailslist) {
                detailMap = new HashMap();
                if (voucherDetail.getFunctionIdDetail() != null) {
                    CFunction function = (CFunction)this.persistenceService.getSession().load(CFunction.class, (Serializable)voucherDetail.getFunctionIdDetail());
                    detailMap.put("functioncode", function.getCode());
                }
                if (this.voucherHeader.getVouchermis().getFunction() != null && !this.voucherHeader.getVouchermis().getFunction().equals(ZERO)) {
                    detailMap.put("functioncode", this.voucherHeader.getVouchermis().getFunction().getCode());
                }
                if (voucherDetail.getCreditAmountDetail().compareTo(BigDecimal.ZERO) == 0) {
                    detailMap.put("debitamount", voucherDetail.getDebitAmountDetail().toString());
                    detailMap.put("creditamount", ZERO);
                    detailMap.put("glcode", voucherDetail.getGlcodeDetail());
                    accountdetails.add(detailMap);
                    glcodeMap.put(voucherDetail.getGlcodeDetail(), "debit");
                    continue;
                }
                detailMap.put("creditamount", voucherDetail.getCreditAmountDetail().toString());
                detailMap.put("debitamount", ZERO);
                detailMap.put("glcode", voucherDetail.getGlcodeDetail());
                accountdetails.add(detailMap);
                glcodeMap.put(voucherDetail.getGlcodeDetail(), "credit");
            }
            for (VoucherDetails voucherDetail : this.subLedgerlist) {
                String amountType;
                subledgertDetailMap = new HashMap<String, Object>();
                String string = amountType = glcodeMap.get(voucherDetail.getSubledgerCode()) != null ? glcodeMap.get(voucherDetail.getSubledgerCode()).toString() : null;
                if (null != amountType && amountType.equalsIgnoreCase("debit")) {
                    subledgertDetailMap.put("debitamount", voucherDetail.getAmount());
                } else if (null != amountType) {
                    subledgertDetailMap.put("creditamount", voucherDetail.getAmount());
                }
                subledgertDetailMap.put("detailtypeid", voucherDetail.getDetailType().getId());
                subledgertDetailMap.put("detailkeyid", voucherDetail.getDetailKeyId());
                subledgertDetailMap.put("glcode", voucherDetail.getSubledgerCode());
                subledgerDetails.add(subledgertDetailMap);
            }
            List transactions = this.createVoucher.createTransaction(null, accountdetails, subledgerDetails, this.voucherHeader);
            this.persistenceService.getSession().flush();
            Transaxtion[] txnList = new Transaxtion[transactions.size()];
            txnList = transactions.toArray(txnList);
            SimpleDateFormat formatter = new SimpleDateFormat(DD_MMM_YYYY);
            if (!this.chartOfAccounts.postTransaxtions(txnList, formatter.format(this.voucherHeader.getVoucherDate()))) {
                throw new ValidationException(Arrays.asList(new ValidationError("Exception While Saving Data", "Transaction Failed")));
            }
        }
        catch (HibernateException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new ValidationException(Arrays.asList(new ValidationError(EXCEPTION_WHILE_SAVING_DATA, FAILED)));
        }
        catch (NumberFormatException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new ValidationException(Arrays.asList(new ValidationError(EXCEPTION_WHILE_SAVING_DATA, FAILED)));
        }
        catch (DatabaseConnectionException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new ValidationException(Arrays.asList(new ValidationError(EXCEPTION_WHILE_SAVING_DATA, FAILED)));
        }
        catch (ApplicationRuntimeException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new ValidationException(Arrays.asList(new ValidationError(EXCEPTION_WHILE_SAVING_DATA, FAILED)));
        }
        catch (SQLException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new ValidationException(Arrays.asList(new ValidationError(EXCEPTION_WHILE_SAVING_DATA, FAILED)));
        }
        catch (TaskFailedException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new ValidationException(Arrays.asList(new ValidationError(EXCEPTION_WHILE_SAVING_DATA, FAILED)));
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new ValidationException(Arrays.asList(new ValidationError(EXCEPTION_WHILE_SAVING_DATA, FAILED)));
        }
    }

    protected boolean validateDBPData(List<VoucherDetails> billDetailslist, List<VoucherDetails> subLedgerList) {
        BigDecimal totalDrAmt = BigDecimal.ZERO;
        BigDecimal totalCrAmt = BigDecimal.ZERO;
        totalCrAmt = totalCrAmt.add(this.commonBean.getAmount());
        int index = 0;
        boolean isValFailed = false;
        for (VoucherDetails voucherDetails : billDetailslist) {
            ++index;
            totalDrAmt = totalDrAmt.add(voucherDetails.getDebitAmountDetail());
            totalCrAmt = totalCrAmt.add(voucherDetails.getCreditAmountDetail());
            if (voucherDetails.getDebitAmountDetail().compareTo(BigDecimal.ZERO) == 0 && voucherDetails.getCreditAmountDetail().compareTo(BigDecimal.ZERO) == 0 && voucherDetails.getGlcodeDetail().trim().length() == 0) {
                this.addActionError(this.getText("journalvoucher.accdetail.emptyaccrow", new String[]{"" + index}));
                isValFailed = true;
                continue;
            }
            if (voucherDetails.getDebitAmountDetail().compareTo(BigDecimal.ZERO) == 0 && voucherDetails.getCreditAmountDetail().compareTo(BigDecimal.ZERO) == 0 && voucherDetails.getGlcodeDetail().trim().length() != 0) {
                this.addActionError(this.getText("journalvoucher.accdetail.amountZero", new String[]{voucherDetails.getGlcodeDetail()}));
                isValFailed = true;
                continue;
            }
            if (voucherDetails.getDebitAmountDetail().compareTo(BigDecimal.ZERO) > 0 && voucherDetails.getCreditAmountDetail().compareTo(BigDecimal.ZERO) > 0) {
                this.addActionError(this.getText("journalvoucher.accdetail.amount", new String[]{voucherDetails.getGlcodeDetail()}));
                isValFailed = true;
                continue;
            }
            if (voucherDetails.getDebitAmountDetail().compareTo(BigDecimal.ZERO) <= 0 && voucherDetails.getCreditAmountDetail().compareTo(BigDecimal.ZERO) <= 0 || voucherDetails.getGlcodeDetail().trim().length() != 0) continue;
            this.addActionError(this.getText("journalvoucher.accdetail.accmissing", new String[]{"" + index}));
            isValFailed = true;
        }
        if (totalDrAmt.compareTo(totalCrAmt) != 0 && !isValFailed) {
            this.addActionError(this.getText("journalvoucher.accdetail.drcrmatch"));
            isValFailed = true;
        } else if (!isValFailed) {
            isValFailed = this.validateSubledgerDetails(billDetailslist, subLedgerList);
        }
        return isValFailed;
    }

    @ValidationErrorPage(value="view")
    @SkipValidation
    @Action(value="/payment/directBankPayment-viewInboxItem")
    public String viewInboxItem() {
        this.paymentheader = this.getPayment();
        this.showApprove = true;
        if (this.paymentheader.getVoucherheader() != null) {
            this.voucherHeader.setId(this.paymentheader.getVoucherheader().getId());
        }
        this.prepareForViewModifyReverse();
        return VIEW;
    }

    @ValidationErrorPage(value="view")
    @SkipValidation
    @Action(value="/payment/directBankPayment-sendForApproval")
    public String sendForApproval() {
        if (this.paymentheader.getId() == null) {
            this.paymentheader = this.getPayment();
        }
        this.populateWorkflowBean();
        this.paymentheader = this.paymentActionHelper.sendForApproval(this.paymentheader, this.workflowBean);
        if ("Reject".equalsIgnoreCase(this.workflowBean.getWorkFlowAction())) {
            this.addActionMessage(this.getText("payment.voucher.rejected", new String[]{this.paymentService.getEmployeeNameForPositionId(this.paymentheader.getState().getOwnerPosition())}));
        }
        if (FORWARD.equalsIgnoreCase(this.workflowBean.getWorkFlowAction())) {
            this.addActionMessage(this.getText("payment.voucher.approved", new String[]{this.paymentService.getEmployeeNameForPositionId(this.paymentheader.getState().getOwnerPosition())}));
        }
        if ("Cancel".equalsIgnoreCase(this.workflowBean.getWorkFlowAction())) {
            this.addActionMessage(this.getText("payment.voucher.cancelled"));
        } else if ("Approve".equalsIgnoreCase(this.workflowBean.getWorkFlowAction())) {
            if ("Closed".equals(this.paymentheader.getState().getValue())) {
                this.addActionMessage(this.getText("payment.voucher.final.approval"));
            } else {
                this.addActionMessage(this.getText("payment.voucher.approved", new String[]{this.paymentService.getEmployeeNameForPositionId(this.paymentheader.getState().getOwnerPosition())}));
            }
            this.setAction(this.workflowBean.getWorkFlowAction());
        }
        this.showMode = VIEW;
        return this.viewInboxItem();
    }

    public List<String> getValidActions() {
        List<String> validActions = Collections.emptyList();
        List cutOffDateconfigValue = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "DataEntryCutOffDate");
        if (cutOffDateconfigValue != null && !cutOffDateconfigValue.isEmpty()) {
            if (null == this.paymentheader || null == this.paymentheader.getId() || this.paymentheader.getCurrentState().getValue().endsWith("NEW")) {
                validActions = Arrays.asList(FORWARD, "Create And Approve");
            } else if (this.paymentheader.getCurrentState() != null) {
                validActions = this.customizedWorkFlowService.getNextValidActions(this.paymentheader.getStateType(), this.getWorkFlowDepartment(), this.getAmountRule(), this.getAdditionalRule(), this.paymentheader.getCurrentState().getValue(), this.getPendingActions(), this.paymentheader.getCreatedDate());
            }
        } else if (null == this.paymentheader || null == this.paymentheader.getId() || this.paymentheader.getCurrentState().getValue().endsWith("NEW")) {
            validActions = Arrays.asList(FORWARD);
        } else if (this.paymentheader.getCurrentState() != null) {
            validActions = this.customizedWorkFlowService.getNextValidActions(this.paymentheader.getStateType(), this.getWorkFlowDepartment(), this.getAmountRule(), this.getAdditionalRule(), this.paymentheader.getCurrentState().getValue(), this.getPendingActions(), this.paymentheader.getCreatedDate());
        }
        return validActions;
    }

    public String getNextAction() {
        WorkFlowMatrix wfMatrix = null;
        if (this.paymentheader.getId() != null) {
            wfMatrix = this.paymentheader.getCurrentState() != null ? this.customizedWorkFlowService.getWfMatrix(this.paymentheader.getStateType(), this.getWorkFlowDepartment(), this.getAmountRule(), this.getAdditionalRule(), this.paymentheader.getCurrentState().getValue(), this.getPendingActions(), this.paymentheader.getCreatedDate()) : this.customizedWorkFlowService.getWfMatrix(this.paymentheader.getStateType(), this.getWorkFlowDepartment(), this.getAmountRule(), this.getAdditionalRule(), "Created", this.getPendingActions(), this.paymentheader.getCreatedDate());
        }
        return wfMatrix == null ? "" : wfMatrix.getNextAction();
    }

    public Paymentheader getPayment() {
        String paymentid = null;
        paymentid = ((String[])this.parameters.get(PAYMENTID))[0];
        if (paymentid != null) {
            this.paymentheader = (Paymentheader)this.paymentService.findById((Serializable)Long.valueOf(paymentid), false);
        }
        if (this.paymentheader == null) {
            this.paymentheader = new Paymentheader();
        }
        return this.paymentheader;
    }

    @ValidationErrorPage(value="beforeEdit")
    @SkipValidation
    public String cancelPayment() {
        this.voucherHeader = (CVoucherHeader)this.persistenceService.getSession().load(CVoucherHeader.class, (Serializable)this.voucherHeader.getId());
        this.paymentheader = (Paymentheader)this.persistenceService.find("from Paymentheader where voucherheader=?", new Object[]{this.voucherHeader});
        this.voucherHeader.setStatus(FinancialConstants.CANCELLEDVOUCHERSTATUS);
        this.paymentheader.transition(true).end();
        this.persistenceService.persist((Object)this.voucherHeader);
        this.addActionMessage(this.getText("payment.cancel.success"));
        this.action = ((String[])this.parameters.get("actionname"))[0];
        return this.beforeView();
    }

    public void setPaymentService(PaymentService paymentService) {
        this.paymentService = paymentService;
    }

    public void setContraService(ContraService contraService) {
    }

    public boolean isShowChequeNumber() {
        return this.showChequeNumber;
    }

    public void setShowChequeNumber(boolean showChequeNumber) {
        this.showChequeNumber = showChequeNumber;
    }

    public List<VoucherDetails> getSubLedgerlist() {
        return this.subLedgerlist;
    }

    public void setSubLedgerlist(List<VoucherDetails> subLedgerlist) {
        this.subLedgerlist = subLedgerlist;
    }

    public List<VoucherDetails> getBillDetailslist() {
        return this.billDetailslist;
    }

    public void setBillDetailslist(List<VoucherDetails> billDetailslist) {
        this.billDetailslist = billDetailslist;
    }

    public void setCommonBean(CommonBean commonBean) {
        this.commonBean = commonBean;
    }

    public CommonBean getCommonBean() {
        return this.commonBean;
    }

    public Map<String, String> getModeOfPaymentMap() {
        return this.modeOfPaymentMap;
    }

    public void setModeOfPaymentMap(Map<String, String> modeOfPaymentMap) {
        this.modeOfPaymentMap = modeOfPaymentMap;
    }

    public String getButton() {
        return this.button;
    }

    public void setButton(String button) {
        this.button = button;
    }

    public VoucherService getVoucherService() {
        return this.voucherService;
    }

    public void setVoucherService(VoucherService voucherService) {
        this.voucherService = voucherService;
    }

    public Paymentheader getPaymentheader() {
        return this.paymentheader;
    }

    public void setPaymentheader(Paymentheader paymentheader) {
        this.paymentheader = paymentheader;
    }

    public void setPaymentWorkflowService(SimpleWorkflowService<Paymentheader> paymentWorkflowService) {
    }

    public void setEgovCommon(EgovCommon egovCommon) {
    }

    public Integer getDepartmentId() {
        return this.departmentId;
    }

    public void setDepartmentId(Integer departmentId) {
        this.departmentId = departmentId;
    }

    public String getWfitemstate() {
        return this.wfitemstate;
    }

    public void setWfitemstate(String wfitemstate) {
        this.wfitemstate = wfitemstate;
    }

    public String getComments() {
        return this.getText("payment.comments", new String[]{this.paymentheader.getPaymentAmount().setScale(2, 6).toPlainString()});
    }

    public String getTypeOfAccount() {
        return this.typeOfAccount;
    }

    public void setTypeOfAccount(String typeOfAccount) {
        this.typeOfAccount = typeOfAccount;
    }

    public List<InstrumentHeader> getInstrumentHeaderList() {
        return this.instrumentHeaderList;
    }

    public void setInstrumentHeaderList(List<InstrumentHeader> instrumentHeaderList) {
        this.instrumentHeaderList = instrumentHeaderList;
    }

    public ScriptService getScriptService() {
        return this.scriptService;
    }

    public void setScriptService(ScriptService scriptService) {
        this.scriptService = scriptService;
    }

    public ChartOfAccounts getChartOfAccounts() {
        return this.chartOfAccounts;
    }

    public void setChartOfAccounts(ChartOfAccounts chartOfAccounts) {
        this.chartOfAccounts = chartOfAccounts;
    }

    public WorkflowBean getWorkflowBean() {
        return this.workflowBean;
    }

    public void setWorkflowBean(WorkflowBean workflowBean) {
        this.workflowBean = workflowBean;
    }

    public String getCurrentState() {
        return this.paymentheader.getState().getValue();
    }

    public String getCutOffDate() {
        return this.cutOffDate;
    }

    public void setCutOffDate(String cutOffDate) {
        this.cutOffDate = cutOffDate;
    }
}

