/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.payment;

import com.exilant.eGov.src.transactions.VoucherTypeForULB;
import com.opensymphony.xwork2.validator.annotations.Validations;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.egf.web.actions.voucher.BaseVoucherAction;
import org.egov.eis.service.EisCommonService;
import org.egov.infra.admin.master.entity.AppConfig;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.service.AppConfigService;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.workflow.service.SimpleWorkflowService;
import org.egov.model.advance.EgAdvanceRequisition;
import org.egov.model.payment.Paymentheader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@ParentPackage(value="egov")
@Validations
@Results(value={@Result(name={"billpayment"}, type="redirectAction", location="payment-view", params={"namespace", "/payment", "paymentid", "${paymentid}"}), @Result(name={"advancepayment"}, type="redirect", location="${url}"), @Result(name={"directbankpayment"}, type="redirectAction", location="directBankPayment-viewInboxItem", params={"namespace", "/payment", "paymentid", "${paymentid}"}), @Result(name={"remitRecovery"}, type="redirectAction", location="remitRecovery-viewInboxItem", params={"namespace", "/deduction", "paymentid", "${paymentid}"}), @Result(name={"contractoradvancepayment"}, type="redirectAction", location="advancePayment-viewInboxItem", params={"namespace", "/payment", "paymentid", "${paymentid}"})})
public class BasePaymentAction
extends BaseVoucherAction {
    private static final long serialVersionUID = 8589393885303282831L;
    EisCommonService eisCommonService;
    private static Logger LOGGER = Logger.getLogger(BasePaymentAction.class);
    @Autowired
    @Qualifier(value="workflowService")
    private SimpleWorkflowService<Paymentheader> paymentHeaderWorkflowService;
    @Autowired
    private VoucherTypeForULB voucherTypeForULB;
    @Autowired
    AppConfigService appConfigService;
    private Map<String, String> modeOfPaymentMap;
    public static final String MDP_CHEQUE = "cheque";
    public static final String MDP_RTGS = "rtgs";
    public static final String MDP_CASH = "cash";
    protected String action = "";
    protected String paymentid = "";
    protected String url = "";
    private final String BILLPAYMENT = "billpayment";
    private final String DIRECTBANKPAYMENT = "directbankpayment";
    private final String REMITTANCEPAYMENT = "remitRecovery";
    public static final String ARF_TYPE = "Contractor";
    private String bankBalanceCheck = "";
    protected static final String ACTIONNAME = "actionname";
    protected boolean canCheckBalance = false;
    @Autowired
    protected AppConfigValueService appConfigValuesService;
    protected String showMode;

    public void setEisCommonService(EisCommonService eisCommonService) {
        this.eisCommonService = eisCommonService;
    }

    public void prepare() {
        super.prepare();
        this.bankBalanceValidation();
    }

    public boolean isCanCheckBalance() {
        return this.canCheckBalance;
    }

    public void setCanCheckBalance(boolean canCheckBalance) {
        this.canCheckBalance = canCheckBalance;
    }

    @SkipValidation
    @Action(value="/payment/basePayment-viewInboxItems")
    public String viewInboxItems() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting viewInboxItems..... ");
        }
        String result = null;
        Paymentheader paymentheader = (Paymentheader)this.persistenceService.find("from Paymentheader where id=?", new Object[]{Long.valueOf(this.paymentid)});
        if (!this.validateOwner(paymentheader.getState()).booleanValue()) {
            return "invalidPage";
        }
        this.getSession().put("paymentid", this.paymentid);
        if (paymentheader.getVoucherheader().getName().equalsIgnoreCase("Advance Payment")) {
            EgAdvanceRequisition arf = (EgAdvanceRequisition)this.persistenceService.find("from EgAdvanceRequisition where arftype = ? and egAdvanceReqMises.voucherheader = ?", new Object[]{ARF_TYPE, paymentheader.getVoucherheader()});
            if (arf != null) {
                result = "contractoradvancepayment";
            } else {
                this.url = "/advancepayment/view/" + this.paymentid;
                result = "advancepayment";
            }
        } else if (paymentheader.getVoucherheader().getName().equalsIgnoreCase("Bill Payment") || "Salary Bill Payment".equalsIgnoreCase(paymentheader.getVoucherheader().getName()) || "Pension Bill Payment".equalsIgnoreCase(paymentheader.getVoucherheader().getName())) {
            result = "billpayment";
        } else if (paymentheader.getVoucherheader().getName().equalsIgnoreCase("Direct Bank Payment")) {
            result = "directbankpayment";
        } else if (paymentheader.getVoucherheader().getName().equalsIgnoreCase("Remittance Payment")) {
            result = "remitRecovery";
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed viewInboxItems..... ");
        }
        return result;
    }

    public boolean shouldshowVoucherNumber() {
        String vNumGenMode = "Manual";
        vNumGenMode = this.voucherTypeForULB.readVoucherTypes("Payment");
        if (!"Auto".equalsIgnoreCase(vNumGenMode)) {
            this.mandatoryFields.add("vouchernumber");
            return true;
        }
        return false;
    }

    public void bankBalanceValidation() {
        AppConfig appConfig = this.appConfigService.getAppConfigByModuleNameAndKeyName("EGF", "Balance Check Control Type");
        if (appConfig != null && !appConfig.getConfValues().isEmpty()) {
            String appValue = ((AppConfigValues)appConfig.getConfValues().get(0)).getValue();
            if ("mandatory".equalsIgnoreCase(appValue)) {
                this.bankBalanceCheck = appValue.toLowerCase();
            } else if ("warning".equalsIgnoreCase(appValue)) {
                this.bankBalanceCheck = appValue.toLowerCase();
            } else if ("none".equalsIgnoreCase(appValue)) {
                this.bankBalanceCheck = appValue.toLowerCase();
            }
        }
    }

    public void getPaymentModes(String paymentType) {
        this.modeOfPaymentMap = new LinkedHashMap();
        AppConfig paymentModes = this.appConfigService.getAppConfigByModuleNameAndKeyName("EGF", "Mode of Payment");
        if (paymentModes != null && !paymentModes.getConfValues().isEmpty()) {
            for (AppConfigValues appConfigValues : paymentModes.getConfValues()) {
                if (!appConfigValues.getValue().contains("|")) continue;
                String[] appConfigValuesArray = appConfigValues.getValue().split("\\|");
                String paymentName = appConfigValuesArray[0];
                if (!paymentType.trim().equalsIgnoreCase(paymentName)) continue;
                if (!appConfigValuesArray[1].isEmpty() && appConfigValuesArray[1].contains(",")) {
                    String[] appCongifValue;
                    for (String value : appCongifValue = appConfigValuesArray[1].split(",")) {
                        this.modeOfPaymentwithAppConfig(value, paymentType);
                    }
                    continue;
                }
                if (appConfigValuesArray[1].isEmpty()) continue;
                this.modeOfPaymentwithAppConfig(appConfigValuesArray[1], paymentType);
            }
        }
        if (this.getModeOfPaymentMap().isEmpty()) {
            this.modeOfPaymentWithOutAppConfig(paymentType);
        }
    }

    public void modeOfPaymentWithOutAppConfig(String paymentType) {
        if (paymentType.trim().equalsIgnoreCase("Remittance Payment")) {
            this.modeOfPaymentMap.put(MDP_CASH, this.getText("cash.consolidated.cheque"));
        } else {
            this.modeOfPaymentMap.put(MDP_CHEQUE, this.getText(MDP_CHEQUE));
            this.modeOfPaymentMap.put(MDP_CASH, this.getText(MDP_CASH));
            this.modeOfPaymentMap.put(MDP_RTGS, this.getText(MDP_RTGS));
        }
    }

    public void modeOfPaymentwithAppConfig(String appCongifValue, String paymentType) {
        if (paymentType.trim().equalsIgnoreCase("Remittance Payment")) {
            this.modeOfPaymentMap.put(MDP_CASH, this.getText("cash.consolidated.cheque"));
        } else {
            if (appCongifValue.trim().equalsIgnoreCase(MDP_CHEQUE)) {
                this.modeOfPaymentMap.put(MDP_CHEQUE, this.getText(MDP_CHEQUE));
            }
            if (appCongifValue.trim().equalsIgnoreCase(MDP_CASH)) {
                this.modeOfPaymentMap.put(MDP_CASH, this.getText(MDP_CASH));
            }
            if (appCongifValue.trim().equalsIgnoreCase(MDP_RTGS)) {
                this.modeOfPaymentMap.put(MDP_RTGS, this.getText(MDP_RTGS));
            }
        }
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getPaymentid() {
        return this.paymentid;
    }

    public void setPaymentid(String paymentid) {
        this.paymentid = paymentid;
    }

    public String getShowMode() {
        return this.showMode;
    }

    public void setShowMode(String showMode) {
        this.showMode = showMode;
    }

    public String getFinConstExpendTypeContingency() {
        return "Expense";
    }

    public String getFinConstExpendTypePension() {
        return "Pension";
    }

    public SimpleWorkflowService<Paymentheader> getPaymentHeaderWorkflowService() {
        return this.paymentHeaderWorkflowService;
    }

    public void setPaymentHeaderWorkflowService(SimpleWorkflowService<Paymentheader> paymentHeaderWorkflowService) {
        this.paymentHeaderWorkflowService = paymentHeaderWorkflowService;
    }

    public String getBankBalanceCheck() {
        return this.bankBalanceCheck;
    }

    public void setBankBalanceCheck(String bankBalanceCheck) {
        this.bankBalanceCheck = bankBalanceCheck;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Map<String, String> getModeOfPaymentMap() {
        return this.modeOfPaymentMap;
    }

    public void setModeOfPaymentMap(Map<String, String> modeOfPaymentMap) {
        this.modeOfPaymentMap = modeOfPaymentMap;
    }
}

