/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.masters;

import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.egov.egf.web.actions.masters.JQueryGridActionSupport;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infstr.services.Page;
import org.egov.infstr.services.PersistenceService;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Junction;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class JQueryGridActionSupport
extends BaseFormAction {
    @Autowired
    @Qualifier(value="persistenceService")
    protected PersistenceService persistenceService;
    private static final long serialVersionUID = 1L;
    protected static final String ADD = "add";
    protected static final String EDIT = "edit";
    protected static final String DELETE = "del";
    protected Integer id;
    protected String oper;
    private boolean _search;
    private Integer rows;
    private Integer page;
    private String ord;
    private String searchField;
    private String searchString;
    private String searchOper;
    private String sidx;
    private String sord;
    private String filters;
    private Integer totalPages;
    private Integer totalRecords;

    public Object getModel() {
        return null;
    }

    protected Page getPagedResult(Class<?> clazz, String keyFieldName, Object keyFieldValue) {
        Criteria criteria = this.persistenceService.getSession().createCriteria(clazz);
        criteria.add((Criterion)Restrictions.eq((String)keyFieldName, (Object)keyFieldValue));
        this.applySearchCriteriaIfAny(criteria);
        Criteria countCriteria = this.persistenceService.getSession().createCriteria(clazz);
        countCriteria.add((Criterion)Restrictions.eq((String)keyFieldName, (Object)keyFieldValue));
        countCriteria.setProjection(Projections.rowCount());
        this.totalRecords = ((Number)countCriteria.uniqueResult()).intValue();
        return new Page(criteria, this.page, this.rows);
    }

    protected void sendAJAXResponse(String response) {
        try {
            HttpServletResponse httpResponse = ServletActionContext.getResponse();
            PrintWriter httpResponseWriter = httpResponse.getWriter();
            IOUtils.write((String)response, (Writer)httpResponseWriter);
            IOUtils.closeQuietly((Writer)httpResponseWriter);
        }
        catch (IOException e) {
            LOG.error("Error occurred while processing Ajax response", (Throwable)e);
        }
    }

    protected String constructJqGridResponse(String jsonData) {
        return "{\"page\":" + this.page + ",\"total\":" + this.getTotalPages() + ",\"records\":" + this.totalRecords + ",\"rows\":" + jsonData + "}";
    }

    private void applySearchCriteriaIfAny(Criteria criteria) {
        if (this._search) {
            if (StringUtils.isBlank((String)this.filters)) {
                criteria.add(this.applyRestriction());
            } else {
                MultipleSearchFilter multipleSearchFilter = this.getMultiSearchFilter();
                if (multipleSearchFilter.getGroupOp().equals("AND")) {
                    this.applyJunctionCriterion((Junction)Restrictions.conjunction(), criteria, multipleSearchFilter);
                } else if (multipleSearchFilter.getGroupOp().equals("OR")) {
                    this.applyJunctionCriterion((Junction)Restrictions.disjunction(), criteria, multipleSearchFilter);
                }
            }
        }
        criteria.addOrder(this.applyOrderBy());
    }

    private void applyJunctionCriterion(Junction junction, Criteria criteria, MultipleSearchFilter multipleSearchFilter) {
        for (MultipleSearchFilter.Rule rule : multipleSearchFilter.getRules()) {
            this.searchOper = rule.getOp();
            this.searchField = rule.getField();
            this.searchString = rule.getData();
            junction.add(this.applyRestriction());
        }
        criteria.add((Criterion)junction);
    }

    protected Object convertValueType(String searchField, String searchValue) {
        return searchValue;
    }

    private Criterion applyRestriction() {
        Object convertedValue = this.convertValueType(this.searchField, this.searchString);
        if (this.searchOper.equals("eq")) {
            return Restrictions.eq((String)this.searchField, (Object)convertedValue);
        }
        if (this.searchOper.equals("ne")) {
            return Restrictions.ne((String)this.searchField, (Object)convertedValue);
        }
        if (convertedValue instanceof String) {
            if (this.searchOper.equals("bw")) {
                return Restrictions.ilike((String)this.searchField, (Object)(this.searchString + "%"));
            }
            if (this.searchOper.equals("cn")) {
                return Restrictions.ilike((String)this.searchField, (Object)("%" + this.searchString + "%"));
            }
            if (this.searchOper.equals("ew")) {
                return Restrictions.ilike((String)this.searchField, (Object)("%" + this.searchString));
            }
            if (this.searchOper.equals("bn")) {
                return Restrictions.not((Criterion)Restrictions.ilike((String)this.searchField, (Object)(this.searchString + "%")));
            }
            if (this.searchOper.equals("en")) {
                return Restrictions.not((Criterion)Restrictions.ilike((String)this.searchField, (Object)("%" + this.searchString)));
            }
            if (this.searchOper.equals("nc")) {
                return Restrictions.not((Criterion)Restrictions.ilike((String)this.searchField, (Object)("%" + this.searchString + "%")));
            }
            if (this.searchOper.equals("in")) {
                return Restrictions.in((String)this.searchField, (Object[])this.searchString.split(","));
            }
            if (this.searchOper.equals("ni")) {
                return Restrictions.not((Criterion)Restrictions.in((String)this.searchField, (Object[])this.searchString.split(",")));
            }
        } else {
            if (this.searchOper.equals("lt")) {
                return Restrictions.lt((String)this.searchField, (Object)convertedValue);
            }
            if (this.searchOper.equals("le")) {
                return Restrictions.le((String)this.searchField, (Object)convertedValue);
            }
            if (this.searchOper.equals("gt")) {
                return Restrictions.gt((String)this.searchField, (Object)convertedValue);
            }
            if (this.searchOper.equals("ge")) {
                return Restrictions.ge((String)this.searchField, (Object)convertedValue);
            }
        }
        return null;
    }

    private Order applyOrderBy() {
        String orderByField;
        String orderBy = this.sord == null ? this.ord : this.sord;
        String string = orderByField = this.sidx == null ? this.searchField : this.sidx;
        if (orderBy.equals("asc")) {
            return Order.asc((String)orderByField);
        }
        return Order.desc((String)orderByField);
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setRows(Integer rows) {
        this.rows = rows;
    }

    public void setPage(Integer page) {
        this.page = page;
    }

    public void setOrd(String ord) {
        this.ord = ord;
    }

    public void setSearchField(String searchField) {
        this.searchField = searchField;
    }

    public void setSearchString(String searchString) {
        this.searchString = searchString;
    }

    public void setSearchOper(String searchOper) {
        this.searchOper = searchOper;
    }

    public void set_search(boolean _search) {
        this._search = _search;
    }

    public void setSidx(String sidx) {
        this.sidx = sidx;
    }

    public void setSord(String sord) {
        this.sord = sord;
    }

    public void setOper(String oper) {
        this.oper = oper;
    }

    public void setFilters(String filters) {
        this.filters = filters;
    }

    private MultipleSearchFilter getMultiSearchFilter() {
        return (MultipleSearchFilter)new GsonBuilder().create().fromJson(this.filters, MultipleSearchFilter.class);
    }

    private Integer getTotalPages() {
        if (this.totalPages == null) {
            this.totalPages = this.totalRecords / this.rows;
            if (this.totalRecords % this.rows != 0) {
                Integer n = this.totalPages;
                Integer n2 = this.totalPages = Integer.valueOf(this.totalPages + 1);
            }
        }
        return this.totalPages;
    }
}

