/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.budget;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.util.ValueStack;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.egov.commons.CFinancialYear;
import org.egov.commons.CFunction;
import org.egov.commons.Functionary;
import org.egov.commons.Fund;
import org.egov.commons.Scheme;
import org.egov.commons.SubScheme;
import org.egov.commons.dao.FinancialYearHibernateDAO;
import org.egov.egf.model.BudgetAmountView;
import org.egov.eis.service.EisCommonService;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infra.workflow.service.SimpleWorkflowService;
import org.egov.infstr.services.PersistenceService;
import org.egov.infstr.utils.EgovMasterDataCaching;
import org.egov.model.budget.Budget;
import org.egov.model.budget.BudgetDetail;
import org.egov.model.budget.BudgetGroup;
import org.egov.pims.commons.Position;
import org.egov.services.budget.BudgetDetailService;
import org.egov.services.budget.BudgetService;
import org.egov.utils.BudgetDetailConfig;
import org.egov.utils.BudgetDetailHelper;
import org.egov.utils.Constants;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@ParentPackage(value="egov")
@Results(value={@Result(name={"detailList"}, location="budgetSearch-detailList.jsp"), @Result(name={"budgets"}, location="budgetSearch-budgets.jsp"), @Result(name={"list"}, location="budgetSearch-list.jsp")})
public class BudgetSearchAction
extends BaseFormAction {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(BudgetSearchAction.class);
    protected List<String> headerFields = new ArrayList();
    protected List<String> gridFields = new ArrayList();
    protected BudgetDetail budgetDetail = new BudgetDetail();
    private final List<Budget> budgetList = new ArrayList();
    private final List<BudgetDetail> budgetDetailList = new ArrayList();
    protected List<BudgetDetail> savedbudgetDetailList = new ArrayList();
    protected List<BudgetAmountView> budgetAmountView = new ArrayList();
    protected SimpleWorkflowService<BudgetDetail> budgetDetailWorkflowService;
    protected Long financialYear;
    protected List<Budget> budgets;
    protected boolean isApproveAction = false;
    protected String mode;
    protected boolean showButton = true;
    protected EisCommonService eisCommonService;
    protected boolean disableBudget = false;
    BudgetDetailHelper budgetDetailHelper;
    boolean errorMessage = true;
    boolean re;
    protected Budget topBudget = null;
    String message = "";
    protected List<String> mandatoryFields = new ArrayList();
    private Map<Long, String> previuosYearBudgetDetailMap = new TreeMap();
    private Map<Long, String> beforePreviousYearBudgetDetailMap = new TreeMap();
    private Map<String, String> budgetDetailIdsAndAmount = new HashMap();
    private Map<String, String> previousYearBudgetDetailIdsAndAmount = new HashMap();
    private Map<String, String> twopreviousYearBudgetDetailIdsAndAmount = new HashMap();
    protected FinancialYearHibernateDAO financialYearDAO;
    protected String currentfinYearRange = "";
    protected String nextfinYearRange = "";
    private String previousfinYearRange = "";
    private String twopreviousfinYearRange = "";
    private boolean shouldShowREAppropriations = true;
    List<AppConfigValues> excludeList = new ArrayList();
    @Autowired
    @Qualifier(value="persistenceService")
    protected PersistenceService persistenceService;
    @Autowired
    protected BudgetDetailConfig budgetDetailConfig;
    @Autowired
    @Qualifier(value="budgetDetailService")
    protected BudgetDetailService budgetDetailService;
    @Autowired
    @Qualifier(value="budgetService")
    protected BudgetService budgetService;
    @Autowired
    private AppConfigValueService appConfigValuesService;
    @Autowired
    @Qualifier(value="masterDataCache")
    private EgovMasterDataCaching masterDataCache;

    public String getMessage() {
        return this.message;
    }

    public boolean isRe() {
        return this.re;
    }

    public List<AppConfigValues> getExcludeStatusForBudget() {
        this.excludeList = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "exclude_status_forbudget_actual");
        return this.excludeList;
    }

    public boolean isErrorMessage() {
        return this.errorMessage;
    }

    public void setBudgetDetailHelper(BudgetDetailHelper budgetHelper) {
        this.budgetDetailHelper = budgetHelper;
    }

    public BudgetDetailService getBudgetDetailService() {
        return this.budgetDetailService;
    }

    public boolean isDisableBudget() {
        return this.disableBudget;
    }

    public void setDisableBudget(boolean disableBudget) {
        this.disableBudget = disableBudget;
    }

    public List<Budget> getBudgets() {
        return this.budgets;
    }

    public Long getFinancialYear() {
        return this.financialYear == null ? this.budgetDetailHelper.getFinancialYear() : this.financialYear;
    }

    public void setFinancialYear(Long financialYearRange) {
        this.financialYear = financialYearRange;
    }

    public List<BudgetAmountView> getBudgetAmountView() {
        return this.budgetAmountView;
    }

    protected String getMessage(String key) {
        return this.getText(key);
    }

    public List<BudgetDetail> getSavedbudgetDetailList() {
        return this.savedbudgetDetailList;
    }

    public void setBudgetDetailService(BudgetDetailService budgetDetailService) {
        this.budgetDetailService = budgetDetailService;
    }

    public void setBudgetService(BudgetService budgetService) {
        this.budgetService = budgetService;
    }

    public List<Budget> getBudgetList() {
        return this.budgetList;
    }

    public String execute() throws Exception {
        if (this.parameters.containsKey("mode")) {
            this.setMode(((String[])this.parameters.get("mode"))[0]);
        }
        this.errorMessage = false;
        return "list";
    }

    public boolean showbuttons() {
        return this.showButton;
    }

    public void prepare() {
        super.prepare();
        this.headerFields = this.budgetDetailConfig.getHeaderFields();
        this.gridFields = this.budgetDetailConfig.getGridFields();
        this.mandatoryFields = this.budgetDetailConfig.getMandatoryFields();
        this.addRelatedEntity("budget", Budget.class);
        this.addRelatedEntity("budgetGroup", BudgetGroup.class);
        if (this.shouldShowField("functionary")) {
            this.addRelatedEntity("functionary", Functionary.class);
        }
        if (this.shouldShowField("function")) {
            this.addRelatedEntity("function", CFunction.class);
        }
        if (this.shouldShowField("fund")) {
            this.addRelatedEntity("fund", Fund.class);
        }
        if (this.shouldShowField("scheme")) {
            this.addRelatedEntity("scheme", Scheme.class);
        }
        if (this.shouldShowField("subScheme")) {
            this.addRelatedEntity("subScheme", SubScheme.class);
        }
        if (this.shouldShowField("executingDepartment")) {
            this.addRelatedEntity("executingDepartment", Department.class);
        }
        if (this.shouldShowField("boundary")) {
            this.addRelatedEntity("boundary", Boundary.class);
        }
        if (!this.parameters.containsKey("skipPrepare")) {
            this.headerFields = this.budgetDetailConfig.getHeaderFields();
            this.gridFields = this.budgetDetailConfig.getGridFields();
            this.dropdownData.put("budgetGroupList", this.masterDataCache.get("egf-budgetGroup"));
            this.dropdownData.put("budgetList", this.budgetDetailService.findApprovedBudgetsForFY(this.getFinancialYear()));
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"done findApprovedBudgetsForFY");
            }
            this.dropdownData.put("financialYearList", this.persistenceService.findAllBy("from CFinancialYear where isActive=true order by finYearRange desc", new Object[0]));
            if (this.shouldShowField("subScheme")) {
                this.dropdownData.put("subSchemeList", Collections.EMPTY_LIST);
            }
            if (this.shouldShowField("functionary")) {
                this.dropdownData.put("functionaryList", this.masterDataCache.get("egi-functionary"));
            }
            if (this.shouldShowField("function")) {
                this.dropdownData.put("functionList", this.masterDataCache.get("egi-function"));
            }
            if (this.shouldShowField("scheme")) {
                this.dropdownData.put("schemeList", this.persistenceService.findAllBy("from Scheme where isActive=true order by name", new Object[0]));
            }
            if (this.shouldShowField("executingDepartment")) {
                this.dropdownData.put("executingDepartmentList", this.masterDataCache.get("egi-department"));
            }
            if (this.shouldShowField("boundary")) {
                this.dropdownData.put("boundaryList", this.persistenceService.findAllBy("from Boundary order by name", new Object[0]));
            }
            if (this.shouldShowField("fund")) {
                this.dropdownData.put("fundList", this.persistenceService.findAllBy("from Fund where isActive=true order by name", new Object[0]));
            }
        }
    }

    public Object getModel() {
        return this.budgetDetail;
    }

    public String list() {
        if (this.parameters.containsKey("mode") && "approve".equals(((String[])this.parameters.get("mode"))[0])) {
            this.setMode(((String[])this.parameters.get("mode"))[0]);
            this.isApproveAction = true;
            this.disableBudget = true;
        }
        if (this.budgetDetail.getBudget() != null) {
            this.persistenceService.getSession().refresh((Object)this.budgetDetail.getBudget());
            if (this.budgetDetail.getBudget().getFinancialYear() == null) {
                this.budgetDetail.setBudget((Budget)this.budgetService.find("from Budget where id=?", new Object[]{this.budgetDetail.getBudget().getId()}));
            }
            this.financialYear = this.budgetDetail.getBudget().getFinancialYear().getId();
            if (this.isApproveAction) {
                this.budgetList.add(this.budgetService.find("select budget from Budget budget  join budget.state as state where budget.id=? and state.owner=? ", new Object[]{this.budgetDetail.getBudget().getId(), this.getPosition()}));
            } else {
                this.budgetList.add(this.budgetService.find("select budget from Budget budget  join budget.state as state where budget.id=? and state.value=? ", new Object[]{this.budgetDetail.getBudget().getId(), "NEW"}));
            }
        } else {
            List budgetDetails = this.budgetDetailService.searchByCriteriaAndFY(this.financialYear, this.budgetDetail, this.isApproveAction, this.getPosition());
            for (BudgetDetail budgetDetail : budgetDetails) {
                if (this.budgetList.contains(budgetDetail.getBudget())) continue;
                this.budgetList.add(budgetDetail.getBudget());
            }
        }
        this.getSession().put("searchCriteria", this.budgetDetail);
        this.getSession().put("financialyearid", this.financialYear);
        if (this.budgetList.isEmpty()) {
            this.message = this.getText("no.data.found");
        }
        return "list";
    }

    @Action(value="/budget/budgetSearch-groupedBudgets")
    public String groupedBudgets() {
        Budget budget = this.budgetDetail.getBudget();
        this.budgetDetail.setBudget(null);
        if (budget != null && budget.getId() != null && budget.getId() != 0L) {
            this.budgetList.addAll(this.budgetDetailService.findBudgetTree(budget, this.budgetDetail));
        } else if (budget != null && budget.getFinancialYear() != null && budget.getFinancialYear().getId() != null) {
            this.budgetList.addAll(this.budgetDetailService.findBudgetTree(this.budgetDetailService.findApprovedPrimaryParentBudgetForFY(budget.getFinancialYear().getId()), this.budgetDetail));
        }
        this.getSession().put("searchCriteria", this.budgetDetail);
        if (this.budgetList.isEmpty()) {
            this.addActionError(this.getText("budget.no.details.found"));
        }
        return "list";
    }

    public void setBudgetDetail(BudgetDetail budgetDetail) {
        this.budgetDetail = budgetDetail;
    }

    public final boolean shouldShowHeaderField(String field) {
        return this.headerFields.isEmpty() || this.headerFields.contains(field);
    }

    public final boolean shouldShowGridField(String field) {
        return this.gridFields.isEmpty() || this.gridFields.contains(field);
    }

    public boolean showApprovalDetails() {
        boolean result = false;
        String mode = this.getMode();
        if (mode != null && mode.equals("approve")) {
            result = this.isApproveAction = true;
        }
        return result;
    }

    public String budgetDetailList() {
        if (this.parameters.get("budget.id") != null) {
            Budget Budget2 = (Budget)this.budgetService.findById((Serializable)Long.valueOf(((String[])this.parameters.get("budget.id"))[0]), false);
            this.setTopBudget(Budget2);
        }
        BudgetDetail criteria = (BudgetDetail)this.persistenceService.getSession().createCriteria("searchCriteria");
        criteria.setBudget(this.budgetDetail.getBudget());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Before getting List------------------------------------------------------------------------------------");
        }
        this.savedbudgetDetailList = this.budgetDetailService.searchBy(criteria);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("After getting List----------------------------------------------------------------" + this.savedbudgetDetailList.size()));
        }
        this.re = this.checkRe(this.budgetDetail.getBudget());
        this.computeAmounts(this.savedbudgetDetailList);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"After compute-------------------------------------------------------------------------------------------");
        }
        return "detailList";
    }

    public BigDecimal divideAndRoundStrToBigDec(String amountStr) {
        BigDecimal value = new BigDecimal(amountStr);
        value = value.divide(new BigDecimal(1000), 2, 4);
        return value;
    }

    public String divideAndRoundBigDecToString(BigDecimal amount) {
        BigDecimal value = BigDecimal.ZERO;
        value = value.divide(new BigDecimal(1000), 2, 4);
        return value.toString();
    }

    protected boolean checkRe(Budget budget) {
        return budget != null && "RE".equalsIgnoreCase(budget.getIsbere());
    }

    @Action(value="/budget/budgetSearch-groupedBudgetDetailList")
    public String groupedBudgetDetailList() {
        BudgetDetail criteria = new BudgetDetail();
        Budget budget = this.budgetDetail.getBudget();
        if (budget != null && budget.getId() != null) {
            budget = (Budget)this.persistenceService.find("from Budget where id=?", new Object[]{budget.getId()});
            this.currentfinYearRange = budget.getFinancialYear().getFinYearRange();
            this.computePreviousYearRange();
            this.computeTwopreviousYearRange();
        }
        criteria.setBudget(null);
        this.savedbudgetDetailList = this.budgetDetailService.findAllBudgetDetailsWithReAppropriation(budget, criteria);
        this.re = this.checkRe(budget);
        this.computeAmounts(this.savedbudgetDetailList);
        this.populateActualData(budget.getFinancialYear());
        return "detailList";
    }

    protected void computePreviousYearRange() {
        if (StringUtils.isNotBlank((String)this.currentfinYearRange)) {
            String[] list = this.currentfinYearRange.split("-");
            this.previousfinYearRange = this.subtract(list[0]) + "-" + this.subtract(list[1]);
        }
    }

    protected void computeTwopreviousYearRange() {
        this.computePreviousYearRange();
        if (StringUtils.isNotBlank((String)this.previousfinYearRange)) {
            String[] list = this.previousfinYearRange.split("-");
            this.twopreviousfinYearRange = this.subtract(list[0]) + "-" + this.subtract(list[1]);
        }
    }

    protected void computeNextYearRange() {
        if (StringUtils.isNotBlank((String)this.currentfinYearRange)) {
            String[] list = this.currentfinYearRange.split("-");
            this.nextfinYearRange = this.addition(list[0]) + "-" + this.addition(list[1]);
        }
    }

    protected String subtract(String value) {
        int val = Integer.parseInt(value) - 1;
        if (val < 10) {
            return "0" + val;
        }
        return String.valueOf(val);
    }

    protected String addition(String value) {
        int val = Integer.parseInt(value) + 1;
        if (val < 10) {
            return "0" + val;
        }
        return String.valueOf(val);
    }

    protected ValueStack getValueStack() {
        return ActionContext.getContext().getValueStack();
    }

    public void computeAmounts(List<BudgetDetail> budgetDetails) {
        this.budgetAmountView = new ArrayList();
        for (BudgetDetail detail : budgetDetails) {
            BigDecimal approvedAmt;
            BudgetAmountView view = new BudgetAmountView();
            this.budgetAmountView.add(view);
            if (detail.getState() != null) {
                detail.setComment(detail.getState().getExtraInfo());
            }
            BigDecimal bigDecimal = approvedAmt = detail.getApprovedAmount() == null ? BigDecimal.ZERO : this.divideAndRoundStrToBigDec(detail.getApprovedAmount().toString());
            if (this.re) {
                if (this.getConsiderReAppropriationAsSeperate()) {
                    view.setCurrentYearReApproved(this.divideAndRoundBigDecToString(approvedAmt));
                } else {
                    view.setCurrentYearReApproved(this.divideAndRoundBigDecToString(this.calculateTotal(detail)));
                    this.shouldShowREAppropriations = false;
                }
            } else {
                view.setCurrentYearBeApproved(this.divideAndRoundBigDecToString(approvedAmt));
            }
            detail.setAnticipatoryAmount(detail.getAnticipatoryAmount() == null ? BigDecimal.ZERO : this.divideAndRoundStrToBigDec(detail.getAnticipatoryAmount().toString()));
            detail.setOriginalAmount(this.divideAndRoundStrToBigDec(detail.getOriginalAmount().toString()));
        }
    }

    public BigDecimal calculateTotal(BudgetDetail detail) {
        BigDecimal approvedAmount = detail.getApprovedAmount() == null ? BigDecimal.ZERO : detail.getApprovedAmount();
        BigDecimal approvedReAppropriationsTotal = detail.getApprovedReAppropriationsTotal() == null ? BigDecimal.ZERO : detail.getApprovedReAppropriationsTotal();
        return approvedAmount.add(approvedReAppropriationsTotal);
    }

    private void populateActualData(CFinancialYear financialYear) {
        String fromDate = Constants.DDMMYYYYFORMAT2.format(financialYear.getStartingDate());
        String toVoucherDate = Constants.DDMMYYYYFORMAT2.format(new Date());
        List result = this.budgetDetailService.fetchActualsForFYDate(fromDate, toVoucherDate, this.mandatoryFields);
        for (Object[] row : result) {
            this.budgetDetailIdsAndAmount.put(row[0].toString(), row[1].toString());
        }
        fromDate = Constants.DDMMYYYYFORMAT2.format(this.subtractYear(financialYear.getStartingDate()));
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(1, -1);
        String toVoucherDate1 = Constants.DDMMYYYYFORMAT2.format(cal.getTime());
        List previousYearResult = this.budgetDetailService.fetchActualsForFYDate(fromDate, toVoucherDate1, this.mandatoryFields);
        for (Object[] row : previousYearResult) {
            this.previousYearBudgetDetailIdsAndAmount.put(row[0].toString(), row[1].toString());
        }
    }

    public Date subtractYear(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(1, -1);
        return cal.getTime();
    }

    @Action(value="/budget/budgetSearch-ajaxLoadBudget")
    public String ajaxLoadBudget() {
        this.budgets = this.budgetDetailService.findApprovedBudgetsForFY(this.getFinancialYear());
        return "budgets";
    }

    public Position getPosition() throws ApplicationRuntimeException {
        Position pos;
        try {
            pos = this.eisCommonService.getPrimaryAssignmentPositionForEmp(ApplicationThreadLocals.getUserId());
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException("Unable to get Position for the user");
        }
        return pos;
    }

    protected User getUser() {
        User user = (User)this.persistenceService.find("from User where id_user=?", new Object[]{ApplicationThreadLocals.getUserId()});
        return user;
    }

    public void setBudgetDetailWorkflowService(SimpleWorkflowService<BudgetDetail> workflowService) {
        this.budgetDetailWorkflowService = workflowService;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public void setEisCommonService(EisCommonService eisCommonService) {
        this.eisCommonService = eisCommonService;
    }

    public Budget getTopBudget() {
        return this.topBudget;
    }

    public void setTopBudget(Budget topBudget) {
        this.topBudget = topBudget;
    }

    public final boolean shouldShowField(String field) {
        if (this.headerFields.isEmpty() && this.gridFields.isEmpty()) {
            return true;
        }
        return this.shouldShowHeaderField(field) || this.shouldShowGridField(field);
    }

    public void setBudgetDetailIdsAndAmount(Map<String, String> budgetDetailIdsAndAmount) {
        this.budgetDetailIdsAndAmount = budgetDetailIdsAndAmount;
    }

    public Map<String, String> getBudgetDetailIdsAndAmount() {
        return this.budgetDetailIdsAndAmount;
    }

    public void setPreviousYearBudgetDetailIdsAndAmount(Map<String, String> previousYearBudgetDetailIdsAndAmount) {
        this.previousYearBudgetDetailIdsAndAmount = previousYearBudgetDetailIdsAndAmount;
    }

    public Map<String, String> getPreviousYearBudgetDetailIdsAndAmount() {
        return this.previousYearBudgetDetailIdsAndAmount;
    }

    public void setFinancialYearDAO(FinancialYearHibernateDAO financialYearDAO) {
        this.financialYearDAO = financialYearDAO;
    }

    public FinancialYearHibernateDAO getFinancialYearDAO() {
        return this.financialYearDAO;
    }

    public void setCurrentfinYearRange(String currentfinYearRange) {
        this.currentfinYearRange = currentfinYearRange;
    }

    public String getCurrentfinYearRange() {
        return this.currentfinYearRange;
    }

    public void setPreviousfinYearRange(String previousfinYearRange) {
        this.previousfinYearRange = previousfinYearRange;
    }

    public String getPreviousfinYearRange() {
        return this.previousfinYearRange;
    }

    private boolean getConsiderReAppropriationAsSeperate() {
        List appList = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "CONSIDER_RE_REAPPROPRIATION_AS_SEPARATE");
        String appValue = "-1";
        appValue = ((AppConfigValues)appList.get(0)).getValue();
        return "Y".equalsIgnoreCase(appValue);
    }

    public boolean getShouldShowREAppropriations() {
        return this.shouldShowREAppropriations;
    }

    public Map<String, String> getTwopreviousYearBudgetDetailIdsAndAmount() {
        return this.twopreviousYearBudgetDetailIdsAndAmount;
    }

    public void setTwopreviousYearBudgetDetailIdsAndAmount(Map<String, String> twopreviousYearBudgetDetailIdsAndAmount) {
        this.twopreviousYearBudgetDetailIdsAndAmount = twopreviousYearBudgetDetailIdsAndAmount;
    }

    public String getTwopreviousfinYearRange() {
        return this.twopreviousfinYearRange;
    }

    public void setTwopreviousfinYearRange(String twopreviousfinYearRange) {
        this.twopreviousfinYearRange = twopreviousfinYearRange;
    }

    public Map<Long, String> getPreviuosYearBudgetDetailMap() {
        return this.previuosYearBudgetDetailMap;
    }

    public void setPreviuosYearBudgetDetailMap(Map<Long, String> previuosYearBudgetDetailMap) {
        this.previuosYearBudgetDetailMap = previuosYearBudgetDetailMap;
    }

    public Map<Long, String> getBeforePreviousYearBudgetDetailMap() {
        return this.beforePreviousYearBudgetDetailMap;
    }

    public void setBeforePreviousYearBudgetDetailMap(Map<Long, String> beforePreviousYearBudgetDetailMap) {
        this.beforePreviousYearBudgetDetailMap = beforePreviousYearBudgetDetailMap;
    }

    public String getNextfinYearRange() {
        return this.nextfinYearRange;
    }

    public void setNextfinYearRange(String nextfinYearRange) {
        this.nextfinYearRange = nextfinYearRange;
    }

    public AppConfigValueService getAppConfigValuesService() {
        return this.appConfigValuesService;
    }

    public EgovMasterDataCaching getMasterDataCache() {
        return this.masterDataCache;
    }

    public void setAppConfigValuesService(AppConfigValueService appConfigValuesService) {
        this.appConfigValuesService = appConfigValuesService;
    }

    public void setMasterDataCache(EgovMasterDataCaching masterDataCache) {
        this.masterDataCache = masterDataCache;
    }

    public BudgetDetail getBudgetDetail() {
        return this.budgetDetail;
    }
}

