/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.bill;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.egov.commons.EgwStatus;
import org.egov.commons.Functionary;
import org.egov.commons.Fund;
import org.egov.commons.Fundsource;
import org.egov.commons.Scheme;
import org.egov.commons.SubScheme;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infstr.services.PersistenceService;
import org.egov.infstr.utils.EgovMasterDataCaching;
import org.egov.model.bills.EgBillregister;
import org.egov.model.bills.EgBillregistermis;
import org.egov.utils.VoucherHelper;
import org.hibernate.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@ParentPackage(value="egov")
@Results(value={@Result(name={"new"}, location="billRegisterSearch-new.jsp")})
public class BillRegisterSearchAction
extends BaseFormAction {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(BillRegisterSearchAction.class);
    private List<String> headerFields = new ArrayList();
    private List<String> mandatoryFields = new ArrayList();
    private EgBillregister billregister = new EgBillregister();
    private String billDateFrom;
    private String billDateTo;
    private String expType;
    private List<Map<String, Object>> billList;
    @Autowired
    private AppConfigValueService appConfigValueService;
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    @Autowired
    private EgovMasterDataCaching masterDataCache;

    public BillRegisterSearchAction() {
        this.billregister.setEgBillregistermis(new EgBillregistermis());
        this.addRelatedEntity("egBillregistermis.egDepartment", Department.class);
        this.addRelatedEntity("egBillregistermis.fund", Fund.class);
        this.addRelatedEntity("egBillregistermis.scheme", Scheme.class);
        this.addRelatedEntity("egBillregistermis.subScheme", SubScheme.class);
        this.addRelatedEntity("egBillregistermis.functionaryid", Functionary.class);
        this.addRelatedEntity("egBillregistermis.fundsource", Fundsource.class);
        this.addRelatedEntity("egBillregistermis.fieldid", Boundary.class);
    }

    public Object getModel() {
        return this.billregister;
    }

    public void prepare() {
        super.prepare();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"BillRegisterSearchAction | prepare | Start");
        }
        ArrayList<String> expTypeList = new ArrayList<String>();
        expTypeList.add("Expense");
        expTypeList.add("Works");
        expTypeList.add("Purchase");
        expTypeList.add("Advance");
        this.addDropdownData("expType", expTypeList);
        this.getHeaderFields();
        if (this.headerFields.contains("department")) {
            this.addDropdownData("departmentList", this.masterDataCache.get("egi-department"));
        }
        if (this.headerFields.contains("functionary")) {
            this.addDropdownData("functionaryList", this.masterDataCache.get("egi-functionary"));
        }
        if (this.headerFields.contains("fund")) {
            this.addDropdownData("fundList", this.masterDataCache.get("egi-fund"));
        }
        if (this.headerFields.contains("fundsource")) {
            this.addDropdownData("fundsourceList", this.masterDataCache.get("egi-fundSource"));
        }
        if (this.headerFields.contains("field")) {
            this.addDropdownData("fieldList", this.masterDataCache.get("egi-ward"));
        }
        if (this.headerFields.contains("scheme")) {
            this.addDropdownData("schemeList", Collections.EMPTY_LIST);
        }
        if (this.headerFields.contains("subscheme")) {
            this.addDropdownData("subschemeList", Collections.EMPTY_LIST);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"BillRegisterSearchAction | prepare | End");
        }
    }

    @Action(value="/bill/billRegisterSearch-newform")
    public String newform() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"BillRegisterSearchAction | newform | Start");
        }
        return "new";
    }

    @Action(value="/bill/billRegisterSearch-search")
    public String search() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"BillRegisterSearchAction | search | Start");
        }
        StringBuffer query = new StringBuffer(500);
        query.append("select br.expendituretype , br.billtype ,br.billnumber , br.billdate , br.billamount , br.passedamount ,egwstatus.description,billmis.sourcePath,").append(" br.id ,br.status.id,egwstatus.description ,br.state.id,br.lastModifiedBy.id ").append(" from EgBillregister br, EgBillregistermis billmis , EgwStatus egwstatus where   billmis.egBillregister.id = br.id and egwstatus.id = br.status.id  ").append(" and br.expendituretype=?").append(VoucherHelper.getBillDateQuery((String)this.billDateFrom, (String)this.billDateTo)).append(VoucherHelper.getBillMisQuery((EgBillregister)this.billregister));
        List list = this.persistenceService.findAllBy(query.toString(), new Object[]{this.expType});
        ArrayList<Long> stateIds = new ArrayList<Long>();
        HashMap<Long, String> stateIdAndOwnerNameMap = new HashMap<Long, String>();
        for (Object object : list) {
            stateIds.add(this.getLongValue(object[11]));
        }
        List oWnerNamesList = new ArrayList();
        if (stateIds != null && stateIds.size() > 0) {
            oWnerNamesList = this.getOwnersForWorkFlowState(stateIds);
        }
        for (Object[] owner : oWnerNamesList) {
            if (stateIdAndOwnerNameMap.containsKey(this.getLongValue(owner[1]))) continue;
            stateIdAndOwnerNameMap.put(this.getLongValue(owner[1]), this.getStringValue(owner[0]));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Total number of bills found =: " + list.size()));
        }
        if (list.size() != 0) {
            this.billList = new ArrayList();
            for (Object[] object : list) {
                HashMap<String, Object> billMap = new HashMap<String, Object>();
                billMap.put("expendituretype", object[0].toString());
                String billtype = "";
                if (object[1] != null) {
                    billtype = object[1].toString();
                }
                billMap.put("billtype", billtype);
                billMap.put("billnumber", object[2].toString());
                billMap.put("billdate", object[3]);
                billMap.put("billamount", object[4]);
                billMap.put("passedamount", object[5]);
                billMap.put("billstatus", object[6].toString());
                if (null != object[7]) {
                    billMap.put("sourcepath", object[7].toString());
                } else {
                    billMap.put("sourcepath", "/EGF/bill/billView-view.action?billId=" + object[8].toString());
                }
                if (object[11] != null) {
                    if (!this.getStringValue(object[10]).equalsIgnoreCase("Approved") && !this.getStringValue(object[10]).equalsIgnoreCase("Cancelled")) {
                        billMap.put("ownerName", stateIdAndOwnerNameMap.get(this.getLongValue(object[11])) != null ? stateIdAndOwnerNameMap.get(this.getLongValue(object[11])) : "-");
                    } else {
                        billMap.put("ownerName", "-");
                    }
                } else {
                    billMap.put("ownerName", "-");
                }
                this.billList.add(billMap);
            }
        } else {
            this.billList = new ArrayList();
        }
        return "new";
    }

    private List<Object[]> getOwnersForWorkFlowState(List<Long> stateIds) {
        ArrayList<Object[]> ownerNamesList = new ArrayList();
        String ownerNamesQueryStr = "select a.employee.username,bill.state.id from Assignment a,State state, EgBillregister bill where  bill.state.id=state.id and a.position.id = state.ownerPosition.id and bill.state.id in (:IDS)";
        int size = stateIds.size();
        if (size > 999) {
            Query ownerNamesQuery;
            List newGLDList;
            int fromIndex = 0;
            int toIndex = 0;
            int step = 1000;
            while (size - 1000 >= 0) {
                newGLDList = new ArrayList();
                ownerNamesQuery = this.persistenceService.getSession().createQuery("select a.employee.username,bill.state.id from Assignment a,State state, EgBillregister bill where  bill.state.id=state.id and a.position.id = state.ownerPosition.id and bill.state.id in (:IDS)");
                ownerNamesQuery.setParameterList("IDS", stateIds.subList(fromIndex, toIndex += 1000));
                newGLDList = ownerNamesQuery.list();
                fromIndex = toIndex;
                size -= 1000;
                if (newGLDList == null) continue;
                ownerNamesList.addAll(newGLDList);
            }
            if (size > 0) {
                newGLDList = new ArrayList();
                fromIndex = toIndex;
                toIndex = fromIndex + size;
                ownerNamesQuery = this.persistenceService.getSession().createQuery("select a.employee.username,bill.state.id from Assignment a,State state, EgBillregister bill where  bill.state.id=state.id and a.position.id = state.ownerPosition.id and bill.state.id in (:IDS)");
                ownerNamesQuery.setParameterList("IDS", stateIds.subList(fromIndex, toIndex));
                newGLDList = ownerNamesQuery.list();
                if (newGLDList != null) {
                    ownerNamesList.addAll(newGLDList);
                }
            }
        } else {
            ownerNamesList = this.persistenceService.getSession().createQuery("select a.employee.username,bill.state.id from Assignment a,State state, EgBillregister bill where  bill.state.id=state.id and a.position.id = state.ownerPosition.id and bill.state.id in (:IDS)").setParameterList("IDS", stateIds).list();
        }
        return ownerNamesList;
    }

    public EgwStatus getStatusId(String moduleType, Integer statusid) {
        String statusQury = "from EgwStatus where upper(moduletype)=upper('" + moduleType + "') and  id=" + statusid;
        EgwStatus egwStatus = (EgwStatus)this.persistenceService.find(statusQury);
        return egwStatus;
    }

    protected void getHeaderFields() {
        List appConfigList = this.appConfigValueService.getConfigValuesByModuleAndKey("EGF", "DEFAULT_SEARCH_MISATTRRIBUTES");
        for (AppConfigValues appConfigVal : appConfigList) {
            String value = appConfigVal.getValue();
            String header = value.substring(0, value.indexOf(124));
            this.headerFields.add(header);
            String mandate = value.substring(value.indexOf(124) + 1);
            if (!mandate.equalsIgnoreCase("M")) continue;
            this.mandatoryFields.add(header);
        }
    }

    public void setMandatoryFields(List<String> mandatoryFields) {
        this.mandatoryFields = mandatoryFields;
    }

    public boolean isFieldMandatory(String field) {
        return this.mandatoryFields.contains(field);
    }

    public boolean shouldShowHeaderField(String field) {
        return this.headerFields.contains(field);
    }

    public void setBillregister(EgBillregister billregister) {
        this.billregister = billregister;
    }

    public void setExpType(String expType) {
        this.expType = expType;
    }

    public void setBillDateFrom(String billDateFrom) {
        this.billDateFrom = billDateFrom;
    }

    public void setBillDateTo(String billDateTo) {
        this.billDateTo = billDateTo;
    }

    public void setBillList(List<Map<String, Object>> billList) {
        this.billList = billList;
    }

    public String getBillDateFrom() {
        return this.billDateFrom;
    }

    public String getBillDateTo() {
        return this.billDateTo;
    }

    public String getExpType() {
        return this.expType;
    }

    public List<Map<String, Object>> getBillList() {
        return this.billList;
    }

    public void setHeaderFields(List<String> headerFields) {
        this.headerFields = headerFields;
    }

    private Long getLongValue(Object object) {
        return object != null ? new Long(object.toString()) : 0L;
    }

    private String getStringValue(Object object) {
        return object != null ? object.toString() : "";
    }
}

