/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.controller.bank;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.List;
import javax.validation.Valid;
import org.egov.commons.Bank;
import org.egov.egf.commons.bank.service.CreateBankService;
import org.egov.egf.web.controller.bank.adaptor.BankJsonAdaptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/bank"})
public class BankController {
    private static final String BANK = "bank";
    @Autowired
    private CreateBankService createBankService;
    @Autowired
    private MessageSource messageSource;

    @RequestMapping(value={"/new"}, method={RequestMethod.GET})
    public String newForm(Model model) {
        model.addAttribute(BANK, (Object)new Bank());
        return "bank-new";
    }

    @RequestMapping(value={"/edit/{id}"}, method={RequestMethod.GET})
    public String edit(@PathVariable(value="id") Integer id, Model model) {
        Bank bank = this.createBankService.getById(id);
        model.addAttribute(BANK, (Object)bank);
        return "bank-update";
    }

    @RequestMapping(value={"/view/{id}"}, method={RequestMethod.GET})
    public String view(@PathVariable(value="id") Integer id, Model model) {
        Bank bank = this.createBankService.getById(id);
        model.addAttribute(BANK, (Object)bank);
        return "bank-view";
    }

    @RequestMapping(value={"/search/{mode}"}, method={RequestMethod.GET})
    public String search(@PathVariable(value="mode") String mode, Model model) {
        Bank bank = new Bank();
        model.addAttribute(BANK, (Object)bank);
        return "bank-search";
    }

    @RequestMapping(value={"/success/{id}"}, method={RequestMethod.GET})
    public String success(@PathVariable(value="id") Integer id, Model model) {
        Bank bank = this.createBankService.getById(id);
        model.addAttribute(BANK, (Object)bank);
        return "bank-success";
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String create(@Valid @ModelAttribute Bank bank, BindingResult errors, Model model, RedirectAttributes redirectAttrs) {
        if (errors.hasErrors()) {
            return "bank-new";
        }
        this.createBankService.create(bank);
        redirectAttrs.addFlashAttribute("message", (Object)this.messageSource.getMessage("msg.bank.success", null, null));
        return "redirect:/bank/success/" + bank.getId();
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public String update(@Valid @ModelAttribute Bank bank, BindingResult errors, Model model, RedirectAttributes redirectAttrs) {
        if (errors.hasErrors()) {
            return "bank-update";
        }
        this.createBankService.update(bank);
        redirectAttrs.addFlashAttribute("message", (Object)this.messageSource.getMessage("msg.bank.success", null, null));
        return "redirect:/bank/success/" + bank.getId();
    }

    @RequestMapping(value={"/ajaxsearch/{mode}"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String ajaxsearch(@PathVariable(value="mode") String mode, Model model, @ModelAttribute Bank bank) {
        List searchResultList = this.createBankService.search(bank);
        return "{ \"data\":" + this.toSearchResultJson((Object)searchResultList) + "}";
    }

    public Object toSearchResultJson(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(Bank.class, (Object)new BankJsonAdaptor()).create();
        return gson.toJson(object);
    }
}

