/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.report;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.egov.commons.CChartOfAccounts;
import org.egov.commons.CVoucherHeader;
import org.egov.commons.EgwStatus;
import org.egov.commons.Functionary;
import org.egov.commons.Fund;
import org.egov.commons.Fundsource;
import org.egov.commons.Scheme;
import org.egov.commons.SubScheme;
import org.egov.commons.Vouchermis;
import org.egov.deduction.model.EgRemittance;
import org.egov.egf.model.BillRegisterReportBean;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.config.persistence.datasource.routing.annotation.ReadOnly;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.web.struts.actions.SearchFormAction;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.infra.web.utils.EgovPaginatedList;
import org.egov.infstr.search.SearchQuery;
import org.egov.infstr.search.SearchQuerySQL;
import org.egov.infstr.services.PersistenceService;
import org.egov.infstr.utils.EgovMasterDataCaching;
import org.egov.model.bills.Miscbilldetail;
import org.egov.model.instrument.InstrumentVoucher;
import org.egov.model.payment.Paymentheader;
import org.egov.utils.FinancialConstants;
import org.hibernate.FlushMode;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@ParentPackage(value="egov")
@Results(value={@Result(name={"new"}, location="billRegisterReport-new.jsp"), @Result(name={"completeBill"}, location="billRegisterReport-completeBill.jsp")})
public class BillRegisterReportAction
extends SearchFormAction {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(BillRegisterReportAction.class);
    public static final Locale LOCALE = new Locale("en", "IN");
    public static final SimpleDateFormat DDMMYYYYFORMATS = new SimpleDateFormat("dd/MM/yyyy", LOCALE);
    private final List<String> headerFields = new ArrayList();
    private final List<String> mandatoryFields = new ArrayList();
    private CVoucherHeader voucherHeader = new CVoucherHeader();
    private static Map<String, List<String>> netAccountCode = new HashMap();
    private Date fromDate;
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    @Autowired
    private AppConfigValueService appConfigValueService;
    private Date toDate;
    private String exptype;
    private Long preVoucherId;
    private String billType;
    private String billNumber;
    private boolean isCompleteBillRegisterReport = false;
    private final String chqdelimitSP = "/";
    private final String chqdelimitDP = "//";
    private List<BillRegisterReportBean> billRegReportList;
    private List<String> chequeStatusCheckList = new ArrayList();
    StringBuffer getRemiitPaymentVoucherQry = new StringBuffer("");
    List<Integer> cancelledChequeStatus = new ArrayList();
    private static boolean errorState = false;
    @Autowired
    private EgovMasterDataCaching masterDataCache;

    public BillRegisterReportAction() {
        this.voucherHeader.setVouchermis(new Vouchermis());
        this.addRelatedEntity("vouchermis.departmentid", Department.class);
        this.addRelatedEntity("fundId", Fund.class);
        this.addRelatedEntity("vouchermis.schemeid", Scheme.class);
        this.addRelatedEntity("vouchermis.subschemeid", SubScheme.class);
        this.addRelatedEntity("vouchermis.functionary", Functionary.class);
        this.addRelatedEntity("vouchermis.divisionid", Boundary.class);
        this.addRelatedEntity("fundsourceId", Fundsource.class);
        this.chequeStatusCheckList.add("Dishonored");
        this.chequeStatusCheckList.add("Surrender_For_Reassign");
        this.chequeStatusCheckList.add("Surrendered");
        this.chequeStatusCheckList.add("Cancelled");
        this.getRemiitPaymentVoucherQry.append("select  distinct rm from EgRemittance rm join rm.egRemittanceDetail rdtl  where rdtl.egRemittanceGldtl.generalledgerdetail.generalLedgerId.voucherHeaderId.voucherNumber =?and rdtl.egRemittanceGldtl.generalledgerdetail.generalLedgerId.voucherHeaderId.status!=? and rm.voucherheader.status!=?").append(" order by rm.voucherheader.id");
    }

    public SearchQuery prepareQuery(String sortField, String sortOrder) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"BillRegisterReportAction | prepare | start");
        }
        String query = this.getQuery();
        if (null != sortField) {
            query = query + " order by " + sortField + " " + sortOrder;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("BillRegisterReportAction | prepare | query >> " + query));
        }
        return new SearchQuerySQL(query, "select count(*) from ( " + query + " ) as count", null);
    }

    public Object getModel() {
        return this.voucherHeader;
    }

    @Action(value="/report/billRegisterReport-newform")
    public String newform() {
        this.persistenceService.getSession().setDefaultReadOnly(true);
        this.persistenceService.getSession().setFlushMode(FlushMode.MANUAL);
        this.isCompleteBillRegisterReport = false;
        this.loadDropdownData();
        this.fromDate = null;
        this.toDate = null;
        this.voucherHeader.reset();
        this.billType = null;
        this.exptype = null;
        if (errorState) {
            this.addActionError(this.getText("bill.register.report.system.error"));
        }
        return "new";
    }

    @Action(value="/report/billRegisterReport-searchform")
    public String searchform() {
        this.persistenceService.getSession().setDefaultReadOnly(true);
        this.persistenceService.getSession().setFlushMode(FlushMode.MANUAL);
        this.isCompleteBillRegisterReport = true;
        this.loadDropdownData();
        this.fromDate = null;
        this.toDate = null;
        this.voucherHeader.reset();
        this.billType = null;
        this.exptype = null;
        if (errorState) {
            this.addActionError(this.getText("bill.register.report.system.error"));
        }
        return "completeBill";
    }

    @ValidationErrorPage(value="new")
    public String list() throws Exception {
        this.persistenceService.getSession().setDefaultReadOnly(true);
        this.persistenceService.getSession().setFlushMode(FlushMode.MANUAL);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"BillRegisterReportAction | list | start");
        }
        this.setPageSize(50);
        this.loadDropdownData();
        this.validateBeforeSearch();
        this.search();
        this.formatSearchResult();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"BillRegisterReportAction | list | End");
        }
        return "new";
    }

    @ReadOnly
    @ValidationErrorPage(value="completeBill")
    @Action(value="/report/billRegisterReport-billSearch")
    public String billSearch() throws Exception {
        this.persistenceService.getSession().setDefaultReadOnly(true);
        this.persistenceService.getSession().setFlushMode(FlushMode.MANUAL);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"BillRegisterReportAction | completeBill | start");
        }
        this.isCompleteBillRegisterReport = true;
        this.setPageSize(50);
        this.loadDropdownData();
        this.validateBeforeSearch();
        this.search();
        this.formatSearchResult();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"BillRegisterReportAction | list | End");
        }
        return "completeBill";
    }

    public void validateBeforeSearch() {
        if (null != this.fromDate && null != this.toDate && this.fromDate.after(this.toDate)) {
            throw new ValidationException(Arrays.asList(new ValidationError("date", "from date can not be greater than to date")));
        }
        if (((List)this.dropdownData.get("expenditureList")).size() == 0) {
            throw new ValidationException(Arrays.asList(new ValidationError("date", "There is no Bill present in the system")));
        }
        if (this.isCompleteBillRegisterReport && null != this.billNumber && !this.billNumber.equals("") && null != this.voucherHeader.getVoucherNumber() && !this.voucherHeader.equals("") && !StringUtils.isEmpty((String)this.voucherHeader.getVoucherNumber())) {
            throw new ValidationException(Arrays.asList(new ValidationError("VoucherNumber", "Enter either Voucher number or Bill number")));
        }
    }

    public boolean shouldShowHeaderField(String field) {
        return this.headerFields.contains(field);
    }

    public boolean isFieldMandatory(String field) {
        return this.mandatoryFields.contains(field);
    }

    protected void formatSearchResult() throws Exception {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"BillRegisterReportAction | formatSearchResult | start");
        }
        this.billRegReportList = new ArrayList();
        EgovPaginatedList egovPaginatedList = (EgovPaginatedList)this.searchResult;
        List list = egovPaginatedList.getList();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("BillRegisterReportAction | formatSearchResult | list size : " + list.size()));
        }
        for (Object[] object : list) {
            try {
                BillRegisterReportBean billRegReport = new BillRegisterReportBean();
                billRegReport.setBillNumber(object[0].toString());
                billRegReport.setVoucherNumber(object[1] != null ? object[1].toString() : "");
                billRegReport.setPartyName(object[2] != null ? object[2].toString() : "");
                billRegReport.setGrossAmount(null != object[3] ? new BigDecimal(object[3].toString()).setScale(2, 6) : BigDecimal.ZERO.setScale(2, 6));
                billRegReport.setNetAmount(null != object[4] ? new BigDecimal(object[4].toString()).setScale(2, 6) : BigDecimal.ZERO.setScale(2, 6));
                billRegReport.setDeductionAmount(billRegReport.getGrossAmount().subtract(billRegReport.getNetAmount()));
                billRegReport.setStatus(null != object[5] ? object[5].toString().toUpperCase() : "");
                billRegReport.setBillDate(DDMMYYYYFORMATS.format((Date)object[6]));
                if (!StringUtils.isEmpty((String)billRegReport.getVoucherNumber())) {
                    List miscBillList = this.persistenceService.findAllBy(" from Miscbilldetail mis where mis.billnumber=?  and mis.billVoucherHeader.voucherNumber=?", new Object[]{billRegReport.getBillNumber(), billRegReport.getVoucherNumber()});
                    if (null != miscBillList && miscBillList.size() > 0) {
                        BigDecimal paidAmount = null;
                        StringBuffer payMentVoucherNumber = new StringBuffer("");
                        StringBuffer chequeNoAndDate = new StringBuffer("");
                        this.preVoucherId = ((Miscbilldetail)miscBillList.get(0)).getPayVoucherHeader().getId();
                        for (Miscbilldetail miscbilldetail : miscBillList) {
                            if (null != miscbilldetail.getPayVoucherHeader() && (miscbilldetail.getPayVoucherHeader().getStatus().equals((int)FinancialConstants.CREATEDVOUCHERSTATUS) || miscbilldetail.getPayVoucherHeader().getStatus().equals((int)FinancialConstants.PREAPPROVEDVOUCHERSTATUS))) {
                                List instrumentVoucherList;
                                Query qry;
                                Paymentheader paymentMode;
                                if (!StringUtils.isEmpty((String)payMentVoucherNumber.toString())) {
                                    payMentVoucherNumber.append("|").append(miscbilldetail.getPayVoucherHeader().getVoucherNumber());
                                    paidAmount = paidAmount.add(miscbilldetail.getPaidamount()).setScale(2, 6);
                                    paymentMode = (Paymentheader)this.persistenceService.find("from Paymentheader where voucherheader=?", new Object[]{miscbilldetail.getPayVoucherHeader()});
                                    if (!paymentMode.getType().equals("rtgs")) {
                                        qry = this.persistenceService.getSession().createQuery("from InstrumentVoucher iv where iv.voucherHeaderId.id=:vhId and iv.instrumentHeaderId.statusId.id not in(:cancelledChequeList)");
                                        qry.setLong("vhId", miscbilldetail.getPayVoucherHeader().getId().longValue());
                                        qry.setParameterList("cancelledChequeList", (Collection)this.cancelledChequeStatus);
                                        instrumentVoucherList = qry.list();
                                        if (instrumentVoucherList.size() > 0) {
                                            for (InstrumentVoucher inst : instrumentVoucherList) {
                                                if (!StringUtils.isEmpty((String)chequeNoAndDate.toString())) {
                                                    if (this.preVoucherId.equals(inst.getVoucherHeaderId().getId())) {
                                                        chequeNoAndDate.append("/").append(inst.getInstrumentHeaderId().getInstrumentNumber()).append(" ").append(DDMMYYYYFORMATS.format(inst.getInstrumentHeaderId().getInstrumentDate()));
                                                        continue;
                                                    }
                                                    chequeNoAndDate.append("//").append(inst.getInstrumentHeaderId().getInstrumentNumber()).append(" ").append(DDMMYYYYFORMATS.format(inst.getInstrumentHeaderId().getInstrumentDate()));
                                                    continue;
                                                }
                                                chequeNoAndDate.append(inst.getInstrumentHeaderId().getInstrumentNumber()).append(" ").append(DDMMYYYYFORMATS.format(inst.getInstrumentHeaderId().getInstrumentDate()));
                                            }
                                        }
                                    } else {
                                        qry = this.persistenceService.getSession().createQuery("from InstrumentVoucher iv where iv.voucherHeaderId.id=:vhId and iv.instrumentHeaderId.statusId.id not in(:cancelledChequeList)");
                                        qry.setLong("vhId", miscbilldetail.getPayVoucherHeader().getId().longValue());
                                        qry.setParameterList("cancelledChequeList", (Collection)this.cancelledChequeStatus);
                                        instrumentVoucherList = qry.list();
                                        if (instrumentVoucherList.size() > 0) {
                                            for (InstrumentVoucher inst : instrumentVoucherList) {
                                                if (!StringUtils.isEmpty((String)chequeNoAndDate.toString())) {
                                                    if (this.preVoucherId.equals(inst.getVoucherHeaderId().getId())) {
                                                        chequeNoAndDate.append("/").append(inst.getInstrumentHeaderId().getTransactionNumber() != null ? inst.getInstrumentHeaderId().getTransactionNumber() : "").append(" ").append(inst.getInstrumentHeaderId().getTransactionDate() != null ? DDMMYYYYFORMATS.format(inst.getInstrumentHeaderId().getTransactionDate()) : "");
                                                        continue;
                                                    }
                                                    chequeNoAndDate.append("//").append(inst.getInstrumentHeaderId().getTransactionNumber() != null ? inst.getInstrumentHeaderId().getTransactionNumber() : "").append(" ").append(inst.getInstrumentHeaderId().getTransactionDate() != null ? DDMMYYYYFORMATS.format(inst.getInstrumentHeaderId().getTransactionDate()) : "");
                                                    continue;
                                                }
                                                chequeNoAndDate.append(inst.getInstrumentHeaderId().getTransactionNumber() != null ? inst.getInstrumentHeaderId().getTransactionNumber() : "").append(" ").append(inst.getInstrumentHeaderId().getTransactionDate() != null ? DDMMYYYYFORMATS.format(inst.getInstrumentHeaderId().getTransactionDate()) : "");
                                            }
                                        }
                                    }
                                } else {
                                    paidAmount = miscbilldetail.getPaidamount().setScale(2, 6);
                                    payMentVoucherNumber.append(miscbilldetail.getPayVoucherHeader().getVoucherNumber());
                                    paymentMode = (Paymentheader)this.persistenceService.find("from Paymentheader where voucherheader=?", new Object[]{miscbilldetail.getPayVoucherHeader()});
                                    if (!paymentMode.getType().equals("rtgs")) {
                                        qry = this.persistenceService.getSession().createQuery("from InstrumentVoucher iv where iv.voucherHeaderId.id=:vhId and iv.instrumentHeaderId.statusId.id not in(:cancelledChequeList)");
                                        qry.setLong("vhId", miscbilldetail.getPayVoucherHeader().getId().longValue());
                                        qry.setParameterList("cancelledChequeList", (Collection)this.cancelledChequeStatus);
                                        instrumentVoucherList = qry.list();
                                        if (instrumentVoucherList.size() > 0) {
                                            for (InstrumentVoucher inst : instrumentVoucherList) {
                                                if (!StringUtils.isEmpty((String)chequeNoAndDate.toString())) {
                                                    if (this.preVoucherId.equals(inst.getVoucherHeaderId().getId())) {
                                                        chequeNoAndDate.append("/").append(inst.getInstrumentHeaderId().getInstrumentNumber()).append(" ").append(DDMMYYYYFORMATS.format(inst.getInstrumentHeaderId().getInstrumentDate()));
                                                        continue;
                                                    }
                                                    chequeNoAndDate.append("//").append(inst.getInstrumentHeaderId().getInstrumentNumber()).append(" ").append(inst.getInstrumentHeaderId().getInstrumentDate() != null ? DDMMYYYYFORMATS.format(inst.getInstrumentHeaderId().getInstrumentDate()) : "");
                                                    continue;
                                                }
                                                chequeNoAndDate.append(inst.getInstrumentHeaderId().getInstrumentNumber()).append(" ").append(inst.getInstrumentHeaderId().getInstrumentDate() != null ? DDMMYYYYFORMATS.format(inst.getInstrumentHeaderId().getInstrumentDate()) : "");
                                            }
                                        }
                                    } else {
                                        qry = this.persistenceService.getSession().createQuery("from InstrumentVoucher iv where iv.voucherHeaderId.id=:vhId and iv.instrumentHeaderId.statusId.id not in(:cancelledChequeList)");
                                        qry.setLong("vhId", miscbilldetail.getPayVoucherHeader().getId().longValue());
                                        qry.setParameterList("cancelledChequeList", (Collection)this.cancelledChequeStatus);
                                        instrumentVoucherList = qry.list();
                                        if (instrumentVoucherList.size() > 0) {
                                            for (InstrumentVoucher inst : instrumentVoucherList) {
                                                if (!StringUtils.isEmpty((String)chequeNoAndDate.toString())) {
                                                    if (this.preVoucherId.equals(inst.getVoucherHeaderId().getId())) {
                                                        chequeNoAndDate.append("/").append(inst.getInstrumentHeaderId().getTransactionNumber() != null ? inst.getInstrumentHeaderId().getTransactionNumber() : "").append(" ").append(inst.getInstrumentHeaderId().getTransactionDate() != null ? DDMMYYYYFORMATS.format(inst.getInstrumentHeaderId().getTransactionDate()) : "");
                                                        continue;
                                                    }
                                                    chequeNoAndDate.append("//").append(inst.getInstrumentHeaderId().getTransactionNumber() != null ? inst.getInstrumentHeaderId().getTransactionNumber() : "").append(" ").append(inst.getInstrumentHeaderId().getTransactionDate() != null ? DDMMYYYYFORMATS.format(inst.getInstrumentHeaderId().getTransactionDate()) : "");
                                                    continue;
                                                }
                                                chequeNoAndDate.append(inst.getInstrumentHeaderId().getTransactionNumber() != null ? inst.getInstrumentHeaderId().getTransactionNumber() : "").append(" ").append(inst.getInstrumentHeaderId().getTransactionDate() != null ? DDMMYYYYFORMATS.format(inst.getInstrumentHeaderId().getTransactionDate()) : "");
                                            }
                                        }
                                    }
                                }
                            }
                            this.preVoucherId = miscbilldetail.getPayVoucherHeader().getId();
                            if (!this.isCompleteBillRegisterReport) continue;
                            this.getRemittancePaymentDetail(billRegReport);
                        }
                        billRegReport.setPaidAmount(paidAmount);
                        billRegReport.setPaymentVoucherNumber(payMentVoucherNumber.toString());
                        billRegReport.setChequeNumAndDate(chequeNoAndDate.toString());
                    } else if (this.isCompleteBillRegisterReport) {
                        this.getRemittancePaymentDetail(billRegReport);
                    }
                }
                this.billRegReportList.add(billRegReport);
            }
            catch (Exception e) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Failed while processing bill number :" + object[0].toString()));
                }
                throw e;
            }
        }
        egovPaginatedList.setList(this.billRegReportList);
    }

    private void getRemittancePaymentDetail(BillRegisterReportBean billRegReport) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"...........Getting Remitance Payment details........");
        }
        List remittancePaymentItem = new ArrayList();
        StringBuffer remmitPaymentVoucherNumber = new StringBuffer("");
        StringBuffer remittanceChequeNoAndDate = new StringBuffer("");
        Long paymentVhId = null;
        List instrumentVoucherList = new ArrayList();
        if (billRegReport.getVoucherNumber() != null) {
            remittancePaymentItem = this.persistenceService.findAllBy(this.getRemiitPaymentVoucherQry.toString(), new Object[]{billRegReport.getVoucherNumber(), FinancialConstants.CANCELLEDVOUCHERSTATUS, FinancialConstants.CANCELLEDVOUCHERSTATUS});
            if (remittancePaymentItem.size() > 0) {
                paymentVhId = ((EgRemittance)remittancePaymentItem.get(0)).getVoucherheader().getId();
                remittanceChequeNoAndDate = new StringBuffer("");
                for (int i = 0; i < remittancePaymentItem.size(); ++i) {
                    remmitPaymentVoucherNumber.append(((EgRemittance)remittancePaymentItem.get(i)).getVoucherheader().getVoucherNumber() + "|");
                    Query qry = this.persistenceService.getSession().createQuery("from InstrumentVoucher iv where iv.voucherHeaderId.id=:vhId and iv.instrumentHeaderId.statusId.id not in(:cancelledChequeList)");
                    qry.setLong("vhId", ((EgRemittance)remittancePaymentItem.get(i)).getVoucherheader().getId().longValue());
                    qry.setParameterList("cancelledChequeList", (Collection)this.cancelledChequeStatus);
                    instrumentVoucherList = qry.list();
                    if (instrumentVoucherList.size() > 0) {
                        for (InstrumentVoucher inst : instrumentVoucherList) {
                            if (!StringUtils.isEmpty((String)remittanceChequeNoAndDate.toString())) {
                                if (paymentVhId != null && paymentVhId.equals(inst.getVoucherHeaderId().getId())) {
                                    remittanceChequeNoAndDate.append("/").append(inst.getInstrumentHeaderId().getInstrumentNumber()).append(" ").append(inst.getInstrumentHeaderId().getInstrumentDate() != null ? DDMMYYYYFORMATS.format(inst.getInstrumentHeaderId().getInstrumentDate()) : "");
                                    continue;
                                }
                                remittanceChequeNoAndDate.append("//").append(inst.getInstrumentHeaderId().getInstrumentNumber()).append(" ").append(inst.getInstrumentHeaderId().getInstrumentDate() != null ? DDMMYYYYFORMATS.format(inst.getInstrumentHeaderId().getInstrumentDate()) : "");
                                continue;
                            }
                            remittanceChequeNoAndDate.append(inst.getInstrumentHeaderId().getInstrumentNumber()).append(" ").append(inst.getInstrumentHeaderId().getInstrumentDate() != null ? DDMMYYYYFORMATS.format(inst.getInstrumentHeaderId().getInstrumentDate()) : "");
                        }
                    }
                    paymentVhId = ((EgRemittance)remittancePaymentItem.get(i)).getVoucherheader().getId();
                }
            }
            billRegReport.setRemittanceVoucherNumber(remmitPaymentVoucherNumber.length() > 0 ? remmitPaymentVoucherNumber.substring(0, remmitPaymentVoucherNumber.length() - 1) : " ");
            billRegReport.setRemittanceChequeNumberAndDate(remittanceChequeNoAndDate.toString());
        }
    }

    public void netAccountCodeValue() {
        block16: {
            Session session = this.persistenceService.getSession();
            try {
                String coaQuery;
                List cBillNetPurpose = this.appConfigValueService.getConfigValuesByModuleAndKey("EGF", "contingencyBillPurposeIds");
                ArrayList<String> cBillNetPayCodeList = new ArrayList<String>();
                for (AppConfigValues appConfigValues : cBillNetPurpose) {
                    coaQuery = "from CChartOfAccounts where purposeId in ( " + appConfigValues.getValue() + " )";
                    List coaList = session.createQuery(coaQuery).list();
                    Iterator iterator = coaList.iterator();
                    while (iterator.hasNext()) {
                        CChartOfAccounts chartOfAccounts = (CChartOfAccounts)iterator.next();
                        cBillNetPayCodeList.add(chartOfAccounts.getId().toString());
                    }
                }
                netAccountCode.put("Expense", cBillNetPayCodeList);
                ArrayList<String> pBillNetPayCodeList = new ArrayList<String>();
                List purchBillNetPurpose = this.appConfigValueService.getConfigValuesByModuleAndKey("EGF", "purchaseBillPurposeIds");
                for (AppConfigValues appConfigValues : purchBillNetPurpose) {
                    coaQuery = "from CChartOfAccounts where purposeId in ( " + appConfigValues.getValue() + " )";
                    List coaList = session.createQuery(coaQuery).list();
                    Iterator iterator = coaList.iterator();
                    while (iterator.hasNext()) {
                        CChartOfAccounts chartOfAccounts = (CChartOfAccounts)iterator.next();
                        pBillNetPayCodeList.add(chartOfAccounts.getId().toString());
                    }
                }
                netAccountCode.put("Purchase", pBillNetPayCodeList);
                ArrayList<String> sBillNetPayCodeList = new ArrayList<String>();
                List sBillNetPurpose = this.appConfigValueService.getConfigValuesByModuleAndKey("EGF", "salaryBillPurposeIds");
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Number of salary purpose ids - " + sBillNetPurpose.size()));
                }
                for (AppConfigValues appConfigValues : sBillNetPurpose) {
                    coaQuery = "from CChartOfAccounts where purposeId in ( " + appConfigValues.getValue() + " )";
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("Querying CChartOfAccounts -  " + coaQuery));
                    }
                    List coaList = session.createQuery(coaQuery).list();
                    Iterator iterator = coaList.iterator();
                    while (iterator.hasNext()) {
                        CChartOfAccounts chartOfAccounts = (CChartOfAccounts)iterator.next();
                        sBillNetPayCodeList.add(chartOfAccounts.getId().toString());
                    }
                }
                netAccountCode.put("Salary", sBillNetPayCodeList);
                ArrayList<String> wBillNetPayCodeList = new ArrayList<String>();
                List wBillNetPurpose = this.appConfigValueService.getConfigValuesByModuleAndKey("EGF", "worksBillPurposeIds");
                for (AppConfigValues appConfigValues : wBillNetPurpose) {
                    coaQuery = "from CChartOfAccounts where purposeId in ( " + appConfigValues.getValue() + " )";
                    List coaList = session.createQuery(coaQuery).list();
                    for (CChartOfAccounts chartOfAccounts : coaList) {
                        wBillNetPayCodeList.add(chartOfAccounts.getId().toString());
                    }
                }
                netAccountCode.put("Works", wBillNetPayCodeList);
                ArrayList<String> penBillNetPayCodeList = new ArrayList<String>();
                List pensionBillNetPurpose = this.appConfigValueService.getConfigValuesByModuleAndKey("EGF", "pensionBillPurposeIds");
                for (AppConfigValues appConfigValues : pensionBillNetPurpose) {
                    coaQuery = "from CChartOfAccounts where purposeId in ( " + appConfigValues.getValue() + " )";
                    List coaList = session.createQuery(coaQuery).list();
                    for (CChartOfAccounts chartOfAccounts : coaList) {
                        penBillNetPayCodeList.add(chartOfAccounts.getId().toString());
                    }
                }
                netAccountCode.put("Pension", penBillNetPayCodeList);
            }
            catch (Exception e) {
                errorState = true;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"EXCEPTION IN STATIC BLOCK OF BillRegisterReportAction ");
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)e.getMessage());
                }
                if (!LOGGER.isDebugEnabled()) break block16;
                LOGGER.debug((Object)e);
            }
        }
    }

    protected String getQuery() {
        StringBuffer query = new StringBuffer(1000);
        StringBuffer whereQuery = new StringBuffer(200);
        new StringBuffer(50);
        if (null != this.voucherHeader.getFundId()) {
            whereQuery.append(" and mis.fundid=" + this.voucherHeader.getFundId().getId());
        }
        if (null != this.voucherHeader.getVouchermis().getDepartmentid()) {
            whereQuery.append(" and mis.departmentid=" + this.voucherHeader.getVouchermis().getDepartmentid().getId());
        }
        if (null != this.voucherHeader.getVouchermis().getSchemeid()) {
            whereQuery.append(" and mis.schemeid=" + this.voucherHeader.getVouchermis().getSchemeid().getId());
        }
        if (null != this.voucherHeader.getVouchermis().getSubschemeid()) {
            whereQuery.append(" and mis.subschemeid=" + this.voucherHeader.getVouchermis().getSubschemeid().getId());
        }
        if (null != this.voucherHeader.getVouchermis().getFunctionary()) {
            whereQuery.append(" and mis.functionaryid=" + this.voucherHeader.getVouchermis().getFunctionary().getId());
        }
        if (null != this.voucherHeader.getVouchermis().getFundsource()) {
            whereQuery.append(" and mis.fundsourceid=" + this.voucherHeader.getVouchermis().getFundsource().getId());
        }
        if (null != this.voucherHeader.getVouchermis().getDivisionid()) {
            whereQuery.append(" and mis.fieldid=" + this.voucherHeader.getVouchermis().getDivisionid().getId());
        }
        if (!StringUtils.isEmpty((String)this.billType)) {
            whereQuery.append(" and  b.billtype='" + this.billType + "'");
        }
        if (null != this.fromDate) {
            whereQuery.append(" and b.billdate >= to_date('" + DDMMYYYYFORMATS.format(this.fromDate) + "','dd/MM/yyyy')");
        }
        if (null != this.toDate) {
            whereQuery.append(" and b.billdate <= to_date('" + DDMMYYYYFORMATS.format(this.toDate) + "','dd/MM/yyyy')");
        }
        if (null != this.billNumber && !StringUtils.isEmpty((String)this.billNumber)) {
            whereQuery.append(" and b.billnumber like '%" + this.billNumber + "%'");
        }
        if (StringUtils.isEmpty((String)this.exptype)) {
            List expndtrList = (List)this.dropdownData.get("expenditureList");
            for (String expenditure : expndtrList) {
                if (!StringUtils.isEmpty((String)query.toString())) {
                    query.append(" UNION ");
                }
                query.append(this.getQueryByExpndType(expenditure, whereQuery.toString()));
            }
        } else {
            query.append(this.getQueryByExpndType(this.exptype, whereQuery.toString()));
        }
        return query.toString();
    }

    protected String getQueryByExpndType(String expndType, String whereQuery) {
        this.netAccountCodeValue();
        List listOfNetPayGlIds = (List)netAccountCode.get(expndType);
        StringBuffer netPayCodes = new StringBuffer(30);
        String voucherQry = "";
        for (String netCode : listOfNetPayGlIds) {
            if (!StringUtils.isEmpty((String)netPayCodes.toString())) {
                netPayCodes.append(",").append(netCode);
                continue;
            }
            netPayCodes.append(netCode);
        }
        if (this.voucherHeader.getVoucherNumber() != null && !StringUtils.isEmpty((String)this.voucherHeader.getVoucherNumber())) {
            voucherQry = " and vh.vouchernumber like '%" + this.voucherHeader.getVoucherNumber() + "%'";
        }
        StringBuffer query = new StringBuffer(500);
        query.append(" select b.billnumber ,vh.vouchernumber as vouchernumber, mis.payto,b.passedamount, sum(bd.creditamount) as netpay, s.description,b.billdate as billdate").append(" from eg_billregister b, eg_billdetails bd, voucherheader vh,eg_billregistermis mis , egw_status s ").append(" where b.id= bd.billid and b.id=mis.billid and mis.voucherheaderid =vh.id  and s.id= b.statusid and bd.creditamount > 0").append(voucherQry).append("  and bd.glcodeid in(").append(netPayCodes.toString()).append(")").append(" and b.expendituretype='").append(expndType).append("'").append("  and vh.status IN (0,5) ").append(whereQuery).append(" group by b.billnumber, vh.vouchernumber,mis.payto, b.passedamount, s.description,b.billdate");
        query.append(" UNION ");
        query.append(" select b.billnumber ,'' as vouchernumber, mis.payto,b.passedamount, sum(bd.creditamount) as netpay, s.description,b.billdate as billdate").append(" from eg_billregister b, eg_billdetails bd, voucherheader vh,eg_billregistermis mis , egw_status s ").append(" where b.id= bd.billid and b.id=mis.billid and mis.voucherheaderid =vh.id  and s.id= b.statusid and bd.creditamount > 0").append(voucherQry).append("  and bd.glcodeid in(").append(netPayCodes.toString()).append(")").append(" and b.expendituretype='").append(expndType).append("'").append("  and vh.status = 4").append(whereQuery).append(" group by b.billnumber,vouchernumber, mis.payto, b.passedamount, s.description,b.billdate");
        if (this.voucherHeader.getVoucherNumber() == null || StringUtils.isEmpty((String)this.voucherHeader.getVoucherNumber())) {
            query.append(" UNION ");
            query.append(" select b.billnumber ,'' as vouchernumber, mis.payto,b.passedamount, sum(bd.creditamount) as netpay, s.description,b.billdate as billdate").append(" from eg_billregister b, eg_billdetails bd,eg_billregistermis mis , egw_status s ").append(" where b.id= bd.billid and b.id=mis.billid  and s.id= b.statusid and  mis.voucherheaderid is null and bd.creditamount > 0").append("  and bd.glcodeid in(").append(netPayCodes.toString()).append(")").append(" and b.expendituretype='").append(expndType).append("'").append(whereQuery).append(" group by b.billnumber, vouchernumber,mis.payto, b.passedamount, s.description,b.billdate");
        }
        return query.toString();
    }

    protected void loadDropdownData() {
        Query query = this.persistenceService.getSession().createQuery("select status.id from EgwStatus status where status.description in (:surrenderedList) and status.moduletype='Instrument'");
        query.setParameterList("surrenderedList", (Collection)this.chequeStatusCheckList);
        this.cancelledChequeStatus = query.list();
        this.getHeaderFields();
        if (this.headerFields.contains("department")) {
            this.addDropdownData("departmentList", this.masterDataCache.get("egi-department"));
        }
        if (this.headerFields.contains("functionary")) {
            this.addDropdownData("functionaryList", this.masterDataCache.get("egi-functionary"));
        }
        if (this.headerFields.contains("fund")) {
            this.addDropdownData("fundList", this.masterDataCache.get("egi-fund"));
        }
        if (this.headerFields.contains("fundsource")) {
            this.addDropdownData("fundsourceList", this.masterDataCache.get("egi-fundSource"));
        }
        if (this.headerFields.contains("field")) {
            this.addDropdownData("fieldList", this.masterDataCache.get("egi-ward"));
        }
        if (this.headerFields.contains("scheme")) {
            this.addDropdownData("schemeList", Collections.EMPTY_LIST);
        }
        if (this.headerFields.contains("subscheme")) {
            this.addDropdownData("subschemeList", Collections.EMPTY_LIST);
        }
        this.addDropdownData("expenditureList", this.persistenceService.findAllBy(" select distinct bill.expendituretype from EgBillregister bill  order by bill.expendituretype", new Object[0]));
        this.addDropdownData("billTypeList", this.persistenceService.findAllBy(" select distinct bill.billtype from EgBillregister bill where  bill.billtype is not null order by bill.billtype", new Object[0]));
    }

    protected void getHeaderFields() {
        List appConfigList = this.appConfigValueService.getConfigValuesByModuleAndKey("EGF", "DEFAULT_SEARCH_MISATTRRIBUTES");
        for (AppConfigValues appConfigVal : appConfigList) {
            String value = appConfigVal.getValue();
            String header = value.substring(0, value.indexOf(124));
            this.headerFields.add(header);
            String mandate = value.substring(value.indexOf(124) + 1);
            if (!mandate.equalsIgnoreCase("M")) continue;
            this.mandatoryFields.add(header);
        }
    }

    public EgwStatus getStatusId(String statusString) {
        String statusQury = "from EgwStatus where upper(moduletype)=upper('instrument') and  upper(description)=upper('" + statusString + "')";
        EgwStatus egwStatus = (EgwStatus)this.persistenceService.find(statusQury);
        return egwStatus;
    }

    public Date getFromDate() {
        return this.fromDate;
    }

    public Date getToDate() {
        return this.toDate;
    }

    public void setFromDate(Date fromDate) {
        this.fromDate = fromDate;
    }

    public void setToDate(Date toDate) {
        this.toDate = toDate;
    }

    public CVoucherHeader getVoucherHeader() {
        return this.voucherHeader;
    }

    public void setVoucherHeader(CVoucherHeader voucherHeader) {
        this.voucherHeader = voucherHeader;
    }

    public String getExptype() {
        return this.exptype;
    }

    public String getBillType() {
        return this.billType;
    }

    public void setExptype(String exptype) {
        this.exptype = exptype;
    }

    public void setBillType(String billType) {
        this.billType = billType;
    }

    public List<BillRegisterReportBean> getBillRegReportList() {
        return this.billRegReportList;
    }

    public void setBillRegReportList(List<BillRegisterReportBean> billRegReportList) {
        this.billRegReportList = billRegReportList;
    }

    public List<String> getChequeStatusCheckList() {
        return this.chequeStatusCheckList;
    }

    public void setChequeStatusCheckList(List<String> chequeStatusCheckList) {
        this.chequeStatusCheckList = chequeStatusCheckList;
    }

    public String getBillNumber() {
        return this.billNumber;
    }

    public void setBillNumber(String billNumber) {
        this.billNumber = billNumber;
    }

    public boolean isCompleteBillRegisterReport() {
        return this.isCompleteBillRegisterReport;
    }

    public void setCompleteBillRegisterReport(boolean isCompleteBillRegisterReport) {
        this.isCompleteBillRegisterReport = isCompleteBillRegisterReport;
    }

    public static Map<String, List<String>> getNetAccountCode() {
        return netAccountCode;
    }

    public static void setNetAccountCode(Map<String, List<String>> netAccountCode) {
        BillRegisterReportAction.netAccountCode = netAccountCode;
    }

    public AppConfigValueService getAppConfigValueService() {
        return this.appConfigValueService;
    }

    public void setAppConfigValueService(AppConfigValueService appConfigValueService) {
        this.appConfigValueService = appConfigValueService;
    }
}

