/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.payment;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.egov.commons.Bankaccount;
import org.egov.commons.Fund;
import org.egov.egf.commons.EgovCommon;
import org.egov.egf.web.actions.payment.ConcurrenceReportData;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infstr.services.PersistenceService;
import org.egov.utils.Constants;
import org.egov.utils.ReportHelper;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.transform.Transformers;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@Results(value={@Result(name={"PDF"}, type="stream", location="inputStream", params={"inputName", "inputStream", "contentType", "application/pdf", "contentDisposition", "no-cache;filename=ConcurrenceReport.pdf"}), @Result(name={"XLS"}, type="stream", location="inputStream", params={"inputName", "inputStream", "contentType", "application/xls", "contentDisposition", "no-cache;filename=ConcurrenceReport.xls"})})
@ParentPackage(value="egov")
public class ConcurrenceReportAction
extends BaseFormAction {
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    private static final long serialVersionUID = 6675640128074557827L;
    private List<ConcurrenceReportData> paymentHeaderList = new ArrayList();
    private List<ConcurrenceReportData> paymentHeaderListFnd = new ArrayList();
    List<Object> paymentHeaderReportList = new ArrayList();
    private BigDecimal grandTol = new BigDecimal("0");
    private static final Logger LOGGER = Logger.getLogger(ConcurrenceReportAction.class);
    private final String jasperpath = "/reports/templates/ConcurrenceReport.jasper";
    private Date asOnDate = new Date();
    private Date fromDate = new Date();
    private Date toDate = new Date();
    private Bankaccount bankAccount;
    private String dateType;
    private ReportHelper reportHelper;
    private InputStream inputStream;
    boolean bankAccountExist = false;
    private String chequeOrRTGS;

    public String execute() throws Exception {
        return "form";
    }

    public void prepare() {
        super.prepare();
        if (!this.parameters.containsKey("skipPrepare")) {
            this.addDropdownData("fundList", this.persistenceService.findAllBy(" from Fund where isactive=true and isnotleaf=false order by name", new Object[0]));
            this.addDropdownData("bankList", Collections.EMPTY_LIST);
            this.addDropdownData("accNumList", Collections.EMPTY_LIST);
        }
    }

    public Object getModel() {
        return null;
    }

    @Action(value="/payment/concurrenceReport-exportPdf")
    public String exportPdf() throws JRException, IOException {
        this.ajaxLoadPaymentHeader();
        this.paymentHeaderReportList.addAll(this.paymentHeaderListFnd);
        this.inputStream = this.reportHelper.exportPdf(this.inputStream, "/reports/templates/ConcurrenceReport.jasper", this.getParamMap(), this.paymentHeaderReportList);
        return "PDF";
    }

    @Action(value="/payment/concurrenceReport-exportXls")
    public String exportXls() throws JRException, IOException {
        this.ajaxLoadPaymentHeader();
        this.paymentHeaderReportList.addAll(this.paymentHeaderListFnd);
        this.inputStream = this.reportHelper.exportXls(this.inputStream, "/reports/templates/ConcurrenceReport.jasper", this.getParamMap(), this.paymentHeaderReportList);
        return "XLS";
    }

    @Action(value="/payment/concurrenceReport-ajaxLoadPaymentHeader")
    public String ajaxLoadPaymentHeader() {
        Query query;
        this.grandTol = BigDecimal.ZERO;
        if (this.parameters.containsKey("bankAccount.id") && ((String[])this.parameters.get("bankAccount.id"))[0] != null) {
            Integer id = Integer.valueOf(((String[])this.parameters.get("bankAccount.id"))[0]);
            this.bankAccount = (Bankaccount)this.persistenceService.find("from Bankaccount where id=?", new Object[]{id});
            this.bankAccountExist = true;
            this.bankAccount.getBankbranch().getBank().getName();
        }
        if (this.parameters.containsKey("asOnDate") && ((String[])this.parameters.get("asOnDate"))[0] != null) {
            this.setDateData(((String[])this.parameters.get("asOnDate"))[0], " ");
            query = this.generateQuery();
            query.setDate("date", this.asOnDate).setResultTransformer(Transformers.aliasToBean(ConcurrenceReportData.class));
            this.paymentHeaderList.addAll(query.list());
        } else if (this.parameters.containsKey("fromDate") && ((String[])this.parameters.get("fromDate"))[0] != null && this.parameters.containsKey("toDate") && ((String[])this.parameters.get("toDate"))[0] != null) {
            this.setDateData(((String[])this.parameters.get("fromDate"))[0], ((String[])this.parameters.get("toDate"))[0]);
            query = this.generateQuery();
            query.setDate("fromDate", this.fromDate).setDate("toDate", this.toDate).setResultTransformer(Transformers.aliasToBean(ConcurrenceReportData.class));
            this.paymentHeaderList.addAll(query.list());
        }
        this.generatePaymentList();
        return "results";
    }

    private void setDateData(String frmDate, String toDate) {
        try {
            if (!toDate.equals(" ")) {
                this.setDateType("0");
                this.setFromDate(Constants.DDMMYYYYFORMAT2.parse(frmDate));
                this.setToDate(Constants.DDMMYYYYFORMAT2.parse(toDate));
            } else {
                this.setDateType("1");
                this.setAsOnDate(Constants.DDMMYYYYFORMAT2.parse(frmDate));
            }
        }
        catch (ParseException e) {
            throw new ValidationException("Invalid date", "Invalid date", new String[0]);
        }
    }

    private void generatePaymentList() {
        if (this.paymentHeaderList.size() != 0) {
            BigDecimal fundAmt = new BigDecimal("0");
            String fndIdPre = ((ConcurrenceReportData)this.paymentHeaderList.get(0)).getFundId().toString();
            int size = this.paymentHeaderList.size();
            this.paymentHeaderListFnd = new ArrayList();
            for (ConcurrenceReportData row : this.paymentHeaderList) {
                int lastInd;
                Fund fundNm;
                if (row.getFundId().toString().equalsIgnoreCase(fndIdPre)) {
                    this.paymentHeaderListFnd.add(row);
                    fundAmt = fundAmt.add(row.getAmount());
                } else {
                    fundNm = (Fund)this.persistenceService.find("from Fund where id=?", new Object[]{Integer.valueOf(fndIdPre)});
                    this.paymentHeaderListFnd.add(new ConcurrenceReportData(new String(fundNm.getName()), fundAmt, "Total"));
                    this.grandTol = this.grandTol.add(fundAmt);
                    fundAmt = BigDecimal.ZERO;
                    fndIdPre = row.getFundId().toString();
                    this.paymentHeaderListFnd.add(row);
                    fundAmt = fundAmt.add(row.getAmount());
                }
                if ((lastInd = this.paymentHeaderList.indexOf(row)) != size - 1) continue;
                fundNm = (Fund)this.persistenceService.find("from Fund where id=?", new Object[]{Integer.valueOf(fndIdPre)});
                this.paymentHeaderListFnd.add(new ConcurrenceReportData(new String(fundNm.getName()), fundAmt, "Total"));
                this.grandTol = this.grandTol.add(fundAmt);
                this.setGrandTol(this.grandTol);
            }
        }
    }

    private Query generateQuery() {
        SQLQuery query = this.persistenceService.getSession().createSQLQuery(this.getQueryString().toString()).addScalar("bankName").addScalar("bankAccountNumber").addScalar("fundId").addScalar("departmentName").addScalar("billNumber").addScalar("billDate").addScalar("uac").addScalar("bpvNumber").addScalar("bpvDate").addScalar("bpvAccountCode").addScalar("amount");
        return query;
    }

    public void setPaymentHeaderList(List<ConcurrenceReportData> paymentHeaderList) {
        this.paymentHeaderList = paymentHeaderList;
    }

    private StringBuffer getQueryString() {
        StringBuffer queryString = new StringBuffer();
        String bankQry = "";
        String dateQry = "";
        String insturmentQry = "";
        if (this.dateType.equals("1")) {
            dateQry = "ph.concurrenceDate <=:date and ";
        } else if (this.dateType.equals("0")) {
            dateQry = "ph.concurrenceDate >=:fromDate and ph.concurrenceDate <= :toDate and ";
        }
        if (this.bankAccountExist) {
            bankQry = "ph.bankaccountnumberid=" + this.bankAccount.getId() + " and ";
            insturmentQry = " where bankaccountid=" + this.bankAccount.getId();
        } else {
            bankQry = " ";
        }
        if (StringUtils.isNotBlank((String)this.chequeOrRTGS)) {
            String chqOrRtgsQry = "";
            if ("cheque".equals(this.chequeOrRTGS)) {
                chqOrRtgsQry = "ih.INSTRUMENTNUMBER is not null and ih.INSTRUMENTTYPE = (select id from egf_instrumenttype where type = 'cheque') and iv.instrumentheaderId = ih.id and ";
            } else if ("rtgs".equals(this.chequeOrRTGS)) {
                chqOrRtgsQry = "ih.TRANSACTIONNUMBER is not null and ih.INSTRUMENTTYPE = (select id from egf_instrumenttype where type = 'advice') and iv.instrumentheaderId = ih.id and ";
            }
            queryString.append("select bk.name   As bankName,ba.accountnumber As bankAccountNumber, vh.fundid As fundId,d.dept_name as departmentName,ms.billnumber as billNumber, ").append("ms.billdate as billDate ,egusr.first_name as uac, vh.vouchernumber as bpvNumber, vh.voucherdate as bpvDate, gl.glcode as bpvAccountCode,").append("ms.paidamount as amount  from miscbilldetail ms,bank bk,bankbranch bb,bankaccount ba, voucherheader vh,vouchermis vmis, eg_department d,").append("generalledger gl,paymentheader ph,eg_wf_states es,EGF_INSTRUMENTHEADER ih, egf_instrumentvoucher iv right outer join voucherheader vh1 on ").append("vh1.id =iv.VOUCHERHEADERID,egw_status egws, eg_user egusr where ph.voucherheaderid=vh.id and gl.debitamount!=0 and gl.debitamount is not null and vh.id= vmis.voucherheaderid and ").append("vmis.departmentid= d.id_dept and ph.state_id=es.id and egusr.id_user=ph.createdby and es.value='END' and gl.voucherheaderid=vh.id and ").append(" ms.payvhid=vh.id and ph.voucherheaderid=vh.id and ").append(chqOrRtgsQry).append(dateQry).append(bankQry).append(" ph.bankaccountnumberid=ba.id and ba.branchid=bb.id and bb.bankid=bk.id").append(" and  vh1.id=vh.id and vh.status=0  group by vh.fundid, ms.billnumber, d.dept_name,").append(" egusr.first_name, ms.billdate,gl.glcode,vh.vouchernumber,bk.name,ba.accountnumber, vh.voucherdate, ms.paidamount ");
        } else {
            queryString.append("select bk.name   As bankName,ba.accountnumber As bankAccountNumber, vh.fundid As fundId,d.dept_name as departmentName,ms.billnumber as billNumber, ").append("ms.billdate as billDate ,egusr.first_name as uac, vh.vouchernumber as bpvNumber, vh.voucherdate as bpvDate, gl.glcode as bpvAccountCode,").append("ms.paidamount as amount  from miscbilldetail ms,bank bk,bankbranch bb,bankaccount ba, voucherheader vh,vouchermis vmis, eg_department d,").append("generalledger gl,paymentheader ph,eg_wf_states es,egf_instrumentvoucher iv right outer join voucherheader vh1 on ").append("vh1.id =iv.VOUCHERHEADERID,egw_status egws, eg_user egusr where ph.voucherheaderid=vh.id and gl.debitamount!=0 and gl.debitamount is not null and vh.id= vmis.voucherheaderid and ").append("vmis.departmentid= d.id_dept and ph.state_id=es.id and egusr.id_user=ph.createdby and es.value='END' and gl.voucherheaderid=vh.id and ").append(" ms.payvhid=vh.id and ph.voucherheaderid=vh.id and ").append(dateQry).append(bankQry).append(" ph.bankaccountnumberid=ba.id and ba.branchid=bb.id and bb.bankid=bk.id").append(" and  vh1.id=vh.id and vh.status=0 and iv.VOUCHERHEADERID is null group by vh.fundid, ms.billnumber, d.dept_name,").append(" egusr.first_name, ms.billdate,gl.glcode,vh.vouchernumber,bk.name,ba.accountnumber, vh.voucherdate, ms.paidamount ").append(" union ").append(" select bk.name   As bankName,ba.accountnumber As bankAccountNumber, vh.fundid As fundId,d.dept_name as departmentName,ms.billnumber as billNumber, ").append("ms.billdate as billDate ,egusr.first_name as uac, vh.vouchernumber as bpvNumber, vh.voucherdate as bpvDate, gl.glcode as bpvAccountCode,").append("ms.paidamount as amount  from miscbilldetail ms, bank bk,bankbranch bb,bankaccount ba, egf_instrumentvoucher iv,voucherheader vh,").append("vouchermis vmis, eg_department d,generalledger gl,").append("paymentheader ph,eg_wf_states es, eg_user egusr,egw_status egws,(select ih1.id,ih1.id_status from egf_instrumentheader ih1, ").append("(select bankid,bankaccountid,instrumentnumber,max(lastmodifieddate) as lastmodifieddate from egf_instrumentheader ").append(insturmentQry).append(" group by bankid,bankaccountid,").append("instrumentnumber order by lastmodifieddate desc) max_rec where max_rec.bankid=ih1.bankid and max_rec.bankaccountid=ih1.bankaccountid and max_rec.instrumentnumber=ih1.instrumentnumber ").append("and max_rec.lastmodifieddate=ih1.lastmodifieddate and rownum=1) ih where ph.voucherheaderid=vh.id and ms.payvhid=vh.id and vh.id= vmis.voucherheaderid and ").append("vmis.departmentid= d.id_dept and ph.state_id=es.id and es.value='END' and egusr.id_user=ph.createdby and gl.voucherheaderid=vh.id and ph.voucherheaderid=vh.id ").append(" and  iv.voucherheaderid=vh.id and iv.instrumentheaderid=ih.id and vh.status=0 and ").append("ih.id_status=egws.id and egws.description in ('Surrendered','Surrender_For_Reassign') and gl.debitamount!=0 and gl.debitamount is not null and ").append(dateQry).append(bankQry).append(" ph.bankaccountnumberid=ba.id and ba.branchid=bb.id and bb.bankid=bk.id and vh.type='").append("Payment").append("'");
        }
        return queryString.append("order by fundid ,bankaccountnumber,billdate");
    }

    public String getChequeOrRTGS() {
        return this.chequeOrRTGS;
    }

    public void setChequeOrRTGS(String chequeOrRTGS) {
        this.chequeOrRTGS = chequeOrRTGS;
    }

    public String getUlbName() {
        SQLQuery query = this.persistenceService.getSession().createSQLQuery("select name from companydetail");
        List result = query.list();
        if (result != null) {
            return (String)result.get(0);
        }
        return "";
    }

    Map<String, Object> getParamMap() {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        String header = "";
        paramMap.put("ulbName", this.getUlbName());
        paramMap.put("grandTol", this.grandTol);
        String bankName = " ";
        if (this.bankAccountExist) {
            bankName = "for ".concat(this.bankAccount.getBankbranch().getBank().getName()).concat("-").concat(this.bankAccount.getBankbranch().getBranchname()).concat("-").concat(this.bankAccount.getAccountnumber());
        }
        header = this.dateType.equals("1") ? "Concurrence Report " + bankName + " as on " + Constants.DDMMYYYYFORMAT2.format(this.asOnDate) : "Concurrence Report " + bankName + " " + Constants.DDMMYYYYFORMAT2.format(this.fromDate) + " - " + Constants.DDMMYYYYFORMAT2.format(this.toDate);
        paramMap.put("heading", header);
        paramMap.put("paymentHeaderListFnd", this.paymentHeaderListFnd);
        paramMap.put("paymentHeaderReportList", this.paymentHeaderReportList);
        return paramMap;
    }

    public List<ConcurrenceReportData> getPaymentHeaderList() {
        return this.paymentHeaderList;
    }

    public List<ConcurrenceReportData> getPaymentHeaderListFnd() {
        return this.paymentHeaderListFnd;
    }

    public void setPaymentHeaderListFnd(List<ConcurrenceReportData> paymentHeaderListFnd) {
        this.paymentHeaderListFnd = paymentHeaderListFnd;
    }

    public String getFormattedDate(Date date) {
        return Constants.DDMMYYYYFORMAT2.format(date);
    }

    public void setBankAccount(Bankaccount bankAccount) {
        this.bankAccount = bankAccount;
    }

    public Bankaccount getBankAccount() {
        return this.bankAccount;
    }

    public void setAsOnDate(Date asOnDate) {
        this.asOnDate = asOnDate;
    }

    public Date getAsOnDate() {
        return this.asOnDate;
    }

    public String getDateType() {
        return this.dateType;
    }

    public void setDateType(String dateType) {
        this.dateType = dateType;
    }

    public Date getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(Date fromDate) {
        this.fromDate = fromDate;
    }

    public Date getToDate() {
        return this.toDate;
    }

    public BigDecimal getGrandTol() {
        return this.grandTol;
    }

    public void setGrandTol(BigDecimal grandTol) {
        this.grandTol = grandTol;
    }

    public void setToDate(Date toDate) {
        this.toDate = toDate;
    }

    public String getFormattedAsOnDate() {
        return Constants.DDMMYYYYFORMAT2.format(this.asOnDate);
    }

    public void setEgovCommon(EgovCommon egovCommon) {
    }

    public void setReportHelper(ReportHelper reportHelper) {
        this.reportHelper = reportHelper;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public List<Object> getPaymentHeaderReportList() {
        return this.paymentHeaderReportList;
    }

    public void setPaymentHeaderReportList(List<Object> paymentHeaderReportList) {
        this.paymentHeaderReportList = paymentHeaderReportList;
    }
}

