/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.brs;

import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.egov.commons.EgwStatus;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.egf.model.ReconcileBean;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infstr.services.PersistenceService;
import org.egov.model.instrument.InstrumentHeader;
import org.egov.services.instrument.InstrumentHeaderService;
import org.egov.services.instrument.InstrumentOtherDetailsService;
import org.hibernate.SQLQuery;
import org.hibernate.transform.Transformers;
import org.hibernate.type.BigDecimalType;
import org.hibernate.type.LongType;
import org.hibernate.type.StringType;
import org.hibernate.type.Type;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ManualReconcileHelper {
    private static final Logger LOGGER = Logger.getLogger(ManualReconcileHelper.class);
    @Autowired
    private AppConfigValueService appConfigValueService;
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    @Autowired
    @Qualifier(value="instrumentOtherDetailsService")
    private InstrumentOtherDetailsService instrumentOtherDetailsService;
    @Autowired
    private EgwStatusHibernateDAO egwStatusHibernateDAO;
    @Autowired
    @Qualifier(value="instrumentHeaderService")
    private InstrumentHeaderService instrumentHeaderService;

    public Map<String, String> getUnReconciledDrCr(Long bankAccId, Date fromDate, Date toDate) {
        LinkedHashMap<String, String> unreconMap = new LinkedHashMap<String, String>();
        String instrumentsForBrsEntryTotal = "case when br.voucherHeaderId is null then ih.instrumentAmount else 0 end";
        String voucherExcludeStatuses = this.getExcludeStatuses();
        String totalQuery = "SELECT (sum(CASE WHEN ih.ispaycheque='1' then ih.instrumentAmount else 0 end ))  AS \"brs_creditTotal\",  (sum(CASE WHEN ih.ispaycheque = '0' then  ih.instrumentAmount else 0 end)) AS \"brs_debitTotal\"  FROM egf_instrumentheader ih \tWHERE   ih.bankAccountId =:bankAccountId  AND IH.INSTRUMENTDATE >= :fromDate AND IH.INSTRUMENTDATE <= :toDate AND  ( (ih.ispaycheque='0' and  ih.id_status=(select id from egw_status where moduletype='Instrument'  and description='Deposited'))or (ih.ispaycheque='1' and  ih.id_status=(select id from egw_status where  moduletype='Instrument'  and description='New')))  and ih.instrumentnumber is not null";
        String otherTotalQuery = " SELECT (sum(case when ih.ispaycheque='1' then ih.instrumentAmount else 0 end))  AS \"brs_creditTotalOthers\",  (sum(case when ih.ispaycheque= '0' then ih.instrumentAmount else 0 end))  AS \"brs_debitTotalOthers\"  FROM  egf_instrumentheader ih\tWHERE   ih.bankAccountId =:bankAccountId AND IH.transactiondate >= :fromDate AND IH.transactiondate <= :toDate   AND ( (ih.ispaycheque='0' and ih.id_status=(select id from egw_status where moduletype='Instrument'  and description='Deposited'))or (ih.ispaycheque='1' and  ih.id_status=(select id from egw_status where moduletype='Instrument'  and description='New')))  AND ih.transactionnumber is not null";
        String brsEntryQuery = " SELECT (sum(case when ih.ispaycheque= '1' then " + instrumentsForBrsEntryTotal + " else 0 end ))  AS \"brs_creditTotalBrsEntry\",  (sum(case when ih.ispaycheque= '0' then " + instrumentsForBrsEntryTotal + " else 0 end))  AS \"brs_debitTotalBrsEntry\"  FROM egf_instrumentheader ih, bankentries br\tWHERE   ih.bankAccountId = :bankAccountId AND IH.transactiondate >= :fromDate   AND IH.transactiondate <= :toDate  AND ( (ih.ispaycheque='0' and ih.id_status=(select id from egw_status where moduletype='Instrument'  and description='Deposited')) or (ih.ispaycheque='1' and  ih.id_status=(select id from egw_status where moduletype='Instrument'  and description='New')))  AND br.instrumentHeaderid=ih.id and ih.transactionnumber is not null";
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("  query  for  total : " + totalQuery));
        }
        String unReconciledDrCr = "";
        String creditTotal = null;
        String creditOthertotal = null;
        String debitTotal = null;
        String debitOtherTotal = null;
        String creditTotalBrsEntry = null;
        String debitTotalBrsEntry = null;
        try {
            Object[] my;
            SQLQuery totalSQLQuery = this.persistenceService.getSession().createSQLQuery(totalQuery);
            totalSQLQuery.setLong("bankAccountId", bankAccId.longValue());
            totalSQLQuery.setDate("fromDate", fromDate);
            totalSQLQuery.setDate("toDate", toDate);
            List list = totalSQLQuery.list();
            if (list.size() > 0) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(list.get(0));
                }
                creditTotal = (my = (Object[])list.get(0))[0] != null ? my[0].toString() : null;
                String string = debitTotal = my[1] != null ? my[1].toString() : null;
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("  query  for other than cheque/DD: " + otherTotalQuery));
            }
            totalSQLQuery = this.persistenceService.getSession().createSQLQuery(otherTotalQuery);
            totalSQLQuery.setLong("bankAccountId", bankAccId.longValue());
            totalSQLQuery.setDate("fromDate", fromDate);
            totalSQLQuery.setDate("toDate", toDate);
            list = totalSQLQuery.list();
            if (list.size() > 0) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(list.get(0));
                }
                creditOthertotal = (my = (Object[])list.get(0))[0] != null ? my[0].toString() : null;
                String string = debitOtherTotal = my[1] != null ? my[1].toString() : null;
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("  query  for bankEntries: " + brsEntryQuery));
            }
            totalSQLQuery = this.persistenceService.getSession().createSQLQuery(brsEntryQuery);
            totalSQLQuery.setLong("bankAccountId", bankAccId.longValue());
            totalSQLQuery.setDate("fromDate", fromDate);
            totalSQLQuery.setDate("toDate", toDate);
            list = totalSQLQuery.list();
            if (list.size() > 0) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(list.get(0));
                }
                creditTotalBrsEntry = (my = (Object[])list.get(0))[0] != null ? my[0].toString() : null;
                debitTotalBrsEntry = my[1] != null ? my[1].toString() : null;
            }
            creditTotal = creditTotal == null ? "0" : creditTotal;
            debitTotal = debitTotal == null ? "0" : debitTotal;
            creditOthertotal = creditOthertotal == null ? "0" : creditOthertotal;
            debitOtherTotal = debitOtherTotal == null ? "0" : debitOtherTotal;
            debitTotalBrsEntry = debitTotalBrsEntry == null ? "0" : debitTotalBrsEntry;
            unreconMap.put("Cheque/DD/Cash Payments", creditTotal);
            unreconMap.put("Cheque/DD/Cash Receipts", debitTotal);
            unreconMap.put("RTGS Payments", creditOthertotal);
            unreconMap.put("Other Receipts", debitOtherTotal);
            unreconMap.put("BRS Entry", debitTotalBrsEntry);
        }
        catch (Exception e) {
            LOGGER.error((Object)("Exp in getUnReconciledDrCr" + e.getMessage()));
        }
        return unreconMap;
    }

    private String getExcludeStatuses() {
        List configValuesByModuleAndKey = this.appConfigValueService.getConfigValuesByModuleAndKey("EGF", "statusexcludeReport");
        String statusExclude = ((AppConfigValues)configValuesByModuleAndKey.get(0)).getValue();
        return statusExclude;
    }

    public List<ReconcileBean> getUnReconciledCheques(ReconcileBean reconBean) {
        ArrayList<ReconcileBean> list = new ArrayList();
        String instrumentCondition = "";
        if (reconBean.getInstrumentNo() != null && !reconBean.getInstrumentNo().isEmpty()) {
            instrumentCondition = "and (ih.instrumentNumber='" + reconBean.getInstrumentNo() + "' or ih.transactionnumber='" + reconBean.getInstrumentNo() + "' )";
        }
        try {
            String voucherExcludeStatuses = this.getExcludeStatuses();
            StringBuffer query = new StringBuffer().append(" select string_agg(distinct v.vouchernumber, ',') as \"voucherNumber\" ,ih.id as \"ihId\", case when ih.instrumentNumber is null then 'Direct' else ih.instrumentNumber  end as \"chequeNumber\",  to_char(ih.instrumentdate,'dd/mm/yyyy') as \"chequeDate\" ,ih.instrumentAmount as \"chequeAmount\",rec.transactiontype as \"txnType\" ,  case when rec.transactionType='Cr' then  'Payment' else 'Receipt' end as \"type\"  FROM BANKRECONCILIATION rec, BANKACCOUNT BANK, VOUCHERHEADER v ,egf_instrumentheader ih, egf_instrumentotherdetails io, egf_instrumentVoucher iv\tWHERE   ih.bankAccountId = BANK.ID AND bank.id =:bankAccId   AND IH.INSTRUMENTDATE <= :toDate   AND v.ID= iv.voucherheaderid  and v.STATUS not in  (" + voucherExcludeStatuses + ")  " + instrumentCondition + " AND ((ih.id_status=(select id from egw_status where moduletype='Instrument'  and description='Deposited') and ih.ispaycheque='0') or (ih.ispaycheque='1' and  ih.id_status=(select id from egw_status where moduletype='Instrument'  and description='New')))  AND rec.instrumentHeaderId=ih.id\t and iv.instrumentHeaderid=ih.id and io.instrumentheaderid=ih.id and ih.instrumentNumber is not null group by ih.id,rec.transactiontype  union   select string_agg(distinct v.vouchernumber, ',') as \"voucherNumber\" , ih.id as \"ihId\", case when ih.transactionnumber is null then 'Direct' else ih.transactionnumber end as \"chequeNumber\",  to_char(ih.transactiondate,'dd/mm/yyyy') as \"chequedate\" ,ih.instrumentAmount as \"chequeamount\",rec.transactiontype as \"txnType\", case when rec.transactionType= 'Cr' then 'Payment' else 'Receipt' end    as \"type\"  FROM BANKRECONCILIATION rec, BANKACCOUNT BANK, VOUCHERHEADER v ,egf_instrumentheader ih, egf_instrumentotherdetails io, egf_instrumentVoucher iv\tWHERE   ih.bankAccountId = BANK.ID AND bank.id = :bankAccId    AND IH.INSTRUMENTDATE <= :toDate " + instrumentCondition + " AND v.ID= iv.voucherheaderid and v.STATUS not in  (" + voucherExcludeStatuses + ") AND ((ih.id_status=(select id from egw_status where moduletype='Instrument'  and description='Deposited') and ih.ispaycheque='0')or (ih.ispaycheque='1' and  ih.id_status=(select id from egw_status where moduletype='Instrument'  and description='New')))  AND rec.instrumentHeaderId=ih.id\t and iv.instrumentHeaderid=ih.id and io.instrumentheaderid=ih.id and ih.transactionnumber is not null   group by ih.id,rec.transactiontype order by 4 ");
            if (reconBean.getLimit() != null & reconBean.getLimit() != 0) {
                query.append(" limit " + reconBean.getLimit());
            }
            LOGGER.info((Object)("  query  for getUnReconciledCheques: " + query));
            SQLQuery createSQLQuery = this.persistenceService.getSession().createSQLQuery(query.toString());
            createSQLQuery.setLong("bankAccId", reconBean.getAccountId().longValue());
            createSQLQuery.setDate("toDate", reconBean.getReconciliationDate());
            createSQLQuery.addScalar("voucherNumber", (Type)StringType.INSTANCE);
            createSQLQuery.addScalar("ihId", (Type)LongType.INSTANCE);
            createSQLQuery.addScalar("chequeDate", (Type)StringType.INSTANCE);
            createSQLQuery.addScalar("chequeNumber", (Type)StringType.INSTANCE);
            createSQLQuery.addScalar("chequeAmount", (Type)BigDecimalType.INSTANCE);
            createSQLQuery.addScalar("txnType", (Type)StringType.INSTANCE);
            createSQLQuery.addScalar("type", (Type)StringType.INSTANCE);
            createSQLQuery.setResultTransformer(Transformers.aliasToBean(ReconcileBean.class));
            list = createSQLQuery.list();
        }
        catch (Exception e) {
            LOGGER.error((Object)("Exp in getUnReconciledCheques:" + e.getMessage()));
            throw new ApplicationRuntimeException(e.getMessage());
        }
        return list;
    }

    @Transactional
    public void update(List<Date> reconDates, List<Long> instrumentHeaders) {
        int i = 0;
        EgwStatus reconciledStatus = this.egwStatusHibernateDAO.getStatusByModuleAndCode("Instrument", "Reconciled");
        for (Date reconcileOn : reconDates) {
            if (reconcileOn != null) {
                Long ihId = instrumentHeaders.get(i);
                InstrumentHeader ih = this.instrumentHeaderService.reconcile(reconcileOn, ihId, reconciledStatus);
                this.instrumentOtherDetailsService.reconcile(reconcileOn, ihId, ih.getInstrumentAmount());
            }
            ++i;
        }
    }
}

