/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.controller;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.egov.commons.Accountdetailtype;
import org.egov.commons.CChartOfAccountDetail;
import org.egov.commons.CChartOfAccounts;
import org.egov.commons.CFunction;
import org.egov.commons.dao.ChartOfAccountsDAO;
import org.egov.commons.dao.FinancialYearDAO;
import org.egov.commons.dao.FunctionDAO;
import org.egov.commons.dao.FundHibernateDAO;
import org.egov.commons.service.AccountdetailtypeService;
import org.egov.eis.service.EmployeeService;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.infstr.services.PersistenceService;
import org.egov.model.contra.TransactionSummary;
import org.egov.model.contra.TransactionSummaryDto;
import org.egov.model.service.TransactionSummaryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/transactionsummary"})
public class TransactionSummaryController {
    private static final String TRANSACTIONSUMMARY_NEW = "transactionsummary-new";
    private static final String TRANSACTIONSUMMARY_RESULT = "transactionsummary-result";
    private static final String TRANSACTIONSUMMARY_EDIT = "transactionsummary-edit";
    private static final String TRANSACTIONSUMMARY_VIEW = "transactionsummary-view";
    @Autowired
    private TransactionSummaryService transactionSummaryService;
    @Autowired
    private AccountdetailtypeService accountdetailtypeService;
    @Autowired
    private FinancialYearDAO financialYearDAO;
    @Autowired
    private FundHibernateDAO fundHibernateDAO;
    @Autowired
    private ChartOfAccountsDAO chartOfAccountsDAO;
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    @Autowired
    private FunctionDAO functionDAO;
    @Autowired
    private EmployeeService employeeService;

    private void prepareNewForm(Model model) {
        model.addAttribute("accountdetailtypes", (Object)this.accountdetailtypeService.findAll());
        model.addAttribute("cFinancialYears", (Object)this.financialYearDAO.getAllActivePostingFinancialYear());
        model.addAttribute("funds", (Object)this.fundHibernateDAO.findAllActiveFunds());
        model.addAttribute("cChartOfAccountss", (Object)this.chartOfAccountsDAO.findAll());
        model.addAttribute("departments", (Object)this.departmentService.getAllDepartments());
        model.addAttribute("cFunctions", (Object)this.functionDAO.getAllActiveFunctions());
    }

    @RequestMapping(value={"/new"}, method={RequestMethod.GET})
    public String newForm(Model model) {
        this.prepareNewForm(model);
        model.addAttribute("transactionSummaryDto", (Object)new TransactionSummaryDto());
        return TRANSACTIONSUMMARY_NEW;
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<?> create(@ModelAttribute TransactionSummaryDto transactionSummaryDto, BindingResult errors, Model model, RedirectAttributes redirectAttrs, HttpServletResponse response) {
        List transactionSummaries = new ArrayList();
        transactionSummaries = this.removeEmptyRows(transactionSummaryDto.getTransactionSummaryList());
        try {
            for (TransactionSummary ts : transactionSummaries) {
                TransactionSummary transactionSummary = null;
                transactionSummary = ts.getId() != null ? this.transactionSummaryService.findOne(ts.getId()) : new TransactionSummary();
                if (ts.getId() == null && ts.getGlcodeid() == null) continue;
                if (ts.getId() != null && ts.getGlcodeid() == null) {
                    this.transactionSummaryService.delete(transactionSummary);
                    continue;
                }
                transactionSummary.setDepartmentid(this.departmentService.getDepartmentById(transactionSummaryDto.getDepartmentid().getId()));
                transactionSummary.setDivisionid(transactionSummaryDto.getDivisionid());
                transactionSummary.setFinancialyear(this.financialYearDAO.getFinancialYearById(transactionSummaryDto.getFinancialyear().getId()));
                transactionSummary.setFunctionid((CFunction)this.persistenceService.find("from CFunction where id=?", new Object[]{transactionSummaryDto.getFunctionid().getId()}));
                transactionSummary.setFund(this.fundHibernateDAO.fundById(transactionSummaryDto.getFund().getId(), false));
                transactionSummary.setAccountdetailkey(ts.getAccountdetailkey());
                if (ts.getAccountdetailtype() != null && ts.getAccountdetailtype().getId() != null) {
                    transactionSummary.setAccountdetailtype(this.accountdetailtypeService.findOne(ts.getAccountdetailtype().getId()));
                } else {
                    transactionSummary.setAccountdetailtype(null);
                }
                transactionSummary.setGlcodeid(this.chartOfAccountsDAO.getCChartOfAccountsByGlCode(ts.getGlcodeDetail()));
                transactionSummary.setNarration(ts.getNarration());
                transactionSummary.setOpeningcreditbalance(ts.getOpeningcreditbalance() == null ? BigDecimal.ZERO : ts.getOpeningcreditbalance());
                transactionSummary.setOpeningdebitbalance(ts.getOpeningdebitbalance() == null ? BigDecimal.ZERO : ts.getOpeningdebitbalance());
                transactionSummary = this.transactionSummaryService.create(transactionSummary);
            }
        }
        catch (Exception e) {
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity(HttpStatus.OK);
    }

    private List<TransactionSummary> removeEmptyRows(List<TransactionSummary> transactionSummaries) {
        ArrayList<TransactionSummary> tempTransactionSummaries = new ArrayList<TransactionSummary>();
        for (TransactionSummary transactionSummary : transactionSummaries) {
            if (transactionSummaries.size() == tempTransactionSummaries.size() + 1) continue;
            tempTransactionSummaries.add(transactionSummary);
        }
        if (transactionSummaries.get(transactionSummaries.size() - 1).getGlcodeDetail() != null && transactionSummaries.get(transactionSummaries.size() - 1).getGlcodeDetail() != "") {
            tempTransactionSummaries.add(transactionSummaries.get(transactionSummaries.size() - 1));
        }
        return tempTransactionSummaries;
    }

    @RequestMapping(value={"/edit/{id}"}, method={RequestMethod.GET})
    public String edit(@PathVariable(value="id") Long id, Model model) {
        TransactionSummary transactionSummary = this.transactionSummaryService.findOne(id);
        this.prepareNewForm(model);
        model.addAttribute("transactionSummary", (Object)transactionSummary);
        return TRANSACTIONSUMMARY_EDIT;
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public String update(@ModelAttribute TransactionSummary transactionSummary, BindingResult errors, Model model, RedirectAttributes redirectAttrs) {
        if (errors.hasErrors()) {
            this.prepareNewForm(model);
            return TRANSACTIONSUMMARY_EDIT;
        }
        this.transactionSummaryService.update(transactionSummary);
        redirectAttrs.addFlashAttribute("message", (Object)"msg.transactionSummary.success");
        return "redirect:/transactionsummary/result/" + transactionSummary.getId();
    }

    @RequestMapping(value={"/view/{id}"}, method={RequestMethod.GET})
    public String view(@PathVariable(value="id") Long id, Model model) {
        TransactionSummary transactionSummary = this.transactionSummaryService.findOne(id);
        this.prepareNewForm(model);
        model.addAttribute("transactionSummary", (Object)transactionSummary);
        return TRANSACTIONSUMMARY_VIEW;
    }

    @RequestMapping(value={"/result/{id}"}, method={RequestMethod.GET})
    public String result(@PathVariable(value="id") Long id, Model model) {
        TransactionSummary transactionSummary = this.transactionSummaryService.findOne(id);
        model.addAttribute("transactionSummary", (Object)transactionSummary);
        return TRANSACTIONSUMMARY_RESULT;
    }

    @RequestMapping(value={"/ajax/getMajorHeads"}, method={RequestMethod.GET})
    @ResponseBody
    public List<CChartOfAccounts> getMajorHeads(@RequestParam(value="type") Character type) {
        List accounts = this.chartOfAccountsDAO.findByType(type);
        return accounts;
    }

    @RequestMapping(value={"/ajax/getMinorHeads"}, method={RequestMethod.GET})
    @ResponseBody
    public List<CChartOfAccounts> getMinorHeads(@RequestParam(value="majorCode") String majorCode, @RequestParam(value="classification") Long classification) {
        List accounts = this.chartOfAccountsDAO.findByMajorCodeAndClassification(majorCode, classification);
        return accounts;
    }

    @RequestMapping(value={"/ajax/getAccounts"}, method={RequestMethod.GET})
    @ResponseBody
    public List<CChartOfAccounts> getAccounts(@RequestParam(value="term") String glcode, @RequestParam(value="majorCode") String majorCode, @RequestParam(value="classification") Long classification) {
        List accounts = null;
        accounts = majorCode != null ? this.chartOfAccountsDAO.findByGlcodeLikeIgnoreCaseAndClassificationAndMajorCode(glcode + "%", classification, majorCode) : this.chartOfAccountsDAO.findByGlcodeLikeIgnoreCaseAndClassification(glcode + "%", classification);
        return accounts;
    }

    @RequestMapping(value={"/ajax/getAccountDetailTypes"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Accountdetailtype> getAccountDetailTypes(@RequestParam(value="id") Long id) {
        CChartOfAccounts account = this.chartOfAccountsDAO.findById((Number)id.intValue(), false);
        ArrayList<Accountdetailtype> detailTypes = new ArrayList<Accountdetailtype>();
        for (CChartOfAccountDetail detail : account.getChartOfAccountDetails()) {
            detailTypes.add(detail.getDetailTypeId());
        }
        return detailTypes;
    }

    @RequestMapping(value={"/ajax/searchTransactionSummariesForNonSubledger"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Map<String, String>> searchTransactionSummariesForNonSubledger(@RequestParam(value="finYear") Long finYear, @RequestParam(value="fund") Long fund, @RequestParam(value="functn") Long functn, @RequestParam(value="department") Long department, @RequestParam(value="glcodeId") Long glcodeId) {
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        HashMap<String, String> amountsMap = new HashMap<String, String>();
        List transactionSummaries = this.transactionSummaryService.searchTransactionsForNonSubledger(finYear, fund, functn, department, glcodeId);
        for (TransactionSummary ts : transactionSummaries) {
            amountsMap.put("tsid", ts.getId().toString());
            amountsMap.put("openingdebitbalance", ts.getOpeningdebitbalance().setScale(2, 6).toString());
            amountsMap.put("openingcreditbalance", ts.getOpeningcreditbalance().setScale(2, 6).toString());
            amountsMap.put("narration", ts.getNarration());
            result.add(amountsMap);
        }
        return result;
    }

    @RequestMapping(value={"/ajax/searchTransactionSummariesForSubledger"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Map<String, String>> searchTransactionSummariesForSubledger(@RequestParam(value="finYear") Long finYear, @RequestParam(value="fund") Long fund, @RequestParam(value="functn") Long functn, @RequestParam(value="department") Long department, @RequestParam(value="glcodeId") Long glcodeId, @RequestParam(value="accountDetailTypeId") Integer accountDetailTypeId, @RequestParam(value="accountDetailKeyId") Integer accountDetailKeyId) {
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        HashMap<String, String> amountsMap = new HashMap<String, String>();
        List transactionSummaries = this.transactionSummaryService.searchTransactionsForSubledger(finYear, fund, functn, department, glcodeId, accountDetailTypeId, accountDetailKeyId);
        for (TransactionSummary ts : transactionSummaries) {
            amountsMap.put("tsid", ts.getId().toString());
            amountsMap.put("openingdebitbalance", ts.getOpeningdebitbalance().setScale(2, 6).toString());
            amountsMap.put("openingcreditbalance", ts.getOpeningcreditbalance().setScale(2, 6).toString());
            amountsMap.put("narration", ts.getNarration());
            result.add(amountsMap);
        }
        return result;
    }

    @RequestMapping(value={"/ajax/deleteTransaction"}, method={RequestMethod.GET})
    @ResponseBody
    public String deleteTransaction(@RequestParam(value="id") Long id) {
        if (id != null) {
            TransactionSummary ts = this.transactionSummaryService.findOne(id);
            this.transactionSummaryService.delete(ts);
        }
        return "success";
    }

    @RequestMapping(value={"/ajax/getTransactionSummary"}, method={RequestMethod.GET})
    @ResponseBody
    public TransactionSummary getTransactionSummary(@RequestParam(value="glcodeid") Long glcodeId, @RequestParam(value="accountdetailtypeid") Long accountDetailTypeId, @RequestParam(value="accountdetailkey") Integer accountDetailKey) {
        TransactionSummary ts = null;
        if (glcodeId != null && accountDetailTypeId != null && accountDetailKey != null) {
            ts = this.transactionSummaryService.getTransactionSummary(glcodeId, accountDetailTypeId, accountDetailKey);
        }
        return ts;
    }
}

