/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.voucher;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.commons.CVoucherHeader;
import org.egov.commons.Functionary;
import org.egov.commons.Fund;
import org.egov.commons.Fundsource;
import org.egov.commons.Scheme;
import org.egov.commons.SubScheme;
import org.egov.commons.Vouchermis;
import org.egov.commons.dao.FinancialYearDAO;
import org.egov.egf.commons.VoucherSearchUtil;
import org.egov.infra.admin.master.entity.AppConfig;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.exception.ApplicationException;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.infra.web.utils.EgovPaginatedList;
import org.egov.infstr.services.Page;
import org.egov.model.bills.EgBillregistermis;
import org.egov.utils.Constants;
import org.egov.utils.FinancialConstants;
import org.egov.utils.VoucherHelper;
import org.hibernate.Query;
import org.springframework.beans.factory.annotation.Autowired;

@ParentPackage(value="egov")
@Results(value={@Result(name="search", location="voucherSearch-search.jsp"), @Result(name="success", type="redirect", location="voucherSearch.action")})
public class VoucherSearchAction
extends BaseFormAction {
    private static final Logger LOGGER = Logger.getLogger(VoucherSearchAction.class);
    private static final long serialVersionUID = 1L;
    public CVoucherHeader voucherHeader = new CVoucherHeader();
    public static final String SEARCH = "search";
    public List<Map<String, Object>> voucherList;
    private List<Object> schemeList;
    public Map<String, String> nameList = new LinkedHashMap();
    public final SimpleDateFormat sdf = new SimpleDateFormat("dd-MMM-yyyy", Constants.LOCALE);
    public final SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy", Constants.LOCALE);
    @Autowired
    protected AppConfigValueService appConfigValuesService;
    private final List<String> headerFields = new ArrayList();
    private final List<String> mandatoryFields = new ArrayList();
    public Date fromDate = new Date();
    public Date toDate;
    private String showMode;
    private VoucherSearchUtil voucherSearchUtil;
    private final Map<Integer, String> sourceMap = new HashMap();
    private Integer page = 1;
    private Integer pageSize = 30;
    private EgovPaginatedList pagedResults;
    List<String> voucherTypes = VoucherHelper.VOUCHER_TYPES;
    Map<String, List<String>> voucherNames = VoucherHelper.VOUCHER_TYPE_NAMES;
    private FinancialYearDAO financialYearDAO;

    public Object getModel() {
        return this.voucherHeader;
    }

    public VoucherSearchAction() {
        LOGGER.error((Object)"creating instance of VoucherSearchAction ");
        this.voucherHeader.setVouchermis(new Vouchermis());
        this.addRelatedEntity("vouchermis.departmentid", Department.class);
        this.addRelatedEntity("fundId", Fund.class);
        this.addRelatedEntity("vouchermis.schemeid", Scheme.class);
        this.addRelatedEntity("vouchermis.subschemeid", SubScheme.class);
        this.addRelatedEntity("vouchermis.functionary", Functionary.class);
        this.addRelatedEntity("fundsourceId", Fundsource.class);
        this.addRelatedEntity("vouchermis.divisionid", Boundary.class);
    }

    public void prepare() {
        super.prepare();
        this.getHeaderFields();
        this.populateSourceMap();
        if (this.headerFields.contains("department")) {
            this.addDropdownData("departmentList", this.persistenceService.findAllBy("from Department order by name", new Object[0]));
        }
        if (this.headerFields.contains("functionary")) {
            this.addDropdownData("functionaryList", this.persistenceService.findAllBy(" from Functionary where isactive=true order by name", new Object[0]));
        }
        if (this.headerFields.contains("fund")) {
            this.addDropdownData("fundList", this.persistenceService.findAllBy(" from Fund where isactive=true and isnotleaf=false order by name", new Object[0]));
        }
        if (this.headerFields.contains("fundsource")) {
            this.addDropdownData("fundsourceList", this.persistenceService.findAllBy(" from Fundsource where isactive=true order by name", new Object[0]));
        }
        if (this.headerFields.contains("field")) {
            this.addDropdownData("fieldList", this.persistenceService.findAllBy(" from Boundary b where lower(b.boundaryType.name)='ward' ", new Object[0]));
        }
        if (this.headerFields.contains("scheme")) {
            this.addDropdownData("schemeList", Collections.EMPTY_LIST);
        }
        if (this.headerFields.contains("subscheme")) {
            this.addDropdownData("subschemeList", Collections.EMPTY_LIST);
        }
        if (null != this.parameters.get("showMode")) {
            this.showMode = ((String[])this.parameters.get("showMode"))[0];
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("show mode  :" + this.showMode));
            }
            if (this.showMode.equalsIgnoreCase("nonBillPayment")) {
                ArrayList<String> typeList = new ArrayList<String>();
                typeList.add("Journal Voucher");
                this.addDropdownData("typeList", typeList);
                this.voucherHeader.setType("Journal Voucher");
                this.nameList = new LinkedHashMap();
                this.nameList.put("Contractor Journal", "Contractor Journal");
                this.nameList.put("Supplier Journal", "Supplier Journal");
                this.nameList.put("Salary Journal", "Salary Journal");
            } else {
                this.addDropdownData("typeList", VoucherHelper.VOUCHER_TYPES);
            }
        } else {
            this.addDropdownData("typeList", VoucherHelper.VOUCHER_TYPES);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Number of  MIS attributes are :" + this.headerFields.size()));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Number of mandate MIS attributes are :" + this.mandatoryFields.size()));
        }
    }

    private void populateSourceMap() {
        List sourceList = new ArrayList();
        sourceList = this.persistenceService.findAllBy(" select distinct m.id,m.name from CVoucherHeader  vh, EgModules m where m.id=vh.moduleId and vh.status!=4 order by m.name", new Object[0]);
        for (Object[] obj : sourceList) {
            this.sourceMap.put((Integer)obj[0], (String)obj[1]);
        }
        this.sourceMap.put(-2, "Internal");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Added sourceMap of size -" + this.sourceMap.size()));
        }
    }

    public Map<String, String> getVoucherNameMap(String type) {
        List voucherNameList = this.getPersistenceService().findAllBy("select  distinct name from  CVoucherHeader where type=?", new Object[]{type});
        this.nameList = new LinkedHashMap();
        for (Object voucherName : voucherNameList) {
            this.nameList.put((String)voucherName, (String)voucherName);
        }
        return this.nameList;
    }

    @SkipValidation
    @Action(value="/voucher/voucherSearch-beforesearch")
    public String beforesearch() {
        this.finYearDate();
        if (this.showMode != null && this.showMode.equalsIgnoreCase("nonBillPayment")) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"nonBillPayment");
            }
        } else if (this.voucherHeader.getType() != null && !this.voucherHeader.getType().equals("-1")) {
            this.getVoucherNameMap(this.voucherHeader.getType());
        }
        return SEARCH;
    }

    public void prepareSearch() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Voucher Search Action | prepareSearch");
        }
        if (this.showMode != null && !this.showMode.equalsIgnoreCase("nonbillPayment") && null != this.parameters.get("type") && !((String[])this.parameters.get("type"))[0].equalsIgnoreCase("-1")) {
            this.nameList = this.getVoucherNameMap(((String[])this.parameters.get("type"))[0]);
        }
    }

    @ValidationErrorPage(value="search")
    @Action(value="/voucher/voucherSearch-search")
    public String search() throws ApplicationException, ParseException {
        List list;
        boolean validateFinancialYearForPosting;
        boolean ismodifyJv = false;
        this.voucherList = new ArrayList();
        HashMap<String, Object> voucherMap = null;
        if (null != this.parameters.get("showMode")) {
            this.showMode = ((String[])this.parameters.get("showMode"))[0];
        }
        if (this.voucherHeader.getModuleId() != null && this.voucherHeader.getModuleId() == -1) {
            this.voucherHeader.setModuleId(null);
        }
        if (null != this.showMode && this.showMode.equalsIgnoreCase("edit") && !(validateFinancialYearForPosting = this.voucherSearchUtil.validateFinancialYearForPosting(this.fromDate, this.toDate))) {
            throw new ValidationException(Arrays.asList(new ValidationError("Financial Year  Not active for Posting(either year or date within selected date range)", "Financial Year  Not active for Posting(either year or date within selected date range)")));
        }
        if (null == this.showMode || this.showMode.equals("")) {
            List qryObj = this.voucherSearchUtil.voucherSearchQuery(this.voucherHeader, this.fromDate, this.toDate, this.showMode);
            Query qry = (Query)qryObj.get(0);
            Long count = (Long)this.persistenceService.find(((Query)qryObj.get(1)).getQueryString());
            Page resPage = new Page(qry, this.page, this.pageSize);
            this.pagedResults = new EgovPaginatedList(resPage, count.intValue());
            list = this.pagedResults != null ? this.pagedResults.getList() : null;
        } else {
            list = this.showMode.equalsIgnoreCase("nonbillPayment") ? this.voucherSearchUtil.searchNonBillVouchers(this.voucherHeader, this.fromDate, this.toDate, this.showMode) : this.voucherSearchUtil.search(this.voucherHeader, this.fromDate, this.toDate, this.showMode);
        }
        if (null == this.showMode || this.showMode.equals("")) {
            for (CVoucherHeader voucherheader : list) {
                voucherMap = new HashMap<String, Object>();
                BigDecimal amt = voucherheader.getTotalAmount();
                voucherMap.put("id", voucherheader.getId());
                voucherMap.put("vouchernumber", voucherheader.getVoucherNumber());
                voucherMap.put("type", voucherheader.getType());
                voucherMap.put("name", voucherheader.getName());
                voucherMap.put("deptName", voucherheader.getVouchermis().getDepartmentid().getName());
                voucherMap.put("voucherdate", voucherheader.getVoucherDate());
                voucherMap.put("fundname", voucherheader.getFundId().getName());
                if (voucherheader.getModuleId() == null) {
                    voucherMap.put("source", "Internal");
                } else {
                    voucherMap.put("source", this.sourceMap.get(voucherheader.getModuleId()));
                }
                voucherMap.put("amount", amt.setScale(2, 6).toString());
                voucherMap.put("status", this.getVoucherStatus(voucherheader.getStatus().intValue()));
                this.voucherList.add(voucherMap);
            }
            this.pagedResults.setList(this.voucherList);
        } else {
            for (CVoucherHeader voucherheader : list) {
                if (voucherheader.getState() != null) {
                    EgBillregistermis billMis = (EgBillregistermis)this.persistenceService.find("from EgBillregistermis where voucherHeader.id=?", new Object[]{voucherheader.getId()});
                    if (billMis != null) {
                        ismodifyJv = billMis.getEgBillregister().getState() == null && voucherheader.getState().getValue().contains("END");
                    } else if (voucherheader.getName().equalsIgnoreCase("JVGeneral") && voucherheader.getState().getValue().contains("END")) {
                        ismodifyJv = true;
                    }
                } else {
                    ismodifyJv = true;
                }
                if (!ismodifyJv) continue;
                voucherMap = new HashMap();
                voucherMap.put("id", voucherheader.getId());
                voucherMap.put("vouchernumber", voucherheader.getVoucherNumber());
                voucherMap.put("type", voucherheader.getType());
                voucherMap.put("name", voucherheader.getName());
                voucherMap.put("deptName", voucherheader.getVouchermis().getDepartmentid().getName());
                voucherMap.put("voucherdate", voucherheader.getVoucherDate());
                voucherMap.put("fundname", voucherheader.getFundId().getName());
                if (voucherheader.getModuleId() == null) {
                    voucherMap.put("source", "Internal");
                } else {
                    voucherMap.put("source", this.sourceMap.get(voucherheader.getModuleId()));
                }
                voucherMap.put("amount", voucherheader.getTotalAmount().setScale(2, 6).toString());
                voucherMap.put("status", this.getVoucherStatus(voucherheader.getStatus().intValue()));
                this.voucherList.add(voucherMap);
            }
        }
        return SEARCH;
    }

    private String getVoucherStatus(int status) {
        if (FinancialConstants.CREATEDVOUCHERSTATUS.equals(status)) {
            return "Approved";
        }
        if (FinancialConstants.REVERSEDVOUCHERSTATUS.equals(status)) {
            return "Reversed";
        }
        if (FinancialConstants.REVERSALVOUCHERSTATUS.equals(status)) {
            return "Reversal";
        }
        if (FinancialConstants.CANCELLEDVOUCHERSTATUS.equals(status)) {
            return "Cancelled";
        }
        if (FinancialConstants.PREAPPROVEDVOUCHERSTATUS.equals(status)) {
            return "Preapproved";
        }
        return "";
    }

    public void finYearDate() {
        String financialYearId = this.financialYearDAO.getCurrYearFiscalId();
        this.fromDate = financialYearId == null || financialYearId.equals("") ? new Date() : (Date)this.persistenceService.find("select startingDate  from CFinancialYear where id=?", new Object[]{Long.parseLong(financialYearId)});
    }

    public void setFinancialYearDAO(FinancialYearDAO financialYearDAO) {
        this.financialYearDAO = financialYearDAO;
    }

    protected void getHeaderFields() {
        List appConfigList = this.persistenceService.findAllBy("from AppConfig where key_name = 'DEFAULT_SEARCH_MISATTRRIBUTES'", new Object[0]);
        for (AppConfig appConfig : appConfigList) {
            for (AppConfigValues appConfigVal : appConfig.getAppDataValues()) {
                String value = appConfigVal.getValue();
                String header = value.substring(0, value.indexOf(124));
                this.headerFields.add(header);
                String mandate = value.substring(value.indexOf(124) + 1);
                if (!mandate.equalsIgnoreCase("M")) continue;
                this.mandatoryFields.add(header);
            }
        }
    }

    public void validate() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Inside Validate Method");
        }
        if (this.fromDate == null) {
            this.addFieldError("From Date", this.getText("Please Enter From Date"));
        }
        if (this.toDate == null) {
            this.addFieldError("To Date", this.getText("Please Enter To Date"));
        }
        this.checkMandatoryField("fundId", "fund", (Object)this.voucherHeader.getFundId(), "voucher.fund.mandatory");
        this.checkMandatoryField("vouchermis.departmentid", "department", (Object)this.voucherHeader.getVouchermis().getDepartmentid(), "voucher.department.mandatory");
        this.checkMandatoryField("vouchermis.schemeid", "scheme", (Object)this.voucherHeader.getVouchermis().getSchemeid(), "voucher.scheme.mandatory");
        this.checkMandatoryField("vouchermis.subschemeid", "subscheme", (Object)this.voucherHeader.getVouchermis().getSubschemeid(), "voucher.subscheme.mandatory");
        this.checkMandatoryField("vouchermis.functionary", "functionary", (Object)this.voucherHeader.getVouchermis().getFunctionary(), "voucher.functionary.mandatory");
        this.checkMandatoryField("fundsourceId", "fundsource", (Object)this.voucherHeader.getVouchermis().getFundsource(), "voucher.fundsource.mandatory");
        this.checkMandatoryField("vouchermis.divisionId", "field", (Object)this.voucherHeader.getVouchermis().getDivisionid(), "voucher.field.mandatory");
    }

    protected void checkMandatoryField(String objectName, String fieldName, Object value, String errorKey) {
        if (this.mandatoryFields.contains(fieldName) && value == null) {
            this.addFieldError(objectName, this.getText(errorKey));
        }
    }

    public boolean isFieldMandatory(String field) {
        return this.mandatoryFields.contains(field);
    }

    public boolean shouldShowHeaderField(String field) {
        return this.headerFields.contains(field);
    }

    public List<Map<String, Object>> getVoucherList() {
        return this.voucherList;
    }

    public String ajaxLoadSchemes() {
        this.schemeList = this.persistenceService.findAllBy(" from Scheme where fund=?", new Object[]{this.voucherHeader.getFundId()});
        return "schemes";
    }

    public String ajaxLoadSubSchemes() {
        this.schemeList = this.persistenceService.findAllBy(" from SubScheme where scheme=?", new Object[]{this.voucherHeader.getVouchermis().getSchemeid()});
        return "schemes";
    }

    public List<Object> getSchemeList() {
        return this.schemeList;
    }

    public void setSchemeId(Integer schemeId) {
        this.voucherHeader.getVouchermis().setSchemeid((Scheme)this.persistenceService.find(" from Scheme where id=?", new Object[]{schemeId}));
    }

    public void setVoucherHeader(CVoucherHeader voucherHeader) {
        this.voucherHeader = voucherHeader;
    }

    public void setVoucherSearchUtil(VoucherSearchUtil voucherSearchUtil) {
        this.voucherSearchUtil = voucherSearchUtil;
    }

    public Date getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(Date fromDate) {
        this.fromDate = fromDate;
    }

    public Date getToDate() {
        return this.toDate;
    }

    public void setToDate(Date toDate) {
        this.toDate = toDate;
    }

    public Map<String, String> getNameList() {
        return this.nameList;
    }

    public void setNameList(Map<String, String> nameList) {
        this.nameList = nameList;
    }

    public Map<Integer, String> getSourceMap() {
        return this.sourceMap;
    }

    public String getShowMode() {
        return this.showMode;
    }

    public void setShowMode(String showMode) {
        this.showMode = showMode;
    }

    public Integer getPage() {
        return this.page;
    }

    public void setPage(Integer page) {
        this.page = page;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public EgovPaginatedList getPagedResults() {
        return this.pagedResults;
    }

    public void setPagedResults(EgovPaginatedList pagedResults) {
        this.pagedResults = pagedResults;
    }

    public List<String> getVoucherTypes() {
        return this.voucherTypes;
    }

    public void setVoucherTypes(List<String> voucherTypes) {
        this.voucherTypes = voucherTypes;
    }

    public Map<String, List<String>> getVoucherNames() {
        return this.voucherNames;
    }

    public void setVoucherNames(Map<String, List<String>> voucherNames) {
        this.voucherNames = voucherNames;
    }
}

