/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.voucher;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.egov.billsaccounting.services.CreateVoucher;
import org.egov.commons.CVoucherHeader;
import org.egov.egf.web.actions.voucher.BaseVoucherAction;
import org.egov.infra.admin.master.entity.AppConfig;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.model.voucher.VoucherDetails;
import org.egov.services.voucher.VoucherService;
import org.egov.utils.Constants;
import org.springframework.beans.factory.annotation.Autowired;

public class JournalVoucherReverseAction
extends BaseVoucherAction {
    private static final long serialVersionUID = -6585536610068562966L;
    private static final Logger LOGGER = Logger.getLogger(JournalVoucherReverseAction.class);
    public Map<String, String> nameList = new LinkedHashMap();
    public List<Map<String, Object>> voucherList;
    @Autowired
    public AppConfigValueService appConfigValuesService;
    public String fromDate;
    public String toDate;
    private String showMode;
    private String message;
    private String button;
    private String cgNumber;
    private boolean close;
    private String target;
    public static final String SEARCH = "search";
    public static final String REVERSE = "reverse";
    public final SimpleDateFormat sdf = new SimpleDateFormat("dd-MMM-yyyy", Constants.LOCALE);
    public final SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy", Constants.LOCALE);
    private List<VoucherDetails> billDetailslist;
    private List<VoucherDetails> subLedgerlist;
    private VoucherService voucherService;
    @Autowired
    private CreateVoucher createVoucher;

    public String beforeReverse() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"JournalVoucherReverseAction  | reverse | Start ");
        }
        Map vhInfoMap = this.voucherService.getVoucherInfo(this.voucherHeader.getId());
        this.voucherHeader = (CVoucherHeader)vhInfoMap.get("voucherHeader");
        this.billDetailslist = (List)vhInfoMap.get("glDetailList");
        this.subLedgerlist = (List)vhInfoMap.get("subLedgerDetail");
        this.loadSchemeSubscheme();
        return REVERSE;
    }

    @ValidationErrorPage(value="reverse")
    public String reverse() {
        this.saveReverse();
        this.setMessage(this.getText("transaction.success") + this.voucherHeader.getVoucherNumber());
        return REVERSE;
    }

    public void saveReverse() {
        Date reversalDate;
        HashMap<String, Object> reversalVoucherMap;
        CVoucherHeader reversalVoucher;
        block14: {
            reversalVoucher = null;
            reversalVoucherMap = new HashMap<String, Object>();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("getReversalVoucherDate    :::::::::::::" + this.getReversalVoucherDate()));
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("getReversalVoucherNumber    :::::::::::::" + this.getReversalVoucherNumber()));
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("voucherHeader.getId()    :::::::::::::" + this.voucherHeader.getId()));
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("voucherHeader.getType()    :::::::::::::" + this.voucherHeader.getType()));
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("voucherHeader.getName()    :::::::::::::" + this.voucherHeader.getName()));
            }
            reversalVoucherMap.put("Original voucher header id", this.voucherHeader.getId());
            reversalVoucherMap.put("Reversal voucher type", "Journal Voucher");
            reversalVoucherMap.put("Reversal voucher name", "JVGeneral");
            this.setTarget("stay");
            reversalDate = null;
            try {
                if (this.getReversalVoucherDate() != null && !this.getReversalVoucherDate().equals("")) {
                    String str1 = this.getReversalVoucherDate();
                    reversalDate = this.formatter.parse(str1);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("voucherHeader.reversalDate     :::::::::::::" + reversalDate.getDate()));
                    }
                }
            }
            catch (ParseException pe) {
                if (!LOGGER.isDebugEnabled()) break block14;
                LOGGER.debug((Object)("voucherHeader.reversalDate     :::::::::::::" + pe));
            }
        }
        reversalVoucherMap.put("Reversal voucher date", reversalDate);
        reversalVoucherMap.put("Reversal voucher number", this.getReversalVoucherNumber());
        ArrayList<HashMap<String, Object>> reversalList = new ArrayList<HashMap<String, Object>>();
        reversalList.add(reversalVoucherMap);
        try {
            reversalVoucher = this.createVoucher.reverseVoucher(reversalList);
        }
        catch (ValidationException e) {
            this.clearMessages();
            this.resetVoucherHeader();
            if (this.subLedgerlist.size() == 0) {
                this.subLedgerlist.add(new VoucherDetails());
            }
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.add(new ValidationError("exp", ((ValidationError)e.getErrors().get(0)).getMessage()));
            throw new ValidationException(errors);
        }
        catch (Exception e) {
            this.clearMessages();
            this.resetVoucherHeader();
            if (this.subLedgerlist.size() == 0) {
                this.subLedgerlist.add(new VoucherDetails());
            }
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.add(new ValidationError("exp", e.getMessage()));
            throw new ValidationException(errors);
        }
        this.addActionMessage(this.getText("transaction.success") + reversalVoucher.getVoucherNumber());
        this.voucherHeader = reversalVoucher;
        this.setTarget("success");
    }

    protected void getHeaderFieldsLoad() {
        List appConfigList = this.persistenceService.findAllBy("from AppConfig where key_name = 'DEFAULT_SEARCH_MISATTRRIBUTES'", new Object[0]);
        for (AppConfig appConfig : appConfigList) {
            for (AppConfigValues appConfigVal : appConfig.getAppDataValues()) {
                String value = appConfigVal.getValue();
                String header = value.substring(0, value.indexOf(124));
                this.headerFields.add(header);
                String mandate = value.substring(value.indexOf(124) + 1);
                if (!mandate.equalsIgnoreCase("M")) continue;
                this.mandatoryFields.add(header);
            }
        }
    }

    public Map<String, String> getNameList() {
        return this.nameList;
    }

    public void setNameList(Map<String, String> nameList) {
        this.nameList = nameList;
    }

    public Map<String, String> getVoucherNameMap(String type) {
        List voucherNameList = this.getPersistenceService().findAllBy("select  distinct name from  CVoucherHeader where type=?", new Object[]{type});
        this.nameList = new LinkedHashMap();
        for (Object voucherName : voucherNameList) {
            this.nameList.put((String)voucherName, (String)voucherName);
        }
        return this.nameList;
    }

    public String getShowMode() {
        return this.showMode;
    }

    public void setShowMode(String showMode) {
        this.showMode = showMode;
    }

    public StateAware getModel() {
        return this.voucherHeader;
    }

    public void setVoucherHeader(CVoucherHeader voucherHeader) {
        this.voucherHeader = voucherHeader;
    }

    public String getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(String fromDate) {
        this.fromDate = fromDate;
    }

    public String getToDate() {
        return this.toDate;
    }

    public void setToDate(String toDate) {
        this.toDate = toDate;
    }

    public VoucherService getVoucherService() {
        return this.voucherService;
    }

    public void setVoucherService(VoucherService voucherService) {
        this.voucherService = voucherService;
    }

    public void setBillDetailslist(List<VoucherDetails> billDetailslist) {
        this.billDetailslist = billDetailslist;
    }

    public List<VoucherDetails> getSubLedgerlist() {
        return this.subLedgerlist;
    }

    public void setSubLedgerlist(List<VoucherDetails> subLedgerlist) {
        this.subLedgerlist = subLedgerlist;
    }

    public String getCgNumber() {
        return this.cgNumber;
    }

    public void setCgNumber(String cgNumber) {
        this.cgNumber = cgNumber;
    }

    public List<VoucherDetails> getBillDetailslist() {
        return this.billDetailslist;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public void setClose(boolean close) {
        this.close = close;
    }

    public boolean isClose() {
        return this.close;
    }

    public String getButton() {
        return this.button;
    }

    public void setButton(String button) {
        this.button = button;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String getFormattedNewDate() {
        return Constants.DDMMYYYYFORMAT2.format(new Date());
    }
}

