/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.revenue;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.commons.CFinancialYear;
import org.egov.egf.revenue.Grant;
import org.egov.egf.web.actions.revenue.BaseRevenueAction;
import org.egov.infra.admin.master.entity.Department;
import org.egov.utils.ReportHelper;

@Results(value={@Result(name="view", location="searchRevenueReport-view.jsp")})
public class SearchRevenueReportAction
extends BaseRevenueAction {
    private static final long serialVersionUID = 2577746024306261450L;
    private static final Logger LOGGER = Logger.getLogger(SearchRevenueReportAction.class);
    private ReportHelper reportHelper;
    private InputStream inputStream;
    private List<String> grantTypeList;
    private Long finYearId;
    private String deptId;
    private String grantTypeStr;

    public void prepare() {
        this.grantTypeList = new ArrayList();
        this.grantTypeList.add("Central Finance Commission");
        this.grantTypeList.add("Entertainment Tax");
        this.grantTypeList.add("Stamp Duty");
        this.grantTypeList.add("State Finance Commission");
        this.addDropdownData("finanYearList", this.persistenceService.findAllBy("from CFinancialYear  where isActive=true order by finYearRange desc", new Object[0]));
        this.addDropdownData("grtTypeList", this.grantTypeList);
        this.addDropdownData("deptList", this.persistenceService.findAllBy("from Department order by deptName ", new Object[0]));
    }

    @SkipValidation
    @Action(value="/revenue/searchRevenueReport-beforeSearch")
    public String beforeSearch() {
        return "view";
    }

    @SkipValidation
    @Action(value="/revenue/searchRevenueReport-search")
    public String search() {
        StringBuffer query = new StringBuffer();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("Search Query:-Financials Year id" + this.finYearId));
        }
        query.append("select distinct gr.financialYear ,gr.grantType,gr.department From Grant gr where gr.financialYear.id=" + this.finYearId);
        if (!this.deptId.equals("-1") && !this.grantTypeStr.equals("-1")) {
            query.append(" and gr.grantType='" + this.grantTypeStr + "' and gr.department.id='" + this.deptId + "'");
        } else {
            if (!this.grantTypeStr.equals("-1")) {
                query.append(" and gr.grantType='" + this.grantTypeStr + "'");
            }
            if (!this.deptId.equals("-1")) {
                query.append(" and gr.department.id='" + this.deptId + "'");
            }
        }
        List findAllBy = this.persistenceService.findAllBy(query.toString(), new Object[0]);
        this.grantsList = new ArrayList();
        for (Object[] ob : findAllBy) {
            CFinancialYear fy = (CFinancialYear)ob[0];
            String type = (String)ob[1];
            Department dept = (Department)ob[2];
            Grant grant2 = new Grant();
            grant2.setFinancialYear(fy);
            grant2.setDepartment(dept);
            grant2.setGrantType(type);
            this.grantsList.add(grant2);
        }
        return "view";
    }

    public Long getFinYearId() {
        return this.finYearId;
    }

    public void setFinYearId(Long finYearId) {
        this.finYearId = finYearId;
    }

    public List<String> getGrantTypeList() {
        return this.grantTypeList;
    }

    public void setGrantTypeList(List<String> grantTypeList) {
        this.grantTypeList = grantTypeList;
    }

    public String getGrantTypeStr() {
        return this.grantTypeStr;
    }

    public void setGrantTypeStr(String grantTypeStr) {
        this.grantTypeStr = grantTypeStr;
    }

    public ReportHelper getReportHelper() {
        return this.reportHelper;
    }

    public void setReportHelper(ReportHelper reportHelper) {
        this.reportHelper = reportHelper;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public String getDeptId() {
        return this.deptId;
    }

    public void setDeptId(String deptId) {
        this.deptId = deptId;
    }
}

