/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.revenue;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.commons.Bankaccount;
import org.egov.commons.Bankbranch;
import org.egov.commons.CVoucherHeader;
import org.egov.egf.revenue.FixedDeposit;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infstr.services.PersistenceService;
import org.egov.model.instrument.InstrumentHeader;
import org.egov.utils.ReportHelper;
import org.hibernate.SQLQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@Results(value={@Result(name="PDF", type="stream", location="inputStream", params={"inputName", "inputStream", "contentType", "application/pdf", "contentDisposition", "no-cache;filename=FixedDepositReport.pdf"}), @Result(name="XLS", type="stream", location="inputStream", params={"inputName", "inputStream", "contentType", "application/xls", "contentDisposition", "no-cache;filename=FixedDepositReport.xls"})})
@ParentPackage(value="egov")
public class FixedDepositAction
extends BaseFormAction {
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    private static final long serialVersionUID = -145348568312338226L;
    protected List<FixedDeposit> fixedDepositList;
    private List<Bankbranch> bankBranchList;
    private BigDecimal voucherAmount;
    private FixedDeposit fixedDep = new FixedDeposit();
    private String serialNo = "";
    private ReportHelper reportHelper;
    private InputStream inputStream;
    private Date toDate;
    private Date fromDate;
    private String mode;
    public static final String VIEW = "view";
    private final SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
    private List<Bankaccount> bankAccountListTemp = new ArrayList();
    protected List<FixedDeposit> childFDList = new ArrayList();
    private final String jasperpath = "/reports/templates/FixedDepositReport.jasper";
    private static final Logger LOGGER = Logger.getLogger(FixedDepositAction.class);

    public FixedDepositAction() {
        this.fixedDep = new FixedDeposit();
    }

    public void prepare() {
        this.bankBranchList = this.persistenceService.findAllBy("from Bankbranch br where br.isactive=true order by br.bank.name asc ", new Object[0]);
    }

    public Object getModel() {
        return this.fixedDep;
    }

    @SkipValidation
    @Action(value="/revenue/fixedDeposit-newForm")
    public String newForm() {
        this.fixedDepositList = new ArrayList();
        this.fixedDepositList.add(new FixedDeposit());
        this.childFDList.add(new FixedDeposit());
        this.mode = "new";
        return "new";
    }

    @SkipValidation
    @Action(value="/revenue/fixedDeposit-beforeEdit")
    public String beforeEdit() {
        this.fixedDepositList = new ArrayList();
        this.mode = "edit";
        return "edit";
    }

    @SkipValidation
    @Action(value="/revenue/fixedDeposit-beforeSearch")
    public String beforeSearch() {
        this.fixedDepositList = new ArrayList();
        this.mode = VIEW;
        return VIEW;
    }

    @SkipValidation
    @Action(value="/revenue/fixedDeposit-search")
    public String search() {
        StringBuffer query = new StringBuffer();
        query.append("From FixedDeposit ");
        if (this.fromDate != null && this.toDate != null) {
            query.append("where date >='" + this.sdf.format(this.fromDate) + "' and date <='" + this.sdf.format(this.toDate) + "'");
        } else if (this.fromDate == null && this.toDate == null) {
            query.append("where date<= CURRENT_DATE");
        } else if (this.fromDate != null) {
            query.append("where date>='" + this.sdf.format(this.fromDate) + "'");
        } else {
            query.append("where date<='" + this.sdf.format(this.toDate) + "'");
        }
        query.append("  order by id");
        this.fixedDepositList = this.persistenceService.findAllBy(query.toString(), new Object[0]);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("Fixed deposit size= " + this.fixedDepositList.size()));
        }
        for (FixedDeposit fd : this.fixedDepositList) {
            this.bankAccountListTemp = this.getPersistenceService().findAllBy("from Bankaccount ba where ba.bankbranch.id=? and isactive=true order by ba.chartofaccounts.glcode", new Object[]{fd.getBankBranch().getId()});
            fd.setBankAccountList(this.bankAccountListTemp);
            if (fd.getReceiptAmount() == null) {
                fd.setReceiptAmount(BigDecimal.ZERO);
            }
            if (fd.getParentId() != null) {
                fd.setParentTemp(fd.getParentId().getId());
                continue;
            }
            fd.setParentId(null);
        }
        if (VIEW.equalsIgnoreCase(this.mode)) {
            return VIEW;
        }
        return "edit";
    }

    @Action(value="/revenue/fixedDeposit-update")
    public String saveOrupdate() {
        for (FixedDeposit fd : this.fixedDepositList) {
            fd.setBankBranch((Bankbranch)this.persistenceService.find("from Bankbranch where id=?", new Object[]{fd.getBankBranch().getId()}));
            fd.setBankAccount((Bankaccount)this.persistenceService.find("from Bankaccount where id=?", new Object[]{fd.getBankAccount().getId()}));
            fd.setOutFlowVoucher((CVoucherHeader)this.persistenceService.find("from CVoucherHeader where id=?", new Object[]{fd.getOutFlowVoucher().getId()}));
            if (fd.getInFlowVoucher().getId() != null) {
                fd.setInFlowVoucher((CVoucherHeader)this.persistenceService.find("from CVoucherHeader where id=?", new Object[]{fd.getInFlowVoucher().getId()}));
            } else {
                fd.setInFlowVoucher(null);
            }
            if (fd.getChallanReceiptVoucher().getId() != null) {
                fd.setChallanReceiptVoucher((CVoucherHeader)this.persistenceService.find("from CVoucherHeader where id=?", new Object[]{fd.getChallanReceiptVoucher().getId()}));
            } else {
                fd.setChallanReceiptVoucher(null);
            }
            if (fd.getInstrumentHeader().getId() != null) {
                fd.setInstrumentHeader((InstrumentHeader)this.persistenceService.find("from InstrumentHeader where id=?", new Object[]{fd.getInstrumentHeader().getId()}));
            } else {
                fd.setInstrumentHeader(null);
            }
            if (fd.getReceiptAmount() == null) continue;
            fd.setReceiptAmount(BigDecimal.ZERO);
        }
        if (this.childFDList.size() > 0) {
            for (FixedDeposit fdd : this.fixedDepositList) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info((Object)("is EXTEND contains" + fdd.getExtend()));
                }
                for (FixedDeposit chld : this.childFDList) {
                    if (!fdd.getReferenceNumber().equals(chld.getReferenceNumber())) continue;
                    chld.setParentId(fdd);
                    chld.setBankBranch((Bankbranch)this.persistenceService.find("from Bankbranch where id=?", new Object[]{chld.getBankBranch().getId()}));
                    chld.setBankAccount((Bankaccount)this.persistenceService.find("from Bankaccount where id=?", new Object[]{chld.getBankAccount().getId()}));
                    chld.setOutFlowVoucher((CVoucherHeader)this.persistenceService.find("from CVoucherHeader where id=?", new Object[]{chld.getOutFlowVoucher().getId()}));
                    if (chld.getInstrumentHeader().getId() != null) {
                        chld.setInstrumentHeader((InstrumentHeader)this.persistenceService.find("from InstrumentHeader where id=?", new Object[]{chld.getInstrumentHeader().getId()}));
                    } else {
                        chld.setInstrumentHeader(null);
                    }
                    if (chld.getInFlowVoucher().getId() != null) {
                        chld.setInFlowVoucher((CVoucherHeader)this.persistenceService.find("from CVoucherHeader where id=?", new Object[]{chld.getInFlowVoucher().getId()}));
                    } else {
                        chld.setInFlowVoucher(null);
                    }
                    if (chld.getChallanReceiptVoucher().getId() != null) {
                        chld.setChallanReceiptVoucher((CVoucherHeader)this.persistenceService.find("from CVoucherHeader where id=?", new Object[]{chld.getChallanReceiptVoucher().getId()}));
                        continue;
                    }
                    chld.setChallanReceiptVoucher(null);
                }
                this.persistenceService.persist((Object)fdd);
                for (FixedDeposit cld : this.childFDList) {
                    this.persistenceService.persist((Object)cld);
                }
            }
        } else {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)"Child doesnot exist");
            }
            for (FixedDeposit fdd : this.fixedDepositList) {
                this.persistenceService.persist((Object)fdd);
            }
        }
        if ("edit".equalsIgnoreCase(this.mode)) {
            return "edit";
        }
        return "new";
    }

    public String getUlbName() {
        SQLQuery query = this.persistenceService.getSession().createSQLQuery("select name from companydetail");
        List result = query.list();
        if (result != null) {
            return (String)result.get(0);
        }
        return "";
    }

    Map<String, Object> getParamMap() {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        String header = "";
        paramMap.put("ulbName", this.getUlbName());
        paramMap.put("heading", "");
        return paramMap;
    }

    public List<Bankaccount> getBankAccountListTemp() {
        return this.bankAccountListTemp;
    }

    public void setBankAccountListTemp(List<Bankaccount> bankAccountListTemp) {
        this.bankAccountListTemp = bankAccountListTemp;
    }

    public String exportPdf() throws JRException, IOException {
        this.fixedDepositList = new ArrayList();
        this.search();
        ArrayList<FixedDeposit> dataSource = new ArrayList<FixedDeposit>();
        for (FixedDeposit row : this.fixedDepositList) {
            row.setBankBranch((Bankbranch)this.persistenceService.find("from Bankbranch where id=?", new Object[]{row.getBankBranch().getId()}));
            row.setBankAccount((Bankaccount)this.persistenceService.find("from Bankaccount where id=?", new Object[]{row.getBankAccount().getId()}));
            dataSource.add(row);
        }
        this.setInputStream(this.reportHelper.exportPdf(this.getInputStream(), "/reports/templates/FixedDepositReport.jasper", this.getParamMap(), dataSource));
        return "PDF";
    }

    public String exportXls() throws JRException, IOException {
        this.fixedDepositList = new ArrayList();
        this.search();
        ArrayList<FixedDeposit> dataSource = new ArrayList<FixedDeposit>();
        for (FixedDeposit row : this.fixedDepositList) {
            row.setBankBranch((Bankbranch)this.persistenceService.find("from Bankbranch where id=?", new Object[]{row.getBankBranch().getId()}));
            row.setBankAccount((Bankaccount)this.persistenceService.find("from Bankaccount where id=?", new Object[]{row.getBankAccount().getId()}));
            dataSource.add(row);
        }
        this.setInputStream(this.reportHelper.exportXls(this.getInputStream(), "/reports/templates/FixedDepositReport.jasper", this.getParamMap(), dataSource));
        return "XLS";
    }

    public List<FixedDeposit> getFixedDepositList() {
        return this.fixedDepositList;
    }

    public void setFixedDepositList(List<FixedDeposit> fixedDepositList) {
        this.fixedDepositList = fixedDepositList;
    }

    public List<Bankbranch> getBankBranchList() {
        return this.bankBranchList;
    }

    public void setBankBranchList(List<Bankbranch> bankBranchList) {
        this.bankBranchList = bankBranchList;
    }

    public BigDecimal getVoucherAmount() {
        return this.voucherAmount;
    }

    public void setVoucherAmount(BigDecimal voucherAmount) {
        this.voucherAmount = voucherAmount;
    }

    public List<FixedDeposit> getChildFDList() {
        return this.childFDList;
    }

    public FixedDeposit getFixedDep() {
        return this.fixedDep;
    }

    public void setFixedDep(FixedDeposit fixedDep) {
        this.fixedDep = fixedDep;
    }

    public String getSerialNo() {
        return this.serialNo;
    }

    public void setSerialNo(String serialNo) {
        this.serialNo = serialNo;
    }

    public void setChildFDList(List<FixedDeposit> childFDList) {
        this.childFDList = childFDList;
    }

    public ReportHelper getReportHelper() {
        return this.reportHelper;
    }

    public void setReportHelper(ReportHelper reportHelper) {
        this.reportHelper = reportHelper;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public Date getToDate() {
        return this.toDate;
    }

    public void setToDate(Date toDate) {
        this.toDate = toDate;
    }

    public Date getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(Date fromDate) {
        this.fromDate = fromDate;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public List<FixedDeposit> getFixedDepositListx() {
        return this.fixedDepositList;
    }
}

