/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.report.loangrant;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import net.sf.jasperreports.engine.JRException;
import org.apache.log4j.Logger;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.egov.commons.Accountdetailtype;
import org.egov.commons.service.EntityTypeService;
import org.egov.egf.masters.model.LoanGrantBean;
import org.egov.egf.web.actions.masters.loangrant.LoanGrantBaseAction;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.infstr.services.PersistenceService;
import org.egov.services.report.LoanGrantService;
import org.egov.utils.ReportHelper;
import org.hibernate.SQLQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

@Results(value={@Result(name="searchGC", location="loanGrantReport-searchGC.jsp"), @Result(name="searchLoan", location="loanGrantReport-searchLoan.jsp"), @Result(name="PDF", type="stream", location="inputStream", params={"inputName", "inputStream", "contentType", "application/pdf", "contentDisposition", "no-cache;filename=LoanGrant.pdf"}), @Result(name="XLS", type="stream", location="inputStream", params={"inputName", "inputStream", "contentType", "application/xls", "contentDisposition", "no-cache;filename=LoanGrant.xls"}), @Result(name="HTML", type="stream", location="inputStream", params={"inputName", "inputStream", "contentType", "text/html", "contentDisposition", "no-cache;filename=LoanGrant.html"})})
public class LoanGrantReportAction
extends LoanGrantBaseAction {
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    private static final String GRANT_CONTRIBUTION = "GrantContribution";
    private static final String LOAN_OUT_STANDINNG = "LoanOutStandinng";
    private static final String SEARCH_LOAN = "searchLoan";
    private static final String PDF = "PDF";
    private static final String HTML = "HTML";
    private static final String XLS = "XLS";
    private static final long serialVersionUID = 6488591368651970475L;
    private static final String NEWGC = "searchGC";
    private static final String RESULTSGC = "resultsGC";
    private LoanGrantService lgService;
    private Long agencyId;
    List<Object> searchGCList;
    List<Object> repaymentList;
    private final String jasperpathForGrant = "/reports/templates/GrantContribution.jasper";
    private final String jasperpathForLoan = "/reports/templates/LoanOutStanding.jasper";
    private InputStream inputStream;
    ReportHelper reportHelper;
    static final Logger LOGGER = Logger.getLogger(LoanGrantReportAction.class);

    public void prepare() {
        super.prepare();
        List agencyList = this.persistenceService.findAllBy("from FundingAgency where isActive=true order by name ", new Object[0]);
        this.addDropdownData("agencyList", agencyList);
    }

    @Action(value="/report/loangrant/loanGrantReport-newFormGC")
    public String newFormGC() {
        return NEWGC;
    }

    public String searchGC() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting Grant Contribution Search");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Passed Params are FundId:" + this.fundId + " schemeId:" + this.schemeId + " subSchemeId" + this.subSchemeId + " agencyId" + this.agencyId));
        }
        Accountdetailtype pcType = (Accountdetailtype)this.persistenceService.find("from Accountdetailtype  where name='PROJECTCODE'");
        Accountdetailtype agencyType = (Accountdetailtype)this.persistenceService.find("from Accountdetailtype  where name='FundingAgency'");
        this.searchGCList = this.lgService.searchGC(this.schemeId, this.subSchemeId, this.fromDate, this.toDate, this.agencyId, pcType.getId(), agencyType.getId(), this.fundId);
        if (this.searchGCList == null || this.searchGCList.size() == 0) {
            this.addActionMessage("No Records Found");
            throw new ValidationException(Arrays.asList(new ValidationError("No Records Found", "no.records.found")));
        }
        String table = pcType.getFullQualifiedName();
        Class<?> service = null;
        try {
            service = Class.forName(table);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error((Object)"Cannot load class", (Throwable)e);
        }
        String simpleName = service.getSimpleName();
        simpleName = simpleName.substring(0, 1).toLowerCase() + simpleName.substring(1) + "Service";
        WebApplicationContext wac = WebApplicationContextUtils.getWebApplicationContext((ServletContext)ServletActionContext.getServletContext());
        EntityTypeService entityService = (EntityTypeService)wac.getBean(simpleName);
        String allAssetCodes = "";
        int i = 0;
        BigDecimal grantTotal = BigDecimal.ZERO;
        BigDecimal agencyTotal = BigDecimal.ZERO;
        BigDecimal pcwiseTotal = BigDecimal.ZERO;
        for (Object obj : this.searchGCList) {
            LoanGrantBean lg = (LoanGrantBean)obj;
            if (lg.getDetailType() == pcType.getId()) {
                List assetCodeList;
                block14: {
                    allAssetCodes = "";
                    assetCodeList = null;
                    try {
                        assetCodeList = entityService.getAssetCodesForProjectCode(lg.getDetailKey());
                    }
                    catch (ValidationException e) {
                        if (!LOGGER.isDebugEnabled()) break block14;
                        LOGGER.debug((Object)"No Details Found Setting to Empty for asset codes");
                    }
                }
                if (assetCodeList != null && assetCodeList.size() > 0) {
                    i = 0;
                    for (String assetCode : assetCodeList) {
                        allAssetCodes = i == 0 ? allAssetCodes + assetCode : allAssetCodes + "," + assetCode;
                        ++i;
                    }
                }
                lg.setStatus(allAssetCodes);
            }
            if (lg.getGrantAmount() != null) {
                grantTotal = grantTotal.add(lg.getGrantAmount());
            }
            if (lg.getAgencyAmount() != null) {
                agencyTotal = agencyTotal.add(lg.getAgencyAmount());
            }
            if (lg.getAmount() == null) continue;
            pcwiseTotal = pcwiseTotal.add(lg.getAmount());
        }
        String totalStatus = "A-B=" + grantTotal.subtract(agencyTotal).setScale(2);
        LoanGrantBean lgTotal = new LoanGrantBean(pcwiseTotal, agencyTotal, grantTotal, "Total", totalStatus);
        this.searchGCList.add(lgTotal);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"exiting from Grant Contribution Search");
        }
        return RESULTSGC;
    }

    @Action(value="/report/loangrant/loanGrantReport-newFormLoan")
    public String newFormLoan() {
        return SEARCH_LOAN;
    }

    public String searchLoan() {
        this.clearMessages();
        Accountdetailtype agencyType = (Accountdetailtype)this.persistenceService.find("from Accountdetailtype  where name='FundingAgency'");
        this.repaymentList = this.lgService.getLoanBy(this.schemeId, this.agencyId, agencyType.getId(), this.fundId);
        if (this.repaymentList == null || this.repaymentList.size() == 0) {
            throw new ValidationException(Arrays.asList(new ValidationError("No Records Found", "no.records.found")));
        }
        BigDecimal soFarPaid = BigDecimal.ZERO;
        BigDecimal balance = BigDecimal.ZERO;
        for (Object ob : this.repaymentList) {
            LoanGrantBean lg = (LoanGrantBean)ob;
            if (lg.getLoanAmount() != null) {
                balance = lg.getBalance();
                soFarPaid = lg.getAgencyAmount();
                continue;
            }
            soFarPaid = soFarPaid.add(lg.getAmount());
            lg.setAgencyAmount(soFarPaid);
            balance = balance.subtract(lg.getAmount());
            lg.setBalance(balance);
        }
        return SEARCH_LOAN;
    }

    public void setLgService(LoanGrantService lgService) {
        this.lgService = lgService;
    }

    public Long getAgencyId() {
        return this.agencyId;
    }

    public void setAgencyId(Long agencyId) {
        this.agencyId = agencyId;
    }

    public void setSearchGCList(List<Object> searchGCList) {
        this.searchGCList = searchGCList;
    }

    @ValidationErrorPage(value="searchLoan")
    public String exportLoanPdf() {
        return this.generateLoanOutStaindingReport(PDF);
    }

    @ValidationErrorPage(value="searchLoan")
    public String exportLoanXls() {
        return this.generateLoanOutStaindingReport(XLS);
    }

    @ValidationErrorPage(value="searchLoan")
    public String exportLoanHTML() {
        return this.generateLoanOutStaindingReport(HTML);
    }

    public String generateLoanOutStaindingReport(String type) {
        try {
            this.searchLoan();
            this.inputStream = type.equalsIgnoreCase(PDF) ? this.reportHelper.exportPdf(this.inputStream, "/reports/templates/LoanOutStanding.jasper", this.getParamMap(LOAN_OUT_STANDINNG), this.repaymentList) : (type.equalsIgnoreCase(XLS) ? this.reportHelper.exportXls(this.inputStream, "/reports/templates/LoanOutStanding.jasper", this.getParamMap(LOAN_OUT_STANDINNG), this.repaymentList) : this.reportHelper.exportHtml(this.inputStream, "/reports/templates/LoanOutStanding.jasper", this.getParamMap(LOAN_OUT_STANDINNG), this.repaymentList, "pt"));
        }
        catch (JRException e) {
            LOGGER.error((Object)e);
        }
        catch (IOException e) {
            LOGGER.error((Object)e);
        }
        catch (ValidationException e) {
            LOGGER.error((Object)e);
            this.addActionMessage("No Records Found");
            type = SEARCH_LOAN;
        }
        return type;
    }

    public String exportPdf() {
        return this.generateGrantContributionReport(PDF);
    }

    public String exportXls() {
        return this.generateGrantContributionReport(XLS);
    }

    public String exportHTML() {
        return this.generateGrantContributionReport(HTML);
    }

    public String generateGrantContributionReport(String type) {
        try {
            this.searchGC();
            this.inputStream = type.equalsIgnoreCase("pdf") ? this.reportHelper.exportPdf(this.inputStream, "/reports/templates/GrantContribution.jasper", this.getParamMap(GRANT_CONTRIBUTION), this.searchGCList) : (type.equalsIgnoreCase(XLS) ? this.reportHelper.exportXls(this.inputStream, "/reports/templates/GrantContribution.jasper", this.getParamMap(GRANT_CONTRIBUTION), this.searchGCList) : this.reportHelper.exportHtml(this.inputStream, "/reports/templates/GrantContribution.jasper", this.getParamMap(GRANT_CONTRIBUTION), this.searchGCList, "pt"));
        }
        catch (JRException e) {
            LOGGER.error((Object)e);
        }
        catch (IOException e) {
            LOGGER.error((Object)e);
        }
        catch (ValidationException e) {
            return NEWGC;
        }
        return type;
    }

    private Map<String, Object> getParamMap(String name) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        String reportByStr = "";
        reportByStr = name.equalsIgnoreCase(GRANT_CONTRIBUTION) ? "Grant Contribution Report for " : "Loan OutStainding Report for ";
        if (this.schemeId != null) {
            String schemeName = (String)this.persistenceService.find("select name from Scheme where id=?", new Object[]{this.getSchemeId()});
            paramMap.put("reportBy", reportByStr + schemeName);
            paramMap.put("schemeName", schemeName);
        }
        if (this.getSubSchemeId() != null) {
            String subSchemeName = (String)this.persistenceService.find("select name from SubScheme where id=?", new Object[]{this.getSubSchemeId()});
            paramMap.put("reportBy", reportByStr + subSchemeName);
            paramMap.put("subSchemeName", subSchemeName);
        }
        if (this.fundId != null) {
            String fundName = (String)this.persistenceService.find("select name from Fund where id=?", new Object[]{this.fundId});
            paramMap.put("fundName", fundName);
        }
        paramMap.put("fromDate", this.fromDate);
        paramMap.put("toDate", this.toDate);
        paramMap.put("ulbName", this.getUlbName());
        return paramMap;
    }

    private String getUlbName() {
        SQLQuery query = this.persistenceService.getSession().createSQLQuery("select name from companydetail");
        List result = query.list();
        if (result != null) {
            return (String)result.get(0);
        }
        return "";
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public void setReportHelper(ReportHelper reportHelper) {
        this.reportHelper = reportHelper;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }
}

