/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.report;

import com.opensymphony.xwork2.validator.annotations.Validation;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.commons.CGeneralLedger;
import org.egov.commons.CVoucherHeader;
import org.egov.commons.EgModules;
import org.egov.commons.Functionary;
import org.egov.commons.Fund;
import org.egov.commons.Fundsource;
import org.egov.commons.Scheme;
import org.egov.commons.SubScheme;
import org.egov.commons.Vouchermis;
import org.egov.commons.dao.FinancialYearDAO;
import org.egov.egf.model.VoucherReportView;
import org.egov.egf.web.actions.voucher.VoucherSearchAction;
import org.egov.infra.admin.master.entity.AppConfig;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.exception.ApplicationException;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.infra.web.utils.EgovPaginatedList;
import org.egov.infra.workflow.entity.State;
import org.egov.infstr.services.Page;
import org.egov.infstr.services.PersistenceService;
import org.egov.model.contra.ContraJournalVoucher;
import org.egov.model.payment.Paymentheader;
import org.egov.utils.Constants;
import org.egov.utils.FinancialConstants;
import org.egov.utils.ReportHelper;
import org.egov.utils.VoucherHelper;
import org.hibernate.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@Results(value={@Result(name="PDF", type="stream", location="inputStream", params={"inputName", "inputStream", "contentType", "application/pdf", "contentDisposition", "no-cache;filename=VoucherStatusReport.pdf"}), @Result(name="search", location="voucherStatusReport-search.jsp"), @Result(name="XLS", type="stream", location="inputStream", params={"inputName", "inputStream", "contentType", "application/xls", "contentDisposition", "no-cache;filename=VoucherStatusReport.xls"})})
@ParentPackage(value="egov")
@Validation
public class VoucherStatusReportAction
extends BaseFormAction {
    private static final Logger LOGGER = Logger.getLogger(VoucherSearchAction.class);
    public List<Map<String, Object>> voucherList;
    private static final long serialVersionUID = 1L;
    public CVoucherHeader voucherHeader = new CVoucherHeader();
    public final SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy", Constants.LOCALE);
    public Date fromDate = new Date();
    public Date toDate = null;
    private final List<String> headerFields = new ArrayList();
    private final List<String> mandatoryFields = new ArrayList();
    InputStream inputStream;
    private static final String JASPERPATH = "/reports/templates/voucherStatusReport.jasper";
    ReportHelper reportHelper;
    List<Object> voucherReportList = new ArrayList();
    List<CVoucherHeader> voucherDisplayList = new ArrayList();
    private Map<Integer, String> statusMap;
    private final Map<String, Object> paramMap = new HashMap();
    private Map<String, String> nameMap;
    private HashMap<Long, String> voucherIDOwnerNameMap;
    private Integer page = 1;
    private Integer pageSize = 30;
    private EgovPaginatedList pagedResults;
    private String countQry;
    private String modeOfPayment;
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    @Autowired
    private FinancialYearDAO financialYearDAO;
    List<String> voucherTypes = VoucherHelper.VOUCHER_TYPES;
    Map<String, List<String>> voucherNames = VoucherHelper.VOUCHER_TYPE_NAMES;

    public Object getModel() {
        return this.voucherHeader;
    }

    public VoucherStatusReportAction() {
        this.voucherHeader.setVouchermis(new Vouchermis());
        this.addRelatedEntity("vouchermis.departmentid", Department.class);
        this.addRelatedEntity("fundId", Fund.class);
        this.addRelatedEntity("vouchermis.schemeid", Scheme.class);
        this.addRelatedEntity("vouchermis.subschemeid", SubScheme.class);
        this.addRelatedEntity("vouchermis.functionary", Functionary.class);
        this.addRelatedEntity("vouchermis.divisionid", Boundary.class);
        this.addRelatedEntity("fundsourceId", Fundsource.class);
    }

    public void finYearDate() {
        String financialYearId = this.financialYearDAO.getCurrYearFiscalId();
        this.fromDate = financialYearId == null || financialYearId.equals("") ? new Date() : (Date)this.persistenceService.find("select startingDate  from CFinancialYear where id=?", new Object[]{Long.parseLong(financialYearId)});
        this.toDate = null;
    }

    public void prepare() {
        super.prepare();
        this.getHeaderFields();
        this.loadDropDowns();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Number of  MIS attributes are :" + this.headerFields.size()));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Number of mandate MIS attributes are :" + this.mandatoryFields.size()));
        }
        this.statusMap = new HashMap();
        this.statusMap.put(FinancialConstants.CREATEDVOUCHERSTATUS, "Approved");
        this.statusMap.put(FinancialConstants.REVERSEDVOUCHERSTATUS, "Reversed");
        this.statusMap.put(FinancialConstants.REVERSALVOUCHERSTATUS, "Reversal");
        this.statusMap.put(FinancialConstants.CANCELLEDVOUCHERSTATUS, "Cancelled");
        this.statusMap.put(FinancialConstants.PREAPPROVEDVOUCHERSTATUS, "Preapproved");
    }

    private void loadDropDowns() {
        if (this.headerFields.contains("department")) {
            this.addDropdownData("departmentList", this.persistenceService.findAllBy("from Department order by name", new Object[0]));
        }
        if (this.headerFields.contains("functionary")) {
            this.addDropdownData("functionaryList", this.persistenceService.findAllBy(" from Functionary where isactive=true order by name", new Object[0]));
        }
        if (this.headerFields.contains("fund")) {
            this.addDropdownData("fundList", this.persistenceService.findAllBy(" from Fund where isactive=true and isnotleaf=false order by name", new Object[0]));
        }
        if (this.headerFields.contains("fundsource")) {
            this.addDropdownData("fundsourceList", this.persistenceService.findAllBy(" from Fundsource where isactive=true order by name", new Object[0]));
        }
        if (this.headerFields.contains("field")) {
            this.addDropdownData("fieldList", this.persistenceService.findAllBy(" from Boundary b where lower(b.boundaryType.name)='ward' ", new Object[0]));
        }
        if (this.headerFields.contains("scheme")) {
            this.addDropdownData("schemeList", Collections.EMPTY_LIST);
        }
        if (this.headerFields.contains("subscheme")) {
            this.addDropdownData("subschemeList", Collections.EMPTY_LIST);
        }
        this.addDropdownData("typeList", VoucherHelper.VOUCHER_TYPES);
        this.addDropdownData("modeOfPaymentList", this.persistenceService.findAllBy(" select DISTINCT upper(type) from Paymentheader ", new Object[0]));
        this.nameMap = new LinkedHashMap();
    }

    protected void getHeaderFields() {
        List appConfigList = this.persistenceService.findAllBy("from AppConfig where key_name = 'DEFAULT_SEARCH_MISATTRRIBUTES'", new Object[0]);
        for (AppConfig appConfig : appConfigList) {
            for (AppConfigValues appConfigVal : appConfig.getAppDataValues()) {
                String value = appConfigVal.getValue();
                String header = value.substring(0, value.indexOf(124));
                this.headerFields.add(header);
                String mandate = value.substring(value.indexOf(124) + 1);
                if (!mandate.equalsIgnoreCase("M")) continue;
                this.mandatoryFields.add(header);
            }
        }
    }

    public boolean shouldShowHeaderField(String field) {
        return this.headerFields.contains(field);
    }

    public Map<Integer, String> getStatusMap() {
        return this.statusMap;
    }

    public void setStatusMap(Map<Integer, String> statusMap) {
        this.statusMap = statusMap;
    }

    @SkipValidation
    @Action(value="/report/voucherStatusReport-beforeSearch")
    public String beforeSearch() {
        this.voucherHeader.reset();
        this.finYearDate();
        return "search";
    }

    @ValidationErrorPage(value="search")
    @Action(value="/report/voucherStatusReport-search")
    public String search() throws ApplicationException, ParseException {
        this.voucherList = new ArrayList();
        HashMap<String, Object> voucherMap = null;
        this.voucherIDOwnerNameMap = new HashMap();
        Query qry = this.voucherSearchQuery();
        Long count = (Long)this.persistenceService.find(this.countQry);
        Page resPage = new Page(qry, this.page, this.pageSize);
        this.pagedResults = new EgovPaginatedList(resPage, count.intValue());
        List list = this.pagedResults != null ? this.pagedResults.getList() : null;
        for (CVoucherHeader voucherheader : list) {
            voucherMap = new HashMap<String, Object>();
            Double amt = new Double(0.0);
            Long voucherHeaderId = voucherheader.getId();
            voucherMap.put("id", voucherHeaderId);
            voucherMap.put("vouchernumber", voucherheader.getVoucherNumber());
            voucherMap.put("type", voucherheader.getType());
            voucherMap.put("name", voucherheader.getName());
            voucherMap.put("voucherdate", voucherheader.getVoucherDate());
            voucherMap.put("deptName", voucherheader.getVouchermis().getDepartmentid().getName());
            for (CGeneralLedger detail : voucherheader.getGeneralledger()) {
                amt = amt + detail.getDebitAmount();
            }
            voucherMap.put("amount", amt);
            voucherMap.put("status", this.getVoucherStatus(voucherheader.getStatus().intValue()));
            voucherMap.put("source", this.getVoucherModule(voucherheader.getModuleId()));
            String voucherOwner = this.getVoucherOwner(voucherheader);
            voucherMap.put("owner", voucherOwner);
            this.voucherIDOwnerNameMap.put(voucherHeaderId, voucherOwner);
            this.voucherList.add(voucherMap);
        }
        this.loadAjaxedData();
        this.pagedResults.setList(this.voucherList);
        return "search";
    }

    private void loadAjaxedData() {
        this.getVoucherNameMap(this.voucherHeader.getType());
        if (this.headerFields.contains("scheme")) {
            if (this.voucherHeader.getFundId() != null && this.voucherHeader.getFundId().getId() != -1) {
                StringBuffer st = new StringBuffer();
                st.append("from Scheme where isactive=true and fund.id=");
                st.append(this.voucherHeader.getFundId().getId());
                this.dropdownData.put("schemeList", this.persistenceService.findAllBy(st.toString(), new Object[0]));
                st.delete(0, st.length() - 1);
            } else {
                this.dropdownData.put("schemeList", Collections.emptyList());
            }
        }
        if (this.headerFields.contains("subscheme")) {
            if (this.voucherHeader.getVouchermis() != null && this.voucherHeader.getVouchermis().getSchemeid() != null && this.voucherHeader.getVouchermis().getSchemeid().getId() != -1) {
                this.dropdownData.put("subSchemeList", this.persistenceService.findAllBy("from SubScheme where isactive=true and scheme.id=?", new Object[]{this.voucherHeader.getVouchermis().getSchemeid().getId()}));
            } else {
                this.dropdownData.put("subSchemeList", Collections.emptyList());
            }
        }
    }

    public Map<String, String> getVoucherNameMap(String type) {
        List voucherNameList = this.persistenceService.findAllBy("select  distinct name from  CVoucherHeader where type=?", new Object[]{type});
        this.nameMap = new LinkedHashMap();
        for (Object voucherName : voucherNameList) {
            this.nameMap.put((String)voucherName, (String)voucherName);
        }
        return this.nameMap;
    }

    private Query voucherSearchQuery() {
        String sql = "";
        sql = !this.modeOfPayment.equals("-1") ? sql + " from CVoucherHeader vh,Paymentheader ph where vh.id = ph.voucherheader.id and" : sql + " from CVoucherHeader vh where ";
        if (this.voucherHeader.getFundId() != null && this.voucherHeader.getFundId().getId() != -1) {
            sql = sql + "  vh.fundId=" + this.voucherHeader.getFundId().getId();
        }
        if (this.voucherHeader.getType() != null && !this.voucherHeader.getType().equals("-1")) {
            sql = sql + " and vh.type='" + this.voucherHeader.getType() + "'";
        }
        if (this.voucherHeader.getName() != null && !this.voucherHeader.getName().equalsIgnoreCase("-1") && !this.voucherHeader.getName().equalsIgnoreCase("0")) {
            sql = sql + " and vh.name='" + this.voucherHeader.getName() + "'";
        }
        if (this.fromDate != null) {
            sql = sql + " and vh.voucherDate>='" + Constants.DDMMYYYYFORMAT1.format(this.fromDate) + "'";
        }
        if (this.toDate != null) {
            sql = sql + " and vh.voucherDate<='" + Constants.DDMMYYYYFORMAT1.format(this.toDate) + "'";
        }
        if (this.voucherHeader.getStatus() != -1) {
            sql = sql + " and vh.status=" + this.voucherHeader.getStatus();
        }
        if (this.voucherHeader.getVouchermis().getDepartmentid() != null && this.voucherHeader.getVouchermis().getDepartmentid().getId() != -1L) {
            sql = sql + " and vh.vouchermis.departmentid=" + this.voucherHeader.getVouchermis().getDepartmentid().getId();
        }
        if (this.voucherHeader.getVouchermis().getSchemeid() != null) {
            sql = sql + " and vh.vouchermis.schemeid=" + this.voucherHeader.getVouchermis().getSchemeid().getId();
        }
        if (this.voucherHeader.getVouchermis().getSubschemeid() != null) {
            sql = sql + " and vh.vouchermis.subschemeid=" + this.voucherHeader.getVouchermis().getSubschemeid().getId();
        }
        if (this.voucherHeader.getVouchermis().getFunctionary() != null) {
            sql = sql + " and vh.vouchermis.functionary=" + this.voucherHeader.getVouchermis().getFunctionary().getId();
        }
        if (this.voucherHeader.getVouchermis().getDivisionid() != null) {
            sql = sql + " and vh.vouchermis.divisionid=" + this.voucherHeader.getVouchermis().getDivisionid().getId();
        }
        if (!this.modeOfPayment.equals("-1")) {
            sql = sql + " and upper(ph.type) ='" + this.getModeOfPayment() + "'";
        }
        this.countQry = "select count(*) " + sql;
        sql = "select vh " + sql + " order by vh.vouchermis.departmentid.name ,vh.voucherDate, vh.voucherNumber";
        Query query = this.persistenceService.getSession().createQuery(sql);
        return query;
    }

    private String getVoucherModule(Integer vchrModuleId) throws ApplicationException {
        if (vchrModuleId == null) {
            return "Internal";
        }
        EgModules egModuleObj = (EgModules)this.persistenceService.find("from EgModules m where m.id=?", new Object[]{vchrModuleId});
        if (egModuleObj == null) {
            throw new ApplicationException("INCORRECT MODULE ID");
        }
        return egModuleObj.getName();
    }

    public void validate() {
        if (this.fromDate == null) {
            this.addFieldError("From Date", this.getText("Please enter From Date"));
        }
        if (this.toDate == null) {
            this.addFieldError("To Date", this.getText("Please enter To Date"));
        }
        this.checkMandatoryField("fundId", "fund", (Object)this.voucherHeader.getFundId(), "voucher.fund.mandatory");
        this.checkMandatoryField("vouchermis.departmentid", "department", (Object)this.voucherHeader.getVouchermis().getDepartmentid(), "voucher.department.mandatory");
        this.checkMandatoryField("vouchermis.schemeid", "scheme", (Object)this.voucherHeader.getVouchermis().getSchemeid(), "voucher.scheme.mandatory");
        this.checkMandatoryField("vouchermis.subschemeid", "subscheme", (Object)this.voucherHeader.getVouchermis().getSubschemeid(), "voucher.subscheme.mandatory");
        this.checkMandatoryField("vouchermis.functionary", "functionary", (Object)this.voucherHeader.getVouchermis().getFunctionary(), "voucher.functionary.mandatory");
        this.checkMandatoryField("fundsourceId", "fundsource", (Object)this.voucherHeader.getVouchermis().getFundsource(), "voucher.fundsource.mandatory");
        this.checkMandatoryField("vouchermis.divisionId", "field", (Object)this.voucherHeader.getVouchermis().getDivisionid(), "voucher.field.mandatory");
    }

    private void populateData() throws ParseException, ApplicationException {
        ArrayList list = new ArrayList();
        list.addAll(this.voucherSearchQuery().list());
        BigDecimal amt = BigDecimal.ZERO;
        for (CVoucherHeader cVchrHdr : list) {
            VoucherReportView vhcrRptView = new VoucherReportView();
            vhcrRptView.setDeptName(cVchrHdr.getVouchermis().getDepartmentid().getName());
            vhcrRptView.setVoucherNumber(cVchrHdr.getVoucherNumber());
            vhcrRptView.setVoucherType(cVchrHdr.getType());
            vhcrRptView.setVoucherName(cVchrHdr.getName());
            vhcrRptView.setVoucherDate(cVchrHdr.getVoucherDate());
            vhcrRptView.setSource(this.getVoucherModule(cVchrHdr.getModuleId()));
            for (CGeneralLedger detail : cVchrHdr.getGeneralledger()) {
                amt = amt.add(BigDecimal.valueOf(detail.getDebitAmount()).setScale(2, 6));
            }
            vhcrRptView.setAmount(amt);
            vhcrRptView.setOwner(this.getVoucherOwner(cVchrHdr));
            vhcrRptView.setStatus(this.getVoucherStatus(cVchrHdr.getStatus().intValue()));
            this.voucherReportList.add(vhcrRptView);
            amt = BigDecimal.ZERO;
        }
        this.setParamMap();
    }

    protected void checkMandatoryField(String objectName, String fieldName, Object value, String errorKey) {
        if (this.mandatoryFields.contains(fieldName) && (value == null || value.equals(-1))) {
            this.addFieldError(objectName, this.getText(errorKey));
        }
    }

    public boolean isFieldMandatory(String field) {
        return this.mandatoryFields.contains(field);
    }

    private String getVoucherStatus(int status) {
        if (FinancialConstants.CREATEDVOUCHERSTATUS.equals(status)) {
            return "Approved";
        }
        if (FinancialConstants.REVERSEDVOUCHERSTATUS.equals(status)) {
            return "Reversed";
        }
        if (FinancialConstants.REVERSALVOUCHERSTATUS.equals(status)) {
            return "Reversal";
        }
        if (FinancialConstants.CANCELLEDVOUCHERSTATUS.equals(status)) {
            return "Cancelled";
        }
        if (FinancialConstants.PREAPPROVEDVOUCHERSTATUS.equals(status)) {
            return "Preapproved";
        }
        return "";
    }

    private String getVoucherOwner(CVoucherHeader voucherHeader) {
        String dash = "-";
        Integer voucherStatus = voucherHeader.getStatus();
        String voucherType = voucherHeader.getType();
        State voucherState = null;
        if (voucherStatus.longValue() == FinancialConstants.CANCELLEDVOUCHERSTATUS.longValue() || voucherStatus.longValue() == FinancialConstants.CREATEDVOUCHERSTATUS.longValue()) {
            return "-";
        }
        if (voucherType.equalsIgnoreCase("Contra")) {
            ContraJournalVoucher contraJV = (ContraJournalVoucher)this.persistenceService.find("from ContraJournalVoucher cj where cj.voucherHeaderId=?", new Object[]{voucherHeader});
            if (contraJV == null) {
                return "-";
            }
            voucherState = contraJV.getState();
            if (voucherState == null) {
                return "-";
            }
            if (voucherState.getValue().equals("END")) {
                return "-";
            }
            return this.getUserNameForPosition(Integer.valueOf(voucherState.getOwnerPosition().getId().intValue()));
        }
        if (voucherType.equalsIgnoreCase("Journal Voucher")) {
            voucherState = voucherHeader.getState();
            if (voucherState == null) {
                return "-";
            }
            if (voucherState.getValue().equals("END")) {
                return "-";
            }
            return this.getUserNameForPosition(Integer.valueOf(voucherState.getOwnerPosition().getId().intValue()));
        }
        if (voucherType.equalsIgnoreCase("Payment")) {
            Paymentheader paymentHeader = (Paymentheader)this.persistenceService.find("from Paymentheader ph where ph.voucherheader=?", new Object[]{voucherHeader});
            if (paymentHeader == null) {
                return "-";
            }
            voucherState = paymentHeader.getState();
            if (voucherState == null) {
                return "-";
            }
            if (voucherState.getValue().equals("END")) {
                return "-";
            }
            return this.getUserNameForPosition(Integer.valueOf(voucherState.getOwnerPosition().getId().intValue()));
        }
        return "-";
    }

    private String getUserNameForPosition(Integer posId) {
        String query = "select emp.userName  from org.egov.eis.entity.EmployeeView emp where emp.position.id = ? ";
        String userName = (String)this.persistenceService.find("select emp.userName  from org.egov.eis.entity.EmployeeView emp where emp.position.id = ? ", new Object[]{posId.longValue()});
        return userName;
    }

    public void setParamMap() {
        this.paramMap.put("fund", this.voucherHeader.getFundId().getName());
        if (this.voucherHeader.getVouchermis() != null && this.voucherHeader.getVouchermis().getDepartmentid() != null) {
            this.paramMap.put("deptName", this.voucherHeader.getVouchermis().getDepartmentid().getName());
        }
        this.paramMap.put("status", this.getVoucherStatus(this.voucherHeader.getStatus().intValue()));
        this.paramMap.put("toDate", this.toDate);
        this.paramMap.put("fromDate", this.fromDate);
        this.paramMap.put("voucherName", this.voucherHeader.getName());
        this.paramMap.put("voucherType", this.voucherHeader.getType());
    }

    public void setReportHelper(ReportHelper reportHelper) {
        this.reportHelper = reportHelper;
    }

    @SkipValidation
    @Action(value="/report/voucherStatusReport-generatePdf")
    public String generatePdf() throws Exception {
        this.populateData();
        this.inputStream = this.reportHelper.exportPdf(this.inputStream, JASPERPATH, this.getParamMap(), this.voucherReportList);
        return "PDF";
    }

    @SkipValidation
    @Action(value="/report/voucherStatusReport-generateXls")
    public String generateXls() throws Exception {
        this.populateData();
        this.inputStream = this.reportHelper.exportXls(this.inputStream, JASPERPATH, this.getParamMap(), this.voucherReportList);
        return "XLS";
    }

    protected Map<String, Object> getParamMap() {
        return this.paramMap;
    }

    public void setPagedResults(EgovPaginatedList pagedResults) {
        this.pagedResults = pagedResults;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public Date getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(Date fromDate) {
        this.fromDate = fromDate;
    }

    public Date getToDate() {
        return this.toDate;
    }

    public void setToDate(Date toDate) {
        this.toDate = toDate;
    }

    public EgovPaginatedList getPagedResults() {
        return this.pagedResults;
    }

    public Map<String, String> getNameMap() {
        return this.nameMap;
    }

    public void setNameMap(Map<String, String> nameMap) {
        this.nameMap = nameMap;
    }

    public Integer getPage() {
        return this.page;
    }

    public void setPage(Integer page) {
        this.page = page;
    }

    public List<String> getVoucherTypes() {
        return this.voucherTypes;
    }

    public void setVoucherTypes(List<String> voucherTypes) {
        this.voucherTypes = voucherTypes;
    }

    public Map<String, List<String>> getVoucherNames() {
        return this.voucherNames;
    }

    public void setVoucherNames(Map<String, List<String>> voucherNames) {
        this.voucherNames = voucherNames;
    }

    public String getModeOfPayment() {
        return this.modeOfPayment;
    }

    public void setModeOfPayment(String modeOfPayment) {
        this.modeOfPayment = modeOfPayment;
    }

    public FinancialYearDAO getFinancialYearDAO() {
        return this.financialYearDAO;
    }

    public void setFinancialYearDAO(FinancialYearDAO financialYearDAO) {
        this.financialYearDAO = financialYearDAO;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }
}

