/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.report;

import com.exilant.eGov.src.reports.TrialBalanceBean;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.commons.CFinancialYear;
import org.egov.commons.Fund;
import org.egov.commons.dao.FinancialYearDAO;
import org.egov.egf.web.actions.report.TrialBalanceAction;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.City;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infstr.services.PersistenceService;
import org.egov.infstr.utils.EgovMasterDataCaching;
import org.egov.model.report.ReportBean;
import org.egov.utils.ReportHelper;
import org.hibernate.FlushMode;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.transform.Transformers;
import org.hibernate.type.BigDecimalType;
import org.hibernate.type.StringType;
import org.hibernate.type.Type;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

/*
 * Exception performing whole class analysis ignored.
 */
@Results(value={@Result(name="new", location="trialBalance-new.jsp"), @Result(name="trialBalance-PDF", type="stream", location="inputStream", params={"inputName", "inputStream", "contentType", "application/pdf", "contentDisposition", "no-cache;filename=trialBalance.pdf"}), @Result(name="trialBalance-XLS", type="stream", location="inputStream", params={"inputName", "inputStream", "contentType", "application/xls", "contentDisposition", "no-cache;filename=trialBalance.xls"}), @Result(name="trialBalance-HTML", type="stream", location="inputStream", params={"inputName", "inputStream", "contentType", "text/html", "contentDisposition", "no-cache;filename=trialBalance.html"})})
@ParentPackage(value="egov")
public class TrialBalanceAction
extends BaseFormAction {
    private static final long serialVersionUID = 6795651373310407180L;
    private static final Logger LOGGER = Logger.getLogger(TrialBalanceAction.class);
    private ReportBean rb = new ReportBean();
    protected InputStream inputStream;
    private CityService cityService;
    private City cityWebsite;
    private String heading = "";
    public String[] reqFundId;
    public String[] reqFundName;
    public Date finStartDate;
    public Date todayDate;
    private BigDecimal totalClosingBalance = BigDecimal.ZERO;
    private BigDecimal totalOpeningBalance = BigDecimal.ZERO;
    private BigDecimal totalDebitAmount = BigDecimal.ZERO;
    private BigDecimal totalCreditAmount = BigDecimal.ZERO;
    private BigDecimal totalAmount = BigDecimal.ZERO;
    private final SimpleDateFormat mmddyyyyformatter = new SimpleDateFormat("dd/MM/yyyy", Locale.ENGLISH);
    List<TrialBalanceBean> al = new ArrayList();
    List<TrialBalanceBean> nonZeroItemsList = new ArrayList();
    private ReportHelper reportHelper;
    private List<Fund> fundList;
    private Map<String, BigDecimal> fundWiseTotalMap = new LinkedHashMap();
    private FinancialYearDAO financialYearDAO;
    private String removeEntrysWithZeroAmount = "";
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    @Autowired
    private AppConfigValueService appConfigValuesService;
    private Date startDate = new Date();
    private Date endDate = new Date();
    final SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
    @Autowired
    private EgovMasterDataCaching masterDataCache;

    public Object getModel() {
        return this.rb;
    }

    public void prepare() {
        this.persistenceService.getSession().setDefaultReadOnly(true);
        this.persistenceService.getSession().setFlushMode(FlushMode.MANUAL);
        super.prepare();
        this.addDropdownData("fundList", this.masterDataCache.get("egi-fund"));
        this.addDropdownData("departmentList", this.masterDataCache.get("egi-department"));
        this.addDropdownData("functionaryList", this.masterDataCache.get("egi-functionary"));
        this.addDropdownData("fieldList", this.masterDataCache.get("egi-ward"));
        this.addDropdownData("functionList", this.masterDataCache.get("egi-function"));
    }

    @Action(value="/report/trialBalance-newForm")
    public String newForm() {
        return "new";
    }

    public String exportTrialBalance() {
        try {
            this.heading = this.generateHeading();
            this.cityWebsite = this.cityService.getCityByURL((String)this.getSession().get("cityurl"));
            if (this.rb.getExportType().equalsIgnoreCase("xls")) {
                this.inputStream = this.reportHelper.exportXls(this.inputStream, this.reportHelper.exportTBDateRange(this.al, this.cityWebsite.getName(), this.rb, this.heading, this.fundList, "xls"));
                return "trialBalance-XLS";
            }
            if (this.rb.getExportType().equalsIgnoreCase("pdf")) {
                this.inputStream = this.reportHelper.exportPdf(this.inputStream, this.reportHelper.exportTBDateRange(this.al, this.cityWebsite.getName(), this.rb, this.heading, this.fundList, null));
                return "trialBalance-PDF";
            }
            this.inputStream = this.reportHelper.exportHtml(this.inputStream, this.reportHelper.exportTBDateRange(this.al, this.cityWebsite.getName(), this.rb, this.heading, this.fundList, null), "px");
            return "new";
        }
        catch (JRException e) {
            LOGGER.error((Object)e, (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error((Object)e, (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error((Object)e, (Throwable)e);
        }
        return "new";
    }

    @SkipValidation
    @Action(value="/report/trialBalance-search")
    public String search() {
        if (this.rb.getReportType().equalsIgnoreCase("daterange")) {
            Date dt;
            String sDate = ((String[])this.parameters.get("fromDate"))[0];
            String eDate = ((String[])this.parameters.get("toDate"))[0];
            Date dd = dt = new Date();
            try {
                dt = this.sdf.parse(sDate);
            }
            catch (ParseException e1) {
                e1.printStackTrace();
            }
            CFinancialYear finYearByDate = this.financialYearDAO.getFinYearByDate(dt);
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
            try {
                dd = this.sdf.parse(eDate);
            }
            catch (ParseException e1) {
                e1.printStackTrace();
            }
            String endFormat = formatter.format(dd);
            String endDate1 = formatter.format(finYearByDate.getEndingDate());
            if (endFormat.compareTo(endDate1) > 0) {
                this.addActionError(this.getText("Start Date and End Date should be in same financial year"));
                return "new";
            }
        }
        try {
            List configValues = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "Remove Entries With Zero Amount in Report");
            for (AppConfigValues appConfigVal : configValues) {
                this.removeEntrysWithZeroAmount = appConfigVal.getValue();
            }
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException("Appconfig value for remove entries with zero amount in report is not defined in the system");
        }
        if (this.rb.getReportType().equalsIgnoreCase("daterange")) {
            this.getReportForDateRange();
            this.formatTBReport();
        } else {
            if (this.rb.getFundId() == null) {
                this.fundList = this.masterDataCache.get("egi-fund");
            } else {
                this.fundList = new ArrayList();
                this.fundList.add((Fund)this.persistenceService.find("from Fund where id=?", new Object[]{this.rb.getFundId()}));
            }
            this.gererateReportForAsOnDate();
        }
        if (this.al.size() >= 1) {
            return this.exportTrialBalance();
        }
        this.addActionMessage("No Data Found");
        return "new";
    }

    private void gererateReportForAsOnDate() {
        String voucherMisTable = "";
        String misClause = "";
        String misDeptCond = "";
        String tsDeptCond = "";
        String functionaryCond = "";
        String tsfunctionaryCond = "";
        String functionIdCond = "";
        String tsFunctionIdCond = "";
        String fieldIdCond = "";
        String tsFieldIdCond = "";
        String fundcondition = "";
        List forAllFunds = new ArrayList();
        fundcondition = this.rb.getFundId() != null ? " and fundid=:fundId" : " and fundid in (select id from fund where isactive=true and isnotleaf!=true )";
        if (null != this.rb.getDepartmentId() || null != this.rb.getFunctionaryId()) {
            voucherMisTable = ",vouchermis mis ";
            misClause = " and mis.voucherheaderid=vh.id ";
        }
        if (null != this.rb.getDepartmentId()) {
            misDeptCond = " and mis.DEPARTMENTID= :departmentId";
            tsDeptCond = " and DEPARTMENTID= :departmentId";
        }
        if (null != this.rb.getFunctionaryId()) {
            functionaryCond = " and mis.FUNCTIONARYID= :functionaryId";
            tsfunctionaryCond = " and FUNCTIONARYID= :functionaryId";
        }
        if (null != this.rb.getFunctionId()) {
            functionIdCond = " and gl.voucherheaderid in (select distinct(voucherheaderid) from generalledger where functionid =:functionId)";
            tsFunctionIdCond = " and FUNCTIONID= functionId";
        }
        if (null != this.rb.getDivisionId()) {
            fieldIdCond = " and mis.divisionId= :divisionId";
            tsFieldIdCond = " and divisionId= :divisionId";
        }
        String defaultStatusExclude = null;
        List listAppConfVal = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "statusexcludeReport");
        if (null == listAppConfVal) {
            throw new ApplicationRuntimeException("Exlcude statusses not  are not defined for Reports");
        }
        defaultStatusExclude = ((AppConfigValues)listAppConfVal.get(0)).getValue();
        String query = " SELECT gl.glcode AS \"accCode\" ,coa.name AS \"accName\" ,vh.fundid AS \"fundId\",(SUM(debitamount)+SUM((SELECT case when SUM(OPENINGDEBITBALANCE)  is null  then 0 else SUM(OPENINGDEBITBALANCE) end FROM transactionsummary WHERE financialyearid=(SELECT id FROM financialyear WHERE startingdate<=:toDate AND endingdate>=:toDate) AND glcodeid =(SELECT id FROM chartofaccounts WHERE glcode=gl.glcode) AND fundid=vh.fundid" + fundcondition + tsDeptCond + tsfunctionaryCond + tsFunctionIdCond + tsFieldIdCond + "))/COUNT(*))-" + " (SUM(creditamount)+SUM((SELECT  case when SUM(OPENINGCREDITBALANCE)  is null  then 0 else SUM(OPENINGCREDITBALANCE) end FROM" + " transactionsummary WHERE financialyearid=(SELECT id FROM financialyear  WHERE startingdate<=:toDate AND endingdate>=:toDate)" + " AND glcodeid =(SELECT id FROM chartofaccounts WHERE glcode=gl.glcode) AND fundid=vh.fundid" + fundcondition + tsDeptCond + tsfunctionaryCond + tsFunctionIdCond + tsFieldIdCond + "))/COUNT(*) ) as \"amount\" " + " FROM generalledger gl,chartofaccounts   coa,voucherheader vh " + voucherMisTable + " WHERE coa.glcode=gl.glcode AND gl.voucherheaderid=vh.id" + misClause + " AND vh.status not in (" + defaultStatusExclude + ") " + " AND  vh.voucherdate<=:toDate AND vh.voucherdate>=(SELECT startingdate FROM financialyear WHERE  startingdate<=:toDate AND   endingdate>=:toDate) " + fundcondition + " " + misDeptCond + functionaryCond + functionIdCond + fieldIdCond + " GROUP BY gl.glcode,coa.name,vh.fundid    HAVING (SUM(debitamount)>0 OR SUM(creditamount)>0)    And" + " (SUM(debitamount)+SUM((SELECT case when SUM(OPENINGDEBITBALANCE) IS NULL then 0 else SUM(OPENINGDEBITBALANCE) end FROM" + " transactionsummary WHERE  financialyearid=(SELECT id FROM financialyear       WHERE startingdate <=:toDate" + " AND endingdate >=:toDate) AND glcodeid =(SELECT id FROM chartofaccounts WHERE glcode=gl.glcode) " + fundcondition + tsDeptCond + tsfunctionaryCond + tsFunctionIdCond + tsFieldIdCond + "))/COUNT(*))-" + " (SUM(creditamount)+SUM((SELECT  case when SUM(OPENINGCREDITBALANCE) IS NULL then 0 else SUM(OPENINGCREDITBALANCE) end FROM" + " transactionsummary WHERE financialyearid=(SELECT id FROM financialyear    WHERE startingdate<=:toDate AND endingdate>=:toDate) " + " AND glcodeid =(SELECT id FROM chartofaccounts WHERE glcode=gl.glcode)  " + fundcondition + tsDeptCond + tsfunctionaryCond + tsFunctionIdCond + tsFieldIdCond + "))/COUNT(*) )<>0" + " union" + " SELECT coa.glcode AS \"accCode\" ,coa.name AS \"accName\" , fu.id as \"fundId\", SUM((SELECT case when SUM(OPENINGDEBITBALANCE) IS NULL then 0 else SUM(OPENINGDEBITBALANCE) end " + " FROM transactionsummary WHERE financialyearid=(SELECT id FROM financialyear WHERE  startingdate<=:toDate AND endingdate>=:toDate)" + " AND glcodeid =(SELECT id FROM chartofaccounts WHERE  glcode=coa.glcode) AND fundid= (select id from fund where id=fu.id)" + " " + fundcondition + tsDeptCond + tsfunctionaryCond + tsFunctionIdCond + tsFieldIdCond + ")) - SUM((SELECT  case when SUM(OPENINGCREDITBALANCE) IS NULL then 0 else SUM(OPENINGCREDITBALANCE) end as \"amount\" FROM transactionsummary WHERE" + " financialyearid=(SELECT id FROM financialyear       WHERE startingdate<=:toDate AND endingdate>=:toDate) AND glcodeid =(SELECT id FROM chartofaccounts" + " WHERE glcode=coa.glcode)AND fundid= (select id from fund where id=fu.id)" + fundcondition + tsDeptCond + tsfunctionaryCond + tsFunctionIdCond + tsFieldIdCond + ")) " + " FROM chartofaccounts  coa, fund fu  WHERE  fu.id IN(SELECT fundid from transactionsummary WHERE financialyearid = (SELECT id FROM financialyear WHERE startingdate<=:toDate " + " AND endingdate>=:toDate) " + fundcondition + tsDeptCond + tsfunctionaryCond + tsFunctionIdCond + tsFieldIdCond + " AND glcodeid =(SELECT id   FROM chartofaccounts WHERE  glcode=coa.glcode) ) AND coa.id NOT IN(SELECT glcodeid FROM generalledger gl,voucherheader vh " + voucherMisTable + " WHERE " + " vh.status not in (" + defaultStatusExclude + ") " + misClause + misDeptCond + functionaryCond + functionIdCond + fieldIdCond + " AND vh.id=gl.voucherheaderid AND vh.fundid=fu.id AND vh.voucherdate<=:toDate AND vh.voucherdate>=(SELECT startingdate FROM financialyear WHERE  startingdate<=:toDate AND   endingdate>=:toDate) " + fundcondition + ")" + " GROUP BY coa.glcode,coa.name, fu.id" + " HAVING((SUM((SELECT case when SUM(OPENINGDEBITBALANCE) IS NULL then 0 else SUM(OPENINGDEBITBALANCE) end FROM transactionsummary WHERE" + " financialyearid=(SELECT id FROM financialyear       WHERE startingdate<=:toDate AND endingdate>=:toDate) AND glcodeid =(SELECT id FROM chartofaccounts WHERE glcode=coa.glcode) " + fundcondition + tsDeptCond + tsfunctionaryCond + tsFunctionIdCond + tsFieldIdCond + " )) >0 )" + " OR (SUM((SELECT  case when SUM(OPENINGCREDITBALANCE) IS NULL then 0 else SUM(OPENINGCREDITBALANCE) end FROM transactionsummary WHERE financialyearid=(SELECT id FROM financialyear WHERE startingdate<=:toDate AND endingdate>=:toDate)" + " AND glcodeid =(SELECT id FROM chartofaccounts WHERE glcode=coa.glcode)     " + fundcondition + tsDeptCond + tsfunctionaryCond + tsFunctionIdCond + tsFieldIdCond + "))>0 ))  ORDER BY \"accCode\"";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("&&&query  " + query));
        }
        try {
            new Double(0.0);
            SQLQuery SQLQuery2 = this.persistenceService.getSession().createSQLQuery(query);
            SQLQuery2.addScalar("accCode").addScalar("accName").addScalar("fundId", (Type)StringType.INSTANCE).addScalar("amount", (Type)BigDecimalType.INSTANCE).setResultTransformer(Transformers.aliasToBean(TrialBalanceBean.class));
            if (null != this.rb.getFundId()) {
                SQLQuery2.setInteger("fundId", this.rb.getFundId().intValue());
            }
            if (null != this.rb.getDepartmentId()) {
                SQLQuery2.setInteger("departmentId", this.rb.getDepartmentId().intValue());
            }
            if (null != this.rb.getFunctionaryId()) {
                SQLQuery2.setInteger("functionaryId", this.rb.getFunctionaryId().intValue());
            }
            if (null != this.rb.getFunctionId()) {
                SQLQuery2.setInteger("functionId", this.rb.getFunctionId().intValue());
            }
            if (null != this.rb.getDivisionId()) {
                SQLQuery2.setInteger("divisionId", this.rb.getDivisionId().intValue());
            }
            if (null != this.rb.getFromDate()) {
                SQLQuery2.setDate("fromDate", this.rb.getFromDate());
            }
            SQLQuery2.setDate("toDate", this.rb.getToDate());
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("query ---->" + SQLQuery2));
            }
            forAllFunds = SQLQuery2.list();
        }
        catch (Exception e) {
            LOGGER.error((Object)("Error in getReport" + e.getMessage()), (Throwable)e);
        }
        for (Object f : this.fundList) {
            this.fundWiseTotalMap.put(f.getId() + "_amount", BigDecimal.ZERO);
        }
        try {
            LinkedHashMap<String, Object> nonDuplicateMap = new LinkedHashMap<String, Object>();
            for (Object tb : forAllFunds) {
                if (nonDuplicateMap.containsKey(tb.getAccCode())) {
                    if (tb.getAmount().signum() == -1) {
                        ((TrialBalanceBean)nonDuplicateMap.get(tb.getAccCode())).addToAmountMap(tb.getFundId() + "_amount", TrialBalanceAction.numberToString((String)tb.getAmount().abs().toString()).toString() + " Cr");
                        if (((TrialBalanceBean)nonDuplicateMap.get(tb.getAccCode())).getCreditAmount() != null) {
                            ((TrialBalanceBean)nonDuplicateMap.get(tb.getAccCode())).setCreditAmount(((TrialBalanceBean)nonDuplicateMap.get(tb.getAccCode())).getCreditAmount().add(tb.getAmount()));
                        } else {
                            ((TrialBalanceBean)nonDuplicateMap.get(tb.getAccCode())).setCreditAmount(tb.getAmount());
                        }
                        this.totalAmount = ((BigDecimal)this.fundWiseTotalMap.get(tb.getFundId() + "_amount")).subtract(tb.getAmount().abs());
                        this.fundWiseTotalMap.put(tb.getFundId() + "_amount", this.totalAmount);
                        continue;
                    }
                    if (tb.getAmount().signum() != 1) continue;
                    ((TrialBalanceBean)nonDuplicateMap.get(tb.getAccCode())).addToAmountMap(tb.getFundId() + "_amount", TrialBalanceAction.numberToString((String)tb.getAmount().toString()).toString() + " Dr");
                    if (((TrialBalanceBean)nonDuplicateMap.get(tb.getAccCode())).getDebitAmount() != null) {
                        ((TrialBalanceBean)nonDuplicateMap.get(tb.getAccCode())).setDebitAmount(((TrialBalanceBean)nonDuplicateMap.get(tb.getAccCode())).getDebitAmount().add(tb.getAmount()));
                    } else {
                        ((TrialBalanceBean)nonDuplicateMap.get(tb.getAccCode())).setDebitAmount(tb.getAmount());
                    }
                    this.totalAmount = ((BigDecimal)this.fundWiseTotalMap.get(tb.getFundId() + "_amount")).add(tb.getAmount());
                    this.fundWiseTotalMap.put(tb.getFundId() + "_amount", this.totalAmount);
                    continue;
                }
                if (tb.getAmount().signum() == -1) {
                    tb.addToAmountMap(tb.getFundId() + "_amount", TrialBalanceAction.numberToString((String)tb.getAmount().abs().toString()).toString() + " Cr");
                    tb.setCreditAmount(tb.getAmount());
                    this.totalAmount = ((BigDecimal)this.fundWiseTotalMap.get(tb.getFundId() + "_amount")).subtract(tb.getAmount().abs());
                    this.fundWiseTotalMap.put(tb.getFundId() + "_amount", this.totalAmount);
                } else if (tb.getAmount().signum() == 1) {
                    tb.addToAmountMap(tb.getFundId() + "_amount", TrialBalanceAction.numberToString((String)tb.getAmount().toString()).toString() + " Dr");
                    tb.setDebitAmount(tb.getAmount());
                    this.totalAmount = ((BigDecimal)this.fundWiseTotalMap.get(tb.getFundId() + "_amount")).add(tb.getAmount());
                    this.fundWiseTotalMap.put(tb.getFundId() + "_amount", this.totalAmount);
                }
                nonDuplicateMap.put(tb.getAccCode(), tb);
            }
            Collection values = nonDuplicateMap.values();
            for (TrialBalanceBean tb : values) {
                if (tb.getDebitAmount() != null) {
                    tb.setDebit(TrialBalanceAction.numberToString((String)tb.getDebitAmount().toString()).toString() + " Dr");
                } else {
                    tb.setDebit("0.00");
                }
                if (tb.getCreditAmount() != null) {
                    tb.setCredit(TrialBalanceAction.numberToString((String)tb.getCreditAmount().abs().toString()).toString() + " Cr");
                } else {
                    tb.setCredit("0.00");
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)tb);
                }
                if (tb.getDebitAmount() != null && tb.getCreditAmount() != null) {
                    BigDecimal add = tb.getDebitAmount().subtract(tb.getCreditAmount().abs());
                    this.totalCreditAmount = this.totalCreditAmount.add(add);
                    if (add.signum() == -1) {
                        tb.setAmount1(TrialBalanceAction.numberToString((String)add.abs().toString()) + " Cr");
                        continue;
                    }
                    tb.setAmount1(TrialBalanceAction.numberToString((String)add.toString()) + " Dr");
                    continue;
                }
                if (tb.getDebitAmount() != null) {
                    tb.setAmount1(TrialBalanceAction.numberToString((String)tb.getDebitAmount().toString()) + " Dr");
                    continue;
                }
                if (tb.getCreditAmount() != null) {
                    tb.setAmount1(TrialBalanceAction.numberToString((String)tb.getCreditAmount().abs().toString()) + " Cr");
                    continue;
                }
                tb.setAmount1("0.00");
            }
            this.al.addAll(values);
            Collections.sort(this.al, new COAcomparator(this));
            TrialBalanceBean tbTotal = new TrialBalanceBean();
            tbTotal.setAccCode("Total");
            for (String key : this.fundWiseTotalMap.keySet()) {
                String totalStr = "0.0";
                BigDecimal total = (BigDecimal)this.fundWiseTotalMap.get(key);
                if (total != null && total.signum() == -1) {
                    totalStr = TrialBalanceAction.numberToString((String)total.abs().toString()) + " Cr";
                } else if (total != null && total.signum() == 1) {
                    totalStr = TrialBalanceAction.numberToString((String)total.toString()) + " Dr";
                }
                tbTotal.addToAmountMap(key, totalStr);
                if (this.totalCreditAmount != null && this.totalCreditAmount.signum() == -1) {
                    totalStr = TrialBalanceAction.numberToString((String)total.abs().toString()) + " Cr";
                } else if (this.totalCreditAmount != null && this.totalCreditAmount.signum() == 1) {
                    totalStr = TrialBalanceAction.numberToString((String)total.toString()) + " Dr";
                }
                tbTotal.setAmount1(totalStr);
            }
            this.al.add(tbTotal);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void getReportForDateRange() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting getTBReport | Getting result for Date Range");
        }
        String voucherMisTable = "";
        String misClause = "";
        String misDeptCond = "";
        String tsDeptCond = "";
        String functionaryCond = "";
        String tsfunctionaryCond = "";
        String functionIdCond = "";
        String tsFunctionIdCond = "";
        String tsdivisionIdCond = "";
        String misdivisionIdCond = "";
        if (null != this.rb.getDepartmentId() || null != this.rb.getFunctionaryId() || null != this.rb.getDivisionId()) {
            voucherMisTable = ",vouchermis mis ";
            misClause = " and mis.voucherheaderid=vh.id ";
        }
        if (null != this.rb.getDepartmentId()) {
            misDeptCond = " and mis.DepartmentId= :departmentId";
            tsDeptCond = " and ts.DepartmentId= :departmentId";
        }
        if (null != this.rb.getFunctionaryId()) {
            functionaryCond = " and mis.FunctionaryId= :functionaryId";
            tsfunctionaryCond = " and ts.FunctionaryId= :functionaryId";
        }
        if (null != this.rb.getFunctionId()) {
            functionIdCond = " and gl.functionid =:functionId";
            tsFunctionIdCond = " and ts.FUNCTIONID= :functionId";
        }
        if (null != this.rb.getDivisionId()) {
            misdivisionIdCond = " and mis.divisionId= :divisionId";
            tsdivisionIdCond = " and ts.divisionId= :divisionId";
        }
        String defaultStatusExclude = null;
        List listAppConfVal = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "statusexcludeReport");
        if (null == listAppConfVal) {
            throw new ApplicationRuntimeException("Exlcude statusses not  are not defined for Reports");
        }
        defaultStatusExclude = ((AppConfigValues)listAppConfVal.get(0)).getValue();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"get Opening balance for all account codes");
        }
        String openingBalanceStr = "SELECT coa.glcode AS accCode ,coa.name  AS accName, SUM(ts.openingcreditbalance) as creditOPB,sum(ts.openingdebitbalance) as debitOPB FROM transactionsummary ts,chartofaccounts coa,financialyear fy  WHERE ts.glcodeid=coa.id  AND ts.financialyearid=fy.id and ts.FundId=:fundId " + tsDeptCond + tsfunctionaryCond + tsFunctionIdCond + tsdivisionIdCond + " AND fy.startingdate<=:fromDate AND fy.endingdate>=:toDate " + " GROUP BY ts.glcodeid,coa.glcode,coa.name ORDER BY coa.glcode ASC";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Query Str" + openingBalanceStr));
        }
        Query openingBalanceQry = this.persistenceService.getSession().createSQLQuery(openingBalanceStr).addScalar("accCode").addScalar("accName").addScalar("creditOPB", (Type)BigDecimalType.INSTANCE).addScalar("debitOPB", (Type)BigDecimalType.INSTANCE).setResultTransformer(Transformers.aliasToBean(TrialBalanceBean.class));
        openingBalanceQry.setInteger("fundId", this.rb.getFundId().intValue());
        if (null != this.rb.getDepartmentId()) {
            openingBalanceQry.setInteger("departmentId", this.rb.getDepartmentId().intValue());
        }
        if (null != this.rb.getFunctionaryId()) {
            openingBalanceQry.setInteger("functionaryId", this.rb.getFunctionaryId().intValue());
        }
        if (null != this.rb.getFunctionId()) {
            openingBalanceQry.setInteger("functionId", this.rb.getFunctionId().intValue());
        }
        if (null != this.rb.getDivisionId()) {
            openingBalanceQry.setInteger("divisionId", this.rb.getDivisionId().intValue());
        }
        openingBalanceQry.setDate("fromDate", this.rb.getFromDate());
        openingBalanceQry.setDate("toDate", this.rb.getToDate());
        List openingBalanceList = openingBalanceQry.list();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("Opening balance query ---->" + openingBalanceQry));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("get Opening balance for all account codes reulted in " + openingBalanceList.size()));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"get till date balance for all account codes");
        }
        String tillDateOPBStr = "SELECT coa.glcode AS accCode ,coa.name  AS accName, SUM(gl.creditAmount) as tillDateCreditOPB,sum(gl.debitAmount) as tillDateDebitOPB FROM generalledger  gl,chartofaccounts coa,financialyear fy,Voucherheader vh " + voucherMisTable + " WHERE gl.glcodeid=coa.id and vh.id=gl.voucherheaderid  and vh.fundid=:fundId " + misClause + misDeptCond + functionaryCond + functionIdCond + misdivisionIdCond + " AND vh.voucherdate>=fy.startingdate AND vh.voucherdate<=:fromDateMinus1 " + " AND fy.startingdate<=:fromDate AND fy.endingdate>=:toDate" + " AND vh.status not in (" + defaultStatusExclude + ")" + " GROUP BY gl.glcodeid,coa.glcode,coa.name ORDER BY coa.glcode ASC";
        Query tillDateOPBQry = this.persistenceService.getSession().createSQLQuery(tillDateOPBStr).addScalar("accCode").addScalar("accName").addScalar("tillDateCreditOPB", (Type)BigDecimalType.INSTANCE).addScalar("tillDateDebitOPB", (Type)BigDecimalType.INSTANCE).setResultTransformer(Transformers.aliasToBean(TrialBalanceBean.class));
        tillDateOPBQry.setInteger("fundId", this.rb.getFundId().intValue());
        if (null != this.rb.getDepartmentId()) {
            tillDateOPBQry.setInteger("departmentId", this.rb.getDepartmentId().intValue());
        }
        if (null != this.rb.getFunctionaryId()) {
            tillDateOPBQry.setInteger("functionaryId", this.rb.getFunctionaryId().intValue());
        }
        if (null != this.rb.getFunctionId()) {
            tillDateOPBQry.setInteger("functionId", this.rb.getFunctionId().intValue());
        }
        if (null != this.rb.getDivisionId()) {
            tillDateOPBQry.setInteger("divisionId", this.rb.getDivisionId().intValue());
        }
        tillDateOPBQry.setDate("fromDate", this.rb.getFromDate());
        tillDateOPBQry.setDate("toDate", this.rb.getToDate());
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.rb.getFromDate());
        cal.add(5, -1);
        tillDateOPBQry.setDate("fromDateMinus1", cal.getTime());
        List tillDateOPBList = tillDateOPBQry.list();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("get till date balance for all account codes reulted in " + tillDateOPBList.size()));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"get current debit and credit sum for all account codes  ");
        }
        String currentDebitCreditStr = "SELECT coa.glcode AS accCode ,coa.name  AS accName, SUM(gl.creditAmount) as creditAmount,sum(gl.debitAmount) as debitAmount FROM generalledger gl,chartofaccounts coa,financialyear fy,Voucherheader vh " + voucherMisTable + " WHERE gl.glcodeid=coa.id and vh.id= gl.voucherheaderid AND  vh.fundid=:fundId " + misClause + misDeptCond + functionaryCond + functionIdCond + misdivisionIdCond + " AND vh.voucherdate>=:fromDate AND vh.voucherdate<=:toDate " + " AND fy.startingdate<=:fromDate AND fy.endingdate>=:toDate" + " AND vh.status not in (" + defaultStatusExclude + ") " + " GROUP BY gl.glcodeid,coa.glcode,coa.name ORDER BY coa.glcode ASC";
        Query currentDebitCreditQry = this.persistenceService.getSession().createSQLQuery(currentDebitCreditStr).addScalar("accCode").addScalar("accName").addScalar("creditAmount", (Type)BigDecimalType.INSTANCE).addScalar("debitAmount", (Type)BigDecimalType.INSTANCE).setResultTransformer(Transformers.aliasToBean(TrialBalanceBean.class));
        currentDebitCreditQry.setInteger("fundId", this.rb.getFundId().intValue());
        if (null != this.rb.getDepartmentId()) {
            currentDebitCreditQry.setInteger("departmentId", this.rb.getDepartmentId().intValue());
        }
        if (null != this.rb.getFunctionaryId()) {
            currentDebitCreditQry.setInteger("functionaryId", this.rb.getFunctionaryId().intValue());
        }
        if (null != this.rb.getFunctionId()) {
            currentDebitCreditQry.setInteger("functionId", this.rb.getFunctionId().intValue());
        }
        if (null != this.rb.getDivisionId()) {
            currentDebitCreditQry.setInteger("divisionId", this.rb.getDivisionId().intValue());
        }
        currentDebitCreditQry.setDate("fromDate", this.rb.getFromDate());
        currentDebitCreditQry.setDate("toDate", this.rb.getToDate());
        List currentDebitCreditList = currentDebitCreditQry.list();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("closing balance query ---->" + currentDebitCreditQry));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("get current debit and credit sum for all account codes resulted in   " + currentDebitCreditList.size()));
        }
        LinkedHashMap<String, TrialBalanceBean> tbMap = new LinkedHashMap<String, TrialBalanceBean>();
        this.totalClosingBalance = BigDecimal.ZERO;
        this.totalOpeningBalance = BigDecimal.ZERO;
        if (!openingBalanceList.isEmpty()) {
            for (TrialBalanceBean tb : openingBalanceList) {
                tb.setOpeningBalance(tb.getDebitOPB().subtract(tb.getCreditOPB()));
                tb.setClosingBalance(tb.getOpeningBalance());
                tbMap.put(tb.getAccCode(), tb);
            }
        }
        for (TrialBalanceBean tillDateTB : tillDateOPBList) {
            if (null != tbMap.get(tillDateTB.getAccCode())) {
                BigDecimal opb = ((TrialBalanceBean)tbMap.get(tillDateTB.getAccCode())).getOpeningBalance().add(tillDateTB.getTillDateDebitOPB().subtract(tillDateTB.getTillDateCreditOPB()));
                ((TrialBalanceBean)tbMap.get(tillDateTB.getAccCode())).setOpeningBalance(opb);
                ((TrialBalanceBean)tbMap.get(tillDateTB.getAccCode())).setClosingBalance(opb);
                continue;
            }
            tillDateTB.setOpeningBalance(tillDateTB.getTillDateDebitOPB().subtract(tillDateTB.getTillDateCreditOPB()));
            tillDateTB.setClosingBalance(tillDateTB.getOpeningBalance());
            tbMap.put(tillDateTB.getAccCode(), tillDateTB);
        }
        BigDecimal cb = BigDecimal.ZERO;
        for (TrialBalanceBean currentAmounts : currentDebitCreditList) {
            if (null != tbMap.get(currentAmounts.getAccCode())) {
                ((TrialBalanceBean)tbMap.get(currentAmounts.getAccCode())).setDebitAmount(currentAmounts.getDebitAmount());
                ((TrialBalanceBean)tbMap.get(currentAmounts.getAccCode())).setCreditAmount(currentAmounts.getCreditAmount());
                cb = ((TrialBalanceBean)tbMap.get(currentAmounts.getAccCode())).getOpeningBalance().add(currentAmounts.getDebitAmount()).subtract(currentAmounts.getCreditAmount());
                ((TrialBalanceBean)tbMap.get(currentAmounts.getAccCode())).setClosingBalance(cb);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("old amounts" + this.totalOpeningBalance + "    " + this.totalClosingBalance));
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Current amounts" + ((TrialBalanceBean)tbMap.get(currentAmounts.getAccCode())).getOpeningBalance() + "    " + cb));
                }
                this.totalOpeningBalance = this.totalOpeningBalance.add(((TrialBalanceBean)tbMap.get(currentAmounts.getAccCode())).getOpeningBalance());
                this.totalClosingBalance = this.totalClosingBalance.add(cb);
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug((Object)("After Amounts" + this.totalOpeningBalance + "    " + this.totalClosingBalance));
                continue;
            }
            currentAmounts.setOpeningBalance(BigDecimal.ZERO);
            cb = currentAmounts.getOpeningBalance().add(currentAmounts.getDebitAmount()).subtract(currentAmounts.getCreditAmount());
            currentAmounts.setClosingBalance(cb);
            currentAmounts.setOpeningBalance(BigDecimal.ZERO);
            tbMap.put(currentAmounts.getAccCode(), currentAmounts);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("old getTBReport" + this.totalOpeningBalance + "    " + this.totalClosingBalance));
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Current amounts" + ((TrialBalanceBean)tbMap.get(currentAmounts.getAccCode())).getOpeningBalance() + "    " + cb));
            }
            this.totalClosingBalance = this.totalClosingBalance.add(cb);
            this.totalOpeningBalance = this.totalOpeningBalance.add(currentAmounts.getOpeningBalance());
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug((Object)("After getTBReport" + this.totalOpeningBalance + "    " + this.totalClosingBalance));
        }
        this.al.addAll(tbMap.values());
        Collections.sort(this.al, new COAcomparator(this));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Exiting getTBReport" + this.totalOpeningBalance + "    " + this.totalClosingBalance));
        }
    }

    private void formatTBReport() {
        for (TrialBalanceBean tb : this.al) {
            if (null == tb.getOpeningBalance()) {
                tb.setOpeningBal("0.00");
                tb.setOpeningBalance(BigDecimal.ZERO);
            } else if (tb.getOpeningBalance().compareTo(BigDecimal.ZERO) > 0) {
                tb.setOpeningBal(TrialBalanceAction.numberToString((String)tb.getOpeningBalance().toString()).toString() + " Dr");
            } else if (tb.getOpeningBalance().compareTo(BigDecimal.ZERO) < 0) {
                tb.setOpeningBal(TrialBalanceAction.numberToString((String)tb.getOpeningBalance().multiply(new BigDecimal(-1)).toString()).toString() + " Cr");
            } else {
                tb.setOpeningBal(TrialBalanceAction.numberToString((String)tb.getOpeningBalance().toString()).toString());
            }
            if (null == tb.getClosingBalance()) {
                tb.setClosingBal("0.00");
                tb.setClosingBalance(BigDecimal.ZERO);
            } else if (tb.getClosingBalance().compareTo(BigDecimal.ZERO) > 0) {
                tb.setClosingBal(TrialBalanceAction.numberToString((String)tb.getClosingBalance().toString()).toString() + " Dr");
            } else if (tb.getClosingBalance().compareTo(BigDecimal.ZERO) < 0) {
                tb.setClosingBal(TrialBalanceAction.numberToString((String)tb.getClosingBalance().multiply(new BigDecimal(-1)).toString()).toString() + " Cr");
            } else {
                tb.setClosingBal(tb.getClosingBalance().setScale(2).toString());
            }
            if (tb.getDebitAmount() != null) {
                tb.setDebit(TrialBalanceAction.numberToString((String)tb.getDebitAmount().toString()).toString());
            } else {
                tb.setDebit("0.00");
                tb.setDebitAmount(BigDecimal.ZERO);
            }
            if (tb.getCreditAmount() != null) {
                tb.setCredit(TrialBalanceAction.numberToString((String)tb.getCreditAmount().toString()).toString());
            } else {
                tb.setCredit("0.00");
                tb.setCreditAmount(BigDecimal.ZERO);
            }
            this.totalDebitAmount = this.totalDebitAmount.add(tb.getDebitAmount());
            this.totalCreditAmount = this.totalCreditAmount.add(tb.getCreditAmount());
        }
        TrialBalanceBean tb = new TrialBalanceBean();
        tb.setAccCode("   Total  ");
        tb.setAccName("");
        if (this.totalOpeningBalance.compareTo(BigDecimal.ZERO) > 0) {
            tb.setOpeningBal(TrialBalanceAction.numberToString((String)this.totalOpeningBalance.toString()).toString() + " Dr");
        } else if (this.totalOpeningBalance.compareTo(BigDecimal.ZERO) < 0) {
            this.totalOpeningBalance = this.totalOpeningBalance.abs();
            tb.setOpeningBal(TrialBalanceAction.numberToString((String)this.totalOpeningBalance.toString()).toString() + " Cr");
        } else {
            tb.setOpeningBal("0.00");
        }
        if (this.totalClosingBalance.compareTo(BigDecimal.ZERO) > 0) {
            tb.setClosingBal(TrialBalanceAction.numberToString((String)this.totalClosingBalance.toString()).toString() + " Dr");
        } else if (this.totalClosingBalance.compareTo(BigDecimal.ZERO) < 0) {
            this.totalClosingBalance = this.totalClosingBalance.abs();
            tb.setClosingBal(TrialBalanceAction.numberToString((String)this.totalClosingBalance.abs().toString()).toString() + " Cr");
        } else {
            tb.setClosingBal("0.00");
        }
        tb.setDebit(TrialBalanceAction.numberToString((String)this.totalDebitAmount.toString()).toString());
        tb.setCredit(TrialBalanceAction.numberToString((String)this.totalCreditAmount.toString()).toString());
        this.al.add(tb);
        if (this.removeEntrysWithZeroAmount.equalsIgnoreCase("Yes")) {
            this.removeEntrysWithZeroAmount(this.al);
        }
    }

    private void removeEntrysWithZeroAmount(List<TrialBalanceBean> taBean) {
        for (TrialBalanceBean trailBalance : taBean) {
            if (trailBalance.getOpeningBal().equalsIgnoreCase("0.00") && trailBalance.getCredit().equalsIgnoreCase("0.00") && trailBalance.getDebit().equalsIgnoreCase("0.00") && trailBalance.getClosingBal().equalsIgnoreCase("0.00")) continue;
            this.nonZeroItemsList.add(trailBalance);
        }
        this.al = this.nonZeroItemsList;
    }

    public static StringBuffer numberToString(String strNumberToConvert) {
        String strNumber = "";
        String signBit = "";
        if (strNumberToConvert.startsWith("-")) {
            strNumber = "" + strNumberToConvert.substring(1, strNumberToConvert.length());
            signBit = "-";
        } else {
            strNumber = "" + strNumberToConvert;
        }
        DecimalFormat dft = new DecimalFormat("##############0.00");
        String strtemp = "" + dft.format(Double.parseDouble(strNumber));
        StringBuffer strbNumber = new StringBuffer(strtemp);
        int intLen = strbNumber.length();
        for (int i = intLen - 6; i > 0; i -= 2) {
            strbNumber.insert(i, ',');
        }
        if (signBit.equals("-")) {
            strbNumber = strbNumber.insert(0, "-");
        }
        return strbNumber;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    private String generateHeading() {
        String name;
        StringBuffer heading = new StringBuffer(256);
        heading.append(" Trial Balance ");
        this.setTodayDate(new Date());
        if (this.rb.getFundId() != null) {
            heading.append(" For ");
            name = (String)this.persistenceService.find("select name from Fund where id=?", new Object[]{this.rb.getFundId()});
            heading.append(name);
        } else {
            heading.append(" For All Funds ");
        }
        if (this.rb.getFromDate() != null) {
            heading.append(" From ");
            name = this.mmddyyyyformatter.format(this.rb.getFromDate());
            heading.append(name);
        } else {
            CFinancialYear financialYearByDate = this.financialYearDAO.getFinancialYearByDate(this.rb.getToDate());
            heading.append(" From ");
            String name2 = this.mmddyyyyformatter.format(financialYearByDate.getStartingDate());
            this.setFinStartDate(financialYearByDate.getStartingDate());
            heading.append(name2);
        }
        if (this.rb.getToDate() != null) {
            heading.append(" To ");
            name = this.mmddyyyyformatter.format(this.rb.getToDate());
            heading.append(name);
        }
        if (this.rb.getFunctionId() != null) {
            heading.append(" in ");
            String code = (String)this.persistenceService.find("select name from CFunction where id=?", new Object[]{(long)this.rb.getFunctionId().intValue()});
            heading.append(code);
            this.rb.setFunctionName(code);
        }
        if (this.rb.getDepartmentId() != null) {
            heading.append(" For  " + (String)this.persistenceService.find("select name from Department where id=?", new Object[]{this.rb.getDepartmentId().longValue()}));
        }
        if (this.rb.getFunctionaryId() != null) {
            heading.append(" For  " + (String)this.persistenceService.find("select name from Functionary where id=?", new Object[]{this.rb.getFunctionaryId()}));
        }
        if (this.rb.getDivisionId() != null) {
            heading.append(" For  " + (String)this.persistenceService.find("select name from Boundary where id=?", new Object[]{this.rb.getDivisionId()}));
        }
        return heading.toString();
    }

    public ReportBean getRb() {
        return this.rb;
    }

    public CityService getCityWebsiteService() {
        return this.cityService;
    }

    public String getHeading() {
        return this.heading;
    }

    public List<TrialBalanceBean> getAl() {
        return this.al;
    }

    public ReportHelper getReportHelper() {
        return this.reportHelper;
    }

    public void setRb(ReportBean rb) {
        this.rb = rb;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public void setCityService(CityService cityService) {
        this.cityService = cityService;
    }

    public void setHeading(String heading) {
        this.heading = heading;
    }

    public void setAl(List<TrialBalanceBean> al) {
        this.al = al;
    }

    public void setReportHelper(ReportHelper reportHelper) {
        this.reportHelper = reportHelper;
    }

    public List<Fund> getFundList() {
        return this.fundList;
    }

    public void setFundList(List<Fund> fundList) {
        this.fundList = fundList;
    }

    public Map<String, BigDecimal> getFundWiseTotalMap() {
        return this.fundWiseTotalMap;
    }

    public void setFundWiseTotalMap(Map<String, BigDecimal> fundWiseTotalMap) {
        this.fundWiseTotalMap = fundWiseTotalMap;
    }

    public Date getFinStartDate() {
        return this.finStartDate;
    }

    public void setFinStartDate(Date finStartDate) {
        this.finStartDate = finStartDate;
    }

    public Date getTodayDate() {
        return this.todayDate;
    }

    public void setTodayDate(Date todayDate) {
        this.todayDate = todayDate;
    }

    public String getRemoveEntrysWithZeroAmount() {
        return this.removeEntrysWithZeroAmount;
    }

    public void setRemoveEntrysWithZeroAmount(String removeEntrysWithZeroAmount) {
        this.removeEntrysWithZeroAmount = removeEntrysWithZeroAmount;
    }

    public AppConfigValueService getAppConfigValuesService() {
        return this.appConfigValuesService;
    }

    public void setAppConfigValuesService(AppConfigValueService appConfigValuesService) {
        this.appConfigValuesService = appConfigValuesService;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setFinancialYearDAO(FinancialYearDAO financialYearDAO) {
        this.financialYearDAO = financialYearDAO;
    }
}

