/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.report;

import com.exilant.eGov.src.reports.GeneralLedgerReport;
import com.exilant.eGov.src.reports.GeneralLedgerReportBean;
import com.exilant.exility.common.TaskFailedException;
import com.opensymphony.xwork2.validator.annotations.RequiredFieldValidator;
import com.opensymphony.xwork2.validator.annotations.Validations;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.commons.CChartOfAccounts;
import org.egov.commons.Fund;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@ParentPackage(value="egov")
@Results(value={@Result(name="search", location="subLedgerReport-search.jsp")})
public class SubLedgerReportAction
extends BaseFormAction {
    private static final long serialVersionUID = 908820938838841653L;
    private static final Logger LOGGER = Logger.getLogger(SubLedgerReportAction.class);
    private GeneralLedgerReportBean subLedgerReport = new GeneralLedgerReportBean();
    @Autowired
    @Qualifier(value="generalLedgerReport")
    private GeneralLedgerReport generalLedgerReport;
    protected DateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
    protected LinkedList subLedgerDisplayList = new LinkedList();
    String heading = "";
    private String drillDownFromSchedule;

    public Object getModel() {
        return this.subLedgerReport;
    }

    public void prepareNewForm() {
        super.prepare();
        this.addDropdownData("fundList", this.persistenceService.findAllBy(" from Fund where isactive=true and isnotleaf=false order by name", new Object[0]));
        this.addDropdownData("departmentList", this.persistenceService.findAllBy("from Department order by name", new Object[0]));
        if (this.subLedgerReport != null && this.subLedgerReport.getGlCode1() != null && !this.subLedgerReport.getGlCode1().equalsIgnoreCase("")) {
            this.addDropdownData("subLedgerTypeList", this.persistenceService.findAllBy("select distinct adt from Accountdetailtype adt, CChartOfAccountDetail cad where cad.glCodeId.glcode = ? and cad.detailTypeId = adt ", new Object[]{this.subLedgerReport.getGlCode1()}));
        } else {
            this.addDropdownData("subLedgerTypeList", Collections.EMPTY_LIST);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Inside  Prepare ........");
        }
    }

    @SkipValidation
    @Action(value="/report/subLedgerReport-newForm")
    public String newForm() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"..Inside NewForm method..");
        }
        return "search";
    }

    @Validations(requiredFields={@RequiredFieldValidator(fieldName="glCode1", message="", key="Required"), @RequiredFieldValidator(fieldName="fund_id", message="", key="Required"), @RequiredFieldValidator(fieldName="subledger", message="", key="Required"), @RequiredFieldValidator(fieldName="accEntitycode", message="", key="Required"), @RequiredFieldValidator(fieldName="startDate", message="", key="Required"), @RequiredFieldValidator(fieldName="endDate", message="", key="Required")})
    @ValidationErrorPage(value="search")
    @SkipValidation
    @Action(value="/report/subLedgerReport-search")
    public String search() throws TaskFailedException {
        this.subLedgerReport.setReportType("sl");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"SubLedgerAction | Search | start");
        }
        try {
            this.subLedgerDisplayList = this.generalLedgerReport.getGeneralLedgerList(this.subLedgerReport);
        }
        catch (ValidationException e) {
            throw new ValidationException(e.getErrors());
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"SubLedgerAction | list | End");
        }
        this.heading = this.getGLHeading();
        this.subLedgerReport.setHeading(this.heading);
        this.prepareNewForm();
        return "search";
    }

    private String getGLHeading() {
        String heading = "";
        CChartOfAccounts glCode = new CChartOfAccounts();
        Fund fund = new Fund();
        if (this.checkNullandEmpty(this.subLedgerReport.getGlCode1()) && this.checkNullandEmpty(this.subLedgerReport.getGlCode1())) {
            glCode = (CChartOfAccounts)this.persistenceService.find("from CChartOfAccounts where glcode = ?", new Object[]{this.subLedgerReport.getGlCode1()});
            fund = (Fund)this.persistenceService.find("from Fund where id = ?", new Object[]{Integer.parseInt(this.subLedgerReport.getFund_id())});
        }
        heading = "Sub Ledger Report for " + this.subLedgerReport.getEntityName() + " in " + glCode.getName() + " under " + fund.getName() + " from " + this.subLedgerReport.getStartDate() + " to " + this.subLedgerReport.getEndDate();
        if (this.checkNullandEmpty(this.subLedgerReport.getDepartmentId())) {
            Department dept = (Department)this.persistenceService.find("from Department where id = ?", new Object[]{Long.parseLong(this.subLedgerReport.getDepartmentId())});
            heading = heading + " under " + dept.getName() + " ";
        }
        return heading;
    }

    private boolean checkNullandEmpty(String column) {
        return column != null && !column.isEmpty();
    }

    public String getHeading() {
        return this.heading;
    }

    public GeneralLedgerReportBean getSubLedgerReport() {
        return this.subLedgerReport;
    }

    public void setSubLedgerReport(GeneralLedgerReportBean subLedgerReport) {
        this.subLedgerReport = subLedgerReport;
    }

    public GeneralLedgerReport getSubLedger() {
        return this.generalLedgerReport;
    }

    public void setSubLedger(GeneralLedgerReport generalLedgerReport) {
        this.generalLedgerReport = generalLedgerReport;
    }

    public LinkedList getSubLedgerDisplayList() {
        return this.subLedgerDisplayList;
    }

    public void setSubLedgerDisplayList(LinkedList subLedgerDisplayList) {
        this.subLedgerDisplayList = subLedgerDisplayList;
    }

    public void setHeading(String heading) {
        this.heading = heading;
    }

    public String getDrillDownFromSchedule() {
        return this.drillDownFromSchedule;
    }

    public void setDrillDownFromSchedule(String drillDownFromSchedule) {
        this.drillDownFromSchedule = drillDownFromSchedule;
    }
}

