/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.report;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.egov.commons.CFunction;
import org.egov.commons.Functionary;
import org.egov.commons.Fund;
import org.egov.commons.Fundsource;
import org.egov.commons.Scheme;
import org.egov.commons.SubScheme;
import org.egov.egf.model.ReportSearch;
import org.egov.infra.admin.master.entity.AppConfig;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infstr.services.PersistenceService;
import org.hibernate.FlushMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class ReportAction
extends BaseFormAction {
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    private static final long serialVersionUID = 1L;
    protected ReportSearch reportSearch = new ReportSearch();
    protected List<String> headerFields = new ArrayList();
    protected List<String> mandatoryFields = new ArrayList();
    protected List<Object> schemeList = new ArrayList();
    protected static final String REPORT = "report";
    protected SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy", Locale.US);
    protected SimpleDateFormat formatter = new SimpleDateFormat("dd-MMM-yyyy", Locale.US);

    public Object getModel() {
        return this.reportSearch;
    }

    public ReportAction() {
        this.addRelatedEntity("department", Department.class);
        this.addRelatedEntity("function", CFunction.class);
        this.addRelatedEntity("fund", Fund.class);
        this.addRelatedEntity("scheme", Scheme.class);
        this.addRelatedEntity("subscheme", SubScheme.class);
        this.addRelatedEntity("functionary", Functionary.class);
        this.addRelatedEntity("fundsource", Fundsource.class);
        this.addRelatedEntity("field", Boundary.class);
    }

    public void prepare() {
        this.persistenceService.getSession().setDefaultReadOnly(true);
        this.persistenceService.getSession().setFlushMode(FlushMode.MANUAL);
        super.prepare();
        this.getHeaderFields();
        if (this.headerFields.contains("department")) {
            this.addDropdownData("departmentList", this.persistenceService.findAllBy("from Department order by name", new Object[0]));
        }
        if (this.headerFields.contains("function")) {
            this.addDropdownData("functionList", this.persistenceService.findAllBy("from CFunction where isactive=true and isnotleaf=false  order by name", new Object[0]));
        }
        if (this.headerFields.contains("functionary")) {
            this.addDropdownData("functionaryList", this.persistenceService.findAllBy(" from Functionary where isactive=true order by name", new Object[0]));
        }
        if (this.headerFields.contains("fund")) {
            this.addDropdownData("fundList", this.persistenceService.findAllBy(" from Fund where isactive=true and isnotleaf=false order by name", new Object[0]));
        }
        if (this.headerFields.contains("fundsource")) {
            this.addDropdownData("fundsourceList", this.persistenceService.findAllBy(" from Fundsource where isactive=true order by name", new Object[0]));
        }
        if (this.headerFields.contains("field")) {
            this.addDropdownData("fieldList", this.persistenceService.findAllBy(" from Boundary b where lower(b.boundaryType.name)='ward' ", new Object[0]));
        }
        if (this.headerFields.contains("scheme")) {
            this.addDropdownData("schemeList", Collections.EMPTY_LIST);
        }
        if (this.headerFields.contains("subscheme")) {
            this.addDropdownData("subschemeList", Collections.EMPTY_LIST);
        }
    }

    protected void getHeaderFields() {
        List appConfigList = this.persistenceService.findAllBy("from AppConfig where key_name = 'REPORT_SEARCH_MISATTRRIBUTES'", new Object[0]);
        for (AppConfig appConfig : appConfigList) {
            for (AppConfigValues appConfigVal : appConfig.getAppDataValues()) {
                String value = appConfigVal.getValue();
                String header = value.substring(0, value.indexOf(124));
                this.headerFields.add(header);
                String mandate = value.substring(value.indexOf(124) + 1);
                if (!mandate.equalsIgnoreCase("M")) continue;
                this.mandatoryFields.add(header);
            }
        }
    }

    public void validate() {
        this.checkMandatoryField("fund", "fund", (Object)this.reportSearch.getFund(), "voucher.fund.mandatory");
        this.checkMandatoryField("department", "department", (Object)this.reportSearch.getDepartment(), "voucher.department.mandatory");
        this.checkMandatoryField("scheme", "scheme", (Object)this.reportSearch.getScheme(), "voucher.scheme.mandatory");
        this.checkMandatoryField("subscheme", "subscheme", (Object)this.reportSearch.getSubScheme(), "voucher.subscheme.mandatory");
        this.checkMandatoryField("functionary", "functionary", (Object)this.reportSearch.getFunctionary(), "voucher.functionary.mandatory");
        this.checkMandatoryField("fundsource", "fundsource", (Object)this.reportSearch.getFundsource(), "voucher.fundsource.mandatory");
        this.checkMandatoryField("function", "function", (Object)this.reportSearch.getFunction(), "voucher.function.mandatory");
        this.checkMandatoryField("field", "field", (Object)this.reportSearch.getField(), "voucher.field.mandatory");
    }

    protected void checkMandatoryField(String objectName, String fieldName, Object value, String errorKey) {
        if (this.mandatoryFields.contains(fieldName) && value == null) {
            this.addFieldError(objectName, this.getText(errorKey));
        }
    }

    public boolean isFieldMandatory(String field) {
        return this.mandatoryFields.contains(field);
    }

    public boolean shouldShowHeaderField(String field) {
        return this.headerFields.contains(field);
    }

    public String ajaxLoadSchemes() {
        this.schemeList = this.persistenceService.findAllBy(" from Scheme where fund=?", new Object[]{this.reportSearch.getFund()});
        return "schemes";
    }

    public String ajaxLoadSubSchemes() {
        this.schemeList = this.persistenceService.findAllBy(" from SubScheme where scheme=?", new Object[]{this.reportSearch.getScheme()});
        return "schemes";
    }

    public List<Object> getSchemeList() {
        return this.schemeList;
    }

    public void setReportSearch(ReportSearch reportSearch) {
        this.reportSearch = reportSearch;
    }

    public ReportSearch getReportSearch() {
        return this.reportSearch;
    }
}

