/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.report;

import java.io.InputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.sf.jasperreports.engine.JasperPrint;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.egov.commons.CFinancialYear;
import org.egov.commons.Fund;
import org.egov.commons.dao.FinancialYearHibernateDAO;
import org.egov.egf.model.Statement;
import org.egov.egf.model.StatementEntry;
import org.egov.egf.model.StatementResultObject;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infstr.services.PersistenceService;
import org.egov.infstr.utils.EgovMasterDataCaching;
import org.egov.services.report.RPService;
import org.egov.utils.Constants;
import org.egov.utils.ReportHelper;
import org.hibernate.SQLQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@Results(value={@Result(name="PDF", type="stream", location="inputStream", params={"inputName", "inputStream", "contentType", "application/pdf", "contentDisposition", "no-cache;filename=receiptPaymentReport.pdf"}), @Result(name="XLS", type="stream", location="inputStream", params={"inputName", "inputStream", "contentType", "application/xls", "contentDisposition", "no-cache;filename=receiptPaymentReport.xls"})})
@ParentPackage(value="egov")
public class ReceiptPaymentReportAction
extends BaseFormAction {
    private static final long serialVersionUID = 1L;
    private static final String RECEIPT_PAYMENT_PDF = "PDF";
    private static final String RECEIPT_PAYMENT_XLS = "XLS";
    private static final String R = "R";
    private String scheduleNo;
    private RPService rpService;
    private Date todayDate;
    Statement receiptPayment = new Statement();
    private StringBuffer header = new StringBuffer();
    Map<String, String> scheduleMasterMap = new LinkedHashMap();
    protected FinancialYearHibernateDAO financialYearDAO;
    public static final Locale LOCALE = new Locale("en", "IN");
    public static final SimpleDateFormat DDMMYYYYFORMATS = new SimpleDateFormat("dd/MM/yyyy", LOCALE);
    static final Logger LOGGER = Logger.getLogger(ReceiptPaymentReportAction.class);
    InputStream inputStream;
    ReportHelper reportHelper;
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    @Autowired
    private EgovMasterDataCaching masterDataCache;

    public Object getModel() {
        return this.receiptPayment;
    }

    @Action(value="/report/receiptPaymentReport-newForm")
    public String newForm() {
        this.loadDropDownData();
        return "new";
    }

    @Action(value="/report/receiptPaymentReport-search")
    public String search() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Inside Search|Ready to fetch data");
        }
        this.generateReceiptPaymentReport();
        this.loadDropDownData();
        return "new";
    }

    @Action(value="/report/receiptPaymentReport-searchDetail")
    public String searchDetail() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Inside searchDetail| fetaching data for detail code result");
        }
        this.generateScheduleReport();
        return "detail";
    }

    private void generateScheduleReport() {
        this.header.append("Receipt Payment Report ").append(" for schedule No" + this.getScheduleNo());
        this.setRelatedEntitesOn();
        if (this.receiptPayment.getFund() != null && this.receiptPayment.getFund().getId() != null && !this.receiptPayment.getFund().getId().equals(0)) {
            this.fetchDetailDataAndPopulate();
        } else {
            this.populateConsolidatedScheduleReport();
        }
    }

    private void loadDropDownData() {
        this.addDropdownData("fundList", this.masterDataCache.get("egi-fund"));
        this.addDropdownData("financialYearList", this.getPersistenceService().findAllBy("from CFinancialYear where isActive=true order by finYearRange desc ", new Object[0]));
    }

    private void addAomuntToScheduleMap(List<StatementResultObject> receiptPaymentList, Map<String, BigDecimal> prepareMap) {
        for (StatementResultObject row : receiptPaymentList) {
            prepareMap.put(row.getScheduleNumber(), row.getAmount());
        }
    }

    public void fetchDetailDataAndPopulate() {
        CFinancialYear previousYear = this.getFinancialYearDAO().getPreviousFinancialYearByDate(this.receiptPayment.getFinancialYear().getStartingDate());
        LinkedHashMap scheduleDetailNonSubMasterMap = new LinkedHashMap();
        LinkedHashMap scheduleDetailSubMasterMap = new LinkedHashMap();
        LinkedHashMap subScheduleMasterMap = new LinkedHashMap();
        List tranType = this.rpService.getTransactionType(this.scheduleNo);
        List subScheduleMaster = this.rpService.getSubScheduleMaster(this.scheduleNo, this.receiptPayment.getFund().getCode());
        this.addScheduleNameAndNumberToMap(subScheduleMaster, subScheduleMasterMap);
        List scheduleDetailMasterNonSub = this.rpService.getDetailGlcodeNonSubSchedule(this.scheduleNo, this.receiptPayment.getFund().getCode());
        this.addScheduleNameAndNumberToMap(scheduleDetailMasterNonSub, scheduleDetailNonSubMasterMap);
        List scheduleDetailMasterSub = this.rpService.getDetailGlcodeSubSchedule(this.scheduleNo, this.receiptPayment.getFund().getCode());
        this.addScheduleNameAndNumberToMap(scheduleDetailMasterSub, scheduleDetailSubMasterMap);
        List currentDetail = this.rpService.getDetailData(this.receiptPayment.getFinancialYear(), tranType.get(0).toString(), this.scheduleNo, this.receiptPayment);
        List previousDetail = this.rpService.getDetailData(previousYear, tranType.get(0).toString(), this.scheduleNo, this.receiptPayment);
        this.addtoReceiptPaymentForDetailCode(subScheduleMasterMap, scheduleDetailSubMasterMap, scheduleDetailNonSubMasterMap, currentDetail, previousDetail, this.scheduleNo);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("size of detail code" + this.receiptPayment.getEntries().size()));
        }
    }

    private void generateReceiptPaymentReport() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"-----Starting generateReceiptPaymentReport-----");
        }
        this.header.append("Receipt Payment Report");
        this.setRelatedEntitesOn();
        if (this.receiptPayment.getFund() != null && this.receiptPayment.getFund().getId() != null && this.receiptPayment.getFund().getId() != 0) {
            this.fetchDataAndPopulate();
        } else {
            this.populateConsolidatedReport();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("size of receipt Payment  report is" + this.receiptPayment.getEntries().size()));
        }
    }

    public void fetchDataAndPopulate() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)" ReceiptPaymentReportAction| Inside fetchDataAndPopulate");
        }
        HashMap currentReceiptPaymentMap = new HashMap();
        HashMap previousReceiptPaymentMap = new HashMap();
        new StatementEntry();
        List scheduleReceiptPaymentMaster = this.rpService.getScheduleNoAndName();
        CFinancialYear previousYear = this.getFinancialYearDAO().getPreviousFinancialYearByDate(this.receiptPayment.getFinancialYear().getStartingDate());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Getting Current year Payment receipt");
        }
        List currentYearReceiptPaymentResult = this.rpService.getData(this.receiptPayment.getFinancialYear(), this.receiptPayment);
        this.addAomuntToScheduleMap(currentYearReceiptPaymentResult, currentReceiptPaymentMap);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)" Getting previous year Payment receipt");
        }
        List previousYearReceiptPaymentResult = this.rpService.getData(previousYear, this.receiptPayment);
        this.addAomuntToScheduleMap(previousYearReceiptPaymentResult, previousReceiptPaymentMap);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)" Populating receipt and payment to receipt Payment object");
        }
        this.addtoReceiptPayment(scheduleReceiptPaymentMaster, currentReceiptPaymentMap, previousReceiptPaymentMap);
    }

    private void addtoReceiptPayment(List<StatementResultObject> scheduleReceiptPaymentMasterList, Map<String, BigDecimal> currentReceiptPaymentMap, Map<String, BigDecimal> previousReceiptPaymentMap) {
        BigDecimal currentReceiptTotal = BigDecimal.ZERO;
        BigDecimal previousReceiptTotal = BigDecimal.ZERO;
        BigDecimal currentPaymentTotal = BigDecimal.ZERO;
        BigDecimal previousPaymentTotal = BigDecimal.ZERO;
        ArrayList<StatementEntry> receiptList = new ArrayList<StatementEntry>();
        ArrayList<StatementEntry> paymentList = new ArrayList<StatementEntry>();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"// Iterating to populate Receipt List and sum up total ");
        }
        receiptList.add(new StatementEntry(null, "Operating Receipt", null, null, null, true));
        paymentList.add(new StatementEntry(null, "Operating Payment", null, null, null, true));
        for (StatementResultObject entry : scheduleReceiptPaymentMasterList) {
            StatementEntry receiptbean = new StatementEntry();
            StatementEntry paymentbean = new StatementEntry();
            if (R.equals(entry.getType().toString())) {
                receiptbean.setScheduleNo(entry.getScheduleNumber());
                receiptbean.setAccountName(entry.getScheduleName());
                receiptbean.setCurrentYearTotal(currentReceiptPaymentMap.containsKey(entry.getScheduleNumber()) ? currentReceiptPaymentMap.get(entry.getScheduleNumber()) : BigDecimal.ZERO);
                currentReceiptTotal = currentReceiptTotal.add(receiptbean.getCurrentYearTotal());
                receiptbean.setPreviousYearTotal(previousReceiptPaymentMap.containsKey(entry.getScheduleNumber()) ? previousReceiptPaymentMap.get(entry.getScheduleNumber()) : BigDecimal.ZERO);
                previousReceiptTotal = previousReceiptTotal.add(receiptbean.getPreviousYearTotal());
                receiptList.add(receiptbean);
                continue;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)" Populating Payment list and adding up total");
            }
            paymentbean.setScheduleNo(entry.getScheduleNumber());
            paymentbean.setAccountName(entry.getScheduleName());
            paymentbean.setCurrentYearTotal(currentReceiptPaymentMap.containsKey(entry.getScheduleNumber()) ? currentReceiptPaymentMap.get(entry.getScheduleNumber()) : BigDecimal.ZERO);
            currentPaymentTotal = currentPaymentTotal.add(paymentbean.getCurrentYearTotal());
            paymentbean.setPreviousYearTotal(previousReceiptPaymentMap.containsKey(entry.getScheduleNumber()) ? previousReceiptPaymentMap.get(entry.getScheduleNumber()) : BigDecimal.ZERO);
            previousPaymentTotal = previousPaymentTotal.add(paymentbean.getPreviousYearTotal());
            paymentList.add(paymentbean);
        }
        receiptList.add(new StatementEntry(null, "Grand Total", "", previousReceiptTotal, currentReceiptTotal, true));
        paymentList.add(new StatementEntry(null, "Grand Total", "", previousPaymentTotal, currentPaymentTotal, true));
        this.receiptPayment.getEntries().addAll(receiptList);
        this.receiptPayment.getEntries().addAll(paymentList);
    }

    public void populateConsolidatedReport() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)" ReceiptPaymentReportAction| Inside fetchDataAndPopulate");
        }
        this.rpService.getScheduleNoAndName();
        Statement receiptEntry = new Statement();
        Statement paymentEntry = new Statement();
        receiptEntry.add(new StatementEntry(null, "Receipts", null, null, null, true));
        paymentEntry.add(new StatementEntry(null, "Payments", null, null, null, true));
        CFinancialYear previousYear = this.getFinancialYearDAO().getPreviousFinancialYearByDate(this.receiptPayment.getFinancialYear().getStartingDate());
        List currentReceiptPaymentList = this.rpService.getConsolidatedResult(this.receiptPayment.getFinancialYear(), this.receiptPayment);
        this.addFundWiseAmountToStatement(currentReceiptPaymentList, receiptEntry, paymentEntry);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)(" ReceiptPaymentReportAction| Receipt Payment size after adding current year receipt is" + this.receiptPayment.getEntries().size()));
        }
        List previousReceipt = this.rpService.getData(previousYear, this.receiptPayment);
        this.addPreviousYearAmountToStatement(previousReceipt, receiptEntry, paymentEntry);
        this.computeCurrentYearTotals(receiptEntry);
        this.computeCurrentYearTotals(paymentEntry);
        this.computeTotals(receiptEntry);
        this.computeTotals(paymentEntry);
        this.receiptPayment.addAll(receiptEntry);
        this.receiptPayment.addAll(paymentEntry);
    }

    private void computeTotals(Statement receipt) {
        HashMap fundNetTotals = new HashMap();
        BigDecimal currentFundAmount = BigDecimal.ZERO;
        BigDecimal preAmount = BigDecimal.ZERO;
        BigDecimal curAmount = BigDecimal.ZERO;
        StatementEntry statementObj = new StatementEntry();
        for (StatementEntry entry : receipt.getEntries()) {
            if (entry.getFundWiseAmount() != null) {
                for (Map.Entry row : entry.getFundWiseAmount().entrySet()) {
                    if (fundNetTotals.get(row.getKey()) == null) {
                        fundNetTotals.put(row.getKey(), BigDecimal.ZERO);
                    }
                    currentFundAmount = (BigDecimal)row.getValue();
                    fundNetTotals.put(row.getKey(), currentFundAmount.add((BigDecimal)fundNetTotals.get(row.getKey())));
                }
            }
            preAmount = preAmount.add(entry.getPreviousYearTotal() != null ? entry.getPreviousYearTotal() : BigDecimal.ZERO);
            curAmount = curAmount.add(entry.getCurrentYearTotal() != null ? entry.getCurrentYearTotal() : BigDecimal.ZERO);
        }
        statementObj.setAccountName("Grand Total");
        statementObj.setDisplayBold(true);
        statementObj.setFundWiseAmount(fundNetTotals);
        statementObj.setCurrentYearTotal(curAmount);
        statementObj.setPreviousYearTotal(preAmount);
        receipt.add(statementObj);
    }

    protected void setRelatedEntitesOn() {
        this.setTodayDate(new Date());
        if (this.receiptPayment.getFinancialYear() != null && this.receiptPayment.getFinancialYear().getId() != null) {
            this.receiptPayment.setFinancialYear((CFinancialYear)this.getPersistenceService().find("from CFinancialYear where id=?", new Object[]{this.receiptPayment.getFinancialYear().getId()}));
            this.header.append(" for the Financial Year " + this.receiptPayment.getFinancialYear().getFinYearRange());
        }
        if (this.receiptPayment.getFund() != null && this.receiptPayment.getFund().getId() != null && this.receiptPayment.getFund().getId() != 0) {
            this.receiptPayment.setFund((Fund)this.getPersistenceService().find("from Fund where id=?", new Object[]{this.receiptPayment.getFund().getId()}));
            this.header.append(" for " + this.receiptPayment.getFund().getName());
        }
        if (this.receiptPayment.getAsOndate() != null) {
            this.header.append(" as on " + DDMMYYYYFORMATS.format(this.receiptPayment.getAsOndate()));
        }
        this.header.toString();
    }

    public String exportReceiptPaymentScheduleXls() throws Exception {
        this.generateScheduleReport();
        String heading = this.getUlbName() + "\\n" + this.header.toString();
        String subtitle = "Report Run Date-" + DDMMYYYYFORMATS.format(this.getTodayDate());
        JasperPrint jasper = this.reportHelper.generateReceiptPaymentReportJasperPrint(this.receiptPayment, heading, subtitle, this.getCurrentYearToDate(), this.getPreviousYearToDate(), false);
        this.inputStream = this.reportHelper.exportXls(this.inputStream, jasper);
        return RECEIPT_PAYMENT_XLS;
    }

    public String exportReceiptPaymentSchedulePdf() throws Exception {
        this.generateScheduleReport();
        String heading = this.getUlbName() + "\\n" + this.header.toString();
        String subtitle = "Report Run Date-" + DDMMYYYYFORMATS.format(this.getTodayDate());
        JasperPrint jasper = this.reportHelper.generateReceiptPaymentReportJasperPrint(this.receiptPayment, heading, subtitle, this.getCurrentYearToDate(), this.getPreviousYearToDate(), false);
        this.inputStream = this.reportHelper.exportPdf(this.inputStream, jasper);
        return RECEIPT_PAYMENT_PDF;
    }

    public String exportReceiptPaymentXls() throws Exception {
        this.generateReceiptPaymentReport();
        String heading = this.getUlbName() + "\\n" + this.header.toString();
        String subtitle = "Report Run Date-" + DDMMYYYYFORMATS.format(this.getTodayDate());
        JasperPrint jasper = this.reportHelper.generateReceiptPaymentReportJasperPrint(this.receiptPayment, heading, subtitle, this.getCurrentYearToDate(), this.getPreviousYearToDate(), true);
        this.inputStream = this.reportHelper.exportXls(this.inputStream, jasper);
        return RECEIPT_PAYMENT_XLS;
    }

    public String exportReceiptPaymentPdf() throws Exception {
        this.generateReceiptPaymentReport();
        String heading = this.getUlbName() + "\\n" + this.header.toString();
        String subtitle = "Report Run Date-" + DDMMYYYYFORMATS.format(this.getTodayDate());
        JasperPrint jasper = this.reportHelper.generateReceiptPaymentReportJasperPrint(this.receiptPayment, heading, subtitle, this.getCurrentYearToDate(), this.getPreviousYearToDate(), true);
        this.inputStream = this.reportHelper.exportPdf(this.inputStream, jasper);
        return RECEIPT_PAYMENT_PDF;
    }

    private void addScheduleNameAndNumberToMap(List<Object[]> tempList, Map<String, String> resultMap) {
        for (Object[] row : tempList) {
            resultMap.put(row[0].toString(), row[1].toString());
        }
    }

    private void addToList(List<Object[]> tempList, List<String> resultList) {
        for (Object[] row : tempList) {
            resultList.add(row[0].toString());
        }
    }

    private void addtoReceiptPaymentForDetailCode(Map<String, String> subScheduleMasterMap, Map<String, String> scheduleDetailSubMasterMap, Map<String, String> scheduleDetailNonSubMasterMap, List<StatementResultObject> currentPayment, List<StatementResultObject> previousPayment, String scheduleNo) {
        BigDecimal currentTotal = BigDecimal.ZERO;
        BigDecimal previousTotal = BigDecimal.ZERO;
        boolean loadBean = false;
        for (Map.Entry<String, String> entry : subScheduleMasterMap.entrySet()) {
            BigDecimal currentSubTotal = BigDecimal.ZERO;
            BigDecimal previousSubTotal = BigDecimal.ZERO;
            this.receiptPayment.add(new StatementEntry(null, entry.getKey() + " : " + entry.getValue(), null, null, null, true));
            for (Map.Entry<String, String> subEntry : scheduleDetailSubMasterMap.entrySet()) {
                if (!entry.getKey().equals(subEntry.getValue())) continue;
                StatementEntry rpbean = new StatementEntry();
                rpbean.setGlCode(subEntry.getKey());
                for (StatementResultObject currentEntry : currentPayment) {
                    if (!currentEntry.getScheduleNumber().equals(scheduleNo) || !subEntry.getKey().equals(currentEntry.getGlCode())) continue;
                    loadBean = true;
                    rpbean.setCurrentYearTotal(currentEntry.getAmount());
                    currentTotal = currentTotal.add(rpbean.getCurrentYearTotal());
                    currentSubTotal = currentSubTotal.add(rpbean.getCurrentYearTotal());
                }
                for (StatementResultObject previousEntry : previousPayment) {
                    if (!previousEntry.getScheduleNumber().equals(scheduleNo) || !subEntry.getKey().equals(previousEntry.getGlCode())) continue;
                    loadBean = true;
                    rpbean.setPreviousYearTotal(previousEntry.getAmount());
                    previousTotal = previousTotal.add(rpbean.getPreviousYearTotal());
                    previousSubTotal = previousSubTotal.add(rpbean.getPreviousYearTotal());
                }
                if (!loadBean) continue;
                this.receiptPayment.getEntries().add(rpbean);
                loadBean = false;
            }
            this.receiptPayment.add(new StatementEntry(null, "Sub Total", null, previousSubTotal, currentSubTotal, true));
        }
        for (Map.Entry<String, String> nonSubEntry : scheduleDetailNonSubMasterMap.entrySet()) {
            StatementEntry rpbean = new StatementEntry();
            rpbean.setGlCode(nonSubEntry.getKey());
            for (StatementResultObject currentEntry : currentPayment) {
                if (!currentEntry.getScheduleNumber().equals(scheduleNo) || !nonSubEntry.getKey().equals(currentEntry.getGlCode())) continue;
                loadBean = true;
                rpbean.setCurrentYearTotal(currentEntry.getAmount());
                currentTotal = currentTotal.add(rpbean.getCurrentYearTotal());
            }
            for (StatementResultObject previousEntry : previousPayment) {
                if (!previousEntry.getScheduleNumber().equals(scheduleNo) || !nonSubEntry.getKey().equals(previousEntry.getGlCode())) continue;
                loadBean = true;
                rpbean.setPreviousYearTotal(previousEntry.getAmount());
                previousTotal = previousTotal.add(rpbean.getPreviousYearTotal());
            }
            if (!loadBean) continue;
            this.receiptPayment.getEntries().add(rpbean);
            loadBean = false;
        }
        this.receiptPayment.add(new StatementEntry(null, "Grand Total", null, previousTotal, currentTotal, true));
    }

    private void addtoReceiptPaymentForDetailCodeConsolidated(List<String> fundMasterList, Map<String, String> subScheduleMasterMap, Map<String, String> scheduleDetailSubMasterMap, Map<String, String> scheduleDetailNonSubMasterMap, List<StatementResultObject> currentPayment, List<StatementResultObject> previousPayment, String scheduleNo) {
        BigDecimal currentTotal = BigDecimal.ZERO;
        BigDecimal previousTotal = BigDecimal.ZERO;
        boolean loadBean = false;
        for (Map.Entry<String, String> entry : subScheduleMasterMap.entrySet()) {
            BigDecimal currentSubTotal = BigDecimal.ZERO;
            BigDecimal previousSubTotal = BigDecimal.ZERO;
            this.receiptPayment.add(new StatementEntry(null, entry.getKey() + " : " + entry.getValue(), null, null, null, true));
            for (Map.Entry<String, String> subEntry : scheduleDetailSubMasterMap.entrySet()) {
                if (!entry.getKey().equals(subEntry.getValue())) continue;
                StatementEntry rpbean = new StatementEntry();
                rpbean.setGlCode(subEntry.getKey());
                for (StatementResultObject currentEntry : currentPayment) {
                    for (String fundCode : fundMasterList) {
                        if (!currentEntry.getScheduleNumber().equals(scheduleNo) || !subEntry.getKey().equals(currentEntry.getGlCode()) || !fundCode.equals(currentEntry.getFundCode())) continue;
                        loadBean = true;
                        rpbean.putFundWiseAmount(currentEntry.getFundCode(), currentEntry.getAmount());
                        rpbean.setCurrentYearTotal(rpbean.getCurrentYearTotal().add(currentEntry.getAmount()));
                        currentTotal = currentTotal.add(rpbean.getCurrentYearTotal());
                        currentSubTotal = currentSubTotal.add(rpbean.getCurrentYearTotal());
                    }
                }
                for (StatementResultObject previousEntry : previousPayment) {
                    if (!previousEntry.getScheduleNumber().equals(scheduleNo) || !subEntry.getKey().equals(previousEntry.getGlCode())) continue;
                    loadBean = true;
                    rpbean.setPreviousYearTotal(previousEntry.getAmount());
                    previousTotal = previousTotal.add(rpbean.getPreviousYearTotal());
                    previousSubTotal = previousSubTotal.add(rpbean.getPreviousYearTotal());
                }
                if (!loadBean) continue;
                this.receiptPayment.getEntries().add(rpbean);
                loadBean = false;
            }
            this.receiptPayment.add(new StatementEntry(null, "Sub Total", null, previousSubTotal, currentSubTotal, true));
        }
        for (Map.Entry<String, String> nonSubEntry : scheduleDetailNonSubMasterMap.entrySet()) {
            StatementEntry rpbean = new StatementEntry();
            rpbean.setGlCode(nonSubEntry.getKey());
            for (StatementResultObject currentEntry : currentPayment) {
                for (String fundCode : fundMasterList) {
                    if (!currentEntry.getScheduleNumber().equals(scheduleNo) || !nonSubEntry.getKey().equals(currentEntry.getGlCode()) || !fundCode.equals(currentEntry.getFundCode())) continue;
                    loadBean = true;
                    rpbean.putFundWiseAmount(currentEntry.getFundCode(), currentEntry.getAmount());
                    rpbean.setCurrentYearTotal(rpbean.getCurrentYearTotal().add(currentEntry.getAmount()));
                    currentTotal = currentTotal.add(rpbean.getCurrentYearTotal());
                }
            }
            for (StatementResultObject previousEntry : previousPayment) {
                if (!previousEntry.getScheduleNumber().equals(scheduleNo) || !nonSubEntry.getKey().equals(previousEntry.getGlCode())) continue;
                loadBean = true;
                rpbean.setPreviousYearTotal(previousEntry.getAmount());
                previousTotal = previousTotal.add(rpbean.getPreviousYearTotal());
            }
            if (!loadBean) continue;
            this.receiptPayment.getEntries().add(rpbean);
            loadBean = false;
        }
        this.receiptPayment.add(new StatementEntry(null, "Grand Total", null, previousTotal, currentTotal, true));
    }

    private void addFundWiseAmountToStatement(List<StatementResultObject> rpCurrentYearList, Statement receipt, Statement payment) {
        boolean addRow = false;
        new HashMap();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"addFundWiseAmountToStatement | populating fundwise amount for current year");
        }
        for (StatementResultObject row : rpCurrentYearList) {
            int index;
            StatementEntry rpbean = new StatementEntry();
            if (R.equals(row.getType().toString())) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)" Populating recipt list");
                }
                if (receipt.containsStatementEntryScheduleNo(row.getScheduleNumber())) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)(" receipt entry contains more than 1 fund fro the " + row.getScheduleNumber() + "Schedule"));
                    }
                    for (index = 1; index < receipt.size(); ++index) {
                        if (!receipt.get(index).getScheduleNo().equals(row.getScheduleNumber())) continue;
                        receipt.get(index).getFundWiseAmount().put(row.getFundCode(), row.getAmount());
                    }
                } else {
                    addRow = true;
                    rpbean.setAccountName(row.getScheduleName());
                    rpbean.setScheduleNo(row.getScheduleNumber());
                    rpbean.setFundCode(row.getFundCode());
                    rpbean.getFundWiseAmount().put(row.getFundCode(), row.getAmount());
                }
                if (addRow) {
                    receipt.add(rpbean);
                }
                addRow = false;
                continue;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)" Populating Payment list");
            }
            if (payment.containsStatementEntryScheduleNo(row.getScheduleNumber())) {
                for (index = 1; index < payment.size(); ++index) {
                    if (!payment.get(index).getScheduleNo().equals(row.getScheduleNumber())) continue;
                    payment.get(index).getFundWiseAmount().put(row.getFundCode(), row.getAmount());
                }
            } else {
                addRow = true;
                rpbean.setAccountName(row.getScheduleName());
                rpbean.setScheduleNo(row.getScheduleNumber());
                rpbean.setFundCode(row.getFundCode());
                rpbean.getFundWiseAmount().put(row.getFundCode(), row.getAmount());
            }
            if (addRow) {
                payment.add(rpbean);
            }
            addRow = false;
        }
    }

    public void computeCurrentYearTotals(Statement receipt) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Adding current year total for receipt / payment");
        }
        for (StatementEntry receiptObj : receipt.getEntries()) {
            if (receiptObj.getFundWiseAmount() == null) continue;
            BigDecimal currentYearTotal = BigDecimal.ZERO;
            for (Map.Entry entry : receiptObj.getFundWiseAmount().entrySet()) {
                currentYearTotal = currentYearTotal.add((BigDecimal)entry.getValue());
            }
            receiptObj.setCurrentYearTotal(currentYearTotal);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"finished calculating  current year total for receipt / payment");
        }
    }

    private void addPreviousYearAmountToStatement(List<StatementResultObject> previousYearList, Statement receipt, Statement payment) {
        boolean addRow = false;
        for (StatementResultObject row : previousYearList) {
            StatementEntry entry = new StatementEntry();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Adding to receipt List");
            }
            if (R.equals(row.getType().toString())) {
                if (receipt.containsStatementEntryScheduleNo(row.getScheduleNumber())) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("iNSIDE RECEIPT FOR PREVIOUS YEAR" + row.getScheduleNumber()));
                    }
                    for (StatementEntry obj : receipt.getEntries()) {
                        if (obj.getScheduleNo() == null || !obj.getScheduleNo().equals(row.getScheduleNumber())) continue;
                        obj.setPreviousYearTotal(row.getAmount());
                    }
                } else {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("iNSIDE RECEIPT FOR PREVIOUS YEAR" + row.getScheduleNumber() + "aDDING NEW ENTRY"));
                    }
                    addRow = true;
                    entry.setScheduleNo(row.getScheduleNumber());
                    entry.setAccountName(row.getScheduleName());
                    entry.setPreviousYearTotal(row.getAmount());
                }
                if (addRow) {
                    receipt.add(entry);
                }
                addRow = false;
                continue;
            }
            if (payment.containsStatementEntryScheduleNo(row.getScheduleNumber())) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("iNSIDE RECEIPT FOR PREVIOUS YEAR" + row.getScheduleNumber()));
                }
                for (StatementEntry obj : payment.getEntries()) {
                    if (obj.getScheduleNo() == null || !obj.getScheduleNo().equals(row.getScheduleNumber())) continue;
                    obj.setPreviousYearTotal(row.getAmount());
                }
            } else {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("iNSIDE RECEIPT FOR PREVIOUS YEAR" + row.getScheduleNumber() + "aDDING NEW ENTRY"));
                }
                addRow = true;
                entry.setScheduleNo(row.getScheduleNumber());
                entry.setAccountName(row.getScheduleName());
                entry.setPreviousYearTotal(row.getAmount());
            }
            if (addRow) {
                payment.add(entry);
            }
            addRow = false;
        }
    }

    public void populateConsolidatedScheduleReport() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)" ReceiptPaymentReportAction| Inside fetchDataAndPopulate");
        }
        CFinancialYear previousYear = this.getFinancialYearDAO().getPreviousFinancialYearByDate(this.receiptPayment.getFinancialYear().getStartingDate());
        LinkedHashMap scheduleDetailNonSubMasterMap = new LinkedHashMap();
        LinkedHashMap scheduleDetailSubMasterMap = new LinkedHashMap();
        LinkedHashMap subScheduleMasterMap = new LinkedHashMap();
        ArrayList fundMasterList = new ArrayList();
        List tranType = this.rpService.getTransactionType(this.scheduleNo);
        List fundMaster = this.rpService.getfundMaster();
        this.addToList(fundMaster, fundMasterList);
        List subScheduleMaster = this.rpService.getSubScheduleMasterConsolidated(this.scheduleNo);
        this.addScheduleNameAndNumberToMap(subScheduleMaster, subScheduleMasterMap);
        List scheduleDetailMasterNonSub = this.rpService.getDetailGlcodeNonSubScheduleConsolidated(this.scheduleNo);
        this.addScheduleNameAndNumberToMap(scheduleDetailMasterNonSub, scheduleDetailNonSubMasterMap);
        List scheduleDetailMasterSub = this.rpService.getDetailGlcodeSubScheduleConsolidated(this.scheduleNo);
        this.addScheduleNameAndNumberToMap(scheduleDetailMasterSub, scheduleDetailSubMasterMap);
        List currentDetail = this.rpService.getCurrentYearConsolidatedReportForGlcode(this.receiptPayment.getFinancialYear(), tranType.get(0).toString(), this.scheduleNo, this.receiptPayment);
        List previousDetail = this.rpService.getDetailData(previousYear, tranType.get(0).toString(), this.scheduleNo, this.receiptPayment);
        this.addtoReceiptPaymentForDetailCodeConsolidated(fundMasterList, subScheduleMasterMap, scheduleDetailSubMasterMap, scheduleDetailNonSubMasterMap, currentDetail, previousDetail, this.scheduleNo);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("size of detail code" + this.receiptPayment.getEntries().size()));
        }
    }

    public String getCurrentYearToDate() {
        return "";
    }

    public String getPreviousYearToDate() {
        return "";
    }

    public void setFinancialYearDAO(FinancialYearHibernateDAO financialYearDAO) {
        this.financialYearDAO = financialYearDAO;
    }

    public void setHeader(StringBuffer header) {
        this.header = header;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public void setReceiptPayment(Statement receiptPayment) {
        this.receiptPayment = receiptPayment;
    }

    public void setReportHelper(ReportHelper reportHelper) {
        this.reportHelper = reportHelper;
    }

    public void setRpService(RPService rpService) {
        this.rpService = rpService;
    }

    public void setScheduleNo(String scheduleNo) {
        this.scheduleNo = scheduleNo;
    }

    public void setTodayDate(Date todayDate) {
        this.todayDate = todayDate;
    }

    public FinancialYearHibernateDAO getFinancialYearDAO() {
        return this.financialYearDAO;
    }

    public StringBuffer getHeader() {
        return this.header;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public String getFormattedDate(Date date) {
        return Constants.DDMMYYYYFORMAT2.format(date);
    }

    public Statement getReceiptPayment() {
        return this.receiptPayment;
    }

    public ReportHelper getReportHelper() {
        return this.reportHelper;
    }

    public RPService getRpService() {
        return this.rpService;
    }

    public String getScheduleNo() {
        return this.scheduleNo;
    }

    public Date getTodayDate() {
        return this.todayDate;
    }

    public String getUlbName() {
        SQLQuery query = this.persistenceService.getSession().createSQLQuery("select name from companydetail");
        List result = query.list();
        if (result != null) {
            return (String)result.get(0);
        }
        return "";
    }
}

