/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.report;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.egov.commons.CChartOfAccountDetail;
import org.egov.commons.CVoucherHeader;
import org.egov.commons.Fund;
import org.egov.commons.Vouchermis;
import org.egov.commons.dao.FinancialYearHibernateDAO;
import org.egov.commons.utils.EntityType;
import org.egov.deduction.model.EgRemittanceDetail;
import org.egov.egf.commons.EgovCommon;
import org.egov.egf.model.TDSEntry;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.exception.ApplicationException;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.reporting.engine.ReportConstants;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infstr.services.PersistenceService;
import org.egov.model.deduction.RemittanceBean;
import org.egov.model.instrument.InstrumentVoucher;
import org.egov.model.recoveries.Recovery;
import org.egov.services.deduction.RemitRecoveryService;
import org.egov.utils.Constants;
import org.hibernate.FlushMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@Results(value={@Result(name="PDF", type="stream", location="inputStream", params={"inputName", "inputStream", "contentType", "application/pdf", "contentDisposition", "no-cache;filename=DeductionDetailedReport.pdf"}), @Result(name="XLS", type="stream", location="inputStream", params={"inputName", "inputStream", "contentType", "application/xls", "contentDisposition", "no-cache;filename=DeductionDetailedReport.xls"}), @Result(name="summary-PDF", type="stream", location="inputStream", params={"inputName", "inputStream", "contentType", "application/pdf", "contentDisposition", "no-cache;filename=DeductionsRemittanceSummary.pdf"}), @Result(name="summary-XLS", type="stream", location="inputStream", params={"inputName", "inputStream", "contentType", "application/xls", "contentDisposition", "no-cache;filename=DeductionsRemittanceSummary.xls"}), @Result(name="results", location="pendingTDSReport-results.jsp"), @Result(name="entities", location="pendingTDSReport-entities.jsp"), @Result(name="summaryForm", location="pendingTDSReport-summaryForm.jsp"), @Result(name="reportForm", location="pendingTDSReport-reportForm.jsp"), @Result(name="summaryResults", location="pendingTDSReport-summaryResults.jsp")})
@ParentPackage(value="egov")
public class PendingTDSReportAction
extends BaseFormAction {
    private static final long serialVersionUID = 4077974966135536959L;
    String jasperpath = "pendingTDSReport";
    String summaryJasperpath = "summaryTDSReport";
    private Date asOnDate = new Date();
    private Date fromDate;
    private InputStream inputStream;
    private ReportService reportService;
    private String partyName = "";
    private String type = "";
    private Integer detailKey;
    private boolean showRemittedEntries = false;
    private List<RemittanceBean> pendingTDS = new ArrayList();
    private List<TDSEntry> remittedTDS = new ArrayList();
    private List<TDSEntry> inWorkflowTDS = new ArrayList();
    private Recovery recovery = new Recovery();
    private Fund fund = new Fund();
    private Department department = new Department();
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    @Autowired
    private EgovCommon egovCommon;
    private final List<EntityType> entitiesList = new ArrayList();
    private RemitRecoveryService remitRecoveryService;
    private FinancialYearHibernateDAO financialYearDAO;
    private String message = "";
    private String mode = "";
    private static Logger LOGGER = Logger.getLogger(PendingTDSReportAction.class);

    public void setFinancialYearDAO(FinancialYearHibernateDAO financialYearDAO) {
        this.financialYearDAO = financialYearDAO;
    }

    public void setRemitRecoveryService(RemitRecoveryService remitRecoveryService) {
        this.remitRecoveryService = remitRecoveryService;
    }

    public String execute() throws Exception {
        this.mode = "deduction";
        return "reportForm";
    }

    @Action(value="/report/pendingTDSReport-summaryReport")
    public String summaryReport() throws Exception {
        return "summaryForm";
    }

    public void prepare() {
        this.persistenceService.getSession().setDefaultReadOnly(true);
        this.persistenceService.getSession().setFlushMode(FlushMode.MANUAL);
        super.prepare();
        this.addDropdownData("departmentList", this.persistenceService.findAllBy("from Department order by name", new Object[0]));
        this.addDropdownData("fundList", this.persistenceService.findAllBy(" from Fund where isactive=true and isnotleaf=false order by name", new Object[0]));
        this.addDropdownData("recoveryList", this.persistenceService.findAllBy(" from Recovery where isactive=true order by chartofaccounts.glcode", new Object[0]));
    }

    @Action(value="/report/pendingTDSReport-ajaxLoadData")
    public String ajaxLoadData() {
        this.populateData();
        return "results";
    }

    @Action(value="/report/pendingTDSReport-ajaxLoadSummaryData")
    public String ajaxLoadSummaryData() {
        this.populateSummaryData();
        return "summaryResults";
    }

    public void setAsOnDate(Date startDate) {
        this.asOnDate = startDate;
    }

    public Date getAsOnDate() {
        return this.asOnDate;
    }

    public String getFormattedDate(Date date) {
        return Constants.DDMMYYYYFORMAT2.format(date);
    }

    @Action(value="/report/pendingTDSReport-exportPdf")
    public String exportPdf() throws JRException, IOException {
        this.generateReport();
        return "PDF";
    }

    @Action(value="/report/pendingTDSReport-exportSummaryPdf")
    public String exportSummaryPdf() throws JRException, IOException {
        this.generateSummaryReport();
        return "summary-PDF";
    }

    private void generateReport() {
        this.populateData();
        ReportRequest reportInput = new ReportRequest(this.jasperpath, (Collection)this.pendingTDS, this.getParamMap());
        ReportOutput reportOutput = this.reportService.createReport(reportInput);
        this.inputStream = new ByteArrayInputStream(reportOutput.getReportOutputData());
    }

    private void generateSummaryReport() {
        this.populateSummaryData();
        ReportRequest reportInput = new ReportRequest(this.summaryJasperpath, (Collection)this.remittedTDS, this.getParamMap());
        ReportOutput reportOutput = this.reportService.createReport(reportInput);
        this.inputStream = new ByteArrayInputStream(reportOutput.getReportOutputData());
    }

    Map<String, Object> getParamMap() {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("remittedTDSJasper", this.getClass().getResourceAsStream("/reports/templates/remittedTDSReport.jasper"));
        paramMap.put("inWorkflowTDSJasper", this.getClass().getResourceAsStream("/reports/templates/inWorkflowTDSReport.jasper"));
        paramMap.put("inWorkflowTDS", this.inWorkflowTDS);
        if (this.showRemittedEntries) {
            paramMap.put("remittedTDS", this.remittedTDS);
        } else {
            paramMap.put("remittedTDS", null);
        }
        String formatedAsOndate = Constants.DDMMYYYYFORMAT2.format(this.asOnDate);
        paramMap.put("asOnDate", formatedAsOndate);
        if (this.fromDate != null) {
            String formatedFromDate = Constants.DDMMYYYYFORMAT2.format(this.fromDate);
            paramMap.put("fromDate", formatedFromDate);
            paramMap.put("heading", "Deduction detailed report for " + this.recovery.getType() + " From " + formatedFromDate + "  to " + formatedAsOndate);
            paramMap.put("summaryheading", "Deductions remittance summary for " + this.recovery.getType() + " From " + formatedFromDate + "  to " + formatedAsOndate);
            paramMap.put("fromDateText", "From Date :      " + formatedFromDate);
        } else {
            paramMap.put("heading", "Deduction detailed report for " + this.recovery.getType() + " as on " + formatedAsOndate);
            paramMap.put("summaryheading", "Deductions remittance summary for " + this.recovery.getType() + " as on " + formatedAsOndate);
        }
        this.fund = (Fund)this.persistenceService.find("from Fund where id=?", new Object[]{this.fund.getId()});
        paramMap.put("fundName", this.fund.getName());
        paramMap.put("partyName", this.partyName);
        if (this.department.getId() != null && this.department.getId() != -1L) {
            this.department = (Department)this.persistenceService.find("from Department where id=?", new Object[]{this.department.getId()});
            paramMap.put("departmentName", this.department.getName());
        }
        this.recovery = (Recovery)this.persistenceService.find("from Recovery where id=?", new Object[]{this.recovery.getId()});
        paramMap.put("recoveryName", this.recovery.getRecoveryName());
        return paramMap;
    }

    private void populateData() {
        this.validateFinYear();
        if (this.getFieldErrors().size() > 0) {
            return;
        }
        this.recovery = (Recovery)this.persistenceService.find("from Recovery where id=?", new Object[]{this.recovery.getId()});
        this.type = this.recovery.getType();
        String deptQuery = "";
        String partyNameQuery = "";
        RemittanceBean remittanceBean = new RemittanceBean();
        remittanceBean.setRecoveryId(this.recovery.getId());
        if (this.department.getId() != null && this.department.getId() != -1L) {
            deptQuery = " and egRemittanceGldtl.generalledgerdetail.generalLedgerId.voucherHeaderId.vouchermis.departmentid.id=" + this.department.getId();
        }
        if (this.detailKey != null && this.detailKey != -1) {
            partyNameQuery = " and egRemittanceGldtl.generalledgerdetail.detailkeyid=" + this.detailKey;
        }
        if (this.fromDate != null) {
            remittanceBean.setFromDate(Constants.DDMMYYYYFORMAT1.format(this.fromDate));
        }
        this.pendingTDS = this.remitRecoveryService.getRecoveryDetailsForReport(remittanceBean, this.getVoucherHeader(), this.detailKey);
        StringBuffer query1 = new StringBuffer(1000);
        List result1 = new ArrayList();
        query1.append("from EgRemittanceDetail where  egRemittanceGldtl.generalledgerdetail.generalLedgerId.glcodeId.id=? and egRemittance.fund.id=? and egRemittance.voucherheader.status = 5 and egRemittanceGldtl.generalledgerdetail.generalLedgerId.voucherHeaderId.status=0 and egRemittanceGldtl.generalledgerdetail.generalLedgerId.voucherHeaderId.voucherDate <= ? ");
        if (this.fromDate != null) {
            query1.append(" and egRemittanceGldtl.generalledgerdetail.generalLedgerId.voucherHeaderId.voucherDate >= ?");
        }
        query1.append(deptQuery).append(partyNameQuery);
        query1.append(" order by egRemittanceGldtl.generalledgerdetail.generalLedgerId.voucherHeaderId.voucherNumber ");
        result1 = this.fromDate != null ? this.persistenceService.findAllBy(query1.toString(), new Object[]{this.recovery.getChartofaccounts().getId(), this.fund.getId(), this.asOnDate, this.fromDate}) : this.persistenceService.findAllBy(query1.toString(), new Object[]{this.recovery.getChartofaccounts().getId(), this.fund.getId(), this.asOnDate});
        Boolean createPartialRow1 = false;
        for (EgRemittanceDetail entry : result1) {
            createPartialRow1 = false;
            for (TDSEntry tdsExists : this.inWorkflowTDS) {
                if (tdsExists.getEgRemittanceGlDtlId().intValue() != entry.getEgRemittanceGldtl().getId().intValue()) continue;
                createPartialRow1 = true;
            }
            TDSEntry tds = new TDSEntry();
            tds.setEgRemittanceGlDtlId(entry.getEgRemittanceGldtl().getId());
            if (!createPartialRow1.booleanValue()) {
                tds = this.createTds(entry);
            }
            tds.setRemittedOn(Constants.DDMMYYYYFORMAT2.format(entry.getEgRemittance().getVoucherheader().getVoucherDate()));
            tds.setAmount(entry.getRemittedamt());
            if (entry.getEgRemittance().getVoucherheader() != null) {
                tds.setPaymentVoucherNumber(entry.getEgRemittance().getVoucherheader().getVoucherNumber());
            }
            List ivList = this.persistenceService.findAllBy("from InstrumentVoucher where instrumentHeaderId.statusId.description in(?,?,?) and voucherHeaderId=?", new Object[]{"Deposited", "New", "Reconciled", entry.getEgRemittance().getVoucherheader()});
            boolean isMultiple = false;
            for (InstrumentVoucher iv : ivList) {
                if (entry.getRemittedamt().compareTo(iv.getInstrumentHeaderId().getInstrumentAmount()) != 0) {
                    isMultiple = true;
                }
                tds.setChequeNumber(iv.getInstrumentHeaderId().getInstrumentNumber());
                if (isMultiple) {
                    tds.setChequeNumber(tds.getChequeNumber() + "-MULTIPLE");
                }
                tds.setChequeAmount(iv.getInstrumentHeaderId().getInstrumentAmount());
                if (iv.getInstrumentHeaderId().getInstrumentDate() == null) continue;
                tds.setDrawnOn(Constants.DDMMYYYYFORMAT2.format(iv.getInstrumentHeaderId().getInstrumentDate()));
            }
            this.inWorkflowTDS.add(tds);
        }
        if (this.showRemittedEntries) {
            if (this.department.getId() != null && this.department.getId() != -1L) {
                deptQuery = " and egRemittanceGldtl.generalledgerdetail.generalLedgerId.voucherHeaderId.vouchermis.departmentid.id=" + this.department.getId();
            }
            if (this.detailKey != null && this.detailKey != -1) {
                partyNameQuery = " and egRemittanceGldtl.generalledgerdetail.detailkeyid=" + this.detailKey;
            }
            StringBuffer query = new StringBuffer(1000);
            List result = new ArrayList();
            query.append("from EgRemittanceDetail where  egRemittanceGldtl.generalledgerdetail.generalLedgerId.glcodeId.id=? and egRemittance.fund.id=? and egRemittance.voucherheader.status = 0 and egRemittanceGldtl.generalledgerdetail.generalLedgerId.voucherHeaderId.status=0 and egRemittanceGldtl.generalledgerdetail.generalLedgerId.voucherHeaderId.voucherDate <= ? ");
            if (this.fromDate != null) {
                query.append(" and egRemittanceGldtl.generalledgerdetail.generalLedgerId.voucherHeaderId.voucherDate >= ?");
            }
            query.append(deptQuery).append(partyNameQuery);
            query.append(" order by egRemittanceGldtl.generalledgerdetail.generalLedgerId.voucherHeaderId.voucherNumber ");
            result = this.fromDate != null ? this.persistenceService.findAllBy(query.toString(), new Object[]{this.recovery.getChartofaccounts().getId(), this.fund.getId(), this.asOnDate, this.fromDate}) : this.persistenceService.findAllBy(query.toString(), new Object[]{this.recovery.getChartofaccounts().getId(), this.fund.getId(), this.asOnDate});
            Boolean createPartialRow = false;
            for (EgRemittanceDetail entry : result) {
                createPartialRow = false;
                for (TDSEntry tdsExists : this.remittedTDS) {
                    if (tdsExists.getEgRemittanceGlDtlId().intValue() != entry.getEgRemittanceGldtl().getId().intValue()) continue;
                    createPartialRow = true;
                }
                TDSEntry tds = new TDSEntry();
                tds.setEgRemittanceGlDtlId(entry.getEgRemittanceGldtl().getId());
                if (!createPartialRow.booleanValue()) {
                    tds = this.createTds(entry);
                }
                tds.setRemittedOn(Constants.DDMMYYYYFORMAT2.format(entry.getEgRemittance().getVoucherheader().getVoucherDate()));
                tds.setAmount(entry.getRemittedamt());
                if (entry.getEgRemittance().getVoucherheader() != null) {
                    tds.setPaymentVoucherNumber(entry.getEgRemittance().getVoucherheader().getVoucherNumber());
                }
                List ivList = this.persistenceService.findAllBy("from InstrumentVoucher where instrumentHeaderId.statusId.description in(?,?,?) and voucherHeaderId=?", new Object[]{"Deposited", "New", "Reconciled", entry.getEgRemittance().getVoucherheader()});
                boolean isMultiple = false;
                for (InstrumentVoucher iv : ivList) {
                    if (entry.getRemittedamt().compareTo(iv.getInstrumentHeaderId().getInstrumentAmount()) != 0) {
                        isMultiple = true;
                    }
                    tds.setChequeNumber(iv.getInstrumentHeaderId().getInstrumentNumber());
                    if (isMultiple) {
                        tds.setChequeNumber(tds.getChequeNumber() + "-MULTIPLE");
                    }
                    tds.setChequeAmount(iv.getInstrumentHeaderId().getInstrumentAmount());
                    if (iv.getInstrumentHeaderId().getInstrumentDate() == null) continue;
                    tds.setDrawnOn(Constants.DDMMYYYYFORMAT2.format(iv.getInstrumentHeaderId().getInstrumentDate()));
                }
                this.remittedTDS.add(tds);
            }
        }
    }

    private void populateSummaryData() {
        this.recovery = (Recovery)this.persistenceService.find("from Recovery where id=?", new Object[]{this.recovery.getId()});
        this.type = this.recovery.getType();
        String deptQuery = "";
        String partyNameQuery = "";
        if (this.department.getId() != null && this.department.getId() != -1L) {
            deptQuery = " and mis.departmentid=" + this.department.getId();
        }
        if (this.detailKey != null && this.detailKey != -1) {
            partyNameQuery = " and gld.detailkeyid=" + this.detailKey;
        }
        List result = new ArrayList();
        List resultTolDeduction = new ArrayList();
        try {
            String qry = "select vh.name,sum(erd.remittedamt),er.month from eg_remittance_detail erd, voucherheader vh1 right outer join eg_remittance er on vh1.id=er.paymentvhid,voucherheader vh,vouchermis mis,generalledger gl,generalledgerdetail gld,fund f,eg_remittance_gldtl ergl where  erd.remittancegldtlid= ergl.id and erd.remittanceid=er.id and gl.glcodeid=" + this.recovery.getChartofaccounts().getId() + " and vh.id=mis.voucherheaderid and " + "  vh1.status=0 and ergl.gldtlid=gld.id and gl.id=gld.generalledgerid and gl.voucherheaderid=vh.id and er.fundid=f.id and f.id=" + this.fund.getId() + " and vh.status=0 and vh.voucherDate <= to_date('" + Constants.DDMMYYYYFORMAT2.format(this.asOnDate) + "','dd/MM/yyyy') and " + "vh.voucherDate >= to_date('" + Constants.DDMMYYYYFORMAT2.format(this.financialYearDAO.getFinancialYearByDate(this.asOnDate).getStartingDate()) + "','dd/MM/yyyy') " + deptQuery + partyNameQuery + " group by er.month,vh.name order by er.month,vh.name";
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)qry);
            }
            result = this.persistenceService.getSession().createSQLQuery(qry).list();
            String qryTolDeduction = "SELECT type,MONTH,SUM(gldtamt) FROM (SELECT DISTINCT er.month AS MONTH,ergl.gldtlamt AS gldtamt,ergl.gldtlid as gldtlid,vh.name AS type FROM eg_remittance_detail erd,voucherheader vh1 RIGHT OUTER JOIN eg_remittance er ON vh1.id=er.paymentvhid,voucherheader vh,vouchermis mis,generalledger gl,generalledgerdetail gld,fund f, eg_remittance_gldtl ergl WHERE erd.remittancegldtlid= ergl.id AND erd.remittanceid=er.id  AND gl.glcodeid =" + this.recovery.getChartofaccounts().getId() + " AND vh.id =mis.voucherheaderid AND vh1.status =0 " + " AND ergl.gldtlid =gld.id  AND gl.id = gld.generalledgerid  AND gl.voucherheaderid     =vh.id  AND er.fundid =f.id" + " AND f.id =" + this.fund.getId() + " AND vh.status =0 AND vh.voucherDate <= to_date('" + Constants.DDMMYYYYFORMAT2.format(this.asOnDate) + "','dd/MM/yyyy') and " + " vh.voucherDate >= to_date('" + Constants.DDMMYYYYFORMAT2.format(this.financialYearDAO.getFinancialYearByDate(this.asOnDate).getStartingDate()) + "','dd/MM/yyyy') " + deptQuery + partyNameQuery + ") as temptable group by type,month";
            resultTolDeduction = this.persistenceService.getSession().createSQLQuery(qryTolDeduction).list();
        }
        catch (ApplicationRuntimeException e) {
            this.message = e.getMessage();
            return;
        }
        catch (Exception e) {
            this.message = e.getMessage();
            return;
        }
        for (Object[] entry : result) {
            for (Object[] dedentry : resultTolDeduction) {
                TDSEntry tds = new TDSEntry();
                String monthChk = (String)DateUtils.getAllMonthsWithFullNames().get(Integer.valueOf(entry[2].toString()) + 1);
                if (!monthChk.equalsIgnoreCase((String)DateUtils.getAllMonthsWithFullNames().get(Integer.valueOf(dedentry[1].toString()) + 1)) || !dedentry[0].toString().equalsIgnoreCase(entry[0].toString())) continue;
                tds.setNatureOfDeduction(entry[0].toString());
                tds.setTotalRemitted(new BigDecimal(entry[1].toString()));
                tds.setMonth((String)DateUtils.getAllMonthsWithFullNames().get(Integer.valueOf(entry[2].toString()) + 1));
                BigDecimal totDeduction = new BigDecimal(dedentry[2].toString());
                tds.setTotalDeduction(totDeduction);
                this.remittedTDS.add(tds);
            }
        }
    }

    private CVoucherHeader getVoucherHeader() {
        CVoucherHeader voucherHeader = new CVoucherHeader();
        voucherHeader.setFundId(this.fund);
        Vouchermis vouchermis = new Vouchermis();
        voucherHeader.setVouchermis(vouchermis);
        voucherHeader.getVouchermis().setDepartmentid(this.department);
        voucherHeader.setVoucherDate(this.asOnDate);
        return voucherHeader;
    }

    @Action(value="/report/pendingTDSReport-ajaxLoadEntites")
    public String ajaxLoadEntites() throws ClassNotFoundException {
        if (this.parameters.containsKey("recoveryId") && ((String[])this.parameters.get("recoveryId"))[0] != null && !"".equals(((String[])this.parameters.get("recoveryId"))[0])) {
            this.recovery = (Recovery)this.persistenceService.find("from Recovery where id=?", new Object[]{Long.valueOf(((String[])this.parameters.get("recoveryId"))[0])});
            for (CChartOfAccountDetail detail : this.recovery.getChartofaccounts().getChartOfAccountDetails()) {
                this.entitiesList.addAll(this.egovCommon.loadEntitesFor(detail.getDetailTypeId()));
            }
        }
        return "entities";
    }

    private TDSEntry createTds(EgRemittanceDetail entry) {
        TDSEntry tds = new TDSEntry();
        if (entry.getEgRemittanceGldtl().getRecovery() != null) {
            tds.setPartyCode(entry.getEgRemittanceGldtl().getRecovery().getEgPartytype().getCode());
        }
        tds.setEgRemittanceGlDtlId(entry.getEgRemittanceGldtl().getId());
        tds.setNatureOfDeduction(entry.getEgRemittanceGldtl().getGeneralledgerdetail().getGeneralLedgerId().getVoucherHeaderId().getName());
        tds.setVoucherNumber(entry.getEgRemittanceGldtl().getGeneralledgerdetail().getGeneralLedgerId().getVoucherHeaderId().getVoucherNumber());
        tds.setVoucherDate(Constants.DDMMYYYYFORMAT2.format(entry.getEgRemittanceGldtl().getGeneralledgerdetail().getGeneralLedgerId().getVoucherHeaderId().getVoucherDate()));
        EntityType entityType = this.getEntity(entry);
        if (entityType != null) {
            tds.setPartyName(entityType.getName());
            tds.setPartyCode(entityType.getCode());
            tds.setPanNo(entityType.getPanno());
        }
        tds.setAmount(entry.getEgRemittanceGldtl().getGldtlamt());
        return tds;
    }

    private EntityType getEntity(EgRemittanceDetail entry) {
        this.egovCommon.setPersistenceService(this.persistenceService);
        Integer detailKeyId = (int)entry.getEgRemittanceGldtl().getGeneralledgerdetail().getDetailKeyId();
        EntityType entityType = null;
        try {
            entityType = this.egovCommon.getEntityType(entry.getEgRemittanceGldtl().getGeneralledgerdetail().getDetailTypeId(), (Serializable)detailKeyId);
        }
        catch (ApplicationException e) {
            e.printStackTrace();
        }
        return entityType;
    }

    @Action(value="/report/pendingTDSReport-exportXls")
    public String exportXls() throws JRException, IOException {
        this.populateData();
        ReportRequest reportInput = new ReportRequest(this.jasperpath, (Collection)this.pendingTDS, this.getParamMap());
        reportInput.setReportFormat(ReportConstants.FileFormat.XLS);
        ReportOutput reportOutput = this.reportService.createReport(reportInput);
        this.inputStream = new ByteArrayInputStream(reportOutput.getReportOutputData());
        return "XLS";
    }

    @Action(value="/report/pendingTDSReport-exportSummaryXls")
    public String exportSummaryXls() throws JRException, IOException {
        this.populateSummaryData();
        ReportRequest reportInput = new ReportRequest(this.summaryJasperpath, (Collection)this.remittedTDS, this.getParamMap());
        reportInput.setReportFormat(ReportConstants.FileFormat.XLS);
        ReportOutput reportOutput = this.reportService.createReport(reportInput);
        this.inputStream = new ByteArrayInputStream(reportOutput.getReportOutputData());
        return "summary-XLS";
    }

    public void validateFinYear() {
        if (this.fromDate != null) {
            Constants.DDMMYYYYFORMAT2.format(this.fromDate);
            if (this.financialYearDAO.isSameFinancialYear(this.fromDate, this.asOnDate)) {
                return;
            }
            this.addFieldError("fromDate", "Dates are not within same Financial Year");
        }
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public Object getModel() {
        return null;
    }

    public void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    public void setPartyName(String partyName) {
        this.partyName = partyName;
    }

    public String getPartyName() {
        return this.partyName;
    }

    public void setShowRemittedEntries(boolean showRemittedEntries) {
        this.showRemittedEntries = showRemittedEntries;
    }

    public boolean getShowRemittedEntries() {
        return this.showRemittedEntries;
    }

    public boolean isShowRemittedEntries() {
        return this.showRemittedEntries;
    }

    public void setPendingTDS(List<RemittanceBean> pendingTDS) {
        this.pendingTDS = pendingTDS;
    }

    public List<RemittanceBean> getPendingTDS() {
        return this.pendingTDS;
    }

    public void setRemittedTDS(List<TDSEntry> remittedTDS) {
        this.remittedTDS = remittedTDS;
    }

    public List<TDSEntry> getRemittedTDS() {
        return this.remittedTDS;
    }

    public List<TDSEntry> getInWorkflowTDS() {
        return this.inWorkflowTDS;
    }

    public void setInWorkflowTDS(List<TDSEntry> inWorkflowTDS) {
        this.inWorkflowTDS = inWorkflowTDS;
    }

    public void setRecovery(Recovery recovery) {
        this.recovery = recovery;
    }

    public Recovery getRecovery() {
        return this.recovery;
    }

    public void setFund(Fund fund) {
        this.fund = fund;
    }

    public Fund getFund() {
        return this.fund;
    }

    public List<EntityType> getEntitiesList() {
        return this.entitiesList;
    }

    public void setDepartment(Department department) {
        this.department = department;
    }

    public Department getDepartment() {
        return this.department;
    }

    public void setDetailKey(Integer detailKey) {
        this.detailKey = detailKey;
    }

    public Integer getDetailKey() {
        return this.detailKey;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public Date getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(Date fromDate) {
        this.fromDate = fromDate;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }
}

