/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.report;

import com.exilant.eGov.src.reports.OpeningBalance;
import com.exilant.eGov.src.reports.OpeningBalanceInputBean;
import com.exilant.exility.common.TaskFailedException;
import com.opensymphony.xwork2.validator.annotations.RequiredFieldValidator;
import com.opensymphony.xwork2.validator.annotations.Validations;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.commons.CFinancialYear;
import org.egov.commons.Fund;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.infstr.services.PersistenceService;
import org.hibernate.FlushMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@ParentPackage(value="egov")
@Results(value={@Result(name="result", location="openingBalanceReport-result.jsp"), @Result(name="search", location="openingBalanceReport-search.jsp")})
public class OpeningBalanceReportAction
extends BaseFormAction {
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    private static final long serialVersionUID = -2567999475434622263L;
    private static final Logger LOGGER = Logger.getLogger(OpeningBalanceReportAction.class);
    private OpeningBalanceInputBean openingBalanceReport = new OpeningBalanceInputBean();
    private OpeningBalance openingBalance;
    protected DateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
    protected ArrayList openingBalanceDisplayList = new ArrayList();
    String heading = "";

    public Object getModel() {
        return this.openingBalanceReport;
    }

    public void prepareNewForm() {
        super.prepare();
        this.persistenceService.getSession().setDefaultReadOnly(true);
        this.persistenceService.getSession().setFlushMode(FlushMode.MANUAL);
        this.addDropdownData("fundList", this.persistenceService.findAllBy(" from Fund where isactive=true and isnotleaf=false order by name", new Object[0]));
        this.addDropdownData("departmentList", this.persistenceService.findAllBy("from Department order by name", new Object[0]));
        this.addDropdownData("financialYearList", this.persistenceService.findAllBy("from CFinancialYear order by finYearRange desc ", new Object[0]));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Inside  Prepare ........");
        }
    }

    @SkipValidation
    @Action(value="/report/openingBalanceReport-newForm")
    public String newForm() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"..Inside NewForm method..");
        }
        return "search";
    }

    @Validations(requiredFields={@RequiredFieldValidator(fieldName="finYear", message="", key="Required")})
    @ValidationErrorPage(value="search")
    @Action(value="/report/openingBalanceReport-ajaxSearch")
    public String ajaxSearch() throws TaskFailedException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"OpeningBalanceReportAction | Search | start");
        }
        try {
            this.openingBalanceDisplayList = this.openingBalance.getOBReport(this.openingBalanceReport);
        }
        catch (ValidationException e) {
            throw new ValidationException(e.getErrors());
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException(e.getMessage());
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"OpeningBalanceReportAction | list | End");
        }
        this.heading = this.getGLHeading();
        this.prepareNewForm();
        this.persistenceService.getSession().setFlushMode(FlushMode.AUTO);
        return "result";
    }

    private String getGLHeading() {
        String heading = "Opening Balance for the Year ";
        CFinancialYear finYear = new CFinancialYear();
        Fund fund = new Fund();
        Department dept = new Department();
        if (this.checkNullandEmpty(this.openingBalanceReport.getFinYear())) {
            finYear = (CFinancialYear)this.persistenceService.find("from CFinancialYear where id = ?", new Object[]{Long.parseLong(this.openingBalanceReport.getFinYear())});
            heading = heading + finYear.getFinYearRange();
        }
        if (this.checkNullandEmpty(this.openingBalanceReport.getObFund_id())) {
            fund = (Fund)this.persistenceService.find("from Fund where id = ?", new Object[]{Integer.parseInt(this.openingBalanceReport.getObFund_id())});
            heading = heading + " under " + fund.getName();
        }
        if (this.checkNullandEmpty(this.openingBalanceReport.getDeptId())) {
            dept = (Department)this.persistenceService.find("from Department where id = ?", new Object[]{Long.parseLong(this.openingBalanceReport.getDeptId())});
            heading = heading + " and " + dept.getName() + " Department ";
        }
        return heading;
    }

    private boolean checkNullandEmpty(String column) {
        return column != null && !column.isEmpty();
    }

    public String getHeading() {
        return this.heading;
    }

    public void setHeading(String heading) {
        this.heading = heading;
    }

    public OpeningBalanceInputBean getOpeningBalanceReport() {
        return this.openingBalanceReport;
    }

    public void setOpeningBalanceReport(OpeningBalanceInputBean openingBalanceReport) {
        this.openingBalanceReport = openingBalanceReport;
    }

    public OpeningBalance getOpeningBalance() {
        return this.openingBalance;
    }

    public void setOpeningBalance(OpeningBalance openingBalance) {
        this.openingBalance = openingBalance;
    }

    public ArrayList getOpeningBalanceDisplayList() {
        return this.openingBalanceDisplayList;
    }

    public void setOpeningBalanceDisplayList(ArrayList openingBalanceDisplayList) {
        this.openingBalanceDisplayList = openingBalanceDisplayList;
    }
}

