/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.report;

import com.exilant.GLEngine.GeneralLedgerBean;
import com.exilant.exility.common.TaskFailedException;
import com.opensymphony.xwork2.validator.annotations.RequiredFieldValidator;
import com.opensymphony.xwork2.validator.annotations.Validations;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.commons.CFunction;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.reporting.util.ReportUtil;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.infstr.services.PersistenceService;
import org.egov.infstr.utils.EgovMasterDataCaching;
import org.egov.utils.VoucherHelper;
import org.hibernate.Query;
import org.hibernate.transform.Transformers;
import org.hibernate.type.StringType;
import org.hibernate.type.Type;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@ParentPackage(value="egov")
@Results(value={@Result(name="result", location="journalBookReport-result.jsp"), @Result(name="search", location="journalBookReport-search.jsp")})
public class JournalBookReportAction
extends BaseFormAction {
    private static final long serialVersionUID = -7540296344209825345L;
    private static final Logger LOGGER = Logger.getLogger(JournalBookReportAction.class);
    private GeneralLedgerBean journalBookReport = new GeneralLedgerBean();
    protected DateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
    private List<GeneralLedgerBean> journalBookDisplayList = new ArrayList();
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    @Autowired
    private EgovMasterDataCaching masterDataCache;
    String heading = "";

    public Object getModel() {
        return this.journalBookReport;
    }

    public void prepareNewForm() {
        super.prepare();
        this.addDropdownData("fundList", this.persistenceService.findAllBy(" from Fund where isactive=true and isnotleaf=false order by name", new Object[0]));
        this.addDropdownData("fundsourceList", this.persistenceService.findAllBy(" from Fundsource where isactive=true order by name", new Object[0]));
        this.addDropdownData("departmentList", this.persistenceService.findAllBy("from Department order by name", new Object[0]));
        this.addDropdownData("functionList", this.masterDataCache.get("egi-function"));
        this.addDropdownData("voucherNameList", (List)VoucherHelper.VOUCHER_TYPE_NAMES.get("Journal Voucher"));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Inside  Prepare ........");
        }
    }

    @SkipValidation
    @Action(value="/report/journalBookReport-newForm")
    public String newForm() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"..Inside NewForm method..");
        }
        return "search";
    }

    @Validations(requiredFields={@RequiredFieldValidator(fieldName="fund_id", message="", key="Required"), @RequiredFieldValidator(fieldName="startDate", message="", key="Required"), @RequiredFieldValidator(fieldName="endDate", message="", key="Required")})
    @ValidationErrorPage(value="search")
    @SkipValidation
    @Action(value="/report/journalBookReport-ajaxSearch")
    public String ajaxSearch() throws TaskFailedException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"JournalBookAction | Search | start");
        }
        this.journalBookReport.setUlbName(ReportUtil.getCityName());
        this.prepareResultList();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"JournalBookAction | list | End");
        }
        this.heading = this.getGLHeading();
        this.prepareNewForm();
        return "result";
    }

    private void prepareResultList() {
        String voucherDate = "";
        String voucherNumber = "";
        String voucherName = "";
        String narration = "";
        Query query = null;
        query = this.persistenceService.getSession().createSQLQuery(this.getQuery()).addScalar("voucherdate", (Type)StringType.INSTANCE).addScalar("vouchernumber", (Type)StringType.INSTANCE).addScalar("code", (Type)StringType.INSTANCE).addScalar("accName", (Type)StringType.INSTANCE).addScalar("narration", (Type)StringType.INSTANCE).addScalar("debitamount", (Type)StringType.INSTANCE).addScalar("creditamount", (Type)StringType.INSTANCE).addScalar("voucherName", (Type)StringType.INSTANCE).addScalar("vhId", (Type)StringType.INSTANCE).setResultTransformer(Transformers.aliasToBean(GeneralLedgerBean.class));
        this.journalBookDisplayList = query.list();
        for (GeneralLedgerBean bean : this.journalBookDisplayList) {
            bean.setDebitamount(new BigDecimal(bean.getDebitamount()).setScale(2, 6).toString());
            bean.setCreditamount(new BigDecimal(bean.getCreditamount()).setScale(2, 6).toString());
            if (voucherDate != null && !voucherDate.equalsIgnoreCase("") && voucherDate.equalsIgnoreCase(bean.getVoucherdate()) && voucherNumber.equalsIgnoreCase(bean.getVouchernumber())) {
                bean.setVoucherdate("");
            } else {
                voucherDate = bean.getVoucherdate();
            }
            if (voucherName != null && !voucherName.equalsIgnoreCase("") && voucherName.equalsIgnoreCase(bean.getVoucherName()) && voucherNumber.equalsIgnoreCase(bean.getVouchernumber())) {
                bean.setVoucherName("");
            } else {
                voucherName = bean.getVoucherName();
            }
            if (voucherNumber != null && !voucherNumber.equalsIgnoreCase("") && voucherNumber.equalsIgnoreCase(bean.getVouchernumber())) {
                bean.setVouchernumber("");
            } else {
                voucherNumber = bean.getVouchernumber();
            }
            if (narration != null && !narration.equalsIgnoreCase("") && narration.equalsIgnoreCase(bean.getNarration())) {
                bean.setNarration("");
                continue;
            }
            narration = bean.getNarration();
        }
    }

    private String getQuery() {
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
        SimpleDateFormat formatter = new SimpleDateFormat("dd-MMM-yyyy");
        String startDate = "";
        String endDate = "";
        try {
            startDate = formatter.format(sdf.parse(this.journalBookReport.getStartDate()));
            endDate = formatter.format(sdf.parse(this.journalBookReport.getEndDate()));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        String query = "";
        String subQuery = "";
        if (this.journalBookReport.getFund_id() != null && !this.journalBookReport.getFund_id().equals("")) {
            subQuery = subQuery + " and f.id= " + this.journalBookReport.getFund_id() + " ";
        }
        if (this.journalBookReport.getVoucher_name() != null && !this.journalBookReport.getVoucher_name().equals("")) {
            subQuery = subQuery + " and vh.Name='" + this.journalBookReport.getVoucher_name() + "' ";
        }
        if (this.journalBookReport.getDept_name() != null && !this.journalBookReport.getDept_name().equals("")) {
            subQuery = subQuery + " and vmis.departmentid=" + this.journalBookReport.getDept_name() + " ";
        }
        if (this.journalBookReport.getFunctionId() != null && !this.journalBookReport.getFunctionId().equals("")) {
            subQuery = subQuery + " and vmis.functionid  =" + this.journalBookReport.getFunctionId() + " ";
        }
        query = "SELECT TO_CHAR(vh.voucherdate,'dd-Mon-yyyy') AS voucherdate,vh.vouchernumber AS vouchernumber,f.name AS fund,gl.glcode AS code,coa.name AS accName,vh.description AS narration,vh.isconfirmed AS isconfirmed,gl.debitamount AS debitamount, gl.creditamount AS creditamount,vh.name AS voucherName,vh.id AS vhId  FROM voucherheader vh, generalledger gl,fund f,function fn ,vouchermis vmis,chartofaccounts coa WHERE vh.id = gl.voucherheaderid AND gl.glcodeid = coa.id AND vh.fundid = f.id AND vmis.functionid = fn.id AND vmis.voucherheaderid=vh.id AND vh.status NOT IN (4,5)" + subQuery + " and vh.voucherdate >='" + startDate + "' " + " and vh.voucherdate<='" + endDate + "'";
        return query;
    }

    private String getGLHeading() {
        String heading = "";
        heading = "Journal Book Report under " + this.journalBookReport.getFundName() + " from " + this.journalBookReport.getStartDate() + " to " + this.journalBookReport.getEndDate();
        Department dept = new Department();
        CFunction function = new CFunction();
        if (this.checkNullandEmpty(this.journalBookReport.getDept_name())) {
            dept = (Department)this.persistenceService.find("from Department where  id = ?", new Object[]{Long.parseLong(this.journalBookReport.getDept_name())});
            heading = heading + " and Department : " + dept.getName();
        }
        if (this.checkNullandEmpty(this.journalBookReport.getFunctionId())) {
            function = (CFunction)this.persistenceService.find("from CFunction where  id = ?", new Object[]{Long.parseLong(this.journalBookReport.getFunctionId())});
            heading = heading + " and Financing Source :" + function.getName();
        }
        if (this.checkNullandEmpty(this.journalBookReport.getVoucher_name())) {
            heading = heading + " and Voucher Type Name :" + this.journalBookReport.getVoucher_name();
        }
        return heading;
    }

    private boolean checkNullandEmpty(String column) {
        return column != null && !column.isEmpty();
    }

    public String getHeading() {
        return this.heading;
    }

    public void setHeading(String heading) {
        this.heading = heading;
    }

    public GeneralLedgerBean getJournalBookReport() {
        return this.journalBookReport;
    }

    public void setJournalBookReport(GeneralLedgerBean journalBookReport) {
        this.journalBookReport = journalBookReport;
    }

    public List<GeneralLedgerBean> getJournalBookDisplayList() {
        return this.journalBookDisplayList;
    }

    public void setJournalBookDisplayList(List<GeneralLedgerBean> journalBookDisplayList) {
        this.journalBookDisplayList = journalBookDisplayList;
    }
}

